import { Command as $Command } from "@smithy/smithy-client";
import type { MetadataBearer as __MetadataBearer } from "@smithy/types";
import type { DeleteProjectRequest, DeleteProjectResponse } from "../models/models_0";
import type { RekognitionClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../RekognitionClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DeleteProjectCommand}.
 */
export interface DeleteProjectCommandInput extends DeleteProjectRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteProjectCommand}.
 */
export interface DeleteProjectCommandOutput extends DeleteProjectResponse, __MetadataBearer {
}
declare const DeleteProjectCommand_base: {
    new (input: DeleteProjectCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteProjectCommandInput, DeleteProjectCommandOutput, RekognitionClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DeleteProjectCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteProjectCommandInput, DeleteProjectCommandOutput, RekognitionClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes a Amazon Rekognition project. To delete a project you must first delete all models or
 *          adapters associated with the project. To delete a model or adapter, see <a>DeleteProjectVersion</a>.</p>
 *          <p>
 *             <code>DeleteProject</code> is an asynchronous operation. To check if the project is
 *          deleted, call <a>DescribeProjects</a>. The project is deleted when the project
 *          no longer appears in the response. Be aware that deleting a given project will also delete
 *          any <code>ProjectPolicies</code> associated with that project.</p>
 *          <p>This operation requires permissions to perform the
 *             <code>rekognition:DeleteProject</code> action. </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { RekognitionClient, DeleteProjectCommand } from "@aws-sdk/client-rekognition"; // ES Modules import
 * // const { RekognitionClient, DeleteProjectCommand } = require("@aws-sdk/client-rekognition"); // CommonJS import
 * // import type { RekognitionClientConfig } from "@aws-sdk/client-rekognition";
 * const config = {}; // type is RekognitionClientConfig
 * const client = new RekognitionClient(config);
 * const input = { // DeleteProjectRequest
 *   ProjectArn: "STRING_VALUE", // required
 * };
 * const command = new DeleteProjectCommand(input);
 * const response = await client.send(command);
 * // { // DeleteProjectResponse
 * //   Status: "CREATING" || "CREATED" || "DELETING",
 * // };
 *
 * ```
 *
 * @param DeleteProjectCommandInput - {@link DeleteProjectCommandInput}
 * @returns {@link DeleteProjectCommandOutput}
 * @see {@link DeleteProjectCommandInput} for command's `input` shape.
 * @see {@link DeleteProjectCommandOutput} for command's `response` shape.
 * @see {@link RekognitionClientResolvedConfig | config} for RekognitionClient's `config` shape.
 *
 * @throws {@link AccessDeniedException} (client fault)
 *  <p>You are not authorized to perform the action.</p>
 *
 * @throws {@link InternalServerError} (server fault)
 *  <p>Amazon Rekognition experienced a service issue. Try your call again.</p>
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>Input parameter violated a constraint. Validate your parameter before calling the API
 *       operation again.</p>
 *
 * @throws {@link ProvisionedThroughputExceededException} (client fault)
 *  <p>The number of requests exceeded your throughput limit. If you want to increase this
 *       limit, contact Amazon Rekognition.</p>
 *
 * @throws {@link ResourceInUseException} (client fault)
 *  <p>The specified resource is already being used.</p>
 *
 * @throws {@link ResourceNotFoundException} (client fault)
 *  <p>The resource specified in the request cannot be found.</p>
 *
 * @throws {@link ThrottlingException} (server fault)
 *  <p>Amazon Rekognition is temporarily unable to process the request. Try your call again.</p>
 *
 * @throws {@link RekognitionServiceException}
 * <p>Base exception class for all service exceptions from Rekognition service.</p>
 *
 *
 * @example To delete an Amazon Rekognition Custom Labels project
 * ```javascript
 * // Deletes an Amazon Rekognition Custom Labels projects.
 * const input = {
 *   ProjectArn: "arn:aws:rekognition:us-east-1:111122223333:project/my-project/1690405809285"
 * };
 * const command = new DeleteProjectCommand(input);
 * const response = await client.send(command);
 * /* response is
 * {
 *   Status: "DELETING"
 * }
 * *\/
 * ```
 *
 * @public
 */
export declare class DeleteProjectCommand extends DeleteProjectCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DeleteProjectRequest;
            output: DeleteProjectResponse;
        };
        sdk: {
            input: DeleteProjectCommandInput;
            output: DeleteProjectCommandOutput;
        };
    };
}
