/**
 * @public
 * @enum
 */
export declare const UnsuccessfulFaceAssociationReason: {
    readonly ASSOCIATED_TO_A_DIFFERENT_USER: "ASSOCIATED_TO_A_DIFFERENT_USER";
    readonly FACE_NOT_FOUND: "FACE_NOT_FOUND";
    readonly LOW_MATCH_CONFIDENCE: "LOW_MATCH_CONFIDENCE";
};
/**
 * @public
 */
export type UnsuccessfulFaceAssociationReason = (typeof UnsuccessfulFaceAssociationReason)[keyof typeof UnsuccessfulFaceAssociationReason];
/**
 * @public
 * @enum
 */
export declare const UserStatus: {
    readonly ACTIVE: "ACTIVE";
    readonly CREATED: "CREATED";
    readonly CREATING: "CREATING";
    readonly UPDATING: "UPDATING";
};
/**
 * @public
 */
export type UserStatus = (typeof UserStatus)[keyof typeof UserStatus];
/**
 * @public
 * @enum
 */
export declare const Attribute: {
    readonly AGE_RANGE: "AGE_RANGE";
    readonly ALL: "ALL";
    readonly BEARD: "BEARD";
    readonly DEFAULT: "DEFAULT";
    readonly EMOTIONS: "EMOTIONS";
    readonly EYEGLASSES: "EYEGLASSES";
    readonly EYES_OPEN: "EYES_OPEN";
    readonly EYE_DIRECTION: "EYE_DIRECTION";
    readonly FACE_OCCLUDED: "FACE_OCCLUDED";
    readonly GENDER: "GENDER";
    readonly MOUTH_OPEN: "MOUTH_OPEN";
    readonly MUSTACHE: "MUSTACHE";
    readonly SMILE: "SMILE";
    readonly SUNGLASSES: "SUNGLASSES";
};
/**
 * @public
 */
export type Attribute = (typeof Attribute)[keyof typeof Attribute];
/**
 * @public
 * @enum
 */
export declare const BodyPart: {
    readonly FACE: "FACE";
    readonly HEAD: "HEAD";
    readonly LEFT_HAND: "LEFT_HAND";
    readonly RIGHT_HAND: "RIGHT_HAND";
};
/**
 * @public
 */
export type BodyPart = (typeof BodyPart)[keyof typeof BodyPart];
/**
 * @public
 * @enum
 */
export declare const ProtectiveEquipmentType: {
    readonly FACE_COVER: "FACE_COVER";
    readonly HAND_COVER: "HAND_COVER";
    readonly HEAD_COVER: "HEAD_COVER";
};
/**
 * @public
 */
export type ProtectiveEquipmentType = (typeof ProtectiveEquipmentType)[keyof typeof ProtectiveEquipmentType];
/**
 * @public
 * @enum
 */
export declare const EmotionName: {
    readonly ANGRY: "ANGRY";
    readonly CALM: "CALM";
    readonly CONFUSED: "CONFUSED";
    readonly DISGUSTED: "DISGUSTED";
    readonly FEAR: "FEAR";
    readonly HAPPY: "HAPPY";
    readonly SAD: "SAD";
    readonly SURPRISED: "SURPRISED";
    readonly UNKNOWN: "UNKNOWN";
};
/**
 * @public
 */
export type EmotionName = (typeof EmotionName)[keyof typeof EmotionName];
/**
 * @public
 * @enum
 */
export declare const LandmarkType: {
    readonly chinBottom: "chinBottom";
    readonly eyeLeft: "eyeLeft";
    readonly eyeRight: "eyeRight";
    readonly leftEyeBrowLeft: "leftEyeBrowLeft";
    readonly leftEyeBrowRight: "leftEyeBrowRight";
    readonly leftEyeBrowUp: "leftEyeBrowUp";
    readonly leftEyeDown: "leftEyeDown";
    readonly leftEyeLeft: "leftEyeLeft";
    readonly leftEyeRight: "leftEyeRight";
    readonly leftEyeUp: "leftEyeUp";
    readonly leftPupil: "leftPupil";
    readonly midJawlineLeft: "midJawlineLeft";
    readonly midJawlineRight: "midJawlineRight";
    readonly mouthDown: "mouthDown";
    readonly mouthLeft: "mouthLeft";
    readonly mouthRight: "mouthRight";
    readonly mouthUp: "mouthUp";
    readonly nose: "nose";
    readonly noseLeft: "noseLeft";
    readonly noseRight: "noseRight";
    readonly rightEyeBrowLeft: "rightEyeBrowLeft";
    readonly rightEyeBrowRight: "rightEyeBrowRight";
    readonly rightEyeBrowUp: "rightEyeBrowUp";
    readonly rightEyeDown: "rightEyeDown";
    readonly rightEyeLeft: "rightEyeLeft";
    readonly rightEyeRight: "rightEyeRight";
    readonly rightEyeUp: "rightEyeUp";
    readonly rightPupil: "rightPupil";
    readonly upperJawlineLeft: "upperJawlineLeft";
    readonly upperJawlineRight: "upperJawlineRight";
};
/**
 * @public
 */
export type LandmarkType = (typeof LandmarkType)[keyof typeof LandmarkType];
/**
 * @public
 * @enum
 */
export declare const KnownGenderType: {
    readonly Female: "Female";
    readonly Male: "Male";
    readonly Nonbinary: "Nonbinary";
    readonly Unlisted: "Unlisted";
};
/**
 * @public
 */
export type KnownGenderType = (typeof KnownGenderType)[keyof typeof KnownGenderType];
/**
 * @public
 * @enum
 */
export declare const GenderType: {
    readonly Female: "Female";
    readonly Male: "Male";
};
/**
 * @public
 */
export type GenderType = (typeof GenderType)[keyof typeof GenderType];
/**
 * @public
 * @enum
 */
export declare const CelebrityRecognitionSortBy: {
    readonly ID: "ID";
    readonly TIMESTAMP: "TIMESTAMP";
};
/**
 * @public
 */
export type CelebrityRecognitionSortBy = (typeof CelebrityRecognitionSortBy)[keyof typeof CelebrityRecognitionSortBy];
/**
 * @public
 * @enum
 */
export declare const ChallengeType: {
    readonly FACE_MOVEMENT_AND_LIGHT_CHALLENGE: "FaceMovementAndLightChallenge";
    readonly FACE_MOVEMENT_CHALLENGE: "FaceMovementChallenge";
};
/**
 * @public
 */
export type ChallengeType = (typeof ChallengeType)[keyof typeof ChallengeType];
/**
 * @public
 * @enum
 */
export declare const QualityFilter: {
    readonly AUTO: "AUTO";
    readonly HIGH: "HIGH";
    readonly LOW: "LOW";
    readonly MEDIUM: "MEDIUM";
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type QualityFilter = (typeof QualityFilter)[keyof typeof QualityFilter];
/**
 * @public
 * @enum
 */
export declare const OrientationCorrection: {
    readonly ROTATE_0: "ROTATE_0";
    readonly ROTATE_180: "ROTATE_180";
    readonly ROTATE_270: "ROTATE_270";
    readonly ROTATE_90: "ROTATE_90";
};
/**
 * @public
 */
export type OrientationCorrection = (typeof OrientationCorrection)[keyof typeof OrientationCorrection];
/**
 * @public
 * @enum
 */
export declare const ContentClassifier: {
    readonly FREE_OF_ADULT_CONTENT: "FreeOfAdultContent";
    readonly FREE_OF_PERSONALLY_IDENTIFIABLE_INFORMATION: "FreeOfPersonallyIdentifiableInformation";
};
/**
 * @public
 */
export type ContentClassifier = (typeof ContentClassifier)[keyof typeof ContentClassifier];
/**
 * @public
 * @enum
 */
export declare const ContentModerationAggregateBy: {
    readonly SEGMENTS: "SEGMENTS";
    readonly TIMESTAMPS: "TIMESTAMPS";
};
/**
 * @public
 */
export type ContentModerationAggregateBy = (typeof ContentModerationAggregateBy)[keyof typeof ContentModerationAggregateBy];
/**
 * @public
 * @enum
 */
export declare const ContentModerationSortBy: {
    readonly NAME: "NAME";
    readonly TIMESTAMP: "TIMESTAMP";
};
/**
 * @public
 */
export type ContentModerationSortBy = (typeof ContentModerationSortBy)[keyof typeof ContentModerationSortBy];
/**
 * @public
 * @enum
 */
export declare const DatasetType: {
    readonly TEST: "TEST";
    readonly TRAIN: "TRAIN";
};
/**
 * @public
 */
export type DatasetType = (typeof DatasetType)[keyof typeof DatasetType];
/**
 * @public
 * @enum
 */
export declare const ProjectAutoUpdate: {
    readonly DISABLED: "DISABLED";
    readonly ENABLED: "ENABLED";
};
/**
 * @public
 */
export type ProjectAutoUpdate = (typeof ProjectAutoUpdate)[keyof typeof ProjectAutoUpdate];
/**
 * @public
 * @enum
 */
export declare const CustomizationFeature: {
    readonly CONTENT_MODERATION: "CONTENT_MODERATION";
    readonly CUSTOM_LABELS: "CUSTOM_LABELS";
};
/**
 * @public
 */
export type CustomizationFeature = (typeof CustomizationFeature)[keyof typeof CustomizationFeature];
/**
 * @public
 * @enum
 */
export declare const DatasetStatus: {
    readonly CREATE_COMPLETE: "CREATE_COMPLETE";
    readonly CREATE_FAILED: "CREATE_FAILED";
    readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
    readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
    readonly UPDATE_COMPLETE: "UPDATE_COMPLETE";
    readonly UPDATE_FAILED: "UPDATE_FAILED";
    readonly UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS";
};
/**
 * @public
 */
export type DatasetStatus = (typeof DatasetStatus)[keyof typeof DatasetStatus];
/**
 * @public
 * @enum
 */
export declare const DatasetStatusMessageCode: {
    readonly CLIENT_ERROR: "CLIENT_ERROR";
    readonly SERVICE_ERROR: "SERVICE_ERROR";
    readonly SUCCESS: "SUCCESS";
};
/**
 * @public
 */
export type DatasetStatusMessageCode = (typeof DatasetStatusMessageCode)[keyof typeof DatasetStatusMessageCode];
/**
 * @public
 * @enum
 */
export declare const UnsuccessfulFaceDeletionReason: {
    readonly ASSOCIATED_TO_AN_EXISTING_USER: "ASSOCIATED_TO_AN_EXISTING_USER";
    readonly FACE_NOT_FOUND: "FACE_NOT_FOUND";
};
/**
 * @public
 */
export type UnsuccessfulFaceDeletionReason = (typeof UnsuccessfulFaceDeletionReason)[keyof typeof UnsuccessfulFaceDeletionReason];
/**
 * @public
 * @enum
 */
export declare const ProjectStatus: {
    readonly CREATED: "CREATED";
    readonly CREATING: "CREATING";
    readonly DELETING: "DELETING";
};
/**
 * @public
 */
export type ProjectStatus = (typeof ProjectStatus)[keyof typeof ProjectStatus];
/**
 * @public
 * @enum
 */
export declare const ProjectVersionStatus: {
    readonly COPYING_COMPLETED: "COPYING_COMPLETED";
    readonly COPYING_FAILED: "COPYING_FAILED";
    readonly COPYING_IN_PROGRESS: "COPYING_IN_PROGRESS";
    readonly DELETING: "DELETING";
    readonly DEPRECATED: "DEPRECATED";
    readonly EXPIRED: "EXPIRED";
    readonly FAILED: "FAILED";
    readonly RUNNING: "RUNNING";
    readonly STARTING: "STARTING";
    readonly STOPPED: "STOPPED";
    readonly STOPPING: "STOPPING";
    readonly TRAINING_COMPLETED: "TRAINING_COMPLETED";
    readonly TRAINING_FAILED: "TRAINING_FAILED";
    readonly TRAINING_IN_PROGRESS: "TRAINING_IN_PROGRESS";
};
/**
 * @public
 */
export type ProjectVersionStatus = (typeof ProjectVersionStatus)[keyof typeof ProjectVersionStatus];
/**
 * @public
 * @enum
 */
export declare const StreamProcessorStatus: {
    readonly FAILED: "FAILED";
    readonly RUNNING: "RUNNING";
    readonly STARTING: "STARTING";
    readonly STOPPED: "STOPPED";
    readonly STOPPING: "STOPPING";
    readonly UPDATING: "UPDATING";
};
/**
 * @public
 */
export type StreamProcessorStatus = (typeof StreamProcessorStatus)[keyof typeof StreamProcessorStatus];
/**
 * @public
 * @enum
 */
export declare const DetectLabelsFeatureName: {
    readonly GENERAL_LABELS: "GENERAL_LABELS";
    readonly IMAGE_PROPERTIES: "IMAGE_PROPERTIES";
};
/**
 * @public
 */
export type DetectLabelsFeatureName = (typeof DetectLabelsFeatureName)[keyof typeof DetectLabelsFeatureName];
/**
 * @public
 * @enum
 */
export declare const TextTypes: {
    readonly LINE: "LINE";
    readonly WORD: "WORD";
};
/**
 * @public
 */
export type TextTypes = (typeof TextTypes)[keyof typeof TextTypes];
/**
 * @public
 * @enum
 */
export declare const UnsuccessfulFaceDisassociationReason: {
    readonly ASSOCIATED_TO_A_DIFFERENT_USER: "ASSOCIATED_TO_A_DIFFERENT_USER";
    readonly FACE_NOT_FOUND: "FACE_NOT_FOUND";
};
/**
 * @public
 */
export type UnsuccessfulFaceDisassociationReason = (typeof UnsuccessfulFaceDisassociationReason)[keyof typeof UnsuccessfulFaceDisassociationReason];
/**
 * @public
 * @enum
 */
export declare const FaceAttributes: {
    readonly ALL: "ALL";
    readonly DEFAULT: "DEFAULT";
};
/**
 * @public
 */
export type FaceAttributes = (typeof FaceAttributes)[keyof typeof FaceAttributes];
/**
 * @public
 * @enum
 */
export declare const FaceSearchSortBy: {
    readonly INDEX: "INDEX";
    readonly TIMESTAMP: "TIMESTAMP";
};
/**
 * @public
 */
export type FaceSearchSortBy = (typeof FaceSearchSortBy)[keyof typeof FaceSearchSortBy];
/**
 * @public
 * @enum
 */
export declare const VideoJobStatus: {
    readonly FAILED: "FAILED";
    readonly IN_PROGRESS: "IN_PROGRESS";
    readonly SUCCEEDED: "SUCCEEDED";
};
/**
 * @public
 */
export type VideoJobStatus = (typeof VideoJobStatus)[keyof typeof VideoJobStatus];
/**
 * @public
 * @enum
 */
export declare const VideoColorRange: {
    readonly FULL: "FULL";
    readonly LIMITED: "LIMITED";
};
/**
 * @public
 */
export type VideoColorRange = (typeof VideoColorRange)[keyof typeof VideoColorRange];
/**
 * @public
 * @enum
 */
export declare const LivenessSessionStatus: {
    readonly CREATED: "CREATED";
    readonly EXPIRED: "EXPIRED";
    readonly FAILED: "FAILED";
    readonly IN_PROGRESS: "IN_PROGRESS";
    readonly SUCCEEDED: "SUCCEEDED";
};
/**
 * @public
 */
export type LivenessSessionStatus = (typeof LivenessSessionStatus)[keyof typeof LivenessSessionStatus];
/**
 * @public
 * @enum
 */
export declare const LabelDetectionAggregateBy: {
    readonly SEGMENTS: "SEGMENTS";
    readonly TIMESTAMPS: "TIMESTAMPS";
};
/**
 * @public
 */
export type LabelDetectionAggregateBy = (typeof LabelDetectionAggregateBy)[keyof typeof LabelDetectionAggregateBy];
/**
 * @public
 * @enum
 */
export declare const LabelDetectionSortBy: {
    readonly NAME: "NAME";
    readonly TIMESTAMP: "TIMESTAMP";
};
/**
 * @public
 */
export type LabelDetectionSortBy = (typeof LabelDetectionSortBy)[keyof typeof LabelDetectionSortBy];
/**
 * @public
 * @enum
 */
export declare const MediaAnalysisJobFailureCode: {
    readonly ACCESS_DENIED: "ACCESS_DENIED";
    readonly INTERNAL_ERROR: "INTERNAL_ERROR";
    readonly INVALID_KMS_KEY: "INVALID_KMS_KEY";
    readonly INVALID_MANIFEST: "INVALID_MANIFEST";
    readonly INVALID_OUTPUT_CONFIG: "INVALID_OUTPUT_CONFIG";
    readonly INVALID_S3_OBJECT: "INVALID_S3_OBJECT";
    readonly RESOURCE_NOT_FOUND: "RESOURCE_NOT_FOUND";
    readonly RESOURCE_NOT_READY: "RESOURCE_NOT_READY";
    readonly THROTTLED: "THROTTLED";
};
/**
 * @public
 */
export type MediaAnalysisJobFailureCode = (typeof MediaAnalysisJobFailureCode)[keyof typeof MediaAnalysisJobFailureCode];
/**
 * @public
 * @enum
 */
export declare const MediaAnalysisJobStatus: {
    readonly CREATED: "CREATED";
    readonly FAILED: "FAILED";
    readonly IN_PROGRESS: "IN_PROGRESS";
    readonly QUEUED: "QUEUED";
    readonly SUCCEEDED: "SUCCEEDED";
};
/**
 * @public
 */
export type MediaAnalysisJobStatus = (typeof MediaAnalysisJobStatus)[keyof typeof MediaAnalysisJobStatus];
/**
 * @public
 * @enum
 */
export declare const PersonTrackingSortBy: {
    readonly INDEX: "INDEX";
    readonly TIMESTAMP: "TIMESTAMP";
};
/**
 * @public
 */
export type PersonTrackingSortBy = (typeof PersonTrackingSortBy)[keyof typeof PersonTrackingSortBy];
/**
 * @public
 * @enum
 */
export declare const TechnicalCueType: {
    readonly BLACK_FRAMES: "BlackFrames";
    readonly COLOR_BARS: "ColorBars";
    readonly CONTENT: "Content";
    readonly END_CREDITS: "EndCredits";
    readonly OPENING_CREDITS: "OpeningCredits";
    readonly SLATE: "Slate";
    readonly STUDIO_LOGO: "StudioLogo";
};
/**
 * @public
 */
export type TechnicalCueType = (typeof TechnicalCueType)[keyof typeof TechnicalCueType];
/**
 * @public
 * @enum
 */
export declare const SegmentType: {
    readonly SHOT: "SHOT";
    readonly TECHNICAL_CUE: "TECHNICAL_CUE";
};
/**
 * @public
 */
export type SegmentType = (typeof SegmentType)[keyof typeof SegmentType];
/**
 * @public
 * @enum
 */
export declare const Reason: {
    readonly EXCEEDS_MAX_FACES: "EXCEEDS_MAX_FACES";
    readonly EXTREME_POSE: "EXTREME_POSE";
    readonly LOW_BRIGHTNESS: "LOW_BRIGHTNESS";
    readonly LOW_CONFIDENCE: "LOW_CONFIDENCE";
    readonly LOW_FACE_QUALITY: "LOW_FACE_QUALITY";
    readonly LOW_SHARPNESS: "LOW_SHARPNESS";
    readonly SMALL_BOUNDING_BOX: "SMALL_BOUNDING_BOX";
};
/**
 * @public
 */
export type Reason = (typeof Reason)[keyof typeof Reason];
/**
 * @public
 * @enum
 */
export declare const LabelDetectionFeatureName: {
    readonly GENERAL_LABELS: "GENERAL_LABELS";
};
/**
 * @public
 */
export type LabelDetectionFeatureName = (typeof LabelDetectionFeatureName)[keyof typeof LabelDetectionFeatureName];
/**
 * @public
 * @enum
 */
export declare const UnsearchedFaceReason: {
    readonly EXCEEDS_MAX_FACES: "EXCEEDS_MAX_FACES";
    readonly EXTREME_POSE: "EXTREME_POSE";
    readonly FACE_NOT_LARGEST: "FACE_NOT_LARGEST";
    readonly LOW_BRIGHTNESS: "LOW_BRIGHTNESS";
    readonly LOW_CONFIDENCE: "LOW_CONFIDENCE";
    readonly LOW_FACE_QUALITY: "LOW_FACE_QUALITY";
    readonly LOW_SHARPNESS: "LOW_SHARPNESS";
    readonly SMALL_BOUNDING_BOX: "SMALL_BOUNDING_BOX";
};
/**
 * @public
 */
export type UnsearchedFaceReason = (typeof UnsearchedFaceReason)[keyof typeof UnsearchedFaceReason];
/**
 * @public
 * @enum
 */
export declare const StreamProcessorParameterToDelete: {
    readonly ConnectedHomeMinConfidence: "ConnectedHomeMinConfidence";
    readonly RegionsOfInterest: "RegionsOfInterest";
};
/**
 * @public
 */
export type StreamProcessorParameterToDelete = (typeof StreamProcessorParameterToDelete)[keyof typeof StreamProcessorParameterToDelete];
