import type { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { RekognitionServiceException as __BaseException } from "./RekognitionServiceException";
/**
 * <p>You are not authorized to perform the action.</p>
 * @public
 */
export declare class AccessDeniedException extends __BaseException {
    readonly name: "AccessDeniedException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<AccessDeniedException, __BaseException>);
}
/**
 * <p> A User with the same Id already exists within the collection, or the update or deletion
 *       of the User caused an inconsistent state. ** </p>
 * @public
 */
export declare class ConflictException extends __BaseException {
    readonly name: "ConflictException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
/**
 * <p>A <code>ClientRequestToken</code> input parameter was reused with an operation, but at least one of the other input
 *         parameters is different from the previous call to the operation.</p>
 * @public
 */
export declare class IdempotentParameterMismatchException extends __BaseException {
    readonly name: "IdempotentParameterMismatchException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<IdempotentParameterMismatchException, __BaseException>);
}
/**
 * <p>Amazon Rekognition experienced a service issue. Try your call again.</p>
 * @public
 */
export declare class InternalServerError extends __BaseException {
    readonly name: "InternalServerError";
    readonly $fault: "server";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InternalServerError, __BaseException>);
}
/**
 * <p>Input parameter violated a constraint. Validate your parameter before calling the API
 *       operation again.</p>
 * @public
 */
export declare class InvalidParameterException extends __BaseException {
    readonly name: "InvalidParameterException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidParameterException, __BaseException>);
}
/**
 * <p>The number of requests exceeded your throughput limit. If you want to increase this
 *       limit, contact Amazon Rekognition.</p>
 * @public
 */
export declare class ProvisionedThroughputExceededException extends __BaseException {
    readonly name: "ProvisionedThroughputExceededException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ProvisionedThroughputExceededException, __BaseException>);
}
/**
 * <p>The resource specified in the request cannot be found.</p>
 * @public
 */
export declare class ResourceNotFoundException extends __BaseException {
    readonly name: "ResourceNotFoundException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>);
}
/**
 * <p></p>
 *          <p>The size of the collection exceeds the allowed limit. For more information,
 *       see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide. </p>
 * @public
 */
export declare class ServiceQuotaExceededException extends __BaseException {
    readonly name: "ServiceQuotaExceededException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ServiceQuotaExceededException, __BaseException>);
}
/**
 * <p>Amazon Rekognition is temporarily unable to process the request. Try your call again.</p>
 * @public
 */
export declare class ThrottlingException extends __BaseException {
    readonly name: "ThrottlingException";
    readonly $fault: "server";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ThrottlingException, __BaseException>);
}
/**
 * <p>The input image size exceeds the allowed limit. If you are calling
 *       DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more
 *       information, see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.
 *     </p>
 * @public
 */
export declare class ImageTooLargeException extends __BaseException {
    readonly name: "ImageTooLargeException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ImageTooLargeException, __BaseException>);
}
/**
 * <p>The provided image format is not supported. </p>
 * @public
 */
export declare class InvalidImageFormatException extends __BaseException {
    readonly name: "InvalidImageFormatException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidImageFormatException, __BaseException>);
}
/**
 * <p>Amazon Rekognition is unable to access the S3 object specified in the request.</p>
 * @public
 */
export declare class InvalidS3ObjectException extends __BaseException {
    readonly name: "InvalidS3ObjectException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidS3ObjectException, __BaseException>);
}
/**
 * <p>An Amazon Rekognition service limit was exceeded. For example, if you start too many jobs
 *             concurrently, subsequent calls to start operations (ex:
 *             <code>StartLabelDetection</code>) will raise a <code>LimitExceededException</code>
 *             exception (HTTP status code: 400) until the number of concurrently running jobs is below
 *             the Amazon Rekognition service limit. </p>
 * @public
 */
export declare class LimitExceededException extends __BaseException {
    readonly name: "LimitExceededException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<LimitExceededException, __BaseException>);
}
/**
 * <p>The specified resource is already being used.</p>
 * @public
 */
export declare class ResourceInUseException extends __BaseException {
    readonly name: "ResourceInUseException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceInUseException, __BaseException>);
}
/**
 * <p>A resource with the specified ID already exists.</p>
 * @public
 */
export declare class ResourceAlreadyExistsException extends __BaseException {
    readonly name: "ResourceAlreadyExistsException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceAlreadyExistsException, __BaseException>);
}
/**
 * <p>The supplied revision id for the project policy is invalid.</p>
 * @public
 */
export declare class InvalidPolicyRevisionIdException extends __BaseException {
    readonly name: "InvalidPolicyRevisionIdException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidPolicyRevisionIdException, __BaseException>);
}
/**
 * <p>Pagination token in the request is not valid.</p>
 * @public
 */
export declare class InvalidPaginationTokenException extends __BaseException {
    readonly name: "InvalidPaginationTokenException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidPaginationTokenException, __BaseException>);
}
/**
 * <p>The requested resource isn't ready. For example,
 *          this exception occurs when you call <code>DetectCustomLabels</code> with a
 *          model version that isn't deployed. </p>
 * @public
 */
export declare class ResourceNotReadyException extends __BaseException {
    readonly name: "ResourceNotReadyException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceNotReadyException, __BaseException>);
}
/**
 * <p>The number of in-progress human reviews you have has exceeded the number allowed.</p>
 * @public
 */
export declare class HumanLoopQuotaExceededException extends __BaseException {
    readonly name: "HumanLoopQuotaExceededException";
    readonly $fault: "client";
    /**
     * <p>The resource type.</p>
     * @public
     */
    ResourceType?: string | undefined;
    /**
     * <p>The quota code.</p>
     * @public
     */
    QuotaCode?: string | undefined;
    /**
     * <p>The service code.</p>
     * @public
     */
    ServiceCode?: string | undefined;
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<HumanLoopQuotaExceededException, __BaseException>);
}
/**
 * <p>Occurs when a given sessionId is not found.</p>
 * @public
 */
export declare class SessionNotFoundException extends __BaseException {
    readonly name: "SessionNotFoundException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<SessionNotFoundException, __BaseException>);
}
/**
 * <p>Indicates that a provided manifest file is empty or larger than the allowed limit.</p>
 * @public
 */
export declare class InvalidManifestException extends __BaseException {
    readonly name: "InvalidManifestException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidManifestException, __BaseException>);
}
/**
 * <p>The format of the project policy document that you supplied to
 *       <code>PutProjectPolicy</code> is incorrect. </p>
 * @public
 */
export declare class MalformedPolicyDocumentException extends __BaseException {
    readonly name: "MalformedPolicyDocumentException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<MalformedPolicyDocumentException, __BaseException>);
}
/**
 * <p>The file size or duration of the supplied media is too large. The maximum file size is 10GB.
 *         The maximum duration is 6 hours. </p>
 * @public
 */
export declare class VideoTooLargeException extends __BaseException {
    readonly name: "VideoTooLargeException";
    readonly $fault: "client";
    Message?: string | undefined;
    Code?: string | undefined;
    /**
     * <p>A universally unique identifier (UUID) for the request.</p>
     * @public
     */
    Logref?: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<VideoTooLargeException, __BaseException>);
}
