import { HttpHandlerOptions as __HttpHandlerOptions } from "@smithy/types";
import {
  AssociateFacesCommandInput,
  AssociateFacesCommandOutput,
} from "./commands/AssociateFacesCommand";
import {
  CompareFacesCommandInput,
  CompareFacesCommandOutput,
} from "./commands/CompareFacesCommand";
import {
  CopyProjectVersionCommandInput,
  CopyProjectVersionCommandOutput,
} from "./commands/CopyProjectVersionCommand";
import {
  CreateCollectionCommandInput,
  CreateCollectionCommandOutput,
} from "./commands/CreateCollectionCommand";
import {
  CreateDatasetCommandInput,
  CreateDatasetCommandOutput,
} from "./commands/CreateDatasetCommand";
import {
  CreateFaceLivenessSessionCommandInput,
  CreateFaceLivenessSessionCommandOutput,
} from "./commands/CreateFaceLivenessSessionCommand";
import {
  CreateProjectCommandInput,
  CreateProjectCommandOutput,
} from "./commands/CreateProjectCommand";
import {
  CreateProjectVersionCommandInput,
  CreateProjectVersionCommandOutput,
} from "./commands/CreateProjectVersionCommand";
import {
  CreateStreamProcessorCommandInput,
  CreateStreamProcessorCommandOutput,
} from "./commands/CreateStreamProcessorCommand";
import {
  CreateUserCommandInput,
  CreateUserCommandOutput,
} from "./commands/CreateUserCommand";
import {
  DeleteCollectionCommandInput,
  DeleteCollectionCommandOutput,
} from "./commands/DeleteCollectionCommand";
import {
  DeleteDatasetCommandInput,
  DeleteDatasetCommandOutput,
} from "./commands/DeleteDatasetCommand";
import {
  DeleteFacesCommandInput,
  DeleteFacesCommandOutput,
} from "./commands/DeleteFacesCommand";
import {
  DeleteProjectCommandInput,
  DeleteProjectCommandOutput,
} from "./commands/DeleteProjectCommand";
import {
  DeleteProjectPolicyCommandInput,
  DeleteProjectPolicyCommandOutput,
} from "./commands/DeleteProjectPolicyCommand";
import {
  DeleteProjectVersionCommandInput,
  DeleteProjectVersionCommandOutput,
} from "./commands/DeleteProjectVersionCommand";
import {
  DeleteStreamProcessorCommandInput,
  DeleteStreamProcessorCommandOutput,
} from "./commands/DeleteStreamProcessorCommand";
import {
  DeleteUserCommandInput,
  DeleteUserCommandOutput,
} from "./commands/DeleteUserCommand";
import {
  DescribeCollectionCommandInput,
  DescribeCollectionCommandOutput,
} from "./commands/DescribeCollectionCommand";
import {
  DescribeDatasetCommandInput,
  DescribeDatasetCommandOutput,
} from "./commands/DescribeDatasetCommand";
import {
  DescribeProjectsCommandInput,
  DescribeProjectsCommandOutput,
} from "./commands/DescribeProjectsCommand";
import {
  DescribeProjectVersionsCommandInput,
  DescribeProjectVersionsCommandOutput,
} from "./commands/DescribeProjectVersionsCommand";
import {
  DescribeStreamProcessorCommandInput,
  DescribeStreamProcessorCommandOutput,
} from "./commands/DescribeStreamProcessorCommand";
import {
  DetectCustomLabelsCommandInput,
  DetectCustomLabelsCommandOutput,
} from "./commands/DetectCustomLabelsCommand";
import {
  DetectFacesCommandInput,
  DetectFacesCommandOutput,
} from "./commands/DetectFacesCommand";
import {
  DetectLabelsCommandInput,
  DetectLabelsCommandOutput,
} from "./commands/DetectLabelsCommand";
import {
  DetectModerationLabelsCommandInput,
  DetectModerationLabelsCommandOutput,
} from "./commands/DetectModerationLabelsCommand";
import {
  DetectProtectiveEquipmentCommandInput,
  DetectProtectiveEquipmentCommandOutput,
} from "./commands/DetectProtectiveEquipmentCommand";
import {
  DetectTextCommandInput,
  DetectTextCommandOutput,
} from "./commands/DetectTextCommand";
import {
  DisassociateFacesCommandInput,
  DisassociateFacesCommandOutput,
} from "./commands/DisassociateFacesCommand";
import {
  DistributeDatasetEntriesCommandInput,
  DistributeDatasetEntriesCommandOutput,
} from "./commands/DistributeDatasetEntriesCommand";
import {
  GetCelebrityInfoCommandInput,
  GetCelebrityInfoCommandOutput,
} from "./commands/GetCelebrityInfoCommand";
import {
  GetCelebrityRecognitionCommandInput,
  GetCelebrityRecognitionCommandOutput,
} from "./commands/GetCelebrityRecognitionCommand";
import {
  GetContentModerationCommandInput,
  GetContentModerationCommandOutput,
} from "./commands/GetContentModerationCommand";
import {
  GetFaceDetectionCommandInput,
  GetFaceDetectionCommandOutput,
} from "./commands/GetFaceDetectionCommand";
import {
  GetFaceLivenessSessionResultsCommandInput,
  GetFaceLivenessSessionResultsCommandOutput,
} from "./commands/GetFaceLivenessSessionResultsCommand";
import {
  GetFaceSearchCommandInput,
  GetFaceSearchCommandOutput,
} from "./commands/GetFaceSearchCommand";
import {
  GetLabelDetectionCommandInput,
  GetLabelDetectionCommandOutput,
} from "./commands/GetLabelDetectionCommand";
import {
  GetMediaAnalysisJobCommandInput,
  GetMediaAnalysisJobCommandOutput,
} from "./commands/GetMediaAnalysisJobCommand";
import {
  GetPersonTrackingCommandInput,
  GetPersonTrackingCommandOutput,
} from "./commands/GetPersonTrackingCommand";
import {
  GetSegmentDetectionCommandInput,
  GetSegmentDetectionCommandOutput,
} from "./commands/GetSegmentDetectionCommand";
import {
  GetTextDetectionCommandInput,
  GetTextDetectionCommandOutput,
} from "./commands/GetTextDetectionCommand";
import {
  IndexFacesCommandInput,
  IndexFacesCommandOutput,
} from "./commands/IndexFacesCommand";
import {
  ListCollectionsCommandInput,
  ListCollectionsCommandOutput,
} from "./commands/ListCollectionsCommand";
import {
  ListDatasetEntriesCommandInput,
  ListDatasetEntriesCommandOutput,
} from "./commands/ListDatasetEntriesCommand";
import {
  ListDatasetLabelsCommandInput,
  ListDatasetLabelsCommandOutput,
} from "./commands/ListDatasetLabelsCommand";
import {
  ListFacesCommandInput,
  ListFacesCommandOutput,
} from "./commands/ListFacesCommand";
import {
  ListMediaAnalysisJobsCommandInput,
  ListMediaAnalysisJobsCommandOutput,
} from "./commands/ListMediaAnalysisJobsCommand";
import {
  ListProjectPoliciesCommandInput,
  ListProjectPoliciesCommandOutput,
} from "./commands/ListProjectPoliciesCommand";
import {
  ListStreamProcessorsCommandInput,
  ListStreamProcessorsCommandOutput,
} from "./commands/ListStreamProcessorsCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  ListUsersCommandInput,
  ListUsersCommandOutput,
} from "./commands/ListUsersCommand";
import {
  PutProjectPolicyCommandInput,
  PutProjectPolicyCommandOutput,
} from "./commands/PutProjectPolicyCommand";
import {
  RecognizeCelebritiesCommandInput,
  RecognizeCelebritiesCommandOutput,
} from "./commands/RecognizeCelebritiesCommand";
import {
  SearchFacesByImageCommandInput,
  SearchFacesByImageCommandOutput,
} from "./commands/SearchFacesByImageCommand";
import {
  SearchFacesCommandInput,
  SearchFacesCommandOutput,
} from "./commands/SearchFacesCommand";
import {
  SearchUsersByImageCommandInput,
  SearchUsersByImageCommandOutput,
} from "./commands/SearchUsersByImageCommand";
import {
  SearchUsersCommandInput,
  SearchUsersCommandOutput,
} from "./commands/SearchUsersCommand";
import {
  StartCelebrityRecognitionCommandInput,
  StartCelebrityRecognitionCommandOutput,
} from "./commands/StartCelebrityRecognitionCommand";
import {
  StartContentModerationCommandInput,
  StartContentModerationCommandOutput,
} from "./commands/StartContentModerationCommand";
import {
  StartFaceDetectionCommandInput,
  StartFaceDetectionCommandOutput,
} from "./commands/StartFaceDetectionCommand";
import {
  StartFaceSearchCommandInput,
  StartFaceSearchCommandOutput,
} from "./commands/StartFaceSearchCommand";
import {
  StartLabelDetectionCommandInput,
  StartLabelDetectionCommandOutput,
} from "./commands/StartLabelDetectionCommand";
import {
  StartMediaAnalysisJobCommandInput,
  StartMediaAnalysisJobCommandOutput,
} from "./commands/StartMediaAnalysisJobCommand";
import {
  StartPersonTrackingCommandInput,
  StartPersonTrackingCommandOutput,
} from "./commands/StartPersonTrackingCommand";
import {
  StartProjectVersionCommandInput,
  StartProjectVersionCommandOutput,
} from "./commands/StartProjectVersionCommand";
import {
  StartSegmentDetectionCommandInput,
  StartSegmentDetectionCommandOutput,
} from "./commands/StartSegmentDetectionCommand";
import {
  StartStreamProcessorCommandInput,
  StartStreamProcessorCommandOutput,
} from "./commands/StartStreamProcessorCommand";
import {
  StartTextDetectionCommandInput,
  StartTextDetectionCommandOutput,
} from "./commands/StartTextDetectionCommand";
import {
  StopProjectVersionCommandInput,
  StopProjectVersionCommandOutput,
} from "./commands/StopProjectVersionCommand";
import {
  StopStreamProcessorCommandInput,
  StopStreamProcessorCommandOutput,
} from "./commands/StopStreamProcessorCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdateDatasetEntriesCommandInput,
  UpdateDatasetEntriesCommandOutput,
} from "./commands/UpdateDatasetEntriesCommand";
import {
  UpdateStreamProcessorCommandInput,
  UpdateStreamProcessorCommandOutput,
} from "./commands/UpdateStreamProcessorCommand";
import { RekognitionClient } from "./RekognitionClient";
export interface Rekognition {
  associateFaces(
    args: AssociateFacesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AssociateFacesCommandOutput>;
  associateFaces(
    args: AssociateFacesCommandInput,
    cb: (err: any, data?: AssociateFacesCommandOutput) => void
  ): void;
  associateFaces(
    args: AssociateFacesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AssociateFacesCommandOutput) => void
  ): void;
  compareFaces(
    args: CompareFacesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CompareFacesCommandOutput>;
  compareFaces(
    args: CompareFacesCommandInput,
    cb: (err: any, data?: CompareFacesCommandOutput) => void
  ): void;
  compareFaces(
    args: CompareFacesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CompareFacesCommandOutput) => void
  ): void;
  copyProjectVersion(
    args: CopyProjectVersionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CopyProjectVersionCommandOutput>;
  copyProjectVersion(
    args: CopyProjectVersionCommandInput,
    cb: (err: any, data?: CopyProjectVersionCommandOutput) => void
  ): void;
  copyProjectVersion(
    args: CopyProjectVersionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CopyProjectVersionCommandOutput) => void
  ): void;
  createCollection(
    args: CreateCollectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateCollectionCommandOutput>;
  createCollection(
    args: CreateCollectionCommandInput,
    cb: (err: any, data?: CreateCollectionCommandOutput) => void
  ): void;
  createCollection(
    args: CreateCollectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateCollectionCommandOutput) => void
  ): void;
  createDataset(
    args: CreateDatasetCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDatasetCommandOutput>;
  createDataset(
    args: CreateDatasetCommandInput,
    cb: (err: any, data?: CreateDatasetCommandOutput) => void
  ): void;
  createDataset(
    args: CreateDatasetCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDatasetCommandOutput) => void
  ): void;
  createFaceLivenessSession(): Promise<CreateFaceLivenessSessionCommandOutput>;
  createFaceLivenessSession(
    args: CreateFaceLivenessSessionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateFaceLivenessSessionCommandOutput>;
  createFaceLivenessSession(
    args: CreateFaceLivenessSessionCommandInput,
    cb: (err: any, data?: CreateFaceLivenessSessionCommandOutput) => void
  ): void;
  createFaceLivenessSession(
    args: CreateFaceLivenessSessionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateFaceLivenessSessionCommandOutput) => void
  ): void;
  createProject(
    args: CreateProjectCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateProjectCommandOutput>;
  createProject(
    args: CreateProjectCommandInput,
    cb: (err: any, data?: CreateProjectCommandOutput) => void
  ): void;
  createProject(
    args: CreateProjectCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateProjectCommandOutput) => void
  ): void;
  createProjectVersion(
    args: CreateProjectVersionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateProjectVersionCommandOutput>;
  createProjectVersion(
    args: CreateProjectVersionCommandInput,
    cb: (err: any, data?: CreateProjectVersionCommandOutput) => void
  ): void;
  createProjectVersion(
    args: CreateProjectVersionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateProjectVersionCommandOutput) => void
  ): void;
  createStreamProcessor(
    args: CreateStreamProcessorCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateStreamProcessorCommandOutput>;
  createStreamProcessor(
    args: CreateStreamProcessorCommandInput,
    cb: (err: any, data?: CreateStreamProcessorCommandOutput) => void
  ): void;
  createStreamProcessor(
    args: CreateStreamProcessorCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateStreamProcessorCommandOutput) => void
  ): void;
  createUser(
    args: CreateUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateUserCommandOutput>;
  createUser(
    args: CreateUserCommandInput,
    cb: (err: any, data?: CreateUserCommandOutput) => void
  ): void;
  createUser(
    args: CreateUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateUserCommandOutput) => void
  ): void;
  deleteCollection(
    args: DeleteCollectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteCollectionCommandOutput>;
  deleteCollection(
    args: DeleteCollectionCommandInput,
    cb: (err: any, data?: DeleteCollectionCommandOutput) => void
  ): void;
  deleteCollection(
    args: DeleteCollectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteCollectionCommandOutput) => void
  ): void;
  deleteDataset(
    args: DeleteDatasetCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDatasetCommandOutput>;
  deleteDataset(
    args: DeleteDatasetCommandInput,
    cb: (err: any, data?: DeleteDatasetCommandOutput) => void
  ): void;
  deleteDataset(
    args: DeleteDatasetCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDatasetCommandOutput) => void
  ): void;
  deleteFaces(
    args: DeleteFacesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteFacesCommandOutput>;
  deleteFaces(
    args: DeleteFacesCommandInput,
    cb: (err: any, data?: DeleteFacesCommandOutput) => void
  ): void;
  deleteFaces(
    args: DeleteFacesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteFacesCommandOutput) => void
  ): void;
  deleteProject(
    args: DeleteProjectCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteProjectCommandOutput>;
  deleteProject(
    args: DeleteProjectCommandInput,
    cb: (err: any, data?: DeleteProjectCommandOutput) => void
  ): void;
  deleteProject(
    args: DeleteProjectCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteProjectCommandOutput) => void
  ): void;
  deleteProjectPolicy(
    args: DeleteProjectPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteProjectPolicyCommandOutput>;
  deleteProjectPolicy(
    args: DeleteProjectPolicyCommandInput,
    cb: (err: any, data?: DeleteProjectPolicyCommandOutput) => void
  ): void;
  deleteProjectPolicy(
    args: DeleteProjectPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteProjectPolicyCommandOutput) => void
  ): void;
  deleteProjectVersion(
    args: DeleteProjectVersionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteProjectVersionCommandOutput>;
  deleteProjectVersion(
    args: DeleteProjectVersionCommandInput,
    cb: (err: any, data?: DeleteProjectVersionCommandOutput) => void
  ): void;
  deleteProjectVersion(
    args: DeleteProjectVersionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteProjectVersionCommandOutput) => void
  ): void;
  deleteStreamProcessor(
    args: DeleteStreamProcessorCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteStreamProcessorCommandOutput>;
  deleteStreamProcessor(
    args: DeleteStreamProcessorCommandInput,
    cb: (err: any, data?: DeleteStreamProcessorCommandOutput) => void
  ): void;
  deleteStreamProcessor(
    args: DeleteStreamProcessorCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteStreamProcessorCommandOutput) => void
  ): void;
  deleteUser(
    args: DeleteUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteUserCommandOutput>;
  deleteUser(
    args: DeleteUserCommandInput,
    cb: (err: any, data?: DeleteUserCommandOutput) => void
  ): void;
  deleteUser(
    args: DeleteUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteUserCommandOutput) => void
  ): void;
  describeCollection(
    args: DescribeCollectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeCollectionCommandOutput>;
  describeCollection(
    args: DescribeCollectionCommandInput,
    cb: (err: any, data?: DescribeCollectionCommandOutput) => void
  ): void;
  describeCollection(
    args: DescribeCollectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeCollectionCommandOutput) => void
  ): void;
  describeDataset(
    args: DescribeDatasetCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDatasetCommandOutput>;
  describeDataset(
    args: DescribeDatasetCommandInput,
    cb: (err: any, data?: DescribeDatasetCommandOutput) => void
  ): void;
  describeDataset(
    args: DescribeDatasetCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDatasetCommandOutput) => void
  ): void;
  describeProjects(): Promise<DescribeProjectsCommandOutput>;
  describeProjects(
    args: DescribeProjectsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeProjectsCommandOutput>;
  describeProjects(
    args: DescribeProjectsCommandInput,
    cb: (err: any, data?: DescribeProjectsCommandOutput) => void
  ): void;
  describeProjects(
    args: DescribeProjectsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeProjectsCommandOutput) => void
  ): void;
  describeProjectVersions(
    args: DescribeProjectVersionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeProjectVersionsCommandOutput>;
  describeProjectVersions(
    args: DescribeProjectVersionsCommandInput,
    cb: (err: any, data?: DescribeProjectVersionsCommandOutput) => void
  ): void;
  describeProjectVersions(
    args: DescribeProjectVersionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeProjectVersionsCommandOutput) => void
  ): void;
  describeStreamProcessor(
    args: DescribeStreamProcessorCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeStreamProcessorCommandOutput>;
  describeStreamProcessor(
    args: DescribeStreamProcessorCommandInput,
    cb: (err: any, data?: DescribeStreamProcessorCommandOutput) => void
  ): void;
  describeStreamProcessor(
    args: DescribeStreamProcessorCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeStreamProcessorCommandOutput) => void
  ): void;
  detectCustomLabels(
    args: DetectCustomLabelsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DetectCustomLabelsCommandOutput>;
  detectCustomLabels(
    args: DetectCustomLabelsCommandInput,
    cb: (err: any, data?: DetectCustomLabelsCommandOutput) => void
  ): void;
  detectCustomLabels(
    args: DetectCustomLabelsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DetectCustomLabelsCommandOutput) => void
  ): void;
  detectFaces(
    args: DetectFacesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DetectFacesCommandOutput>;
  detectFaces(
    args: DetectFacesCommandInput,
    cb: (err: any, data?: DetectFacesCommandOutput) => void
  ): void;
  detectFaces(
    args: DetectFacesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DetectFacesCommandOutput) => void
  ): void;
  detectLabels(
    args: DetectLabelsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DetectLabelsCommandOutput>;
  detectLabels(
    args: DetectLabelsCommandInput,
    cb: (err: any, data?: DetectLabelsCommandOutput) => void
  ): void;
  detectLabels(
    args: DetectLabelsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DetectLabelsCommandOutput) => void
  ): void;
  detectModerationLabels(
    args: DetectModerationLabelsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DetectModerationLabelsCommandOutput>;
  detectModerationLabels(
    args: DetectModerationLabelsCommandInput,
    cb: (err: any, data?: DetectModerationLabelsCommandOutput) => void
  ): void;
  detectModerationLabels(
    args: DetectModerationLabelsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DetectModerationLabelsCommandOutput) => void
  ): void;
  detectProtectiveEquipment(
    args: DetectProtectiveEquipmentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DetectProtectiveEquipmentCommandOutput>;
  detectProtectiveEquipment(
    args: DetectProtectiveEquipmentCommandInput,
    cb: (err: any, data?: DetectProtectiveEquipmentCommandOutput) => void
  ): void;
  detectProtectiveEquipment(
    args: DetectProtectiveEquipmentCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DetectProtectiveEquipmentCommandOutput) => void
  ): void;
  detectText(
    args: DetectTextCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DetectTextCommandOutput>;
  detectText(
    args: DetectTextCommandInput,
    cb: (err: any, data?: DetectTextCommandOutput) => void
  ): void;
  detectText(
    args: DetectTextCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DetectTextCommandOutput) => void
  ): void;
  disassociateFaces(
    args: DisassociateFacesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DisassociateFacesCommandOutput>;
  disassociateFaces(
    args: DisassociateFacesCommandInput,
    cb: (err: any, data?: DisassociateFacesCommandOutput) => void
  ): void;
  disassociateFaces(
    args: DisassociateFacesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DisassociateFacesCommandOutput) => void
  ): void;
  distributeDatasetEntries(
    args: DistributeDatasetEntriesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DistributeDatasetEntriesCommandOutput>;
  distributeDatasetEntries(
    args: DistributeDatasetEntriesCommandInput,
    cb: (err: any, data?: DistributeDatasetEntriesCommandOutput) => void
  ): void;
  distributeDatasetEntries(
    args: DistributeDatasetEntriesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DistributeDatasetEntriesCommandOutput) => void
  ): void;
  getCelebrityInfo(
    args: GetCelebrityInfoCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCelebrityInfoCommandOutput>;
  getCelebrityInfo(
    args: GetCelebrityInfoCommandInput,
    cb: (err: any, data?: GetCelebrityInfoCommandOutput) => void
  ): void;
  getCelebrityInfo(
    args: GetCelebrityInfoCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetCelebrityInfoCommandOutput) => void
  ): void;
  getCelebrityRecognition(
    args: GetCelebrityRecognitionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCelebrityRecognitionCommandOutput>;
  getCelebrityRecognition(
    args: GetCelebrityRecognitionCommandInput,
    cb: (err: any, data?: GetCelebrityRecognitionCommandOutput) => void
  ): void;
  getCelebrityRecognition(
    args: GetCelebrityRecognitionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetCelebrityRecognitionCommandOutput) => void
  ): void;
  getContentModeration(
    args: GetContentModerationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetContentModerationCommandOutput>;
  getContentModeration(
    args: GetContentModerationCommandInput,
    cb: (err: any, data?: GetContentModerationCommandOutput) => void
  ): void;
  getContentModeration(
    args: GetContentModerationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetContentModerationCommandOutput) => void
  ): void;
  getFaceDetection(
    args: GetFaceDetectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFaceDetectionCommandOutput>;
  getFaceDetection(
    args: GetFaceDetectionCommandInput,
    cb: (err: any, data?: GetFaceDetectionCommandOutput) => void
  ): void;
  getFaceDetection(
    args: GetFaceDetectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetFaceDetectionCommandOutput) => void
  ): void;
  getFaceLivenessSessionResults(
    args: GetFaceLivenessSessionResultsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFaceLivenessSessionResultsCommandOutput>;
  getFaceLivenessSessionResults(
    args: GetFaceLivenessSessionResultsCommandInput,
    cb: (err: any, data?: GetFaceLivenessSessionResultsCommandOutput) => void
  ): void;
  getFaceLivenessSessionResults(
    args: GetFaceLivenessSessionResultsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetFaceLivenessSessionResultsCommandOutput) => void
  ): void;
  getFaceSearch(
    args: GetFaceSearchCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFaceSearchCommandOutput>;
  getFaceSearch(
    args: GetFaceSearchCommandInput,
    cb: (err: any, data?: GetFaceSearchCommandOutput) => void
  ): void;
  getFaceSearch(
    args: GetFaceSearchCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetFaceSearchCommandOutput) => void
  ): void;
  getLabelDetection(
    args: GetLabelDetectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetLabelDetectionCommandOutput>;
  getLabelDetection(
    args: GetLabelDetectionCommandInput,
    cb: (err: any, data?: GetLabelDetectionCommandOutput) => void
  ): void;
  getLabelDetection(
    args: GetLabelDetectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetLabelDetectionCommandOutput) => void
  ): void;
  getMediaAnalysisJob(
    args: GetMediaAnalysisJobCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetMediaAnalysisJobCommandOutput>;
  getMediaAnalysisJob(
    args: GetMediaAnalysisJobCommandInput,
    cb: (err: any, data?: GetMediaAnalysisJobCommandOutput) => void
  ): void;
  getMediaAnalysisJob(
    args: GetMediaAnalysisJobCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetMediaAnalysisJobCommandOutput) => void
  ): void;
  getPersonTracking(
    args: GetPersonTrackingCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetPersonTrackingCommandOutput>;
  getPersonTracking(
    args: GetPersonTrackingCommandInput,
    cb: (err: any, data?: GetPersonTrackingCommandOutput) => void
  ): void;
  getPersonTracking(
    args: GetPersonTrackingCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetPersonTrackingCommandOutput) => void
  ): void;
  getSegmentDetection(
    args: GetSegmentDetectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetSegmentDetectionCommandOutput>;
  getSegmentDetection(
    args: GetSegmentDetectionCommandInput,
    cb: (err: any, data?: GetSegmentDetectionCommandOutput) => void
  ): void;
  getSegmentDetection(
    args: GetSegmentDetectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetSegmentDetectionCommandOutput) => void
  ): void;
  getTextDetection(
    args: GetTextDetectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetTextDetectionCommandOutput>;
  getTextDetection(
    args: GetTextDetectionCommandInput,
    cb: (err: any, data?: GetTextDetectionCommandOutput) => void
  ): void;
  getTextDetection(
    args: GetTextDetectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetTextDetectionCommandOutput) => void
  ): void;
  indexFaces(
    args: IndexFacesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<IndexFacesCommandOutput>;
  indexFaces(
    args: IndexFacesCommandInput,
    cb: (err: any, data?: IndexFacesCommandOutput) => void
  ): void;
  indexFaces(
    args: IndexFacesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: IndexFacesCommandOutput) => void
  ): void;
  listCollections(): Promise<ListCollectionsCommandOutput>;
  listCollections(
    args: ListCollectionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListCollectionsCommandOutput>;
  listCollections(
    args: ListCollectionsCommandInput,
    cb: (err: any, data?: ListCollectionsCommandOutput) => void
  ): void;
  listCollections(
    args: ListCollectionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListCollectionsCommandOutput) => void
  ): void;
  listDatasetEntries(
    args: ListDatasetEntriesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDatasetEntriesCommandOutput>;
  listDatasetEntries(
    args: ListDatasetEntriesCommandInput,
    cb: (err: any, data?: ListDatasetEntriesCommandOutput) => void
  ): void;
  listDatasetEntries(
    args: ListDatasetEntriesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDatasetEntriesCommandOutput) => void
  ): void;
  listDatasetLabels(
    args: ListDatasetLabelsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDatasetLabelsCommandOutput>;
  listDatasetLabels(
    args: ListDatasetLabelsCommandInput,
    cb: (err: any, data?: ListDatasetLabelsCommandOutput) => void
  ): void;
  listDatasetLabels(
    args: ListDatasetLabelsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDatasetLabelsCommandOutput) => void
  ): void;
  listFaces(
    args: ListFacesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListFacesCommandOutput>;
  listFaces(
    args: ListFacesCommandInput,
    cb: (err: any, data?: ListFacesCommandOutput) => void
  ): void;
  listFaces(
    args: ListFacesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListFacesCommandOutput) => void
  ): void;
  listMediaAnalysisJobs(): Promise<ListMediaAnalysisJobsCommandOutput>;
  listMediaAnalysisJobs(
    args: ListMediaAnalysisJobsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListMediaAnalysisJobsCommandOutput>;
  listMediaAnalysisJobs(
    args: ListMediaAnalysisJobsCommandInput,
    cb: (err: any, data?: ListMediaAnalysisJobsCommandOutput) => void
  ): void;
  listMediaAnalysisJobs(
    args: ListMediaAnalysisJobsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListMediaAnalysisJobsCommandOutput) => void
  ): void;
  listProjectPolicies(
    args: ListProjectPoliciesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListProjectPoliciesCommandOutput>;
  listProjectPolicies(
    args: ListProjectPoliciesCommandInput,
    cb: (err: any, data?: ListProjectPoliciesCommandOutput) => void
  ): void;
  listProjectPolicies(
    args: ListProjectPoliciesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListProjectPoliciesCommandOutput) => void
  ): void;
  listStreamProcessors(): Promise<ListStreamProcessorsCommandOutput>;
  listStreamProcessors(
    args: ListStreamProcessorsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListStreamProcessorsCommandOutput>;
  listStreamProcessors(
    args: ListStreamProcessorsCommandInput,
    cb: (err: any, data?: ListStreamProcessorsCommandOutput) => void
  ): void;
  listStreamProcessors(
    args: ListStreamProcessorsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListStreamProcessorsCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListTagsForResourceCommandOutput>;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  listUsers(
    args: ListUsersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListUsersCommandOutput>;
  listUsers(
    args: ListUsersCommandInput,
    cb: (err: any, data?: ListUsersCommandOutput) => void
  ): void;
  listUsers(
    args: ListUsersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListUsersCommandOutput) => void
  ): void;
  putProjectPolicy(
    args: PutProjectPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PutProjectPolicyCommandOutput>;
  putProjectPolicy(
    args: PutProjectPolicyCommandInput,
    cb: (err: any, data?: PutProjectPolicyCommandOutput) => void
  ): void;
  putProjectPolicy(
    args: PutProjectPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PutProjectPolicyCommandOutput) => void
  ): void;
  recognizeCelebrities(
    args: RecognizeCelebritiesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RecognizeCelebritiesCommandOutput>;
  recognizeCelebrities(
    args: RecognizeCelebritiesCommandInput,
    cb: (err: any, data?: RecognizeCelebritiesCommandOutput) => void
  ): void;
  recognizeCelebrities(
    args: RecognizeCelebritiesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RecognizeCelebritiesCommandOutput) => void
  ): void;
  searchFaces(
    args: SearchFacesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SearchFacesCommandOutput>;
  searchFaces(
    args: SearchFacesCommandInput,
    cb: (err: any, data?: SearchFacesCommandOutput) => void
  ): void;
  searchFaces(
    args: SearchFacesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SearchFacesCommandOutput) => void
  ): void;
  searchFacesByImage(
    args: SearchFacesByImageCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SearchFacesByImageCommandOutput>;
  searchFacesByImage(
    args: SearchFacesByImageCommandInput,
    cb: (err: any, data?: SearchFacesByImageCommandOutput) => void
  ): void;
  searchFacesByImage(
    args: SearchFacesByImageCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SearchFacesByImageCommandOutput) => void
  ): void;
  searchUsers(
    args: SearchUsersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SearchUsersCommandOutput>;
  searchUsers(
    args: SearchUsersCommandInput,
    cb: (err: any, data?: SearchUsersCommandOutput) => void
  ): void;
  searchUsers(
    args: SearchUsersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SearchUsersCommandOutput) => void
  ): void;
  searchUsersByImage(
    args: SearchUsersByImageCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SearchUsersByImageCommandOutput>;
  searchUsersByImage(
    args: SearchUsersByImageCommandInput,
    cb: (err: any, data?: SearchUsersByImageCommandOutput) => void
  ): void;
  searchUsersByImage(
    args: SearchUsersByImageCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SearchUsersByImageCommandOutput) => void
  ): void;
  startCelebrityRecognition(
    args: StartCelebrityRecognitionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartCelebrityRecognitionCommandOutput>;
  startCelebrityRecognition(
    args: StartCelebrityRecognitionCommandInput,
    cb: (err: any, data?: StartCelebrityRecognitionCommandOutput) => void
  ): void;
  startCelebrityRecognition(
    args: StartCelebrityRecognitionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartCelebrityRecognitionCommandOutput) => void
  ): void;
  startContentModeration(
    args: StartContentModerationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartContentModerationCommandOutput>;
  startContentModeration(
    args: StartContentModerationCommandInput,
    cb: (err: any, data?: StartContentModerationCommandOutput) => void
  ): void;
  startContentModeration(
    args: StartContentModerationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartContentModerationCommandOutput) => void
  ): void;
  startFaceDetection(
    args: StartFaceDetectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartFaceDetectionCommandOutput>;
  startFaceDetection(
    args: StartFaceDetectionCommandInput,
    cb: (err: any, data?: StartFaceDetectionCommandOutput) => void
  ): void;
  startFaceDetection(
    args: StartFaceDetectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartFaceDetectionCommandOutput) => void
  ): void;
  startFaceSearch(
    args: StartFaceSearchCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartFaceSearchCommandOutput>;
  startFaceSearch(
    args: StartFaceSearchCommandInput,
    cb: (err: any, data?: StartFaceSearchCommandOutput) => void
  ): void;
  startFaceSearch(
    args: StartFaceSearchCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartFaceSearchCommandOutput) => void
  ): void;
  startLabelDetection(
    args: StartLabelDetectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartLabelDetectionCommandOutput>;
  startLabelDetection(
    args: StartLabelDetectionCommandInput,
    cb: (err: any, data?: StartLabelDetectionCommandOutput) => void
  ): void;
  startLabelDetection(
    args: StartLabelDetectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartLabelDetectionCommandOutput) => void
  ): void;
  startMediaAnalysisJob(
    args: StartMediaAnalysisJobCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartMediaAnalysisJobCommandOutput>;
  startMediaAnalysisJob(
    args: StartMediaAnalysisJobCommandInput,
    cb: (err: any, data?: StartMediaAnalysisJobCommandOutput) => void
  ): void;
  startMediaAnalysisJob(
    args: StartMediaAnalysisJobCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartMediaAnalysisJobCommandOutput) => void
  ): void;
  startPersonTracking(
    args: StartPersonTrackingCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartPersonTrackingCommandOutput>;
  startPersonTracking(
    args: StartPersonTrackingCommandInput,
    cb: (err: any, data?: StartPersonTrackingCommandOutput) => void
  ): void;
  startPersonTracking(
    args: StartPersonTrackingCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartPersonTrackingCommandOutput) => void
  ): void;
  startProjectVersion(
    args: StartProjectVersionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartProjectVersionCommandOutput>;
  startProjectVersion(
    args: StartProjectVersionCommandInput,
    cb: (err: any, data?: StartProjectVersionCommandOutput) => void
  ): void;
  startProjectVersion(
    args: StartProjectVersionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartProjectVersionCommandOutput) => void
  ): void;
  startSegmentDetection(
    args: StartSegmentDetectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartSegmentDetectionCommandOutput>;
  startSegmentDetection(
    args: StartSegmentDetectionCommandInput,
    cb: (err: any, data?: StartSegmentDetectionCommandOutput) => void
  ): void;
  startSegmentDetection(
    args: StartSegmentDetectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartSegmentDetectionCommandOutput) => void
  ): void;
  startStreamProcessor(
    args: StartStreamProcessorCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartStreamProcessorCommandOutput>;
  startStreamProcessor(
    args: StartStreamProcessorCommandInput,
    cb: (err: any, data?: StartStreamProcessorCommandOutput) => void
  ): void;
  startStreamProcessor(
    args: StartStreamProcessorCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartStreamProcessorCommandOutput) => void
  ): void;
  startTextDetection(
    args: StartTextDetectionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartTextDetectionCommandOutput>;
  startTextDetection(
    args: StartTextDetectionCommandInput,
    cb: (err: any, data?: StartTextDetectionCommandOutput) => void
  ): void;
  startTextDetection(
    args: StartTextDetectionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartTextDetectionCommandOutput) => void
  ): void;
  stopProjectVersion(
    args: StopProjectVersionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StopProjectVersionCommandOutput>;
  stopProjectVersion(
    args: StopProjectVersionCommandInput,
    cb: (err: any, data?: StopProjectVersionCommandOutput) => void
  ): void;
  stopProjectVersion(
    args: StopProjectVersionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StopProjectVersionCommandOutput) => void
  ): void;
  stopStreamProcessor(
    args: StopStreamProcessorCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StopStreamProcessorCommandOutput>;
  stopStreamProcessor(
    args: StopStreamProcessorCommandInput,
    cb: (err: any, data?: StopStreamProcessorCommandOutput) => void
  ): void;
  stopStreamProcessor(
    args: StopStreamProcessorCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StopStreamProcessorCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<TagResourceCommandOutput>;
  tagResource(
    args: TagResourceCommandInput,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UntagResourceCommandOutput>;
  untagResource(
    args: UntagResourceCommandInput,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  updateDatasetEntries(
    args: UpdateDatasetEntriesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateDatasetEntriesCommandOutput>;
  updateDatasetEntries(
    args: UpdateDatasetEntriesCommandInput,
    cb: (err: any, data?: UpdateDatasetEntriesCommandOutput) => void
  ): void;
  updateDatasetEntries(
    args: UpdateDatasetEntriesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateDatasetEntriesCommandOutput) => void
  ): void;
  updateStreamProcessor(
    args: UpdateStreamProcessorCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateStreamProcessorCommandOutput>;
  updateStreamProcessor(
    args: UpdateStreamProcessorCommandInput,
    cb: (err: any, data?: UpdateStreamProcessorCommandOutput) => void
  ): void;
  updateStreamProcessor(
    args: UpdateStreamProcessorCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateStreamProcessorCommandOutput) => void
  ): void;
}
export declare class Rekognition
  extends RekognitionClient
  implements Rekognition {}
