import {
  AwsSdkSigV4AuthInputConfig,
  AwsSdkSigV4AuthResolvedConfig,
  AwsSdkSigV4PreviouslyResolved,
} from "@aws-sdk/core";
import {
  HandlerExecutionContext,
  HttpAuthScheme,
  HttpAuthSchemeParameters,
  HttpAuthSchemeParametersProvider,
  HttpAuthSchemeProvider,
  Provider,
} from "@smithy/types";
import { RekognitionClientResolvedConfig } from "../RekognitionClient";
export interface RekognitionHttpAuthSchemeParameters
  extends HttpAuthSchemeParameters {
  region?: string;
}
export interface RekognitionHttpAuthSchemeParametersProvider
  extends HttpAuthSchemeParametersProvider<
    RekognitionClientResolvedConfig,
    HandlerExecutionContext,
    RekognitionHttpAuthSchemeParameters,
    object
  > {}
export declare const defaultRekognitionHttpAuthSchemeParametersProvider: (
  config: RekognitionClientResolvedConfig,
  context: HandlerExecutionContext,
  input: object
) => Promise<RekognitionHttpAuthSchemeParameters>;
export interface RekognitionHttpAuthSchemeProvider
  extends HttpAuthSchemeProvider<RekognitionHttpAuthSchemeParameters> {}
export declare const defaultRekognitionHttpAuthSchemeProvider: RekognitionHttpAuthSchemeProvider;
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
  authSchemePreference?: string[] | Provider<string[]>;
  httpAuthSchemes?: HttpAuthScheme[];
  httpAuthSchemeProvider?: RekognitionHttpAuthSchemeProvider;
}
export interface HttpAuthSchemeResolvedConfig
  extends AwsSdkSigV4AuthResolvedConfig {
  readonly authSchemePreference: Provider<string[]>;
  readonly httpAuthSchemes: HttpAuthScheme[];
  readonly httpAuthSchemeProvider: RekognitionHttpAuthSchemeProvider;
}
export declare const resolveHttpAuthSchemeConfig: <T>(
  config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved
) => T & HttpAuthSchemeResolvedConfig;
