import { AutomaticJsonStringConversion as __AutomaticJsonStringConversion } from "@smithy/smithy-client";
import {
  Attribute,
  BodyPart,
  CelebrityRecognitionSortBy,
  ChallengeType,
  ContentClassifier,
  ContentModerationAggregateBy,
  ContentModerationSortBy,
  CustomizationFeature,
  DatasetStatus,
  DatasetStatusMessageCode,
  DatasetType,
  DetectLabelsFeatureName,
  EmotionName,
  FaceAttributes,
  FaceSearchSortBy,
  GenderType,
  KnownGenderType,
  LabelDetectionAggregateBy,
  LabelDetectionFeatureName,
  LabelDetectionSortBy,
  LandmarkType,
  LivenessSessionStatus,
  MediaAnalysisJobFailureCode,
  MediaAnalysisJobStatus,
  OrientationCorrection,
  PersonTrackingSortBy,
  ProjectAutoUpdate,
  ProjectStatus,
  ProjectVersionStatus,
  ProtectiveEquipmentType,
  QualityFilter,
  Reason,
  SegmentType,
  StreamProcessorParameterToDelete,
  StreamProcessorStatus,
  TechnicalCueType,
  TextTypes,
  UnsearchedFaceReason,
  UnsuccessfulFaceAssociationReason,
  UnsuccessfulFaceDeletionReason,
  UnsuccessfulFaceDisassociationReason,
  UserStatus,
  VideoColorRange,
  VideoJobStatus,
} from "./enums";
export interface AgeRange {
  Low?: number | undefined;
  High?: number | undefined;
}
export interface S3Object {
  Bucket?: string | undefined;
  Name?: string | undefined;
  Version?: string | undefined;
}
export interface GroundTruthManifest {
  S3Object?: S3Object | undefined;
}
export interface Asset {
  GroundTruthManifest?: GroundTruthManifest | undefined;
}
export interface AssociatedFace {
  FaceId?: string | undefined;
}
export interface AssociateFacesRequest {
  CollectionId: string | undefined;
  UserId: string | undefined;
  FaceIds: string[] | undefined;
  UserMatchThreshold?: number | undefined;
  ClientRequestToken?: string | undefined;
}
export interface UnsuccessfulFaceAssociation {
  FaceId?: string | undefined;
  UserId?: string | undefined;
  Confidence?: number | undefined;
  Reasons?: UnsuccessfulFaceAssociationReason[] | undefined;
}
export interface AssociateFacesResponse {
  AssociatedFaces?: AssociatedFace[] | undefined;
  UnsuccessfulFaceAssociations?: UnsuccessfulFaceAssociation[] | undefined;
  UserStatus?: UserStatus | undefined;
}
export interface AudioMetadata {
  Codec?: string | undefined;
  DurationMillis?: number | undefined;
  SampleRate?: number | undefined;
  NumberOfChannels?: number | undefined;
}
export interface BoundingBox {
  Width?: number | undefined;
  Height?: number | undefined;
  Left?: number | undefined;
  Top?: number | undefined;
}
export interface AuditImage {
  Bytes?: Uint8Array | undefined;
  S3Object?: S3Object | undefined;
  BoundingBox?: BoundingBox | undefined;
}
export interface Beard {
  Value?: boolean | undefined;
  Confidence?: number | undefined;
}
export interface BlackFrame {
  MaxPixelThreshold?: number | undefined;
  MinCoveragePercentage?: number | undefined;
}
export interface CoversBodyPart {
  Confidence?: number | undefined;
  Value?: boolean | undefined;
}
export interface EquipmentDetection {
  BoundingBox?: BoundingBox | undefined;
  Confidence?: number | undefined;
  Type?: ProtectiveEquipmentType | undefined;
  CoversBodyPart?: CoversBodyPart | undefined;
}
export interface ProtectiveEquipmentBodyPart {
  Name?: BodyPart | undefined;
  Confidence?: number | undefined;
  EquipmentDetections?: EquipmentDetection[] | undefined;
}
export interface Emotion {
  Type?: EmotionName | undefined;
  Confidence?: number | undefined;
}
export interface Landmark {
  Type?: LandmarkType | undefined;
  X?: number | undefined;
  Y?: number | undefined;
}
export interface Pose {
  Roll?: number | undefined;
  Yaw?: number | undefined;
  Pitch?: number | undefined;
}
export interface ImageQuality {
  Brightness?: number | undefined;
  Sharpness?: number | undefined;
}
export interface Smile {
  Value?: boolean | undefined;
  Confidence?: number | undefined;
}
export interface ComparedFace {
  BoundingBox?: BoundingBox | undefined;
  Confidence?: number | undefined;
  Landmarks?: Landmark[] | undefined;
  Pose?: Pose | undefined;
  Quality?: ImageQuality | undefined;
  Emotions?: Emotion[] | undefined;
  Smile?: Smile | undefined;
}
export interface KnownGender {
  Type?: KnownGenderType | undefined;
}
export interface Celebrity {
  Urls?: string[] | undefined;
  Name?: string | undefined;
  Id?: string | undefined;
  Face?: ComparedFace | undefined;
  MatchConfidence?: number | undefined;
  KnownGender?: KnownGender | undefined;
}
export interface EyeDirection {
  Yaw?: number | undefined;
  Pitch?: number | undefined;
  Confidence?: number | undefined;
}
export interface Eyeglasses {
  Value?: boolean | undefined;
  Confidence?: number | undefined;
}
export interface EyeOpen {
  Value?: boolean | undefined;
  Confidence?: number | undefined;
}
export interface FaceOccluded {
  Value?: boolean | undefined;
  Confidence?: number | undefined;
}
export interface Gender {
  Value?: GenderType | undefined;
  Confidence?: number | undefined;
}
export interface MouthOpen {
  Value?: boolean | undefined;
  Confidence?: number | undefined;
}
export interface Mustache {
  Value?: boolean | undefined;
  Confidence?: number | undefined;
}
export interface Sunglasses {
  Value?: boolean | undefined;
  Confidence?: number | undefined;
}
export interface FaceDetail {
  BoundingBox?: BoundingBox | undefined;
  AgeRange?: AgeRange | undefined;
  Smile?: Smile | undefined;
  Eyeglasses?: Eyeglasses | undefined;
  Sunglasses?: Sunglasses | undefined;
  Gender?: Gender | undefined;
  Beard?: Beard | undefined;
  Mustache?: Mustache | undefined;
  EyesOpen?: EyeOpen | undefined;
  MouthOpen?: MouthOpen | undefined;
  Emotions?: Emotion[] | undefined;
  Landmarks?: Landmark[] | undefined;
  Pose?: Pose | undefined;
  Quality?: ImageQuality | undefined;
  Confidence?: number | undefined;
  FaceOccluded?: FaceOccluded | undefined;
  EyeDirection?: EyeDirection | undefined;
}
export interface CelebrityDetail {
  Urls?: string[] | undefined;
  Name?: string | undefined;
  Id?: string | undefined;
  Confidence?: number | undefined;
  BoundingBox?: BoundingBox | undefined;
  Face?: FaceDetail | undefined;
  KnownGender?: KnownGender | undefined;
}
export interface CelebrityRecognition {
  Timestamp?: number | undefined;
  Celebrity?: CelebrityDetail | undefined;
}
export interface Challenge {
  Type: ChallengeType | undefined;
  Version: string | undefined;
}
export interface Versions {
  Minimum?: string | undefined;
  Maximum?: string | undefined;
}
export interface ChallengePreference {
  Type: ChallengeType | undefined;
  Versions?: Versions | undefined;
}
export interface ComparedSourceImageFace {
  BoundingBox?: BoundingBox | undefined;
  Confidence?: number | undefined;
}
export interface Image {
  Bytes?: Uint8Array | undefined;
  S3Object?: S3Object | undefined;
}
export interface CompareFacesRequest {
  SourceImage: Image | undefined;
  TargetImage: Image | undefined;
  SimilarityThreshold?: number | undefined;
  QualityFilter?: QualityFilter | undefined;
}
export interface CompareFacesMatch {
  Similarity?: number | undefined;
  Face?: ComparedFace | undefined;
}
export interface CompareFacesResponse {
  SourceImageFace?: ComparedSourceImageFace | undefined;
  FaceMatches?: CompareFacesMatch[] | undefined;
  UnmatchedFaces?: ComparedFace[] | undefined;
  SourceImageOrientationCorrection?: OrientationCorrection | undefined;
  TargetImageOrientationCorrection?: OrientationCorrection | undefined;
}
export interface ConnectedHomeSettings {
  Labels: string[] | undefined;
  MinConfidence?: number | undefined;
}
export interface ConnectedHomeSettingsForUpdate {
  Labels?: string[] | undefined;
  MinConfidence?: number | undefined;
}
export interface ContentType {
  Confidence?: number | undefined;
  Name?: string | undefined;
}
export interface ModerationLabel {
  Confidence?: number | undefined;
  Name?: string | undefined;
  ParentName?: string | undefined;
  TaxonomyLevel?: number | undefined;
}
export interface ContentModerationDetection {
  Timestamp?: number | undefined;
  ModerationLabel?: ModerationLabel | undefined;
  StartTimestampMillis?: number | undefined;
  EndTimestampMillis?: number | undefined;
  DurationMillis?: number | undefined;
  ContentTypes?: ContentType[] | undefined;
}
export interface OutputConfig {
  S3Bucket?: string | undefined;
  S3KeyPrefix?: string | undefined;
}
export interface CopyProjectVersionRequest {
  SourceProjectArn: string | undefined;
  SourceProjectVersionArn: string | undefined;
  DestinationProjectArn: string | undefined;
  VersionName: string | undefined;
  OutputConfig: OutputConfig | undefined;
  Tags?: Record<string, string> | undefined;
  KmsKeyId?: string | undefined;
}
export interface CopyProjectVersionResponse {
  ProjectVersionArn?: string | undefined;
}
export interface CreateCollectionRequest {
  CollectionId: string | undefined;
  Tags?: Record<string, string> | undefined;
}
export interface CreateCollectionResponse {
  StatusCode?: number | undefined;
  CollectionArn?: string | undefined;
  FaceModelVersion?: string | undefined;
}
export interface DatasetSource {
  GroundTruthManifest?: GroundTruthManifest | undefined;
  DatasetArn?: string | undefined;
}
export interface CreateDatasetRequest {
  DatasetSource?: DatasetSource | undefined;
  DatasetType: DatasetType | undefined;
  ProjectArn: string | undefined;
  Tags?: Record<string, string> | undefined;
}
export interface CreateDatasetResponse {
  DatasetArn?: string | undefined;
}
export interface LivenessOutputConfig {
  S3Bucket: string | undefined;
  S3KeyPrefix?: string | undefined;
}
export interface CreateFaceLivenessSessionRequestSettings {
  OutputConfig?: LivenessOutputConfig | undefined;
  AuditImagesLimit?: number | undefined;
  ChallengePreferences?: ChallengePreference[] | undefined;
}
export interface CreateFaceLivenessSessionRequest {
  KmsKeyId?: string | undefined;
  Settings?: CreateFaceLivenessSessionRequestSettings | undefined;
  ClientRequestToken?: string | undefined;
}
export interface CreateFaceLivenessSessionResponse {
  SessionId: string | undefined;
}
export interface CreateProjectRequest {
  ProjectName: string | undefined;
  Feature?: CustomizationFeature | undefined;
  AutoUpdate?: ProjectAutoUpdate | undefined;
  Tags?: Record<string, string> | undefined;
}
export interface CreateProjectResponse {
  ProjectArn?: string | undefined;
}
export interface CustomizationFeatureContentModerationConfig {
  ConfidenceThreshold?: number | undefined;
}
export interface CustomizationFeatureConfig {
  ContentModeration?: CustomizationFeatureContentModerationConfig | undefined;
}
export interface TestingData {
  Assets?: Asset[] | undefined;
  AutoCreate?: boolean | undefined;
}
export interface TrainingData {
  Assets?: Asset[] | undefined;
}
export interface CreateProjectVersionRequest {
  ProjectArn: string | undefined;
  VersionName: string | undefined;
  OutputConfig: OutputConfig | undefined;
  TrainingData?: TrainingData | undefined;
  TestingData?: TestingData | undefined;
  Tags?: Record<string, string> | undefined;
  KmsKeyId?: string | undefined;
  VersionDescription?: string | undefined;
  FeatureConfig?: CustomizationFeatureConfig | undefined;
}
export interface CreateProjectVersionResponse {
  ProjectVersionArn?: string | undefined;
}
export interface StreamProcessorDataSharingPreference {
  OptIn: boolean | undefined;
}
export interface KinesisVideoStream {
  Arn?: string | undefined;
}
export interface StreamProcessorInput {
  KinesisVideoStream?: KinesisVideoStream | undefined;
}
export interface StreamProcessorNotificationChannel {
  SNSTopicArn: string | undefined;
}
export interface KinesisDataStream {
  Arn?: string | undefined;
}
export interface S3Destination {
  Bucket?: string | undefined;
  KeyPrefix?: string | undefined;
}
export interface StreamProcessorOutput {
  KinesisDataStream?: KinesisDataStream | undefined;
  S3Destination?: S3Destination | undefined;
}
export interface Point {
  X?: number | undefined;
  Y?: number | undefined;
}
export interface RegionOfInterest {
  BoundingBox?: BoundingBox | undefined;
  Polygon?: Point[] | undefined;
}
export interface FaceSearchSettings {
  CollectionId?: string | undefined;
  FaceMatchThreshold?: number | undefined;
}
export interface StreamProcessorSettings {
  FaceSearch?: FaceSearchSettings | undefined;
  ConnectedHome?: ConnectedHomeSettings | undefined;
}
export interface CreateStreamProcessorRequest {
  Input: StreamProcessorInput | undefined;
  Output: StreamProcessorOutput | undefined;
  Name: string | undefined;
  Settings: StreamProcessorSettings | undefined;
  RoleArn: string | undefined;
  Tags?: Record<string, string> | undefined;
  NotificationChannel?: StreamProcessorNotificationChannel | undefined;
  KmsKeyId?: string | undefined;
  RegionsOfInterest?: RegionOfInterest[] | undefined;
  DataSharingPreference?: StreamProcessorDataSharingPreference | undefined;
}
export interface CreateStreamProcessorResponse {
  StreamProcessorArn?: string | undefined;
}
export interface CreateUserRequest {
  CollectionId: string | undefined;
  UserId: string | undefined;
  ClientRequestToken?: string | undefined;
}
export interface CreateUserResponse {}
export interface Geometry {
  BoundingBox?: BoundingBox | undefined;
  Polygon?: Point[] | undefined;
}
export interface CustomLabel {
  Name?: string | undefined;
  Confidence?: number | undefined;
  Geometry?: Geometry | undefined;
}
export interface DatasetChanges {
  GroundTruth: Uint8Array | undefined;
}
export interface DatasetStats {
  LabeledEntries?: number | undefined;
  TotalEntries?: number | undefined;
  TotalLabels?: number | undefined;
  ErrorEntries?: number | undefined;
}
export interface DatasetDescription {
  CreationTimestamp?: Date | undefined;
  LastUpdatedTimestamp?: Date | undefined;
  Status?: DatasetStatus | undefined;
  StatusMessage?: string | undefined;
  StatusMessageCode?: DatasetStatusMessageCode | undefined;
  DatasetStats?: DatasetStats | undefined;
}
export interface DatasetLabelStats {
  EntryCount?: number | undefined;
  BoundingBoxCount?: number | undefined;
}
export interface DatasetLabelDescription {
  LabelName?: string | undefined;
  LabelStats?: DatasetLabelStats | undefined;
}
export interface DatasetMetadata {
  CreationTimestamp?: Date | undefined;
  DatasetType?: DatasetType | undefined;
  DatasetArn?: string | undefined;
  Status?: DatasetStatus | undefined;
  StatusMessage?: string | undefined;
  StatusMessageCode?: DatasetStatusMessageCode | undefined;
}
export interface DeleteCollectionRequest {
  CollectionId: string | undefined;
}
export interface DeleteCollectionResponse {
  StatusCode?: number | undefined;
}
export interface DeleteDatasetRequest {
  DatasetArn: string | undefined;
}
export interface DeleteDatasetResponse {}
export interface DeleteFacesRequest {
  CollectionId: string | undefined;
  FaceIds: string[] | undefined;
}
export interface UnsuccessfulFaceDeletion {
  FaceId?: string | undefined;
  UserId?: string | undefined;
  Reasons?: UnsuccessfulFaceDeletionReason[] | undefined;
}
export interface DeleteFacesResponse {
  DeletedFaces?: string[] | undefined;
  UnsuccessfulFaceDeletions?: UnsuccessfulFaceDeletion[] | undefined;
}
export interface DeleteProjectRequest {
  ProjectArn: string | undefined;
}
export interface DeleteProjectResponse {
  Status?: ProjectStatus | undefined;
}
export interface DeleteProjectPolicyRequest {
  ProjectArn: string | undefined;
  PolicyName: string | undefined;
  PolicyRevisionId?: string | undefined;
}
export interface DeleteProjectPolicyResponse {}
export interface DeleteProjectVersionRequest {
  ProjectVersionArn: string | undefined;
}
export interface DeleteProjectVersionResponse {
  Status?: ProjectVersionStatus | undefined;
}
export interface DeleteStreamProcessorRequest {
  Name: string | undefined;
}
export interface DeleteStreamProcessorResponse {}
export interface DeleteUserRequest {
  CollectionId: string | undefined;
  UserId: string | undefined;
  ClientRequestToken?: string | undefined;
}
export interface DeleteUserResponse {}
export interface DescribeCollectionRequest {
  CollectionId: string | undefined;
}
export interface DescribeCollectionResponse {
  FaceCount?: number | undefined;
  FaceModelVersion?: string | undefined;
  CollectionARN?: string | undefined;
  CreationTimestamp?: Date | undefined;
  UserCount?: number | undefined;
}
export interface DescribeDatasetRequest {
  DatasetArn: string | undefined;
}
export interface DescribeDatasetResponse {
  DatasetDescription?: DatasetDescription | undefined;
}
export interface DescribeProjectsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  ProjectNames?: string[] | undefined;
  Features?: CustomizationFeature[] | undefined;
}
export interface ProjectDescription {
  ProjectArn?: string | undefined;
  CreationTimestamp?: Date | undefined;
  Status?: ProjectStatus | undefined;
  Datasets?: DatasetMetadata[] | undefined;
  Feature?: CustomizationFeature | undefined;
  AutoUpdate?: ProjectAutoUpdate | undefined;
}
export interface DescribeProjectsResponse {
  ProjectDescriptions?: ProjectDescription[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeProjectVersionsRequest {
  ProjectArn: string | undefined;
  VersionNames?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface Summary {
  S3Object?: S3Object | undefined;
}
export interface EvaluationResult {
  F1Score?: number | undefined;
  Summary?: Summary | undefined;
}
export interface ValidationData {
  Assets?: Asset[] | undefined;
}
export interface TestingDataResult {
  Input?: TestingData | undefined;
  Output?: TestingData | undefined;
  Validation?: ValidationData | undefined;
}
export interface TrainingDataResult {
  Input?: TrainingData | undefined;
  Output?: TrainingData | undefined;
  Validation?: ValidationData | undefined;
}
export interface ProjectVersionDescription {
  ProjectVersionArn?: string | undefined;
  CreationTimestamp?: Date | undefined;
  MinInferenceUnits?: number | undefined;
  Status?: ProjectVersionStatus | undefined;
  StatusMessage?: string | undefined;
  BillableTrainingTimeInSeconds?: number | undefined;
  TrainingEndTimestamp?: Date | undefined;
  OutputConfig?: OutputConfig | undefined;
  TrainingDataResult?: TrainingDataResult | undefined;
  TestingDataResult?: TestingDataResult | undefined;
  EvaluationResult?: EvaluationResult | undefined;
  ManifestSummary?: GroundTruthManifest | undefined;
  KmsKeyId?: string | undefined;
  MaxInferenceUnits?: number | undefined;
  SourceProjectVersionArn?: string | undefined;
  VersionDescription?: string | undefined;
  Feature?: CustomizationFeature | undefined;
  BaseModelVersion?: string | undefined;
  FeatureConfig?: CustomizationFeatureConfig | undefined;
}
export interface DescribeProjectVersionsResponse {
  ProjectVersionDescriptions?: ProjectVersionDescription[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeStreamProcessorRequest {
  Name: string | undefined;
}
export interface DescribeStreamProcessorResponse {
  Name?: string | undefined;
  StreamProcessorArn?: string | undefined;
  Status?: StreamProcessorStatus | undefined;
  StatusMessage?: string | undefined;
  CreationTimestamp?: Date | undefined;
  LastUpdateTimestamp?: Date | undefined;
  Input?: StreamProcessorInput | undefined;
  Output?: StreamProcessorOutput | undefined;
  RoleArn?: string | undefined;
  Settings?: StreamProcessorSettings | undefined;
  NotificationChannel?: StreamProcessorNotificationChannel | undefined;
  KmsKeyId?: string | undefined;
  RegionsOfInterest?: RegionOfInterest[] | undefined;
  DataSharingPreference?: StreamProcessorDataSharingPreference | undefined;
}
export interface DetectCustomLabelsRequest {
  ProjectVersionArn: string | undefined;
  Image: Image | undefined;
  MaxResults?: number | undefined;
  MinConfidence?: number | undefined;
}
export interface DetectCustomLabelsResponse {
  CustomLabels?: CustomLabel[] | undefined;
}
export interface DetectFacesRequest {
  Image: Image | undefined;
  Attributes?: Attribute[] | undefined;
}
export interface DetectFacesResponse {
  FaceDetails?: FaceDetail[] | undefined;
  OrientationCorrection?: OrientationCorrection | undefined;
}
export interface DetectionFilter {
  MinConfidence?: number | undefined;
  MinBoundingBoxHeight?: number | undefined;
  MinBoundingBoxWidth?: number | undefined;
}
export interface GeneralLabelsSettings {
  LabelInclusionFilters?: string[] | undefined;
  LabelExclusionFilters?: string[] | undefined;
  LabelCategoryInclusionFilters?: string[] | undefined;
  LabelCategoryExclusionFilters?: string[] | undefined;
}
export interface DetectLabelsImagePropertiesSettings {
  MaxDominantColors?: number | undefined;
}
export interface DetectLabelsSettings {
  GeneralLabels?: GeneralLabelsSettings | undefined;
  ImageProperties?: DetectLabelsImagePropertiesSettings | undefined;
}
export interface DetectLabelsRequest {
  Image: Image | undefined;
  MaxLabels?: number | undefined;
  MinConfidence?: number | undefined;
  Features?: DetectLabelsFeatureName[] | undefined;
  Settings?: DetectLabelsSettings | undefined;
}
export interface DominantColor {
  Red?: number | undefined;
  Blue?: number | undefined;
  Green?: number | undefined;
  HexCode?: string | undefined;
  CSSColor?: string | undefined;
  SimplifiedColor?: string | undefined;
  PixelPercent?: number | undefined;
}
export interface DetectLabelsImageQuality {
  Brightness?: number | undefined;
  Sharpness?: number | undefined;
  Contrast?: number | undefined;
}
export interface DetectLabelsImageBackground {
  Quality?: DetectLabelsImageQuality | undefined;
  DominantColors?: DominantColor[] | undefined;
}
export interface DetectLabelsImageForeground {
  Quality?: DetectLabelsImageQuality | undefined;
  DominantColors?: DominantColor[] | undefined;
}
export interface DetectLabelsImageProperties {
  Quality?: DetectLabelsImageQuality | undefined;
  DominantColors?: DominantColor[] | undefined;
  Foreground?: DetectLabelsImageForeground | undefined;
  Background?: DetectLabelsImageBackground | undefined;
}
export interface LabelAlias {
  Name?: string | undefined;
}
export interface LabelCategory {
  Name?: string | undefined;
}
export interface Instance {
  BoundingBox?: BoundingBox | undefined;
  Confidence?: number | undefined;
  DominantColors?: DominantColor[] | undefined;
}
export interface Parent {
  Name?: string | undefined;
}
export interface Label {
  Name?: string | undefined;
  Confidence?: number | undefined;
  Instances?: Instance[] | undefined;
  Parents?: Parent[] | undefined;
  Aliases?: LabelAlias[] | undefined;
  Categories?: LabelCategory[] | undefined;
}
export interface DetectLabelsResponse {
  Labels?: Label[] | undefined;
  OrientationCorrection?: OrientationCorrection | undefined;
  LabelModelVersion?: string | undefined;
  ImageProperties?: DetectLabelsImageProperties | undefined;
}
export interface HumanLoopDataAttributes {
  ContentClassifiers?: ContentClassifier[] | undefined;
}
export interface HumanLoopConfig {
  HumanLoopName: string | undefined;
  FlowDefinitionArn: string | undefined;
  DataAttributes?: HumanLoopDataAttributes | undefined;
}
export interface DetectModerationLabelsRequest {
  Image: Image | undefined;
  MinConfidence?: number | undefined;
  HumanLoopConfig?: HumanLoopConfig | undefined;
  ProjectVersion?: string | undefined;
}
export interface HumanLoopActivationOutput {
  HumanLoopArn?: string | undefined;
  HumanLoopActivationReasons?: string[] | undefined;
  HumanLoopActivationConditionsEvaluationResults?:
    | __AutomaticJsonStringConversion
    | string
    | undefined;
}
export interface DetectModerationLabelsResponse {
  ModerationLabels?: ModerationLabel[] | undefined;
  ModerationModelVersion?: string | undefined;
  HumanLoopActivationOutput?: HumanLoopActivationOutput | undefined;
  ProjectVersion?: string | undefined;
  ContentTypes?: ContentType[] | undefined;
}
export interface ProtectiveEquipmentSummarizationAttributes {
  MinConfidence: number | undefined;
  RequiredEquipmentTypes: ProtectiveEquipmentType[] | undefined;
}
export interface DetectProtectiveEquipmentRequest {
  Image: Image | undefined;
  SummarizationAttributes?:
    | ProtectiveEquipmentSummarizationAttributes
    | undefined;
}
export interface ProtectiveEquipmentPerson {
  BodyParts?: ProtectiveEquipmentBodyPart[] | undefined;
  BoundingBox?: BoundingBox | undefined;
  Confidence?: number | undefined;
  Id?: number | undefined;
}
export interface ProtectiveEquipmentSummary {
  PersonsWithRequiredEquipment?: number[] | undefined;
  PersonsWithoutRequiredEquipment?: number[] | undefined;
  PersonsIndeterminate?: number[] | undefined;
}
export interface DetectProtectiveEquipmentResponse {
  ProtectiveEquipmentModelVersion?: string | undefined;
  Persons?: ProtectiveEquipmentPerson[] | undefined;
  Summary?: ProtectiveEquipmentSummary | undefined;
}
export interface DetectTextFilters {
  WordFilter?: DetectionFilter | undefined;
  RegionsOfInterest?: RegionOfInterest[] | undefined;
}
export interface DetectTextRequest {
  Image: Image | undefined;
  Filters?: DetectTextFilters | undefined;
}
export interface TextDetection {
  DetectedText?: string | undefined;
  Type?: TextTypes | undefined;
  Id?: number | undefined;
  ParentId?: number | undefined;
  Confidence?: number | undefined;
  Geometry?: Geometry | undefined;
}
export interface DetectTextResponse {
  TextDetections?: TextDetection[] | undefined;
  TextModelVersion?: string | undefined;
}
export interface DisassociatedFace {
  FaceId?: string | undefined;
}
export interface DisassociateFacesRequest {
  CollectionId: string | undefined;
  UserId: string | undefined;
  ClientRequestToken?: string | undefined;
  FaceIds: string[] | undefined;
}
export interface UnsuccessfulFaceDisassociation {
  FaceId?: string | undefined;
  UserId?: string | undefined;
  Reasons?: UnsuccessfulFaceDisassociationReason[] | undefined;
}
export interface DisassociateFacesResponse {
  DisassociatedFaces?: DisassociatedFace[] | undefined;
  UnsuccessfulFaceDisassociations?:
    | UnsuccessfulFaceDisassociation[]
    | undefined;
  UserStatus?: UserStatus | undefined;
}
export interface DistributeDataset {
  Arn: string | undefined;
}
export interface DistributeDatasetEntriesRequest {
  Datasets: DistributeDataset[] | undefined;
}
export interface DistributeDatasetEntriesResponse {}
export interface Face {
  FaceId?: string | undefined;
  BoundingBox?: BoundingBox | undefined;
  ImageId?: string | undefined;
  ExternalImageId?: string | undefined;
  Confidence?: number | undefined;
  IndexFacesModelVersion?: string | undefined;
  UserId?: string | undefined;
}
export interface FaceDetection {
  Timestamp?: number | undefined;
  Face?: FaceDetail | undefined;
}
export interface FaceMatch {
  Similarity?: number | undefined;
  Face?: Face | undefined;
}
export interface FaceRecord {
  Face?: Face | undefined;
  FaceDetail?: FaceDetail | undefined;
}
export interface GetCelebrityInfoRequest {
  Id: string | undefined;
}
export interface GetCelebrityInfoResponse {
  Urls?: string[] | undefined;
  Name?: string | undefined;
  KnownGender?: KnownGender | undefined;
}
export interface GetCelebrityRecognitionRequest {
  JobId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  SortBy?: CelebrityRecognitionSortBy | undefined;
}
export interface Video {
  S3Object?: S3Object | undefined;
}
export interface VideoMetadata {
  Codec?: string | undefined;
  DurationMillis?: number | undefined;
  Format?: string | undefined;
  FrameRate?: number | undefined;
  FrameHeight?: number | undefined;
  FrameWidth?: number | undefined;
  ColorRange?: VideoColorRange | undefined;
}
export interface GetCelebrityRecognitionResponse {
  JobStatus?: VideoJobStatus | undefined;
  StatusMessage?: string | undefined;
  VideoMetadata?: VideoMetadata | undefined;
  NextToken?: string | undefined;
  Celebrities?: CelebrityRecognition[] | undefined;
  JobId?: string | undefined;
  Video?: Video | undefined;
  JobTag?: string | undefined;
}
export interface GetContentModerationRequest {
  JobId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  SortBy?: ContentModerationSortBy | undefined;
  AggregateBy?: ContentModerationAggregateBy | undefined;
}
export interface GetContentModerationRequestMetadata {
  SortBy?: ContentModerationSortBy | undefined;
  AggregateBy?: ContentModerationAggregateBy | undefined;
}
export interface GetContentModerationResponse {
  JobStatus?: VideoJobStatus | undefined;
  StatusMessage?: string | undefined;
  VideoMetadata?: VideoMetadata | undefined;
  ModerationLabels?: ContentModerationDetection[] | undefined;
  NextToken?: string | undefined;
  ModerationModelVersion?: string | undefined;
  JobId?: string | undefined;
  Video?: Video | undefined;
  JobTag?: string | undefined;
  GetRequestMetadata?: GetContentModerationRequestMetadata | undefined;
}
export interface GetFaceDetectionRequest {
  JobId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface GetFaceDetectionResponse {
  JobStatus?: VideoJobStatus | undefined;
  StatusMessage?: string | undefined;
  VideoMetadata?: VideoMetadata | undefined;
  NextToken?: string | undefined;
  Faces?: FaceDetection[] | undefined;
  JobId?: string | undefined;
  Video?: Video | undefined;
  JobTag?: string | undefined;
}
export interface GetFaceLivenessSessionResultsRequest {
  SessionId: string | undefined;
}
export interface GetFaceLivenessSessionResultsResponse {
  SessionId: string | undefined;
  Status: LivenessSessionStatus | undefined;
  Confidence?: number | undefined;
  ReferenceImage?: AuditImage | undefined;
  AuditImages?: AuditImage[] | undefined;
  Challenge?: Challenge | undefined;
}
export interface GetFaceSearchRequest {
  JobId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  SortBy?: FaceSearchSortBy | undefined;
}
export interface PersonDetail {
  Index?: number | undefined;
  BoundingBox?: BoundingBox | undefined;
  Face?: FaceDetail | undefined;
}
export interface PersonMatch {
  Timestamp?: number | undefined;
  Person?: PersonDetail | undefined;
  FaceMatches?: FaceMatch[] | undefined;
}
export interface GetFaceSearchResponse {
  JobStatus?: VideoJobStatus | undefined;
  StatusMessage?: string | undefined;
  NextToken?: string | undefined;
  VideoMetadata?: VideoMetadata | undefined;
  Persons?: PersonMatch[] | undefined;
  JobId?: string | undefined;
  Video?: Video | undefined;
  JobTag?: string | undefined;
}
export interface GetLabelDetectionRequest {
  JobId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  SortBy?: LabelDetectionSortBy | undefined;
  AggregateBy?: LabelDetectionAggregateBy | undefined;
}
export interface GetLabelDetectionRequestMetadata {
  SortBy?: LabelDetectionSortBy | undefined;
  AggregateBy?: LabelDetectionAggregateBy | undefined;
}
export interface LabelDetection {
  Timestamp?: number | undefined;
  Label?: Label | undefined;
  StartTimestampMillis?: number | undefined;
  EndTimestampMillis?: number | undefined;
  DurationMillis?: number | undefined;
}
export interface GetLabelDetectionResponse {
  JobStatus?: VideoJobStatus | undefined;
  StatusMessage?: string | undefined;
  VideoMetadata?: VideoMetadata | undefined;
  NextToken?: string | undefined;
  Labels?: LabelDetection[] | undefined;
  LabelModelVersion?: string | undefined;
  JobId?: string | undefined;
  Video?: Video | undefined;
  JobTag?: string | undefined;
  GetRequestMetadata?: GetLabelDetectionRequestMetadata | undefined;
}
export interface GetMediaAnalysisJobRequest {
  JobId: string | undefined;
}
export interface MediaAnalysisJobFailureDetails {
  Code?: MediaAnalysisJobFailureCode | undefined;
  Message?: string | undefined;
}
export interface MediaAnalysisInput {
  S3Object: S3Object | undefined;
}
export interface MediaAnalysisManifestSummary {
  S3Object?: S3Object | undefined;
}
export interface MediaAnalysisDetectModerationLabelsConfig {
  MinConfidence?: number | undefined;
  ProjectVersion?: string | undefined;
}
export interface MediaAnalysisOperationsConfig {
  DetectModerationLabels?:
    | MediaAnalysisDetectModerationLabelsConfig
    | undefined;
}
export interface MediaAnalysisOutputConfig {
  S3Bucket: string | undefined;
  S3KeyPrefix?: string | undefined;
}
export interface MediaAnalysisModelVersions {
  Moderation?: string | undefined;
}
export interface MediaAnalysisResults {
  S3Object?: S3Object | undefined;
  ModelVersions?: MediaAnalysisModelVersions | undefined;
}
export interface GetMediaAnalysisJobResponse {
  JobId: string | undefined;
  JobName?: string | undefined;
  OperationsConfig: MediaAnalysisOperationsConfig | undefined;
  Status: MediaAnalysisJobStatus | undefined;
  FailureDetails?: MediaAnalysisJobFailureDetails | undefined;
  CreationTimestamp: Date | undefined;
  CompletionTimestamp?: Date | undefined;
  Input: MediaAnalysisInput | undefined;
  OutputConfig: MediaAnalysisOutputConfig | undefined;
  KmsKeyId?: string | undefined;
  Results?: MediaAnalysisResults | undefined;
  ManifestSummary?: MediaAnalysisManifestSummary | undefined;
}
export interface GetPersonTrackingRequest {
  JobId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  SortBy?: PersonTrackingSortBy | undefined;
}
export interface PersonDetection {
  Timestamp?: number | undefined;
  Person?: PersonDetail | undefined;
}
export interface GetPersonTrackingResponse {
  JobStatus?: VideoJobStatus | undefined;
  StatusMessage?: string | undefined;
  VideoMetadata?: VideoMetadata | undefined;
  NextToken?: string | undefined;
  Persons?: PersonDetection[] | undefined;
  JobId?: string | undefined;
  Video?: Video | undefined;
  JobTag?: string | undefined;
}
export interface GetSegmentDetectionRequest {
  JobId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ShotSegment {
  Index?: number | undefined;
  Confidence?: number | undefined;
}
export interface TechnicalCueSegment {
  Type?: TechnicalCueType | undefined;
  Confidence?: number | undefined;
}
export interface SegmentDetection {
  Type?: SegmentType | undefined;
  StartTimestampMillis?: number | undefined;
  EndTimestampMillis?: number | undefined;
  DurationMillis?: number | undefined;
  StartTimecodeSMPTE?: string | undefined;
  EndTimecodeSMPTE?: string | undefined;
  DurationSMPTE?: string | undefined;
  TechnicalCueSegment?: TechnicalCueSegment | undefined;
  ShotSegment?: ShotSegment | undefined;
  StartFrameNumber?: number | undefined;
  EndFrameNumber?: number | undefined;
  DurationFrames?: number | undefined;
}
export interface SegmentTypeInfo {
  Type?: SegmentType | undefined;
  ModelVersion?: string | undefined;
}
export interface GetSegmentDetectionResponse {
  JobStatus?: VideoJobStatus | undefined;
  StatusMessage?: string | undefined;
  VideoMetadata?: VideoMetadata[] | undefined;
  AudioMetadata?: AudioMetadata[] | undefined;
  NextToken?: string | undefined;
  Segments?: SegmentDetection[] | undefined;
  SelectedSegmentTypes?: SegmentTypeInfo[] | undefined;
  JobId?: string | undefined;
  Video?: Video | undefined;
  JobTag?: string | undefined;
}
export interface GetTextDetectionRequest {
  JobId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface TextDetectionResult {
  Timestamp?: number | undefined;
  TextDetection?: TextDetection | undefined;
}
export interface GetTextDetectionResponse {
  JobStatus?: VideoJobStatus | undefined;
  StatusMessage?: string | undefined;
  VideoMetadata?: VideoMetadata | undefined;
  TextDetections?: TextDetectionResult[] | undefined;
  NextToken?: string | undefined;
  TextModelVersion?: string | undefined;
  JobId?: string | undefined;
  Video?: Video | undefined;
  JobTag?: string | undefined;
}
export interface IndexFacesRequest {
  CollectionId: string | undefined;
  Image: Image | undefined;
  ExternalImageId?: string | undefined;
  DetectionAttributes?: Attribute[] | undefined;
  MaxFaces?: number | undefined;
  QualityFilter?: QualityFilter | undefined;
}
export interface UnindexedFace {
  Reasons?: Reason[] | undefined;
  FaceDetail?: FaceDetail | undefined;
}
export interface IndexFacesResponse {
  FaceRecords?: FaceRecord[] | undefined;
  OrientationCorrection?: OrientationCorrection | undefined;
  FaceModelVersion?: string | undefined;
  UnindexedFaces?: UnindexedFace[] | undefined;
}
export interface KinesisVideoStreamStartSelector {
  ProducerTimestamp?: number | undefined;
  FragmentNumber?: string | undefined;
}
export interface LabelDetectionSettings {
  GeneralLabels?: GeneralLabelsSettings | undefined;
}
export interface ListCollectionsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListCollectionsResponse {
  CollectionIds?: string[] | undefined;
  NextToken?: string | undefined;
  FaceModelVersions?: string[] | undefined;
}
export interface ListDatasetEntriesRequest {
  DatasetArn: string | undefined;
  ContainsLabels?: string[] | undefined;
  Labeled?: boolean | undefined;
  SourceRefContains?: string | undefined;
  HasErrors?: boolean | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListDatasetEntriesResponse {
  DatasetEntries?: string[] | undefined;
  NextToken?: string | undefined;
}
export interface ListDatasetLabelsRequest {
  DatasetArn: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListDatasetLabelsResponse {
  DatasetLabelDescriptions?: DatasetLabelDescription[] | undefined;
  NextToken?: string | undefined;
}
export interface ListFacesRequest {
  CollectionId: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  UserId?: string | undefined;
  FaceIds?: string[] | undefined;
}
export interface ListFacesResponse {
  Faces?: Face[] | undefined;
  NextToken?: string | undefined;
  FaceModelVersion?: string | undefined;
}
export interface ListMediaAnalysisJobsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface MediaAnalysisJobDescription {
  JobId: string | undefined;
  JobName?: string | undefined;
  OperationsConfig: MediaAnalysisOperationsConfig | undefined;
  Status: MediaAnalysisJobStatus | undefined;
  FailureDetails?: MediaAnalysisJobFailureDetails | undefined;
  CreationTimestamp: Date | undefined;
  CompletionTimestamp?: Date | undefined;
  Input: MediaAnalysisInput | undefined;
  OutputConfig: MediaAnalysisOutputConfig | undefined;
  KmsKeyId?: string | undefined;
  Results?: MediaAnalysisResults | undefined;
  ManifestSummary?: MediaAnalysisManifestSummary | undefined;
}
export interface ListMediaAnalysisJobsResponse {
  NextToken?: string | undefined;
  MediaAnalysisJobs: MediaAnalysisJobDescription[] | undefined;
}
export interface ListProjectPoliciesRequest {
  ProjectArn: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ProjectPolicy {
  ProjectArn?: string | undefined;
  PolicyName?: string | undefined;
  PolicyRevisionId?: string | undefined;
  PolicyDocument?: string | undefined;
  CreationTimestamp?: Date | undefined;
  LastUpdatedTimestamp?: Date | undefined;
}
export interface ListProjectPoliciesResponse {
  ProjectPolicies?: ProjectPolicy[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStreamProcessorsRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface StreamProcessor {
  Name?: string | undefined;
  Status?: StreamProcessorStatus | undefined;
}
export interface ListStreamProcessorsResponse {
  NextToken?: string | undefined;
  StreamProcessors?: StreamProcessor[] | undefined;
}
export interface ListTagsForResourceRequest {
  ResourceArn: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags?: Record<string, string> | undefined;
}
export interface ListUsersRequest {
  CollectionId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface User {
  UserId?: string | undefined;
  UserStatus?: UserStatus | undefined;
}
export interface ListUsersResponse {
  Users?: User[] | undefined;
  NextToken?: string | undefined;
}
export interface MatchedUser {
  UserId?: string | undefined;
  UserStatus?: UserStatus | undefined;
}
export interface NotificationChannel {
  SNSTopicArn: string | undefined;
  RoleArn: string | undefined;
}
export interface PutProjectPolicyRequest {
  ProjectArn: string | undefined;
  PolicyName: string | undefined;
  PolicyRevisionId?: string | undefined;
  PolicyDocument: string | undefined;
}
export interface PutProjectPolicyResponse {
  PolicyRevisionId?: string | undefined;
}
export interface RecognizeCelebritiesRequest {
  Image: Image | undefined;
}
export interface RecognizeCelebritiesResponse {
  CelebrityFaces?: Celebrity[] | undefined;
  UnrecognizedFaces?: ComparedFace[] | undefined;
  OrientationCorrection?: OrientationCorrection | undefined;
}
export interface SearchFacesRequest {
  CollectionId: string | undefined;
  FaceId: string | undefined;
  MaxFaces?: number | undefined;
  FaceMatchThreshold?: number | undefined;
}
export interface SearchFacesResponse {
  SearchedFaceId?: string | undefined;
  FaceMatches?: FaceMatch[] | undefined;
  FaceModelVersion?: string | undefined;
}
export interface SearchFacesByImageRequest {
  CollectionId: string | undefined;
  Image: Image | undefined;
  MaxFaces?: number | undefined;
  FaceMatchThreshold?: number | undefined;
  QualityFilter?: QualityFilter | undefined;
}
export interface SearchFacesByImageResponse {
  SearchedFaceBoundingBox?: BoundingBox | undefined;
  SearchedFaceConfidence?: number | undefined;
  FaceMatches?: FaceMatch[] | undefined;
  FaceModelVersion?: string | undefined;
}
export interface SearchUsersRequest {
  CollectionId: string | undefined;
  UserId?: string | undefined;
  FaceId?: string | undefined;
  UserMatchThreshold?: number | undefined;
  MaxUsers?: number | undefined;
}
export interface SearchedFace {
  FaceId?: string | undefined;
}
export interface SearchedUser {
  UserId?: string | undefined;
}
export interface UserMatch {
  Similarity?: number | undefined;
  User?: MatchedUser | undefined;
}
export interface SearchUsersResponse {
  UserMatches?: UserMatch[] | undefined;
  FaceModelVersion?: string | undefined;
  SearchedFace?: SearchedFace | undefined;
  SearchedUser?: SearchedUser | undefined;
}
export interface SearchUsersByImageRequest {
  CollectionId: string | undefined;
  Image: Image | undefined;
  UserMatchThreshold?: number | undefined;
  MaxUsers?: number | undefined;
  QualityFilter?: QualityFilter | undefined;
}
export interface SearchedFaceDetails {
  FaceDetail?: FaceDetail | undefined;
}
export interface UnsearchedFace {
  FaceDetails?: FaceDetail | undefined;
  Reasons?: UnsearchedFaceReason[] | undefined;
}
export interface SearchUsersByImageResponse {
  UserMatches?: UserMatch[] | undefined;
  FaceModelVersion?: string | undefined;
  SearchedFace?: SearchedFaceDetails | undefined;
  UnsearchedFaces?: UnsearchedFace[] | undefined;
}
export interface StartCelebrityRecognitionRequest {
  Video: Video | undefined;
  ClientRequestToken?: string | undefined;
  NotificationChannel?: NotificationChannel | undefined;
  JobTag?: string | undefined;
}
export interface StartCelebrityRecognitionResponse {
  JobId?: string | undefined;
}
export interface StartContentModerationRequest {
  Video: Video | undefined;
  MinConfidence?: number | undefined;
  ClientRequestToken?: string | undefined;
  NotificationChannel?: NotificationChannel | undefined;
  JobTag?: string | undefined;
}
export interface StartContentModerationResponse {
  JobId?: string | undefined;
}
export interface StartFaceDetectionRequest {
  Video: Video | undefined;
  ClientRequestToken?: string | undefined;
  NotificationChannel?: NotificationChannel | undefined;
  FaceAttributes?: FaceAttributes | undefined;
  JobTag?: string | undefined;
}
export interface StartFaceDetectionResponse {
  JobId?: string | undefined;
}
export interface StartFaceSearchRequest {
  Video: Video | undefined;
  ClientRequestToken?: string | undefined;
  FaceMatchThreshold?: number | undefined;
  CollectionId: string | undefined;
  NotificationChannel?: NotificationChannel | undefined;
  JobTag?: string | undefined;
}
export interface StartFaceSearchResponse {
  JobId?: string | undefined;
}
export interface StartLabelDetectionRequest {
  Video: Video | undefined;
  ClientRequestToken?: string | undefined;
  MinConfidence?: number | undefined;
  NotificationChannel?: NotificationChannel | undefined;
  JobTag?: string | undefined;
  Features?: LabelDetectionFeatureName[] | undefined;
  Settings?: LabelDetectionSettings | undefined;
}
export interface StartLabelDetectionResponse {
  JobId?: string | undefined;
}
export interface StartMediaAnalysisJobRequest {
  ClientRequestToken?: string | undefined;
  JobName?: string | undefined;
  OperationsConfig: MediaAnalysisOperationsConfig | undefined;
  Input: MediaAnalysisInput | undefined;
  OutputConfig: MediaAnalysisOutputConfig | undefined;
  KmsKeyId?: string | undefined;
}
export interface StartMediaAnalysisJobResponse {
  JobId: string | undefined;
}
export interface StartPersonTrackingRequest {
  Video: Video | undefined;
  ClientRequestToken?: string | undefined;
  NotificationChannel?: NotificationChannel | undefined;
  JobTag?: string | undefined;
}
export interface StartPersonTrackingResponse {
  JobId?: string | undefined;
}
export interface StartProjectVersionRequest {
  ProjectVersionArn: string | undefined;
  MinInferenceUnits: number | undefined;
  MaxInferenceUnits?: number | undefined;
}
export interface StartProjectVersionResponse {
  Status?: ProjectVersionStatus | undefined;
}
export interface StartShotDetectionFilter {
  MinSegmentConfidence?: number | undefined;
}
export interface StartTechnicalCueDetectionFilter {
  MinSegmentConfidence?: number | undefined;
  BlackFrame?: BlackFrame | undefined;
}
export interface StartSegmentDetectionFilters {
  TechnicalCueFilter?: StartTechnicalCueDetectionFilter | undefined;
  ShotFilter?: StartShotDetectionFilter | undefined;
}
export interface StartSegmentDetectionRequest {
  Video: Video | undefined;
  ClientRequestToken?: string | undefined;
  NotificationChannel?: NotificationChannel | undefined;
  JobTag?: string | undefined;
  Filters?: StartSegmentDetectionFilters | undefined;
  SegmentTypes: SegmentType[] | undefined;
}
export interface StartSegmentDetectionResponse {
  JobId?: string | undefined;
}
export interface StreamProcessingStartSelector {
  KVSStreamStartSelector?: KinesisVideoStreamStartSelector | undefined;
}
export interface StreamProcessingStopSelector {
  MaxDurationInSeconds?: number | undefined;
}
export interface StartStreamProcessorRequest {
  Name: string | undefined;
  StartSelector?: StreamProcessingStartSelector | undefined;
  StopSelector?: StreamProcessingStopSelector | undefined;
}
export interface StartStreamProcessorResponse {
  SessionId?: string | undefined;
}
export interface StartTextDetectionFilters {
  WordFilter?: DetectionFilter | undefined;
  RegionsOfInterest?: RegionOfInterest[] | undefined;
}
export interface StartTextDetectionRequest {
  Video: Video | undefined;
  ClientRequestToken?: string | undefined;
  NotificationChannel?: NotificationChannel | undefined;
  JobTag?: string | undefined;
  Filters?: StartTextDetectionFilters | undefined;
}
export interface StartTextDetectionResponse {
  JobId?: string | undefined;
}
export interface StopProjectVersionRequest {
  ProjectVersionArn: string | undefined;
}
export interface StopProjectVersionResponse {
  Status?: ProjectVersionStatus | undefined;
}
export interface StopStreamProcessorRequest {
  Name: string | undefined;
}
export interface StopStreamProcessorResponse {}
export interface TagResourceRequest {
  ResourceArn: string | undefined;
  Tags: Record<string, string> | undefined;
}
export interface TagResourceResponse {}
export interface UntagResourceRequest {
  ResourceArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagResourceResponse {}
export interface UpdateDatasetEntriesRequest {
  DatasetArn: string | undefined;
  Changes: DatasetChanges | undefined;
}
export interface UpdateDatasetEntriesResponse {}
export interface StreamProcessorSettingsForUpdate {
  ConnectedHomeForUpdate?: ConnectedHomeSettingsForUpdate | undefined;
}
export interface UpdateStreamProcessorRequest {
  Name: string | undefined;
  SettingsForUpdate?: StreamProcessorSettingsForUpdate | undefined;
  RegionsOfInterestForUpdate?: RegionOfInterest[] | undefined;
  DataSharingPreferenceForUpdate?:
    | StreamProcessorDataSharingPreference
    | undefined;
  ParametersToDelete?: StreamProcessorParameterToDelete[] | undefined;
}
export interface UpdateStreamProcessorResponse {}
