// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import type {protobuf as $protobuf} from "google-gax";
import Long = require("long");
/** Namespace google. */
export namespace google {

    /** Namespace cloud. */
    namespace cloud {

        /** Namespace vision. */
        namespace vision {

            /** Namespace v1. */
            namespace v1 {

                /** Properties of a Vertex. */
                interface IVertex {

                    /** Vertex x */
                    x?: (number|null);

                    /** Vertex y */
                    y?: (number|null);
                }

                /** Represents a Vertex. */
                class Vertex implements IVertex {

                    /**
                     * Constructs a new Vertex.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IVertex);

                    /** Vertex x. */
                    public x: number;

                    /** Vertex y. */
                    public y: number;

                    /**
                     * Creates a new Vertex instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Vertex instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IVertex): google.cloud.vision.v1.Vertex;

                    /**
                     * Encodes the specified Vertex message. Does not implicitly {@link google.cloud.vision.v1.Vertex.verify|verify} messages.
                     * @param message Vertex message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IVertex, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Vertex message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Vertex.verify|verify} messages.
                     * @param message Vertex message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IVertex, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Vertex message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Vertex
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Vertex;

                    /**
                     * Decodes a Vertex message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Vertex
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Vertex;

                    /**
                     * Verifies a Vertex message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Vertex message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Vertex
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Vertex;

                    /**
                     * Creates a plain object from a Vertex message. Also converts values to other types if specified.
                     * @param message Vertex
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Vertex, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Vertex to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Vertex
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a NormalizedVertex. */
                interface INormalizedVertex {

                    /** NormalizedVertex x */
                    x?: (number|null);

                    /** NormalizedVertex y */
                    y?: (number|null);
                }

                /** Represents a NormalizedVertex. */
                class NormalizedVertex implements INormalizedVertex {

                    /**
                     * Constructs a new NormalizedVertex.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.INormalizedVertex);

                    /** NormalizedVertex x. */
                    public x: number;

                    /** NormalizedVertex y. */
                    public y: number;

                    /**
                     * Creates a new NormalizedVertex instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns NormalizedVertex instance
                     */
                    public static create(properties?: google.cloud.vision.v1.INormalizedVertex): google.cloud.vision.v1.NormalizedVertex;

                    /**
                     * Encodes the specified NormalizedVertex message. Does not implicitly {@link google.cloud.vision.v1.NormalizedVertex.verify|verify} messages.
                     * @param message NormalizedVertex message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.INormalizedVertex, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified NormalizedVertex message, length delimited. Does not implicitly {@link google.cloud.vision.v1.NormalizedVertex.verify|verify} messages.
                     * @param message NormalizedVertex message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.INormalizedVertex, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a NormalizedVertex message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns NormalizedVertex
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.NormalizedVertex;

                    /**
                     * Decodes a NormalizedVertex message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns NormalizedVertex
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.NormalizedVertex;

                    /**
                     * Verifies a NormalizedVertex message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a NormalizedVertex message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns NormalizedVertex
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.NormalizedVertex;

                    /**
                     * Creates a plain object from a NormalizedVertex message. Also converts values to other types if specified.
                     * @param message NormalizedVertex
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.NormalizedVertex, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this NormalizedVertex to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for NormalizedVertex
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BoundingPoly. */
                interface IBoundingPoly {

                    /** BoundingPoly vertices */
                    vertices?: (google.cloud.vision.v1.IVertex[]|null);

                    /** BoundingPoly normalizedVertices */
                    normalizedVertices?: (google.cloud.vision.v1.INormalizedVertex[]|null);
                }

                /** Represents a BoundingPoly. */
                class BoundingPoly implements IBoundingPoly {

                    /**
                     * Constructs a new BoundingPoly.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IBoundingPoly);

                    /** BoundingPoly vertices. */
                    public vertices: google.cloud.vision.v1.IVertex[];

                    /** BoundingPoly normalizedVertices. */
                    public normalizedVertices: google.cloud.vision.v1.INormalizedVertex[];

                    /**
                     * Creates a new BoundingPoly instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BoundingPoly instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IBoundingPoly): google.cloud.vision.v1.BoundingPoly;

                    /**
                     * Encodes the specified BoundingPoly message. Does not implicitly {@link google.cloud.vision.v1.BoundingPoly.verify|verify} messages.
                     * @param message BoundingPoly message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IBoundingPoly, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BoundingPoly message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BoundingPoly.verify|verify} messages.
                     * @param message BoundingPoly message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IBoundingPoly, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BoundingPoly message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BoundingPoly
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.BoundingPoly;

                    /**
                     * Decodes a BoundingPoly message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BoundingPoly
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.BoundingPoly;

                    /**
                     * Verifies a BoundingPoly message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BoundingPoly message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BoundingPoly
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.BoundingPoly;

                    /**
                     * Creates a plain object from a BoundingPoly message. Also converts values to other types if specified.
                     * @param message BoundingPoly
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.BoundingPoly, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BoundingPoly to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BoundingPoly
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Position. */
                interface IPosition {

                    /** Position x */
                    x?: (number|null);

                    /** Position y */
                    y?: (number|null);

                    /** Position z */
                    z?: (number|null);
                }

                /** Represents a Position. */
                class Position implements IPosition {

                    /**
                     * Constructs a new Position.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IPosition);

                    /** Position x. */
                    public x: number;

                    /** Position y. */
                    public y: number;

                    /** Position z. */
                    public z: number;

                    /**
                     * Creates a new Position instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Position instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IPosition): google.cloud.vision.v1.Position;

                    /**
                     * Encodes the specified Position message. Does not implicitly {@link google.cloud.vision.v1.Position.verify|verify} messages.
                     * @param message Position message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IPosition, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Position message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Position.verify|verify} messages.
                     * @param message Position message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IPosition, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Position message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Position
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Position;

                    /**
                     * Decodes a Position message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Position
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Position;

                    /**
                     * Verifies a Position message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Position message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Position
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Position;

                    /**
                     * Creates a plain object from a Position message. Also converts values to other types if specified.
                     * @param message Position
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Position, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Position to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Position
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Represents an ImageAnnotator */
                class ImageAnnotator extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new ImageAnnotator service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new ImageAnnotator service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): ImageAnnotator;

                    /**
                     * Calls BatchAnnotateImages.
                     * @param request BatchAnnotateImagesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and BatchAnnotateImagesResponse
                     */
                    public batchAnnotateImages(request: google.cloud.vision.v1.IBatchAnnotateImagesRequest, callback: google.cloud.vision.v1.ImageAnnotator.BatchAnnotateImagesCallback): void;

                    /**
                     * Calls BatchAnnotateImages.
                     * @param request BatchAnnotateImagesRequest message or plain object
                     * @returns Promise
                     */
                    public batchAnnotateImages(request: google.cloud.vision.v1.IBatchAnnotateImagesRequest): Promise<google.cloud.vision.v1.BatchAnnotateImagesResponse>;

                    /**
                     * Calls BatchAnnotateFiles.
                     * @param request BatchAnnotateFilesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and BatchAnnotateFilesResponse
                     */
                    public batchAnnotateFiles(request: google.cloud.vision.v1.IBatchAnnotateFilesRequest, callback: google.cloud.vision.v1.ImageAnnotator.BatchAnnotateFilesCallback): void;

                    /**
                     * Calls BatchAnnotateFiles.
                     * @param request BatchAnnotateFilesRequest message or plain object
                     * @returns Promise
                     */
                    public batchAnnotateFiles(request: google.cloud.vision.v1.IBatchAnnotateFilesRequest): Promise<google.cloud.vision.v1.BatchAnnotateFilesResponse>;

                    /**
                     * Calls AsyncBatchAnnotateImages.
                     * @param request AsyncBatchAnnotateImagesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public asyncBatchAnnotateImages(request: google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest, callback: google.cloud.vision.v1.ImageAnnotator.AsyncBatchAnnotateImagesCallback): void;

                    /**
                     * Calls AsyncBatchAnnotateImages.
                     * @param request AsyncBatchAnnotateImagesRequest message or plain object
                     * @returns Promise
                     */
                    public asyncBatchAnnotateImages(request: google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls AsyncBatchAnnotateFiles.
                     * @param request AsyncBatchAnnotateFilesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public asyncBatchAnnotateFiles(request: google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest, callback: google.cloud.vision.v1.ImageAnnotator.AsyncBatchAnnotateFilesCallback): void;

                    /**
                     * Calls AsyncBatchAnnotateFiles.
                     * @param request AsyncBatchAnnotateFilesRequest message or plain object
                     * @returns Promise
                     */
                    public asyncBatchAnnotateFiles(request: google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest): Promise<google.longrunning.Operation>;
                }

                namespace ImageAnnotator {

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ImageAnnotator|batchAnnotateImages}.
                     * @param error Error, if any
                     * @param [response] BatchAnnotateImagesResponse
                     */
                    type BatchAnnotateImagesCallback = (error: (Error|null), response?: google.cloud.vision.v1.BatchAnnotateImagesResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ImageAnnotator|batchAnnotateFiles}.
                     * @param error Error, if any
                     * @param [response] BatchAnnotateFilesResponse
                     */
                    type BatchAnnotateFilesCallback = (error: (Error|null), response?: google.cloud.vision.v1.BatchAnnotateFilesResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ImageAnnotator|asyncBatchAnnotateImages}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type AsyncBatchAnnotateImagesCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ImageAnnotator|asyncBatchAnnotateFiles}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type AsyncBatchAnnotateFilesCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;
                }

                /** Likelihood enum. */
                enum Likelihood {
                    UNKNOWN = 0,
                    VERY_UNLIKELY = 1,
                    UNLIKELY = 2,
                    POSSIBLE = 3,
                    LIKELY = 4,
                    VERY_LIKELY = 5
                }

                /** Properties of a Feature. */
                interface IFeature {

                    /** Feature type */
                    type?: (google.cloud.vision.v1.Feature.Type|keyof typeof google.cloud.vision.v1.Feature.Type|null);

                    /** Feature maxResults */
                    maxResults?: (number|null);

                    /** Feature model */
                    model?: (string|null);
                }

                /** Represents a Feature. */
                class Feature implements IFeature {

                    /**
                     * Constructs a new Feature.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IFeature);

                    /** Feature type. */
                    public type: (google.cloud.vision.v1.Feature.Type|keyof typeof google.cloud.vision.v1.Feature.Type);

                    /** Feature maxResults. */
                    public maxResults: number;

                    /** Feature model. */
                    public model: string;

                    /**
                     * Creates a new Feature instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Feature instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IFeature): google.cloud.vision.v1.Feature;

                    /**
                     * Encodes the specified Feature message. Does not implicitly {@link google.cloud.vision.v1.Feature.verify|verify} messages.
                     * @param message Feature message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IFeature, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Feature message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Feature.verify|verify} messages.
                     * @param message Feature message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IFeature, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Feature message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Feature
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Feature;

                    /**
                     * Decodes a Feature message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Feature
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Feature;

                    /**
                     * Verifies a Feature message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Feature message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Feature
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Feature;

                    /**
                     * Creates a plain object from a Feature message. Also converts values to other types if specified.
                     * @param message Feature
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Feature, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Feature to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Feature
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace Feature {

                    /** Type enum. */
                    enum Type {
                        TYPE_UNSPECIFIED = 0,
                        FACE_DETECTION = 1,
                        LANDMARK_DETECTION = 2,
                        LOGO_DETECTION = 3,
                        LABEL_DETECTION = 4,
                        TEXT_DETECTION = 5,
                        DOCUMENT_TEXT_DETECTION = 11,
                        SAFE_SEARCH_DETECTION = 6,
                        IMAGE_PROPERTIES = 7,
                        CROP_HINTS = 9,
                        WEB_DETECTION = 10,
                        PRODUCT_SEARCH = 12,
                        OBJECT_LOCALIZATION = 19
                    }
                }

                /** Properties of an ImageSource. */
                interface IImageSource {

                    /** ImageSource gcsImageUri */
                    gcsImageUri?: (string|null);

                    /** ImageSource imageUri */
                    imageUri?: (string|null);
                }

                /** Represents an ImageSource. */
                class ImageSource implements IImageSource {

                    /**
                     * Constructs a new ImageSource.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IImageSource);

                    /** ImageSource gcsImageUri. */
                    public gcsImageUri: string;

                    /** ImageSource imageUri. */
                    public imageUri: string;

                    /**
                     * Creates a new ImageSource instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageSource instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IImageSource): google.cloud.vision.v1.ImageSource;

                    /**
                     * Encodes the specified ImageSource message. Does not implicitly {@link google.cloud.vision.v1.ImageSource.verify|verify} messages.
                     * @param message ImageSource message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IImageSource, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageSource message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImageSource.verify|verify} messages.
                     * @param message ImageSource message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IImageSource, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageSource message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageSource
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ImageSource;

                    /**
                     * Decodes an ImageSource message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageSource
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ImageSource;

                    /**
                     * Verifies an ImageSource message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageSource message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageSource
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ImageSource;

                    /**
                     * Creates a plain object from an ImageSource message. Also converts values to other types if specified.
                     * @param message ImageSource
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ImageSource, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageSource to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageSource
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an Image. */
                interface IImage {

                    /** Image content */
                    content?: (Uint8Array|Buffer|string|null);

                    /** Image source */
                    source?: (google.cloud.vision.v1.IImageSource|null);
                }

                /** Represents an Image. */
                class Image implements IImage {

                    /**
                     * Constructs a new Image.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IImage);

                    /** Image content. */
                    public content: (Uint8Array|Buffer|string);

                    /** Image source. */
                    public source?: (google.cloud.vision.v1.IImageSource|null);

                    /**
                     * Creates a new Image instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Image instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IImage): google.cloud.vision.v1.Image;

                    /**
                     * Encodes the specified Image message. Does not implicitly {@link google.cloud.vision.v1.Image.verify|verify} messages.
                     * @param message Image message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IImage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Image message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Image.verify|verify} messages.
                     * @param message Image message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IImage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an Image message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Image
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Image;

                    /**
                     * Decodes an Image message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Image
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Image;

                    /**
                     * Verifies an Image message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an Image message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Image
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Image;

                    /**
                     * Creates a plain object from an Image message. Also converts values to other types if specified.
                     * @param message Image
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Image, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Image to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Image
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a FaceAnnotation. */
                interface IFaceAnnotation {

                    /** FaceAnnotation boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** FaceAnnotation fdBoundingPoly */
                    fdBoundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** FaceAnnotation landmarks */
                    landmarks?: (google.cloud.vision.v1.FaceAnnotation.ILandmark[]|null);

                    /** FaceAnnotation rollAngle */
                    rollAngle?: (number|null);

                    /** FaceAnnotation panAngle */
                    panAngle?: (number|null);

                    /** FaceAnnotation tiltAngle */
                    tiltAngle?: (number|null);

                    /** FaceAnnotation detectionConfidence */
                    detectionConfidence?: (number|null);

                    /** FaceAnnotation landmarkingConfidence */
                    landmarkingConfidence?: (number|null);

                    /** FaceAnnotation joyLikelihood */
                    joyLikelihood?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);

                    /** FaceAnnotation sorrowLikelihood */
                    sorrowLikelihood?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);

                    /** FaceAnnotation angerLikelihood */
                    angerLikelihood?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);

                    /** FaceAnnotation surpriseLikelihood */
                    surpriseLikelihood?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);

                    /** FaceAnnotation underExposedLikelihood */
                    underExposedLikelihood?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);

                    /** FaceAnnotation blurredLikelihood */
                    blurredLikelihood?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);

                    /** FaceAnnotation headwearLikelihood */
                    headwearLikelihood?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);
                }

                /** Represents a FaceAnnotation. */
                class FaceAnnotation implements IFaceAnnotation {

                    /**
                     * Constructs a new FaceAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IFaceAnnotation);

                    /** FaceAnnotation boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** FaceAnnotation fdBoundingPoly. */
                    public fdBoundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** FaceAnnotation landmarks. */
                    public landmarks: google.cloud.vision.v1.FaceAnnotation.ILandmark[];

                    /** FaceAnnotation rollAngle. */
                    public rollAngle: number;

                    /** FaceAnnotation panAngle. */
                    public panAngle: number;

                    /** FaceAnnotation tiltAngle. */
                    public tiltAngle: number;

                    /** FaceAnnotation detectionConfidence. */
                    public detectionConfidence: number;

                    /** FaceAnnotation landmarkingConfidence. */
                    public landmarkingConfidence: number;

                    /** FaceAnnotation joyLikelihood. */
                    public joyLikelihood: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /** FaceAnnotation sorrowLikelihood. */
                    public sorrowLikelihood: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /** FaceAnnotation angerLikelihood. */
                    public angerLikelihood: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /** FaceAnnotation surpriseLikelihood. */
                    public surpriseLikelihood: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /** FaceAnnotation underExposedLikelihood. */
                    public underExposedLikelihood: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /** FaceAnnotation blurredLikelihood. */
                    public blurredLikelihood: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /** FaceAnnotation headwearLikelihood. */
                    public headwearLikelihood: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /**
                     * Creates a new FaceAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns FaceAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IFaceAnnotation): google.cloud.vision.v1.FaceAnnotation;

                    /**
                     * Encodes the specified FaceAnnotation message. Does not implicitly {@link google.cloud.vision.v1.FaceAnnotation.verify|verify} messages.
                     * @param message FaceAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IFaceAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified FaceAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.FaceAnnotation.verify|verify} messages.
                     * @param message FaceAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IFaceAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a FaceAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns FaceAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.FaceAnnotation;

                    /**
                     * Decodes a FaceAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns FaceAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.FaceAnnotation;

                    /**
                     * Verifies a FaceAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a FaceAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns FaceAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.FaceAnnotation;

                    /**
                     * Creates a plain object from a FaceAnnotation message. Also converts values to other types if specified.
                     * @param message FaceAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.FaceAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this FaceAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for FaceAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace FaceAnnotation {

                    /** Properties of a Landmark. */
                    interface ILandmark {

                        /** Landmark type */
                        type?: (google.cloud.vision.v1.FaceAnnotation.Landmark.Type|keyof typeof google.cloud.vision.v1.FaceAnnotation.Landmark.Type|null);

                        /** Landmark position */
                        position?: (google.cloud.vision.v1.IPosition|null);
                    }

                    /** Represents a Landmark. */
                    class Landmark implements ILandmark {

                        /**
                         * Constructs a new Landmark.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.FaceAnnotation.ILandmark);

                        /** Landmark type. */
                        public type: (google.cloud.vision.v1.FaceAnnotation.Landmark.Type|keyof typeof google.cloud.vision.v1.FaceAnnotation.Landmark.Type);

                        /** Landmark position. */
                        public position?: (google.cloud.vision.v1.IPosition|null);

                        /**
                         * Creates a new Landmark instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Landmark instance
                         */
                        public static create(properties?: google.cloud.vision.v1.FaceAnnotation.ILandmark): google.cloud.vision.v1.FaceAnnotation.Landmark;

                        /**
                         * Encodes the specified Landmark message. Does not implicitly {@link google.cloud.vision.v1.FaceAnnotation.Landmark.verify|verify} messages.
                         * @param message Landmark message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.FaceAnnotation.ILandmark, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Landmark message, length delimited. Does not implicitly {@link google.cloud.vision.v1.FaceAnnotation.Landmark.verify|verify} messages.
                         * @param message Landmark message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.FaceAnnotation.ILandmark, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Landmark message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Landmark
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.FaceAnnotation.Landmark;

                        /**
                         * Decodes a Landmark message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Landmark
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.FaceAnnotation.Landmark;

                        /**
                         * Verifies a Landmark message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Landmark message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Landmark
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.FaceAnnotation.Landmark;

                        /**
                         * Creates a plain object from a Landmark message. Also converts values to other types if specified.
                         * @param message Landmark
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.FaceAnnotation.Landmark, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Landmark to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for Landmark
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace Landmark {

                        /** Type enum. */
                        enum Type {
                            UNKNOWN_LANDMARK = 0,
                            LEFT_EYE = 1,
                            RIGHT_EYE = 2,
                            LEFT_OF_LEFT_EYEBROW = 3,
                            RIGHT_OF_LEFT_EYEBROW = 4,
                            LEFT_OF_RIGHT_EYEBROW = 5,
                            RIGHT_OF_RIGHT_EYEBROW = 6,
                            MIDPOINT_BETWEEN_EYES = 7,
                            NOSE_TIP = 8,
                            UPPER_LIP = 9,
                            LOWER_LIP = 10,
                            MOUTH_LEFT = 11,
                            MOUTH_RIGHT = 12,
                            MOUTH_CENTER = 13,
                            NOSE_BOTTOM_RIGHT = 14,
                            NOSE_BOTTOM_LEFT = 15,
                            NOSE_BOTTOM_CENTER = 16,
                            LEFT_EYE_TOP_BOUNDARY = 17,
                            LEFT_EYE_RIGHT_CORNER = 18,
                            LEFT_EYE_BOTTOM_BOUNDARY = 19,
                            LEFT_EYE_LEFT_CORNER = 20,
                            RIGHT_EYE_TOP_BOUNDARY = 21,
                            RIGHT_EYE_RIGHT_CORNER = 22,
                            RIGHT_EYE_BOTTOM_BOUNDARY = 23,
                            RIGHT_EYE_LEFT_CORNER = 24,
                            LEFT_EYEBROW_UPPER_MIDPOINT = 25,
                            RIGHT_EYEBROW_UPPER_MIDPOINT = 26,
                            LEFT_EAR_TRAGION = 27,
                            RIGHT_EAR_TRAGION = 28,
                            LEFT_EYE_PUPIL = 29,
                            RIGHT_EYE_PUPIL = 30,
                            FOREHEAD_GLABELLA = 31,
                            CHIN_GNATHION = 32,
                            CHIN_LEFT_GONION = 33,
                            CHIN_RIGHT_GONION = 34,
                            LEFT_CHEEK_CENTER = 35,
                            RIGHT_CHEEK_CENTER = 36
                        }
                    }
                }

                /** Properties of a LocationInfo. */
                interface ILocationInfo {

                    /** LocationInfo latLng */
                    latLng?: (google.type.ILatLng|null);
                }

                /** Represents a LocationInfo. */
                class LocationInfo implements ILocationInfo {

                    /**
                     * Constructs a new LocationInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ILocationInfo);

                    /** LocationInfo latLng. */
                    public latLng?: (google.type.ILatLng|null);

                    /**
                     * Creates a new LocationInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns LocationInfo instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ILocationInfo): google.cloud.vision.v1.LocationInfo;

                    /**
                     * Encodes the specified LocationInfo message. Does not implicitly {@link google.cloud.vision.v1.LocationInfo.verify|verify} messages.
                     * @param message LocationInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ILocationInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified LocationInfo message, length delimited. Does not implicitly {@link google.cloud.vision.v1.LocationInfo.verify|verify} messages.
                     * @param message LocationInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ILocationInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a LocationInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns LocationInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.LocationInfo;

                    /**
                     * Decodes a LocationInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns LocationInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.LocationInfo;

                    /**
                     * Verifies a LocationInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a LocationInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns LocationInfo
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.LocationInfo;

                    /**
                     * Creates a plain object from a LocationInfo message. Also converts values to other types if specified.
                     * @param message LocationInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.LocationInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this LocationInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for LocationInfo
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Property. */
                interface IProperty {

                    /** Property name */
                    name?: (string|null);

                    /** Property value */
                    value?: (string|null);

                    /** Property uint64Value */
                    uint64Value?: (number|Long|string|null);
                }

                /** Represents a Property. */
                class Property implements IProperty {

                    /**
                     * Constructs a new Property.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IProperty);

                    /** Property name. */
                    public name: string;

                    /** Property value. */
                    public value: string;

                    /** Property uint64Value. */
                    public uint64Value: (number|Long|string);

                    /**
                     * Creates a new Property instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Property instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IProperty): google.cloud.vision.v1.Property;

                    /**
                     * Encodes the specified Property message. Does not implicitly {@link google.cloud.vision.v1.Property.verify|verify} messages.
                     * @param message Property message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Property message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Property.verify|verify} messages.
                     * @param message Property message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Property message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Property
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Property;

                    /**
                     * Decodes a Property message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Property
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Property;

                    /**
                     * Verifies a Property message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Property message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Property
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Property;

                    /**
                     * Creates a plain object from a Property message. Also converts values to other types if specified.
                     * @param message Property
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Property, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Property to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Property
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an EntityAnnotation. */
                interface IEntityAnnotation {

                    /** EntityAnnotation mid */
                    mid?: (string|null);

                    /** EntityAnnotation locale */
                    locale?: (string|null);

                    /** EntityAnnotation description */
                    description?: (string|null);

                    /** EntityAnnotation score */
                    score?: (number|null);

                    /** EntityAnnotation confidence */
                    confidence?: (number|null);

                    /** EntityAnnotation topicality */
                    topicality?: (number|null);

                    /** EntityAnnotation boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** EntityAnnotation locations */
                    locations?: (google.cloud.vision.v1.ILocationInfo[]|null);

                    /** EntityAnnotation properties */
                    properties?: (google.cloud.vision.v1.IProperty[]|null);
                }

                /** Represents an EntityAnnotation. */
                class EntityAnnotation implements IEntityAnnotation {

                    /**
                     * Constructs a new EntityAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IEntityAnnotation);

                    /** EntityAnnotation mid. */
                    public mid: string;

                    /** EntityAnnotation locale. */
                    public locale: string;

                    /** EntityAnnotation description. */
                    public description: string;

                    /** EntityAnnotation score. */
                    public score: number;

                    /** EntityAnnotation confidence. */
                    public confidence: number;

                    /** EntityAnnotation topicality. */
                    public topicality: number;

                    /** EntityAnnotation boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** EntityAnnotation locations. */
                    public locations: google.cloud.vision.v1.ILocationInfo[];

                    /** EntityAnnotation properties. */
                    public properties: google.cloud.vision.v1.IProperty[];

                    /**
                     * Creates a new EntityAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns EntityAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IEntityAnnotation): google.cloud.vision.v1.EntityAnnotation;

                    /**
                     * Encodes the specified EntityAnnotation message. Does not implicitly {@link google.cloud.vision.v1.EntityAnnotation.verify|verify} messages.
                     * @param message EntityAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IEntityAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified EntityAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.EntityAnnotation.verify|verify} messages.
                     * @param message EntityAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IEntityAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an EntityAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns EntityAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.EntityAnnotation;

                    /**
                     * Decodes an EntityAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns EntityAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.EntityAnnotation;

                    /**
                     * Verifies an EntityAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an EntityAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns EntityAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.EntityAnnotation;

                    /**
                     * Creates a plain object from an EntityAnnotation message. Also converts values to other types if specified.
                     * @param message EntityAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.EntityAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this EntityAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for EntityAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a LocalizedObjectAnnotation. */
                interface ILocalizedObjectAnnotation {

                    /** LocalizedObjectAnnotation mid */
                    mid?: (string|null);

                    /** LocalizedObjectAnnotation languageCode */
                    languageCode?: (string|null);

                    /** LocalizedObjectAnnotation name */
                    name?: (string|null);

                    /** LocalizedObjectAnnotation score */
                    score?: (number|null);

                    /** LocalizedObjectAnnotation boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);
                }

                /** Represents a LocalizedObjectAnnotation. */
                class LocalizedObjectAnnotation implements ILocalizedObjectAnnotation {

                    /**
                     * Constructs a new LocalizedObjectAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ILocalizedObjectAnnotation);

                    /** LocalizedObjectAnnotation mid. */
                    public mid: string;

                    /** LocalizedObjectAnnotation languageCode. */
                    public languageCode: string;

                    /** LocalizedObjectAnnotation name. */
                    public name: string;

                    /** LocalizedObjectAnnotation score. */
                    public score: number;

                    /** LocalizedObjectAnnotation boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /**
                     * Creates a new LocalizedObjectAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns LocalizedObjectAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ILocalizedObjectAnnotation): google.cloud.vision.v1.LocalizedObjectAnnotation;

                    /**
                     * Encodes the specified LocalizedObjectAnnotation message. Does not implicitly {@link google.cloud.vision.v1.LocalizedObjectAnnotation.verify|verify} messages.
                     * @param message LocalizedObjectAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ILocalizedObjectAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified LocalizedObjectAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.LocalizedObjectAnnotation.verify|verify} messages.
                     * @param message LocalizedObjectAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ILocalizedObjectAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a LocalizedObjectAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns LocalizedObjectAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.LocalizedObjectAnnotation;

                    /**
                     * Decodes a LocalizedObjectAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns LocalizedObjectAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.LocalizedObjectAnnotation;

                    /**
                     * Verifies a LocalizedObjectAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a LocalizedObjectAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns LocalizedObjectAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.LocalizedObjectAnnotation;

                    /**
                     * Creates a plain object from a LocalizedObjectAnnotation message. Also converts values to other types if specified.
                     * @param message LocalizedObjectAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.LocalizedObjectAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this LocalizedObjectAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for LocalizedObjectAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a SafeSearchAnnotation. */
                interface ISafeSearchAnnotation {

                    /** SafeSearchAnnotation adult */
                    adult?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);

                    /** SafeSearchAnnotation spoof */
                    spoof?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);

                    /** SafeSearchAnnotation medical */
                    medical?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);

                    /** SafeSearchAnnotation violence */
                    violence?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);

                    /** SafeSearchAnnotation racy */
                    racy?: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood|null);
                }

                /** Represents a SafeSearchAnnotation. */
                class SafeSearchAnnotation implements ISafeSearchAnnotation {

                    /**
                     * Constructs a new SafeSearchAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ISafeSearchAnnotation);

                    /** SafeSearchAnnotation adult. */
                    public adult: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /** SafeSearchAnnotation spoof. */
                    public spoof: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /** SafeSearchAnnotation medical. */
                    public medical: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /** SafeSearchAnnotation violence. */
                    public violence: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /** SafeSearchAnnotation racy. */
                    public racy: (google.cloud.vision.v1.Likelihood|keyof typeof google.cloud.vision.v1.Likelihood);

                    /**
                     * Creates a new SafeSearchAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SafeSearchAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ISafeSearchAnnotation): google.cloud.vision.v1.SafeSearchAnnotation;

                    /**
                     * Encodes the specified SafeSearchAnnotation message. Does not implicitly {@link google.cloud.vision.v1.SafeSearchAnnotation.verify|verify} messages.
                     * @param message SafeSearchAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ISafeSearchAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SafeSearchAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.SafeSearchAnnotation.verify|verify} messages.
                     * @param message SafeSearchAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ISafeSearchAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SafeSearchAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SafeSearchAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.SafeSearchAnnotation;

                    /**
                     * Decodes a SafeSearchAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SafeSearchAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.SafeSearchAnnotation;

                    /**
                     * Verifies a SafeSearchAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SafeSearchAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SafeSearchAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.SafeSearchAnnotation;

                    /**
                     * Creates a plain object from a SafeSearchAnnotation message. Also converts values to other types if specified.
                     * @param message SafeSearchAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.SafeSearchAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SafeSearchAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for SafeSearchAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a LatLongRect. */
                interface ILatLongRect {

                    /** LatLongRect minLatLng */
                    minLatLng?: (google.type.ILatLng|null);

                    /** LatLongRect maxLatLng */
                    maxLatLng?: (google.type.ILatLng|null);
                }

                /** Represents a LatLongRect. */
                class LatLongRect implements ILatLongRect {

                    /**
                     * Constructs a new LatLongRect.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ILatLongRect);

                    /** LatLongRect minLatLng. */
                    public minLatLng?: (google.type.ILatLng|null);

                    /** LatLongRect maxLatLng. */
                    public maxLatLng?: (google.type.ILatLng|null);

                    /**
                     * Creates a new LatLongRect instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns LatLongRect instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ILatLongRect): google.cloud.vision.v1.LatLongRect;

                    /**
                     * Encodes the specified LatLongRect message. Does not implicitly {@link google.cloud.vision.v1.LatLongRect.verify|verify} messages.
                     * @param message LatLongRect message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ILatLongRect, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified LatLongRect message, length delimited. Does not implicitly {@link google.cloud.vision.v1.LatLongRect.verify|verify} messages.
                     * @param message LatLongRect message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ILatLongRect, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a LatLongRect message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns LatLongRect
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.LatLongRect;

                    /**
                     * Decodes a LatLongRect message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns LatLongRect
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.LatLongRect;

                    /**
                     * Verifies a LatLongRect message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a LatLongRect message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns LatLongRect
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.LatLongRect;

                    /**
                     * Creates a plain object from a LatLongRect message. Also converts values to other types if specified.
                     * @param message LatLongRect
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.LatLongRect, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this LatLongRect to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for LatLongRect
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ColorInfo. */
                interface IColorInfo {

                    /** ColorInfo color */
                    color?: (google.type.IColor|null);

                    /** ColorInfo score */
                    score?: (number|null);

                    /** ColorInfo pixelFraction */
                    pixelFraction?: (number|null);
                }

                /** Represents a ColorInfo. */
                class ColorInfo implements IColorInfo {

                    /**
                     * Constructs a new ColorInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IColorInfo);

                    /** ColorInfo color. */
                    public color?: (google.type.IColor|null);

                    /** ColorInfo score. */
                    public score: number;

                    /** ColorInfo pixelFraction. */
                    public pixelFraction: number;

                    /**
                     * Creates a new ColorInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ColorInfo instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IColorInfo): google.cloud.vision.v1.ColorInfo;

                    /**
                     * Encodes the specified ColorInfo message. Does not implicitly {@link google.cloud.vision.v1.ColorInfo.verify|verify} messages.
                     * @param message ColorInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IColorInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ColorInfo message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ColorInfo.verify|verify} messages.
                     * @param message ColorInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IColorInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ColorInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ColorInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ColorInfo;

                    /**
                     * Decodes a ColorInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ColorInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ColorInfo;

                    /**
                     * Verifies a ColorInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ColorInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ColorInfo
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ColorInfo;

                    /**
                     * Creates a plain object from a ColorInfo message. Also converts values to other types if specified.
                     * @param message ColorInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ColorInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ColorInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ColorInfo
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DominantColorsAnnotation. */
                interface IDominantColorsAnnotation {

                    /** DominantColorsAnnotation colors */
                    colors?: (google.cloud.vision.v1.IColorInfo[]|null);
                }

                /** Represents a DominantColorsAnnotation. */
                class DominantColorsAnnotation implements IDominantColorsAnnotation {

                    /**
                     * Constructs a new DominantColorsAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IDominantColorsAnnotation);

                    /** DominantColorsAnnotation colors. */
                    public colors: google.cloud.vision.v1.IColorInfo[];

                    /**
                     * Creates a new DominantColorsAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DominantColorsAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IDominantColorsAnnotation): google.cloud.vision.v1.DominantColorsAnnotation;

                    /**
                     * Encodes the specified DominantColorsAnnotation message. Does not implicitly {@link google.cloud.vision.v1.DominantColorsAnnotation.verify|verify} messages.
                     * @param message DominantColorsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IDominantColorsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DominantColorsAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.DominantColorsAnnotation.verify|verify} messages.
                     * @param message DominantColorsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IDominantColorsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DominantColorsAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DominantColorsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.DominantColorsAnnotation;

                    /**
                     * Decodes a DominantColorsAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DominantColorsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.DominantColorsAnnotation;

                    /**
                     * Verifies a DominantColorsAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DominantColorsAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DominantColorsAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.DominantColorsAnnotation;

                    /**
                     * Creates a plain object from a DominantColorsAnnotation message. Also converts values to other types if specified.
                     * @param message DominantColorsAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.DominantColorsAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DominantColorsAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DominantColorsAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImageProperties. */
                interface IImageProperties {

                    /** ImageProperties dominantColors */
                    dominantColors?: (google.cloud.vision.v1.IDominantColorsAnnotation|null);
                }

                /** Represents an ImageProperties. */
                class ImageProperties implements IImageProperties {

                    /**
                     * Constructs a new ImageProperties.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IImageProperties);

                    /** ImageProperties dominantColors. */
                    public dominantColors?: (google.cloud.vision.v1.IDominantColorsAnnotation|null);

                    /**
                     * Creates a new ImageProperties instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageProperties instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IImageProperties): google.cloud.vision.v1.ImageProperties;

                    /**
                     * Encodes the specified ImageProperties message. Does not implicitly {@link google.cloud.vision.v1.ImageProperties.verify|verify} messages.
                     * @param message ImageProperties message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IImageProperties, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageProperties message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImageProperties.verify|verify} messages.
                     * @param message ImageProperties message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IImageProperties, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageProperties message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageProperties
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ImageProperties;

                    /**
                     * Decodes an ImageProperties message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageProperties
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ImageProperties;

                    /**
                     * Verifies an ImageProperties message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageProperties message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageProperties
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ImageProperties;

                    /**
                     * Creates a plain object from an ImageProperties message. Also converts values to other types if specified.
                     * @param message ImageProperties
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ImageProperties, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageProperties to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageProperties
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CropHint. */
                interface ICropHint {

                    /** CropHint boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** CropHint confidence */
                    confidence?: (number|null);

                    /** CropHint importanceFraction */
                    importanceFraction?: (number|null);
                }

                /** Represents a CropHint. */
                class CropHint implements ICropHint {

                    /**
                     * Constructs a new CropHint.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ICropHint);

                    /** CropHint boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** CropHint confidence. */
                    public confidence: number;

                    /** CropHint importanceFraction. */
                    public importanceFraction: number;

                    /**
                     * Creates a new CropHint instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CropHint instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ICropHint): google.cloud.vision.v1.CropHint;

                    /**
                     * Encodes the specified CropHint message. Does not implicitly {@link google.cloud.vision.v1.CropHint.verify|verify} messages.
                     * @param message CropHint message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ICropHint, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CropHint message, length delimited. Does not implicitly {@link google.cloud.vision.v1.CropHint.verify|verify} messages.
                     * @param message CropHint message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ICropHint, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CropHint message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CropHint
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.CropHint;

                    /**
                     * Decodes a CropHint message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CropHint
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.CropHint;

                    /**
                     * Verifies a CropHint message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CropHint message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CropHint
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.CropHint;

                    /**
                     * Creates a plain object from a CropHint message. Also converts values to other types if specified.
                     * @param message CropHint
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.CropHint, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CropHint to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CropHint
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CropHintsAnnotation. */
                interface ICropHintsAnnotation {

                    /** CropHintsAnnotation cropHints */
                    cropHints?: (google.cloud.vision.v1.ICropHint[]|null);
                }

                /** Represents a CropHintsAnnotation. */
                class CropHintsAnnotation implements ICropHintsAnnotation {

                    /**
                     * Constructs a new CropHintsAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ICropHintsAnnotation);

                    /** CropHintsAnnotation cropHints. */
                    public cropHints: google.cloud.vision.v1.ICropHint[];

                    /**
                     * Creates a new CropHintsAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CropHintsAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ICropHintsAnnotation): google.cloud.vision.v1.CropHintsAnnotation;

                    /**
                     * Encodes the specified CropHintsAnnotation message. Does not implicitly {@link google.cloud.vision.v1.CropHintsAnnotation.verify|verify} messages.
                     * @param message CropHintsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ICropHintsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CropHintsAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.CropHintsAnnotation.verify|verify} messages.
                     * @param message CropHintsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ICropHintsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CropHintsAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CropHintsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.CropHintsAnnotation;

                    /**
                     * Decodes a CropHintsAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CropHintsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.CropHintsAnnotation;

                    /**
                     * Verifies a CropHintsAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CropHintsAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CropHintsAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.CropHintsAnnotation;

                    /**
                     * Creates a plain object from a CropHintsAnnotation message. Also converts values to other types if specified.
                     * @param message CropHintsAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.CropHintsAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CropHintsAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CropHintsAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CropHintsParams. */
                interface ICropHintsParams {

                    /** CropHintsParams aspectRatios */
                    aspectRatios?: (number[]|null);
                }

                /** Represents a CropHintsParams. */
                class CropHintsParams implements ICropHintsParams {

                    /**
                     * Constructs a new CropHintsParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ICropHintsParams);

                    /** CropHintsParams aspectRatios. */
                    public aspectRatios: number[];

                    /**
                     * Creates a new CropHintsParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CropHintsParams instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ICropHintsParams): google.cloud.vision.v1.CropHintsParams;

                    /**
                     * Encodes the specified CropHintsParams message. Does not implicitly {@link google.cloud.vision.v1.CropHintsParams.verify|verify} messages.
                     * @param message CropHintsParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ICropHintsParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CropHintsParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1.CropHintsParams.verify|verify} messages.
                     * @param message CropHintsParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ICropHintsParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CropHintsParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CropHintsParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.CropHintsParams;

                    /**
                     * Decodes a CropHintsParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CropHintsParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.CropHintsParams;

                    /**
                     * Verifies a CropHintsParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CropHintsParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CropHintsParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.CropHintsParams;

                    /**
                     * Creates a plain object from a CropHintsParams message. Also converts values to other types if specified.
                     * @param message CropHintsParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.CropHintsParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CropHintsParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CropHintsParams
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a WebDetectionParams. */
                interface IWebDetectionParams {

                    /** WebDetectionParams includeGeoResults */
                    includeGeoResults?: (boolean|null);
                }

                /** Represents a WebDetectionParams. */
                class WebDetectionParams implements IWebDetectionParams {

                    /**
                     * Constructs a new WebDetectionParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IWebDetectionParams);

                    /** WebDetectionParams includeGeoResults. */
                    public includeGeoResults: boolean;

                    /**
                     * Creates a new WebDetectionParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns WebDetectionParams instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IWebDetectionParams): google.cloud.vision.v1.WebDetectionParams;

                    /**
                     * Encodes the specified WebDetectionParams message. Does not implicitly {@link google.cloud.vision.v1.WebDetectionParams.verify|verify} messages.
                     * @param message WebDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IWebDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified WebDetectionParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1.WebDetectionParams.verify|verify} messages.
                     * @param message WebDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IWebDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a WebDetectionParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns WebDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.WebDetectionParams;

                    /**
                     * Decodes a WebDetectionParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns WebDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.WebDetectionParams;

                    /**
                     * Verifies a WebDetectionParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a WebDetectionParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns WebDetectionParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.WebDetectionParams;

                    /**
                     * Creates a plain object from a WebDetectionParams message. Also converts values to other types if specified.
                     * @param message WebDetectionParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.WebDetectionParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this WebDetectionParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for WebDetectionParams
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a TextDetectionParams. */
                interface ITextDetectionParams {

                    /** TextDetectionParams enableTextDetectionConfidenceScore */
                    enableTextDetectionConfidenceScore?: (boolean|null);

                    /** TextDetectionParams advancedOcrOptions */
                    advancedOcrOptions?: (string[]|null);
                }

                /** Represents a TextDetectionParams. */
                class TextDetectionParams implements ITextDetectionParams {

                    /**
                     * Constructs a new TextDetectionParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ITextDetectionParams);

                    /** TextDetectionParams enableTextDetectionConfidenceScore. */
                    public enableTextDetectionConfidenceScore: boolean;

                    /** TextDetectionParams advancedOcrOptions. */
                    public advancedOcrOptions: string[];

                    /**
                     * Creates a new TextDetectionParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TextDetectionParams instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ITextDetectionParams): google.cloud.vision.v1.TextDetectionParams;

                    /**
                     * Encodes the specified TextDetectionParams message. Does not implicitly {@link google.cloud.vision.v1.TextDetectionParams.verify|verify} messages.
                     * @param message TextDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ITextDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TextDetectionParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1.TextDetectionParams.verify|verify} messages.
                     * @param message TextDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ITextDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TextDetectionParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TextDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.TextDetectionParams;

                    /**
                     * Decodes a TextDetectionParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TextDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.TextDetectionParams;

                    /**
                     * Verifies a TextDetectionParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TextDetectionParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TextDetectionParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.TextDetectionParams;

                    /**
                     * Creates a plain object from a TextDetectionParams message. Also converts values to other types if specified.
                     * @param message TextDetectionParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.TextDetectionParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TextDetectionParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for TextDetectionParams
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImageContext. */
                interface IImageContext {

                    /** ImageContext latLongRect */
                    latLongRect?: (google.cloud.vision.v1.ILatLongRect|null);

                    /** ImageContext languageHints */
                    languageHints?: (string[]|null);

                    /** ImageContext cropHintsParams */
                    cropHintsParams?: (google.cloud.vision.v1.ICropHintsParams|null);

                    /** ImageContext productSearchParams */
                    productSearchParams?: (google.cloud.vision.v1.IProductSearchParams|null);

                    /** ImageContext webDetectionParams */
                    webDetectionParams?: (google.cloud.vision.v1.IWebDetectionParams|null);

                    /** ImageContext textDetectionParams */
                    textDetectionParams?: (google.cloud.vision.v1.ITextDetectionParams|null);
                }

                /** Represents an ImageContext. */
                class ImageContext implements IImageContext {

                    /**
                     * Constructs a new ImageContext.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IImageContext);

                    /** ImageContext latLongRect. */
                    public latLongRect?: (google.cloud.vision.v1.ILatLongRect|null);

                    /** ImageContext languageHints. */
                    public languageHints: string[];

                    /** ImageContext cropHintsParams. */
                    public cropHintsParams?: (google.cloud.vision.v1.ICropHintsParams|null);

                    /** ImageContext productSearchParams. */
                    public productSearchParams?: (google.cloud.vision.v1.IProductSearchParams|null);

                    /** ImageContext webDetectionParams. */
                    public webDetectionParams?: (google.cloud.vision.v1.IWebDetectionParams|null);

                    /** ImageContext textDetectionParams. */
                    public textDetectionParams?: (google.cloud.vision.v1.ITextDetectionParams|null);

                    /**
                     * Creates a new ImageContext instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageContext instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IImageContext): google.cloud.vision.v1.ImageContext;

                    /**
                     * Encodes the specified ImageContext message. Does not implicitly {@link google.cloud.vision.v1.ImageContext.verify|verify} messages.
                     * @param message ImageContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IImageContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageContext message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImageContext.verify|verify} messages.
                     * @param message ImageContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IImageContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageContext message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ImageContext;

                    /**
                     * Decodes an ImageContext message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ImageContext;

                    /**
                     * Verifies an ImageContext message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageContext message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageContext
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ImageContext;

                    /**
                     * Creates a plain object from an ImageContext message. Also converts values to other types if specified.
                     * @param message ImageContext
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ImageContext, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageContext to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageContext
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AnnotateImageRequest. */
                interface IAnnotateImageRequest {

                    /** AnnotateImageRequest image */
                    image?: (google.cloud.vision.v1.IImage|null);

                    /** AnnotateImageRequest features */
                    features?: (google.cloud.vision.v1.IFeature[]|null);

                    /** AnnotateImageRequest imageContext */
                    imageContext?: (google.cloud.vision.v1.IImageContext|null);
                }

                /** Represents an AnnotateImageRequest. */
                class AnnotateImageRequest implements IAnnotateImageRequest {

                    /**
                     * Constructs a new AnnotateImageRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAnnotateImageRequest);

                    /** AnnotateImageRequest image. */
                    public image?: (google.cloud.vision.v1.IImage|null);

                    /** AnnotateImageRequest features. */
                    public features: google.cloud.vision.v1.IFeature[];

                    /** AnnotateImageRequest imageContext. */
                    public imageContext?: (google.cloud.vision.v1.IImageContext|null);

                    /**
                     * Creates a new AnnotateImageRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnnotateImageRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAnnotateImageRequest): google.cloud.vision.v1.AnnotateImageRequest;

                    /**
                     * Encodes the specified AnnotateImageRequest message. Does not implicitly {@link google.cloud.vision.v1.AnnotateImageRequest.verify|verify} messages.
                     * @param message AnnotateImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAnnotateImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnnotateImageRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AnnotateImageRequest.verify|verify} messages.
                     * @param message AnnotateImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAnnotateImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnnotateImageRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnnotateImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AnnotateImageRequest;

                    /**
                     * Decodes an AnnotateImageRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnnotateImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AnnotateImageRequest;

                    /**
                     * Verifies an AnnotateImageRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnnotateImageRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnnotateImageRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AnnotateImageRequest;

                    /**
                     * Creates a plain object from an AnnotateImageRequest message. Also converts values to other types if specified.
                     * @param message AnnotateImageRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AnnotateImageRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnnotateImageRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AnnotateImageRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImageAnnotationContext. */
                interface IImageAnnotationContext {

                    /** ImageAnnotationContext uri */
                    uri?: (string|null);

                    /** ImageAnnotationContext pageNumber */
                    pageNumber?: (number|null);
                }

                /** Represents an ImageAnnotationContext. */
                class ImageAnnotationContext implements IImageAnnotationContext {

                    /**
                     * Constructs a new ImageAnnotationContext.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IImageAnnotationContext);

                    /** ImageAnnotationContext uri. */
                    public uri: string;

                    /** ImageAnnotationContext pageNumber. */
                    public pageNumber: number;

                    /**
                     * Creates a new ImageAnnotationContext instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageAnnotationContext instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IImageAnnotationContext): google.cloud.vision.v1.ImageAnnotationContext;

                    /**
                     * Encodes the specified ImageAnnotationContext message. Does not implicitly {@link google.cloud.vision.v1.ImageAnnotationContext.verify|verify} messages.
                     * @param message ImageAnnotationContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IImageAnnotationContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageAnnotationContext message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImageAnnotationContext.verify|verify} messages.
                     * @param message ImageAnnotationContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IImageAnnotationContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageAnnotationContext message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageAnnotationContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ImageAnnotationContext;

                    /**
                     * Decodes an ImageAnnotationContext message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageAnnotationContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ImageAnnotationContext;

                    /**
                     * Verifies an ImageAnnotationContext message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageAnnotationContext message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageAnnotationContext
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ImageAnnotationContext;

                    /**
                     * Creates a plain object from an ImageAnnotationContext message. Also converts values to other types if specified.
                     * @param message ImageAnnotationContext
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ImageAnnotationContext, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageAnnotationContext to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageAnnotationContext
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AnnotateImageResponse. */
                interface IAnnotateImageResponse {

                    /** AnnotateImageResponse faceAnnotations */
                    faceAnnotations?: (google.cloud.vision.v1.IFaceAnnotation[]|null);

                    /** AnnotateImageResponse landmarkAnnotations */
                    landmarkAnnotations?: (google.cloud.vision.v1.IEntityAnnotation[]|null);

                    /** AnnotateImageResponse logoAnnotations */
                    logoAnnotations?: (google.cloud.vision.v1.IEntityAnnotation[]|null);

                    /** AnnotateImageResponse labelAnnotations */
                    labelAnnotations?: (google.cloud.vision.v1.IEntityAnnotation[]|null);

                    /** AnnotateImageResponse localizedObjectAnnotations */
                    localizedObjectAnnotations?: (google.cloud.vision.v1.ILocalizedObjectAnnotation[]|null);

                    /** AnnotateImageResponse textAnnotations */
                    textAnnotations?: (google.cloud.vision.v1.IEntityAnnotation[]|null);

                    /** AnnotateImageResponse fullTextAnnotation */
                    fullTextAnnotation?: (google.cloud.vision.v1.ITextAnnotation|null);

                    /** AnnotateImageResponse safeSearchAnnotation */
                    safeSearchAnnotation?: (google.cloud.vision.v1.ISafeSearchAnnotation|null);

                    /** AnnotateImageResponse imagePropertiesAnnotation */
                    imagePropertiesAnnotation?: (google.cloud.vision.v1.IImageProperties|null);

                    /** AnnotateImageResponse cropHintsAnnotation */
                    cropHintsAnnotation?: (google.cloud.vision.v1.ICropHintsAnnotation|null);

                    /** AnnotateImageResponse webDetection */
                    webDetection?: (google.cloud.vision.v1.IWebDetection|null);

                    /** AnnotateImageResponse productSearchResults */
                    productSearchResults?: (google.cloud.vision.v1.IProductSearchResults|null);

                    /** AnnotateImageResponse error */
                    error?: (google.rpc.IStatus|null);

                    /** AnnotateImageResponse context */
                    context?: (google.cloud.vision.v1.IImageAnnotationContext|null);
                }

                /** Represents an AnnotateImageResponse. */
                class AnnotateImageResponse implements IAnnotateImageResponse {

                    /**
                     * Constructs a new AnnotateImageResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAnnotateImageResponse);

                    /** AnnotateImageResponse faceAnnotations. */
                    public faceAnnotations: google.cloud.vision.v1.IFaceAnnotation[];

                    /** AnnotateImageResponse landmarkAnnotations. */
                    public landmarkAnnotations: google.cloud.vision.v1.IEntityAnnotation[];

                    /** AnnotateImageResponse logoAnnotations. */
                    public logoAnnotations: google.cloud.vision.v1.IEntityAnnotation[];

                    /** AnnotateImageResponse labelAnnotations. */
                    public labelAnnotations: google.cloud.vision.v1.IEntityAnnotation[];

                    /** AnnotateImageResponse localizedObjectAnnotations. */
                    public localizedObjectAnnotations: google.cloud.vision.v1.ILocalizedObjectAnnotation[];

                    /** AnnotateImageResponse textAnnotations. */
                    public textAnnotations: google.cloud.vision.v1.IEntityAnnotation[];

                    /** AnnotateImageResponse fullTextAnnotation. */
                    public fullTextAnnotation?: (google.cloud.vision.v1.ITextAnnotation|null);

                    /** AnnotateImageResponse safeSearchAnnotation. */
                    public safeSearchAnnotation?: (google.cloud.vision.v1.ISafeSearchAnnotation|null);

                    /** AnnotateImageResponse imagePropertiesAnnotation. */
                    public imagePropertiesAnnotation?: (google.cloud.vision.v1.IImageProperties|null);

                    /** AnnotateImageResponse cropHintsAnnotation. */
                    public cropHintsAnnotation?: (google.cloud.vision.v1.ICropHintsAnnotation|null);

                    /** AnnotateImageResponse webDetection. */
                    public webDetection?: (google.cloud.vision.v1.IWebDetection|null);

                    /** AnnotateImageResponse productSearchResults. */
                    public productSearchResults?: (google.cloud.vision.v1.IProductSearchResults|null);

                    /** AnnotateImageResponse error. */
                    public error?: (google.rpc.IStatus|null);

                    /** AnnotateImageResponse context. */
                    public context?: (google.cloud.vision.v1.IImageAnnotationContext|null);

                    /**
                     * Creates a new AnnotateImageResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnnotateImageResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAnnotateImageResponse): google.cloud.vision.v1.AnnotateImageResponse;

                    /**
                     * Encodes the specified AnnotateImageResponse message. Does not implicitly {@link google.cloud.vision.v1.AnnotateImageResponse.verify|verify} messages.
                     * @param message AnnotateImageResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAnnotateImageResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnnotateImageResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AnnotateImageResponse.verify|verify} messages.
                     * @param message AnnotateImageResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAnnotateImageResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnnotateImageResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnnotateImageResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AnnotateImageResponse;

                    /**
                     * Decodes an AnnotateImageResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnnotateImageResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AnnotateImageResponse;

                    /**
                     * Verifies an AnnotateImageResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnnotateImageResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnnotateImageResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AnnotateImageResponse;

                    /**
                     * Creates a plain object from an AnnotateImageResponse message. Also converts values to other types if specified.
                     * @param message AnnotateImageResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AnnotateImageResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnnotateImageResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AnnotateImageResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BatchAnnotateImagesRequest. */
                interface IBatchAnnotateImagesRequest {

                    /** BatchAnnotateImagesRequest requests */
                    requests?: (google.cloud.vision.v1.IAnnotateImageRequest[]|null);

                    /** BatchAnnotateImagesRequest parent */
                    parent?: (string|null);

                    /** BatchAnnotateImagesRequest labels */
                    labels?: ({ [k: string]: string }|null);
                }

                /** Represents a BatchAnnotateImagesRequest. */
                class BatchAnnotateImagesRequest implements IBatchAnnotateImagesRequest {

                    /**
                     * Constructs a new BatchAnnotateImagesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IBatchAnnotateImagesRequest);

                    /** BatchAnnotateImagesRequest requests. */
                    public requests: google.cloud.vision.v1.IAnnotateImageRequest[];

                    /** BatchAnnotateImagesRequest parent. */
                    public parent: string;

                    /** BatchAnnotateImagesRequest labels. */
                    public labels: { [k: string]: string };

                    /**
                     * Creates a new BatchAnnotateImagesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchAnnotateImagesRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IBatchAnnotateImagesRequest): google.cloud.vision.v1.BatchAnnotateImagesRequest;

                    /**
                     * Encodes the specified BatchAnnotateImagesRequest message. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateImagesRequest.verify|verify} messages.
                     * @param message BatchAnnotateImagesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IBatchAnnotateImagesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchAnnotateImagesRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateImagesRequest.verify|verify} messages.
                     * @param message BatchAnnotateImagesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IBatchAnnotateImagesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchAnnotateImagesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchAnnotateImagesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.BatchAnnotateImagesRequest;

                    /**
                     * Decodes a BatchAnnotateImagesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchAnnotateImagesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.BatchAnnotateImagesRequest;

                    /**
                     * Verifies a BatchAnnotateImagesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchAnnotateImagesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchAnnotateImagesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.BatchAnnotateImagesRequest;

                    /**
                     * Creates a plain object from a BatchAnnotateImagesRequest message. Also converts values to other types if specified.
                     * @param message BatchAnnotateImagesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.BatchAnnotateImagesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchAnnotateImagesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BatchAnnotateImagesRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BatchAnnotateImagesResponse. */
                interface IBatchAnnotateImagesResponse {

                    /** BatchAnnotateImagesResponse responses */
                    responses?: (google.cloud.vision.v1.IAnnotateImageResponse[]|null);
                }

                /** Represents a BatchAnnotateImagesResponse. */
                class BatchAnnotateImagesResponse implements IBatchAnnotateImagesResponse {

                    /**
                     * Constructs a new BatchAnnotateImagesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IBatchAnnotateImagesResponse);

                    /** BatchAnnotateImagesResponse responses. */
                    public responses: google.cloud.vision.v1.IAnnotateImageResponse[];

                    /**
                     * Creates a new BatchAnnotateImagesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchAnnotateImagesResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IBatchAnnotateImagesResponse): google.cloud.vision.v1.BatchAnnotateImagesResponse;

                    /**
                     * Encodes the specified BatchAnnotateImagesResponse message. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateImagesResponse.verify|verify} messages.
                     * @param message BatchAnnotateImagesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IBatchAnnotateImagesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchAnnotateImagesResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateImagesResponse.verify|verify} messages.
                     * @param message BatchAnnotateImagesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IBatchAnnotateImagesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchAnnotateImagesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchAnnotateImagesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.BatchAnnotateImagesResponse;

                    /**
                     * Decodes a BatchAnnotateImagesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchAnnotateImagesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.BatchAnnotateImagesResponse;

                    /**
                     * Verifies a BatchAnnotateImagesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchAnnotateImagesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchAnnotateImagesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.BatchAnnotateImagesResponse;

                    /**
                     * Creates a plain object from a BatchAnnotateImagesResponse message. Also converts values to other types if specified.
                     * @param message BatchAnnotateImagesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.BatchAnnotateImagesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchAnnotateImagesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BatchAnnotateImagesResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AnnotateFileRequest. */
                interface IAnnotateFileRequest {

                    /** AnnotateFileRequest inputConfig */
                    inputConfig?: (google.cloud.vision.v1.IInputConfig|null);

                    /** AnnotateFileRequest features */
                    features?: (google.cloud.vision.v1.IFeature[]|null);

                    /** AnnotateFileRequest imageContext */
                    imageContext?: (google.cloud.vision.v1.IImageContext|null);

                    /** AnnotateFileRequest pages */
                    pages?: (number[]|null);
                }

                /** Represents an AnnotateFileRequest. */
                class AnnotateFileRequest implements IAnnotateFileRequest {

                    /**
                     * Constructs a new AnnotateFileRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAnnotateFileRequest);

                    /** AnnotateFileRequest inputConfig. */
                    public inputConfig?: (google.cloud.vision.v1.IInputConfig|null);

                    /** AnnotateFileRequest features. */
                    public features: google.cloud.vision.v1.IFeature[];

                    /** AnnotateFileRequest imageContext. */
                    public imageContext?: (google.cloud.vision.v1.IImageContext|null);

                    /** AnnotateFileRequest pages. */
                    public pages: number[];

                    /**
                     * Creates a new AnnotateFileRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnnotateFileRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAnnotateFileRequest): google.cloud.vision.v1.AnnotateFileRequest;

                    /**
                     * Encodes the specified AnnotateFileRequest message. Does not implicitly {@link google.cloud.vision.v1.AnnotateFileRequest.verify|verify} messages.
                     * @param message AnnotateFileRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAnnotateFileRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnnotateFileRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AnnotateFileRequest.verify|verify} messages.
                     * @param message AnnotateFileRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAnnotateFileRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnnotateFileRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnnotateFileRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AnnotateFileRequest;

                    /**
                     * Decodes an AnnotateFileRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnnotateFileRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AnnotateFileRequest;

                    /**
                     * Verifies an AnnotateFileRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnnotateFileRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnnotateFileRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AnnotateFileRequest;

                    /**
                     * Creates a plain object from an AnnotateFileRequest message. Also converts values to other types if specified.
                     * @param message AnnotateFileRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AnnotateFileRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnnotateFileRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AnnotateFileRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AnnotateFileResponse. */
                interface IAnnotateFileResponse {

                    /** AnnotateFileResponse inputConfig */
                    inputConfig?: (google.cloud.vision.v1.IInputConfig|null);

                    /** AnnotateFileResponse responses */
                    responses?: (google.cloud.vision.v1.IAnnotateImageResponse[]|null);

                    /** AnnotateFileResponse totalPages */
                    totalPages?: (number|null);

                    /** AnnotateFileResponse error */
                    error?: (google.rpc.IStatus|null);
                }

                /** Represents an AnnotateFileResponse. */
                class AnnotateFileResponse implements IAnnotateFileResponse {

                    /**
                     * Constructs a new AnnotateFileResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAnnotateFileResponse);

                    /** AnnotateFileResponse inputConfig. */
                    public inputConfig?: (google.cloud.vision.v1.IInputConfig|null);

                    /** AnnotateFileResponse responses. */
                    public responses: google.cloud.vision.v1.IAnnotateImageResponse[];

                    /** AnnotateFileResponse totalPages. */
                    public totalPages: number;

                    /** AnnotateFileResponse error. */
                    public error?: (google.rpc.IStatus|null);

                    /**
                     * Creates a new AnnotateFileResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnnotateFileResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAnnotateFileResponse): google.cloud.vision.v1.AnnotateFileResponse;

                    /**
                     * Encodes the specified AnnotateFileResponse message. Does not implicitly {@link google.cloud.vision.v1.AnnotateFileResponse.verify|verify} messages.
                     * @param message AnnotateFileResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAnnotateFileResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnnotateFileResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AnnotateFileResponse.verify|verify} messages.
                     * @param message AnnotateFileResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAnnotateFileResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnnotateFileResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnnotateFileResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AnnotateFileResponse;

                    /**
                     * Decodes an AnnotateFileResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnnotateFileResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AnnotateFileResponse;

                    /**
                     * Verifies an AnnotateFileResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnnotateFileResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnnotateFileResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AnnotateFileResponse;

                    /**
                     * Creates a plain object from an AnnotateFileResponse message. Also converts values to other types if specified.
                     * @param message AnnotateFileResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AnnotateFileResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnnotateFileResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AnnotateFileResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BatchAnnotateFilesRequest. */
                interface IBatchAnnotateFilesRequest {

                    /** BatchAnnotateFilesRequest requests */
                    requests?: (google.cloud.vision.v1.IAnnotateFileRequest[]|null);

                    /** BatchAnnotateFilesRequest parent */
                    parent?: (string|null);

                    /** BatchAnnotateFilesRequest labels */
                    labels?: ({ [k: string]: string }|null);
                }

                /** Represents a BatchAnnotateFilesRequest. */
                class BatchAnnotateFilesRequest implements IBatchAnnotateFilesRequest {

                    /**
                     * Constructs a new BatchAnnotateFilesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IBatchAnnotateFilesRequest);

                    /** BatchAnnotateFilesRequest requests. */
                    public requests: google.cloud.vision.v1.IAnnotateFileRequest[];

                    /** BatchAnnotateFilesRequest parent. */
                    public parent: string;

                    /** BatchAnnotateFilesRequest labels. */
                    public labels: { [k: string]: string };

                    /**
                     * Creates a new BatchAnnotateFilesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchAnnotateFilesRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IBatchAnnotateFilesRequest): google.cloud.vision.v1.BatchAnnotateFilesRequest;

                    /**
                     * Encodes the specified BatchAnnotateFilesRequest message. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateFilesRequest.verify|verify} messages.
                     * @param message BatchAnnotateFilesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IBatchAnnotateFilesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchAnnotateFilesRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateFilesRequest.verify|verify} messages.
                     * @param message BatchAnnotateFilesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IBatchAnnotateFilesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchAnnotateFilesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchAnnotateFilesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.BatchAnnotateFilesRequest;

                    /**
                     * Decodes a BatchAnnotateFilesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchAnnotateFilesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.BatchAnnotateFilesRequest;

                    /**
                     * Verifies a BatchAnnotateFilesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchAnnotateFilesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchAnnotateFilesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.BatchAnnotateFilesRequest;

                    /**
                     * Creates a plain object from a BatchAnnotateFilesRequest message. Also converts values to other types if specified.
                     * @param message BatchAnnotateFilesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.BatchAnnotateFilesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchAnnotateFilesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BatchAnnotateFilesRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BatchAnnotateFilesResponse. */
                interface IBatchAnnotateFilesResponse {

                    /** BatchAnnotateFilesResponse responses */
                    responses?: (google.cloud.vision.v1.IAnnotateFileResponse[]|null);
                }

                /** Represents a BatchAnnotateFilesResponse. */
                class BatchAnnotateFilesResponse implements IBatchAnnotateFilesResponse {

                    /**
                     * Constructs a new BatchAnnotateFilesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IBatchAnnotateFilesResponse);

                    /** BatchAnnotateFilesResponse responses. */
                    public responses: google.cloud.vision.v1.IAnnotateFileResponse[];

                    /**
                     * Creates a new BatchAnnotateFilesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchAnnotateFilesResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IBatchAnnotateFilesResponse): google.cloud.vision.v1.BatchAnnotateFilesResponse;

                    /**
                     * Encodes the specified BatchAnnotateFilesResponse message. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateFilesResponse.verify|verify} messages.
                     * @param message BatchAnnotateFilesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IBatchAnnotateFilesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchAnnotateFilesResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateFilesResponse.verify|verify} messages.
                     * @param message BatchAnnotateFilesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IBatchAnnotateFilesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchAnnotateFilesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchAnnotateFilesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.BatchAnnotateFilesResponse;

                    /**
                     * Decodes a BatchAnnotateFilesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchAnnotateFilesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.BatchAnnotateFilesResponse;

                    /**
                     * Verifies a BatchAnnotateFilesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchAnnotateFilesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchAnnotateFilesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.BatchAnnotateFilesResponse;

                    /**
                     * Creates a plain object from a BatchAnnotateFilesResponse message. Also converts values to other types if specified.
                     * @param message BatchAnnotateFilesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.BatchAnnotateFilesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchAnnotateFilesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BatchAnnotateFilesResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AsyncAnnotateFileRequest. */
                interface IAsyncAnnotateFileRequest {

                    /** AsyncAnnotateFileRequest inputConfig */
                    inputConfig?: (google.cloud.vision.v1.IInputConfig|null);

                    /** AsyncAnnotateFileRequest features */
                    features?: (google.cloud.vision.v1.IFeature[]|null);

                    /** AsyncAnnotateFileRequest imageContext */
                    imageContext?: (google.cloud.vision.v1.IImageContext|null);

                    /** AsyncAnnotateFileRequest outputConfig */
                    outputConfig?: (google.cloud.vision.v1.IOutputConfig|null);
                }

                /** Represents an AsyncAnnotateFileRequest. */
                class AsyncAnnotateFileRequest implements IAsyncAnnotateFileRequest {

                    /**
                     * Constructs a new AsyncAnnotateFileRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAsyncAnnotateFileRequest);

                    /** AsyncAnnotateFileRequest inputConfig. */
                    public inputConfig?: (google.cloud.vision.v1.IInputConfig|null);

                    /** AsyncAnnotateFileRequest features. */
                    public features: google.cloud.vision.v1.IFeature[];

                    /** AsyncAnnotateFileRequest imageContext. */
                    public imageContext?: (google.cloud.vision.v1.IImageContext|null);

                    /** AsyncAnnotateFileRequest outputConfig. */
                    public outputConfig?: (google.cloud.vision.v1.IOutputConfig|null);

                    /**
                     * Creates a new AsyncAnnotateFileRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AsyncAnnotateFileRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAsyncAnnotateFileRequest): google.cloud.vision.v1.AsyncAnnotateFileRequest;

                    /**
                     * Encodes the specified AsyncAnnotateFileRequest message. Does not implicitly {@link google.cloud.vision.v1.AsyncAnnotateFileRequest.verify|verify} messages.
                     * @param message AsyncAnnotateFileRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAsyncAnnotateFileRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AsyncAnnotateFileRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncAnnotateFileRequest.verify|verify} messages.
                     * @param message AsyncAnnotateFileRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAsyncAnnotateFileRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AsyncAnnotateFileRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AsyncAnnotateFileRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AsyncAnnotateFileRequest;

                    /**
                     * Decodes an AsyncAnnotateFileRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AsyncAnnotateFileRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AsyncAnnotateFileRequest;

                    /**
                     * Verifies an AsyncAnnotateFileRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AsyncAnnotateFileRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AsyncAnnotateFileRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AsyncAnnotateFileRequest;

                    /**
                     * Creates a plain object from an AsyncAnnotateFileRequest message. Also converts values to other types if specified.
                     * @param message AsyncAnnotateFileRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AsyncAnnotateFileRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AsyncAnnotateFileRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AsyncAnnotateFileRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AsyncAnnotateFileResponse. */
                interface IAsyncAnnotateFileResponse {

                    /** AsyncAnnotateFileResponse outputConfig */
                    outputConfig?: (google.cloud.vision.v1.IOutputConfig|null);
                }

                /** Represents an AsyncAnnotateFileResponse. */
                class AsyncAnnotateFileResponse implements IAsyncAnnotateFileResponse {

                    /**
                     * Constructs a new AsyncAnnotateFileResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAsyncAnnotateFileResponse);

                    /** AsyncAnnotateFileResponse outputConfig. */
                    public outputConfig?: (google.cloud.vision.v1.IOutputConfig|null);

                    /**
                     * Creates a new AsyncAnnotateFileResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AsyncAnnotateFileResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAsyncAnnotateFileResponse): google.cloud.vision.v1.AsyncAnnotateFileResponse;

                    /**
                     * Encodes the specified AsyncAnnotateFileResponse message. Does not implicitly {@link google.cloud.vision.v1.AsyncAnnotateFileResponse.verify|verify} messages.
                     * @param message AsyncAnnotateFileResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAsyncAnnotateFileResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AsyncAnnotateFileResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncAnnotateFileResponse.verify|verify} messages.
                     * @param message AsyncAnnotateFileResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAsyncAnnotateFileResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AsyncAnnotateFileResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AsyncAnnotateFileResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AsyncAnnotateFileResponse;

                    /**
                     * Decodes an AsyncAnnotateFileResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AsyncAnnotateFileResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AsyncAnnotateFileResponse;

                    /**
                     * Verifies an AsyncAnnotateFileResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AsyncAnnotateFileResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AsyncAnnotateFileResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AsyncAnnotateFileResponse;

                    /**
                     * Creates a plain object from an AsyncAnnotateFileResponse message. Also converts values to other types if specified.
                     * @param message AsyncAnnotateFileResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AsyncAnnotateFileResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AsyncAnnotateFileResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AsyncAnnotateFileResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AsyncBatchAnnotateImagesRequest. */
                interface IAsyncBatchAnnotateImagesRequest {

                    /** AsyncBatchAnnotateImagesRequest requests */
                    requests?: (google.cloud.vision.v1.IAnnotateImageRequest[]|null);

                    /** AsyncBatchAnnotateImagesRequest outputConfig */
                    outputConfig?: (google.cloud.vision.v1.IOutputConfig|null);

                    /** AsyncBatchAnnotateImagesRequest parent */
                    parent?: (string|null);

                    /** AsyncBatchAnnotateImagesRequest labels */
                    labels?: ({ [k: string]: string }|null);
                }

                /** Represents an AsyncBatchAnnotateImagesRequest. */
                class AsyncBatchAnnotateImagesRequest implements IAsyncBatchAnnotateImagesRequest {

                    /**
                     * Constructs a new AsyncBatchAnnotateImagesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest);

                    /** AsyncBatchAnnotateImagesRequest requests. */
                    public requests: google.cloud.vision.v1.IAnnotateImageRequest[];

                    /** AsyncBatchAnnotateImagesRequest outputConfig. */
                    public outputConfig?: (google.cloud.vision.v1.IOutputConfig|null);

                    /** AsyncBatchAnnotateImagesRequest parent. */
                    public parent: string;

                    /** AsyncBatchAnnotateImagesRequest labels. */
                    public labels: { [k: string]: string };

                    /**
                     * Creates a new AsyncBatchAnnotateImagesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AsyncBatchAnnotateImagesRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest): google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest;

                    /**
                     * Encodes the specified AsyncBatchAnnotateImagesRequest message. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.verify|verify} messages.
                     * @param message AsyncBatchAnnotateImagesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AsyncBatchAnnotateImagesRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.verify|verify} messages.
                     * @param message AsyncBatchAnnotateImagesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AsyncBatchAnnotateImagesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AsyncBatchAnnotateImagesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest;

                    /**
                     * Decodes an AsyncBatchAnnotateImagesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AsyncBatchAnnotateImagesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest;

                    /**
                     * Verifies an AsyncBatchAnnotateImagesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AsyncBatchAnnotateImagesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AsyncBatchAnnotateImagesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest;

                    /**
                     * Creates a plain object from an AsyncBatchAnnotateImagesRequest message. Also converts values to other types if specified.
                     * @param message AsyncBatchAnnotateImagesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AsyncBatchAnnotateImagesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AsyncBatchAnnotateImagesRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AsyncBatchAnnotateImagesResponse. */
                interface IAsyncBatchAnnotateImagesResponse {

                    /** AsyncBatchAnnotateImagesResponse outputConfig */
                    outputConfig?: (google.cloud.vision.v1.IOutputConfig|null);
                }

                /** Represents an AsyncBatchAnnotateImagesResponse. */
                class AsyncBatchAnnotateImagesResponse implements IAsyncBatchAnnotateImagesResponse {

                    /**
                     * Constructs a new AsyncBatchAnnotateImagesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAsyncBatchAnnotateImagesResponse);

                    /** AsyncBatchAnnotateImagesResponse outputConfig. */
                    public outputConfig?: (google.cloud.vision.v1.IOutputConfig|null);

                    /**
                     * Creates a new AsyncBatchAnnotateImagesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AsyncBatchAnnotateImagesResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAsyncBatchAnnotateImagesResponse): google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse;

                    /**
                     * Encodes the specified AsyncBatchAnnotateImagesResponse message. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse.verify|verify} messages.
                     * @param message AsyncBatchAnnotateImagesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAsyncBatchAnnotateImagesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AsyncBatchAnnotateImagesResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse.verify|verify} messages.
                     * @param message AsyncBatchAnnotateImagesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAsyncBatchAnnotateImagesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AsyncBatchAnnotateImagesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AsyncBatchAnnotateImagesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse;

                    /**
                     * Decodes an AsyncBatchAnnotateImagesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AsyncBatchAnnotateImagesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse;

                    /**
                     * Verifies an AsyncBatchAnnotateImagesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AsyncBatchAnnotateImagesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AsyncBatchAnnotateImagesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse;

                    /**
                     * Creates a plain object from an AsyncBatchAnnotateImagesResponse message. Also converts values to other types if specified.
                     * @param message AsyncBatchAnnotateImagesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AsyncBatchAnnotateImagesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AsyncBatchAnnotateImagesResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AsyncBatchAnnotateFilesRequest. */
                interface IAsyncBatchAnnotateFilesRequest {

                    /** AsyncBatchAnnotateFilesRequest requests */
                    requests?: (google.cloud.vision.v1.IAsyncAnnotateFileRequest[]|null);

                    /** AsyncBatchAnnotateFilesRequest parent */
                    parent?: (string|null);

                    /** AsyncBatchAnnotateFilesRequest labels */
                    labels?: ({ [k: string]: string }|null);
                }

                /** Represents an AsyncBatchAnnotateFilesRequest. */
                class AsyncBatchAnnotateFilesRequest implements IAsyncBatchAnnotateFilesRequest {

                    /**
                     * Constructs a new AsyncBatchAnnotateFilesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest);

                    /** AsyncBatchAnnotateFilesRequest requests. */
                    public requests: google.cloud.vision.v1.IAsyncAnnotateFileRequest[];

                    /** AsyncBatchAnnotateFilesRequest parent. */
                    public parent: string;

                    /** AsyncBatchAnnotateFilesRequest labels. */
                    public labels: { [k: string]: string };

                    /**
                     * Creates a new AsyncBatchAnnotateFilesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AsyncBatchAnnotateFilesRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest): google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest;

                    /**
                     * Encodes the specified AsyncBatchAnnotateFilesRequest message. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.verify|verify} messages.
                     * @param message AsyncBatchAnnotateFilesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AsyncBatchAnnotateFilesRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.verify|verify} messages.
                     * @param message AsyncBatchAnnotateFilesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AsyncBatchAnnotateFilesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AsyncBatchAnnotateFilesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest;

                    /**
                     * Decodes an AsyncBatchAnnotateFilesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AsyncBatchAnnotateFilesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest;

                    /**
                     * Verifies an AsyncBatchAnnotateFilesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AsyncBatchAnnotateFilesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AsyncBatchAnnotateFilesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest;

                    /**
                     * Creates a plain object from an AsyncBatchAnnotateFilesRequest message. Also converts values to other types if specified.
                     * @param message AsyncBatchAnnotateFilesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AsyncBatchAnnotateFilesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AsyncBatchAnnotateFilesRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AsyncBatchAnnotateFilesResponse. */
                interface IAsyncBatchAnnotateFilesResponse {

                    /** AsyncBatchAnnotateFilesResponse responses */
                    responses?: (google.cloud.vision.v1.IAsyncAnnotateFileResponse[]|null);
                }

                /** Represents an AsyncBatchAnnotateFilesResponse. */
                class AsyncBatchAnnotateFilesResponse implements IAsyncBatchAnnotateFilesResponse {

                    /**
                     * Constructs a new AsyncBatchAnnotateFilesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAsyncBatchAnnotateFilesResponse);

                    /** AsyncBatchAnnotateFilesResponse responses. */
                    public responses: google.cloud.vision.v1.IAsyncAnnotateFileResponse[];

                    /**
                     * Creates a new AsyncBatchAnnotateFilesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AsyncBatchAnnotateFilesResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAsyncBatchAnnotateFilesResponse): google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse;

                    /**
                     * Encodes the specified AsyncBatchAnnotateFilesResponse message. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse.verify|verify} messages.
                     * @param message AsyncBatchAnnotateFilesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAsyncBatchAnnotateFilesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AsyncBatchAnnotateFilesResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse.verify|verify} messages.
                     * @param message AsyncBatchAnnotateFilesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAsyncBatchAnnotateFilesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AsyncBatchAnnotateFilesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AsyncBatchAnnotateFilesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse;

                    /**
                     * Decodes an AsyncBatchAnnotateFilesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AsyncBatchAnnotateFilesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse;

                    /**
                     * Verifies an AsyncBatchAnnotateFilesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AsyncBatchAnnotateFilesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AsyncBatchAnnotateFilesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse;

                    /**
                     * Creates a plain object from an AsyncBatchAnnotateFilesResponse message. Also converts values to other types if specified.
                     * @param message AsyncBatchAnnotateFilesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AsyncBatchAnnotateFilesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AsyncBatchAnnotateFilesResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an InputConfig. */
                interface IInputConfig {

                    /** InputConfig gcsSource */
                    gcsSource?: (google.cloud.vision.v1.IGcsSource|null);

                    /** InputConfig content */
                    content?: (Uint8Array|Buffer|string|null);

                    /** InputConfig mimeType */
                    mimeType?: (string|null);
                }

                /** Represents an InputConfig. */
                class InputConfig implements IInputConfig {

                    /**
                     * Constructs a new InputConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IInputConfig);

                    /** InputConfig gcsSource. */
                    public gcsSource?: (google.cloud.vision.v1.IGcsSource|null);

                    /** InputConfig content. */
                    public content: (Uint8Array|Buffer|string);

                    /** InputConfig mimeType. */
                    public mimeType: string;

                    /**
                     * Creates a new InputConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns InputConfig instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IInputConfig): google.cloud.vision.v1.InputConfig;

                    /**
                     * Encodes the specified InputConfig message. Does not implicitly {@link google.cloud.vision.v1.InputConfig.verify|verify} messages.
                     * @param message InputConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IInputConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified InputConfig message, length delimited. Does not implicitly {@link google.cloud.vision.v1.InputConfig.verify|verify} messages.
                     * @param message InputConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IInputConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an InputConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns InputConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.InputConfig;

                    /**
                     * Decodes an InputConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns InputConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.InputConfig;

                    /**
                     * Verifies an InputConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an InputConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns InputConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.InputConfig;

                    /**
                     * Creates a plain object from an InputConfig message. Also converts values to other types if specified.
                     * @param message InputConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.InputConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this InputConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for InputConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an OutputConfig. */
                interface IOutputConfig {

                    /** OutputConfig gcsDestination */
                    gcsDestination?: (google.cloud.vision.v1.IGcsDestination|null);

                    /** OutputConfig batchSize */
                    batchSize?: (number|null);
                }

                /** Represents an OutputConfig. */
                class OutputConfig implements IOutputConfig {

                    /**
                     * Constructs a new OutputConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IOutputConfig);

                    /** OutputConfig gcsDestination. */
                    public gcsDestination?: (google.cloud.vision.v1.IGcsDestination|null);

                    /** OutputConfig batchSize. */
                    public batchSize: number;

                    /**
                     * Creates a new OutputConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns OutputConfig instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IOutputConfig): google.cloud.vision.v1.OutputConfig;

                    /**
                     * Encodes the specified OutputConfig message. Does not implicitly {@link google.cloud.vision.v1.OutputConfig.verify|verify} messages.
                     * @param message OutputConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IOutputConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified OutputConfig message, length delimited. Does not implicitly {@link google.cloud.vision.v1.OutputConfig.verify|verify} messages.
                     * @param message OutputConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IOutputConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an OutputConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns OutputConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.OutputConfig;

                    /**
                     * Decodes an OutputConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns OutputConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.OutputConfig;

                    /**
                     * Verifies an OutputConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an OutputConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns OutputConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.OutputConfig;

                    /**
                     * Creates a plain object from an OutputConfig message. Also converts values to other types if specified.
                     * @param message OutputConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.OutputConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this OutputConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for OutputConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GcsSource. */
                interface IGcsSource {

                    /** GcsSource uri */
                    uri?: (string|null);
                }

                /** Represents a GcsSource. */
                class GcsSource implements IGcsSource {

                    /**
                     * Constructs a new GcsSource.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IGcsSource);

                    /** GcsSource uri. */
                    public uri: string;

                    /**
                     * Creates a new GcsSource instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GcsSource instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IGcsSource): google.cloud.vision.v1.GcsSource;

                    /**
                     * Encodes the specified GcsSource message. Does not implicitly {@link google.cloud.vision.v1.GcsSource.verify|verify} messages.
                     * @param message GcsSource message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IGcsSource, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GcsSource message, length delimited. Does not implicitly {@link google.cloud.vision.v1.GcsSource.verify|verify} messages.
                     * @param message GcsSource message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IGcsSource, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GcsSource message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GcsSource
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.GcsSource;

                    /**
                     * Decodes a GcsSource message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GcsSource
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.GcsSource;

                    /**
                     * Verifies a GcsSource message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GcsSource message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GcsSource
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.GcsSource;

                    /**
                     * Creates a plain object from a GcsSource message. Also converts values to other types if specified.
                     * @param message GcsSource
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.GcsSource, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GcsSource to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GcsSource
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GcsDestination. */
                interface IGcsDestination {

                    /** GcsDestination uri */
                    uri?: (string|null);
                }

                /** Represents a GcsDestination. */
                class GcsDestination implements IGcsDestination {

                    /**
                     * Constructs a new GcsDestination.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IGcsDestination);

                    /** GcsDestination uri. */
                    public uri: string;

                    /**
                     * Creates a new GcsDestination instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GcsDestination instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IGcsDestination): google.cloud.vision.v1.GcsDestination;

                    /**
                     * Encodes the specified GcsDestination message. Does not implicitly {@link google.cloud.vision.v1.GcsDestination.verify|verify} messages.
                     * @param message GcsDestination message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IGcsDestination, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GcsDestination message, length delimited. Does not implicitly {@link google.cloud.vision.v1.GcsDestination.verify|verify} messages.
                     * @param message GcsDestination message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IGcsDestination, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GcsDestination message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GcsDestination
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.GcsDestination;

                    /**
                     * Decodes a GcsDestination message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GcsDestination
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.GcsDestination;

                    /**
                     * Verifies a GcsDestination message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GcsDestination message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GcsDestination
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.GcsDestination;

                    /**
                     * Creates a plain object from a GcsDestination message. Also converts values to other types if specified.
                     * @param message GcsDestination
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.GcsDestination, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GcsDestination to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GcsDestination
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an OperationMetadata. */
                interface IOperationMetadata {

                    /** OperationMetadata state */
                    state?: (google.cloud.vision.v1.OperationMetadata.State|keyof typeof google.cloud.vision.v1.OperationMetadata.State|null);

                    /** OperationMetadata createTime */
                    createTime?: (google.protobuf.ITimestamp|null);

                    /** OperationMetadata updateTime */
                    updateTime?: (google.protobuf.ITimestamp|null);
                }

                /** Represents an OperationMetadata. */
                class OperationMetadata implements IOperationMetadata {

                    /**
                     * Constructs a new OperationMetadata.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IOperationMetadata);

                    /** OperationMetadata state. */
                    public state: (google.cloud.vision.v1.OperationMetadata.State|keyof typeof google.cloud.vision.v1.OperationMetadata.State);

                    /** OperationMetadata createTime. */
                    public createTime?: (google.protobuf.ITimestamp|null);

                    /** OperationMetadata updateTime. */
                    public updateTime?: (google.protobuf.ITimestamp|null);

                    /**
                     * Creates a new OperationMetadata instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns OperationMetadata instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IOperationMetadata): google.cloud.vision.v1.OperationMetadata;

                    /**
                     * Encodes the specified OperationMetadata message. Does not implicitly {@link google.cloud.vision.v1.OperationMetadata.verify|verify} messages.
                     * @param message OperationMetadata message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IOperationMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified OperationMetadata message, length delimited. Does not implicitly {@link google.cloud.vision.v1.OperationMetadata.verify|verify} messages.
                     * @param message OperationMetadata message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IOperationMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an OperationMetadata message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns OperationMetadata
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.OperationMetadata;

                    /**
                     * Decodes an OperationMetadata message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns OperationMetadata
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.OperationMetadata;

                    /**
                     * Verifies an OperationMetadata message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an OperationMetadata message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns OperationMetadata
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.OperationMetadata;

                    /**
                     * Creates a plain object from an OperationMetadata message. Also converts values to other types if specified.
                     * @param message OperationMetadata
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.OperationMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this OperationMetadata to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for OperationMetadata
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace OperationMetadata {

                    /** State enum. */
                    enum State {
                        STATE_UNSPECIFIED = 0,
                        CREATED = 1,
                        RUNNING = 2,
                        DONE = 3,
                        CANCELLED = 4
                    }
                }

                /** Properties of a ProductSearchParams. */
                interface IProductSearchParams {

                    /** ProductSearchParams boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** ProductSearchParams productSet */
                    productSet?: (string|null);

                    /** ProductSearchParams productCategories */
                    productCategories?: (string[]|null);

                    /** ProductSearchParams filter */
                    filter?: (string|null);
                }

                /** Represents a ProductSearchParams. */
                class ProductSearchParams implements IProductSearchParams {

                    /**
                     * Constructs a new ProductSearchParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IProductSearchParams);

                    /** ProductSearchParams boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** ProductSearchParams productSet. */
                    public productSet: string;

                    /** ProductSearchParams productCategories. */
                    public productCategories: string[];

                    /** ProductSearchParams filter. */
                    public filter: string;

                    /**
                     * Creates a new ProductSearchParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ProductSearchParams instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IProductSearchParams): google.cloud.vision.v1.ProductSearchParams;

                    /**
                     * Encodes the specified ProductSearchParams message. Does not implicitly {@link google.cloud.vision.v1.ProductSearchParams.verify|verify} messages.
                     * @param message ProductSearchParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IProductSearchParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ProductSearchParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSearchParams.verify|verify} messages.
                     * @param message ProductSearchParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IProductSearchParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ProductSearchParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ProductSearchParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ProductSearchParams;

                    /**
                     * Decodes a ProductSearchParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ProductSearchParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ProductSearchParams;

                    /**
                     * Verifies a ProductSearchParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ProductSearchParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ProductSearchParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ProductSearchParams;

                    /**
                     * Creates a plain object from a ProductSearchParams message. Also converts values to other types if specified.
                     * @param message ProductSearchParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ProductSearchParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ProductSearchParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ProductSearchParams
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ProductSearchResults. */
                interface IProductSearchResults {

                    /** ProductSearchResults indexTime */
                    indexTime?: (google.protobuf.ITimestamp|null);

                    /** ProductSearchResults results */
                    results?: (google.cloud.vision.v1.ProductSearchResults.IResult[]|null);

                    /** ProductSearchResults productGroupedResults */
                    productGroupedResults?: (google.cloud.vision.v1.ProductSearchResults.IGroupedResult[]|null);
                }

                /** Represents a ProductSearchResults. */
                class ProductSearchResults implements IProductSearchResults {

                    /**
                     * Constructs a new ProductSearchResults.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IProductSearchResults);

                    /** ProductSearchResults indexTime. */
                    public indexTime?: (google.protobuf.ITimestamp|null);

                    /** ProductSearchResults results. */
                    public results: google.cloud.vision.v1.ProductSearchResults.IResult[];

                    /** ProductSearchResults productGroupedResults. */
                    public productGroupedResults: google.cloud.vision.v1.ProductSearchResults.IGroupedResult[];

                    /**
                     * Creates a new ProductSearchResults instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ProductSearchResults instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IProductSearchResults): google.cloud.vision.v1.ProductSearchResults;

                    /**
                     * Encodes the specified ProductSearchResults message. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.verify|verify} messages.
                     * @param message ProductSearchResults message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IProductSearchResults, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ProductSearchResults message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.verify|verify} messages.
                     * @param message ProductSearchResults message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IProductSearchResults, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ProductSearchResults message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ProductSearchResults
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ProductSearchResults;

                    /**
                     * Decodes a ProductSearchResults message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ProductSearchResults
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ProductSearchResults;

                    /**
                     * Verifies a ProductSearchResults message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ProductSearchResults message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ProductSearchResults
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ProductSearchResults;

                    /**
                     * Creates a plain object from a ProductSearchResults message. Also converts values to other types if specified.
                     * @param message ProductSearchResults
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ProductSearchResults, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ProductSearchResults to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ProductSearchResults
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace ProductSearchResults {

                    /** Properties of a Result. */
                    interface IResult {

                        /** Result product */
                        product?: (google.cloud.vision.v1.IProduct|null);

                        /** Result score */
                        score?: (number|null);

                        /** Result image */
                        image?: (string|null);
                    }

                    /** Represents a Result. */
                    class Result implements IResult {

                        /**
                         * Constructs a new Result.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.ProductSearchResults.IResult);

                        /** Result product. */
                        public product?: (google.cloud.vision.v1.IProduct|null);

                        /** Result score. */
                        public score: number;

                        /** Result image. */
                        public image: string;

                        /**
                         * Creates a new Result instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Result instance
                         */
                        public static create(properties?: google.cloud.vision.v1.ProductSearchResults.IResult): google.cloud.vision.v1.ProductSearchResults.Result;

                        /**
                         * Encodes the specified Result message. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.Result.verify|verify} messages.
                         * @param message Result message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.ProductSearchResults.IResult, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Result message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.Result.verify|verify} messages.
                         * @param message Result message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.ProductSearchResults.IResult, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Result message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Result
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ProductSearchResults.Result;

                        /**
                         * Decodes a Result message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Result
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ProductSearchResults.Result;

                        /**
                         * Verifies a Result message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Result message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Result
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ProductSearchResults.Result;

                        /**
                         * Creates a plain object from a Result message. Also converts values to other types if specified.
                         * @param message Result
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.ProductSearchResults.Result, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Result to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for Result
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of an ObjectAnnotation. */
                    interface IObjectAnnotation {

                        /** ObjectAnnotation mid */
                        mid?: (string|null);

                        /** ObjectAnnotation languageCode */
                        languageCode?: (string|null);

                        /** ObjectAnnotation name */
                        name?: (string|null);

                        /** ObjectAnnotation score */
                        score?: (number|null);
                    }

                    /** Represents an ObjectAnnotation. */
                    class ObjectAnnotation implements IObjectAnnotation {

                        /**
                         * Constructs a new ObjectAnnotation.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation);

                        /** ObjectAnnotation mid. */
                        public mid: string;

                        /** ObjectAnnotation languageCode. */
                        public languageCode: string;

                        /** ObjectAnnotation name. */
                        public name: string;

                        /** ObjectAnnotation score. */
                        public score: number;

                        /**
                         * Creates a new ObjectAnnotation instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ObjectAnnotation instance
                         */
                        public static create(properties?: google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation): google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation;

                        /**
                         * Encodes the specified ObjectAnnotation message. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation.verify|verify} messages.
                         * @param message ObjectAnnotation message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ObjectAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation.verify|verify} messages.
                         * @param message ObjectAnnotation message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an ObjectAnnotation message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ObjectAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation;

                        /**
                         * Decodes an ObjectAnnotation message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ObjectAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation;

                        /**
                         * Verifies an ObjectAnnotation message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an ObjectAnnotation message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ObjectAnnotation
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation;

                        /**
                         * Creates a plain object from an ObjectAnnotation message. Also converts values to other types if specified.
                         * @param message ObjectAnnotation
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ObjectAnnotation to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for ObjectAnnotation
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a GroupedResult. */
                    interface IGroupedResult {

                        /** GroupedResult boundingPoly */
                        boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                        /** GroupedResult results */
                        results?: (google.cloud.vision.v1.ProductSearchResults.IResult[]|null);

                        /** GroupedResult objectAnnotations */
                        objectAnnotations?: (google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation[]|null);
                    }

                    /** Represents a GroupedResult. */
                    class GroupedResult implements IGroupedResult {

                        /**
                         * Constructs a new GroupedResult.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.ProductSearchResults.IGroupedResult);

                        /** GroupedResult boundingPoly. */
                        public boundingPoly?: (google.cloud.vision.v1.IBoundingPoly|null);

                        /** GroupedResult results. */
                        public results: google.cloud.vision.v1.ProductSearchResults.IResult[];

                        /** GroupedResult objectAnnotations. */
                        public objectAnnotations: google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation[];

                        /**
                         * Creates a new GroupedResult instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GroupedResult instance
                         */
                        public static create(properties?: google.cloud.vision.v1.ProductSearchResults.IGroupedResult): google.cloud.vision.v1.ProductSearchResults.GroupedResult;

                        /**
                         * Encodes the specified GroupedResult message. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.GroupedResult.verify|verify} messages.
                         * @param message GroupedResult message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.ProductSearchResults.IGroupedResult, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GroupedResult message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.GroupedResult.verify|verify} messages.
                         * @param message GroupedResult message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.ProductSearchResults.IGroupedResult, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GroupedResult message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GroupedResult
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ProductSearchResults.GroupedResult;

                        /**
                         * Decodes a GroupedResult message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GroupedResult
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ProductSearchResults.GroupedResult;

                        /**
                         * Verifies a GroupedResult message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GroupedResult message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GroupedResult
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ProductSearchResults.GroupedResult;

                        /**
                         * Creates a plain object from a GroupedResult message. Also converts values to other types if specified.
                         * @param message GroupedResult
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.ProductSearchResults.GroupedResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GroupedResult to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for GroupedResult
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }

                /** Represents a ProductSearch */
                class ProductSearch extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new ProductSearch service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new ProductSearch service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): ProductSearch;

                    /**
                     * Calls CreateProductSet.
                     * @param request CreateProductSetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ProductSet
                     */
                    public createProductSet(request: google.cloud.vision.v1.ICreateProductSetRequest, callback: google.cloud.vision.v1.ProductSearch.CreateProductSetCallback): void;

                    /**
                     * Calls CreateProductSet.
                     * @param request CreateProductSetRequest message or plain object
                     * @returns Promise
                     */
                    public createProductSet(request: google.cloud.vision.v1.ICreateProductSetRequest): Promise<google.cloud.vision.v1.ProductSet>;

                    /**
                     * Calls ListProductSets.
                     * @param request ListProductSetsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListProductSetsResponse
                     */
                    public listProductSets(request: google.cloud.vision.v1.IListProductSetsRequest, callback: google.cloud.vision.v1.ProductSearch.ListProductSetsCallback): void;

                    /**
                     * Calls ListProductSets.
                     * @param request ListProductSetsRequest message or plain object
                     * @returns Promise
                     */
                    public listProductSets(request: google.cloud.vision.v1.IListProductSetsRequest): Promise<google.cloud.vision.v1.ListProductSetsResponse>;

                    /**
                     * Calls GetProductSet.
                     * @param request GetProductSetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ProductSet
                     */
                    public getProductSet(request: google.cloud.vision.v1.IGetProductSetRequest, callback: google.cloud.vision.v1.ProductSearch.GetProductSetCallback): void;

                    /**
                     * Calls GetProductSet.
                     * @param request GetProductSetRequest message or plain object
                     * @returns Promise
                     */
                    public getProductSet(request: google.cloud.vision.v1.IGetProductSetRequest): Promise<google.cloud.vision.v1.ProductSet>;

                    /**
                     * Calls UpdateProductSet.
                     * @param request UpdateProductSetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ProductSet
                     */
                    public updateProductSet(request: google.cloud.vision.v1.IUpdateProductSetRequest, callback: google.cloud.vision.v1.ProductSearch.UpdateProductSetCallback): void;

                    /**
                     * Calls UpdateProductSet.
                     * @param request UpdateProductSetRequest message or plain object
                     * @returns Promise
                     */
                    public updateProductSet(request: google.cloud.vision.v1.IUpdateProductSetRequest): Promise<google.cloud.vision.v1.ProductSet>;

                    /**
                     * Calls DeleteProductSet.
                     * @param request DeleteProductSetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteProductSet(request: google.cloud.vision.v1.IDeleteProductSetRequest, callback: google.cloud.vision.v1.ProductSearch.DeleteProductSetCallback): void;

                    /**
                     * Calls DeleteProductSet.
                     * @param request DeleteProductSetRequest message or plain object
                     * @returns Promise
                     */
                    public deleteProductSet(request: google.cloud.vision.v1.IDeleteProductSetRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls CreateProduct.
                     * @param request CreateProductRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Product
                     */
                    public createProduct(request: google.cloud.vision.v1.ICreateProductRequest, callback: google.cloud.vision.v1.ProductSearch.CreateProductCallback): void;

                    /**
                     * Calls CreateProduct.
                     * @param request CreateProductRequest message or plain object
                     * @returns Promise
                     */
                    public createProduct(request: google.cloud.vision.v1.ICreateProductRequest): Promise<google.cloud.vision.v1.Product>;

                    /**
                     * Calls ListProducts.
                     * @param request ListProductsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListProductsResponse
                     */
                    public listProducts(request: google.cloud.vision.v1.IListProductsRequest, callback: google.cloud.vision.v1.ProductSearch.ListProductsCallback): void;

                    /**
                     * Calls ListProducts.
                     * @param request ListProductsRequest message or plain object
                     * @returns Promise
                     */
                    public listProducts(request: google.cloud.vision.v1.IListProductsRequest): Promise<google.cloud.vision.v1.ListProductsResponse>;

                    /**
                     * Calls GetProduct.
                     * @param request GetProductRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Product
                     */
                    public getProduct(request: google.cloud.vision.v1.IGetProductRequest, callback: google.cloud.vision.v1.ProductSearch.GetProductCallback): void;

                    /**
                     * Calls GetProduct.
                     * @param request GetProductRequest message or plain object
                     * @returns Promise
                     */
                    public getProduct(request: google.cloud.vision.v1.IGetProductRequest): Promise<google.cloud.vision.v1.Product>;

                    /**
                     * Calls UpdateProduct.
                     * @param request UpdateProductRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Product
                     */
                    public updateProduct(request: google.cloud.vision.v1.IUpdateProductRequest, callback: google.cloud.vision.v1.ProductSearch.UpdateProductCallback): void;

                    /**
                     * Calls UpdateProduct.
                     * @param request UpdateProductRequest message or plain object
                     * @returns Promise
                     */
                    public updateProduct(request: google.cloud.vision.v1.IUpdateProductRequest): Promise<google.cloud.vision.v1.Product>;

                    /**
                     * Calls DeleteProduct.
                     * @param request DeleteProductRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteProduct(request: google.cloud.vision.v1.IDeleteProductRequest, callback: google.cloud.vision.v1.ProductSearch.DeleteProductCallback): void;

                    /**
                     * Calls DeleteProduct.
                     * @param request DeleteProductRequest message or plain object
                     * @returns Promise
                     */
                    public deleteProduct(request: google.cloud.vision.v1.IDeleteProductRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls CreateReferenceImage.
                     * @param request CreateReferenceImageRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ReferenceImage
                     */
                    public createReferenceImage(request: google.cloud.vision.v1.ICreateReferenceImageRequest, callback: google.cloud.vision.v1.ProductSearch.CreateReferenceImageCallback): void;

                    /**
                     * Calls CreateReferenceImage.
                     * @param request CreateReferenceImageRequest message or plain object
                     * @returns Promise
                     */
                    public createReferenceImage(request: google.cloud.vision.v1.ICreateReferenceImageRequest): Promise<google.cloud.vision.v1.ReferenceImage>;

                    /**
                     * Calls DeleteReferenceImage.
                     * @param request DeleteReferenceImageRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteReferenceImage(request: google.cloud.vision.v1.IDeleteReferenceImageRequest, callback: google.cloud.vision.v1.ProductSearch.DeleteReferenceImageCallback): void;

                    /**
                     * Calls DeleteReferenceImage.
                     * @param request DeleteReferenceImageRequest message or plain object
                     * @returns Promise
                     */
                    public deleteReferenceImage(request: google.cloud.vision.v1.IDeleteReferenceImageRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls ListReferenceImages.
                     * @param request ListReferenceImagesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListReferenceImagesResponse
                     */
                    public listReferenceImages(request: google.cloud.vision.v1.IListReferenceImagesRequest, callback: google.cloud.vision.v1.ProductSearch.ListReferenceImagesCallback): void;

                    /**
                     * Calls ListReferenceImages.
                     * @param request ListReferenceImagesRequest message or plain object
                     * @returns Promise
                     */
                    public listReferenceImages(request: google.cloud.vision.v1.IListReferenceImagesRequest): Promise<google.cloud.vision.v1.ListReferenceImagesResponse>;

                    /**
                     * Calls GetReferenceImage.
                     * @param request GetReferenceImageRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ReferenceImage
                     */
                    public getReferenceImage(request: google.cloud.vision.v1.IGetReferenceImageRequest, callback: google.cloud.vision.v1.ProductSearch.GetReferenceImageCallback): void;

                    /**
                     * Calls GetReferenceImage.
                     * @param request GetReferenceImageRequest message or plain object
                     * @returns Promise
                     */
                    public getReferenceImage(request: google.cloud.vision.v1.IGetReferenceImageRequest): Promise<google.cloud.vision.v1.ReferenceImage>;

                    /**
                     * Calls AddProductToProductSet.
                     * @param request AddProductToProductSetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public addProductToProductSet(request: google.cloud.vision.v1.IAddProductToProductSetRequest, callback: google.cloud.vision.v1.ProductSearch.AddProductToProductSetCallback): void;

                    /**
                     * Calls AddProductToProductSet.
                     * @param request AddProductToProductSetRequest message or plain object
                     * @returns Promise
                     */
                    public addProductToProductSet(request: google.cloud.vision.v1.IAddProductToProductSetRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls RemoveProductFromProductSet.
                     * @param request RemoveProductFromProductSetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public removeProductFromProductSet(request: google.cloud.vision.v1.IRemoveProductFromProductSetRequest, callback: google.cloud.vision.v1.ProductSearch.RemoveProductFromProductSetCallback): void;

                    /**
                     * Calls RemoveProductFromProductSet.
                     * @param request RemoveProductFromProductSetRequest message or plain object
                     * @returns Promise
                     */
                    public removeProductFromProductSet(request: google.cloud.vision.v1.IRemoveProductFromProductSetRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls ListProductsInProductSet.
                     * @param request ListProductsInProductSetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListProductsInProductSetResponse
                     */
                    public listProductsInProductSet(request: google.cloud.vision.v1.IListProductsInProductSetRequest, callback: google.cloud.vision.v1.ProductSearch.ListProductsInProductSetCallback): void;

                    /**
                     * Calls ListProductsInProductSet.
                     * @param request ListProductsInProductSetRequest message or plain object
                     * @returns Promise
                     */
                    public listProductsInProductSet(request: google.cloud.vision.v1.IListProductsInProductSetRequest): Promise<google.cloud.vision.v1.ListProductsInProductSetResponse>;

                    /**
                     * Calls ImportProductSets.
                     * @param request ImportProductSetsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public importProductSets(request: google.cloud.vision.v1.IImportProductSetsRequest, callback: google.cloud.vision.v1.ProductSearch.ImportProductSetsCallback): void;

                    /**
                     * Calls ImportProductSets.
                     * @param request ImportProductSetsRequest message or plain object
                     * @returns Promise
                     */
                    public importProductSets(request: google.cloud.vision.v1.IImportProductSetsRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls PurgeProducts.
                     * @param request PurgeProductsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public purgeProducts(request: google.cloud.vision.v1.IPurgeProductsRequest, callback: google.cloud.vision.v1.ProductSearch.PurgeProductsCallback): void;

                    /**
                     * Calls PurgeProducts.
                     * @param request PurgeProductsRequest message or plain object
                     * @returns Promise
                     */
                    public purgeProducts(request: google.cloud.vision.v1.IPurgeProductsRequest): Promise<google.longrunning.Operation>;
                }

                namespace ProductSearch {

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|createProductSet}.
                     * @param error Error, if any
                     * @param [response] ProductSet
                     */
                    type CreateProductSetCallback = (error: (Error|null), response?: google.cloud.vision.v1.ProductSet) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|listProductSets}.
                     * @param error Error, if any
                     * @param [response] ListProductSetsResponse
                     */
                    type ListProductSetsCallback = (error: (Error|null), response?: google.cloud.vision.v1.ListProductSetsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|getProductSet}.
                     * @param error Error, if any
                     * @param [response] ProductSet
                     */
                    type GetProductSetCallback = (error: (Error|null), response?: google.cloud.vision.v1.ProductSet) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|updateProductSet}.
                     * @param error Error, if any
                     * @param [response] ProductSet
                     */
                    type UpdateProductSetCallback = (error: (Error|null), response?: google.cloud.vision.v1.ProductSet) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|deleteProductSet}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteProductSetCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|createProduct}.
                     * @param error Error, if any
                     * @param [response] Product
                     */
                    type CreateProductCallback = (error: (Error|null), response?: google.cloud.vision.v1.Product) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|listProducts}.
                     * @param error Error, if any
                     * @param [response] ListProductsResponse
                     */
                    type ListProductsCallback = (error: (Error|null), response?: google.cloud.vision.v1.ListProductsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|getProduct}.
                     * @param error Error, if any
                     * @param [response] Product
                     */
                    type GetProductCallback = (error: (Error|null), response?: google.cloud.vision.v1.Product) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|updateProduct}.
                     * @param error Error, if any
                     * @param [response] Product
                     */
                    type UpdateProductCallback = (error: (Error|null), response?: google.cloud.vision.v1.Product) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|deleteProduct}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteProductCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|createReferenceImage}.
                     * @param error Error, if any
                     * @param [response] ReferenceImage
                     */
                    type CreateReferenceImageCallback = (error: (Error|null), response?: google.cloud.vision.v1.ReferenceImage) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|deleteReferenceImage}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteReferenceImageCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|listReferenceImages}.
                     * @param error Error, if any
                     * @param [response] ListReferenceImagesResponse
                     */
                    type ListReferenceImagesCallback = (error: (Error|null), response?: google.cloud.vision.v1.ListReferenceImagesResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|getReferenceImage}.
                     * @param error Error, if any
                     * @param [response] ReferenceImage
                     */
                    type GetReferenceImageCallback = (error: (Error|null), response?: google.cloud.vision.v1.ReferenceImage) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|addProductToProductSet}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type AddProductToProductSetCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|removeProductFromProductSet}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type RemoveProductFromProductSetCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|listProductsInProductSet}.
                     * @param error Error, if any
                     * @param [response] ListProductsInProductSetResponse
                     */
                    type ListProductsInProductSetCallback = (error: (Error|null), response?: google.cloud.vision.v1.ListProductsInProductSetResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|importProductSets}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type ImportProductSetsCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1.ProductSearch|purgeProducts}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type PurgeProductsCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;
                }

                /** Properties of a Product. */
                interface IProduct {

                    /** Product name */
                    name?: (string|null);

                    /** Product displayName */
                    displayName?: (string|null);

                    /** Product description */
                    description?: (string|null);

                    /** Product productCategory */
                    productCategory?: (string|null);

                    /** Product productLabels */
                    productLabels?: (google.cloud.vision.v1.Product.IKeyValue[]|null);
                }

                /** Represents a Product. */
                class Product implements IProduct {

                    /**
                     * Constructs a new Product.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IProduct);

                    /** Product name. */
                    public name: string;

                    /** Product displayName. */
                    public displayName: string;

                    /** Product description. */
                    public description: string;

                    /** Product productCategory. */
                    public productCategory: string;

                    /** Product productLabels. */
                    public productLabels: google.cloud.vision.v1.Product.IKeyValue[];

                    /**
                     * Creates a new Product instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Product instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IProduct): google.cloud.vision.v1.Product;

                    /**
                     * Encodes the specified Product message. Does not implicitly {@link google.cloud.vision.v1.Product.verify|verify} messages.
                     * @param message Product message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IProduct, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Product message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Product.verify|verify} messages.
                     * @param message Product message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IProduct, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Product message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Product
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Product;

                    /**
                     * Decodes a Product message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Product
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Product;

                    /**
                     * Verifies a Product message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Product message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Product
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Product;

                    /**
                     * Creates a plain object from a Product message. Also converts values to other types if specified.
                     * @param message Product
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Product, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Product to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Product
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace Product {

                    /** Properties of a KeyValue. */
                    interface IKeyValue {

                        /** KeyValue key */
                        key?: (string|null);

                        /** KeyValue value */
                        value?: (string|null);
                    }

                    /** Represents a KeyValue. */
                    class KeyValue implements IKeyValue {

                        /**
                         * Constructs a new KeyValue.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.Product.IKeyValue);

                        /** KeyValue key. */
                        public key: string;

                        /** KeyValue value. */
                        public value: string;

                        /**
                         * Creates a new KeyValue instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns KeyValue instance
                         */
                        public static create(properties?: google.cloud.vision.v1.Product.IKeyValue): google.cloud.vision.v1.Product.KeyValue;

                        /**
                         * Encodes the specified KeyValue message. Does not implicitly {@link google.cloud.vision.v1.Product.KeyValue.verify|verify} messages.
                         * @param message KeyValue message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.Product.IKeyValue, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified KeyValue message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Product.KeyValue.verify|verify} messages.
                         * @param message KeyValue message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.Product.IKeyValue, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a KeyValue message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns KeyValue
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Product.KeyValue;

                        /**
                         * Decodes a KeyValue message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns KeyValue
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Product.KeyValue;

                        /**
                         * Verifies a KeyValue message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a KeyValue message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns KeyValue
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Product.KeyValue;

                        /**
                         * Creates a plain object from a KeyValue message. Also converts values to other types if specified.
                         * @param message KeyValue
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.Product.KeyValue, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this KeyValue to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for KeyValue
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }

                /** Properties of a ProductSet. */
                interface IProductSet {

                    /** ProductSet name */
                    name?: (string|null);

                    /** ProductSet displayName */
                    displayName?: (string|null);

                    /** ProductSet indexTime */
                    indexTime?: (google.protobuf.ITimestamp|null);

                    /** ProductSet indexError */
                    indexError?: (google.rpc.IStatus|null);
                }

                /** Represents a ProductSet. */
                class ProductSet implements IProductSet {

                    /**
                     * Constructs a new ProductSet.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IProductSet);

                    /** ProductSet name. */
                    public name: string;

                    /** ProductSet displayName. */
                    public displayName: string;

                    /** ProductSet indexTime. */
                    public indexTime?: (google.protobuf.ITimestamp|null);

                    /** ProductSet indexError. */
                    public indexError?: (google.rpc.IStatus|null);

                    /**
                     * Creates a new ProductSet instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ProductSet instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IProductSet): google.cloud.vision.v1.ProductSet;

                    /**
                     * Encodes the specified ProductSet message. Does not implicitly {@link google.cloud.vision.v1.ProductSet.verify|verify} messages.
                     * @param message ProductSet message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IProductSet, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ProductSet message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSet.verify|verify} messages.
                     * @param message ProductSet message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IProductSet, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ProductSet message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ProductSet
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ProductSet;

                    /**
                     * Decodes a ProductSet message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ProductSet
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ProductSet;

                    /**
                     * Verifies a ProductSet message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ProductSet message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ProductSet
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ProductSet;

                    /**
                     * Creates a plain object from a ProductSet message. Also converts values to other types if specified.
                     * @param message ProductSet
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ProductSet, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ProductSet to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ProductSet
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ReferenceImage. */
                interface IReferenceImage {

                    /** ReferenceImage name */
                    name?: (string|null);

                    /** ReferenceImage uri */
                    uri?: (string|null);

                    /** ReferenceImage boundingPolys */
                    boundingPolys?: (google.cloud.vision.v1.IBoundingPoly[]|null);
                }

                /** Represents a ReferenceImage. */
                class ReferenceImage implements IReferenceImage {

                    /**
                     * Constructs a new ReferenceImage.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IReferenceImage);

                    /** ReferenceImage name. */
                    public name: string;

                    /** ReferenceImage uri. */
                    public uri: string;

                    /** ReferenceImage boundingPolys. */
                    public boundingPolys: google.cloud.vision.v1.IBoundingPoly[];

                    /**
                     * Creates a new ReferenceImage instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ReferenceImage instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IReferenceImage): google.cloud.vision.v1.ReferenceImage;

                    /**
                     * Encodes the specified ReferenceImage message. Does not implicitly {@link google.cloud.vision.v1.ReferenceImage.verify|verify} messages.
                     * @param message ReferenceImage message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IReferenceImage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ReferenceImage message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ReferenceImage.verify|verify} messages.
                     * @param message ReferenceImage message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IReferenceImage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ReferenceImage message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ReferenceImage
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ReferenceImage;

                    /**
                     * Decodes a ReferenceImage message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ReferenceImage
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ReferenceImage;

                    /**
                     * Verifies a ReferenceImage message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ReferenceImage message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ReferenceImage
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ReferenceImage;

                    /**
                     * Creates a plain object from a ReferenceImage message. Also converts values to other types if specified.
                     * @param message ReferenceImage
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ReferenceImage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ReferenceImage to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ReferenceImage
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateProductRequest. */
                interface ICreateProductRequest {

                    /** CreateProductRequest parent */
                    parent?: (string|null);

                    /** CreateProductRequest product */
                    product?: (google.cloud.vision.v1.IProduct|null);

                    /** CreateProductRequest productId */
                    productId?: (string|null);
                }

                /** Represents a CreateProductRequest. */
                class CreateProductRequest implements ICreateProductRequest {

                    /**
                     * Constructs a new CreateProductRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ICreateProductRequest);

                    /** CreateProductRequest parent. */
                    public parent: string;

                    /** CreateProductRequest product. */
                    public product?: (google.cloud.vision.v1.IProduct|null);

                    /** CreateProductRequest productId. */
                    public productId: string;

                    /**
                     * Creates a new CreateProductRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateProductRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ICreateProductRequest): google.cloud.vision.v1.CreateProductRequest;

                    /**
                     * Encodes the specified CreateProductRequest message. Does not implicitly {@link google.cloud.vision.v1.CreateProductRequest.verify|verify} messages.
                     * @param message CreateProductRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ICreateProductRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateProductRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.CreateProductRequest.verify|verify} messages.
                     * @param message CreateProductRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ICreateProductRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateProductRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateProductRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.CreateProductRequest;

                    /**
                     * Decodes a CreateProductRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateProductRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.CreateProductRequest;

                    /**
                     * Verifies a CreateProductRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateProductRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateProductRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.CreateProductRequest;

                    /**
                     * Creates a plain object from a CreateProductRequest message. Also converts values to other types if specified.
                     * @param message CreateProductRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.CreateProductRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateProductRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateProductRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListProductsRequest. */
                interface IListProductsRequest {

                    /** ListProductsRequest parent */
                    parent?: (string|null);

                    /** ListProductsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListProductsRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListProductsRequest. */
                class ListProductsRequest implements IListProductsRequest {

                    /**
                     * Constructs a new ListProductsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IListProductsRequest);

                    /** ListProductsRequest parent. */
                    public parent: string;

                    /** ListProductsRequest pageSize. */
                    public pageSize: number;

                    /** ListProductsRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListProductsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListProductsRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IListProductsRequest): google.cloud.vision.v1.ListProductsRequest;

                    /**
                     * Encodes the specified ListProductsRequest message. Does not implicitly {@link google.cloud.vision.v1.ListProductsRequest.verify|verify} messages.
                     * @param message ListProductsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IListProductsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListProductsRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ListProductsRequest.verify|verify} messages.
                     * @param message ListProductsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IListProductsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListProductsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListProductsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ListProductsRequest;

                    /**
                     * Decodes a ListProductsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListProductsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ListProductsRequest;

                    /**
                     * Verifies a ListProductsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListProductsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListProductsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ListProductsRequest;

                    /**
                     * Creates a plain object from a ListProductsRequest message. Also converts values to other types if specified.
                     * @param message ListProductsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ListProductsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListProductsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListProductsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListProductsResponse. */
                interface IListProductsResponse {

                    /** ListProductsResponse products */
                    products?: (google.cloud.vision.v1.IProduct[]|null);

                    /** ListProductsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListProductsResponse. */
                class ListProductsResponse implements IListProductsResponse {

                    /**
                     * Constructs a new ListProductsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IListProductsResponse);

                    /** ListProductsResponse products. */
                    public products: google.cloud.vision.v1.IProduct[];

                    /** ListProductsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListProductsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListProductsResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IListProductsResponse): google.cloud.vision.v1.ListProductsResponse;

                    /**
                     * Encodes the specified ListProductsResponse message. Does not implicitly {@link google.cloud.vision.v1.ListProductsResponse.verify|verify} messages.
                     * @param message ListProductsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IListProductsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListProductsResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ListProductsResponse.verify|verify} messages.
                     * @param message ListProductsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IListProductsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListProductsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListProductsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ListProductsResponse;

                    /**
                     * Decodes a ListProductsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListProductsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ListProductsResponse;

                    /**
                     * Verifies a ListProductsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListProductsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListProductsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ListProductsResponse;

                    /**
                     * Creates a plain object from a ListProductsResponse message. Also converts values to other types if specified.
                     * @param message ListProductsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ListProductsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListProductsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListProductsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetProductRequest. */
                interface IGetProductRequest {

                    /** GetProductRequest name */
                    name?: (string|null);
                }

                /** Represents a GetProductRequest. */
                class GetProductRequest implements IGetProductRequest {

                    /**
                     * Constructs a new GetProductRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IGetProductRequest);

                    /** GetProductRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetProductRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetProductRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IGetProductRequest): google.cloud.vision.v1.GetProductRequest;

                    /**
                     * Encodes the specified GetProductRequest message. Does not implicitly {@link google.cloud.vision.v1.GetProductRequest.verify|verify} messages.
                     * @param message GetProductRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IGetProductRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetProductRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.GetProductRequest.verify|verify} messages.
                     * @param message GetProductRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IGetProductRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetProductRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetProductRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.GetProductRequest;

                    /**
                     * Decodes a GetProductRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetProductRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.GetProductRequest;

                    /**
                     * Verifies a GetProductRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetProductRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetProductRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.GetProductRequest;

                    /**
                     * Creates a plain object from a GetProductRequest message. Also converts values to other types if specified.
                     * @param message GetProductRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.GetProductRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetProductRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetProductRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an UpdateProductRequest. */
                interface IUpdateProductRequest {

                    /** UpdateProductRequest product */
                    product?: (google.cloud.vision.v1.IProduct|null);

                    /** UpdateProductRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateProductRequest. */
                class UpdateProductRequest implements IUpdateProductRequest {

                    /**
                     * Constructs a new UpdateProductRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IUpdateProductRequest);

                    /** UpdateProductRequest product. */
                    public product?: (google.cloud.vision.v1.IProduct|null);

                    /** UpdateProductRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateProductRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateProductRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IUpdateProductRequest): google.cloud.vision.v1.UpdateProductRequest;

                    /**
                     * Encodes the specified UpdateProductRequest message. Does not implicitly {@link google.cloud.vision.v1.UpdateProductRequest.verify|verify} messages.
                     * @param message UpdateProductRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IUpdateProductRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateProductRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.UpdateProductRequest.verify|verify} messages.
                     * @param message UpdateProductRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IUpdateProductRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateProductRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateProductRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.UpdateProductRequest;

                    /**
                     * Decodes an UpdateProductRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateProductRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.UpdateProductRequest;

                    /**
                     * Verifies an UpdateProductRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateProductRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateProductRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.UpdateProductRequest;

                    /**
                     * Creates a plain object from an UpdateProductRequest message. Also converts values to other types if specified.
                     * @param message UpdateProductRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.UpdateProductRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateProductRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for UpdateProductRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteProductRequest. */
                interface IDeleteProductRequest {

                    /** DeleteProductRequest name */
                    name?: (string|null);
                }

                /** Represents a DeleteProductRequest. */
                class DeleteProductRequest implements IDeleteProductRequest {

                    /**
                     * Constructs a new DeleteProductRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IDeleteProductRequest);

                    /** DeleteProductRequest name. */
                    public name: string;

                    /**
                     * Creates a new DeleteProductRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteProductRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IDeleteProductRequest): google.cloud.vision.v1.DeleteProductRequest;

                    /**
                     * Encodes the specified DeleteProductRequest message. Does not implicitly {@link google.cloud.vision.v1.DeleteProductRequest.verify|verify} messages.
                     * @param message DeleteProductRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IDeleteProductRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteProductRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.DeleteProductRequest.verify|verify} messages.
                     * @param message DeleteProductRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IDeleteProductRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteProductRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteProductRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.DeleteProductRequest;

                    /**
                     * Decodes a DeleteProductRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteProductRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.DeleteProductRequest;

                    /**
                     * Verifies a DeleteProductRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteProductRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteProductRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.DeleteProductRequest;

                    /**
                     * Creates a plain object from a DeleteProductRequest message. Also converts values to other types if specified.
                     * @param message DeleteProductRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.DeleteProductRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteProductRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteProductRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateProductSetRequest. */
                interface ICreateProductSetRequest {

                    /** CreateProductSetRequest parent */
                    parent?: (string|null);

                    /** CreateProductSetRequest productSet */
                    productSet?: (google.cloud.vision.v1.IProductSet|null);

                    /** CreateProductSetRequest productSetId */
                    productSetId?: (string|null);
                }

                /** Represents a CreateProductSetRequest. */
                class CreateProductSetRequest implements ICreateProductSetRequest {

                    /**
                     * Constructs a new CreateProductSetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ICreateProductSetRequest);

                    /** CreateProductSetRequest parent. */
                    public parent: string;

                    /** CreateProductSetRequest productSet. */
                    public productSet?: (google.cloud.vision.v1.IProductSet|null);

                    /** CreateProductSetRequest productSetId. */
                    public productSetId: string;

                    /**
                     * Creates a new CreateProductSetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateProductSetRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ICreateProductSetRequest): google.cloud.vision.v1.CreateProductSetRequest;

                    /**
                     * Encodes the specified CreateProductSetRequest message. Does not implicitly {@link google.cloud.vision.v1.CreateProductSetRequest.verify|verify} messages.
                     * @param message CreateProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ICreateProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateProductSetRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.CreateProductSetRequest.verify|verify} messages.
                     * @param message CreateProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ICreateProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateProductSetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.CreateProductSetRequest;

                    /**
                     * Decodes a CreateProductSetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.CreateProductSetRequest;

                    /**
                     * Verifies a CreateProductSetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateProductSetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateProductSetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.CreateProductSetRequest;

                    /**
                     * Creates a plain object from a CreateProductSetRequest message. Also converts values to other types if specified.
                     * @param message CreateProductSetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.CreateProductSetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateProductSetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateProductSetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListProductSetsRequest. */
                interface IListProductSetsRequest {

                    /** ListProductSetsRequest parent */
                    parent?: (string|null);

                    /** ListProductSetsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListProductSetsRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListProductSetsRequest. */
                class ListProductSetsRequest implements IListProductSetsRequest {

                    /**
                     * Constructs a new ListProductSetsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IListProductSetsRequest);

                    /** ListProductSetsRequest parent. */
                    public parent: string;

                    /** ListProductSetsRequest pageSize. */
                    public pageSize: number;

                    /** ListProductSetsRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListProductSetsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListProductSetsRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IListProductSetsRequest): google.cloud.vision.v1.ListProductSetsRequest;

                    /**
                     * Encodes the specified ListProductSetsRequest message. Does not implicitly {@link google.cloud.vision.v1.ListProductSetsRequest.verify|verify} messages.
                     * @param message ListProductSetsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IListProductSetsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListProductSetsRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ListProductSetsRequest.verify|verify} messages.
                     * @param message ListProductSetsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IListProductSetsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListProductSetsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListProductSetsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ListProductSetsRequest;

                    /**
                     * Decodes a ListProductSetsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListProductSetsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ListProductSetsRequest;

                    /**
                     * Verifies a ListProductSetsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListProductSetsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListProductSetsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ListProductSetsRequest;

                    /**
                     * Creates a plain object from a ListProductSetsRequest message. Also converts values to other types if specified.
                     * @param message ListProductSetsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ListProductSetsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListProductSetsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListProductSetsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListProductSetsResponse. */
                interface IListProductSetsResponse {

                    /** ListProductSetsResponse productSets */
                    productSets?: (google.cloud.vision.v1.IProductSet[]|null);

                    /** ListProductSetsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListProductSetsResponse. */
                class ListProductSetsResponse implements IListProductSetsResponse {

                    /**
                     * Constructs a new ListProductSetsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IListProductSetsResponse);

                    /** ListProductSetsResponse productSets. */
                    public productSets: google.cloud.vision.v1.IProductSet[];

                    /** ListProductSetsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListProductSetsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListProductSetsResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IListProductSetsResponse): google.cloud.vision.v1.ListProductSetsResponse;

                    /**
                     * Encodes the specified ListProductSetsResponse message. Does not implicitly {@link google.cloud.vision.v1.ListProductSetsResponse.verify|verify} messages.
                     * @param message ListProductSetsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IListProductSetsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListProductSetsResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ListProductSetsResponse.verify|verify} messages.
                     * @param message ListProductSetsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IListProductSetsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListProductSetsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListProductSetsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ListProductSetsResponse;

                    /**
                     * Decodes a ListProductSetsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListProductSetsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ListProductSetsResponse;

                    /**
                     * Verifies a ListProductSetsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListProductSetsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListProductSetsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ListProductSetsResponse;

                    /**
                     * Creates a plain object from a ListProductSetsResponse message. Also converts values to other types if specified.
                     * @param message ListProductSetsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ListProductSetsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListProductSetsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListProductSetsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetProductSetRequest. */
                interface IGetProductSetRequest {

                    /** GetProductSetRequest name */
                    name?: (string|null);
                }

                /** Represents a GetProductSetRequest. */
                class GetProductSetRequest implements IGetProductSetRequest {

                    /**
                     * Constructs a new GetProductSetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IGetProductSetRequest);

                    /** GetProductSetRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetProductSetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetProductSetRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IGetProductSetRequest): google.cloud.vision.v1.GetProductSetRequest;

                    /**
                     * Encodes the specified GetProductSetRequest message. Does not implicitly {@link google.cloud.vision.v1.GetProductSetRequest.verify|verify} messages.
                     * @param message GetProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IGetProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetProductSetRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.GetProductSetRequest.verify|verify} messages.
                     * @param message GetProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IGetProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetProductSetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.GetProductSetRequest;

                    /**
                     * Decodes a GetProductSetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.GetProductSetRequest;

                    /**
                     * Verifies a GetProductSetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetProductSetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetProductSetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.GetProductSetRequest;

                    /**
                     * Creates a plain object from a GetProductSetRequest message. Also converts values to other types if specified.
                     * @param message GetProductSetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.GetProductSetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetProductSetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetProductSetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an UpdateProductSetRequest. */
                interface IUpdateProductSetRequest {

                    /** UpdateProductSetRequest productSet */
                    productSet?: (google.cloud.vision.v1.IProductSet|null);

                    /** UpdateProductSetRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateProductSetRequest. */
                class UpdateProductSetRequest implements IUpdateProductSetRequest {

                    /**
                     * Constructs a new UpdateProductSetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IUpdateProductSetRequest);

                    /** UpdateProductSetRequest productSet. */
                    public productSet?: (google.cloud.vision.v1.IProductSet|null);

                    /** UpdateProductSetRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateProductSetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateProductSetRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IUpdateProductSetRequest): google.cloud.vision.v1.UpdateProductSetRequest;

                    /**
                     * Encodes the specified UpdateProductSetRequest message. Does not implicitly {@link google.cloud.vision.v1.UpdateProductSetRequest.verify|verify} messages.
                     * @param message UpdateProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IUpdateProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateProductSetRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.UpdateProductSetRequest.verify|verify} messages.
                     * @param message UpdateProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IUpdateProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateProductSetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.UpdateProductSetRequest;

                    /**
                     * Decodes an UpdateProductSetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.UpdateProductSetRequest;

                    /**
                     * Verifies an UpdateProductSetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateProductSetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateProductSetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.UpdateProductSetRequest;

                    /**
                     * Creates a plain object from an UpdateProductSetRequest message. Also converts values to other types if specified.
                     * @param message UpdateProductSetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.UpdateProductSetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateProductSetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for UpdateProductSetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteProductSetRequest. */
                interface IDeleteProductSetRequest {

                    /** DeleteProductSetRequest name */
                    name?: (string|null);
                }

                /** Represents a DeleteProductSetRequest. */
                class DeleteProductSetRequest implements IDeleteProductSetRequest {

                    /**
                     * Constructs a new DeleteProductSetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IDeleteProductSetRequest);

                    /** DeleteProductSetRequest name. */
                    public name: string;

                    /**
                     * Creates a new DeleteProductSetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteProductSetRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IDeleteProductSetRequest): google.cloud.vision.v1.DeleteProductSetRequest;

                    /**
                     * Encodes the specified DeleteProductSetRequest message. Does not implicitly {@link google.cloud.vision.v1.DeleteProductSetRequest.verify|verify} messages.
                     * @param message DeleteProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IDeleteProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteProductSetRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.DeleteProductSetRequest.verify|verify} messages.
                     * @param message DeleteProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IDeleteProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteProductSetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.DeleteProductSetRequest;

                    /**
                     * Decodes a DeleteProductSetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.DeleteProductSetRequest;

                    /**
                     * Verifies a DeleteProductSetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteProductSetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteProductSetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.DeleteProductSetRequest;

                    /**
                     * Creates a plain object from a DeleteProductSetRequest message. Also converts values to other types if specified.
                     * @param message DeleteProductSetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.DeleteProductSetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteProductSetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteProductSetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CreateReferenceImageRequest. */
                interface ICreateReferenceImageRequest {

                    /** CreateReferenceImageRequest parent */
                    parent?: (string|null);

                    /** CreateReferenceImageRequest referenceImage */
                    referenceImage?: (google.cloud.vision.v1.IReferenceImage|null);

                    /** CreateReferenceImageRequest referenceImageId */
                    referenceImageId?: (string|null);
                }

                /** Represents a CreateReferenceImageRequest. */
                class CreateReferenceImageRequest implements ICreateReferenceImageRequest {

                    /**
                     * Constructs a new CreateReferenceImageRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ICreateReferenceImageRequest);

                    /** CreateReferenceImageRequest parent. */
                    public parent: string;

                    /** CreateReferenceImageRequest referenceImage. */
                    public referenceImage?: (google.cloud.vision.v1.IReferenceImage|null);

                    /** CreateReferenceImageRequest referenceImageId. */
                    public referenceImageId: string;

                    /**
                     * Creates a new CreateReferenceImageRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateReferenceImageRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ICreateReferenceImageRequest): google.cloud.vision.v1.CreateReferenceImageRequest;

                    /**
                     * Encodes the specified CreateReferenceImageRequest message. Does not implicitly {@link google.cloud.vision.v1.CreateReferenceImageRequest.verify|verify} messages.
                     * @param message CreateReferenceImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ICreateReferenceImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateReferenceImageRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.CreateReferenceImageRequest.verify|verify} messages.
                     * @param message CreateReferenceImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ICreateReferenceImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateReferenceImageRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateReferenceImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.CreateReferenceImageRequest;

                    /**
                     * Decodes a CreateReferenceImageRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateReferenceImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.CreateReferenceImageRequest;

                    /**
                     * Verifies a CreateReferenceImageRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateReferenceImageRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateReferenceImageRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.CreateReferenceImageRequest;

                    /**
                     * Creates a plain object from a CreateReferenceImageRequest message. Also converts values to other types if specified.
                     * @param message CreateReferenceImageRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.CreateReferenceImageRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateReferenceImageRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CreateReferenceImageRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListReferenceImagesRequest. */
                interface IListReferenceImagesRequest {

                    /** ListReferenceImagesRequest parent */
                    parent?: (string|null);

                    /** ListReferenceImagesRequest pageSize */
                    pageSize?: (number|null);

                    /** ListReferenceImagesRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListReferenceImagesRequest. */
                class ListReferenceImagesRequest implements IListReferenceImagesRequest {

                    /**
                     * Constructs a new ListReferenceImagesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IListReferenceImagesRequest);

                    /** ListReferenceImagesRequest parent. */
                    public parent: string;

                    /** ListReferenceImagesRequest pageSize. */
                    public pageSize: number;

                    /** ListReferenceImagesRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListReferenceImagesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListReferenceImagesRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IListReferenceImagesRequest): google.cloud.vision.v1.ListReferenceImagesRequest;

                    /**
                     * Encodes the specified ListReferenceImagesRequest message. Does not implicitly {@link google.cloud.vision.v1.ListReferenceImagesRequest.verify|verify} messages.
                     * @param message ListReferenceImagesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IListReferenceImagesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListReferenceImagesRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ListReferenceImagesRequest.verify|verify} messages.
                     * @param message ListReferenceImagesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IListReferenceImagesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListReferenceImagesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListReferenceImagesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ListReferenceImagesRequest;

                    /**
                     * Decodes a ListReferenceImagesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListReferenceImagesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ListReferenceImagesRequest;

                    /**
                     * Verifies a ListReferenceImagesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListReferenceImagesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListReferenceImagesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ListReferenceImagesRequest;

                    /**
                     * Creates a plain object from a ListReferenceImagesRequest message. Also converts values to other types if specified.
                     * @param message ListReferenceImagesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ListReferenceImagesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListReferenceImagesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListReferenceImagesRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListReferenceImagesResponse. */
                interface IListReferenceImagesResponse {

                    /** ListReferenceImagesResponse referenceImages */
                    referenceImages?: (google.cloud.vision.v1.IReferenceImage[]|null);

                    /** ListReferenceImagesResponse pageSize */
                    pageSize?: (number|null);

                    /** ListReferenceImagesResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListReferenceImagesResponse. */
                class ListReferenceImagesResponse implements IListReferenceImagesResponse {

                    /**
                     * Constructs a new ListReferenceImagesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IListReferenceImagesResponse);

                    /** ListReferenceImagesResponse referenceImages. */
                    public referenceImages: google.cloud.vision.v1.IReferenceImage[];

                    /** ListReferenceImagesResponse pageSize. */
                    public pageSize: number;

                    /** ListReferenceImagesResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListReferenceImagesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListReferenceImagesResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IListReferenceImagesResponse): google.cloud.vision.v1.ListReferenceImagesResponse;

                    /**
                     * Encodes the specified ListReferenceImagesResponse message. Does not implicitly {@link google.cloud.vision.v1.ListReferenceImagesResponse.verify|verify} messages.
                     * @param message ListReferenceImagesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IListReferenceImagesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListReferenceImagesResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ListReferenceImagesResponse.verify|verify} messages.
                     * @param message ListReferenceImagesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IListReferenceImagesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListReferenceImagesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListReferenceImagesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ListReferenceImagesResponse;

                    /**
                     * Decodes a ListReferenceImagesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListReferenceImagesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ListReferenceImagesResponse;

                    /**
                     * Verifies a ListReferenceImagesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListReferenceImagesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListReferenceImagesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ListReferenceImagesResponse;

                    /**
                     * Creates a plain object from a ListReferenceImagesResponse message. Also converts values to other types if specified.
                     * @param message ListReferenceImagesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ListReferenceImagesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListReferenceImagesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListReferenceImagesResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a GetReferenceImageRequest. */
                interface IGetReferenceImageRequest {

                    /** GetReferenceImageRequest name */
                    name?: (string|null);
                }

                /** Represents a GetReferenceImageRequest. */
                class GetReferenceImageRequest implements IGetReferenceImageRequest {

                    /**
                     * Constructs a new GetReferenceImageRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IGetReferenceImageRequest);

                    /** GetReferenceImageRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetReferenceImageRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetReferenceImageRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IGetReferenceImageRequest): google.cloud.vision.v1.GetReferenceImageRequest;

                    /**
                     * Encodes the specified GetReferenceImageRequest message. Does not implicitly {@link google.cloud.vision.v1.GetReferenceImageRequest.verify|verify} messages.
                     * @param message GetReferenceImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IGetReferenceImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetReferenceImageRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.GetReferenceImageRequest.verify|verify} messages.
                     * @param message GetReferenceImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IGetReferenceImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetReferenceImageRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetReferenceImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.GetReferenceImageRequest;

                    /**
                     * Decodes a GetReferenceImageRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetReferenceImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.GetReferenceImageRequest;

                    /**
                     * Verifies a GetReferenceImageRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetReferenceImageRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetReferenceImageRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.GetReferenceImageRequest;

                    /**
                     * Creates a plain object from a GetReferenceImageRequest message. Also converts values to other types if specified.
                     * @param message GetReferenceImageRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.GetReferenceImageRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetReferenceImageRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for GetReferenceImageRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DeleteReferenceImageRequest. */
                interface IDeleteReferenceImageRequest {

                    /** DeleteReferenceImageRequest name */
                    name?: (string|null);
                }

                /** Represents a DeleteReferenceImageRequest. */
                class DeleteReferenceImageRequest implements IDeleteReferenceImageRequest {

                    /**
                     * Constructs a new DeleteReferenceImageRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IDeleteReferenceImageRequest);

                    /** DeleteReferenceImageRequest name. */
                    public name: string;

                    /**
                     * Creates a new DeleteReferenceImageRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteReferenceImageRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IDeleteReferenceImageRequest): google.cloud.vision.v1.DeleteReferenceImageRequest;

                    /**
                     * Encodes the specified DeleteReferenceImageRequest message. Does not implicitly {@link google.cloud.vision.v1.DeleteReferenceImageRequest.verify|verify} messages.
                     * @param message DeleteReferenceImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IDeleteReferenceImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteReferenceImageRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.DeleteReferenceImageRequest.verify|verify} messages.
                     * @param message DeleteReferenceImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IDeleteReferenceImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteReferenceImageRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteReferenceImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.DeleteReferenceImageRequest;

                    /**
                     * Decodes a DeleteReferenceImageRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteReferenceImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.DeleteReferenceImageRequest;

                    /**
                     * Verifies a DeleteReferenceImageRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteReferenceImageRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteReferenceImageRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.DeleteReferenceImageRequest;

                    /**
                     * Creates a plain object from a DeleteReferenceImageRequest message. Also converts values to other types if specified.
                     * @param message DeleteReferenceImageRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.DeleteReferenceImageRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteReferenceImageRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DeleteReferenceImageRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AddProductToProductSetRequest. */
                interface IAddProductToProductSetRequest {

                    /** AddProductToProductSetRequest name */
                    name?: (string|null);

                    /** AddProductToProductSetRequest product */
                    product?: (string|null);
                }

                /** Represents an AddProductToProductSetRequest. */
                class AddProductToProductSetRequest implements IAddProductToProductSetRequest {

                    /**
                     * Constructs a new AddProductToProductSetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IAddProductToProductSetRequest);

                    /** AddProductToProductSetRequest name. */
                    public name: string;

                    /** AddProductToProductSetRequest product. */
                    public product: string;

                    /**
                     * Creates a new AddProductToProductSetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AddProductToProductSetRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IAddProductToProductSetRequest): google.cloud.vision.v1.AddProductToProductSetRequest;

                    /**
                     * Encodes the specified AddProductToProductSetRequest message. Does not implicitly {@link google.cloud.vision.v1.AddProductToProductSetRequest.verify|verify} messages.
                     * @param message AddProductToProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IAddProductToProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AddProductToProductSetRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AddProductToProductSetRequest.verify|verify} messages.
                     * @param message AddProductToProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IAddProductToProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AddProductToProductSetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AddProductToProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.AddProductToProductSetRequest;

                    /**
                     * Decodes an AddProductToProductSetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AddProductToProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.AddProductToProductSetRequest;

                    /**
                     * Verifies an AddProductToProductSetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AddProductToProductSetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AddProductToProductSetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.AddProductToProductSetRequest;

                    /**
                     * Creates a plain object from an AddProductToProductSetRequest message. Also converts values to other types if specified.
                     * @param message AddProductToProductSetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.AddProductToProductSetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AddProductToProductSetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AddProductToProductSetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a RemoveProductFromProductSetRequest. */
                interface IRemoveProductFromProductSetRequest {

                    /** RemoveProductFromProductSetRequest name */
                    name?: (string|null);

                    /** RemoveProductFromProductSetRequest product */
                    product?: (string|null);
                }

                /** Represents a RemoveProductFromProductSetRequest. */
                class RemoveProductFromProductSetRequest implements IRemoveProductFromProductSetRequest {

                    /**
                     * Constructs a new RemoveProductFromProductSetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IRemoveProductFromProductSetRequest);

                    /** RemoveProductFromProductSetRequest name. */
                    public name: string;

                    /** RemoveProductFromProductSetRequest product. */
                    public product: string;

                    /**
                     * Creates a new RemoveProductFromProductSetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns RemoveProductFromProductSetRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IRemoveProductFromProductSetRequest): google.cloud.vision.v1.RemoveProductFromProductSetRequest;

                    /**
                     * Encodes the specified RemoveProductFromProductSetRequest message. Does not implicitly {@link google.cloud.vision.v1.RemoveProductFromProductSetRequest.verify|verify} messages.
                     * @param message RemoveProductFromProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IRemoveProductFromProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified RemoveProductFromProductSetRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.RemoveProductFromProductSetRequest.verify|verify} messages.
                     * @param message RemoveProductFromProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IRemoveProductFromProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a RemoveProductFromProductSetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns RemoveProductFromProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.RemoveProductFromProductSetRequest;

                    /**
                     * Decodes a RemoveProductFromProductSetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns RemoveProductFromProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.RemoveProductFromProductSetRequest;

                    /**
                     * Verifies a RemoveProductFromProductSetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a RemoveProductFromProductSetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns RemoveProductFromProductSetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.RemoveProductFromProductSetRequest;

                    /**
                     * Creates a plain object from a RemoveProductFromProductSetRequest message. Also converts values to other types if specified.
                     * @param message RemoveProductFromProductSetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.RemoveProductFromProductSetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this RemoveProductFromProductSetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for RemoveProductFromProductSetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListProductsInProductSetRequest. */
                interface IListProductsInProductSetRequest {

                    /** ListProductsInProductSetRequest name */
                    name?: (string|null);

                    /** ListProductsInProductSetRequest pageSize */
                    pageSize?: (number|null);

                    /** ListProductsInProductSetRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListProductsInProductSetRequest. */
                class ListProductsInProductSetRequest implements IListProductsInProductSetRequest {

                    /**
                     * Constructs a new ListProductsInProductSetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IListProductsInProductSetRequest);

                    /** ListProductsInProductSetRequest name. */
                    public name: string;

                    /** ListProductsInProductSetRequest pageSize. */
                    public pageSize: number;

                    /** ListProductsInProductSetRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListProductsInProductSetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListProductsInProductSetRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IListProductsInProductSetRequest): google.cloud.vision.v1.ListProductsInProductSetRequest;

                    /**
                     * Encodes the specified ListProductsInProductSetRequest message. Does not implicitly {@link google.cloud.vision.v1.ListProductsInProductSetRequest.verify|verify} messages.
                     * @param message ListProductsInProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IListProductsInProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListProductsInProductSetRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ListProductsInProductSetRequest.verify|verify} messages.
                     * @param message ListProductsInProductSetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IListProductsInProductSetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListProductsInProductSetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListProductsInProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ListProductsInProductSetRequest;

                    /**
                     * Decodes a ListProductsInProductSetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListProductsInProductSetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ListProductsInProductSetRequest;

                    /**
                     * Verifies a ListProductsInProductSetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListProductsInProductSetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListProductsInProductSetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ListProductsInProductSetRequest;

                    /**
                     * Creates a plain object from a ListProductsInProductSetRequest message. Also converts values to other types if specified.
                     * @param message ListProductsInProductSetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ListProductsInProductSetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListProductsInProductSetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListProductsInProductSetRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ListProductsInProductSetResponse. */
                interface IListProductsInProductSetResponse {

                    /** ListProductsInProductSetResponse products */
                    products?: (google.cloud.vision.v1.IProduct[]|null);

                    /** ListProductsInProductSetResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListProductsInProductSetResponse. */
                class ListProductsInProductSetResponse implements IListProductsInProductSetResponse {

                    /**
                     * Constructs a new ListProductsInProductSetResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IListProductsInProductSetResponse);

                    /** ListProductsInProductSetResponse products. */
                    public products: google.cloud.vision.v1.IProduct[];

                    /** ListProductsInProductSetResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListProductsInProductSetResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListProductsInProductSetResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IListProductsInProductSetResponse): google.cloud.vision.v1.ListProductsInProductSetResponse;

                    /**
                     * Encodes the specified ListProductsInProductSetResponse message. Does not implicitly {@link google.cloud.vision.v1.ListProductsInProductSetResponse.verify|verify} messages.
                     * @param message ListProductsInProductSetResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IListProductsInProductSetResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListProductsInProductSetResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ListProductsInProductSetResponse.verify|verify} messages.
                     * @param message ListProductsInProductSetResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IListProductsInProductSetResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListProductsInProductSetResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListProductsInProductSetResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ListProductsInProductSetResponse;

                    /**
                     * Decodes a ListProductsInProductSetResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListProductsInProductSetResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ListProductsInProductSetResponse;

                    /**
                     * Verifies a ListProductsInProductSetResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListProductsInProductSetResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListProductsInProductSetResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ListProductsInProductSetResponse;

                    /**
                     * Creates a plain object from a ListProductsInProductSetResponse message. Also converts values to other types if specified.
                     * @param message ListProductsInProductSetResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ListProductsInProductSetResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListProductsInProductSetResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ListProductsInProductSetResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImportProductSetsGcsSource. */
                interface IImportProductSetsGcsSource {

                    /** ImportProductSetsGcsSource csvFileUri */
                    csvFileUri?: (string|null);
                }

                /** Represents an ImportProductSetsGcsSource. */
                class ImportProductSetsGcsSource implements IImportProductSetsGcsSource {

                    /**
                     * Constructs a new ImportProductSetsGcsSource.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IImportProductSetsGcsSource);

                    /** ImportProductSetsGcsSource csvFileUri. */
                    public csvFileUri: string;

                    /**
                     * Creates a new ImportProductSetsGcsSource instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImportProductSetsGcsSource instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IImportProductSetsGcsSource): google.cloud.vision.v1.ImportProductSetsGcsSource;

                    /**
                     * Encodes the specified ImportProductSetsGcsSource message. Does not implicitly {@link google.cloud.vision.v1.ImportProductSetsGcsSource.verify|verify} messages.
                     * @param message ImportProductSetsGcsSource message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IImportProductSetsGcsSource, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImportProductSetsGcsSource message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImportProductSetsGcsSource.verify|verify} messages.
                     * @param message ImportProductSetsGcsSource message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IImportProductSetsGcsSource, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImportProductSetsGcsSource message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImportProductSetsGcsSource
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ImportProductSetsGcsSource;

                    /**
                     * Decodes an ImportProductSetsGcsSource message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImportProductSetsGcsSource
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ImportProductSetsGcsSource;

                    /**
                     * Verifies an ImportProductSetsGcsSource message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImportProductSetsGcsSource message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImportProductSetsGcsSource
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ImportProductSetsGcsSource;

                    /**
                     * Creates a plain object from an ImportProductSetsGcsSource message. Also converts values to other types if specified.
                     * @param message ImportProductSetsGcsSource
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ImportProductSetsGcsSource, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImportProductSetsGcsSource to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImportProductSetsGcsSource
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImportProductSetsInputConfig. */
                interface IImportProductSetsInputConfig {

                    /** ImportProductSetsInputConfig gcsSource */
                    gcsSource?: (google.cloud.vision.v1.IImportProductSetsGcsSource|null);
                }

                /** Represents an ImportProductSetsInputConfig. */
                class ImportProductSetsInputConfig implements IImportProductSetsInputConfig {

                    /**
                     * Constructs a new ImportProductSetsInputConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IImportProductSetsInputConfig);

                    /** ImportProductSetsInputConfig gcsSource. */
                    public gcsSource?: (google.cloud.vision.v1.IImportProductSetsGcsSource|null);

                    /** ImportProductSetsInputConfig source. */
                    public source?: "gcsSource";

                    /**
                     * Creates a new ImportProductSetsInputConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImportProductSetsInputConfig instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IImportProductSetsInputConfig): google.cloud.vision.v1.ImportProductSetsInputConfig;

                    /**
                     * Encodes the specified ImportProductSetsInputConfig message. Does not implicitly {@link google.cloud.vision.v1.ImportProductSetsInputConfig.verify|verify} messages.
                     * @param message ImportProductSetsInputConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IImportProductSetsInputConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImportProductSetsInputConfig message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImportProductSetsInputConfig.verify|verify} messages.
                     * @param message ImportProductSetsInputConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IImportProductSetsInputConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImportProductSetsInputConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImportProductSetsInputConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ImportProductSetsInputConfig;

                    /**
                     * Decodes an ImportProductSetsInputConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImportProductSetsInputConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ImportProductSetsInputConfig;

                    /**
                     * Verifies an ImportProductSetsInputConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImportProductSetsInputConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImportProductSetsInputConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ImportProductSetsInputConfig;

                    /**
                     * Creates a plain object from an ImportProductSetsInputConfig message. Also converts values to other types if specified.
                     * @param message ImportProductSetsInputConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ImportProductSetsInputConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImportProductSetsInputConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImportProductSetsInputConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImportProductSetsRequest. */
                interface IImportProductSetsRequest {

                    /** ImportProductSetsRequest parent */
                    parent?: (string|null);

                    /** ImportProductSetsRequest inputConfig */
                    inputConfig?: (google.cloud.vision.v1.IImportProductSetsInputConfig|null);
                }

                /** Represents an ImportProductSetsRequest. */
                class ImportProductSetsRequest implements IImportProductSetsRequest {

                    /**
                     * Constructs a new ImportProductSetsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IImportProductSetsRequest);

                    /** ImportProductSetsRequest parent. */
                    public parent: string;

                    /** ImportProductSetsRequest inputConfig. */
                    public inputConfig?: (google.cloud.vision.v1.IImportProductSetsInputConfig|null);

                    /**
                     * Creates a new ImportProductSetsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImportProductSetsRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IImportProductSetsRequest): google.cloud.vision.v1.ImportProductSetsRequest;

                    /**
                     * Encodes the specified ImportProductSetsRequest message. Does not implicitly {@link google.cloud.vision.v1.ImportProductSetsRequest.verify|verify} messages.
                     * @param message ImportProductSetsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IImportProductSetsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImportProductSetsRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImportProductSetsRequest.verify|verify} messages.
                     * @param message ImportProductSetsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IImportProductSetsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImportProductSetsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImportProductSetsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ImportProductSetsRequest;

                    /**
                     * Decodes an ImportProductSetsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImportProductSetsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ImportProductSetsRequest;

                    /**
                     * Verifies an ImportProductSetsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImportProductSetsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImportProductSetsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ImportProductSetsRequest;

                    /**
                     * Creates a plain object from an ImportProductSetsRequest message. Also converts values to other types if specified.
                     * @param message ImportProductSetsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ImportProductSetsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImportProductSetsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImportProductSetsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImportProductSetsResponse. */
                interface IImportProductSetsResponse {

                    /** ImportProductSetsResponse referenceImages */
                    referenceImages?: (google.cloud.vision.v1.IReferenceImage[]|null);

                    /** ImportProductSetsResponse statuses */
                    statuses?: (google.rpc.IStatus[]|null);
                }

                /** Represents an ImportProductSetsResponse. */
                class ImportProductSetsResponse implements IImportProductSetsResponse {

                    /**
                     * Constructs a new ImportProductSetsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IImportProductSetsResponse);

                    /** ImportProductSetsResponse referenceImages. */
                    public referenceImages: google.cloud.vision.v1.IReferenceImage[];

                    /** ImportProductSetsResponse statuses. */
                    public statuses: google.rpc.IStatus[];

                    /**
                     * Creates a new ImportProductSetsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImportProductSetsResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IImportProductSetsResponse): google.cloud.vision.v1.ImportProductSetsResponse;

                    /**
                     * Encodes the specified ImportProductSetsResponse message. Does not implicitly {@link google.cloud.vision.v1.ImportProductSetsResponse.verify|verify} messages.
                     * @param message ImportProductSetsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IImportProductSetsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImportProductSetsResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImportProductSetsResponse.verify|verify} messages.
                     * @param message ImportProductSetsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IImportProductSetsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImportProductSetsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImportProductSetsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ImportProductSetsResponse;

                    /**
                     * Decodes an ImportProductSetsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImportProductSetsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ImportProductSetsResponse;

                    /**
                     * Verifies an ImportProductSetsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImportProductSetsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImportProductSetsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ImportProductSetsResponse;

                    /**
                     * Creates a plain object from an ImportProductSetsResponse message. Also converts values to other types if specified.
                     * @param message ImportProductSetsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ImportProductSetsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImportProductSetsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImportProductSetsResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BatchOperationMetadata. */
                interface IBatchOperationMetadata {

                    /** BatchOperationMetadata state */
                    state?: (google.cloud.vision.v1.BatchOperationMetadata.State|keyof typeof google.cloud.vision.v1.BatchOperationMetadata.State|null);

                    /** BatchOperationMetadata submitTime */
                    submitTime?: (google.protobuf.ITimestamp|null);

                    /** BatchOperationMetadata endTime */
                    endTime?: (google.protobuf.ITimestamp|null);
                }

                /** Represents a BatchOperationMetadata. */
                class BatchOperationMetadata implements IBatchOperationMetadata {

                    /**
                     * Constructs a new BatchOperationMetadata.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IBatchOperationMetadata);

                    /** BatchOperationMetadata state. */
                    public state: (google.cloud.vision.v1.BatchOperationMetadata.State|keyof typeof google.cloud.vision.v1.BatchOperationMetadata.State);

                    /** BatchOperationMetadata submitTime. */
                    public submitTime?: (google.protobuf.ITimestamp|null);

                    /** BatchOperationMetadata endTime. */
                    public endTime?: (google.protobuf.ITimestamp|null);

                    /**
                     * Creates a new BatchOperationMetadata instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchOperationMetadata instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IBatchOperationMetadata): google.cloud.vision.v1.BatchOperationMetadata;

                    /**
                     * Encodes the specified BatchOperationMetadata message. Does not implicitly {@link google.cloud.vision.v1.BatchOperationMetadata.verify|verify} messages.
                     * @param message BatchOperationMetadata message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IBatchOperationMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchOperationMetadata message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BatchOperationMetadata.verify|verify} messages.
                     * @param message BatchOperationMetadata message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IBatchOperationMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchOperationMetadata message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchOperationMetadata
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.BatchOperationMetadata;

                    /**
                     * Decodes a BatchOperationMetadata message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchOperationMetadata
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.BatchOperationMetadata;

                    /**
                     * Verifies a BatchOperationMetadata message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchOperationMetadata message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchOperationMetadata
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.BatchOperationMetadata;

                    /**
                     * Creates a plain object from a BatchOperationMetadata message. Also converts values to other types if specified.
                     * @param message BatchOperationMetadata
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.BatchOperationMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchOperationMetadata to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BatchOperationMetadata
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace BatchOperationMetadata {

                    /** State enum. */
                    enum State {
                        STATE_UNSPECIFIED = 0,
                        PROCESSING = 1,
                        SUCCESSFUL = 2,
                        FAILED = 3,
                        CANCELLED = 4
                    }
                }

                /** Properties of a ProductSetPurgeConfig. */
                interface IProductSetPurgeConfig {

                    /** ProductSetPurgeConfig productSetId */
                    productSetId?: (string|null);
                }

                /** Represents a ProductSetPurgeConfig. */
                class ProductSetPurgeConfig implements IProductSetPurgeConfig {

                    /**
                     * Constructs a new ProductSetPurgeConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IProductSetPurgeConfig);

                    /** ProductSetPurgeConfig productSetId. */
                    public productSetId: string;

                    /**
                     * Creates a new ProductSetPurgeConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ProductSetPurgeConfig instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IProductSetPurgeConfig): google.cloud.vision.v1.ProductSetPurgeConfig;

                    /**
                     * Encodes the specified ProductSetPurgeConfig message. Does not implicitly {@link google.cloud.vision.v1.ProductSetPurgeConfig.verify|verify} messages.
                     * @param message ProductSetPurgeConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IProductSetPurgeConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ProductSetPurgeConfig message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSetPurgeConfig.verify|verify} messages.
                     * @param message ProductSetPurgeConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IProductSetPurgeConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ProductSetPurgeConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ProductSetPurgeConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.ProductSetPurgeConfig;

                    /**
                     * Decodes a ProductSetPurgeConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ProductSetPurgeConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.ProductSetPurgeConfig;

                    /**
                     * Verifies a ProductSetPurgeConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ProductSetPurgeConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ProductSetPurgeConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.ProductSetPurgeConfig;

                    /**
                     * Creates a plain object from a ProductSetPurgeConfig message. Also converts values to other types if specified.
                     * @param message ProductSetPurgeConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.ProductSetPurgeConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ProductSetPurgeConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ProductSetPurgeConfig
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a PurgeProductsRequest. */
                interface IPurgeProductsRequest {

                    /** PurgeProductsRequest productSetPurgeConfig */
                    productSetPurgeConfig?: (google.cloud.vision.v1.IProductSetPurgeConfig|null);

                    /** PurgeProductsRequest deleteOrphanProducts */
                    deleteOrphanProducts?: (boolean|null);

                    /** PurgeProductsRequest parent */
                    parent?: (string|null);

                    /** PurgeProductsRequest force */
                    force?: (boolean|null);
                }

                /** Represents a PurgeProductsRequest. */
                class PurgeProductsRequest implements IPurgeProductsRequest {

                    /**
                     * Constructs a new PurgeProductsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IPurgeProductsRequest);

                    /** PurgeProductsRequest productSetPurgeConfig. */
                    public productSetPurgeConfig?: (google.cloud.vision.v1.IProductSetPurgeConfig|null);

                    /** PurgeProductsRequest deleteOrphanProducts. */
                    public deleteOrphanProducts?: (boolean|null);

                    /** PurgeProductsRequest parent. */
                    public parent: string;

                    /** PurgeProductsRequest force. */
                    public force: boolean;

                    /** PurgeProductsRequest target. */
                    public target?: ("productSetPurgeConfig"|"deleteOrphanProducts");

                    /**
                     * Creates a new PurgeProductsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns PurgeProductsRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IPurgeProductsRequest): google.cloud.vision.v1.PurgeProductsRequest;

                    /**
                     * Encodes the specified PurgeProductsRequest message. Does not implicitly {@link google.cloud.vision.v1.PurgeProductsRequest.verify|verify} messages.
                     * @param message PurgeProductsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IPurgeProductsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified PurgeProductsRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.PurgeProductsRequest.verify|verify} messages.
                     * @param message PurgeProductsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IPurgeProductsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a PurgeProductsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns PurgeProductsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.PurgeProductsRequest;

                    /**
                     * Decodes a PurgeProductsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns PurgeProductsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.PurgeProductsRequest;

                    /**
                     * Verifies a PurgeProductsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a PurgeProductsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns PurgeProductsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.PurgeProductsRequest;

                    /**
                     * Creates a plain object from a PurgeProductsRequest message. Also converts values to other types if specified.
                     * @param message PurgeProductsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.PurgeProductsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this PurgeProductsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for PurgeProductsRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a TextAnnotation. */
                interface ITextAnnotation {

                    /** TextAnnotation pages */
                    pages?: (google.cloud.vision.v1.IPage[]|null);

                    /** TextAnnotation text */
                    text?: (string|null);
                }

                /** Represents a TextAnnotation. */
                class TextAnnotation implements ITextAnnotation {

                    /**
                     * Constructs a new TextAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ITextAnnotation);

                    /** TextAnnotation pages. */
                    public pages: google.cloud.vision.v1.IPage[];

                    /** TextAnnotation text. */
                    public text: string;

                    /**
                     * Creates a new TextAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TextAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ITextAnnotation): google.cloud.vision.v1.TextAnnotation;

                    /**
                     * Encodes the specified TextAnnotation message. Does not implicitly {@link google.cloud.vision.v1.TextAnnotation.verify|verify} messages.
                     * @param message TextAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ITextAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TextAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.TextAnnotation.verify|verify} messages.
                     * @param message TextAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ITextAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TextAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TextAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.TextAnnotation;

                    /**
                     * Decodes a TextAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TextAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.TextAnnotation;

                    /**
                     * Verifies a TextAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TextAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TextAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.TextAnnotation;

                    /**
                     * Creates a plain object from a TextAnnotation message. Also converts values to other types if specified.
                     * @param message TextAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.TextAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TextAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for TextAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace TextAnnotation {

                    /** Properties of a DetectedLanguage. */
                    interface IDetectedLanguage {

                        /** DetectedLanguage languageCode */
                        languageCode?: (string|null);

                        /** DetectedLanguage confidence */
                        confidence?: (number|null);
                    }

                    /** Represents a DetectedLanguage. */
                    class DetectedLanguage implements IDetectedLanguage {

                        /**
                         * Constructs a new DetectedLanguage.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.TextAnnotation.IDetectedLanguage);

                        /** DetectedLanguage languageCode. */
                        public languageCode: string;

                        /** DetectedLanguage confidence. */
                        public confidence: number;

                        /**
                         * Creates a new DetectedLanguage instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DetectedLanguage instance
                         */
                        public static create(properties?: google.cloud.vision.v1.TextAnnotation.IDetectedLanguage): google.cloud.vision.v1.TextAnnotation.DetectedLanguage;

                        /**
                         * Encodes the specified DetectedLanguage message. Does not implicitly {@link google.cloud.vision.v1.TextAnnotation.DetectedLanguage.verify|verify} messages.
                         * @param message DetectedLanguage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.TextAnnotation.IDetectedLanguage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DetectedLanguage message, length delimited. Does not implicitly {@link google.cloud.vision.v1.TextAnnotation.DetectedLanguage.verify|verify} messages.
                         * @param message DetectedLanguage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.TextAnnotation.IDetectedLanguage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DetectedLanguage message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DetectedLanguage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.TextAnnotation.DetectedLanguage;

                        /**
                         * Decodes a DetectedLanguage message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DetectedLanguage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.TextAnnotation.DetectedLanguage;

                        /**
                         * Verifies a DetectedLanguage message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DetectedLanguage message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DetectedLanguage
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.TextAnnotation.DetectedLanguage;

                        /**
                         * Creates a plain object from a DetectedLanguage message. Also converts values to other types if specified.
                         * @param message DetectedLanguage
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.TextAnnotation.DetectedLanguage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DetectedLanguage to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for DetectedLanguage
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a DetectedBreak. */
                    interface IDetectedBreak {

                        /** DetectedBreak type */
                        type?: (google.cloud.vision.v1.TextAnnotation.DetectedBreak.BreakType|keyof typeof google.cloud.vision.v1.TextAnnotation.DetectedBreak.BreakType|null);

                        /** DetectedBreak isPrefix */
                        isPrefix?: (boolean|null);
                    }

                    /** Represents a DetectedBreak. */
                    class DetectedBreak implements IDetectedBreak {

                        /**
                         * Constructs a new DetectedBreak.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.TextAnnotation.IDetectedBreak);

                        /** DetectedBreak type. */
                        public type: (google.cloud.vision.v1.TextAnnotation.DetectedBreak.BreakType|keyof typeof google.cloud.vision.v1.TextAnnotation.DetectedBreak.BreakType);

                        /** DetectedBreak isPrefix. */
                        public isPrefix: boolean;

                        /**
                         * Creates a new DetectedBreak instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DetectedBreak instance
                         */
                        public static create(properties?: google.cloud.vision.v1.TextAnnotation.IDetectedBreak): google.cloud.vision.v1.TextAnnotation.DetectedBreak;

                        /**
                         * Encodes the specified DetectedBreak message. Does not implicitly {@link google.cloud.vision.v1.TextAnnotation.DetectedBreak.verify|verify} messages.
                         * @param message DetectedBreak message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.TextAnnotation.IDetectedBreak, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DetectedBreak message, length delimited. Does not implicitly {@link google.cloud.vision.v1.TextAnnotation.DetectedBreak.verify|verify} messages.
                         * @param message DetectedBreak message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.TextAnnotation.IDetectedBreak, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DetectedBreak message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DetectedBreak
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.TextAnnotation.DetectedBreak;

                        /**
                         * Decodes a DetectedBreak message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DetectedBreak
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.TextAnnotation.DetectedBreak;

                        /**
                         * Verifies a DetectedBreak message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DetectedBreak message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DetectedBreak
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.TextAnnotation.DetectedBreak;

                        /**
                         * Creates a plain object from a DetectedBreak message. Also converts values to other types if specified.
                         * @param message DetectedBreak
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.TextAnnotation.DetectedBreak, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DetectedBreak to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for DetectedBreak
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace DetectedBreak {

                        /** BreakType enum. */
                        enum BreakType {
                            UNKNOWN = 0,
                            SPACE = 1,
                            SURE_SPACE = 2,
                            EOL_SURE_SPACE = 3,
                            HYPHEN = 4,
                            LINE_BREAK = 5
                        }
                    }

                    /** Properties of a TextProperty. */
                    interface ITextProperty {

                        /** TextProperty detectedLanguages */
                        detectedLanguages?: (google.cloud.vision.v1.TextAnnotation.IDetectedLanguage[]|null);

                        /** TextProperty detectedBreak */
                        detectedBreak?: (google.cloud.vision.v1.TextAnnotation.IDetectedBreak|null);
                    }

                    /** Represents a TextProperty. */
                    class TextProperty implements ITextProperty {

                        /**
                         * Constructs a new TextProperty.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.TextAnnotation.ITextProperty);

                        /** TextProperty detectedLanguages. */
                        public detectedLanguages: google.cloud.vision.v1.TextAnnotation.IDetectedLanguage[];

                        /** TextProperty detectedBreak. */
                        public detectedBreak?: (google.cloud.vision.v1.TextAnnotation.IDetectedBreak|null);

                        /**
                         * Creates a new TextProperty instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TextProperty instance
                         */
                        public static create(properties?: google.cloud.vision.v1.TextAnnotation.ITextProperty): google.cloud.vision.v1.TextAnnotation.TextProperty;

                        /**
                         * Encodes the specified TextProperty message. Does not implicitly {@link google.cloud.vision.v1.TextAnnotation.TextProperty.verify|verify} messages.
                         * @param message TextProperty message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.TextAnnotation.ITextProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TextProperty message, length delimited. Does not implicitly {@link google.cloud.vision.v1.TextAnnotation.TextProperty.verify|verify} messages.
                         * @param message TextProperty message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.TextAnnotation.ITextProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TextProperty message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TextProperty
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.TextAnnotation.TextProperty;

                        /**
                         * Decodes a TextProperty message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TextProperty
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.TextAnnotation.TextProperty;

                        /**
                         * Verifies a TextProperty message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TextProperty message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TextProperty
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.TextAnnotation.TextProperty;

                        /**
                         * Creates a plain object from a TextProperty message. Also converts values to other types if specified.
                         * @param message TextProperty
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.TextAnnotation.TextProperty, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TextProperty to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for TextProperty
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }

                /** Properties of a Page. */
                interface IPage {

                    /** Page property */
                    property?: (google.cloud.vision.v1.TextAnnotation.ITextProperty|null);

                    /** Page width */
                    width?: (number|null);

                    /** Page height */
                    height?: (number|null);

                    /** Page blocks */
                    blocks?: (google.cloud.vision.v1.IBlock[]|null);

                    /** Page confidence */
                    confidence?: (number|null);
                }

                /** Represents a Page. */
                class Page implements IPage {

                    /**
                     * Constructs a new Page.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IPage);

                    /** Page property. */
                    public property?: (google.cloud.vision.v1.TextAnnotation.ITextProperty|null);

                    /** Page width. */
                    public width: number;

                    /** Page height. */
                    public height: number;

                    /** Page blocks. */
                    public blocks: google.cloud.vision.v1.IBlock[];

                    /** Page confidence. */
                    public confidence: number;

                    /**
                     * Creates a new Page instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Page instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IPage): google.cloud.vision.v1.Page;

                    /**
                     * Encodes the specified Page message. Does not implicitly {@link google.cloud.vision.v1.Page.verify|verify} messages.
                     * @param message Page message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IPage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Page message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Page.verify|verify} messages.
                     * @param message Page message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IPage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Page message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Page
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Page;

                    /**
                     * Decodes a Page message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Page
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Page;

                    /**
                     * Verifies a Page message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Page message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Page
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Page;

                    /**
                     * Creates a plain object from a Page message. Also converts values to other types if specified.
                     * @param message Page
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Page, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Page to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Page
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Block. */
                interface IBlock {

                    /** Block property */
                    property?: (google.cloud.vision.v1.TextAnnotation.ITextProperty|null);

                    /** Block boundingBox */
                    boundingBox?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** Block paragraphs */
                    paragraphs?: (google.cloud.vision.v1.IParagraph[]|null);

                    /** Block blockType */
                    blockType?: (google.cloud.vision.v1.Block.BlockType|keyof typeof google.cloud.vision.v1.Block.BlockType|null);

                    /** Block confidence */
                    confidence?: (number|null);
                }

                /** Represents a Block. */
                class Block implements IBlock {

                    /**
                     * Constructs a new Block.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IBlock);

                    /** Block property. */
                    public property?: (google.cloud.vision.v1.TextAnnotation.ITextProperty|null);

                    /** Block boundingBox. */
                    public boundingBox?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** Block paragraphs. */
                    public paragraphs: google.cloud.vision.v1.IParagraph[];

                    /** Block blockType. */
                    public blockType: (google.cloud.vision.v1.Block.BlockType|keyof typeof google.cloud.vision.v1.Block.BlockType);

                    /** Block confidence. */
                    public confidence: number;

                    /**
                     * Creates a new Block instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Block instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IBlock): google.cloud.vision.v1.Block;

                    /**
                     * Encodes the specified Block message. Does not implicitly {@link google.cloud.vision.v1.Block.verify|verify} messages.
                     * @param message Block message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IBlock, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Block message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Block.verify|verify} messages.
                     * @param message Block message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IBlock, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Block message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Block
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Block;

                    /**
                     * Decodes a Block message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Block
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Block;

                    /**
                     * Verifies a Block message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Block message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Block
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Block;

                    /**
                     * Creates a plain object from a Block message. Also converts values to other types if specified.
                     * @param message Block
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Block, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Block to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Block
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace Block {

                    /** BlockType enum. */
                    enum BlockType {
                        UNKNOWN = 0,
                        TEXT = 1,
                        TABLE = 2,
                        PICTURE = 3,
                        RULER = 4,
                        BARCODE = 5
                    }
                }

                /** Properties of a Paragraph. */
                interface IParagraph {

                    /** Paragraph property */
                    property?: (google.cloud.vision.v1.TextAnnotation.ITextProperty|null);

                    /** Paragraph boundingBox */
                    boundingBox?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** Paragraph words */
                    words?: (google.cloud.vision.v1.IWord[]|null);

                    /** Paragraph confidence */
                    confidence?: (number|null);
                }

                /** Represents a Paragraph. */
                class Paragraph implements IParagraph {

                    /**
                     * Constructs a new Paragraph.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IParagraph);

                    /** Paragraph property. */
                    public property?: (google.cloud.vision.v1.TextAnnotation.ITextProperty|null);

                    /** Paragraph boundingBox. */
                    public boundingBox?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** Paragraph words. */
                    public words: google.cloud.vision.v1.IWord[];

                    /** Paragraph confidence. */
                    public confidence: number;

                    /**
                     * Creates a new Paragraph instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Paragraph instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IParagraph): google.cloud.vision.v1.Paragraph;

                    /**
                     * Encodes the specified Paragraph message. Does not implicitly {@link google.cloud.vision.v1.Paragraph.verify|verify} messages.
                     * @param message Paragraph message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IParagraph, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Paragraph message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Paragraph.verify|verify} messages.
                     * @param message Paragraph message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IParagraph, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Paragraph message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Paragraph
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Paragraph;

                    /**
                     * Decodes a Paragraph message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Paragraph
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Paragraph;

                    /**
                     * Verifies a Paragraph message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Paragraph message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Paragraph
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Paragraph;

                    /**
                     * Creates a plain object from a Paragraph message. Also converts values to other types if specified.
                     * @param message Paragraph
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Paragraph, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Paragraph to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Paragraph
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Word. */
                interface IWord {

                    /** Word property */
                    property?: (google.cloud.vision.v1.TextAnnotation.ITextProperty|null);

                    /** Word boundingBox */
                    boundingBox?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** Word symbols */
                    symbols?: (google.cloud.vision.v1.ISymbol[]|null);

                    /** Word confidence */
                    confidence?: (number|null);
                }

                /** Represents a Word. */
                class Word implements IWord {

                    /**
                     * Constructs a new Word.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IWord);

                    /** Word property. */
                    public property?: (google.cloud.vision.v1.TextAnnotation.ITextProperty|null);

                    /** Word boundingBox. */
                    public boundingBox?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** Word symbols. */
                    public symbols: google.cloud.vision.v1.ISymbol[];

                    /** Word confidence. */
                    public confidence: number;

                    /**
                     * Creates a new Word instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Word instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IWord): google.cloud.vision.v1.Word;

                    /**
                     * Encodes the specified Word message. Does not implicitly {@link google.cloud.vision.v1.Word.verify|verify} messages.
                     * @param message Word message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IWord, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Word message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Word.verify|verify} messages.
                     * @param message Word message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IWord, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Word message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Word
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Word;

                    /**
                     * Decodes a Word message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Word
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Word;

                    /**
                     * Verifies a Word message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Word message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Word
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Word;

                    /**
                     * Creates a plain object from a Word message. Also converts values to other types if specified.
                     * @param message Word
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Word, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Word to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Word
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Symbol. */
                interface ISymbol {

                    /** Symbol property */
                    property?: (google.cloud.vision.v1.TextAnnotation.ITextProperty|null);

                    /** Symbol boundingBox */
                    boundingBox?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** Symbol text */
                    text?: (string|null);

                    /** Symbol confidence */
                    confidence?: (number|null);
                }

                /** Represents a Symbol. */
                class Symbol implements ISymbol {

                    /**
                     * Constructs a new Symbol.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.ISymbol);

                    /** Symbol property. */
                    public property?: (google.cloud.vision.v1.TextAnnotation.ITextProperty|null);

                    /** Symbol boundingBox. */
                    public boundingBox?: (google.cloud.vision.v1.IBoundingPoly|null);

                    /** Symbol text. */
                    public text: string;

                    /** Symbol confidence. */
                    public confidence: number;

                    /**
                     * Creates a new Symbol instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Symbol instance
                     */
                    public static create(properties?: google.cloud.vision.v1.ISymbol): google.cloud.vision.v1.Symbol;

                    /**
                     * Encodes the specified Symbol message. Does not implicitly {@link google.cloud.vision.v1.Symbol.verify|verify} messages.
                     * @param message Symbol message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.ISymbol, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Symbol message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Symbol.verify|verify} messages.
                     * @param message Symbol message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.ISymbol, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Symbol message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Symbol
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.Symbol;

                    /**
                     * Decodes a Symbol message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Symbol
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.Symbol;

                    /**
                     * Verifies a Symbol message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Symbol message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Symbol
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.Symbol;

                    /**
                     * Creates a plain object from a Symbol message. Also converts values to other types if specified.
                     * @param message Symbol
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.Symbol, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Symbol to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Symbol
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a WebDetection. */
                interface IWebDetection {

                    /** WebDetection webEntities */
                    webEntities?: (google.cloud.vision.v1.WebDetection.IWebEntity[]|null);

                    /** WebDetection fullMatchingImages */
                    fullMatchingImages?: (google.cloud.vision.v1.WebDetection.IWebImage[]|null);

                    /** WebDetection partialMatchingImages */
                    partialMatchingImages?: (google.cloud.vision.v1.WebDetection.IWebImage[]|null);

                    /** WebDetection pagesWithMatchingImages */
                    pagesWithMatchingImages?: (google.cloud.vision.v1.WebDetection.IWebPage[]|null);

                    /** WebDetection visuallySimilarImages */
                    visuallySimilarImages?: (google.cloud.vision.v1.WebDetection.IWebImage[]|null);

                    /** WebDetection bestGuessLabels */
                    bestGuessLabels?: (google.cloud.vision.v1.WebDetection.IWebLabel[]|null);
                }

                /** Represents a WebDetection. */
                class WebDetection implements IWebDetection {

                    /**
                     * Constructs a new WebDetection.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1.IWebDetection);

                    /** WebDetection webEntities. */
                    public webEntities: google.cloud.vision.v1.WebDetection.IWebEntity[];

                    /** WebDetection fullMatchingImages. */
                    public fullMatchingImages: google.cloud.vision.v1.WebDetection.IWebImage[];

                    /** WebDetection partialMatchingImages. */
                    public partialMatchingImages: google.cloud.vision.v1.WebDetection.IWebImage[];

                    /** WebDetection pagesWithMatchingImages. */
                    public pagesWithMatchingImages: google.cloud.vision.v1.WebDetection.IWebPage[];

                    /** WebDetection visuallySimilarImages. */
                    public visuallySimilarImages: google.cloud.vision.v1.WebDetection.IWebImage[];

                    /** WebDetection bestGuessLabels. */
                    public bestGuessLabels: google.cloud.vision.v1.WebDetection.IWebLabel[];

                    /**
                     * Creates a new WebDetection instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns WebDetection instance
                     */
                    public static create(properties?: google.cloud.vision.v1.IWebDetection): google.cloud.vision.v1.WebDetection;

                    /**
                     * Encodes the specified WebDetection message. Does not implicitly {@link google.cloud.vision.v1.WebDetection.verify|verify} messages.
                     * @param message WebDetection message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1.IWebDetection, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified WebDetection message, length delimited. Does not implicitly {@link google.cloud.vision.v1.WebDetection.verify|verify} messages.
                     * @param message WebDetection message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1.IWebDetection, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a WebDetection message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns WebDetection
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.WebDetection;

                    /**
                     * Decodes a WebDetection message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns WebDetection
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.WebDetection;

                    /**
                     * Verifies a WebDetection message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a WebDetection message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns WebDetection
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.WebDetection;

                    /**
                     * Creates a plain object from a WebDetection message. Also converts values to other types if specified.
                     * @param message WebDetection
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1.WebDetection, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this WebDetection to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for WebDetection
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace WebDetection {

                    /** Properties of a WebEntity. */
                    interface IWebEntity {

                        /** WebEntity entityId */
                        entityId?: (string|null);

                        /** WebEntity score */
                        score?: (number|null);

                        /** WebEntity description */
                        description?: (string|null);
                    }

                    /** Represents a WebEntity. */
                    class WebEntity implements IWebEntity {

                        /**
                         * Constructs a new WebEntity.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.WebDetection.IWebEntity);

                        /** WebEntity entityId. */
                        public entityId: string;

                        /** WebEntity score. */
                        public score: number;

                        /** WebEntity description. */
                        public description: string;

                        /**
                         * Creates a new WebEntity instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns WebEntity instance
                         */
                        public static create(properties?: google.cloud.vision.v1.WebDetection.IWebEntity): google.cloud.vision.v1.WebDetection.WebEntity;

                        /**
                         * Encodes the specified WebEntity message. Does not implicitly {@link google.cloud.vision.v1.WebDetection.WebEntity.verify|verify} messages.
                         * @param message WebEntity message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.WebDetection.IWebEntity, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified WebEntity message, length delimited. Does not implicitly {@link google.cloud.vision.v1.WebDetection.WebEntity.verify|verify} messages.
                         * @param message WebEntity message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.WebDetection.IWebEntity, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a WebEntity message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns WebEntity
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.WebDetection.WebEntity;

                        /**
                         * Decodes a WebEntity message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns WebEntity
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.WebDetection.WebEntity;

                        /**
                         * Verifies a WebEntity message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a WebEntity message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns WebEntity
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.WebDetection.WebEntity;

                        /**
                         * Creates a plain object from a WebEntity message. Also converts values to other types if specified.
                         * @param message WebEntity
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.WebDetection.WebEntity, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this WebEntity to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for WebEntity
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a WebImage. */
                    interface IWebImage {

                        /** WebImage url */
                        url?: (string|null);

                        /** WebImage score */
                        score?: (number|null);
                    }

                    /** Represents a WebImage. */
                    class WebImage implements IWebImage {

                        /**
                         * Constructs a new WebImage.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.WebDetection.IWebImage);

                        /** WebImage url. */
                        public url: string;

                        /** WebImage score. */
                        public score: number;

                        /**
                         * Creates a new WebImage instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns WebImage instance
                         */
                        public static create(properties?: google.cloud.vision.v1.WebDetection.IWebImage): google.cloud.vision.v1.WebDetection.WebImage;

                        /**
                         * Encodes the specified WebImage message. Does not implicitly {@link google.cloud.vision.v1.WebDetection.WebImage.verify|verify} messages.
                         * @param message WebImage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.WebDetection.IWebImage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified WebImage message, length delimited. Does not implicitly {@link google.cloud.vision.v1.WebDetection.WebImage.verify|verify} messages.
                         * @param message WebImage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.WebDetection.IWebImage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a WebImage message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns WebImage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.WebDetection.WebImage;

                        /**
                         * Decodes a WebImage message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns WebImage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.WebDetection.WebImage;

                        /**
                         * Verifies a WebImage message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a WebImage message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns WebImage
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.WebDetection.WebImage;

                        /**
                         * Creates a plain object from a WebImage message. Also converts values to other types if specified.
                         * @param message WebImage
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.WebDetection.WebImage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this WebImage to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for WebImage
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a WebPage. */
                    interface IWebPage {

                        /** WebPage url */
                        url?: (string|null);

                        /** WebPage score */
                        score?: (number|null);

                        /** WebPage pageTitle */
                        pageTitle?: (string|null);

                        /** WebPage fullMatchingImages */
                        fullMatchingImages?: (google.cloud.vision.v1.WebDetection.IWebImage[]|null);

                        /** WebPage partialMatchingImages */
                        partialMatchingImages?: (google.cloud.vision.v1.WebDetection.IWebImage[]|null);
                    }

                    /** Represents a WebPage. */
                    class WebPage implements IWebPage {

                        /**
                         * Constructs a new WebPage.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.WebDetection.IWebPage);

                        /** WebPage url. */
                        public url: string;

                        /** WebPage score. */
                        public score: number;

                        /** WebPage pageTitle. */
                        public pageTitle: string;

                        /** WebPage fullMatchingImages. */
                        public fullMatchingImages: google.cloud.vision.v1.WebDetection.IWebImage[];

                        /** WebPage partialMatchingImages. */
                        public partialMatchingImages: google.cloud.vision.v1.WebDetection.IWebImage[];

                        /**
                         * Creates a new WebPage instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns WebPage instance
                         */
                        public static create(properties?: google.cloud.vision.v1.WebDetection.IWebPage): google.cloud.vision.v1.WebDetection.WebPage;

                        /**
                         * Encodes the specified WebPage message. Does not implicitly {@link google.cloud.vision.v1.WebDetection.WebPage.verify|verify} messages.
                         * @param message WebPage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.WebDetection.IWebPage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified WebPage message, length delimited. Does not implicitly {@link google.cloud.vision.v1.WebDetection.WebPage.verify|verify} messages.
                         * @param message WebPage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.WebDetection.IWebPage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a WebPage message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns WebPage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.WebDetection.WebPage;

                        /**
                         * Decodes a WebPage message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns WebPage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.WebDetection.WebPage;

                        /**
                         * Verifies a WebPage message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a WebPage message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns WebPage
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.WebDetection.WebPage;

                        /**
                         * Creates a plain object from a WebPage message. Also converts values to other types if specified.
                         * @param message WebPage
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.WebDetection.WebPage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this WebPage to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for WebPage
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a WebLabel. */
                    interface IWebLabel {

                        /** WebLabel label */
                        label?: (string|null);

                        /** WebLabel languageCode */
                        languageCode?: (string|null);
                    }

                    /** Represents a WebLabel. */
                    class WebLabel implements IWebLabel {

                        /**
                         * Constructs a new WebLabel.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1.WebDetection.IWebLabel);

                        /** WebLabel label. */
                        public label: string;

                        /** WebLabel languageCode. */
                        public languageCode: string;

                        /**
                         * Creates a new WebLabel instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns WebLabel instance
                         */
                        public static create(properties?: google.cloud.vision.v1.WebDetection.IWebLabel): google.cloud.vision.v1.WebDetection.WebLabel;

                        /**
                         * Encodes the specified WebLabel message. Does not implicitly {@link google.cloud.vision.v1.WebDetection.WebLabel.verify|verify} messages.
                         * @param message WebLabel message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1.WebDetection.IWebLabel, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified WebLabel message, length delimited. Does not implicitly {@link google.cloud.vision.v1.WebDetection.WebLabel.verify|verify} messages.
                         * @param message WebLabel message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1.WebDetection.IWebLabel, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a WebLabel message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns WebLabel
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1.WebDetection.WebLabel;

                        /**
                         * Decodes a WebLabel message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns WebLabel
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1.WebDetection.WebLabel;

                        /**
                         * Verifies a WebLabel message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a WebLabel message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns WebLabel
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1.WebDetection.WebLabel;

                        /**
                         * Creates a plain object from a WebLabel message. Also converts values to other types if specified.
                         * @param message WebLabel
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1.WebDetection.WebLabel, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this WebLabel to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for WebLabel
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }
            }

            /** Namespace v1p1beta1. */
            namespace v1p1beta1 {

                /** Properties of a Vertex. */
                interface IVertex {

                    /** Vertex x */
                    x?: (number|null);

                    /** Vertex y */
                    y?: (number|null);
                }

                /** Represents a Vertex. */
                class Vertex implements IVertex {

                    /**
                     * Constructs a new Vertex.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IVertex);

                    /** Vertex x. */
                    public x: number;

                    /** Vertex y. */
                    public y: number;

                    /**
                     * Creates a new Vertex instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Vertex instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IVertex): google.cloud.vision.v1p1beta1.Vertex;

                    /**
                     * Encodes the specified Vertex message. Does not implicitly {@link google.cloud.vision.v1p1beta1.Vertex.verify|verify} messages.
                     * @param message Vertex message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IVertex, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Vertex message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.Vertex.verify|verify} messages.
                     * @param message Vertex message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IVertex, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Vertex message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Vertex
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.Vertex;

                    /**
                     * Decodes a Vertex message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Vertex
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.Vertex;

                    /**
                     * Verifies a Vertex message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Vertex message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Vertex
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.Vertex;

                    /**
                     * Creates a plain object from a Vertex message. Also converts values to other types if specified.
                     * @param message Vertex
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.Vertex, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Vertex to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Vertex
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BoundingPoly. */
                interface IBoundingPoly {

                    /** BoundingPoly vertices */
                    vertices?: (google.cloud.vision.v1p1beta1.IVertex[]|null);
                }

                /** Represents a BoundingPoly. */
                class BoundingPoly implements IBoundingPoly {

                    /**
                     * Constructs a new BoundingPoly.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IBoundingPoly);

                    /** BoundingPoly vertices. */
                    public vertices: google.cloud.vision.v1p1beta1.IVertex[];

                    /**
                     * Creates a new BoundingPoly instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BoundingPoly instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IBoundingPoly): google.cloud.vision.v1p1beta1.BoundingPoly;

                    /**
                     * Encodes the specified BoundingPoly message. Does not implicitly {@link google.cloud.vision.v1p1beta1.BoundingPoly.verify|verify} messages.
                     * @param message BoundingPoly message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IBoundingPoly, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BoundingPoly message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.BoundingPoly.verify|verify} messages.
                     * @param message BoundingPoly message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IBoundingPoly, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BoundingPoly message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BoundingPoly
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.BoundingPoly;

                    /**
                     * Decodes a BoundingPoly message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BoundingPoly
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.BoundingPoly;

                    /**
                     * Verifies a BoundingPoly message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BoundingPoly message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BoundingPoly
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.BoundingPoly;

                    /**
                     * Creates a plain object from a BoundingPoly message. Also converts values to other types if specified.
                     * @param message BoundingPoly
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.BoundingPoly, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BoundingPoly to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BoundingPoly
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Position. */
                interface IPosition {

                    /** Position x */
                    x?: (number|null);

                    /** Position y */
                    y?: (number|null);

                    /** Position z */
                    z?: (number|null);
                }

                /** Represents a Position. */
                class Position implements IPosition {

                    /**
                     * Constructs a new Position.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IPosition);

                    /** Position x. */
                    public x: number;

                    /** Position y. */
                    public y: number;

                    /** Position z. */
                    public z: number;

                    /**
                     * Creates a new Position instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Position instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IPosition): google.cloud.vision.v1p1beta1.Position;

                    /**
                     * Encodes the specified Position message. Does not implicitly {@link google.cloud.vision.v1p1beta1.Position.verify|verify} messages.
                     * @param message Position message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IPosition, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Position message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.Position.verify|verify} messages.
                     * @param message Position message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IPosition, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Position message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Position
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.Position;

                    /**
                     * Decodes a Position message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Position
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.Position;

                    /**
                     * Verifies a Position message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Position message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Position
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.Position;

                    /**
                     * Creates a plain object from a Position message. Also converts values to other types if specified.
                     * @param message Position
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.Position, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Position to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Position
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Represents an ImageAnnotator */
                class ImageAnnotator extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new ImageAnnotator service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new ImageAnnotator service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): ImageAnnotator;

                    /**
                     * Calls BatchAnnotateImages.
                     * @param request BatchAnnotateImagesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and BatchAnnotateImagesResponse
                     */
                    public batchAnnotateImages(request: google.cloud.vision.v1p1beta1.IBatchAnnotateImagesRequest, callback: google.cloud.vision.v1p1beta1.ImageAnnotator.BatchAnnotateImagesCallback): void;

                    /**
                     * Calls BatchAnnotateImages.
                     * @param request BatchAnnotateImagesRequest message or plain object
                     * @returns Promise
                     */
                    public batchAnnotateImages(request: google.cloud.vision.v1p1beta1.IBatchAnnotateImagesRequest): Promise<google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse>;
                }

                namespace ImageAnnotator {

                    /**
                     * Callback as used by {@link google.cloud.vision.v1p1beta1.ImageAnnotator|batchAnnotateImages}.
                     * @param error Error, if any
                     * @param [response] BatchAnnotateImagesResponse
                     */
                    type BatchAnnotateImagesCallback = (error: (Error|null), response?: google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse) => void;
                }

                /** Properties of a Feature. */
                interface IFeature {

                    /** Feature type */
                    type?: (google.cloud.vision.v1p1beta1.Feature.Type|keyof typeof google.cloud.vision.v1p1beta1.Feature.Type|null);

                    /** Feature maxResults */
                    maxResults?: (number|null);

                    /** Feature model */
                    model?: (string|null);
                }

                /** Represents a Feature. */
                class Feature implements IFeature {

                    /**
                     * Constructs a new Feature.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IFeature);

                    /** Feature type. */
                    public type: (google.cloud.vision.v1p1beta1.Feature.Type|keyof typeof google.cloud.vision.v1p1beta1.Feature.Type);

                    /** Feature maxResults. */
                    public maxResults: number;

                    /** Feature model. */
                    public model: string;

                    /**
                     * Creates a new Feature instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Feature instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IFeature): google.cloud.vision.v1p1beta1.Feature;

                    /**
                     * Encodes the specified Feature message. Does not implicitly {@link google.cloud.vision.v1p1beta1.Feature.verify|verify} messages.
                     * @param message Feature message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IFeature, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Feature message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.Feature.verify|verify} messages.
                     * @param message Feature message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IFeature, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Feature message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Feature
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.Feature;

                    /**
                     * Decodes a Feature message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Feature
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.Feature;

                    /**
                     * Verifies a Feature message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Feature message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Feature
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.Feature;

                    /**
                     * Creates a plain object from a Feature message. Also converts values to other types if specified.
                     * @param message Feature
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.Feature, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Feature to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Feature
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace Feature {

                    /** Type enum. */
                    enum Type {
                        TYPE_UNSPECIFIED = 0,
                        FACE_DETECTION = 1,
                        LANDMARK_DETECTION = 2,
                        LOGO_DETECTION = 3,
                        LABEL_DETECTION = 4,
                        TEXT_DETECTION = 5,
                        DOCUMENT_TEXT_DETECTION = 11,
                        SAFE_SEARCH_DETECTION = 6,
                        IMAGE_PROPERTIES = 7,
                        CROP_HINTS = 9,
                        WEB_DETECTION = 10
                    }
                }

                /** Properties of an ImageSource. */
                interface IImageSource {

                    /** ImageSource gcsImageUri */
                    gcsImageUri?: (string|null);

                    /** ImageSource imageUri */
                    imageUri?: (string|null);
                }

                /** Represents an ImageSource. */
                class ImageSource implements IImageSource {

                    /**
                     * Constructs a new ImageSource.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IImageSource);

                    /** ImageSource gcsImageUri. */
                    public gcsImageUri: string;

                    /** ImageSource imageUri. */
                    public imageUri: string;

                    /**
                     * Creates a new ImageSource instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageSource instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IImageSource): google.cloud.vision.v1p1beta1.ImageSource;

                    /**
                     * Encodes the specified ImageSource message. Does not implicitly {@link google.cloud.vision.v1p1beta1.ImageSource.verify|verify} messages.
                     * @param message ImageSource message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IImageSource, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageSource message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.ImageSource.verify|verify} messages.
                     * @param message ImageSource message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IImageSource, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageSource message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageSource
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.ImageSource;

                    /**
                     * Decodes an ImageSource message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageSource
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.ImageSource;

                    /**
                     * Verifies an ImageSource message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageSource message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageSource
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.ImageSource;

                    /**
                     * Creates a plain object from an ImageSource message. Also converts values to other types if specified.
                     * @param message ImageSource
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.ImageSource, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageSource to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageSource
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an Image. */
                interface IImage {

                    /** Image content */
                    content?: (Uint8Array|Buffer|string|null);

                    /** Image source */
                    source?: (google.cloud.vision.v1p1beta1.IImageSource|null);
                }

                /** Represents an Image. */
                class Image implements IImage {

                    /**
                     * Constructs a new Image.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IImage);

                    /** Image content. */
                    public content: (Uint8Array|Buffer|string);

                    /** Image source. */
                    public source?: (google.cloud.vision.v1p1beta1.IImageSource|null);

                    /**
                     * Creates a new Image instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Image instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IImage): google.cloud.vision.v1p1beta1.Image;

                    /**
                     * Encodes the specified Image message. Does not implicitly {@link google.cloud.vision.v1p1beta1.Image.verify|verify} messages.
                     * @param message Image message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IImage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Image message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.Image.verify|verify} messages.
                     * @param message Image message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IImage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an Image message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Image
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.Image;

                    /**
                     * Decodes an Image message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Image
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.Image;

                    /**
                     * Verifies an Image message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an Image message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Image
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.Image;

                    /**
                     * Creates a plain object from an Image message. Also converts values to other types if specified.
                     * @param message Image
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.Image, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Image to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Image
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a FaceAnnotation. */
                interface IFaceAnnotation {

                    /** FaceAnnotation boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** FaceAnnotation fdBoundingPoly */
                    fdBoundingPoly?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** FaceAnnotation landmarks */
                    landmarks?: (google.cloud.vision.v1p1beta1.FaceAnnotation.ILandmark[]|null);

                    /** FaceAnnotation rollAngle */
                    rollAngle?: (number|null);

                    /** FaceAnnotation panAngle */
                    panAngle?: (number|null);

                    /** FaceAnnotation tiltAngle */
                    tiltAngle?: (number|null);

                    /** FaceAnnotation detectionConfidence */
                    detectionConfidence?: (number|null);

                    /** FaceAnnotation landmarkingConfidence */
                    landmarkingConfidence?: (number|null);

                    /** FaceAnnotation joyLikelihood */
                    joyLikelihood?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);

                    /** FaceAnnotation sorrowLikelihood */
                    sorrowLikelihood?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);

                    /** FaceAnnotation angerLikelihood */
                    angerLikelihood?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);

                    /** FaceAnnotation surpriseLikelihood */
                    surpriseLikelihood?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);

                    /** FaceAnnotation underExposedLikelihood */
                    underExposedLikelihood?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);

                    /** FaceAnnotation blurredLikelihood */
                    blurredLikelihood?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);

                    /** FaceAnnotation headwearLikelihood */
                    headwearLikelihood?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);
                }

                /** Represents a FaceAnnotation. */
                class FaceAnnotation implements IFaceAnnotation {

                    /**
                     * Constructs a new FaceAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IFaceAnnotation);

                    /** FaceAnnotation boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** FaceAnnotation fdBoundingPoly. */
                    public fdBoundingPoly?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** FaceAnnotation landmarks. */
                    public landmarks: google.cloud.vision.v1p1beta1.FaceAnnotation.ILandmark[];

                    /** FaceAnnotation rollAngle. */
                    public rollAngle: number;

                    /** FaceAnnotation panAngle. */
                    public panAngle: number;

                    /** FaceAnnotation tiltAngle. */
                    public tiltAngle: number;

                    /** FaceAnnotation detectionConfidence. */
                    public detectionConfidence: number;

                    /** FaceAnnotation landmarkingConfidence. */
                    public landmarkingConfidence: number;

                    /** FaceAnnotation joyLikelihood. */
                    public joyLikelihood: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /** FaceAnnotation sorrowLikelihood. */
                    public sorrowLikelihood: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /** FaceAnnotation angerLikelihood. */
                    public angerLikelihood: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /** FaceAnnotation surpriseLikelihood. */
                    public surpriseLikelihood: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /** FaceAnnotation underExposedLikelihood. */
                    public underExposedLikelihood: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /** FaceAnnotation blurredLikelihood. */
                    public blurredLikelihood: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /** FaceAnnotation headwearLikelihood. */
                    public headwearLikelihood: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /**
                     * Creates a new FaceAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns FaceAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IFaceAnnotation): google.cloud.vision.v1p1beta1.FaceAnnotation;

                    /**
                     * Encodes the specified FaceAnnotation message. Does not implicitly {@link google.cloud.vision.v1p1beta1.FaceAnnotation.verify|verify} messages.
                     * @param message FaceAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IFaceAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified FaceAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.FaceAnnotation.verify|verify} messages.
                     * @param message FaceAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IFaceAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a FaceAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns FaceAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.FaceAnnotation;

                    /**
                     * Decodes a FaceAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns FaceAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.FaceAnnotation;

                    /**
                     * Verifies a FaceAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a FaceAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns FaceAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.FaceAnnotation;

                    /**
                     * Creates a plain object from a FaceAnnotation message. Also converts values to other types if specified.
                     * @param message FaceAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.FaceAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this FaceAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for FaceAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace FaceAnnotation {

                    /** Properties of a Landmark. */
                    interface ILandmark {

                        /** Landmark type */
                        type?: (google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark.Type|keyof typeof google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark.Type|null);

                        /** Landmark position */
                        position?: (google.cloud.vision.v1p1beta1.IPosition|null);
                    }

                    /** Represents a Landmark. */
                    class Landmark implements ILandmark {

                        /**
                         * Constructs a new Landmark.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1p1beta1.FaceAnnotation.ILandmark);

                        /** Landmark type. */
                        public type: (google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark.Type|keyof typeof google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark.Type);

                        /** Landmark position. */
                        public position?: (google.cloud.vision.v1p1beta1.IPosition|null);

                        /**
                         * Creates a new Landmark instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Landmark instance
                         */
                        public static create(properties?: google.cloud.vision.v1p1beta1.FaceAnnotation.ILandmark): google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark;

                        /**
                         * Encodes the specified Landmark message. Does not implicitly {@link google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark.verify|verify} messages.
                         * @param message Landmark message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1p1beta1.FaceAnnotation.ILandmark, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Landmark message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark.verify|verify} messages.
                         * @param message Landmark message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1p1beta1.FaceAnnotation.ILandmark, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Landmark message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Landmark
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark;

                        /**
                         * Decodes a Landmark message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Landmark
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark;

                        /**
                         * Verifies a Landmark message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Landmark message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Landmark
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark;

                        /**
                         * Creates a plain object from a Landmark message. Also converts values to other types if specified.
                         * @param message Landmark
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Landmark to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for Landmark
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace Landmark {

                        /** Type enum. */
                        enum Type {
                            UNKNOWN_LANDMARK = 0,
                            LEFT_EYE = 1,
                            RIGHT_EYE = 2,
                            LEFT_OF_LEFT_EYEBROW = 3,
                            RIGHT_OF_LEFT_EYEBROW = 4,
                            LEFT_OF_RIGHT_EYEBROW = 5,
                            RIGHT_OF_RIGHT_EYEBROW = 6,
                            MIDPOINT_BETWEEN_EYES = 7,
                            NOSE_TIP = 8,
                            UPPER_LIP = 9,
                            LOWER_LIP = 10,
                            MOUTH_LEFT = 11,
                            MOUTH_RIGHT = 12,
                            MOUTH_CENTER = 13,
                            NOSE_BOTTOM_RIGHT = 14,
                            NOSE_BOTTOM_LEFT = 15,
                            NOSE_BOTTOM_CENTER = 16,
                            LEFT_EYE_TOP_BOUNDARY = 17,
                            LEFT_EYE_RIGHT_CORNER = 18,
                            LEFT_EYE_BOTTOM_BOUNDARY = 19,
                            LEFT_EYE_LEFT_CORNER = 20,
                            RIGHT_EYE_TOP_BOUNDARY = 21,
                            RIGHT_EYE_RIGHT_CORNER = 22,
                            RIGHT_EYE_BOTTOM_BOUNDARY = 23,
                            RIGHT_EYE_LEFT_CORNER = 24,
                            LEFT_EYEBROW_UPPER_MIDPOINT = 25,
                            RIGHT_EYEBROW_UPPER_MIDPOINT = 26,
                            LEFT_EAR_TRAGION = 27,
                            RIGHT_EAR_TRAGION = 28,
                            LEFT_EYE_PUPIL = 29,
                            RIGHT_EYE_PUPIL = 30,
                            FOREHEAD_GLABELLA = 31,
                            CHIN_GNATHION = 32,
                            CHIN_LEFT_GONION = 33,
                            CHIN_RIGHT_GONION = 34
                        }
                    }
                }

                /** Properties of a LocationInfo. */
                interface ILocationInfo {

                    /** LocationInfo latLng */
                    latLng?: (google.type.ILatLng|null);
                }

                /** Represents a LocationInfo. */
                class LocationInfo implements ILocationInfo {

                    /**
                     * Constructs a new LocationInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.ILocationInfo);

                    /** LocationInfo latLng. */
                    public latLng?: (google.type.ILatLng|null);

                    /**
                     * Creates a new LocationInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns LocationInfo instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.ILocationInfo): google.cloud.vision.v1p1beta1.LocationInfo;

                    /**
                     * Encodes the specified LocationInfo message. Does not implicitly {@link google.cloud.vision.v1p1beta1.LocationInfo.verify|verify} messages.
                     * @param message LocationInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.ILocationInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified LocationInfo message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.LocationInfo.verify|verify} messages.
                     * @param message LocationInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.ILocationInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a LocationInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns LocationInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.LocationInfo;

                    /**
                     * Decodes a LocationInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns LocationInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.LocationInfo;

                    /**
                     * Verifies a LocationInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a LocationInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns LocationInfo
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.LocationInfo;

                    /**
                     * Creates a plain object from a LocationInfo message. Also converts values to other types if specified.
                     * @param message LocationInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.LocationInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this LocationInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for LocationInfo
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Property. */
                interface IProperty {

                    /** Property name */
                    name?: (string|null);

                    /** Property value */
                    value?: (string|null);

                    /** Property uint64Value */
                    uint64Value?: (number|Long|string|null);
                }

                /** Represents a Property. */
                class Property implements IProperty {

                    /**
                     * Constructs a new Property.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IProperty);

                    /** Property name. */
                    public name: string;

                    /** Property value. */
                    public value: string;

                    /** Property uint64Value. */
                    public uint64Value: (number|Long|string);

                    /**
                     * Creates a new Property instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Property instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IProperty): google.cloud.vision.v1p1beta1.Property;

                    /**
                     * Encodes the specified Property message. Does not implicitly {@link google.cloud.vision.v1p1beta1.Property.verify|verify} messages.
                     * @param message Property message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Property message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.Property.verify|verify} messages.
                     * @param message Property message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Property message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Property
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.Property;

                    /**
                     * Decodes a Property message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Property
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.Property;

                    /**
                     * Verifies a Property message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Property message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Property
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.Property;

                    /**
                     * Creates a plain object from a Property message. Also converts values to other types if specified.
                     * @param message Property
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.Property, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Property to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Property
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an EntityAnnotation. */
                interface IEntityAnnotation {

                    /** EntityAnnotation mid */
                    mid?: (string|null);

                    /** EntityAnnotation locale */
                    locale?: (string|null);

                    /** EntityAnnotation description */
                    description?: (string|null);

                    /** EntityAnnotation score */
                    score?: (number|null);

                    /** EntityAnnotation confidence */
                    confidence?: (number|null);

                    /** EntityAnnotation topicality */
                    topicality?: (number|null);

                    /** EntityAnnotation boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** EntityAnnotation locations */
                    locations?: (google.cloud.vision.v1p1beta1.ILocationInfo[]|null);

                    /** EntityAnnotation properties */
                    properties?: (google.cloud.vision.v1p1beta1.IProperty[]|null);
                }

                /** Represents an EntityAnnotation. */
                class EntityAnnotation implements IEntityAnnotation {

                    /**
                     * Constructs a new EntityAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IEntityAnnotation);

                    /** EntityAnnotation mid. */
                    public mid: string;

                    /** EntityAnnotation locale. */
                    public locale: string;

                    /** EntityAnnotation description. */
                    public description: string;

                    /** EntityAnnotation score. */
                    public score: number;

                    /** EntityAnnotation confidence. */
                    public confidence: number;

                    /** EntityAnnotation topicality. */
                    public topicality: number;

                    /** EntityAnnotation boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** EntityAnnotation locations. */
                    public locations: google.cloud.vision.v1p1beta1.ILocationInfo[];

                    /** EntityAnnotation properties. */
                    public properties: google.cloud.vision.v1p1beta1.IProperty[];

                    /**
                     * Creates a new EntityAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns EntityAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IEntityAnnotation): google.cloud.vision.v1p1beta1.EntityAnnotation;

                    /**
                     * Encodes the specified EntityAnnotation message. Does not implicitly {@link google.cloud.vision.v1p1beta1.EntityAnnotation.verify|verify} messages.
                     * @param message EntityAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IEntityAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified EntityAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.EntityAnnotation.verify|verify} messages.
                     * @param message EntityAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IEntityAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an EntityAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns EntityAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.EntityAnnotation;

                    /**
                     * Decodes an EntityAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns EntityAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.EntityAnnotation;

                    /**
                     * Verifies an EntityAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an EntityAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns EntityAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.EntityAnnotation;

                    /**
                     * Creates a plain object from an EntityAnnotation message. Also converts values to other types if specified.
                     * @param message EntityAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.EntityAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this EntityAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for EntityAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a SafeSearchAnnotation. */
                interface ISafeSearchAnnotation {

                    /** SafeSearchAnnotation adult */
                    adult?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);

                    /** SafeSearchAnnotation spoof */
                    spoof?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);

                    /** SafeSearchAnnotation medical */
                    medical?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);

                    /** SafeSearchAnnotation violence */
                    violence?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);

                    /** SafeSearchAnnotation racy */
                    racy?: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood|null);
                }

                /** Represents a SafeSearchAnnotation. */
                class SafeSearchAnnotation implements ISafeSearchAnnotation {

                    /**
                     * Constructs a new SafeSearchAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.ISafeSearchAnnotation);

                    /** SafeSearchAnnotation adult. */
                    public adult: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /** SafeSearchAnnotation spoof. */
                    public spoof: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /** SafeSearchAnnotation medical. */
                    public medical: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /** SafeSearchAnnotation violence. */
                    public violence: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /** SafeSearchAnnotation racy. */
                    public racy: (google.cloud.vision.v1p1beta1.Likelihood|keyof typeof google.cloud.vision.v1p1beta1.Likelihood);

                    /**
                     * Creates a new SafeSearchAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SafeSearchAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.ISafeSearchAnnotation): google.cloud.vision.v1p1beta1.SafeSearchAnnotation;

                    /**
                     * Encodes the specified SafeSearchAnnotation message. Does not implicitly {@link google.cloud.vision.v1p1beta1.SafeSearchAnnotation.verify|verify} messages.
                     * @param message SafeSearchAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.ISafeSearchAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SafeSearchAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.SafeSearchAnnotation.verify|verify} messages.
                     * @param message SafeSearchAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.ISafeSearchAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SafeSearchAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SafeSearchAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.SafeSearchAnnotation;

                    /**
                     * Decodes a SafeSearchAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SafeSearchAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.SafeSearchAnnotation;

                    /**
                     * Verifies a SafeSearchAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SafeSearchAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SafeSearchAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.SafeSearchAnnotation;

                    /**
                     * Creates a plain object from a SafeSearchAnnotation message. Also converts values to other types if specified.
                     * @param message SafeSearchAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.SafeSearchAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SafeSearchAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for SafeSearchAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a LatLongRect. */
                interface ILatLongRect {

                    /** LatLongRect minLatLng */
                    minLatLng?: (google.type.ILatLng|null);

                    /** LatLongRect maxLatLng */
                    maxLatLng?: (google.type.ILatLng|null);
                }

                /** Represents a LatLongRect. */
                class LatLongRect implements ILatLongRect {

                    /**
                     * Constructs a new LatLongRect.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.ILatLongRect);

                    /** LatLongRect minLatLng. */
                    public minLatLng?: (google.type.ILatLng|null);

                    /** LatLongRect maxLatLng. */
                    public maxLatLng?: (google.type.ILatLng|null);

                    /**
                     * Creates a new LatLongRect instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns LatLongRect instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.ILatLongRect): google.cloud.vision.v1p1beta1.LatLongRect;

                    /**
                     * Encodes the specified LatLongRect message. Does not implicitly {@link google.cloud.vision.v1p1beta1.LatLongRect.verify|verify} messages.
                     * @param message LatLongRect message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.ILatLongRect, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified LatLongRect message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.LatLongRect.verify|verify} messages.
                     * @param message LatLongRect message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.ILatLongRect, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a LatLongRect message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns LatLongRect
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.LatLongRect;

                    /**
                     * Decodes a LatLongRect message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns LatLongRect
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.LatLongRect;

                    /**
                     * Verifies a LatLongRect message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a LatLongRect message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns LatLongRect
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.LatLongRect;

                    /**
                     * Creates a plain object from a LatLongRect message. Also converts values to other types if specified.
                     * @param message LatLongRect
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.LatLongRect, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this LatLongRect to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for LatLongRect
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ColorInfo. */
                interface IColorInfo {

                    /** ColorInfo color */
                    color?: (google.type.IColor|null);

                    /** ColorInfo score */
                    score?: (number|null);

                    /** ColorInfo pixelFraction */
                    pixelFraction?: (number|null);
                }

                /** Represents a ColorInfo. */
                class ColorInfo implements IColorInfo {

                    /**
                     * Constructs a new ColorInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IColorInfo);

                    /** ColorInfo color. */
                    public color?: (google.type.IColor|null);

                    /** ColorInfo score. */
                    public score: number;

                    /** ColorInfo pixelFraction. */
                    public pixelFraction: number;

                    /**
                     * Creates a new ColorInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ColorInfo instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IColorInfo): google.cloud.vision.v1p1beta1.ColorInfo;

                    /**
                     * Encodes the specified ColorInfo message. Does not implicitly {@link google.cloud.vision.v1p1beta1.ColorInfo.verify|verify} messages.
                     * @param message ColorInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IColorInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ColorInfo message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.ColorInfo.verify|verify} messages.
                     * @param message ColorInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IColorInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ColorInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ColorInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.ColorInfo;

                    /**
                     * Decodes a ColorInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ColorInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.ColorInfo;

                    /**
                     * Verifies a ColorInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ColorInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ColorInfo
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.ColorInfo;

                    /**
                     * Creates a plain object from a ColorInfo message. Also converts values to other types if specified.
                     * @param message ColorInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.ColorInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ColorInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ColorInfo
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DominantColorsAnnotation. */
                interface IDominantColorsAnnotation {

                    /** DominantColorsAnnotation colors */
                    colors?: (google.cloud.vision.v1p1beta1.IColorInfo[]|null);
                }

                /** Represents a DominantColorsAnnotation. */
                class DominantColorsAnnotation implements IDominantColorsAnnotation {

                    /**
                     * Constructs a new DominantColorsAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IDominantColorsAnnotation);

                    /** DominantColorsAnnotation colors. */
                    public colors: google.cloud.vision.v1p1beta1.IColorInfo[];

                    /**
                     * Creates a new DominantColorsAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DominantColorsAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IDominantColorsAnnotation): google.cloud.vision.v1p1beta1.DominantColorsAnnotation;

                    /**
                     * Encodes the specified DominantColorsAnnotation message. Does not implicitly {@link google.cloud.vision.v1p1beta1.DominantColorsAnnotation.verify|verify} messages.
                     * @param message DominantColorsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IDominantColorsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DominantColorsAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.DominantColorsAnnotation.verify|verify} messages.
                     * @param message DominantColorsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IDominantColorsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DominantColorsAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DominantColorsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.DominantColorsAnnotation;

                    /**
                     * Decodes a DominantColorsAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DominantColorsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.DominantColorsAnnotation;

                    /**
                     * Verifies a DominantColorsAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DominantColorsAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DominantColorsAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.DominantColorsAnnotation;

                    /**
                     * Creates a plain object from a DominantColorsAnnotation message. Also converts values to other types if specified.
                     * @param message DominantColorsAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.DominantColorsAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DominantColorsAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DominantColorsAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImageProperties. */
                interface IImageProperties {

                    /** ImageProperties dominantColors */
                    dominantColors?: (google.cloud.vision.v1p1beta1.IDominantColorsAnnotation|null);
                }

                /** Represents an ImageProperties. */
                class ImageProperties implements IImageProperties {

                    /**
                     * Constructs a new ImageProperties.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IImageProperties);

                    /** ImageProperties dominantColors. */
                    public dominantColors?: (google.cloud.vision.v1p1beta1.IDominantColorsAnnotation|null);

                    /**
                     * Creates a new ImageProperties instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageProperties instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IImageProperties): google.cloud.vision.v1p1beta1.ImageProperties;

                    /**
                     * Encodes the specified ImageProperties message. Does not implicitly {@link google.cloud.vision.v1p1beta1.ImageProperties.verify|verify} messages.
                     * @param message ImageProperties message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IImageProperties, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageProperties message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.ImageProperties.verify|verify} messages.
                     * @param message ImageProperties message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IImageProperties, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageProperties message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageProperties
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.ImageProperties;

                    /**
                     * Decodes an ImageProperties message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageProperties
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.ImageProperties;

                    /**
                     * Verifies an ImageProperties message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageProperties message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageProperties
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.ImageProperties;

                    /**
                     * Creates a plain object from an ImageProperties message. Also converts values to other types if specified.
                     * @param message ImageProperties
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.ImageProperties, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageProperties to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageProperties
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CropHint. */
                interface ICropHint {

                    /** CropHint boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** CropHint confidence */
                    confidence?: (number|null);

                    /** CropHint importanceFraction */
                    importanceFraction?: (number|null);
                }

                /** Represents a CropHint. */
                class CropHint implements ICropHint {

                    /**
                     * Constructs a new CropHint.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.ICropHint);

                    /** CropHint boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** CropHint confidence. */
                    public confidence: number;

                    /** CropHint importanceFraction. */
                    public importanceFraction: number;

                    /**
                     * Creates a new CropHint instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CropHint instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.ICropHint): google.cloud.vision.v1p1beta1.CropHint;

                    /**
                     * Encodes the specified CropHint message. Does not implicitly {@link google.cloud.vision.v1p1beta1.CropHint.verify|verify} messages.
                     * @param message CropHint message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.ICropHint, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CropHint message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.CropHint.verify|verify} messages.
                     * @param message CropHint message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.ICropHint, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CropHint message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CropHint
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.CropHint;

                    /**
                     * Decodes a CropHint message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CropHint
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.CropHint;

                    /**
                     * Verifies a CropHint message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CropHint message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CropHint
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.CropHint;

                    /**
                     * Creates a plain object from a CropHint message. Also converts values to other types if specified.
                     * @param message CropHint
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.CropHint, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CropHint to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CropHint
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CropHintsAnnotation. */
                interface ICropHintsAnnotation {

                    /** CropHintsAnnotation cropHints */
                    cropHints?: (google.cloud.vision.v1p1beta1.ICropHint[]|null);
                }

                /** Represents a CropHintsAnnotation. */
                class CropHintsAnnotation implements ICropHintsAnnotation {

                    /**
                     * Constructs a new CropHintsAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.ICropHintsAnnotation);

                    /** CropHintsAnnotation cropHints. */
                    public cropHints: google.cloud.vision.v1p1beta1.ICropHint[];

                    /**
                     * Creates a new CropHintsAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CropHintsAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.ICropHintsAnnotation): google.cloud.vision.v1p1beta1.CropHintsAnnotation;

                    /**
                     * Encodes the specified CropHintsAnnotation message. Does not implicitly {@link google.cloud.vision.v1p1beta1.CropHintsAnnotation.verify|verify} messages.
                     * @param message CropHintsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.ICropHintsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CropHintsAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.CropHintsAnnotation.verify|verify} messages.
                     * @param message CropHintsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.ICropHintsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CropHintsAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CropHintsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.CropHintsAnnotation;

                    /**
                     * Decodes a CropHintsAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CropHintsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.CropHintsAnnotation;

                    /**
                     * Verifies a CropHintsAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CropHintsAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CropHintsAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.CropHintsAnnotation;

                    /**
                     * Creates a plain object from a CropHintsAnnotation message. Also converts values to other types if specified.
                     * @param message CropHintsAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.CropHintsAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CropHintsAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CropHintsAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CropHintsParams. */
                interface ICropHintsParams {

                    /** CropHintsParams aspectRatios */
                    aspectRatios?: (number[]|null);
                }

                /** Represents a CropHintsParams. */
                class CropHintsParams implements ICropHintsParams {

                    /**
                     * Constructs a new CropHintsParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.ICropHintsParams);

                    /** CropHintsParams aspectRatios. */
                    public aspectRatios: number[];

                    /**
                     * Creates a new CropHintsParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CropHintsParams instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.ICropHintsParams): google.cloud.vision.v1p1beta1.CropHintsParams;

                    /**
                     * Encodes the specified CropHintsParams message. Does not implicitly {@link google.cloud.vision.v1p1beta1.CropHintsParams.verify|verify} messages.
                     * @param message CropHintsParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.ICropHintsParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CropHintsParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.CropHintsParams.verify|verify} messages.
                     * @param message CropHintsParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.ICropHintsParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CropHintsParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CropHintsParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.CropHintsParams;

                    /**
                     * Decodes a CropHintsParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CropHintsParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.CropHintsParams;

                    /**
                     * Verifies a CropHintsParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CropHintsParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CropHintsParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.CropHintsParams;

                    /**
                     * Creates a plain object from a CropHintsParams message. Also converts values to other types if specified.
                     * @param message CropHintsParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.CropHintsParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CropHintsParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CropHintsParams
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a WebDetectionParams. */
                interface IWebDetectionParams {

                    /** WebDetectionParams includeGeoResults */
                    includeGeoResults?: (boolean|null);
                }

                /** Represents a WebDetectionParams. */
                class WebDetectionParams implements IWebDetectionParams {

                    /**
                     * Constructs a new WebDetectionParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IWebDetectionParams);

                    /** WebDetectionParams includeGeoResults. */
                    public includeGeoResults: boolean;

                    /**
                     * Creates a new WebDetectionParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns WebDetectionParams instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IWebDetectionParams): google.cloud.vision.v1p1beta1.WebDetectionParams;

                    /**
                     * Encodes the specified WebDetectionParams message. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetectionParams.verify|verify} messages.
                     * @param message WebDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IWebDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified WebDetectionParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetectionParams.verify|verify} messages.
                     * @param message WebDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IWebDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a WebDetectionParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns WebDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.WebDetectionParams;

                    /**
                     * Decodes a WebDetectionParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns WebDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.WebDetectionParams;

                    /**
                     * Verifies a WebDetectionParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a WebDetectionParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns WebDetectionParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.WebDetectionParams;

                    /**
                     * Creates a plain object from a WebDetectionParams message. Also converts values to other types if specified.
                     * @param message WebDetectionParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.WebDetectionParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this WebDetectionParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for WebDetectionParams
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a TextDetectionParams. */
                interface ITextDetectionParams {

                    /** TextDetectionParams enableTextDetectionConfidenceScore */
                    enableTextDetectionConfidenceScore?: (boolean|null);

                    /** TextDetectionParams advancedOcrOptions */
                    advancedOcrOptions?: (string[]|null);
                }

                /** Represents a TextDetectionParams. */
                class TextDetectionParams implements ITextDetectionParams {

                    /**
                     * Constructs a new TextDetectionParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.ITextDetectionParams);

                    /** TextDetectionParams enableTextDetectionConfidenceScore. */
                    public enableTextDetectionConfidenceScore: boolean;

                    /** TextDetectionParams advancedOcrOptions. */
                    public advancedOcrOptions: string[];

                    /**
                     * Creates a new TextDetectionParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TextDetectionParams instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.ITextDetectionParams): google.cloud.vision.v1p1beta1.TextDetectionParams;

                    /**
                     * Encodes the specified TextDetectionParams message. Does not implicitly {@link google.cloud.vision.v1p1beta1.TextDetectionParams.verify|verify} messages.
                     * @param message TextDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.ITextDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TextDetectionParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.TextDetectionParams.verify|verify} messages.
                     * @param message TextDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.ITextDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TextDetectionParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TextDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.TextDetectionParams;

                    /**
                     * Decodes a TextDetectionParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TextDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.TextDetectionParams;

                    /**
                     * Verifies a TextDetectionParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TextDetectionParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TextDetectionParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.TextDetectionParams;

                    /**
                     * Creates a plain object from a TextDetectionParams message. Also converts values to other types if specified.
                     * @param message TextDetectionParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.TextDetectionParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TextDetectionParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for TextDetectionParams
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImageContext. */
                interface IImageContext {

                    /** ImageContext latLongRect */
                    latLongRect?: (google.cloud.vision.v1p1beta1.ILatLongRect|null);

                    /** ImageContext languageHints */
                    languageHints?: (string[]|null);

                    /** ImageContext cropHintsParams */
                    cropHintsParams?: (google.cloud.vision.v1p1beta1.ICropHintsParams|null);

                    /** ImageContext webDetectionParams */
                    webDetectionParams?: (google.cloud.vision.v1p1beta1.IWebDetectionParams|null);

                    /** ImageContext textDetectionParams */
                    textDetectionParams?: (google.cloud.vision.v1p1beta1.ITextDetectionParams|null);
                }

                /** Represents an ImageContext. */
                class ImageContext implements IImageContext {

                    /**
                     * Constructs a new ImageContext.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IImageContext);

                    /** ImageContext latLongRect. */
                    public latLongRect?: (google.cloud.vision.v1p1beta1.ILatLongRect|null);

                    /** ImageContext languageHints. */
                    public languageHints: string[];

                    /** ImageContext cropHintsParams. */
                    public cropHintsParams?: (google.cloud.vision.v1p1beta1.ICropHintsParams|null);

                    /** ImageContext webDetectionParams. */
                    public webDetectionParams?: (google.cloud.vision.v1p1beta1.IWebDetectionParams|null);

                    /** ImageContext textDetectionParams. */
                    public textDetectionParams?: (google.cloud.vision.v1p1beta1.ITextDetectionParams|null);

                    /**
                     * Creates a new ImageContext instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageContext instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IImageContext): google.cloud.vision.v1p1beta1.ImageContext;

                    /**
                     * Encodes the specified ImageContext message. Does not implicitly {@link google.cloud.vision.v1p1beta1.ImageContext.verify|verify} messages.
                     * @param message ImageContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IImageContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageContext message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.ImageContext.verify|verify} messages.
                     * @param message ImageContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IImageContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageContext message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.ImageContext;

                    /**
                     * Decodes an ImageContext message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.ImageContext;

                    /**
                     * Verifies an ImageContext message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageContext message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageContext
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.ImageContext;

                    /**
                     * Creates a plain object from an ImageContext message. Also converts values to other types if specified.
                     * @param message ImageContext
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.ImageContext, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageContext to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageContext
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AnnotateImageRequest. */
                interface IAnnotateImageRequest {

                    /** AnnotateImageRequest image */
                    image?: (google.cloud.vision.v1p1beta1.IImage|null);

                    /** AnnotateImageRequest features */
                    features?: (google.cloud.vision.v1p1beta1.IFeature[]|null);

                    /** AnnotateImageRequest imageContext */
                    imageContext?: (google.cloud.vision.v1p1beta1.IImageContext|null);
                }

                /** Represents an AnnotateImageRequest. */
                class AnnotateImageRequest implements IAnnotateImageRequest {

                    /**
                     * Constructs a new AnnotateImageRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IAnnotateImageRequest);

                    /** AnnotateImageRequest image. */
                    public image?: (google.cloud.vision.v1p1beta1.IImage|null);

                    /** AnnotateImageRequest features. */
                    public features: google.cloud.vision.v1p1beta1.IFeature[];

                    /** AnnotateImageRequest imageContext. */
                    public imageContext?: (google.cloud.vision.v1p1beta1.IImageContext|null);

                    /**
                     * Creates a new AnnotateImageRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnnotateImageRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IAnnotateImageRequest): google.cloud.vision.v1p1beta1.AnnotateImageRequest;

                    /**
                     * Encodes the specified AnnotateImageRequest message. Does not implicitly {@link google.cloud.vision.v1p1beta1.AnnotateImageRequest.verify|verify} messages.
                     * @param message AnnotateImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IAnnotateImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnnotateImageRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.AnnotateImageRequest.verify|verify} messages.
                     * @param message AnnotateImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IAnnotateImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnnotateImageRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnnotateImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.AnnotateImageRequest;

                    /**
                     * Decodes an AnnotateImageRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnnotateImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.AnnotateImageRequest;

                    /**
                     * Verifies an AnnotateImageRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnnotateImageRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnnotateImageRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.AnnotateImageRequest;

                    /**
                     * Creates a plain object from an AnnotateImageRequest message. Also converts values to other types if specified.
                     * @param message AnnotateImageRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.AnnotateImageRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnnotateImageRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AnnotateImageRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AnnotateImageResponse. */
                interface IAnnotateImageResponse {

                    /** AnnotateImageResponse faceAnnotations */
                    faceAnnotations?: (google.cloud.vision.v1p1beta1.IFaceAnnotation[]|null);

                    /** AnnotateImageResponse landmarkAnnotations */
                    landmarkAnnotations?: (google.cloud.vision.v1p1beta1.IEntityAnnotation[]|null);

                    /** AnnotateImageResponse logoAnnotations */
                    logoAnnotations?: (google.cloud.vision.v1p1beta1.IEntityAnnotation[]|null);

                    /** AnnotateImageResponse labelAnnotations */
                    labelAnnotations?: (google.cloud.vision.v1p1beta1.IEntityAnnotation[]|null);

                    /** AnnotateImageResponse textAnnotations */
                    textAnnotations?: (google.cloud.vision.v1p1beta1.IEntityAnnotation[]|null);

                    /** AnnotateImageResponse fullTextAnnotation */
                    fullTextAnnotation?: (google.cloud.vision.v1p1beta1.ITextAnnotation|null);

                    /** AnnotateImageResponse safeSearchAnnotation */
                    safeSearchAnnotation?: (google.cloud.vision.v1p1beta1.ISafeSearchAnnotation|null);

                    /** AnnotateImageResponse imagePropertiesAnnotation */
                    imagePropertiesAnnotation?: (google.cloud.vision.v1p1beta1.IImageProperties|null);

                    /** AnnotateImageResponse cropHintsAnnotation */
                    cropHintsAnnotation?: (google.cloud.vision.v1p1beta1.ICropHintsAnnotation|null);

                    /** AnnotateImageResponse webDetection */
                    webDetection?: (google.cloud.vision.v1p1beta1.IWebDetection|null);

                    /** AnnotateImageResponse error */
                    error?: (google.rpc.IStatus|null);
                }

                /** Represents an AnnotateImageResponse. */
                class AnnotateImageResponse implements IAnnotateImageResponse {

                    /**
                     * Constructs a new AnnotateImageResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IAnnotateImageResponse);

                    /** AnnotateImageResponse faceAnnotations. */
                    public faceAnnotations: google.cloud.vision.v1p1beta1.IFaceAnnotation[];

                    /** AnnotateImageResponse landmarkAnnotations. */
                    public landmarkAnnotations: google.cloud.vision.v1p1beta1.IEntityAnnotation[];

                    /** AnnotateImageResponse logoAnnotations. */
                    public logoAnnotations: google.cloud.vision.v1p1beta1.IEntityAnnotation[];

                    /** AnnotateImageResponse labelAnnotations. */
                    public labelAnnotations: google.cloud.vision.v1p1beta1.IEntityAnnotation[];

                    /** AnnotateImageResponse textAnnotations. */
                    public textAnnotations: google.cloud.vision.v1p1beta1.IEntityAnnotation[];

                    /** AnnotateImageResponse fullTextAnnotation. */
                    public fullTextAnnotation?: (google.cloud.vision.v1p1beta1.ITextAnnotation|null);

                    /** AnnotateImageResponse safeSearchAnnotation. */
                    public safeSearchAnnotation?: (google.cloud.vision.v1p1beta1.ISafeSearchAnnotation|null);

                    /** AnnotateImageResponse imagePropertiesAnnotation. */
                    public imagePropertiesAnnotation?: (google.cloud.vision.v1p1beta1.IImageProperties|null);

                    /** AnnotateImageResponse cropHintsAnnotation. */
                    public cropHintsAnnotation?: (google.cloud.vision.v1p1beta1.ICropHintsAnnotation|null);

                    /** AnnotateImageResponse webDetection. */
                    public webDetection?: (google.cloud.vision.v1p1beta1.IWebDetection|null);

                    /** AnnotateImageResponse error. */
                    public error?: (google.rpc.IStatus|null);

                    /**
                     * Creates a new AnnotateImageResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnnotateImageResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IAnnotateImageResponse): google.cloud.vision.v1p1beta1.AnnotateImageResponse;

                    /**
                     * Encodes the specified AnnotateImageResponse message. Does not implicitly {@link google.cloud.vision.v1p1beta1.AnnotateImageResponse.verify|verify} messages.
                     * @param message AnnotateImageResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IAnnotateImageResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnnotateImageResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.AnnotateImageResponse.verify|verify} messages.
                     * @param message AnnotateImageResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IAnnotateImageResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnnotateImageResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnnotateImageResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.AnnotateImageResponse;

                    /**
                     * Decodes an AnnotateImageResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnnotateImageResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.AnnotateImageResponse;

                    /**
                     * Verifies an AnnotateImageResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnnotateImageResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnnotateImageResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.AnnotateImageResponse;

                    /**
                     * Creates a plain object from an AnnotateImageResponse message. Also converts values to other types if specified.
                     * @param message AnnotateImageResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.AnnotateImageResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnnotateImageResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AnnotateImageResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BatchAnnotateImagesRequest. */
                interface IBatchAnnotateImagesRequest {

                    /** BatchAnnotateImagesRequest requests */
                    requests?: (google.cloud.vision.v1p1beta1.IAnnotateImageRequest[]|null);
                }

                /** Represents a BatchAnnotateImagesRequest. */
                class BatchAnnotateImagesRequest implements IBatchAnnotateImagesRequest {

                    /**
                     * Constructs a new BatchAnnotateImagesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IBatchAnnotateImagesRequest);

                    /** BatchAnnotateImagesRequest requests. */
                    public requests: google.cloud.vision.v1p1beta1.IAnnotateImageRequest[];

                    /**
                     * Creates a new BatchAnnotateImagesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchAnnotateImagesRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IBatchAnnotateImagesRequest): google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest;

                    /**
                     * Encodes the specified BatchAnnotateImagesRequest message. Does not implicitly {@link google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest.verify|verify} messages.
                     * @param message BatchAnnotateImagesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IBatchAnnotateImagesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchAnnotateImagesRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest.verify|verify} messages.
                     * @param message BatchAnnotateImagesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IBatchAnnotateImagesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchAnnotateImagesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchAnnotateImagesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest;

                    /**
                     * Decodes a BatchAnnotateImagesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchAnnotateImagesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest;

                    /**
                     * Verifies a BatchAnnotateImagesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchAnnotateImagesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchAnnotateImagesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest;

                    /**
                     * Creates a plain object from a BatchAnnotateImagesRequest message. Also converts values to other types if specified.
                     * @param message BatchAnnotateImagesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchAnnotateImagesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BatchAnnotateImagesRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BatchAnnotateImagesResponse. */
                interface IBatchAnnotateImagesResponse {

                    /** BatchAnnotateImagesResponse responses */
                    responses?: (google.cloud.vision.v1p1beta1.IAnnotateImageResponse[]|null);
                }

                /** Represents a BatchAnnotateImagesResponse. */
                class BatchAnnotateImagesResponse implements IBatchAnnotateImagesResponse {

                    /**
                     * Constructs a new BatchAnnotateImagesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IBatchAnnotateImagesResponse);

                    /** BatchAnnotateImagesResponse responses. */
                    public responses: google.cloud.vision.v1p1beta1.IAnnotateImageResponse[];

                    /**
                     * Creates a new BatchAnnotateImagesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchAnnotateImagesResponse instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IBatchAnnotateImagesResponse): google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse;

                    /**
                     * Encodes the specified BatchAnnotateImagesResponse message. Does not implicitly {@link google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse.verify|verify} messages.
                     * @param message BatchAnnotateImagesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IBatchAnnotateImagesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchAnnotateImagesResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse.verify|verify} messages.
                     * @param message BatchAnnotateImagesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IBatchAnnotateImagesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchAnnotateImagesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchAnnotateImagesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse;

                    /**
                     * Decodes a BatchAnnotateImagesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchAnnotateImagesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse;

                    /**
                     * Verifies a BatchAnnotateImagesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchAnnotateImagesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchAnnotateImagesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse;

                    /**
                     * Creates a plain object from a BatchAnnotateImagesResponse message. Also converts values to other types if specified.
                     * @param message BatchAnnotateImagesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchAnnotateImagesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BatchAnnotateImagesResponse
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Likelihood enum. */
                enum Likelihood {
                    UNKNOWN = 0,
                    VERY_UNLIKELY = 1,
                    UNLIKELY = 2,
                    POSSIBLE = 3,
                    LIKELY = 4,
                    VERY_LIKELY = 5
                }

                /** Properties of a TextAnnotation. */
                interface ITextAnnotation {

                    /** TextAnnotation pages */
                    pages?: (google.cloud.vision.v1p1beta1.IPage[]|null);

                    /** TextAnnotation text */
                    text?: (string|null);
                }

                /** Represents a TextAnnotation. */
                class TextAnnotation implements ITextAnnotation {

                    /**
                     * Constructs a new TextAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.ITextAnnotation);

                    /** TextAnnotation pages. */
                    public pages: google.cloud.vision.v1p1beta1.IPage[];

                    /** TextAnnotation text. */
                    public text: string;

                    /**
                     * Creates a new TextAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TextAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.ITextAnnotation): google.cloud.vision.v1p1beta1.TextAnnotation;

                    /**
                     * Encodes the specified TextAnnotation message. Does not implicitly {@link google.cloud.vision.v1p1beta1.TextAnnotation.verify|verify} messages.
                     * @param message TextAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.ITextAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TextAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.TextAnnotation.verify|verify} messages.
                     * @param message TextAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.ITextAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TextAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TextAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.TextAnnotation;

                    /**
                     * Decodes a TextAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TextAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.TextAnnotation;

                    /**
                     * Verifies a TextAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TextAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TextAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.TextAnnotation;

                    /**
                     * Creates a plain object from a TextAnnotation message. Also converts values to other types if specified.
                     * @param message TextAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.TextAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TextAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for TextAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace TextAnnotation {

                    /** Properties of a DetectedLanguage. */
                    interface IDetectedLanguage {

                        /** DetectedLanguage languageCode */
                        languageCode?: (string|null);

                        /** DetectedLanguage confidence */
                        confidence?: (number|null);
                    }

                    /** Represents a DetectedLanguage. */
                    class DetectedLanguage implements IDetectedLanguage {

                        /**
                         * Constructs a new DetectedLanguage.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedLanguage);

                        /** DetectedLanguage languageCode. */
                        public languageCode: string;

                        /** DetectedLanguage confidence. */
                        public confidence: number;

                        /**
                         * Creates a new DetectedLanguage instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DetectedLanguage instance
                         */
                        public static create(properties?: google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedLanguage): google.cloud.vision.v1p1beta1.TextAnnotation.DetectedLanguage;

                        /**
                         * Encodes the specified DetectedLanguage message. Does not implicitly {@link google.cloud.vision.v1p1beta1.TextAnnotation.DetectedLanguage.verify|verify} messages.
                         * @param message DetectedLanguage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedLanguage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DetectedLanguage message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.TextAnnotation.DetectedLanguage.verify|verify} messages.
                         * @param message DetectedLanguage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedLanguage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DetectedLanguage message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DetectedLanguage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.TextAnnotation.DetectedLanguage;

                        /**
                         * Decodes a DetectedLanguage message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DetectedLanguage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.TextAnnotation.DetectedLanguage;

                        /**
                         * Verifies a DetectedLanguage message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DetectedLanguage message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DetectedLanguage
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.TextAnnotation.DetectedLanguage;

                        /**
                         * Creates a plain object from a DetectedLanguage message. Also converts values to other types if specified.
                         * @param message DetectedLanguage
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1p1beta1.TextAnnotation.DetectedLanguage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DetectedLanguage to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for DetectedLanguage
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a DetectedBreak. */
                    interface IDetectedBreak {

                        /** DetectedBreak type */
                        type?: (google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak.BreakType|keyof typeof google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak.BreakType|null);

                        /** DetectedBreak isPrefix */
                        isPrefix?: (boolean|null);
                    }

                    /** Represents a DetectedBreak. */
                    class DetectedBreak implements IDetectedBreak {

                        /**
                         * Constructs a new DetectedBreak.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedBreak);

                        /** DetectedBreak type. */
                        public type: (google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak.BreakType|keyof typeof google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak.BreakType);

                        /** DetectedBreak isPrefix. */
                        public isPrefix: boolean;

                        /**
                         * Creates a new DetectedBreak instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DetectedBreak instance
                         */
                        public static create(properties?: google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedBreak): google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak;

                        /**
                         * Encodes the specified DetectedBreak message. Does not implicitly {@link google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak.verify|verify} messages.
                         * @param message DetectedBreak message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedBreak, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DetectedBreak message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak.verify|verify} messages.
                         * @param message DetectedBreak message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedBreak, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DetectedBreak message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DetectedBreak
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak;

                        /**
                         * Decodes a DetectedBreak message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DetectedBreak
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak;

                        /**
                         * Verifies a DetectedBreak message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DetectedBreak message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DetectedBreak
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak;

                        /**
                         * Creates a plain object from a DetectedBreak message. Also converts values to other types if specified.
                         * @param message DetectedBreak
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1p1beta1.TextAnnotation.DetectedBreak, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DetectedBreak to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for DetectedBreak
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace DetectedBreak {

                        /** BreakType enum. */
                        enum BreakType {
                            UNKNOWN = 0,
                            SPACE = 1,
                            SURE_SPACE = 2,
                            EOL_SURE_SPACE = 3,
                            HYPHEN = 4,
                            LINE_BREAK = 5
                        }
                    }

                    /** Properties of a TextProperty. */
                    interface ITextProperty {

                        /** TextProperty detectedLanguages */
                        detectedLanguages?: (google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedLanguage[]|null);

                        /** TextProperty detectedBreak */
                        detectedBreak?: (google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedBreak|null);
                    }

                    /** Represents a TextProperty. */
                    class TextProperty implements ITextProperty {

                        /**
                         * Constructs a new TextProperty.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty);

                        /** TextProperty detectedLanguages. */
                        public detectedLanguages: google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedLanguage[];

                        /** TextProperty detectedBreak. */
                        public detectedBreak?: (google.cloud.vision.v1p1beta1.TextAnnotation.IDetectedBreak|null);

                        /**
                         * Creates a new TextProperty instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TextProperty instance
                         */
                        public static create(properties?: google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty): google.cloud.vision.v1p1beta1.TextAnnotation.TextProperty;

                        /**
                         * Encodes the specified TextProperty message. Does not implicitly {@link google.cloud.vision.v1p1beta1.TextAnnotation.TextProperty.verify|verify} messages.
                         * @param message TextProperty message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TextProperty message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.TextAnnotation.TextProperty.verify|verify} messages.
                         * @param message TextProperty message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TextProperty message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TextProperty
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.TextAnnotation.TextProperty;

                        /**
                         * Decodes a TextProperty message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TextProperty
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.TextAnnotation.TextProperty;

                        /**
                         * Verifies a TextProperty message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TextProperty message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TextProperty
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.TextAnnotation.TextProperty;

                        /**
                         * Creates a plain object from a TextProperty message. Also converts values to other types if specified.
                         * @param message TextProperty
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1p1beta1.TextAnnotation.TextProperty, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TextProperty to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for TextProperty
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }

                /** Properties of a Page. */
                interface IPage {

                    /** Page property */
                    property?: (google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty|null);

                    /** Page width */
                    width?: (number|null);

                    /** Page height */
                    height?: (number|null);

                    /** Page blocks */
                    blocks?: (google.cloud.vision.v1p1beta1.IBlock[]|null);

                    /** Page confidence */
                    confidence?: (number|null);
                }

                /** Represents a Page. */
                class Page implements IPage {

                    /**
                     * Constructs a new Page.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IPage);

                    /** Page property. */
                    public property?: (google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty|null);

                    /** Page width. */
                    public width: number;

                    /** Page height. */
                    public height: number;

                    /** Page blocks. */
                    public blocks: google.cloud.vision.v1p1beta1.IBlock[];

                    /** Page confidence. */
                    public confidence: number;

                    /**
                     * Creates a new Page instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Page instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IPage): google.cloud.vision.v1p1beta1.Page;

                    /**
                     * Encodes the specified Page message. Does not implicitly {@link google.cloud.vision.v1p1beta1.Page.verify|verify} messages.
                     * @param message Page message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IPage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Page message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.Page.verify|verify} messages.
                     * @param message Page message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IPage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Page message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Page
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.Page;

                    /**
                     * Decodes a Page message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Page
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.Page;

                    /**
                     * Verifies a Page message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Page message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Page
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.Page;

                    /**
                     * Creates a plain object from a Page message. Also converts values to other types if specified.
                     * @param message Page
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.Page, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Page to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Page
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Block. */
                interface IBlock {

                    /** Block property */
                    property?: (google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty|null);

                    /** Block boundingBox */
                    boundingBox?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** Block paragraphs */
                    paragraphs?: (google.cloud.vision.v1p1beta1.IParagraph[]|null);

                    /** Block blockType */
                    blockType?: (google.cloud.vision.v1p1beta1.Block.BlockType|keyof typeof google.cloud.vision.v1p1beta1.Block.BlockType|null);

                    /** Block confidence */
                    confidence?: (number|null);
                }

                /** Represents a Block. */
                class Block implements IBlock {

                    /**
                     * Constructs a new Block.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IBlock);

                    /** Block property. */
                    public property?: (google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty|null);

                    /** Block boundingBox. */
                    public boundingBox?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** Block paragraphs. */
                    public paragraphs: google.cloud.vision.v1p1beta1.IParagraph[];

                    /** Block blockType. */
                    public blockType: (google.cloud.vision.v1p1beta1.Block.BlockType|keyof typeof google.cloud.vision.v1p1beta1.Block.BlockType);

                    /** Block confidence. */
                    public confidence: number;

                    /**
                     * Creates a new Block instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Block instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IBlock): google.cloud.vision.v1p1beta1.Block;

                    /**
                     * Encodes the specified Block message. Does not implicitly {@link google.cloud.vision.v1p1beta1.Block.verify|verify} messages.
                     * @param message Block message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IBlock, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Block message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.Block.verify|verify} messages.
                     * @param message Block message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IBlock, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Block message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Block
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.Block;

                    /**
                     * Decodes a Block message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Block
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.Block;

                    /**
                     * Verifies a Block message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Block message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Block
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.Block;

                    /**
                     * Creates a plain object from a Block message. Also converts values to other types if specified.
                     * @param message Block
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.Block, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Block to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Block
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace Block {

                    /** BlockType enum. */
                    enum BlockType {
                        UNKNOWN = 0,
                        TEXT = 1,
                        TABLE = 2,
                        PICTURE = 3,
                        RULER = 4,
                        BARCODE = 5
                    }
                }

                /** Properties of a Paragraph. */
                interface IParagraph {

                    /** Paragraph property */
                    property?: (google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty|null);

                    /** Paragraph boundingBox */
                    boundingBox?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** Paragraph words */
                    words?: (google.cloud.vision.v1p1beta1.IWord[]|null);

                    /** Paragraph confidence */
                    confidence?: (number|null);
                }

                /** Represents a Paragraph. */
                class Paragraph implements IParagraph {

                    /**
                     * Constructs a new Paragraph.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IParagraph);

                    /** Paragraph property. */
                    public property?: (google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty|null);

                    /** Paragraph boundingBox. */
                    public boundingBox?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** Paragraph words. */
                    public words: google.cloud.vision.v1p1beta1.IWord[];

                    /** Paragraph confidence. */
                    public confidence: number;

                    /**
                     * Creates a new Paragraph instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Paragraph instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IParagraph): google.cloud.vision.v1p1beta1.Paragraph;

                    /**
                     * Encodes the specified Paragraph message. Does not implicitly {@link google.cloud.vision.v1p1beta1.Paragraph.verify|verify} messages.
                     * @param message Paragraph message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IParagraph, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Paragraph message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.Paragraph.verify|verify} messages.
                     * @param message Paragraph message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IParagraph, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Paragraph message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Paragraph
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.Paragraph;

                    /**
                     * Decodes a Paragraph message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Paragraph
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.Paragraph;

                    /**
                     * Verifies a Paragraph message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Paragraph message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Paragraph
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.Paragraph;

                    /**
                     * Creates a plain object from a Paragraph message. Also converts values to other types if specified.
                     * @param message Paragraph
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.Paragraph, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Paragraph to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Paragraph
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Word. */
                interface IWord {

                    /** Word property */
                    property?: (google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty|null);

                    /** Word boundingBox */
                    boundingBox?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** Word symbols */
                    symbols?: (google.cloud.vision.v1p1beta1.ISymbol[]|null);

                    /** Word confidence */
                    confidence?: (number|null);
                }

                /** Represents a Word. */
                class Word implements IWord {

                    /**
                     * Constructs a new Word.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IWord);

                    /** Word property. */
                    public property?: (google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty|null);

                    /** Word boundingBox. */
                    public boundingBox?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** Word symbols. */
                    public symbols: google.cloud.vision.v1p1beta1.ISymbol[];

                    /** Word confidence. */
                    public confidence: number;

                    /**
                     * Creates a new Word instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Word instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IWord): google.cloud.vision.v1p1beta1.Word;

                    /**
                     * Encodes the specified Word message. Does not implicitly {@link google.cloud.vision.v1p1beta1.Word.verify|verify} messages.
                     * @param message Word message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IWord, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Word message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.Word.verify|verify} messages.
                     * @param message Word message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IWord, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Word message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Word
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.Word;

                    /**
                     * Decodes a Word message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Word
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.Word;

                    /**
                     * Verifies a Word message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Word message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Word
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.Word;

                    /**
                     * Creates a plain object from a Word message. Also converts values to other types if specified.
                     * @param message Word
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.Word, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Word to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Word
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Symbol. */
                interface ISymbol {

                    /** Symbol property */
                    property?: (google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty|null);

                    /** Symbol boundingBox */
                    boundingBox?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** Symbol text */
                    text?: (string|null);

                    /** Symbol confidence */
                    confidence?: (number|null);
                }

                /** Represents a Symbol. */
                class Symbol implements ISymbol {

                    /**
                     * Constructs a new Symbol.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.ISymbol);

                    /** Symbol property. */
                    public property?: (google.cloud.vision.v1p1beta1.TextAnnotation.ITextProperty|null);

                    /** Symbol boundingBox. */
                    public boundingBox?: (google.cloud.vision.v1p1beta1.IBoundingPoly|null);

                    /** Symbol text. */
                    public text: string;

                    /** Symbol confidence. */
                    public confidence: number;

                    /**
                     * Creates a new Symbol instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Symbol instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.ISymbol): google.cloud.vision.v1p1beta1.Symbol;

                    /**
                     * Encodes the specified Symbol message. Does not implicitly {@link google.cloud.vision.v1p1beta1.Symbol.verify|verify} messages.
                     * @param message Symbol message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.ISymbol, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Symbol message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.Symbol.verify|verify} messages.
                     * @param message Symbol message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.ISymbol, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Symbol message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Symbol
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.Symbol;

                    /**
                     * Decodes a Symbol message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Symbol
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.Symbol;

                    /**
                     * Verifies a Symbol message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Symbol message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Symbol
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.Symbol;

                    /**
                     * Creates a plain object from a Symbol message. Also converts values to other types if specified.
                     * @param message Symbol
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.Symbol, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Symbol to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Symbol
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a WebDetection. */
                interface IWebDetection {

                    /** WebDetection webEntities */
                    webEntities?: (google.cloud.vision.v1p1beta1.WebDetection.IWebEntity[]|null);

                    /** WebDetection fullMatchingImages */
                    fullMatchingImages?: (google.cloud.vision.v1p1beta1.WebDetection.IWebImage[]|null);

                    /** WebDetection partialMatchingImages */
                    partialMatchingImages?: (google.cloud.vision.v1p1beta1.WebDetection.IWebImage[]|null);

                    /** WebDetection pagesWithMatchingImages */
                    pagesWithMatchingImages?: (google.cloud.vision.v1p1beta1.WebDetection.IWebPage[]|null);

                    /** WebDetection visuallySimilarImages */
                    visuallySimilarImages?: (google.cloud.vision.v1p1beta1.WebDetection.IWebImage[]|null);

                    /** WebDetection bestGuessLabels */
                    bestGuessLabels?: (google.cloud.vision.v1p1beta1.WebDetection.IWebLabel[]|null);
                }

                /** Represents a WebDetection. */
                class WebDetection implements IWebDetection {

                    /**
                     * Constructs a new WebDetection.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p1beta1.IWebDetection);

                    /** WebDetection webEntities. */
                    public webEntities: google.cloud.vision.v1p1beta1.WebDetection.IWebEntity[];

                    /** WebDetection fullMatchingImages. */
                    public fullMatchingImages: google.cloud.vision.v1p1beta1.WebDetection.IWebImage[];

                    /** WebDetection partialMatchingImages. */
                    public partialMatchingImages: google.cloud.vision.v1p1beta1.WebDetection.IWebImage[];

                    /** WebDetection pagesWithMatchingImages. */
                    public pagesWithMatchingImages: google.cloud.vision.v1p1beta1.WebDetection.IWebPage[];

                    /** WebDetection visuallySimilarImages. */
                    public visuallySimilarImages: google.cloud.vision.v1p1beta1.WebDetection.IWebImage[];

                    /** WebDetection bestGuessLabels. */
                    public bestGuessLabels: google.cloud.vision.v1p1beta1.WebDetection.IWebLabel[];

                    /**
                     * Creates a new WebDetection instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns WebDetection instance
                     */
                    public static create(properties?: google.cloud.vision.v1p1beta1.IWebDetection): google.cloud.vision.v1p1beta1.WebDetection;

                    /**
                     * Encodes the specified WebDetection message. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetection.verify|verify} messages.
                     * @param message WebDetection message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p1beta1.IWebDetection, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified WebDetection message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetection.verify|verify} messages.
                     * @param message WebDetection message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p1beta1.IWebDetection, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a WebDetection message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns WebDetection
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.WebDetection;

                    /**
                     * Decodes a WebDetection message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns WebDetection
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.WebDetection;

                    /**
                     * Verifies a WebDetection message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a WebDetection message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns WebDetection
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.WebDetection;

                    /**
                     * Creates a plain object from a WebDetection message. Also converts values to other types if specified.
                     * @param message WebDetection
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p1beta1.WebDetection, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this WebDetection to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for WebDetection
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace WebDetection {

                    /** Properties of a WebEntity. */
                    interface IWebEntity {

                        /** WebEntity entityId */
                        entityId?: (string|null);

                        /** WebEntity score */
                        score?: (number|null);

                        /** WebEntity description */
                        description?: (string|null);
                    }

                    /** Represents a WebEntity. */
                    class WebEntity implements IWebEntity {

                        /**
                         * Constructs a new WebEntity.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1p1beta1.WebDetection.IWebEntity);

                        /** WebEntity entityId. */
                        public entityId: string;

                        /** WebEntity score. */
                        public score: number;

                        /** WebEntity description. */
                        public description: string;

                        /**
                         * Creates a new WebEntity instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns WebEntity instance
                         */
                        public static create(properties?: google.cloud.vision.v1p1beta1.WebDetection.IWebEntity): google.cloud.vision.v1p1beta1.WebDetection.WebEntity;

                        /**
                         * Encodes the specified WebEntity message. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetection.WebEntity.verify|verify} messages.
                         * @param message WebEntity message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1p1beta1.WebDetection.IWebEntity, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified WebEntity message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetection.WebEntity.verify|verify} messages.
                         * @param message WebEntity message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1p1beta1.WebDetection.IWebEntity, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a WebEntity message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns WebEntity
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.WebDetection.WebEntity;

                        /**
                         * Decodes a WebEntity message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns WebEntity
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.WebDetection.WebEntity;

                        /**
                         * Verifies a WebEntity message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a WebEntity message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns WebEntity
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.WebDetection.WebEntity;

                        /**
                         * Creates a plain object from a WebEntity message. Also converts values to other types if specified.
                         * @param message WebEntity
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1p1beta1.WebDetection.WebEntity, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this WebEntity to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for WebEntity
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a WebImage. */
                    interface IWebImage {

                        /** WebImage url */
                        url?: (string|null);

                        /** WebImage score */
                        score?: (number|null);
                    }

                    /** Represents a WebImage. */
                    class WebImage implements IWebImage {

                        /**
                         * Constructs a new WebImage.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1p1beta1.WebDetection.IWebImage);

                        /** WebImage url. */
                        public url: string;

                        /** WebImage score. */
                        public score: number;

                        /**
                         * Creates a new WebImage instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns WebImage instance
                         */
                        public static create(properties?: google.cloud.vision.v1p1beta1.WebDetection.IWebImage): google.cloud.vision.v1p1beta1.WebDetection.WebImage;

                        /**
                         * Encodes the specified WebImage message. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetection.WebImage.verify|verify} messages.
                         * @param message WebImage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1p1beta1.WebDetection.IWebImage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified WebImage message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetection.WebImage.verify|verify} messages.
                         * @param message WebImage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1p1beta1.WebDetection.IWebImage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a WebImage message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns WebImage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.WebDetection.WebImage;

                        /**
                         * Decodes a WebImage message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns WebImage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.WebDetection.WebImage;

                        /**
                         * Verifies a WebImage message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a WebImage message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns WebImage
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.WebDetection.WebImage;

                        /**
                         * Creates a plain object from a WebImage message. Also converts values to other types if specified.
                         * @param message WebImage
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1p1beta1.WebDetection.WebImage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this WebImage to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for WebImage
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a WebPage. */
                    interface IWebPage {

                        /** WebPage url */
                        url?: (string|null);

                        /** WebPage score */
                        score?: (number|null);

                        /** WebPage pageTitle */
                        pageTitle?: (string|null);

                        /** WebPage fullMatchingImages */
                        fullMatchingImages?: (google.cloud.vision.v1p1beta1.WebDetection.IWebImage[]|null);

                        /** WebPage partialMatchingImages */
                        partialMatchingImages?: (google.cloud.vision.v1p1beta1.WebDetection.IWebImage[]|null);
                    }

                    /** Represents a WebPage. */
                    class WebPage implements IWebPage {

                        /**
                         * Constructs a new WebPage.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1p1beta1.WebDetection.IWebPage);

                        /** WebPage url. */
                        public url: string;

                        /** WebPage score. */
                        public score: number;

                        /** WebPage pageTitle. */
                        public pageTitle: string;

                        /** WebPage fullMatchingImages. */
                        public fullMatchingImages: google.cloud.vision.v1p1beta1.WebDetection.IWebImage[];

                        /** WebPage partialMatchingImages. */
                        public partialMatchingImages: google.cloud.vision.v1p1beta1.WebDetection.IWebImage[];

                        /**
                         * Creates a new WebPage instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns WebPage instance
                         */
                        public static create(properties?: google.cloud.vision.v1p1beta1.WebDetection.IWebPage): google.cloud.vision.v1p1beta1.WebDetection.WebPage;

                        /**
                         * Encodes the specified WebPage message. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetection.WebPage.verify|verify} messages.
                         * @param message WebPage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1p1beta1.WebDetection.IWebPage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified WebPage message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetection.WebPage.verify|verify} messages.
                         * @param message WebPage message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1p1beta1.WebDetection.IWebPage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a WebPage message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns WebPage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.WebDetection.WebPage;

                        /**
                         * Decodes a WebPage message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns WebPage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.WebDetection.WebPage;

                        /**
                         * Verifies a WebPage message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a WebPage message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns WebPage
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.WebDetection.WebPage;

                        /**
                         * Creates a plain object from a WebPage message. Also converts values to other types if specified.
                         * @param message WebPage
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1p1beta1.WebDetection.WebPage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this WebPage to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for WebPage
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    /** Properties of a WebLabel. */
                    interface IWebLabel {

                        /** WebLabel label */
                        label?: (string|null);

                        /** WebLabel languageCode */
                        languageCode?: (string|null);
                    }

                    /** Represents a WebLabel. */
                    class WebLabel implements IWebLabel {

                        /**
                         * Constructs a new WebLabel.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1p1beta1.WebDetection.IWebLabel);

                        /** WebLabel label. */
                        public label: string;

                        /** WebLabel languageCode. */
                        public languageCode: string;

                        /**
                         * Creates a new WebLabel instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns WebLabel instance
                         */
                        public static create(properties?: google.cloud.vision.v1p1beta1.WebDetection.IWebLabel): google.cloud.vision.v1p1beta1.WebDetection.WebLabel;

                        /**
                         * Encodes the specified WebLabel message. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetection.WebLabel.verify|verify} messages.
                         * @param message WebLabel message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1p1beta1.WebDetection.IWebLabel, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified WebLabel message, length delimited. Does not implicitly {@link google.cloud.vision.v1p1beta1.WebDetection.WebLabel.verify|verify} messages.
                         * @param message WebLabel message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1p1beta1.WebDetection.IWebLabel, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a WebLabel message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns WebLabel
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p1beta1.WebDetection.WebLabel;

                        /**
                         * Decodes a WebLabel message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns WebLabel
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p1beta1.WebDetection.WebLabel;

                        /**
                         * Verifies a WebLabel message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a WebLabel message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns WebLabel
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p1beta1.WebDetection.WebLabel;

                        /**
                         * Creates a plain object from a WebLabel message. Also converts values to other types if specified.
                         * @param message WebLabel
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1p1beta1.WebDetection.WebLabel, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this WebLabel to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for WebLabel
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }
                }
            }

            /** Namespace v1p2beta1. */
            namespace v1p2beta1 {

                /** Properties of a Vertex. */
                interface IVertex {

                    /** Vertex x */
                    x?: (number|null);

                    /** Vertex y */
                    y?: (number|null);
                }

                /** Represents a Vertex. */
                class Vertex implements IVertex {

                    /**
                     * Constructs a new Vertex.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IVertex);

                    /** Vertex x. */
                    public x: number;

                    /** Vertex y. */
                    public y: number;

                    /**
                     * Creates a new Vertex instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Vertex instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IVertex): google.cloud.vision.v1p2beta1.Vertex;

                    /**
                     * Encodes the specified Vertex message. Does not implicitly {@link google.cloud.vision.v1p2beta1.Vertex.verify|verify} messages.
                     * @param message Vertex message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IVertex, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Vertex message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.Vertex.verify|verify} messages.
                     * @param message Vertex message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IVertex, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Vertex message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Vertex
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.Vertex;

                    /**
                     * Decodes a Vertex message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Vertex
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.Vertex;

                    /**
                     * Verifies a Vertex message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Vertex message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Vertex
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.Vertex;

                    /**
                     * Creates a plain object from a Vertex message. Also converts values to other types if specified.
                     * @param message Vertex
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.Vertex, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Vertex to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Vertex
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a NormalizedVertex. */
                interface INormalizedVertex {

                    /** NormalizedVertex x */
                    x?: (number|null);

                    /** NormalizedVertex y */
                    y?: (number|null);
                }

                /** Represents a NormalizedVertex. */
                class NormalizedVertex implements INormalizedVertex {

                    /**
                     * Constructs a new NormalizedVertex.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.INormalizedVertex);

                    /** NormalizedVertex x. */
                    public x: number;

                    /** NormalizedVertex y. */
                    public y: number;

                    /**
                     * Creates a new NormalizedVertex instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns NormalizedVertex instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.INormalizedVertex): google.cloud.vision.v1p2beta1.NormalizedVertex;

                    /**
                     * Encodes the specified NormalizedVertex message. Does not implicitly {@link google.cloud.vision.v1p2beta1.NormalizedVertex.verify|verify} messages.
                     * @param message NormalizedVertex message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.INormalizedVertex, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified NormalizedVertex message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.NormalizedVertex.verify|verify} messages.
                     * @param message NormalizedVertex message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.INormalizedVertex, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a NormalizedVertex message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns NormalizedVertex
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.NormalizedVertex;

                    /**
                     * Decodes a NormalizedVertex message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns NormalizedVertex
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.NormalizedVertex;

                    /**
                     * Verifies a NormalizedVertex message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a NormalizedVertex message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns NormalizedVertex
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.NormalizedVertex;

                    /**
                     * Creates a plain object from a NormalizedVertex message. Also converts values to other types if specified.
                     * @param message NormalizedVertex
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.NormalizedVertex, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this NormalizedVertex to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for NormalizedVertex
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a BoundingPoly. */
                interface IBoundingPoly {

                    /** BoundingPoly vertices */
                    vertices?: (google.cloud.vision.v1p2beta1.IVertex[]|null);

                    /** BoundingPoly normalizedVertices */
                    normalizedVertices?: (google.cloud.vision.v1p2beta1.INormalizedVertex[]|null);
                }

                /** Represents a BoundingPoly. */
                class BoundingPoly implements IBoundingPoly {

                    /**
                     * Constructs a new BoundingPoly.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IBoundingPoly);

                    /** BoundingPoly vertices. */
                    public vertices: google.cloud.vision.v1p2beta1.IVertex[];

                    /** BoundingPoly normalizedVertices. */
                    public normalizedVertices: google.cloud.vision.v1p2beta1.INormalizedVertex[];

                    /**
                     * Creates a new BoundingPoly instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BoundingPoly instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IBoundingPoly): google.cloud.vision.v1p2beta1.BoundingPoly;

                    /**
                     * Encodes the specified BoundingPoly message. Does not implicitly {@link google.cloud.vision.v1p2beta1.BoundingPoly.verify|verify} messages.
                     * @param message BoundingPoly message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IBoundingPoly, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BoundingPoly message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.BoundingPoly.verify|verify} messages.
                     * @param message BoundingPoly message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IBoundingPoly, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BoundingPoly message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BoundingPoly
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.BoundingPoly;

                    /**
                     * Decodes a BoundingPoly message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BoundingPoly
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.BoundingPoly;

                    /**
                     * Verifies a BoundingPoly message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BoundingPoly message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BoundingPoly
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.BoundingPoly;

                    /**
                     * Creates a plain object from a BoundingPoly message. Also converts values to other types if specified.
                     * @param message BoundingPoly
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.BoundingPoly, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BoundingPoly to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for BoundingPoly
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Position. */
                interface IPosition {

                    /** Position x */
                    x?: (number|null);

                    /** Position y */
                    y?: (number|null);

                    /** Position z */
                    z?: (number|null);
                }

                /** Represents a Position. */
                class Position implements IPosition {

                    /**
                     * Constructs a new Position.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IPosition);

                    /** Position x. */
                    public x: number;

                    /** Position y. */
                    public y: number;

                    /** Position z. */
                    public z: number;

                    /**
                     * Creates a new Position instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Position instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IPosition): google.cloud.vision.v1p2beta1.Position;

                    /**
                     * Encodes the specified Position message. Does not implicitly {@link google.cloud.vision.v1p2beta1.Position.verify|verify} messages.
                     * @param message Position message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IPosition, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Position message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.Position.verify|verify} messages.
                     * @param message Position message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IPosition, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Position message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Position
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.Position;

                    /**
                     * Decodes a Position message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Position
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.Position;

                    /**
                     * Verifies a Position message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Position message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Position
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.Position;

                    /**
                     * Creates a plain object from a Position message. Also converts values to other types if specified.
                     * @param message Position
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.Position, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Position to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Position
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Represents an ImageAnnotator */
                class ImageAnnotator extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new ImageAnnotator service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new ImageAnnotator service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): ImageAnnotator;

                    /**
                     * Calls BatchAnnotateImages.
                     * @param request BatchAnnotateImagesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and BatchAnnotateImagesResponse
                     */
                    public batchAnnotateImages(request: google.cloud.vision.v1p2beta1.IBatchAnnotateImagesRequest, callback: google.cloud.vision.v1p2beta1.ImageAnnotator.BatchAnnotateImagesCallback): void;

                    /**
                     * Calls BatchAnnotateImages.
                     * @param request BatchAnnotateImagesRequest message or plain object
                     * @returns Promise
                     */
                    public batchAnnotateImages(request: google.cloud.vision.v1p2beta1.IBatchAnnotateImagesRequest): Promise<google.cloud.vision.v1p2beta1.BatchAnnotateImagesResponse>;

                    /**
                     * Calls AsyncBatchAnnotateFiles.
                     * @param request AsyncBatchAnnotateFilesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public asyncBatchAnnotateFiles(request: google.cloud.vision.v1p2beta1.IAsyncBatchAnnotateFilesRequest, callback: google.cloud.vision.v1p2beta1.ImageAnnotator.AsyncBatchAnnotateFilesCallback): void;

                    /**
                     * Calls AsyncBatchAnnotateFiles.
                     * @param request AsyncBatchAnnotateFilesRequest message or plain object
                     * @returns Promise
                     */
                    public asyncBatchAnnotateFiles(request: google.cloud.vision.v1p2beta1.IAsyncBatchAnnotateFilesRequest): Promise<google.longrunning.Operation>;
                }

                namespace ImageAnnotator {

                    /**
                     * Callback as used by {@link google.cloud.vision.v1p2beta1.ImageAnnotator|batchAnnotateImages}.
                     * @param error Error, if any
                     * @param [response] BatchAnnotateImagesResponse
                     */
                    type BatchAnnotateImagesCallback = (error: (Error|null), response?: google.cloud.vision.v1p2beta1.BatchAnnotateImagesResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.vision.v1p2beta1.ImageAnnotator|asyncBatchAnnotateFiles}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type AsyncBatchAnnotateFilesCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;
                }

                /** Properties of a Feature. */
                interface IFeature {

                    /** Feature type */
                    type?: (google.cloud.vision.v1p2beta1.Feature.Type|keyof typeof google.cloud.vision.v1p2beta1.Feature.Type|null);

                    /** Feature maxResults */
                    maxResults?: (number|null);

                    /** Feature model */
                    model?: (string|null);
                }

                /** Represents a Feature. */
                class Feature implements IFeature {

                    /**
                     * Constructs a new Feature.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IFeature);

                    /** Feature type. */
                    public type: (google.cloud.vision.v1p2beta1.Feature.Type|keyof typeof google.cloud.vision.v1p2beta1.Feature.Type);

                    /** Feature maxResults. */
                    public maxResults: number;

                    /** Feature model. */
                    public model: string;

                    /**
                     * Creates a new Feature instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Feature instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IFeature): google.cloud.vision.v1p2beta1.Feature;

                    /**
                     * Encodes the specified Feature message. Does not implicitly {@link google.cloud.vision.v1p2beta1.Feature.verify|verify} messages.
                     * @param message Feature message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IFeature, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Feature message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.Feature.verify|verify} messages.
                     * @param message Feature message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IFeature, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Feature message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Feature
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.Feature;

                    /**
                     * Decodes a Feature message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Feature
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.Feature;

                    /**
                     * Verifies a Feature message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Feature message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Feature
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.Feature;

                    /**
                     * Creates a plain object from a Feature message. Also converts values to other types if specified.
                     * @param message Feature
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.Feature, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Feature to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Feature
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace Feature {

                    /** Type enum. */
                    enum Type {
                        TYPE_UNSPECIFIED = 0,
                        FACE_DETECTION = 1,
                        LANDMARK_DETECTION = 2,
                        LOGO_DETECTION = 3,
                        LABEL_DETECTION = 4,
                        TEXT_DETECTION = 5,
                        DOCUMENT_TEXT_DETECTION = 11,
                        SAFE_SEARCH_DETECTION = 6,
                        IMAGE_PROPERTIES = 7,
                        CROP_HINTS = 9,
                        WEB_DETECTION = 10
                    }
                }

                /** Properties of an ImageSource. */
                interface IImageSource {

                    /** ImageSource gcsImageUri */
                    gcsImageUri?: (string|null);

                    /** ImageSource imageUri */
                    imageUri?: (string|null);
                }

                /** Represents an ImageSource. */
                class ImageSource implements IImageSource {

                    /**
                     * Constructs a new ImageSource.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IImageSource);

                    /** ImageSource gcsImageUri. */
                    public gcsImageUri: string;

                    /** ImageSource imageUri. */
                    public imageUri: string;

                    /**
                     * Creates a new ImageSource instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageSource instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IImageSource): google.cloud.vision.v1p2beta1.ImageSource;

                    /**
                     * Encodes the specified ImageSource message. Does not implicitly {@link google.cloud.vision.v1p2beta1.ImageSource.verify|verify} messages.
                     * @param message ImageSource message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IImageSource, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageSource message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.ImageSource.verify|verify} messages.
                     * @param message ImageSource message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IImageSource, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageSource message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageSource
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.ImageSource;

                    /**
                     * Decodes an ImageSource message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageSource
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.ImageSource;

                    /**
                     * Verifies an ImageSource message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageSource message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageSource
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.ImageSource;

                    /**
                     * Creates a plain object from an ImageSource message. Also converts values to other types if specified.
                     * @param message ImageSource
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.ImageSource, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageSource to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageSource
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an Image. */
                interface IImage {

                    /** Image content */
                    content?: (Uint8Array|Buffer|string|null);

                    /** Image source */
                    source?: (google.cloud.vision.v1p2beta1.IImageSource|null);
                }

                /** Represents an Image. */
                class Image implements IImage {

                    /**
                     * Constructs a new Image.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IImage);

                    /** Image content. */
                    public content: (Uint8Array|Buffer|string);

                    /** Image source. */
                    public source?: (google.cloud.vision.v1p2beta1.IImageSource|null);

                    /**
                     * Creates a new Image instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Image instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IImage): google.cloud.vision.v1p2beta1.Image;

                    /**
                     * Encodes the specified Image message. Does not implicitly {@link google.cloud.vision.v1p2beta1.Image.verify|verify} messages.
                     * @param message Image message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IImage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Image message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.Image.verify|verify} messages.
                     * @param message Image message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IImage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an Image message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Image
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.Image;

                    /**
                     * Decodes an Image message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Image
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.Image;

                    /**
                     * Verifies an Image message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an Image message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Image
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.Image;

                    /**
                     * Creates a plain object from an Image message. Also converts values to other types if specified.
                     * @param message Image
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.Image, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Image to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Image
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a FaceAnnotation. */
                interface IFaceAnnotation {

                    /** FaceAnnotation boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1p2beta1.IBoundingPoly|null);

                    /** FaceAnnotation fdBoundingPoly */
                    fdBoundingPoly?: (google.cloud.vision.v1p2beta1.IBoundingPoly|null);

                    /** FaceAnnotation landmarks */
                    landmarks?: (google.cloud.vision.v1p2beta1.FaceAnnotation.ILandmark[]|null);

                    /** FaceAnnotation rollAngle */
                    rollAngle?: (number|null);

                    /** FaceAnnotation panAngle */
                    panAngle?: (number|null);

                    /** FaceAnnotation tiltAngle */
                    tiltAngle?: (number|null);

                    /** FaceAnnotation detectionConfidence */
                    detectionConfidence?: (number|null);

                    /** FaceAnnotation landmarkingConfidence */
                    landmarkingConfidence?: (number|null);

                    /** FaceAnnotation joyLikelihood */
                    joyLikelihood?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);

                    /** FaceAnnotation sorrowLikelihood */
                    sorrowLikelihood?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);

                    /** FaceAnnotation angerLikelihood */
                    angerLikelihood?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);

                    /** FaceAnnotation surpriseLikelihood */
                    surpriseLikelihood?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);

                    /** FaceAnnotation underExposedLikelihood */
                    underExposedLikelihood?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);

                    /** FaceAnnotation blurredLikelihood */
                    blurredLikelihood?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);

                    /** FaceAnnotation headwearLikelihood */
                    headwearLikelihood?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);
                }

                /** Represents a FaceAnnotation. */
                class FaceAnnotation implements IFaceAnnotation {

                    /**
                     * Constructs a new FaceAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IFaceAnnotation);

                    /** FaceAnnotation boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1p2beta1.IBoundingPoly|null);

                    /** FaceAnnotation fdBoundingPoly. */
                    public fdBoundingPoly?: (google.cloud.vision.v1p2beta1.IBoundingPoly|null);

                    /** FaceAnnotation landmarks. */
                    public landmarks: google.cloud.vision.v1p2beta1.FaceAnnotation.ILandmark[];

                    /** FaceAnnotation rollAngle. */
                    public rollAngle: number;

                    /** FaceAnnotation panAngle. */
                    public panAngle: number;

                    /** FaceAnnotation tiltAngle. */
                    public tiltAngle: number;

                    /** FaceAnnotation detectionConfidence. */
                    public detectionConfidence: number;

                    /** FaceAnnotation landmarkingConfidence. */
                    public landmarkingConfidence: number;

                    /** FaceAnnotation joyLikelihood. */
                    public joyLikelihood: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /** FaceAnnotation sorrowLikelihood. */
                    public sorrowLikelihood: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /** FaceAnnotation angerLikelihood. */
                    public angerLikelihood: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /** FaceAnnotation surpriseLikelihood. */
                    public surpriseLikelihood: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /** FaceAnnotation underExposedLikelihood. */
                    public underExposedLikelihood: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /** FaceAnnotation blurredLikelihood. */
                    public blurredLikelihood: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /** FaceAnnotation headwearLikelihood. */
                    public headwearLikelihood: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /**
                     * Creates a new FaceAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns FaceAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IFaceAnnotation): google.cloud.vision.v1p2beta1.FaceAnnotation;

                    /**
                     * Encodes the specified FaceAnnotation message. Does not implicitly {@link google.cloud.vision.v1p2beta1.FaceAnnotation.verify|verify} messages.
                     * @param message FaceAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IFaceAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified FaceAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.FaceAnnotation.verify|verify} messages.
                     * @param message FaceAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IFaceAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a FaceAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns FaceAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.FaceAnnotation;

                    /**
                     * Decodes a FaceAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns FaceAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.FaceAnnotation;

                    /**
                     * Verifies a FaceAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a FaceAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns FaceAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.FaceAnnotation;

                    /**
                     * Creates a plain object from a FaceAnnotation message. Also converts values to other types if specified.
                     * @param message FaceAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.FaceAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this FaceAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for FaceAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                namespace FaceAnnotation {

                    /** Properties of a Landmark. */
                    interface ILandmark {

                        /** Landmark type */
                        type?: (google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type|keyof typeof google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type|null);

                        /** Landmark position */
                        position?: (google.cloud.vision.v1p2beta1.IPosition|null);
                    }

                    /** Represents a Landmark. */
                    class Landmark implements ILandmark {

                        /**
                         * Constructs a new Landmark.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.vision.v1p2beta1.FaceAnnotation.ILandmark);

                        /** Landmark type. */
                        public type: (google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type|keyof typeof google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type);

                        /** Landmark position. */
                        public position?: (google.cloud.vision.v1p2beta1.IPosition|null);

                        /**
                         * Creates a new Landmark instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Landmark instance
                         */
                        public static create(properties?: google.cloud.vision.v1p2beta1.FaceAnnotation.ILandmark): google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark;

                        /**
                         * Encodes the specified Landmark message. Does not implicitly {@link google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.verify|verify} messages.
                         * @param message Landmark message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.vision.v1p2beta1.FaceAnnotation.ILandmark, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Landmark message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.verify|verify} messages.
                         * @param message Landmark message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.vision.v1p2beta1.FaceAnnotation.ILandmark, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Landmark message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Landmark
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark;

                        /**
                         * Decodes a Landmark message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Landmark
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark;

                        /**
                         * Verifies a Landmark message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Landmark message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Landmark
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark;

                        /**
                         * Creates a plain object from a Landmark message. Also converts values to other types if specified.
                         * @param message Landmark
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Landmark to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };

                        /**
                         * Gets the default type url for Landmark
                         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns The default type url
                         */
                        public static getTypeUrl(typeUrlPrefix?: string): string;
                    }

                    namespace Landmark {

                        /** Type enum. */
                        enum Type {
                            UNKNOWN_LANDMARK = 0,
                            LEFT_EYE = 1,
                            RIGHT_EYE = 2,
                            LEFT_OF_LEFT_EYEBROW = 3,
                            RIGHT_OF_LEFT_EYEBROW = 4,
                            LEFT_OF_RIGHT_EYEBROW = 5,
                            RIGHT_OF_RIGHT_EYEBROW = 6,
                            MIDPOINT_BETWEEN_EYES = 7,
                            NOSE_TIP = 8,
                            UPPER_LIP = 9,
                            LOWER_LIP = 10,
                            MOUTH_LEFT = 11,
                            MOUTH_RIGHT = 12,
                            MOUTH_CENTER = 13,
                            NOSE_BOTTOM_RIGHT = 14,
                            NOSE_BOTTOM_LEFT = 15,
                            NOSE_BOTTOM_CENTER = 16,
                            LEFT_EYE_TOP_BOUNDARY = 17,
                            LEFT_EYE_RIGHT_CORNER = 18,
                            LEFT_EYE_BOTTOM_BOUNDARY = 19,
                            LEFT_EYE_LEFT_CORNER = 20,
                            RIGHT_EYE_TOP_BOUNDARY = 21,
                            RIGHT_EYE_RIGHT_CORNER = 22,
                            RIGHT_EYE_BOTTOM_BOUNDARY = 23,
                            RIGHT_EYE_LEFT_CORNER = 24,
                            LEFT_EYEBROW_UPPER_MIDPOINT = 25,
                            RIGHT_EYEBROW_UPPER_MIDPOINT = 26,
                            LEFT_EAR_TRAGION = 27,
                            RIGHT_EAR_TRAGION = 28,
                            LEFT_EYE_PUPIL = 29,
                            RIGHT_EYE_PUPIL = 30,
                            FOREHEAD_GLABELLA = 31,
                            CHIN_GNATHION = 32,
                            CHIN_LEFT_GONION = 33,
                            CHIN_RIGHT_GONION = 34
                        }
                    }
                }

                /** Properties of a LocationInfo. */
                interface ILocationInfo {

                    /** LocationInfo latLng */
                    latLng?: (google.type.ILatLng|null);
                }

                /** Represents a LocationInfo. */
                class LocationInfo implements ILocationInfo {

                    /**
                     * Constructs a new LocationInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.ILocationInfo);

                    /** LocationInfo latLng. */
                    public latLng?: (google.type.ILatLng|null);

                    /**
                     * Creates a new LocationInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns LocationInfo instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.ILocationInfo): google.cloud.vision.v1p2beta1.LocationInfo;

                    /**
                     * Encodes the specified LocationInfo message. Does not implicitly {@link google.cloud.vision.v1p2beta1.LocationInfo.verify|verify} messages.
                     * @param message LocationInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.ILocationInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified LocationInfo message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.LocationInfo.verify|verify} messages.
                     * @param message LocationInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.ILocationInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a LocationInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns LocationInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.LocationInfo;

                    /**
                     * Decodes a LocationInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns LocationInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.LocationInfo;

                    /**
                     * Verifies a LocationInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a LocationInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns LocationInfo
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.LocationInfo;

                    /**
                     * Creates a plain object from a LocationInfo message. Also converts values to other types if specified.
                     * @param message LocationInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.LocationInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this LocationInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for LocationInfo
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a Property. */
                interface IProperty {

                    /** Property name */
                    name?: (string|null);

                    /** Property value */
                    value?: (string|null);

                    /** Property uint64Value */
                    uint64Value?: (number|Long|string|null);
                }

                /** Represents a Property. */
                class Property implements IProperty {

                    /**
                     * Constructs a new Property.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IProperty);

                    /** Property name. */
                    public name: string;

                    /** Property value. */
                    public value: string;

                    /** Property uint64Value. */
                    public uint64Value: (number|Long|string);

                    /**
                     * Creates a new Property instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Property instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IProperty): google.cloud.vision.v1p2beta1.Property;

                    /**
                     * Encodes the specified Property message. Does not implicitly {@link google.cloud.vision.v1p2beta1.Property.verify|verify} messages.
                     * @param message Property message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Property message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.Property.verify|verify} messages.
                     * @param message Property message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IProperty, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Property message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Property
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.Property;

                    /**
                     * Decodes a Property message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Property
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.Property;

                    /**
                     * Verifies a Property message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Property message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Property
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.Property;

                    /**
                     * Creates a plain object from a Property message. Also converts values to other types if specified.
                     * @param message Property
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.Property, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Property to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for Property
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an EntityAnnotation. */
                interface IEntityAnnotation {

                    /** EntityAnnotation mid */
                    mid?: (string|null);

                    /** EntityAnnotation locale */
                    locale?: (string|null);

                    /** EntityAnnotation description */
                    description?: (string|null);

                    /** EntityAnnotation score */
                    score?: (number|null);

                    /** EntityAnnotation confidence */
                    confidence?: (number|null);

                    /** EntityAnnotation topicality */
                    topicality?: (number|null);

                    /** EntityAnnotation boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1p2beta1.IBoundingPoly|null);

                    /** EntityAnnotation locations */
                    locations?: (google.cloud.vision.v1p2beta1.ILocationInfo[]|null);

                    /** EntityAnnotation properties */
                    properties?: (google.cloud.vision.v1p2beta1.IProperty[]|null);
                }

                /** Represents an EntityAnnotation. */
                class EntityAnnotation implements IEntityAnnotation {

                    /**
                     * Constructs a new EntityAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IEntityAnnotation);

                    /** EntityAnnotation mid. */
                    public mid: string;

                    /** EntityAnnotation locale. */
                    public locale: string;

                    /** EntityAnnotation description. */
                    public description: string;

                    /** EntityAnnotation score. */
                    public score: number;

                    /** EntityAnnotation confidence. */
                    public confidence: number;

                    /** EntityAnnotation topicality. */
                    public topicality: number;

                    /** EntityAnnotation boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1p2beta1.IBoundingPoly|null);

                    /** EntityAnnotation locations. */
                    public locations: google.cloud.vision.v1p2beta1.ILocationInfo[];

                    /** EntityAnnotation properties. */
                    public properties: google.cloud.vision.v1p2beta1.IProperty[];

                    /**
                     * Creates a new EntityAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns EntityAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IEntityAnnotation): google.cloud.vision.v1p2beta1.EntityAnnotation;

                    /**
                     * Encodes the specified EntityAnnotation message. Does not implicitly {@link google.cloud.vision.v1p2beta1.EntityAnnotation.verify|verify} messages.
                     * @param message EntityAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IEntityAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified EntityAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.EntityAnnotation.verify|verify} messages.
                     * @param message EntityAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IEntityAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an EntityAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns EntityAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.EntityAnnotation;

                    /**
                     * Decodes an EntityAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns EntityAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.EntityAnnotation;

                    /**
                     * Verifies an EntityAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an EntityAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns EntityAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.EntityAnnotation;

                    /**
                     * Creates a plain object from an EntityAnnotation message. Also converts values to other types if specified.
                     * @param message EntityAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.EntityAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this EntityAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for EntityAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a SafeSearchAnnotation. */
                interface ISafeSearchAnnotation {

                    /** SafeSearchAnnotation adult */
                    adult?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);

                    /** SafeSearchAnnotation spoof */
                    spoof?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);

                    /** SafeSearchAnnotation medical */
                    medical?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);

                    /** SafeSearchAnnotation violence */
                    violence?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);

                    /** SafeSearchAnnotation racy */
                    racy?: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood|null);
                }

                /** Represents a SafeSearchAnnotation. */
                class SafeSearchAnnotation implements ISafeSearchAnnotation {

                    /**
                     * Constructs a new SafeSearchAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.ISafeSearchAnnotation);

                    /** SafeSearchAnnotation adult. */
                    public adult: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /** SafeSearchAnnotation spoof. */
                    public spoof: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /** SafeSearchAnnotation medical. */
                    public medical: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /** SafeSearchAnnotation violence. */
                    public violence: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /** SafeSearchAnnotation racy. */
                    public racy: (google.cloud.vision.v1p2beta1.Likelihood|keyof typeof google.cloud.vision.v1p2beta1.Likelihood);

                    /**
                     * Creates a new SafeSearchAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SafeSearchAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.ISafeSearchAnnotation): google.cloud.vision.v1p2beta1.SafeSearchAnnotation;

                    /**
                     * Encodes the specified SafeSearchAnnotation message. Does not implicitly {@link google.cloud.vision.v1p2beta1.SafeSearchAnnotation.verify|verify} messages.
                     * @param message SafeSearchAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.ISafeSearchAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SafeSearchAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.SafeSearchAnnotation.verify|verify} messages.
                     * @param message SafeSearchAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.ISafeSearchAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SafeSearchAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SafeSearchAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.SafeSearchAnnotation;

                    /**
                     * Decodes a SafeSearchAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SafeSearchAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.SafeSearchAnnotation;

                    /**
                     * Verifies a SafeSearchAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SafeSearchAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SafeSearchAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.SafeSearchAnnotation;

                    /**
                     * Creates a plain object from a SafeSearchAnnotation message. Also converts values to other types if specified.
                     * @param message SafeSearchAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.SafeSearchAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SafeSearchAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for SafeSearchAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a LatLongRect. */
                interface ILatLongRect {

                    /** LatLongRect minLatLng */
                    minLatLng?: (google.type.ILatLng|null);

                    /** LatLongRect maxLatLng */
                    maxLatLng?: (google.type.ILatLng|null);
                }

                /** Represents a LatLongRect. */
                class LatLongRect implements ILatLongRect {

                    /**
                     * Constructs a new LatLongRect.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.ILatLongRect);

                    /** LatLongRect minLatLng. */
                    public minLatLng?: (google.type.ILatLng|null);

                    /** LatLongRect maxLatLng. */
                    public maxLatLng?: (google.type.ILatLng|null);

                    /**
                     * Creates a new LatLongRect instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns LatLongRect instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.ILatLongRect): google.cloud.vision.v1p2beta1.LatLongRect;

                    /**
                     * Encodes the specified LatLongRect message. Does not implicitly {@link google.cloud.vision.v1p2beta1.LatLongRect.verify|verify} messages.
                     * @param message LatLongRect message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.ILatLongRect, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified LatLongRect message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.LatLongRect.verify|verify} messages.
                     * @param message LatLongRect message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.ILatLongRect, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a LatLongRect message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns LatLongRect
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.LatLongRect;

                    /**
                     * Decodes a LatLongRect message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns LatLongRect
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.LatLongRect;

                    /**
                     * Verifies a LatLongRect message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a LatLongRect message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns LatLongRect
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.LatLongRect;

                    /**
                     * Creates a plain object from a LatLongRect message. Also converts values to other types if specified.
                     * @param message LatLongRect
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.LatLongRect, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this LatLongRect to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for LatLongRect
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a ColorInfo. */
                interface IColorInfo {

                    /** ColorInfo color */
                    color?: (google.type.IColor|null);

                    /** ColorInfo score */
                    score?: (number|null);

                    /** ColorInfo pixelFraction */
                    pixelFraction?: (number|null);
                }

                /** Represents a ColorInfo. */
                class ColorInfo implements IColorInfo {

                    /**
                     * Constructs a new ColorInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IColorInfo);

                    /** ColorInfo color. */
                    public color?: (google.type.IColor|null);

                    /** ColorInfo score. */
                    public score: number;

                    /** ColorInfo pixelFraction. */
                    public pixelFraction: number;

                    /**
                     * Creates a new ColorInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ColorInfo instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IColorInfo): google.cloud.vision.v1p2beta1.ColorInfo;

                    /**
                     * Encodes the specified ColorInfo message. Does not implicitly {@link google.cloud.vision.v1p2beta1.ColorInfo.verify|verify} messages.
                     * @param message ColorInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IColorInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ColorInfo message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.ColorInfo.verify|verify} messages.
                     * @param message ColorInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IColorInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ColorInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ColorInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.ColorInfo;

                    /**
                     * Decodes a ColorInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ColorInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.ColorInfo;

                    /**
                     * Verifies a ColorInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ColorInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ColorInfo
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.ColorInfo;

                    /**
                     * Creates a plain object from a ColorInfo message. Also converts values to other types if specified.
                     * @param message ColorInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.ColorInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ColorInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ColorInfo
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a DominantColorsAnnotation. */
                interface IDominantColorsAnnotation {

                    /** DominantColorsAnnotation colors */
                    colors?: (google.cloud.vision.v1p2beta1.IColorInfo[]|null);
                }

                /** Represents a DominantColorsAnnotation. */
                class DominantColorsAnnotation implements IDominantColorsAnnotation {

                    /**
                     * Constructs a new DominantColorsAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IDominantColorsAnnotation);

                    /** DominantColorsAnnotation colors. */
                    public colors: google.cloud.vision.v1p2beta1.IColorInfo[];

                    /**
                     * Creates a new DominantColorsAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DominantColorsAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IDominantColorsAnnotation): google.cloud.vision.v1p2beta1.DominantColorsAnnotation;

                    /**
                     * Encodes the specified DominantColorsAnnotation message. Does not implicitly {@link google.cloud.vision.v1p2beta1.DominantColorsAnnotation.verify|verify} messages.
                     * @param message DominantColorsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IDominantColorsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DominantColorsAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.DominantColorsAnnotation.verify|verify} messages.
                     * @param message DominantColorsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IDominantColorsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DominantColorsAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DominantColorsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.DominantColorsAnnotation;

                    /**
                     * Decodes a DominantColorsAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DominantColorsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.DominantColorsAnnotation;

                    /**
                     * Verifies a DominantColorsAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DominantColorsAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DominantColorsAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.DominantColorsAnnotation;

                    /**
                     * Creates a plain object from a DominantColorsAnnotation message. Also converts values to other types if specified.
                     * @param message DominantColorsAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.DominantColorsAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DominantColorsAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for DominantColorsAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImageProperties. */
                interface IImageProperties {

                    /** ImageProperties dominantColors */
                    dominantColors?: (google.cloud.vision.v1p2beta1.IDominantColorsAnnotation|null);
                }

                /** Represents an ImageProperties. */
                class ImageProperties implements IImageProperties {

                    /**
                     * Constructs a new ImageProperties.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IImageProperties);

                    /** ImageProperties dominantColors. */
                    public dominantColors?: (google.cloud.vision.v1p2beta1.IDominantColorsAnnotation|null);

                    /**
                     * Creates a new ImageProperties instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageProperties instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IImageProperties): google.cloud.vision.v1p2beta1.ImageProperties;

                    /**
                     * Encodes the specified ImageProperties message. Does not implicitly {@link google.cloud.vision.v1p2beta1.ImageProperties.verify|verify} messages.
                     * @param message ImageProperties message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IImageProperties, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageProperties message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.ImageProperties.verify|verify} messages.
                     * @param message ImageProperties message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IImageProperties, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageProperties message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageProperties
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.ImageProperties;

                    /**
                     * Decodes an ImageProperties message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageProperties
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.ImageProperties;

                    /**
                     * Verifies an ImageProperties message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageProperties message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageProperties
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.ImageProperties;

                    /**
                     * Creates a plain object from an ImageProperties message. Also converts values to other types if specified.
                     * @param message ImageProperties
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.ImageProperties, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageProperties to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageProperties
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CropHint. */
                interface ICropHint {

                    /** CropHint boundingPoly */
                    boundingPoly?: (google.cloud.vision.v1p2beta1.IBoundingPoly|null);

                    /** CropHint confidence */
                    confidence?: (number|null);

                    /** CropHint importanceFraction */
                    importanceFraction?: (number|null);
                }

                /** Represents a CropHint. */
                class CropHint implements ICropHint {

                    /**
                     * Constructs a new CropHint.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.ICropHint);

                    /** CropHint boundingPoly. */
                    public boundingPoly?: (google.cloud.vision.v1p2beta1.IBoundingPoly|null);

                    /** CropHint confidence. */
                    public confidence: number;

                    /** CropHint importanceFraction. */
                    public importanceFraction: number;

                    /**
                     * Creates a new CropHint instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CropHint instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.ICropHint): google.cloud.vision.v1p2beta1.CropHint;

                    /**
                     * Encodes the specified CropHint message. Does not implicitly {@link google.cloud.vision.v1p2beta1.CropHint.verify|verify} messages.
                     * @param message CropHint message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.ICropHint, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CropHint message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.CropHint.verify|verify} messages.
                     * @param message CropHint message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.ICropHint, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CropHint message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CropHint
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.CropHint;

                    /**
                     * Decodes a CropHint message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CropHint
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.CropHint;

                    /**
                     * Verifies a CropHint message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CropHint message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CropHint
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.CropHint;

                    /**
                     * Creates a plain object from a CropHint message. Also converts values to other types if specified.
                     * @param message CropHint
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.CropHint, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CropHint to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CropHint
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CropHintsAnnotation. */
                interface ICropHintsAnnotation {

                    /** CropHintsAnnotation cropHints */
                    cropHints?: (google.cloud.vision.v1p2beta1.ICropHint[]|null);
                }

                /** Represents a CropHintsAnnotation. */
                class CropHintsAnnotation implements ICropHintsAnnotation {

                    /**
                     * Constructs a new CropHintsAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.ICropHintsAnnotation);

                    /** CropHintsAnnotation cropHints. */
                    public cropHints: google.cloud.vision.v1p2beta1.ICropHint[];

                    /**
                     * Creates a new CropHintsAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CropHintsAnnotation instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.ICropHintsAnnotation): google.cloud.vision.v1p2beta1.CropHintsAnnotation;

                    /**
                     * Encodes the specified CropHintsAnnotation message. Does not implicitly {@link google.cloud.vision.v1p2beta1.CropHintsAnnotation.verify|verify} messages.
                     * @param message CropHintsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.ICropHintsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CropHintsAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.CropHintsAnnotation.verify|verify} messages.
                     * @param message CropHintsAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.ICropHintsAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CropHintsAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CropHintsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.CropHintsAnnotation;

                    /**
                     * Decodes a CropHintsAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CropHintsAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.CropHintsAnnotation;

                    /**
                     * Verifies a CropHintsAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CropHintsAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CropHintsAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.CropHintsAnnotation;

                    /**
                     * Creates a plain object from a CropHintsAnnotation message. Also converts values to other types if specified.
                     * @param message CropHintsAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.CropHintsAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CropHintsAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CropHintsAnnotation
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a CropHintsParams. */
                interface ICropHintsParams {

                    /** CropHintsParams aspectRatios */
                    aspectRatios?: (number[]|null);
                }

                /** Represents a CropHintsParams. */
                class CropHintsParams implements ICropHintsParams {

                    /**
                     * Constructs a new CropHintsParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.ICropHintsParams);

                    /** CropHintsParams aspectRatios. */
                    public aspectRatios: number[];

                    /**
                     * Creates a new CropHintsParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CropHintsParams instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.ICropHintsParams): google.cloud.vision.v1p2beta1.CropHintsParams;

                    /**
                     * Encodes the specified CropHintsParams message. Does not implicitly {@link google.cloud.vision.v1p2beta1.CropHintsParams.verify|verify} messages.
                     * @param message CropHintsParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.ICropHintsParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CropHintsParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.CropHintsParams.verify|verify} messages.
                     * @param message CropHintsParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.ICropHintsParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CropHintsParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CropHintsParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.CropHintsParams;

                    /**
                     * Decodes a CropHintsParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CropHintsParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.CropHintsParams;

                    /**
                     * Verifies a CropHintsParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CropHintsParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CropHintsParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.CropHintsParams;

                    /**
                     * Creates a plain object from a CropHintsParams message. Also converts values to other types if specified.
                     * @param message CropHintsParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.CropHintsParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CropHintsParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for CropHintsParams
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a WebDetectionParams. */
                interface IWebDetectionParams {

                    /** WebDetectionParams includeGeoResults */
                    includeGeoResults?: (boolean|null);
                }

                /** Represents a WebDetectionParams. */
                class WebDetectionParams implements IWebDetectionParams {

                    /**
                     * Constructs a new WebDetectionParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IWebDetectionParams);

                    /** WebDetectionParams includeGeoResults. */
                    public includeGeoResults: boolean;

                    /**
                     * Creates a new WebDetectionParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns WebDetectionParams instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IWebDetectionParams): google.cloud.vision.v1p2beta1.WebDetectionParams;

                    /**
                     * Encodes the specified WebDetectionParams message. Does not implicitly {@link google.cloud.vision.v1p2beta1.WebDetectionParams.verify|verify} messages.
                     * @param message WebDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IWebDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified WebDetectionParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.WebDetectionParams.verify|verify} messages.
                     * @param message WebDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IWebDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a WebDetectionParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns WebDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.WebDetectionParams;

                    /**
                     * Decodes a WebDetectionParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns WebDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.WebDetectionParams;

                    /**
                     * Verifies a WebDetectionParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a WebDetectionParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns WebDetectionParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.WebDetectionParams;

                    /**
                     * Creates a plain object from a WebDetectionParams message. Also converts values to other types if specified.
                     * @param message WebDetectionParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.WebDetectionParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this WebDetectionParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for WebDetectionParams
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a TextDetectionParams. */
                interface ITextDetectionParams {

                    /** TextDetectionParams enableTextDetectionConfidenceScore */
                    enableTextDetectionConfidenceScore?: (boolean|null);

                    /** TextDetectionParams advancedOcrOptions */
                    advancedOcrOptions?: (string[]|null);
                }

                /** Represents a TextDetectionParams. */
                class TextDetectionParams implements ITextDetectionParams {

                    /**
                     * Constructs a new TextDetectionParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.ITextDetectionParams);

                    /** TextDetectionParams enableTextDetectionConfidenceScore. */
                    public enableTextDetectionConfidenceScore: boolean;

                    /** TextDetectionParams advancedOcrOptions. */
                    public advancedOcrOptions: string[];

                    /**
                     * Creates a new TextDetectionParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TextDetectionParams instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.ITextDetectionParams): google.cloud.vision.v1p2beta1.TextDetectionParams;

                    /**
                     * Encodes the specified TextDetectionParams message. Does not implicitly {@link google.cloud.vision.v1p2beta1.TextDetectionParams.verify|verify} messages.
                     * @param message TextDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.ITextDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TextDetectionParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.TextDetectionParams.verify|verify} messages.
                     * @param message TextDetectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.ITextDetectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TextDetectionParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TextDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.TextDetectionParams;

                    /**
                     * Decodes a TextDetectionParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TextDetectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.TextDetectionParams;

                    /**
                     * Verifies a TextDetectionParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TextDetectionParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TextDetectionParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.TextDetectionParams;

                    /**
                     * Creates a plain object from a TextDetectionParams message. Also converts values to other types if specified.
                     * @param message TextDetectionParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.TextDetectionParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TextDetectionParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for TextDetectionParams
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImageContext. */
                interface IImageContext {

                    /** ImageContext latLongRect */
                    latLongRect?: (google.cloud.vision.v1p2beta1.ILatLongRect|null);

                    /** ImageContext languageHints */
                    languageHints?: (string[]|null);

                    /** ImageContext cropHintsParams */
                    cropHintsParams?: (google.cloud.vision.v1p2beta1.ICropHintsParams|null);

                    /** ImageContext webDetectionParams */
                    webDetectionParams?: (google.cloud.vision.v1p2beta1.IWebDetectionParams|null);

                    /** ImageContext textDetectionParams */
                    textDetectionParams?: (google.cloud.vision.v1p2beta1.ITextDetectionParams|null);
                }

                /** Represents an ImageContext. */
                class ImageContext implements IImageContext {

                    /**
                     * Constructs a new ImageContext.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IImageContext);

                    /** ImageContext latLongRect. */
                    public latLongRect?: (google.cloud.vision.v1p2beta1.ILatLongRect|null);

                    /** ImageContext languageHints. */
                    public languageHints: string[];

                    /** ImageContext cropHintsParams. */
                    public cropHintsParams?: (google.cloud.vision.v1p2beta1.ICropHintsParams|null);

                    /** ImageContext webDetectionParams. */
                    public webDetectionParams?: (google.cloud.vision.v1p2beta1.IWebDetectionParams|null);

                    /** ImageContext textDetectionParams. */
                    public textDetectionParams?: (google.cloud.vision.v1p2beta1.ITextDetectionParams|null);

                    /**
                     * Creates a new ImageContext instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageContext instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IImageContext): google.cloud.vision.v1p2beta1.ImageContext;

                    /**
                     * Encodes the specified ImageContext message. Does not implicitly {@link google.cloud.vision.v1p2beta1.ImageContext.verify|verify} messages.
                     * @param message ImageContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IImageContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageContext message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.ImageContext.verify|verify} messages.
                     * @param message ImageContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IImageContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageContext message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.ImageContext;

                    /**
                     * Decodes an ImageContext message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.ImageContext;

                    /**
                     * Verifies an ImageContext message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageContext message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageContext
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.ImageContext;

                    /**
                     * Creates a plain object from an ImageContext message. Also converts values to other types if specified.
                     * @param message ImageContext
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.ImageContext, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageContext to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageContext
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AnnotateImageRequest. */
                interface IAnnotateImageRequest {

                    /** AnnotateImageRequest image */
                    image?: (google.cloud.vision.v1p2beta1.IImage|null);

                    /** AnnotateImageRequest features */
                    features?: (google.cloud.vision.v1p2beta1.IFeature[]|null);

                    /** AnnotateImageRequest imageContext */
                    imageContext?: (google.cloud.vision.v1p2beta1.IImageContext|null);
                }

                /** Represents an AnnotateImageRequest. */
                class AnnotateImageRequest implements IAnnotateImageRequest {

                    /**
                     * Constructs a new AnnotateImageRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IAnnotateImageRequest);

                    /** AnnotateImageRequest image. */
                    public image?: (google.cloud.vision.v1p2beta1.IImage|null);

                    /** AnnotateImageRequest features. */
                    public features: google.cloud.vision.v1p2beta1.IFeature[];

                    /** AnnotateImageRequest imageContext. */
                    public imageContext?: (google.cloud.vision.v1p2beta1.IImageContext|null);

                    /**
                     * Creates a new AnnotateImageRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnnotateImageRequest instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IAnnotateImageRequest): google.cloud.vision.v1p2beta1.AnnotateImageRequest;

                    /**
                     * Encodes the specified AnnotateImageRequest message. Does not implicitly {@link google.cloud.vision.v1p2beta1.AnnotateImageRequest.verify|verify} messages.
                     * @param message AnnotateImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IAnnotateImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnnotateImageRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.AnnotateImageRequest.verify|verify} messages.
                     * @param message AnnotateImageRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IAnnotateImageRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnnotateImageRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnnotateImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.AnnotateImageRequest;

                    /**
                     * Decodes an AnnotateImageRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnnotateImageRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.AnnotateImageRequest;

                    /**
                     * Verifies an AnnotateImageRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnnotateImageRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnnotateImageRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.AnnotateImageRequest;

                    /**
                     * Creates a plain object from an AnnotateImageRequest message. Also converts values to other types if specified.
                     * @param message AnnotateImageRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.AnnotateImageRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnnotateImageRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for AnnotateImageRequest
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an ImageAnnotationContext. */
                interface IImageAnnotationContext {

                    /** ImageAnnotationContext uri */
                    uri?: (string|null);

                    /** ImageAnnotationContext pageNumber */
                    pageNumber?: (number|null);
                }

                /** Represents an ImageAnnotationContext. */
                class ImageAnnotationContext implements IImageAnnotationContext {

                    /**
                     * Constructs a new ImageAnnotationContext.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.vision.v1p2beta1.IImageAnnotationContext);

                    /** ImageAnnotationContext uri. */
                    public uri: string;

                    /** ImageAnnotationContext pageNumber. */
                    public pageNumber: number;

                    /**
                     * Creates a new ImageAnnotationContext instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImageAnnotationContext instance
                     */
                    public static create(properties?: google.cloud.vision.v1p2beta1.IImageAnnotationContext): google.cloud.vision.v1p2beta1.ImageAnnotationContext;

                    /**
                     * Encodes the specified ImageAnnotationContext message. Does not implicitly {@link google.cloud.vision.v1p2beta1.ImageAnnotationContext.verify|verify} messages.
                     * @param message ImageAnnotationContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.vision.v1p2beta1.IImageAnnotationContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImageAnnotationContext message, length delimited. Does not implicitly {@link google.cloud.vision.v1p2beta1.ImageAnnotationContext.verify|verify} messages.
                     * @param message ImageAnnotationContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.vision.v1p2beta1.IImageAnnotationContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImageAnnotationContext message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImageAnnotationContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.vision.v1p2beta1.ImageAnnotationContext;

                    /**
                     * Decodes an ImageAnnotationContext message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImageAnnotationContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.vision.v1p2beta1.ImageAnnotationContext;

                    /**
                     * Verifies an ImageAnnotationContext message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImageAnnotationContext message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImageAnnotationContext
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.vision.v1p2beta1.ImageAnnotationContext;

                    /**
                     * Creates a plain object from an ImageAnnotationContext message. Also converts values to other types if specified.
                     * @param message ImageAnnotationContext
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.vision.v1p2beta1.ImageAnnotationContext, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImageAnnotationContext to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ImageAnnotationContext
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of an AnnotateImageResponse. */
                interface IAnnotateImageResponse {

                    /** AnnotateImageResponse faceAnnotations */
                    faceAnnotations?: (google.cloud.vision.v1p2beta1.IFaceAnnotation[]|null);

                    /** AnnotateImageResponse landmarkAnnotations */
                    landmarkAnnotations?: (google.cloud.vision.v1p2beta1.IEnti