// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("google-gax/build/src/protobuf").protobufMinimal);

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots._google_cloud_vision_protos || ($protobuf.roots._google_cloud_vision_protos = {});
    
    $root.google = (function() {
    
        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};
    
        google.cloud = (function() {
    
            /**
             * Namespace cloud.
             * @memberof google
             * @namespace
             */
            var cloud = {};
    
            cloud.vision = (function() {
    
                /**
                 * Namespace vision.
                 * @memberof google.cloud
                 * @namespace
                 */
                var vision = {};
    
                vision.v1 = (function() {
    
                    /**
                     * Namespace v1.
                     * @memberof google.cloud.vision
                     * @namespace
                     */
                    var v1 = {};
    
                    v1.Vertex = (function() {
    
                        /**
                         * Properties of a Vertex.
                         * @memberof google.cloud.vision.v1
                         * @interface IVertex
                         * @property {number|null} [x] Vertex x
                         * @property {number|null} [y] Vertex y
                         */
    
                        /**
                         * Constructs a new Vertex.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a Vertex.
                         * @implements IVertex
                         * @constructor
                         * @param {google.cloud.vision.v1.IVertex=} [properties] Properties to set
                         */
                        function Vertex(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Vertex x.
                         * @member {number} x
                         * @memberof google.cloud.vision.v1.Vertex
                         * @instance
                         */
                        Vertex.prototype.x = 0;
    
                        /**
                         * Vertex y.
                         * @member {number} y
                         * @memberof google.cloud.vision.v1.Vertex
                         * @instance
                         */
                        Vertex.prototype.y = 0;
    
                        /**
                         * Creates a new Vertex instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.Vertex
                         * @static
                         * @param {google.cloud.vision.v1.IVertex=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.Vertex} Vertex instance
                         */
                        Vertex.create = function create(properties) {
                            return new Vertex(properties);
                        };
    
                        /**
                         * Encodes the specified Vertex message. Does not implicitly {@link google.cloud.vision.v1.Vertex.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.Vertex
                         * @static
                         * @param {google.cloud.vision.v1.IVertex} message Vertex message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Vertex.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.x != null && Object.hasOwnProperty.call(message, "x"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.x);
                            if (message.y != null && Object.hasOwnProperty.call(message, "y"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.y);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Vertex message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Vertex.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.Vertex
                         * @static
                         * @param {google.cloud.vision.v1.IVertex} message Vertex message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Vertex.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Vertex message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.Vertex
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.Vertex} Vertex
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Vertex.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.Vertex();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.x = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.y = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Vertex message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.Vertex
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.Vertex} Vertex
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Vertex.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Vertex message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.Vertex
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Vertex.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.x != null && message.hasOwnProperty("x"))
                                if (!$util.isInteger(message.x))
                                    return "x: integer expected";
                            if (message.y != null && message.hasOwnProperty("y"))
                                if (!$util.isInteger(message.y))
                                    return "y: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a Vertex message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.Vertex
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.Vertex} Vertex
                         */
                        Vertex.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.Vertex)
                                return object;
                            var message = new $root.google.cloud.vision.v1.Vertex();
                            if (object.x != null)
                                message.x = object.x | 0;
                            if (object.y != null)
                                message.y = object.y | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Vertex message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.Vertex
                         * @static
                         * @param {google.cloud.vision.v1.Vertex} message Vertex
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Vertex.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.x = 0;
                                object.y = 0;
                            }
                            if (message.x != null && message.hasOwnProperty("x"))
                                object.x = message.x;
                            if (message.y != null && message.hasOwnProperty("y"))
                                object.y = message.y;
                            return object;
                        };
    
                        /**
                         * Converts this Vertex to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.Vertex
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Vertex.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Vertex
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.Vertex
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Vertex.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.Vertex";
                        };
    
                        return Vertex;
                    })();
    
                    v1.NormalizedVertex = (function() {
    
                        /**
                         * Properties of a NormalizedVertex.
                         * @memberof google.cloud.vision.v1
                         * @interface INormalizedVertex
                         * @property {number|null} [x] NormalizedVertex x
                         * @property {number|null} [y] NormalizedVertex y
                         */
    
                        /**
                         * Constructs a new NormalizedVertex.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a NormalizedVertex.
                         * @implements INormalizedVertex
                         * @constructor
                         * @param {google.cloud.vision.v1.INormalizedVertex=} [properties] Properties to set
                         */
                        function NormalizedVertex(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * NormalizedVertex x.
                         * @member {number} x
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @instance
                         */
                        NormalizedVertex.prototype.x = 0;
    
                        /**
                         * NormalizedVertex y.
                         * @member {number} y
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @instance
                         */
                        NormalizedVertex.prototype.y = 0;
    
                        /**
                         * Creates a new NormalizedVertex instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @static
                         * @param {google.cloud.vision.v1.INormalizedVertex=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.NormalizedVertex} NormalizedVertex instance
                         */
                        NormalizedVertex.create = function create(properties) {
                            return new NormalizedVertex(properties);
                        };
    
                        /**
                         * Encodes the specified NormalizedVertex message. Does not implicitly {@link google.cloud.vision.v1.NormalizedVertex.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @static
                         * @param {google.cloud.vision.v1.INormalizedVertex} message NormalizedVertex message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        NormalizedVertex.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.x != null && Object.hasOwnProperty.call(message, "x"))
                                writer.uint32(/* id 1, wireType 5 =*/13).float(message.x);
                            if (message.y != null && Object.hasOwnProperty.call(message, "y"))
                                writer.uint32(/* id 2, wireType 5 =*/21).float(message.y);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified NormalizedVertex message, length delimited. Does not implicitly {@link google.cloud.vision.v1.NormalizedVertex.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @static
                         * @param {google.cloud.vision.v1.INormalizedVertex} message NormalizedVertex message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        NormalizedVertex.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a NormalizedVertex message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.NormalizedVertex} NormalizedVertex
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        NormalizedVertex.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.NormalizedVertex();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.x = reader.float();
                                        break;
                                    }
                                case 2: {
                                        message.y = reader.float();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a NormalizedVertex message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.NormalizedVertex} NormalizedVertex
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        NormalizedVertex.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a NormalizedVertex message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        NormalizedVertex.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.x != null && message.hasOwnProperty("x"))
                                if (typeof message.x !== "number")
                                    return "x: number expected";
                            if (message.y != null && message.hasOwnProperty("y"))
                                if (typeof message.y !== "number")
                                    return "y: number expected";
                            return null;
                        };
    
                        /**
                         * Creates a NormalizedVertex message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.NormalizedVertex} NormalizedVertex
                         */
                        NormalizedVertex.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.NormalizedVertex)
                                return object;
                            var message = new $root.google.cloud.vision.v1.NormalizedVertex();
                            if (object.x != null)
                                message.x = Number(object.x);
                            if (object.y != null)
                                message.y = Number(object.y);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a NormalizedVertex message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @static
                         * @param {google.cloud.vision.v1.NormalizedVertex} message NormalizedVertex
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        NormalizedVertex.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.x = 0;
                                object.y = 0;
                            }
                            if (message.x != null && message.hasOwnProperty("x"))
                                object.x = options.json && !isFinite(message.x) ? String(message.x) : message.x;
                            if (message.y != null && message.hasOwnProperty("y"))
                                object.y = options.json && !isFinite(message.y) ? String(message.y) : message.y;
                            return object;
                        };
    
                        /**
                         * Converts this NormalizedVertex to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        NormalizedVertex.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for NormalizedVertex
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.NormalizedVertex
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        NormalizedVertex.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.NormalizedVertex";
                        };
    
                        return NormalizedVertex;
                    })();
    
                    v1.BoundingPoly = (function() {
    
                        /**
                         * Properties of a BoundingPoly.
                         * @memberof google.cloud.vision.v1
                         * @interface IBoundingPoly
                         * @property {Array.<google.cloud.vision.v1.IVertex>|null} [vertices] BoundingPoly vertices
                         * @property {Array.<google.cloud.vision.v1.INormalizedVertex>|null} [normalizedVertices] BoundingPoly normalizedVertices
                         */
    
                        /**
                         * Constructs a new BoundingPoly.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a BoundingPoly.
                         * @implements IBoundingPoly
                         * @constructor
                         * @param {google.cloud.vision.v1.IBoundingPoly=} [properties] Properties to set
                         */
                        function BoundingPoly(properties) {
                            this.vertices = [];
                            this.normalizedVertices = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * BoundingPoly vertices.
                         * @member {Array.<google.cloud.vision.v1.IVertex>} vertices
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @instance
                         */
                        BoundingPoly.prototype.vertices = $util.emptyArray;
    
                        /**
                         * BoundingPoly normalizedVertices.
                         * @member {Array.<google.cloud.vision.v1.INormalizedVertex>} normalizedVertices
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @instance
                         */
                        BoundingPoly.prototype.normalizedVertices = $util.emptyArray;
    
                        /**
                         * Creates a new BoundingPoly instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @static
                         * @param {google.cloud.vision.v1.IBoundingPoly=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.BoundingPoly} BoundingPoly instance
                         */
                        BoundingPoly.create = function create(properties) {
                            return new BoundingPoly(properties);
                        };
    
                        /**
                         * Encodes the specified BoundingPoly message. Does not implicitly {@link google.cloud.vision.v1.BoundingPoly.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @static
                         * @param {google.cloud.vision.v1.IBoundingPoly} message BoundingPoly message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BoundingPoly.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.vertices != null && message.vertices.length)
                                for (var i = 0; i < message.vertices.length; ++i)
                                    $root.google.cloud.vision.v1.Vertex.encode(message.vertices[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.normalizedVertices != null && message.normalizedVertices.length)
                                for (var i = 0; i < message.normalizedVertices.length; ++i)
                                    $root.google.cloud.vision.v1.NormalizedVertex.encode(message.normalizedVertices[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified BoundingPoly message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BoundingPoly.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @static
                         * @param {google.cloud.vision.v1.IBoundingPoly} message BoundingPoly message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BoundingPoly.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a BoundingPoly message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.BoundingPoly} BoundingPoly
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BoundingPoly.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.BoundingPoly();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.vertices && message.vertices.length))
                                            message.vertices = [];
                                        message.vertices.push($root.google.cloud.vision.v1.Vertex.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        if (!(message.normalizedVertices && message.normalizedVertices.length))
                                            message.normalizedVertices = [];
                                        message.normalizedVertices.push($root.google.cloud.vision.v1.NormalizedVertex.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a BoundingPoly message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.BoundingPoly} BoundingPoly
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BoundingPoly.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a BoundingPoly message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        BoundingPoly.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.vertices != null && message.hasOwnProperty("vertices")) {
                                if (!Array.isArray(message.vertices))
                                    return "vertices: array expected";
                                for (var i = 0; i < message.vertices.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.Vertex.verify(message.vertices[i]);
                                    if (error)
                                        return "vertices." + error;
                                }
                            }
                            if (message.normalizedVertices != null && message.hasOwnProperty("normalizedVertices")) {
                                if (!Array.isArray(message.normalizedVertices))
                                    return "normalizedVertices: array expected";
                                for (var i = 0; i < message.normalizedVertices.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.NormalizedVertex.verify(message.normalizedVertices[i]);
                                    if (error)
                                        return "normalizedVertices." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a BoundingPoly message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.BoundingPoly} BoundingPoly
                         */
                        BoundingPoly.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.BoundingPoly)
                                return object;
                            var message = new $root.google.cloud.vision.v1.BoundingPoly();
                            if (object.vertices) {
                                if (!Array.isArray(object.vertices))
                                    throw TypeError(".google.cloud.vision.v1.BoundingPoly.vertices: array expected");
                                message.vertices = [];
                                for (var i = 0; i < object.vertices.length; ++i) {
                                    if (typeof object.vertices[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.BoundingPoly.vertices: object expected");
                                    message.vertices[i] = $root.google.cloud.vision.v1.Vertex.fromObject(object.vertices[i]);
                                }
                            }
                            if (object.normalizedVertices) {
                                if (!Array.isArray(object.normalizedVertices))
                                    throw TypeError(".google.cloud.vision.v1.BoundingPoly.normalizedVertices: array expected");
                                message.normalizedVertices = [];
                                for (var i = 0; i < object.normalizedVertices.length; ++i) {
                                    if (typeof object.normalizedVertices[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.BoundingPoly.normalizedVertices: object expected");
                                    message.normalizedVertices[i] = $root.google.cloud.vision.v1.NormalizedVertex.fromObject(object.normalizedVertices[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a BoundingPoly message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @static
                         * @param {google.cloud.vision.v1.BoundingPoly} message BoundingPoly
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        BoundingPoly.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.vertices = [];
                                object.normalizedVertices = [];
                            }
                            if (message.vertices && message.vertices.length) {
                                object.vertices = [];
                                for (var j = 0; j < message.vertices.length; ++j)
                                    object.vertices[j] = $root.google.cloud.vision.v1.Vertex.toObject(message.vertices[j], options);
                            }
                            if (message.normalizedVertices && message.normalizedVertices.length) {
                                object.normalizedVertices = [];
                                for (var j = 0; j < message.normalizedVertices.length; ++j)
                                    object.normalizedVertices[j] = $root.google.cloud.vision.v1.NormalizedVertex.toObject(message.normalizedVertices[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this BoundingPoly to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        BoundingPoly.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for BoundingPoly
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.BoundingPoly
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        BoundingPoly.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.BoundingPoly";
                        };
    
                        return BoundingPoly;
                    })();
    
                    v1.Position = (function() {
    
                        /**
                         * Properties of a Position.
                         * @memberof google.cloud.vision.v1
                         * @interface IPosition
                         * @property {number|null} [x] Position x
                         * @property {number|null} [y] Position y
                         * @property {number|null} [z] Position z
                         */
    
                        /**
                         * Constructs a new Position.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a Position.
                         * @implements IPosition
                         * @constructor
                         * @param {google.cloud.vision.v1.IPosition=} [properties] Properties to set
                         */
                        function Position(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Position x.
                         * @member {number} x
                         * @memberof google.cloud.vision.v1.Position
                         * @instance
                         */
                        Position.prototype.x = 0;
    
                        /**
                         * Position y.
                         * @member {number} y
                         * @memberof google.cloud.vision.v1.Position
                         * @instance
                         */
                        Position.prototype.y = 0;
    
                        /**
                         * Position z.
                         * @member {number} z
                         * @memberof google.cloud.vision.v1.Position
                         * @instance
                         */
                        Position.prototype.z = 0;
    
                        /**
                         * Creates a new Position instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.Position
                         * @static
                         * @param {google.cloud.vision.v1.IPosition=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.Position} Position instance
                         */
                        Position.create = function create(properties) {
                            return new Position(properties);
                        };
    
                        /**
                         * Encodes the specified Position message. Does not implicitly {@link google.cloud.vision.v1.Position.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.Position
                         * @static
                         * @param {google.cloud.vision.v1.IPosition} message Position message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Position.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.x != null && Object.hasOwnProperty.call(message, "x"))
                                writer.uint32(/* id 1, wireType 5 =*/13).float(message.x);
                            if (message.y != null && Object.hasOwnProperty.call(message, "y"))
                                writer.uint32(/* id 2, wireType 5 =*/21).float(message.y);
                            if (message.z != null && Object.hasOwnProperty.call(message, "z"))
                                writer.uint32(/* id 3, wireType 5 =*/29).float(message.z);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Position message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Position.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.Position
                         * @static
                         * @param {google.cloud.vision.v1.IPosition} message Position message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Position.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Position message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.Position
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.Position} Position
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Position.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.Position();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.x = reader.float();
                                        break;
                                    }
                                case 2: {
                                        message.y = reader.float();
                                        break;
                                    }
                                case 3: {
                                        message.z = reader.float();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Position message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.Position
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.Position} Position
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Position.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Position message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.Position
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Position.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.x != null && message.hasOwnProperty("x"))
                                if (typeof message.x !== "number")
                                    return "x: number expected";
                            if (message.y != null && message.hasOwnProperty("y"))
                                if (typeof message.y !== "number")
                                    return "y: number expected";
                            if (message.z != null && message.hasOwnProperty("z"))
                                if (typeof message.z !== "number")
                                    return "z: number expected";
                            return null;
                        };
    
                        /**
                         * Creates a Position message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.Position
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.Position} Position
                         */
                        Position.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.Position)
                                return object;
                            var message = new $root.google.cloud.vision.v1.Position();
                            if (object.x != null)
                                message.x = Number(object.x);
                            if (object.y != null)
                                message.y = Number(object.y);
                            if (object.z != null)
                                message.z = Number(object.z);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Position message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.Position
                         * @static
                         * @param {google.cloud.vision.v1.Position} message Position
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Position.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.x = 0;
                                object.y = 0;
                                object.z = 0;
                            }
                            if (message.x != null && message.hasOwnProperty("x"))
                                object.x = options.json && !isFinite(message.x) ? String(message.x) : message.x;
                            if (message.y != null && message.hasOwnProperty("y"))
                                object.y = options.json && !isFinite(message.y) ? String(message.y) : message.y;
                            if (message.z != null && message.hasOwnProperty("z"))
                                object.z = options.json && !isFinite(message.z) ? String(message.z) : message.z;
                            return object;
                        };
    
                        /**
                         * Converts this Position to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.Position
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Position.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Position
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.Position
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Position.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.Position";
                        };
    
                        return Position;
                    })();
    
                    v1.ImageAnnotator = (function() {
    
                        /**
                         * Constructs a new ImageAnnotator service.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an ImageAnnotator
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function ImageAnnotator(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (ImageAnnotator.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = ImageAnnotator;
    
                        /**
                         * Creates new ImageAnnotator service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {ImageAnnotator} RPC service. Useful where requests and/or responses are streamed.
                         */
                        ImageAnnotator.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ImageAnnotator|batchAnnotateImages}.
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @typedef BatchAnnotateImagesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.BatchAnnotateImagesResponse} [response] BatchAnnotateImagesResponse
                         */
    
                        /**
                         * Calls BatchAnnotateImages.
                         * @function batchAnnotateImages
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @instance
                         * @param {google.cloud.vision.v1.IBatchAnnotateImagesRequest} request BatchAnnotateImagesRequest message or plain object
                         * @param {google.cloud.vision.v1.ImageAnnotator.BatchAnnotateImagesCallback} callback Node-style callback called with the error, if any, and BatchAnnotateImagesResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ImageAnnotator.prototype.batchAnnotateImages = function batchAnnotateImages(request, callback) {
                            return this.rpcCall(batchAnnotateImages, $root.google.cloud.vision.v1.BatchAnnotateImagesRequest, $root.google.cloud.vision.v1.BatchAnnotateImagesResponse, request, callback);
                        }, "name", { value: "BatchAnnotateImages" });
    
                        /**
                         * Calls BatchAnnotateImages.
                         * @function batchAnnotateImages
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @instance
                         * @param {google.cloud.vision.v1.IBatchAnnotateImagesRequest} request BatchAnnotateImagesRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.BatchAnnotateImagesResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ImageAnnotator|batchAnnotateFiles}.
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @typedef BatchAnnotateFilesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.BatchAnnotateFilesResponse} [response] BatchAnnotateFilesResponse
                         */
    
                        /**
                         * Calls BatchAnnotateFiles.
                         * @function batchAnnotateFiles
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @instance
                         * @param {google.cloud.vision.v1.IBatchAnnotateFilesRequest} request BatchAnnotateFilesRequest message or plain object
                         * @param {google.cloud.vision.v1.ImageAnnotator.BatchAnnotateFilesCallback} callback Node-style callback called with the error, if any, and BatchAnnotateFilesResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ImageAnnotator.prototype.batchAnnotateFiles = function batchAnnotateFiles(request, callback) {
                            return this.rpcCall(batchAnnotateFiles, $root.google.cloud.vision.v1.BatchAnnotateFilesRequest, $root.google.cloud.vision.v1.BatchAnnotateFilesResponse, request, callback);
                        }, "name", { value: "BatchAnnotateFiles" });
    
                        /**
                         * Calls BatchAnnotateFiles.
                         * @function batchAnnotateFiles
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @instance
                         * @param {google.cloud.vision.v1.IBatchAnnotateFilesRequest} request BatchAnnotateFilesRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.BatchAnnotateFilesResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ImageAnnotator|asyncBatchAnnotateImages}.
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @typedef AsyncBatchAnnotateImagesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls AsyncBatchAnnotateImages.
                         * @function asyncBatchAnnotateImages
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @instance
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest} request AsyncBatchAnnotateImagesRequest message or plain object
                         * @param {google.cloud.vision.v1.ImageAnnotator.AsyncBatchAnnotateImagesCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ImageAnnotator.prototype.asyncBatchAnnotateImages = function asyncBatchAnnotateImages(request, callback) {
                            return this.rpcCall(asyncBatchAnnotateImages, $root.google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "AsyncBatchAnnotateImages" });
    
                        /**
                         * Calls AsyncBatchAnnotateImages.
                         * @function asyncBatchAnnotateImages
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @instance
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest} request AsyncBatchAnnotateImagesRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ImageAnnotator|asyncBatchAnnotateFiles}.
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @typedef AsyncBatchAnnotateFilesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls AsyncBatchAnnotateFiles.
                         * @function asyncBatchAnnotateFiles
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @instance
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest} request AsyncBatchAnnotateFilesRequest message or plain object
                         * @param {google.cloud.vision.v1.ImageAnnotator.AsyncBatchAnnotateFilesCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ImageAnnotator.prototype.asyncBatchAnnotateFiles = function asyncBatchAnnotateFiles(request, callback) {
                            return this.rpcCall(asyncBatchAnnotateFiles, $root.google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "AsyncBatchAnnotateFiles" });
    
                        /**
                         * Calls AsyncBatchAnnotateFiles.
                         * @function asyncBatchAnnotateFiles
                         * @memberof google.cloud.vision.v1.ImageAnnotator
                         * @instance
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest} request AsyncBatchAnnotateFilesRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        return ImageAnnotator;
                    })();
    
                    /**
                     * Likelihood enum.
                     * @name google.cloud.vision.v1.Likelihood
                     * @enum {number}
                     * @property {number} UNKNOWN=0 UNKNOWN value
                     * @property {number} VERY_UNLIKELY=1 VERY_UNLIKELY value
                     * @property {number} UNLIKELY=2 UNLIKELY value
                     * @property {number} POSSIBLE=3 POSSIBLE value
                     * @property {number} LIKELY=4 LIKELY value
                     * @property {number} VERY_LIKELY=5 VERY_LIKELY value
                     */
                    v1.Likelihood = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "UNKNOWN"] = 0;
                        values[valuesById[1] = "VERY_UNLIKELY"] = 1;
                        values[valuesById[2] = "UNLIKELY"] = 2;
                        values[valuesById[3] = "POSSIBLE"] = 3;
                        values[valuesById[4] = "LIKELY"] = 4;
                        values[valuesById[5] = "VERY_LIKELY"] = 5;
                        return values;
                    })();
    
                    v1.Feature = (function() {
    
                        /**
                         * Properties of a Feature.
                         * @memberof google.cloud.vision.v1
                         * @interface IFeature
                         * @property {google.cloud.vision.v1.Feature.Type|null} [type] Feature type
                         * @property {number|null} [maxResults] Feature maxResults
                         * @property {string|null} [model] Feature model
                         */
    
                        /**
                         * Constructs a new Feature.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a Feature.
                         * @implements IFeature
                         * @constructor
                         * @param {google.cloud.vision.v1.IFeature=} [properties] Properties to set
                         */
                        function Feature(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Feature type.
                         * @member {google.cloud.vision.v1.Feature.Type} type
                         * @memberof google.cloud.vision.v1.Feature
                         * @instance
                         */
                        Feature.prototype.type = 0;
    
                        /**
                         * Feature maxResults.
                         * @member {number} maxResults
                         * @memberof google.cloud.vision.v1.Feature
                         * @instance
                         */
                        Feature.prototype.maxResults = 0;
    
                        /**
                         * Feature model.
                         * @member {string} model
                         * @memberof google.cloud.vision.v1.Feature
                         * @instance
                         */
                        Feature.prototype.model = "";
    
                        /**
                         * Creates a new Feature instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.Feature
                         * @static
                         * @param {google.cloud.vision.v1.IFeature=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.Feature} Feature instance
                         */
                        Feature.create = function create(properties) {
                            return new Feature(properties);
                        };
    
                        /**
                         * Encodes the specified Feature message. Does not implicitly {@link google.cloud.vision.v1.Feature.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.Feature
                         * @static
                         * @param {google.cloud.vision.v1.IFeature} message Feature message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Feature.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.type);
                            if (message.maxResults != null && Object.hasOwnProperty.call(message, "maxResults"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.maxResults);
                            if (message.model != null && Object.hasOwnProperty.call(message, "model"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.model);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Feature message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Feature.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.Feature
                         * @static
                         * @param {google.cloud.vision.v1.IFeature} message Feature message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Feature.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Feature message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.Feature
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.Feature} Feature
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Feature.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.Feature();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.type = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.maxResults = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.model = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Feature message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.Feature
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.Feature} Feature
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Feature.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Feature message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.Feature
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Feature.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.type != null && message.hasOwnProperty("type"))
                                switch (message.type) {
                                default:
                                    return "type: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 11:
                                case 6:
                                case 7:
                                case 9:
                                case 10:
                                case 12:
                                case 19:
                                    break;
                                }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults"))
                                if (!$util.isInteger(message.maxResults))
                                    return "maxResults: integer expected";
                            if (message.model != null && message.hasOwnProperty("model"))
                                if (!$util.isString(message.model))
                                    return "model: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a Feature message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.Feature
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.Feature} Feature
                         */
                        Feature.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.Feature)
                                return object;
                            var message = new $root.google.cloud.vision.v1.Feature();
                            switch (object.type) {
                            default:
                                if (typeof object.type === "number") {
                                    message.type = object.type;
                                    break;
                                }
                                break;
                            case "TYPE_UNSPECIFIED":
                            case 0:
                                message.type = 0;
                                break;
                            case "FACE_DETECTION":
                            case 1:
                                message.type = 1;
                                break;
                            case "LANDMARK_DETECTION":
                            case 2:
                                message.type = 2;
                                break;
                            case "LOGO_DETECTION":
                            case 3:
                                message.type = 3;
                                break;
                            case "LABEL_DETECTION":
                            case 4:
                                message.type = 4;
                                break;
                            case "TEXT_DETECTION":
                            case 5:
                                message.type = 5;
                                break;
                            case "DOCUMENT_TEXT_DETECTION":
                            case 11:
                                message.type = 11;
                                break;
                            case "SAFE_SEARCH_DETECTION":
                            case 6:
                                message.type = 6;
                                break;
                            case "IMAGE_PROPERTIES":
                            case 7:
                                message.type = 7;
                                break;
                            case "CROP_HINTS":
                            case 9:
                                message.type = 9;
                                break;
                            case "WEB_DETECTION":
                            case 10:
                                message.type = 10;
                                break;
                            case "PRODUCT_SEARCH":
                            case 12:
                                message.type = 12;
                                break;
                            case "OBJECT_LOCALIZATION":
                            case 19:
                                message.type = 19;
                                break;
                            }
                            if (object.maxResults != null)
                                message.maxResults = object.maxResults | 0;
                            if (object.model != null)
                                message.model = String(object.model);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Feature message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.Feature
                         * @static
                         * @param {google.cloud.vision.v1.Feature} message Feature
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Feature.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.type = options.enums === String ? "TYPE_UNSPECIFIED" : 0;
                                object.maxResults = 0;
                                object.model = "";
                            }
                            if (message.type != null && message.hasOwnProperty("type"))
                                object.type = options.enums === String ? $root.google.cloud.vision.v1.Feature.Type[message.type] === undefined ? message.type : $root.google.cloud.vision.v1.Feature.Type[message.type] : message.type;
                            if (message.maxResults != null && message.hasOwnProperty("maxResults"))
                                object.maxResults = message.maxResults;
                            if (message.model != null && message.hasOwnProperty("model"))
                                object.model = message.model;
                            return object;
                        };
    
                        /**
                         * Converts this Feature to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.Feature
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Feature.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Feature
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.Feature
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Feature.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.Feature";
                        };
    
                        /**
                         * Type enum.
                         * @name google.cloud.vision.v1.Feature.Type
                         * @enum {number}
                         * @property {number} TYPE_UNSPECIFIED=0 TYPE_UNSPECIFIED value
                         * @property {number} FACE_DETECTION=1 FACE_DETECTION value
                         * @property {number} LANDMARK_DETECTION=2 LANDMARK_DETECTION value
                         * @property {number} LOGO_DETECTION=3 LOGO_DETECTION value
                         * @property {number} LABEL_DETECTION=4 LABEL_DETECTION value
                         * @property {number} TEXT_DETECTION=5 TEXT_DETECTION value
                         * @property {number} DOCUMENT_TEXT_DETECTION=11 DOCUMENT_TEXT_DETECTION value
                         * @property {number} SAFE_SEARCH_DETECTION=6 SAFE_SEARCH_DETECTION value
                         * @property {number} IMAGE_PROPERTIES=7 IMAGE_PROPERTIES value
                         * @property {number} CROP_HINTS=9 CROP_HINTS value
                         * @property {number} WEB_DETECTION=10 WEB_DETECTION value
                         * @property {number} PRODUCT_SEARCH=12 PRODUCT_SEARCH value
                         * @property {number} OBJECT_LOCALIZATION=19 OBJECT_LOCALIZATION value
                         */
                        Feature.Type = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "TYPE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "FACE_DETECTION"] = 1;
                            values[valuesById[2] = "LANDMARK_DETECTION"] = 2;
                            values[valuesById[3] = "LOGO_DETECTION"] = 3;
                            values[valuesById[4] = "LABEL_DETECTION"] = 4;
                            values[valuesById[5] = "TEXT_DETECTION"] = 5;
                            values[valuesById[11] = "DOCUMENT_TEXT_DETECTION"] = 11;
                            values[valuesById[6] = "SAFE_SEARCH_DETECTION"] = 6;
                            values[valuesById[7] = "IMAGE_PROPERTIES"] = 7;
                            values[valuesById[9] = "CROP_HINTS"] = 9;
                            values[valuesById[10] = "WEB_DETECTION"] = 10;
                            values[valuesById[12] = "PRODUCT_SEARCH"] = 12;
                            values[valuesById[19] = "OBJECT_LOCALIZATION"] = 19;
                            return values;
                        })();
    
                        return Feature;
                    })();
    
                    v1.ImageSource = (function() {
    
                        /**
                         * Properties of an ImageSource.
                         * @memberof google.cloud.vision.v1
                         * @interface IImageSource
                         * @property {string|null} [gcsImageUri] ImageSource gcsImageUri
                         * @property {string|null} [imageUri] ImageSource imageUri
                         */
    
                        /**
                         * Constructs a new ImageSource.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an ImageSource.
                         * @implements IImageSource
                         * @constructor
                         * @param {google.cloud.vision.v1.IImageSource=} [properties] Properties to set
                         */
                        function ImageSource(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ImageSource gcsImageUri.
                         * @member {string} gcsImageUri
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @instance
                         */
                        ImageSource.prototype.gcsImageUri = "";
    
                        /**
                         * ImageSource imageUri.
                         * @member {string} imageUri
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @instance
                         */
                        ImageSource.prototype.imageUri = "";
    
                        /**
                         * Creates a new ImageSource instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @static
                         * @param {google.cloud.vision.v1.IImageSource=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.ImageSource} ImageSource instance
                         */
                        ImageSource.create = function create(properties) {
                            return new ImageSource(properties);
                        };
    
                        /**
                         * Encodes the specified ImageSource message. Does not implicitly {@link google.cloud.vision.v1.ImageSource.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @static
                         * @param {google.cloud.vision.v1.IImageSource} message ImageSource message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImageSource.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.gcsImageUri != null && Object.hasOwnProperty.call(message, "gcsImageUri"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.gcsImageUri);
                            if (message.imageUri != null && Object.hasOwnProperty.call(message, "imageUri"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.imageUri);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ImageSource message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImageSource.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @static
                         * @param {google.cloud.vision.v1.IImageSource} message ImageSource message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImageSource.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ImageSource message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.ImageSource} ImageSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImageSource.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.ImageSource();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.gcsImageUri = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.imageUri = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ImageSource message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.ImageSource} ImageSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImageSource.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ImageSource message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ImageSource.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.gcsImageUri != null && message.hasOwnProperty("gcsImageUri"))
                                if (!$util.isString(message.gcsImageUri))
                                    return "gcsImageUri: string expected";
                            if (message.imageUri != null && message.hasOwnProperty("imageUri"))
                                if (!$util.isString(message.imageUri))
                                    return "imageUri: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an ImageSource message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.ImageSource} ImageSource
                         */
                        ImageSource.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.ImageSource)
                                return object;
                            var message = new $root.google.cloud.vision.v1.ImageSource();
                            if (object.gcsImageUri != null)
                                message.gcsImageUri = String(object.gcsImageUri);
                            if (object.imageUri != null)
                                message.imageUri = String(object.imageUri);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ImageSource message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @static
                         * @param {google.cloud.vision.v1.ImageSource} message ImageSource
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ImageSource.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.gcsImageUri = "";
                                object.imageUri = "";
                            }
                            if (message.gcsImageUri != null && message.hasOwnProperty("gcsImageUri"))
                                object.gcsImageUri = message.gcsImageUri;
                            if (message.imageUri != null && message.hasOwnProperty("imageUri"))
                                object.imageUri = message.imageUri;
                            return object;
                        };
    
                        /**
                         * Converts this ImageSource to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ImageSource.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ImageSource
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.ImageSource
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ImageSource.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.ImageSource";
                        };
    
                        return ImageSource;
                    })();
    
                    v1.Image = (function() {
    
                        /**
                         * Properties of an Image.
                         * @memberof google.cloud.vision.v1
                         * @interface IImage
                         * @property {Uint8Array|null} [content] Image content
                         * @property {google.cloud.vision.v1.IImageSource|null} [source] Image source
                         */
    
                        /**
                         * Constructs a new Image.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an Image.
                         * @implements IImage
                         * @constructor
                         * @param {google.cloud.vision.v1.IImage=} [properties] Properties to set
                         */
                        function Image(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Image content.
                         * @member {Uint8Array} content
                         * @memberof google.cloud.vision.v1.Image
                         * @instance
                         */
                        Image.prototype.content = $util.newBuffer([]);
    
                        /**
                         * Image source.
                         * @member {google.cloud.vision.v1.IImageSource|null|undefined} source
                         * @memberof google.cloud.vision.v1.Image
                         * @instance
                         */
                        Image.prototype.source = null;
    
                        /**
                         * Creates a new Image instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.Image
                         * @static
                         * @param {google.cloud.vision.v1.IImage=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.Image} Image instance
                         */
                        Image.create = function create(properties) {
                            return new Image(properties);
                        };
    
                        /**
                         * Encodes the specified Image message. Does not implicitly {@link google.cloud.vision.v1.Image.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.Image
                         * @static
                         * @param {google.cloud.vision.v1.IImage} message Image message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Image.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.content != null && Object.hasOwnProperty.call(message, "content"))
                                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.content);
                            if (message.source != null && Object.hasOwnProperty.call(message, "source"))
                                $root.google.cloud.vision.v1.ImageSource.encode(message.source, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Image message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Image.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.Image
                         * @static
                         * @param {google.cloud.vision.v1.IImage} message Image message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Image.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an Image message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.Image
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.Image} Image
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Image.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.Image();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.content = reader.bytes();
                                        break;
                                    }
                                case 2: {
                                        message.source = $root.google.cloud.vision.v1.ImageSource.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an Image message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.Image
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.Image} Image
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Image.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an Image message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.Image
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Image.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.content != null && message.hasOwnProperty("content"))
                                if (!(message.content && typeof message.content.length === "number" || $util.isString(message.content)))
                                    return "content: buffer expected";
                            if (message.source != null && message.hasOwnProperty("source")) {
                                var error = $root.google.cloud.vision.v1.ImageSource.verify(message.source);
                                if (error)
                                    return "source." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an Image message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.Image
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.Image} Image
                         */
                        Image.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.Image)
                                return object;
                            var message = new $root.google.cloud.vision.v1.Image();
                            if (object.content != null)
                                if (typeof object.content === "string")
                                    $util.base64.decode(object.content, message.content = $util.newBuffer($util.base64.length(object.content)), 0);
                                else if (object.content.length >= 0)
                                    message.content = object.content;
                            if (object.source != null) {
                                if (typeof object.source !== "object")
                                    throw TypeError(".google.cloud.vision.v1.Image.source: object expected");
                                message.source = $root.google.cloud.vision.v1.ImageSource.fromObject(object.source);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an Image message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.Image
                         * @static
                         * @param {google.cloud.vision.v1.Image} message Image
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Image.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                if (options.bytes === String)
                                    object.content = "";
                                else {
                                    object.content = [];
                                    if (options.bytes !== Array)
                                        object.content = $util.newBuffer(object.content);
                                }
                                object.source = null;
                            }
                            if (message.content != null && message.hasOwnProperty("content"))
                                object.content = options.bytes === String ? $util.base64.encode(message.content, 0, message.content.length) : options.bytes === Array ? Array.prototype.slice.call(message.content) : message.content;
                            if (message.source != null && message.hasOwnProperty("source"))
                                object.source = $root.google.cloud.vision.v1.ImageSource.toObject(message.source, options);
                            return object;
                        };
    
                        /**
                         * Converts this Image to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.Image
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Image.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Image
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.Image
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Image.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.Image";
                        };
    
                        return Image;
                    })();
    
                    v1.FaceAnnotation = (function() {
    
                        /**
                         * Properties of a FaceAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @interface IFaceAnnotation
                         * @property {google.cloud.vision.v1.IBoundingPoly|null} [boundingPoly] FaceAnnotation boundingPoly
                         * @property {google.cloud.vision.v1.IBoundingPoly|null} [fdBoundingPoly] FaceAnnotation fdBoundingPoly
                         * @property {Array.<google.cloud.vision.v1.FaceAnnotation.ILandmark>|null} [landmarks] FaceAnnotation landmarks
                         * @property {number|null} [rollAngle] FaceAnnotation rollAngle
                         * @property {number|null} [panAngle] FaceAnnotation panAngle
                         * @property {number|null} [tiltAngle] FaceAnnotation tiltAngle
                         * @property {number|null} [detectionConfidence] FaceAnnotation detectionConfidence
                         * @property {number|null} [landmarkingConfidence] FaceAnnotation landmarkingConfidence
                         * @property {google.cloud.vision.v1.Likelihood|null} [joyLikelihood] FaceAnnotation joyLikelihood
                         * @property {google.cloud.vision.v1.Likelihood|null} [sorrowLikelihood] FaceAnnotation sorrowLikelihood
                         * @property {google.cloud.vision.v1.Likelihood|null} [angerLikelihood] FaceAnnotation angerLikelihood
                         * @property {google.cloud.vision.v1.Likelihood|null} [surpriseLikelihood] FaceAnnotation surpriseLikelihood
                         * @property {google.cloud.vision.v1.Likelihood|null} [underExposedLikelihood] FaceAnnotation underExposedLikelihood
                         * @property {google.cloud.vision.v1.Likelihood|null} [blurredLikelihood] FaceAnnotation blurredLikelihood
                         * @property {google.cloud.vision.v1.Likelihood|null} [headwearLikelihood] FaceAnnotation headwearLikelihood
                         */
    
                        /**
                         * Constructs a new FaceAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a FaceAnnotation.
                         * @implements IFaceAnnotation
                         * @constructor
                         * @param {google.cloud.vision.v1.IFaceAnnotation=} [properties] Properties to set
                         */
                        function FaceAnnotation(properties) {
                            this.landmarks = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * FaceAnnotation boundingPoly.
                         * @member {google.cloud.vision.v1.IBoundingPoly|null|undefined} boundingPoly
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.boundingPoly = null;
    
                        /**
                         * FaceAnnotation fdBoundingPoly.
                         * @member {google.cloud.vision.v1.IBoundingPoly|null|undefined} fdBoundingPoly
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.fdBoundingPoly = null;
    
                        /**
                         * FaceAnnotation landmarks.
                         * @member {Array.<google.cloud.vision.v1.FaceAnnotation.ILandmark>} landmarks
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.landmarks = $util.emptyArray;
    
                        /**
                         * FaceAnnotation rollAngle.
                         * @member {number} rollAngle
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.rollAngle = 0;
    
                        /**
                         * FaceAnnotation panAngle.
                         * @member {number} panAngle
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.panAngle = 0;
    
                        /**
                         * FaceAnnotation tiltAngle.
                         * @member {number} tiltAngle
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.tiltAngle = 0;
    
                        /**
                         * FaceAnnotation detectionConfidence.
                         * @member {number} detectionConfidence
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.detectionConfidence = 0;
    
                        /**
                         * FaceAnnotation landmarkingConfidence.
                         * @member {number} landmarkingConfidence
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.landmarkingConfidence = 0;
    
                        /**
                         * FaceAnnotation joyLikelihood.
                         * @member {google.cloud.vision.v1.Likelihood} joyLikelihood
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.joyLikelihood = 0;
    
                        /**
                         * FaceAnnotation sorrowLikelihood.
                         * @member {google.cloud.vision.v1.Likelihood} sorrowLikelihood
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.sorrowLikelihood = 0;
    
                        /**
                         * FaceAnnotation angerLikelihood.
                         * @member {google.cloud.vision.v1.Likelihood} angerLikelihood
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.angerLikelihood = 0;
    
                        /**
                         * FaceAnnotation surpriseLikelihood.
                         * @member {google.cloud.vision.v1.Likelihood} surpriseLikelihood
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.surpriseLikelihood = 0;
    
                        /**
                         * FaceAnnotation underExposedLikelihood.
                         * @member {google.cloud.vision.v1.Likelihood} underExposedLikelihood
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.underExposedLikelihood = 0;
    
                        /**
                         * FaceAnnotation blurredLikelihood.
                         * @member {google.cloud.vision.v1.Likelihood} blurredLikelihood
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.blurredLikelihood = 0;
    
                        /**
                         * FaceAnnotation headwearLikelihood.
                         * @member {google.cloud.vision.v1.Likelihood} headwearLikelihood
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         */
                        FaceAnnotation.prototype.headwearLikelihood = 0;
    
                        /**
                         * Creates a new FaceAnnotation instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.IFaceAnnotation=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.FaceAnnotation} FaceAnnotation instance
                         */
                        FaceAnnotation.create = function create(properties) {
                            return new FaceAnnotation(properties);
                        };
    
                        /**
                         * Encodes the specified FaceAnnotation message. Does not implicitly {@link google.cloud.vision.v1.FaceAnnotation.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.IFaceAnnotation} message FaceAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FaceAnnotation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.boundingPoly != null && Object.hasOwnProperty.call(message, "boundingPoly"))
                                $root.google.cloud.vision.v1.BoundingPoly.encode(message.boundingPoly, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.fdBoundingPoly != null && Object.hasOwnProperty.call(message, "fdBoundingPoly"))
                                $root.google.cloud.vision.v1.BoundingPoly.encode(message.fdBoundingPoly, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.landmarks != null && message.landmarks.length)
                                for (var i = 0; i < message.landmarks.length; ++i)
                                    $root.google.cloud.vision.v1.FaceAnnotation.Landmark.encode(message.landmarks[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.rollAngle != null && Object.hasOwnProperty.call(message, "rollAngle"))
                                writer.uint32(/* id 4, wireType 5 =*/37).float(message.rollAngle);
                            if (message.panAngle != null && Object.hasOwnProperty.call(message, "panAngle"))
                                writer.uint32(/* id 5, wireType 5 =*/45).float(message.panAngle);
                            if (message.tiltAngle != null && Object.hasOwnProperty.call(message, "tiltAngle"))
                                writer.uint32(/* id 6, wireType 5 =*/53).float(message.tiltAngle);
                            if (message.detectionConfidence != null && Object.hasOwnProperty.call(message, "detectionConfidence"))
                                writer.uint32(/* id 7, wireType 5 =*/61).float(message.detectionConfidence);
                            if (message.landmarkingConfidence != null && Object.hasOwnProperty.call(message, "landmarkingConfidence"))
                                writer.uint32(/* id 8, wireType 5 =*/69).float(message.landmarkingConfidence);
                            if (message.joyLikelihood != null && Object.hasOwnProperty.call(message, "joyLikelihood"))
                                writer.uint32(/* id 9, wireType 0 =*/72).int32(message.joyLikelihood);
                            if (message.sorrowLikelihood != null && Object.hasOwnProperty.call(message, "sorrowLikelihood"))
                                writer.uint32(/* id 10, wireType 0 =*/80).int32(message.sorrowLikelihood);
                            if (message.angerLikelihood != null && Object.hasOwnProperty.call(message, "angerLikelihood"))
                                writer.uint32(/* id 11, wireType 0 =*/88).int32(message.angerLikelihood);
                            if (message.surpriseLikelihood != null && Object.hasOwnProperty.call(message, "surpriseLikelihood"))
                                writer.uint32(/* id 12, wireType 0 =*/96).int32(message.surpriseLikelihood);
                            if (message.underExposedLikelihood != null && Object.hasOwnProperty.call(message, "underExposedLikelihood"))
                                writer.uint32(/* id 13, wireType 0 =*/104).int32(message.underExposedLikelihood);
                            if (message.blurredLikelihood != null && Object.hasOwnProperty.call(message, "blurredLikelihood"))
                                writer.uint32(/* id 14, wireType 0 =*/112).int32(message.blurredLikelihood);
                            if (message.headwearLikelihood != null && Object.hasOwnProperty.call(message, "headwearLikelihood"))
                                writer.uint32(/* id 15, wireType 0 =*/120).int32(message.headwearLikelihood);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified FaceAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.FaceAnnotation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.IFaceAnnotation} message FaceAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FaceAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a FaceAnnotation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.FaceAnnotation} FaceAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FaceAnnotation.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.FaceAnnotation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.fdBoundingPoly = $root.google.cloud.vision.v1.BoundingPoly.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        if (!(message.landmarks && message.landmarks.length))
                                            message.landmarks = [];
                                        message.landmarks.push($root.google.cloud.vision.v1.FaceAnnotation.Landmark.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 4: {
                                        message.rollAngle = reader.float();
                                        break;
                                    }
                                case 5: {
                                        message.panAngle = reader.float();
                                        break;
                                    }
                                case 6: {
                                        message.tiltAngle = reader.float();
                                        break;
                                    }
                                case 7: {
                                        message.detectionConfidence = reader.float();
                                        break;
                                    }
                                case 8: {
                                        message.landmarkingConfidence = reader.float();
                                        break;
                                    }
                                case 9: {
                                        message.joyLikelihood = reader.int32();
                                        break;
                                    }
                                case 10: {
                                        message.sorrowLikelihood = reader.int32();
                                        break;
                                    }
                                case 11: {
                                        message.angerLikelihood = reader.int32();
                                        break;
                                    }
                                case 12: {
                                        message.surpriseLikelihood = reader.int32();
                                        break;
                                    }
                                case 13: {
                                        message.underExposedLikelihood = reader.int32();
                                        break;
                                    }
                                case 14: {
                                        message.blurredLikelihood = reader.int32();
                                        break;
                                    }
                                case 15: {
                                        message.headwearLikelihood = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a FaceAnnotation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.FaceAnnotation} FaceAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FaceAnnotation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a FaceAnnotation message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        FaceAnnotation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly")) {
                                var error = $root.google.cloud.vision.v1.BoundingPoly.verify(message.boundingPoly);
                                if (error)
                                    return "boundingPoly." + error;
                            }
                            if (message.fdBoundingPoly != null && message.hasOwnProperty("fdBoundingPoly")) {
                                var error = $root.google.cloud.vision.v1.BoundingPoly.verify(message.fdBoundingPoly);
                                if (error)
                                    return "fdBoundingPoly." + error;
                            }
                            if (message.landmarks != null && message.hasOwnProperty("landmarks")) {
                                if (!Array.isArray(message.landmarks))
                                    return "landmarks: array expected";
                                for (var i = 0; i < message.landmarks.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.FaceAnnotation.Landmark.verify(message.landmarks[i]);
                                    if (error)
                                        return "landmarks." + error;
                                }
                            }
                            if (message.rollAngle != null && message.hasOwnProperty("rollAngle"))
                                if (typeof message.rollAngle !== "number")
                                    return "rollAngle: number expected";
                            if (message.panAngle != null && message.hasOwnProperty("panAngle"))
                                if (typeof message.panAngle !== "number")
                                    return "panAngle: number expected";
                            if (message.tiltAngle != null && message.hasOwnProperty("tiltAngle"))
                                if (typeof message.tiltAngle !== "number")
                                    return "tiltAngle: number expected";
                            if (message.detectionConfidence != null && message.hasOwnProperty("detectionConfidence"))
                                if (typeof message.detectionConfidence !== "number")
                                    return "detectionConfidence: number expected";
                            if (message.landmarkingConfidence != null && message.hasOwnProperty("landmarkingConfidence"))
                                if (typeof message.landmarkingConfidence !== "number")
                                    return "landmarkingConfidence: number expected";
                            if (message.joyLikelihood != null && message.hasOwnProperty("joyLikelihood"))
                                switch (message.joyLikelihood) {
                                default:
                                    return "joyLikelihood: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.sorrowLikelihood != null && message.hasOwnProperty("sorrowLikelihood"))
                                switch (message.sorrowLikelihood) {
                                default:
                                    return "sorrowLikelihood: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.angerLikelihood != null && message.hasOwnProperty("angerLikelihood"))
                                switch (message.angerLikelihood) {
                                default:
                                    return "angerLikelihood: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.surpriseLikelihood != null && message.hasOwnProperty("surpriseLikelihood"))
                                switch (message.surpriseLikelihood) {
                                default:
                                    return "surpriseLikelihood: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.underExposedLikelihood != null && message.hasOwnProperty("underExposedLikelihood"))
                                switch (message.underExposedLikelihood) {
                                default:
                                    return "underExposedLikelihood: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.blurredLikelihood != null && message.hasOwnProperty("blurredLikelihood"))
                                switch (message.blurredLikelihood) {
                                default:
                                    return "blurredLikelihood: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.headwearLikelihood != null && message.hasOwnProperty("headwearLikelihood"))
                                switch (message.headwearLikelihood) {
                                default:
                                    return "headwearLikelihood: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a FaceAnnotation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.FaceAnnotation} FaceAnnotation
                         */
                        FaceAnnotation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.FaceAnnotation)
                                return object;
                            var message = new $root.google.cloud.vision.v1.FaceAnnotation();
                            if (object.boundingPoly != null) {
                                if (typeof object.boundingPoly !== "object")
                                    throw TypeError(".google.cloud.vision.v1.FaceAnnotation.boundingPoly: object expected");
                                message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.fromObject(object.boundingPoly);
                            }
                            if (object.fdBoundingPoly != null) {
                                if (typeof object.fdBoundingPoly !== "object")
                                    throw TypeError(".google.cloud.vision.v1.FaceAnnotation.fdBoundingPoly: object expected");
                                message.fdBoundingPoly = $root.google.cloud.vision.v1.BoundingPoly.fromObject(object.fdBoundingPoly);
                            }
                            if (object.landmarks) {
                                if (!Array.isArray(object.landmarks))
                                    throw TypeError(".google.cloud.vision.v1.FaceAnnotation.landmarks: array expected");
                                message.landmarks = [];
                                for (var i = 0; i < object.landmarks.length; ++i) {
                                    if (typeof object.landmarks[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.FaceAnnotation.landmarks: object expected");
                                    message.landmarks[i] = $root.google.cloud.vision.v1.FaceAnnotation.Landmark.fromObject(object.landmarks[i]);
                                }
                            }
                            if (object.rollAngle != null)
                                message.rollAngle = Number(object.rollAngle);
                            if (object.panAngle != null)
                                message.panAngle = Number(object.panAngle);
                            if (object.tiltAngle != null)
                                message.tiltAngle = Number(object.tiltAngle);
                            if (object.detectionConfidence != null)
                                message.detectionConfidence = Number(object.detectionConfidence);
                            if (object.landmarkingConfidence != null)
                                message.landmarkingConfidence = Number(object.landmarkingConfidence);
                            switch (object.joyLikelihood) {
                            default:
                                if (typeof object.joyLikelihood === "number") {
                                    message.joyLikelihood = object.joyLikelihood;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.joyLikelihood = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.joyLikelihood = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.joyLikelihood = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.joyLikelihood = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.joyLikelihood = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.joyLikelihood = 5;
                                break;
                            }
                            switch (object.sorrowLikelihood) {
                            default:
                                if (typeof object.sorrowLikelihood === "number") {
                                    message.sorrowLikelihood = object.sorrowLikelihood;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.sorrowLikelihood = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.sorrowLikelihood = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.sorrowLikelihood = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.sorrowLikelihood = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.sorrowLikelihood = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.sorrowLikelihood = 5;
                                break;
                            }
                            switch (object.angerLikelihood) {
                            default:
                                if (typeof object.angerLikelihood === "number") {
                                    message.angerLikelihood = object.angerLikelihood;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.angerLikelihood = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.angerLikelihood = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.angerLikelihood = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.angerLikelihood = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.angerLikelihood = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.angerLikelihood = 5;
                                break;
                            }
                            switch (object.surpriseLikelihood) {
                            default:
                                if (typeof object.surpriseLikelihood === "number") {
                                    message.surpriseLikelihood = object.surpriseLikelihood;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.surpriseLikelihood = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.surpriseLikelihood = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.surpriseLikelihood = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.surpriseLikelihood = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.surpriseLikelihood = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.surpriseLikelihood = 5;
                                break;
                            }
                            switch (object.underExposedLikelihood) {
                            default:
                                if (typeof object.underExposedLikelihood === "number") {
                                    message.underExposedLikelihood = object.underExposedLikelihood;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.underExposedLikelihood = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.underExposedLikelihood = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.underExposedLikelihood = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.underExposedLikelihood = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.underExposedLikelihood = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.underExposedLikelihood = 5;
                                break;
                            }
                            switch (object.blurredLikelihood) {
                            default:
                                if (typeof object.blurredLikelihood === "number") {
                                    message.blurredLikelihood = object.blurredLikelihood;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.blurredLikelihood = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.blurredLikelihood = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.blurredLikelihood = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.blurredLikelihood = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.blurredLikelihood = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.blurredLikelihood = 5;
                                break;
                            }
                            switch (object.headwearLikelihood) {
                            default:
                                if (typeof object.headwearLikelihood === "number") {
                                    message.headwearLikelihood = object.headwearLikelihood;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.headwearLikelihood = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.headwearLikelihood = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.headwearLikelihood = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.headwearLikelihood = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.headwearLikelihood = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.headwearLikelihood = 5;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a FaceAnnotation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.FaceAnnotation} message FaceAnnotation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        FaceAnnotation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.landmarks = [];
                            if (options.defaults) {
                                object.boundingPoly = null;
                                object.fdBoundingPoly = null;
                                object.rollAngle = 0;
                                object.panAngle = 0;
                                object.tiltAngle = 0;
                                object.detectionConfidence = 0;
                                object.landmarkingConfidence = 0;
                                object.joyLikelihood = options.enums === String ? "UNKNOWN" : 0;
                                object.sorrowLikelihood = options.enums === String ? "UNKNOWN" : 0;
                                object.angerLikelihood = options.enums === String ? "UNKNOWN" : 0;
                                object.surpriseLikelihood = options.enums === String ? "UNKNOWN" : 0;
                                object.underExposedLikelihood = options.enums === String ? "UNKNOWN" : 0;
                                object.blurredLikelihood = options.enums === String ? "UNKNOWN" : 0;
                                object.headwearLikelihood = options.enums === String ? "UNKNOWN" : 0;
                            }
                            if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly"))
                                object.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.toObject(message.boundingPoly, options);
                            if (message.fdBoundingPoly != null && message.hasOwnProperty("fdBoundingPoly"))
                                object.fdBoundingPoly = $root.google.cloud.vision.v1.BoundingPoly.toObject(message.fdBoundingPoly, options);
                            if (message.landmarks && message.landmarks.length) {
                                object.landmarks = [];
                                for (var j = 0; j < message.landmarks.length; ++j)
                                    object.landmarks[j] = $root.google.cloud.vision.v1.FaceAnnotation.Landmark.toObject(message.landmarks[j], options);
                            }
                            if (message.rollAngle != null && message.hasOwnProperty("rollAngle"))
                                object.rollAngle = options.json && !isFinite(message.rollAngle) ? String(message.rollAngle) : message.rollAngle;
                            if (message.panAngle != null && message.hasOwnProperty("panAngle"))
                                object.panAngle = options.json && !isFinite(message.panAngle) ? String(message.panAngle) : message.panAngle;
                            if (message.tiltAngle != null && message.hasOwnProperty("tiltAngle"))
                                object.tiltAngle = options.json && !isFinite(message.tiltAngle) ? String(message.tiltAngle) : message.tiltAngle;
                            if (message.detectionConfidence != null && message.hasOwnProperty("detectionConfidence"))
                                object.detectionConfidence = options.json && !isFinite(message.detectionConfidence) ? String(message.detectionConfidence) : message.detectionConfidence;
                            if (message.landmarkingConfidence != null && message.hasOwnProperty("landmarkingConfidence"))
                                object.landmarkingConfidence = options.json && !isFinite(message.landmarkingConfidence) ? String(message.landmarkingConfidence) : message.landmarkingConfidence;
                            if (message.joyLikelihood != null && message.hasOwnProperty("joyLikelihood"))
                                object.joyLikelihood = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.joyLikelihood] === undefined ? message.joyLikelihood : $root.google.cloud.vision.v1.Likelihood[message.joyLikelihood] : message.joyLikelihood;
                            if (message.sorrowLikelihood != null && message.hasOwnProperty("sorrowLikelihood"))
                                object.sorrowLikelihood = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.sorrowLikelihood] === undefined ? message.sorrowLikelihood : $root.google.cloud.vision.v1.Likelihood[message.sorrowLikelihood] : message.sorrowLikelihood;
                            if (message.angerLikelihood != null && message.hasOwnProperty("angerLikelihood"))
                                object.angerLikelihood = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.angerLikelihood] === undefined ? message.angerLikelihood : $root.google.cloud.vision.v1.Likelihood[message.angerLikelihood] : message.angerLikelihood;
                            if (message.surpriseLikelihood != null && message.hasOwnProperty("surpriseLikelihood"))
                                object.surpriseLikelihood = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.surpriseLikelihood] === undefined ? message.surpriseLikelihood : $root.google.cloud.vision.v1.Likelihood[message.surpriseLikelihood] : message.surpriseLikelihood;
                            if (message.underExposedLikelihood != null && message.hasOwnProperty("underExposedLikelihood"))
                                object.underExposedLikelihood = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.underExposedLikelihood] === undefined ? message.underExposedLikelihood : $root.google.cloud.vision.v1.Likelihood[message.underExposedLikelihood] : message.underExposedLikelihood;
                            if (message.blurredLikelihood != null && message.hasOwnProperty("blurredLikelihood"))
                                object.blurredLikelihood = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.blurredLikelihood] === undefined ? message.blurredLikelihood : $root.google.cloud.vision.v1.Likelihood[message.blurredLikelihood] : message.blurredLikelihood;
                            if (message.headwearLikelihood != null && message.hasOwnProperty("headwearLikelihood"))
                                object.headwearLikelihood = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.headwearLikelihood] === undefined ? message.headwearLikelihood : $root.google.cloud.vision.v1.Likelihood[message.headwearLikelihood] : message.headwearLikelihood;
                            return object;
                        };
    
                        /**
                         * Converts this FaceAnnotation to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        FaceAnnotation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for FaceAnnotation
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.FaceAnnotation
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        FaceAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.FaceAnnotation";
                        };
    
                        FaceAnnotation.Landmark = (function() {
    
                            /**
                             * Properties of a Landmark.
                             * @memberof google.cloud.vision.v1.FaceAnnotation
                             * @interface ILandmark
                             * @property {google.cloud.vision.v1.FaceAnnotation.Landmark.Type|null} [type] Landmark type
                             * @property {google.cloud.vision.v1.IPosition|null} [position] Landmark position
                             */
    
                            /**
                             * Constructs a new Landmark.
                             * @memberof google.cloud.vision.v1.FaceAnnotation
                             * @classdesc Represents a Landmark.
                             * @implements ILandmark
                             * @constructor
                             * @param {google.cloud.vision.v1.FaceAnnotation.ILandmark=} [properties] Properties to set
                             */
                            function Landmark(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * Landmark type.
                             * @member {google.cloud.vision.v1.FaceAnnotation.Landmark.Type} type
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @instance
                             */
                            Landmark.prototype.type = 0;
    
                            /**
                             * Landmark position.
                             * @member {google.cloud.vision.v1.IPosition|null|undefined} position
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @instance
                             */
                            Landmark.prototype.position = null;
    
                            /**
                             * Creates a new Landmark instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @static
                             * @param {google.cloud.vision.v1.FaceAnnotation.ILandmark=} [properties] Properties to set
                             * @returns {google.cloud.vision.v1.FaceAnnotation.Landmark} Landmark instance
                             */
                            Landmark.create = function create(properties) {
                                return new Landmark(properties);
                            };
    
                            /**
                             * Encodes the specified Landmark message. Does not implicitly {@link google.cloud.vision.v1.FaceAnnotation.Landmark.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @static
                             * @param {google.cloud.vision.v1.FaceAnnotation.ILandmark} message Landmark message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            Landmark.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                                    writer.uint32(/* id 3, wireType 0 =*/24).int32(message.type);
                                if (message.position != null && Object.hasOwnProperty.call(message, "position"))
                                    $root.google.cloud.vision.v1.Position.encode(message.position, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified Landmark message, length delimited. Does not implicitly {@link google.cloud.vision.v1.FaceAnnotation.Landmark.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @static
                             * @param {google.cloud.vision.v1.FaceAnnotation.ILandmark} message Landmark message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            Landmark.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a Landmark message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.vision.v1.FaceAnnotation.Landmark} Landmark
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            Landmark.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.FaceAnnotation.Landmark();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 3: {
                                            message.type = reader.int32();
                                            break;
                                        }
                                    case 4: {
                                            message.position = $root.google.cloud.vision.v1.Position.decode(reader, reader.uint32());
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a Landmark message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.vision.v1.FaceAnnotation.Landmark} Landmark
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            Landmark.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a Landmark message.
                             * @function verify
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            Landmark.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.type != null && message.hasOwnProperty("type"))
                                    switch (message.type) {
                                    default:
                                        return "type: enum value expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 10:
                                    case 11:
                                    case 12:
                                    case 13:
                                    case 14:
                                    case 15:
                                    case 16:
                                    case 17:
                                    case 18:
                                    case 19:
                                    case 20:
                                    case 21:
                                    case 22:
                                    case 23:
                                    case 24:
                                    case 25:
                                    case 26:
                                    case 27:
                                    case 28:
                                    case 29:
                                    case 30:
                                    case 31:
                                    case 32:
                                    case 33:
                                    case 34:
                                    case 35:
                                    case 36:
                                        break;
                                    }
                                if (message.position != null && message.hasOwnProperty("position")) {
                                    var error = $root.google.cloud.vision.v1.Position.verify(message.position);
                                    if (error)
                                        return "position." + error;
                                }
                                return null;
                            };
    
                            /**
                             * Creates a Landmark message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.vision.v1.FaceAnnotation.Landmark} Landmark
                             */
                            Landmark.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.vision.v1.FaceAnnotation.Landmark)
                                    return object;
                                var message = new $root.google.cloud.vision.v1.FaceAnnotation.Landmark();
                                switch (object.type) {
                                default:
                                    if (typeof object.type === "number") {
                                        message.type = object.type;
                                        break;
                                    }
                                    break;
                                case "UNKNOWN_LANDMARK":
                                case 0:
                                    message.type = 0;
                                    break;
                                case "LEFT_EYE":
                                case 1:
                                    message.type = 1;
                                    break;
                                case "RIGHT_EYE":
                                case 2:
                                    message.type = 2;
                                    break;
                                case "LEFT_OF_LEFT_EYEBROW":
                                case 3:
                                    message.type = 3;
                                    break;
                                case "RIGHT_OF_LEFT_EYEBROW":
                                case 4:
                                    message.type = 4;
                                    break;
                                case "LEFT_OF_RIGHT_EYEBROW":
                                case 5:
                                    message.type = 5;
                                    break;
                                case "RIGHT_OF_RIGHT_EYEBROW":
                                case 6:
                                    message.type = 6;
                                    break;
                                case "MIDPOINT_BETWEEN_EYES":
                                case 7:
                                    message.type = 7;
                                    break;
                                case "NOSE_TIP":
                                case 8:
                                    message.type = 8;
                                    break;
                                case "UPPER_LIP":
                                case 9:
                                    message.type = 9;
                                    break;
                                case "LOWER_LIP":
                                case 10:
                                    message.type = 10;
                                    break;
                                case "MOUTH_LEFT":
                                case 11:
                                    message.type = 11;
                                    break;
                                case "MOUTH_RIGHT":
                                case 12:
                                    message.type = 12;
                                    break;
                                case "MOUTH_CENTER":
                                case 13:
                                    message.type = 13;
                                    break;
                                case "NOSE_BOTTOM_RIGHT":
                                case 14:
                                    message.type = 14;
                                    break;
                                case "NOSE_BOTTOM_LEFT":
                                case 15:
                                    message.type = 15;
                                    break;
                                case "NOSE_BOTTOM_CENTER":
                                case 16:
                                    message.type = 16;
                                    break;
                                case "LEFT_EYE_TOP_BOUNDARY":
                                case 17:
                                    message.type = 17;
                                    break;
                                case "LEFT_EYE_RIGHT_CORNER":
                                case 18:
                                    message.type = 18;
                                    break;
                                case "LEFT_EYE_BOTTOM_BOUNDARY":
                                case 19:
                                    message.type = 19;
                                    break;
                                case "LEFT_EYE_LEFT_CORNER":
                                case 20:
                                    message.type = 20;
                                    break;
                                case "RIGHT_EYE_TOP_BOUNDARY":
                                case 21:
                                    message.type = 21;
                                    break;
                                case "RIGHT_EYE_RIGHT_CORNER":
                                case 22:
                                    message.type = 22;
                                    break;
                                case "RIGHT_EYE_BOTTOM_BOUNDARY":
                                case 23:
                                    message.type = 23;
                                    break;
                                case "RIGHT_EYE_LEFT_CORNER":
                                case 24:
                                    message.type = 24;
                                    break;
                                case "LEFT_EYEBROW_UPPER_MIDPOINT":
                                case 25:
                                    message.type = 25;
                                    break;
                                case "RIGHT_EYEBROW_UPPER_MIDPOINT":
                                case 26:
                                    message.type = 26;
                                    break;
                                case "LEFT_EAR_TRAGION":
                                case 27:
                                    message.type = 27;
                                    break;
                                case "RIGHT_EAR_TRAGION":
                                case 28:
                                    message.type = 28;
                                    break;
                                case "LEFT_EYE_PUPIL":
                                case 29:
                                    message.type = 29;
                                    break;
                                case "RIGHT_EYE_PUPIL":
                                case 30:
                                    message.type = 30;
                                    break;
                                case "FOREHEAD_GLABELLA":
                                case 31:
                                    message.type = 31;
                                    break;
                                case "CHIN_GNATHION":
                                case 32:
                                    message.type = 32;
                                    break;
                                case "CHIN_LEFT_GONION":
                                case 33:
                                    message.type = 33;
                                    break;
                                case "CHIN_RIGHT_GONION":
                                case 34:
                                    message.type = 34;
                                    break;
                                case "LEFT_CHEEK_CENTER":
                                case 35:
                                    message.type = 35;
                                    break;
                                case "RIGHT_CHEEK_CENTER":
                                case 36:
                                    message.type = 36;
                                    break;
                                }
                                if (object.position != null) {
                                    if (typeof object.position !== "object")
                                        throw TypeError(".google.cloud.vision.v1.FaceAnnotation.Landmark.position: object expected");
                                    message.position = $root.google.cloud.vision.v1.Position.fromObject(object.position);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a Landmark message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @static
                             * @param {google.cloud.vision.v1.FaceAnnotation.Landmark} message Landmark
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            Landmark.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.type = options.enums === String ? "UNKNOWN_LANDMARK" : 0;
                                    object.position = null;
                                }
                                if (message.type != null && message.hasOwnProperty("type"))
                                    object.type = options.enums === String ? $root.google.cloud.vision.v1.FaceAnnotation.Landmark.Type[message.type] === undefined ? message.type : $root.google.cloud.vision.v1.FaceAnnotation.Landmark.Type[message.type] : message.type;
                                if (message.position != null && message.hasOwnProperty("position"))
                                    object.position = $root.google.cloud.vision.v1.Position.toObject(message.position, options);
                                return object;
                            };
    
                            /**
                             * Converts this Landmark to JSON.
                             * @function toJSON
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            Landmark.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for Landmark
                             * @function getTypeUrl
                             * @memberof google.cloud.vision.v1.FaceAnnotation.Landmark
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            Landmark.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.vision.v1.FaceAnnotation.Landmark";
                            };
    
                            /**
                             * Type enum.
                             * @name google.cloud.vision.v1.FaceAnnotation.Landmark.Type
                             * @enum {number}
                             * @property {number} UNKNOWN_LANDMARK=0 UNKNOWN_LANDMARK value
                             * @property {number} LEFT_EYE=1 LEFT_EYE value
                             * @property {number} RIGHT_EYE=2 RIGHT_EYE value
                             * @property {number} LEFT_OF_LEFT_EYEBROW=3 LEFT_OF_LEFT_EYEBROW value
                             * @property {number} RIGHT_OF_LEFT_EYEBROW=4 RIGHT_OF_LEFT_EYEBROW value
                             * @property {number} LEFT_OF_RIGHT_EYEBROW=5 LEFT_OF_RIGHT_EYEBROW value
                             * @property {number} RIGHT_OF_RIGHT_EYEBROW=6 RIGHT_OF_RIGHT_EYEBROW value
                             * @property {number} MIDPOINT_BETWEEN_EYES=7 MIDPOINT_BETWEEN_EYES value
                             * @property {number} NOSE_TIP=8 NOSE_TIP value
                             * @property {number} UPPER_LIP=9 UPPER_LIP value
                             * @property {number} LOWER_LIP=10 LOWER_LIP value
                             * @property {number} MOUTH_LEFT=11 MOUTH_LEFT value
                             * @property {number} MOUTH_RIGHT=12 MOUTH_RIGHT value
                             * @property {number} MOUTH_CENTER=13 MOUTH_CENTER value
                             * @property {number} NOSE_BOTTOM_RIGHT=14 NOSE_BOTTOM_RIGHT value
                             * @property {number} NOSE_BOTTOM_LEFT=15 NOSE_BOTTOM_LEFT value
                             * @property {number} NOSE_BOTTOM_CENTER=16 NOSE_BOTTOM_CENTER value
                             * @property {number} LEFT_EYE_TOP_BOUNDARY=17 LEFT_EYE_TOP_BOUNDARY value
                             * @property {number} LEFT_EYE_RIGHT_CORNER=18 LEFT_EYE_RIGHT_CORNER value
                             * @property {number} LEFT_EYE_BOTTOM_BOUNDARY=19 LEFT_EYE_BOTTOM_BOUNDARY value
                             * @property {number} LEFT_EYE_LEFT_CORNER=20 LEFT_EYE_LEFT_CORNER value
                             * @property {number} RIGHT_EYE_TOP_BOUNDARY=21 RIGHT_EYE_TOP_BOUNDARY value
                             * @property {number} RIGHT_EYE_RIGHT_CORNER=22 RIGHT_EYE_RIGHT_CORNER value
                             * @property {number} RIGHT_EYE_BOTTOM_BOUNDARY=23 RIGHT_EYE_BOTTOM_BOUNDARY value
                             * @property {number} RIGHT_EYE_LEFT_CORNER=24 RIGHT_EYE_LEFT_CORNER value
                             * @property {number} LEFT_EYEBROW_UPPER_MIDPOINT=25 LEFT_EYEBROW_UPPER_MIDPOINT value
                             * @property {number} RIGHT_EYEBROW_UPPER_MIDPOINT=26 RIGHT_EYEBROW_UPPER_MIDPOINT value
                             * @property {number} LEFT_EAR_TRAGION=27 LEFT_EAR_TRAGION value
                             * @property {number} RIGHT_EAR_TRAGION=28 RIGHT_EAR_TRAGION value
                             * @property {number} LEFT_EYE_PUPIL=29 LEFT_EYE_PUPIL value
                             * @property {number} RIGHT_EYE_PUPIL=30 RIGHT_EYE_PUPIL value
                             * @property {number} FOREHEAD_GLABELLA=31 FOREHEAD_GLABELLA value
                             * @property {number} CHIN_GNATHION=32 CHIN_GNATHION value
                             * @property {number} CHIN_LEFT_GONION=33 CHIN_LEFT_GONION value
                             * @property {number} CHIN_RIGHT_GONION=34 CHIN_RIGHT_GONION value
                             * @property {number} LEFT_CHEEK_CENTER=35 LEFT_CHEEK_CENTER value
                             * @property {number} RIGHT_CHEEK_CENTER=36 RIGHT_CHEEK_CENTER value
                             */
                            Landmark.Type = (function() {
                                var valuesById = {}, values = Object.create(valuesById);
                                values[valuesById[0] = "UNKNOWN_LANDMARK"] = 0;
                                values[valuesById[1] = "LEFT_EYE"] = 1;
                                values[valuesById[2] = "RIGHT_EYE"] = 2;
                                values[valuesById[3] = "LEFT_OF_LEFT_EYEBROW"] = 3;
                                values[valuesById[4] = "RIGHT_OF_LEFT_EYEBROW"] = 4;
                                values[valuesById[5] = "LEFT_OF_RIGHT_EYEBROW"] = 5;
                                values[valuesById[6] = "RIGHT_OF_RIGHT_EYEBROW"] = 6;
                                values[valuesById[7] = "MIDPOINT_BETWEEN_EYES"] = 7;
                                values[valuesById[8] = "NOSE_TIP"] = 8;
                                values[valuesById[9] = "UPPER_LIP"] = 9;
                                values[valuesById[10] = "LOWER_LIP"] = 10;
                                values[valuesById[11] = "MOUTH_LEFT"] = 11;
                                values[valuesById[12] = "MOUTH_RIGHT"] = 12;
                                values[valuesById[13] = "MOUTH_CENTER"] = 13;
                                values[valuesById[14] = "NOSE_BOTTOM_RIGHT"] = 14;
                                values[valuesById[15] = "NOSE_BOTTOM_LEFT"] = 15;
                                values[valuesById[16] = "NOSE_BOTTOM_CENTER"] = 16;
                                values[valuesById[17] = "LEFT_EYE_TOP_BOUNDARY"] = 17;
                                values[valuesById[18] = "LEFT_EYE_RIGHT_CORNER"] = 18;
                                values[valuesById[19] = "LEFT_EYE_BOTTOM_BOUNDARY"] = 19;
                                values[valuesById[20] = "LEFT_EYE_LEFT_CORNER"] = 20;
                                values[valuesById[21] = "RIGHT_EYE_TOP_BOUNDARY"] = 21;
                                values[valuesById[22] = "RIGHT_EYE_RIGHT_CORNER"] = 22;
                                values[valuesById[23] = "RIGHT_EYE_BOTTOM_BOUNDARY"] = 23;
                                values[valuesById[24] = "RIGHT_EYE_LEFT_CORNER"] = 24;
                                values[valuesById[25] = "LEFT_EYEBROW_UPPER_MIDPOINT"] = 25;
                                values[valuesById[26] = "RIGHT_EYEBROW_UPPER_MIDPOINT"] = 26;
                                values[valuesById[27] = "LEFT_EAR_TRAGION"] = 27;
                                values[valuesById[28] = "RIGHT_EAR_TRAGION"] = 28;
                                values[valuesById[29] = "LEFT_EYE_PUPIL"] = 29;
                                values[valuesById[30] = "RIGHT_EYE_PUPIL"] = 30;
                                values[valuesById[31] = "FOREHEAD_GLABELLA"] = 31;
                                values[valuesById[32] = "CHIN_GNATHION"] = 32;
                                values[valuesById[33] = "CHIN_LEFT_GONION"] = 33;
                                values[valuesById[34] = "CHIN_RIGHT_GONION"] = 34;
                                values[valuesById[35] = "LEFT_CHEEK_CENTER"] = 35;
                                values[valuesById[36] = "RIGHT_CHEEK_CENTER"] = 36;
                                return values;
                            })();
    
                            return Landmark;
                        })();
    
                        return FaceAnnotation;
                    })();
    
                    v1.LocationInfo = (function() {
    
                        /**
                         * Properties of a LocationInfo.
                         * @memberof google.cloud.vision.v1
                         * @interface ILocationInfo
                         * @property {google.type.ILatLng|null} [latLng] LocationInfo latLng
                         */
    
                        /**
                         * Constructs a new LocationInfo.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a LocationInfo.
                         * @implements ILocationInfo
                         * @constructor
                         * @param {google.cloud.vision.v1.ILocationInfo=} [properties] Properties to set
                         */
                        function LocationInfo(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * LocationInfo latLng.
                         * @member {google.type.ILatLng|null|undefined} latLng
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @instance
                         */
                        LocationInfo.prototype.latLng = null;
    
                        /**
                         * Creates a new LocationInfo instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @static
                         * @param {google.cloud.vision.v1.ILocationInfo=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.LocationInfo} LocationInfo instance
                         */
                        LocationInfo.create = function create(properties) {
                            return new LocationInfo(properties);
                        };
    
                        /**
                         * Encodes the specified LocationInfo message. Does not implicitly {@link google.cloud.vision.v1.LocationInfo.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @static
                         * @param {google.cloud.vision.v1.ILocationInfo} message LocationInfo message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        LocationInfo.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.latLng != null && Object.hasOwnProperty.call(message, "latLng"))
                                $root.google.type.LatLng.encode(message.latLng, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified LocationInfo message, length delimited. Does not implicitly {@link google.cloud.vision.v1.LocationInfo.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @static
                         * @param {google.cloud.vision.v1.ILocationInfo} message LocationInfo message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        LocationInfo.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a LocationInfo message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.LocationInfo} LocationInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        LocationInfo.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.LocationInfo();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.latLng = $root.google.type.LatLng.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a LocationInfo message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.LocationInfo} LocationInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        LocationInfo.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a LocationInfo message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        LocationInfo.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.latLng != null && message.hasOwnProperty("latLng")) {
                                var error = $root.google.type.LatLng.verify(message.latLng);
                                if (error)
                                    return "latLng." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a LocationInfo message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.LocationInfo} LocationInfo
                         */
                        LocationInfo.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.LocationInfo)
                                return object;
                            var message = new $root.google.cloud.vision.v1.LocationInfo();
                            if (object.latLng != null) {
                                if (typeof object.latLng !== "object")
                                    throw TypeError(".google.cloud.vision.v1.LocationInfo.latLng: object expected");
                                message.latLng = $root.google.type.LatLng.fromObject(object.latLng);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a LocationInfo message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @static
                         * @param {google.cloud.vision.v1.LocationInfo} message LocationInfo
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        LocationInfo.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.latLng = null;
                            if (message.latLng != null && message.hasOwnProperty("latLng"))
                                object.latLng = $root.google.type.LatLng.toObject(message.latLng, options);
                            return object;
                        };
    
                        /**
                         * Converts this LocationInfo to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        LocationInfo.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for LocationInfo
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.LocationInfo
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        LocationInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.LocationInfo";
                        };
    
                        return LocationInfo;
                    })();
    
                    v1.Property = (function() {
    
                        /**
                         * Properties of a Property.
                         * @memberof google.cloud.vision.v1
                         * @interface IProperty
                         * @property {string|null} [name] Property name
                         * @property {string|null} [value] Property value
                         * @property {number|Long|null} [uint64Value] Property uint64Value
                         */
    
                        /**
                         * Constructs a new Property.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a Property.
                         * @implements IProperty
                         * @constructor
                         * @param {google.cloud.vision.v1.IProperty=} [properties] Properties to set
                         */
                        function Property(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Property name.
                         * @member {string} name
                         * @memberof google.cloud.vision.v1.Property
                         * @instance
                         */
                        Property.prototype.name = "";
    
                        /**
                         * Property value.
                         * @member {string} value
                         * @memberof google.cloud.vision.v1.Property
                         * @instance
                         */
                        Property.prototype.value = "";
    
                        /**
                         * Property uint64Value.
                         * @member {number|Long} uint64Value
                         * @memberof google.cloud.vision.v1.Property
                         * @instance
                         */
                        Property.prototype.uint64Value = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
    
                        /**
                         * Creates a new Property instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.Property
                         * @static
                         * @param {google.cloud.vision.v1.IProperty=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.Property} Property instance
                         */
                        Property.create = function create(properties) {
                            return new Property(properties);
                        };
    
                        /**
                         * Encodes the specified Property message. Does not implicitly {@link google.cloud.vision.v1.Property.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.Property
                         * @static
                         * @param {google.cloud.vision.v1.IProperty} message Property message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Property.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.value != null && Object.hasOwnProperty.call(message, "value"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.value);
                            if (message.uint64Value != null && Object.hasOwnProperty.call(message, "uint64Value"))
                                writer.uint32(/* id 3, wireType 0 =*/24).uint64(message.uint64Value);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Property message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Property.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.Property
                         * @static
                         * @param {google.cloud.vision.v1.IProperty} message Property message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Property.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Property message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.Property
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.Property} Property
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Property.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.Property();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.value = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.uint64Value = reader.uint64();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Property message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.Property
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.Property} Property
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Property.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Property message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.Property
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Property.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.value != null && message.hasOwnProperty("value"))
                                if (!$util.isString(message.value))
                                    return "value: string expected";
                            if (message.uint64Value != null && message.hasOwnProperty("uint64Value"))
                                if (!$util.isInteger(message.uint64Value) && !(message.uint64Value && $util.isInteger(message.uint64Value.low) && $util.isInteger(message.uint64Value.high)))
                                    return "uint64Value: integer|Long expected";
                            return null;
                        };
    
                        /**
                         * Creates a Property message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.Property
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.Property} Property
                         */
                        Property.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.Property)
                                return object;
                            var message = new $root.google.cloud.vision.v1.Property();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.value != null)
                                message.value = String(object.value);
                            if (object.uint64Value != null)
                                if ($util.Long)
                                    (message.uint64Value = $util.Long.fromValue(object.uint64Value)).unsigned = true;
                                else if (typeof object.uint64Value === "string")
                                    message.uint64Value = parseInt(object.uint64Value, 10);
                                else if (typeof object.uint64Value === "number")
                                    message.uint64Value = object.uint64Value;
                                else if (typeof object.uint64Value === "object")
                                    message.uint64Value = new $util.LongBits(object.uint64Value.low >>> 0, object.uint64Value.high >>> 0).toNumber(true);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Property message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.Property
                         * @static
                         * @param {google.cloud.vision.v1.Property} message Property
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Property.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.value = "";
                                if ($util.Long) {
                                    var long = new $util.Long(0, 0, true);
                                    object.uint64Value = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                                } else
                                    object.uint64Value = options.longs === String ? "0" : 0;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.value != null && message.hasOwnProperty("value"))
                                object.value = message.value;
                            if (message.uint64Value != null && message.hasOwnProperty("uint64Value"))
                                if (typeof message.uint64Value === "number")
                                    object.uint64Value = options.longs === String ? String(message.uint64Value) : message.uint64Value;
                                else
                                    object.uint64Value = options.longs === String ? $util.Long.prototype.toString.call(message.uint64Value) : options.longs === Number ? new $util.LongBits(message.uint64Value.low >>> 0, message.uint64Value.high >>> 0).toNumber(true) : message.uint64Value;
                            return object;
                        };
    
                        /**
                         * Converts this Property to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.Property
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Property.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Property
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.Property
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Property.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.Property";
                        };
    
                        return Property;
                    })();
    
                    v1.EntityAnnotation = (function() {
    
                        /**
                         * Properties of an EntityAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @interface IEntityAnnotation
                         * @property {string|null} [mid] EntityAnnotation mid
                         * @property {string|null} [locale] EntityAnnotation locale
                         * @property {string|null} [description] EntityAnnotation description
                         * @property {number|null} [score] EntityAnnotation score
                         * @property {number|null} [confidence] EntityAnnotation confidence
                         * @property {number|null} [topicality] EntityAnnotation topicality
                         * @property {google.cloud.vision.v1.IBoundingPoly|null} [boundingPoly] EntityAnnotation boundingPoly
                         * @property {Array.<google.cloud.vision.v1.ILocationInfo>|null} [locations] EntityAnnotation locations
                         * @property {Array.<google.cloud.vision.v1.IProperty>|null} [properties] EntityAnnotation properties
                         */
    
                        /**
                         * Constructs a new EntityAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an EntityAnnotation.
                         * @implements IEntityAnnotation
                         * @constructor
                         * @param {google.cloud.vision.v1.IEntityAnnotation=} [properties] Properties to set
                         */
                        function EntityAnnotation(properties) {
                            this.locations = [];
                            this.properties = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * EntityAnnotation mid.
                         * @member {string} mid
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @instance
                         */
                        EntityAnnotation.prototype.mid = "";
    
                        /**
                         * EntityAnnotation locale.
                         * @member {string} locale
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @instance
                         */
                        EntityAnnotation.prototype.locale = "";
    
                        /**
                         * EntityAnnotation description.
                         * @member {string} description
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @instance
                         */
                        EntityAnnotation.prototype.description = "";
    
                        /**
                         * EntityAnnotation score.
                         * @member {number} score
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @instance
                         */
                        EntityAnnotation.prototype.score = 0;
    
                        /**
                         * EntityAnnotation confidence.
                         * @member {number} confidence
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @instance
                         */
                        EntityAnnotation.prototype.confidence = 0;
    
                        /**
                         * EntityAnnotation topicality.
                         * @member {number} topicality
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @instance
                         */
                        EntityAnnotation.prototype.topicality = 0;
    
                        /**
                         * EntityAnnotation boundingPoly.
                         * @member {google.cloud.vision.v1.IBoundingPoly|null|undefined} boundingPoly
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @instance
                         */
                        EntityAnnotation.prototype.boundingPoly = null;
    
                        /**
                         * EntityAnnotation locations.
                         * @member {Array.<google.cloud.vision.v1.ILocationInfo>} locations
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @instance
                         */
                        EntityAnnotation.prototype.locations = $util.emptyArray;
    
                        /**
                         * EntityAnnotation properties.
                         * @member {Array.<google.cloud.vision.v1.IProperty>} properties
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @instance
                         */
                        EntityAnnotation.prototype.properties = $util.emptyArray;
    
                        /**
                         * Creates a new EntityAnnotation instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.IEntityAnnotation=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.EntityAnnotation} EntityAnnotation instance
                         */
                        EntityAnnotation.create = function create(properties) {
                            return new EntityAnnotation(properties);
                        };
    
                        /**
                         * Encodes the specified EntityAnnotation message. Does not implicitly {@link google.cloud.vision.v1.EntityAnnotation.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.IEntityAnnotation} message EntityAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EntityAnnotation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.mid != null && Object.hasOwnProperty.call(message, "mid"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.mid);
                            if (message.locale != null && Object.hasOwnProperty.call(message, "locale"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.locale);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.description);
                            if (message.score != null && Object.hasOwnProperty.call(message, "score"))
                                writer.uint32(/* id 4, wireType 5 =*/37).float(message.score);
                            if (message.confidence != null && Object.hasOwnProperty.call(message, "confidence"))
                                writer.uint32(/* id 5, wireType 5 =*/45).float(message.confidence);
                            if (message.topicality != null && Object.hasOwnProperty.call(message, "topicality"))
                                writer.uint32(/* id 6, wireType 5 =*/53).float(message.topicality);
                            if (message.boundingPoly != null && Object.hasOwnProperty.call(message, "boundingPoly"))
                                $root.google.cloud.vision.v1.BoundingPoly.encode(message.boundingPoly, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.locations != null && message.locations.length)
                                for (var i = 0; i < message.locations.length; ++i)
                                    $root.google.cloud.vision.v1.LocationInfo.encode(message.locations[i], writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            if (message.properties != null && message.properties.length)
                                for (var i = 0; i < message.properties.length; ++i)
                                    $root.google.cloud.vision.v1.Property.encode(message.properties[i], writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified EntityAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.EntityAnnotation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.IEntityAnnotation} message EntityAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EntityAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an EntityAnnotation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.EntityAnnotation} EntityAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EntityAnnotation.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.EntityAnnotation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.mid = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.locale = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.description = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.score = reader.float();
                                        break;
                                    }
                                case 5: {
                                        message.confidence = reader.float();
                                        break;
                                    }
                                case 6: {
                                        message.topicality = reader.float();
                                        break;
                                    }
                                case 7: {
                                        message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        if (!(message.locations && message.locations.length))
                                            message.locations = [];
                                        message.locations.push($root.google.cloud.vision.v1.LocationInfo.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 9: {
                                        if (!(message.properties && message.properties.length))
                                            message.properties = [];
                                        message.properties.push($root.google.cloud.vision.v1.Property.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an EntityAnnotation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.EntityAnnotation} EntityAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EntityAnnotation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an EntityAnnotation message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EntityAnnotation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.mid != null && message.hasOwnProperty("mid"))
                                if (!$util.isString(message.mid))
                                    return "mid: string expected";
                            if (message.locale != null && message.hasOwnProperty("locale"))
                                if (!$util.isString(message.locale))
                                    return "locale: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.score != null && message.hasOwnProperty("score"))
                                if (typeof message.score !== "number")
                                    return "score: number expected";
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                if (typeof message.confidence !== "number")
                                    return "confidence: number expected";
                            if (message.topicality != null && message.hasOwnProperty("topicality"))
                                if (typeof message.topicality !== "number")
                                    return "topicality: number expected";
                            if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly")) {
                                var error = $root.google.cloud.vision.v1.BoundingPoly.verify(message.boundingPoly);
                                if (error)
                                    return "boundingPoly." + error;
                            }
                            if (message.locations != null && message.hasOwnProperty("locations")) {
                                if (!Array.isArray(message.locations))
                                    return "locations: array expected";
                                for (var i = 0; i < message.locations.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.LocationInfo.verify(message.locations[i]);
                                    if (error)
                                        return "locations." + error;
                                }
                            }
                            if (message.properties != null && message.hasOwnProperty("properties")) {
                                if (!Array.isArray(message.properties))
                                    return "properties: array expected";
                                for (var i = 0; i < message.properties.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.Property.verify(message.properties[i]);
                                    if (error)
                                        return "properties." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates an EntityAnnotation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.EntityAnnotation} EntityAnnotation
                         */
                        EntityAnnotation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.EntityAnnotation)
                                return object;
                            var message = new $root.google.cloud.vision.v1.EntityAnnotation();
                            if (object.mid != null)
                                message.mid = String(object.mid);
                            if (object.locale != null)
                                message.locale = String(object.locale);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.score != null)
                                message.score = Number(object.score);
                            if (object.confidence != null)
                                message.confidence = Number(object.confidence);
                            if (object.topicality != null)
                                message.topicality = Number(object.topicality);
                            if (object.boundingPoly != null) {
                                if (typeof object.boundingPoly !== "object")
                                    throw TypeError(".google.cloud.vision.v1.EntityAnnotation.boundingPoly: object expected");
                                message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.fromObject(object.boundingPoly);
                            }
                            if (object.locations) {
                                if (!Array.isArray(object.locations))
                                    throw TypeError(".google.cloud.vision.v1.EntityAnnotation.locations: array expected");
                                message.locations = [];
                                for (var i = 0; i < object.locations.length; ++i) {
                                    if (typeof object.locations[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.EntityAnnotation.locations: object expected");
                                    message.locations[i] = $root.google.cloud.vision.v1.LocationInfo.fromObject(object.locations[i]);
                                }
                            }
                            if (object.properties) {
                                if (!Array.isArray(object.properties))
                                    throw TypeError(".google.cloud.vision.v1.EntityAnnotation.properties: array expected");
                                message.properties = [];
                                for (var i = 0; i < object.properties.length; ++i) {
                                    if (typeof object.properties[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.EntityAnnotation.properties: object expected");
                                    message.properties[i] = $root.google.cloud.vision.v1.Property.fromObject(object.properties[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an EntityAnnotation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.EntityAnnotation} message EntityAnnotation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EntityAnnotation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.locations = [];
                                object.properties = [];
                            }
                            if (options.defaults) {
                                object.mid = "";
                                object.locale = "";
                                object.description = "";
                                object.score = 0;
                                object.confidence = 0;
                                object.topicality = 0;
                                object.boundingPoly = null;
                            }
                            if (message.mid != null && message.hasOwnProperty("mid"))
                                object.mid = message.mid;
                            if (message.locale != null && message.hasOwnProperty("locale"))
                                object.locale = message.locale;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.score != null && message.hasOwnProperty("score"))
                                object.score = options.json && !isFinite(message.score) ? String(message.score) : message.score;
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                object.confidence = options.json && !isFinite(message.confidence) ? String(message.confidence) : message.confidence;
                            if (message.topicality != null && message.hasOwnProperty("topicality"))
                                object.topicality = options.json && !isFinite(message.topicality) ? String(message.topicality) : message.topicality;
                            if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly"))
                                object.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.toObject(message.boundingPoly, options);
                            if (message.locations && message.locations.length) {
                                object.locations = [];
                                for (var j = 0; j < message.locations.length; ++j)
                                    object.locations[j] = $root.google.cloud.vision.v1.LocationInfo.toObject(message.locations[j], options);
                            }
                            if (message.properties && message.properties.length) {
                                object.properties = [];
                                for (var j = 0; j < message.properties.length; ++j)
                                    object.properties[j] = $root.google.cloud.vision.v1.Property.toObject(message.properties[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this EntityAnnotation to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EntityAnnotation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for EntityAnnotation
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.EntityAnnotation
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        EntityAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.EntityAnnotation";
                        };
    
                        return EntityAnnotation;
                    })();
    
                    v1.LocalizedObjectAnnotation = (function() {
    
                        /**
                         * Properties of a LocalizedObjectAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @interface ILocalizedObjectAnnotation
                         * @property {string|null} [mid] LocalizedObjectAnnotation mid
                         * @property {string|null} [languageCode] LocalizedObjectAnnotation languageCode
                         * @property {string|null} [name] LocalizedObjectAnnotation name
                         * @property {number|null} [score] LocalizedObjectAnnotation score
                         * @property {google.cloud.vision.v1.IBoundingPoly|null} [boundingPoly] LocalizedObjectAnnotation boundingPoly
                         */
    
                        /**
                         * Constructs a new LocalizedObjectAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a LocalizedObjectAnnotation.
                         * @implements ILocalizedObjectAnnotation
                         * @constructor
                         * @param {google.cloud.vision.v1.ILocalizedObjectAnnotation=} [properties] Properties to set
                         */
                        function LocalizedObjectAnnotation(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * LocalizedObjectAnnotation mid.
                         * @member {string} mid
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @instance
                         */
                        LocalizedObjectAnnotation.prototype.mid = "";
    
                        /**
                         * LocalizedObjectAnnotation languageCode.
                         * @member {string} languageCode
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @instance
                         */
                        LocalizedObjectAnnotation.prototype.languageCode = "";
    
                        /**
                         * LocalizedObjectAnnotation name.
                         * @member {string} name
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @instance
                         */
                        LocalizedObjectAnnotation.prototype.name = "";
    
                        /**
                         * LocalizedObjectAnnotation score.
                         * @member {number} score
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @instance
                         */
                        LocalizedObjectAnnotation.prototype.score = 0;
    
                        /**
                         * LocalizedObjectAnnotation boundingPoly.
                         * @member {google.cloud.vision.v1.IBoundingPoly|null|undefined} boundingPoly
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @instance
                         */
                        LocalizedObjectAnnotation.prototype.boundingPoly = null;
    
                        /**
                         * Creates a new LocalizedObjectAnnotation instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.ILocalizedObjectAnnotation=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.LocalizedObjectAnnotation} LocalizedObjectAnnotation instance
                         */
                        LocalizedObjectAnnotation.create = function create(properties) {
                            return new LocalizedObjectAnnotation(properties);
                        };
    
                        /**
                         * Encodes the specified LocalizedObjectAnnotation message. Does not implicitly {@link google.cloud.vision.v1.LocalizedObjectAnnotation.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.ILocalizedObjectAnnotation} message LocalizedObjectAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        LocalizedObjectAnnotation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.mid != null && Object.hasOwnProperty.call(message, "mid"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.mid);
                            if (message.languageCode != null && Object.hasOwnProperty.call(message, "languageCode"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.languageCode);
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.name);
                            if (message.score != null && Object.hasOwnProperty.call(message, "score"))
                                writer.uint32(/* id 4, wireType 5 =*/37).float(message.score);
                            if (message.boundingPoly != null && Object.hasOwnProperty.call(message, "boundingPoly"))
                                $root.google.cloud.vision.v1.BoundingPoly.encode(message.boundingPoly, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified LocalizedObjectAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.LocalizedObjectAnnotation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.ILocalizedObjectAnnotation} message LocalizedObjectAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        LocalizedObjectAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a LocalizedObjectAnnotation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.LocalizedObjectAnnotation} LocalizedObjectAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        LocalizedObjectAnnotation.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.LocalizedObjectAnnotation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.mid = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.languageCode = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.score = reader.float();
                                        break;
                                    }
                                case 5: {
                                        message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a LocalizedObjectAnnotation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.LocalizedObjectAnnotation} LocalizedObjectAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        LocalizedObjectAnnotation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a LocalizedObjectAnnotation message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        LocalizedObjectAnnotation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.mid != null && message.hasOwnProperty("mid"))
                                if (!$util.isString(message.mid))
                                    return "mid: string expected";
                            if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                                if (!$util.isString(message.languageCode))
                                    return "languageCode: string expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.score != null && message.hasOwnProperty("score"))
                                if (typeof message.score !== "number")
                                    return "score: number expected";
                            if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly")) {
                                var error = $root.google.cloud.vision.v1.BoundingPoly.verify(message.boundingPoly);
                                if (error)
                                    return "boundingPoly." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a LocalizedObjectAnnotation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.LocalizedObjectAnnotation} LocalizedObjectAnnotation
                         */
                        LocalizedObjectAnnotation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.LocalizedObjectAnnotation)
                                return object;
                            var message = new $root.google.cloud.vision.v1.LocalizedObjectAnnotation();
                            if (object.mid != null)
                                message.mid = String(object.mid);
                            if (object.languageCode != null)
                                message.languageCode = String(object.languageCode);
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.score != null)
                                message.score = Number(object.score);
                            if (object.boundingPoly != null) {
                                if (typeof object.boundingPoly !== "object")
                                    throw TypeError(".google.cloud.vision.v1.LocalizedObjectAnnotation.boundingPoly: object expected");
                                message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.fromObject(object.boundingPoly);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a LocalizedObjectAnnotation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.LocalizedObjectAnnotation} message LocalizedObjectAnnotation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        LocalizedObjectAnnotation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.mid = "";
                                object.languageCode = "";
                                object.name = "";
                                object.score = 0;
                                object.boundingPoly = null;
                            }
                            if (message.mid != null && message.hasOwnProperty("mid"))
                                object.mid = message.mid;
                            if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                                object.languageCode = message.languageCode;
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.score != null && message.hasOwnProperty("score"))
                                object.score = options.json && !isFinite(message.score) ? String(message.score) : message.score;
                            if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly"))
                                object.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.toObject(message.boundingPoly, options);
                            return object;
                        };
    
                        /**
                         * Converts this LocalizedObjectAnnotation to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        LocalizedObjectAnnotation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for LocalizedObjectAnnotation
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.LocalizedObjectAnnotation
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        LocalizedObjectAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.LocalizedObjectAnnotation";
                        };
    
                        return LocalizedObjectAnnotation;
                    })();
    
                    v1.SafeSearchAnnotation = (function() {
    
                        /**
                         * Properties of a SafeSearchAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @interface ISafeSearchAnnotation
                         * @property {google.cloud.vision.v1.Likelihood|null} [adult] SafeSearchAnnotation adult
                         * @property {google.cloud.vision.v1.Likelihood|null} [spoof] SafeSearchAnnotation spoof
                         * @property {google.cloud.vision.v1.Likelihood|null} [medical] SafeSearchAnnotation medical
                         * @property {google.cloud.vision.v1.Likelihood|null} [violence] SafeSearchAnnotation violence
                         * @property {google.cloud.vision.v1.Likelihood|null} [racy] SafeSearchAnnotation racy
                         */
    
                        /**
                         * Constructs a new SafeSearchAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a SafeSearchAnnotation.
                         * @implements ISafeSearchAnnotation
                         * @constructor
                         * @param {google.cloud.vision.v1.ISafeSearchAnnotation=} [properties] Properties to set
                         */
                        function SafeSearchAnnotation(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SafeSearchAnnotation adult.
                         * @member {google.cloud.vision.v1.Likelihood} adult
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @instance
                         */
                        SafeSearchAnnotation.prototype.adult = 0;
    
                        /**
                         * SafeSearchAnnotation spoof.
                         * @member {google.cloud.vision.v1.Likelihood} spoof
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @instance
                         */
                        SafeSearchAnnotation.prototype.spoof = 0;
    
                        /**
                         * SafeSearchAnnotation medical.
                         * @member {google.cloud.vision.v1.Likelihood} medical
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @instance
                         */
                        SafeSearchAnnotation.prototype.medical = 0;
    
                        /**
                         * SafeSearchAnnotation violence.
                         * @member {google.cloud.vision.v1.Likelihood} violence
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @instance
                         */
                        SafeSearchAnnotation.prototype.violence = 0;
    
                        /**
                         * SafeSearchAnnotation racy.
                         * @member {google.cloud.vision.v1.Likelihood} racy
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @instance
                         */
                        SafeSearchAnnotation.prototype.racy = 0;
    
                        /**
                         * Creates a new SafeSearchAnnotation instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.ISafeSearchAnnotation=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.SafeSearchAnnotation} SafeSearchAnnotation instance
                         */
                        SafeSearchAnnotation.create = function create(properties) {
                            return new SafeSearchAnnotation(properties);
                        };
    
                        /**
                         * Encodes the specified SafeSearchAnnotation message. Does not implicitly {@link google.cloud.vision.v1.SafeSearchAnnotation.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.ISafeSearchAnnotation} message SafeSearchAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SafeSearchAnnotation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.adult != null && Object.hasOwnProperty.call(message, "adult"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.adult);
                            if (message.spoof != null && Object.hasOwnProperty.call(message, "spoof"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.spoof);
                            if (message.medical != null && Object.hasOwnProperty.call(message, "medical"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.medical);
                            if (message.violence != null && Object.hasOwnProperty.call(message, "violence"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.violence);
                            if (message.racy != null && Object.hasOwnProperty.call(message, "racy"))
                                writer.uint32(/* id 9, wireType 0 =*/72).int32(message.racy);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SafeSearchAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.SafeSearchAnnotation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.ISafeSearchAnnotation} message SafeSearchAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SafeSearchAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SafeSearchAnnotation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.SafeSearchAnnotation} SafeSearchAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SafeSearchAnnotation.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.SafeSearchAnnotation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.adult = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.spoof = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.medical = reader.int32();
                                        break;
                                    }
                                case 4: {
                                        message.violence = reader.int32();
                                        break;
                                    }
                                case 9: {
                                        message.racy = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SafeSearchAnnotation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.SafeSearchAnnotation} SafeSearchAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SafeSearchAnnotation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SafeSearchAnnotation message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SafeSearchAnnotation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.adult != null && message.hasOwnProperty("adult"))
                                switch (message.adult) {
                                default:
                                    return "adult: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.spoof != null && message.hasOwnProperty("spoof"))
                                switch (message.spoof) {
                                default:
                                    return "spoof: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.medical != null && message.hasOwnProperty("medical"))
                                switch (message.medical) {
                                default:
                                    return "medical: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.violence != null && message.hasOwnProperty("violence"))
                                switch (message.violence) {
                                default:
                                    return "violence: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.racy != null && message.hasOwnProperty("racy"))
                                switch (message.racy) {
                                default:
                                    return "racy: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a SafeSearchAnnotation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.SafeSearchAnnotation} SafeSearchAnnotation
                         */
                        SafeSearchAnnotation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.SafeSearchAnnotation)
                                return object;
                            var message = new $root.google.cloud.vision.v1.SafeSearchAnnotation();
                            switch (object.adult) {
                            default:
                                if (typeof object.adult === "number") {
                                    message.adult = object.adult;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.adult = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.adult = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.adult = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.adult = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.adult = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.adult = 5;
                                break;
                            }
                            switch (object.spoof) {
                            default:
                                if (typeof object.spoof === "number") {
                                    message.spoof = object.spoof;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.spoof = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.spoof = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.spoof = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.spoof = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.spoof = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.spoof = 5;
                                break;
                            }
                            switch (object.medical) {
                            default:
                                if (typeof object.medical === "number") {
                                    message.medical = object.medical;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.medical = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.medical = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.medical = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.medical = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.medical = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.medical = 5;
                                break;
                            }
                            switch (object.violence) {
                            default:
                                if (typeof object.violence === "number") {
                                    message.violence = object.violence;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.violence = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.violence = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.violence = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.violence = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.violence = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.violence = 5;
                                break;
                            }
                            switch (object.racy) {
                            default:
                                if (typeof object.racy === "number") {
                                    message.racy = object.racy;
                                    break;
                                }
                                break;
                            case "UNKNOWN":
                            case 0:
                                message.racy = 0;
                                break;
                            case "VERY_UNLIKELY":
                            case 1:
                                message.racy = 1;
                                break;
                            case "UNLIKELY":
                            case 2:
                                message.racy = 2;
                                break;
                            case "POSSIBLE":
                            case 3:
                                message.racy = 3;
                                break;
                            case "LIKELY":
                            case 4:
                                message.racy = 4;
                                break;
                            case "VERY_LIKELY":
                            case 5:
                                message.racy = 5;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SafeSearchAnnotation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.SafeSearchAnnotation} message SafeSearchAnnotation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SafeSearchAnnotation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.adult = options.enums === String ? "UNKNOWN" : 0;
                                object.spoof = options.enums === String ? "UNKNOWN" : 0;
                                object.medical = options.enums === String ? "UNKNOWN" : 0;
                                object.violence = options.enums === String ? "UNKNOWN" : 0;
                                object.racy = options.enums === String ? "UNKNOWN" : 0;
                            }
                            if (message.adult != null && message.hasOwnProperty("adult"))
                                object.adult = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.adult] === undefined ? message.adult : $root.google.cloud.vision.v1.Likelihood[message.adult] : message.adult;
                            if (message.spoof != null && message.hasOwnProperty("spoof"))
                                object.spoof = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.spoof] === undefined ? message.spoof : $root.google.cloud.vision.v1.Likelihood[message.spoof] : message.spoof;
                            if (message.medical != null && message.hasOwnProperty("medical"))
                                object.medical = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.medical] === undefined ? message.medical : $root.google.cloud.vision.v1.Likelihood[message.medical] : message.medical;
                            if (message.violence != null && message.hasOwnProperty("violence"))
                                object.violence = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.violence] === undefined ? message.violence : $root.google.cloud.vision.v1.Likelihood[message.violence] : message.violence;
                            if (message.racy != null && message.hasOwnProperty("racy"))
                                object.racy = options.enums === String ? $root.google.cloud.vision.v1.Likelihood[message.racy] === undefined ? message.racy : $root.google.cloud.vision.v1.Likelihood[message.racy] : message.racy;
                            return object;
                        };
    
                        /**
                         * Converts this SafeSearchAnnotation to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SafeSearchAnnotation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SafeSearchAnnotation
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.SafeSearchAnnotation
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SafeSearchAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.SafeSearchAnnotation";
                        };
    
                        return SafeSearchAnnotation;
                    })();
    
                    v1.LatLongRect = (function() {
    
                        /**
                         * Properties of a LatLongRect.
                         * @memberof google.cloud.vision.v1
                         * @interface ILatLongRect
                         * @property {google.type.ILatLng|null} [minLatLng] LatLongRect minLatLng
                         * @property {google.type.ILatLng|null} [maxLatLng] LatLongRect maxLatLng
                         */
    
                        /**
                         * Constructs a new LatLongRect.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a LatLongRect.
                         * @implements ILatLongRect
                         * @constructor
                         * @param {google.cloud.vision.v1.ILatLongRect=} [properties] Properties to set
                         */
                        function LatLongRect(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * LatLongRect minLatLng.
                         * @member {google.type.ILatLng|null|undefined} minLatLng
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @instance
                         */
                        LatLongRect.prototype.minLatLng = null;
    
                        /**
                         * LatLongRect maxLatLng.
                         * @member {google.type.ILatLng|null|undefined} maxLatLng
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @instance
                         */
                        LatLongRect.prototype.maxLatLng = null;
    
                        /**
                         * Creates a new LatLongRect instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @static
                         * @param {google.cloud.vision.v1.ILatLongRect=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.LatLongRect} LatLongRect instance
                         */
                        LatLongRect.create = function create(properties) {
                            return new LatLongRect(properties);
                        };
    
                        /**
                         * Encodes the specified LatLongRect message. Does not implicitly {@link google.cloud.vision.v1.LatLongRect.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @static
                         * @param {google.cloud.vision.v1.ILatLongRect} message LatLongRect message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        LatLongRect.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.minLatLng != null && Object.hasOwnProperty.call(message, "minLatLng"))
                                $root.google.type.LatLng.encode(message.minLatLng, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.maxLatLng != null && Object.hasOwnProperty.call(message, "maxLatLng"))
                                $root.google.type.LatLng.encode(message.maxLatLng, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified LatLongRect message, length delimited. Does not implicitly {@link google.cloud.vision.v1.LatLongRect.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @static
                         * @param {google.cloud.vision.v1.ILatLongRect} message LatLongRect message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        LatLongRect.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a LatLongRect message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.LatLongRect} LatLongRect
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        LatLongRect.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.LatLongRect();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.minLatLng = $root.google.type.LatLng.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.maxLatLng = $root.google.type.LatLng.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a LatLongRect message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.LatLongRect} LatLongRect
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        LatLongRect.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a LatLongRect message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        LatLongRect.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.minLatLng != null && message.hasOwnProperty("minLatLng")) {
                                var error = $root.google.type.LatLng.verify(message.minLatLng);
                                if (error)
                                    return "minLatLng." + error;
                            }
                            if (message.maxLatLng != null && message.hasOwnProperty("maxLatLng")) {
                                var error = $root.google.type.LatLng.verify(message.maxLatLng);
                                if (error)
                                    return "maxLatLng." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a LatLongRect message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.LatLongRect} LatLongRect
                         */
                        LatLongRect.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.LatLongRect)
                                return object;
                            var message = new $root.google.cloud.vision.v1.LatLongRect();
                            if (object.minLatLng != null) {
                                if (typeof object.minLatLng !== "object")
                                    throw TypeError(".google.cloud.vision.v1.LatLongRect.minLatLng: object expected");
                                message.minLatLng = $root.google.type.LatLng.fromObject(object.minLatLng);
                            }
                            if (object.maxLatLng != null) {
                                if (typeof object.maxLatLng !== "object")
                                    throw TypeError(".google.cloud.vision.v1.LatLongRect.maxLatLng: object expected");
                                message.maxLatLng = $root.google.type.LatLng.fromObject(object.maxLatLng);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a LatLongRect message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @static
                         * @param {google.cloud.vision.v1.LatLongRect} message LatLongRect
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        LatLongRect.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.minLatLng = null;
                                object.maxLatLng = null;
                            }
                            if (message.minLatLng != null && message.hasOwnProperty("minLatLng"))
                                object.minLatLng = $root.google.type.LatLng.toObject(message.minLatLng, options);
                            if (message.maxLatLng != null && message.hasOwnProperty("maxLatLng"))
                                object.maxLatLng = $root.google.type.LatLng.toObject(message.maxLatLng, options);
                            return object;
                        };
    
                        /**
                         * Converts this LatLongRect to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        LatLongRect.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for LatLongRect
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.LatLongRect
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        LatLongRect.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.LatLongRect";
                        };
    
                        return LatLongRect;
                    })();
    
                    v1.ColorInfo = (function() {
    
                        /**
                         * Properties of a ColorInfo.
                         * @memberof google.cloud.vision.v1
                         * @interface IColorInfo
                         * @property {google.type.IColor|null} [color] ColorInfo color
                         * @property {number|null} [score] ColorInfo score
                         * @property {number|null} [pixelFraction] ColorInfo pixelFraction
                         */
    
                        /**
                         * Constructs a new ColorInfo.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a ColorInfo.
                         * @implements IColorInfo
                         * @constructor
                         * @param {google.cloud.vision.v1.IColorInfo=} [properties] Properties to set
                         */
                        function ColorInfo(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ColorInfo color.
                         * @member {google.type.IColor|null|undefined} color
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @instance
                         */
                        ColorInfo.prototype.color = null;
    
                        /**
                         * ColorInfo score.
                         * @member {number} score
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @instance
                         */
                        ColorInfo.prototype.score = 0;
    
                        /**
                         * ColorInfo pixelFraction.
                         * @member {number} pixelFraction
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @instance
                         */
                        ColorInfo.prototype.pixelFraction = 0;
    
                        /**
                         * Creates a new ColorInfo instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @static
                         * @param {google.cloud.vision.v1.IColorInfo=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.ColorInfo} ColorInfo instance
                         */
                        ColorInfo.create = function create(properties) {
                            return new ColorInfo(properties);
                        };
    
                        /**
                         * Encodes the specified ColorInfo message. Does not implicitly {@link google.cloud.vision.v1.ColorInfo.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @static
                         * @param {google.cloud.vision.v1.IColorInfo} message ColorInfo message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ColorInfo.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.color != null && Object.hasOwnProperty.call(message, "color"))
                                $root.google.type.Color.encode(message.color, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.score != null && Object.hasOwnProperty.call(message, "score"))
                                writer.uint32(/* id 2, wireType 5 =*/21).float(message.score);
                            if (message.pixelFraction != null && Object.hasOwnProperty.call(message, "pixelFraction"))
                                writer.uint32(/* id 3, wireType 5 =*/29).float(message.pixelFraction);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ColorInfo message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ColorInfo.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @static
                         * @param {google.cloud.vision.v1.IColorInfo} message ColorInfo message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ColorInfo.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ColorInfo message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.ColorInfo} ColorInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ColorInfo.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.ColorInfo();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.color = $root.google.type.Color.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.score = reader.float();
                                        break;
                                    }
                                case 3: {
                                        message.pixelFraction = reader.float();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ColorInfo message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.ColorInfo} ColorInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ColorInfo.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ColorInfo message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ColorInfo.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.color != null && message.hasOwnProperty("color")) {
                                var error = $root.google.type.Color.verify(message.color);
                                if (error)
                                    return "color." + error;
                            }
                            if (message.score != null && message.hasOwnProperty("score"))
                                if (typeof message.score !== "number")
                                    return "score: number expected";
                            if (message.pixelFraction != null && message.hasOwnProperty("pixelFraction"))
                                if (typeof message.pixelFraction !== "number")
                                    return "pixelFraction: number expected";
                            return null;
                        };
    
                        /**
                         * Creates a ColorInfo message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.ColorInfo} ColorInfo
                         */
                        ColorInfo.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.ColorInfo)
                                return object;
                            var message = new $root.google.cloud.vision.v1.ColorInfo();
                            if (object.color != null) {
                                if (typeof object.color !== "object")
                                    throw TypeError(".google.cloud.vision.v1.ColorInfo.color: object expected");
                                message.color = $root.google.type.Color.fromObject(object.color);
                            }
                            if (object.score != null)
                                message.score = Number(object.score);
                            if (object.pixelFraction != null)
                                message.pixelFraction = Number(object.pixelFraction);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ColorInfo message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @static
                         * @param {google.cloud.vision.v1.ColorInfo} message ColorInfo
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ColorInfo.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.color = null;
                                object.score = 0;
                                object.pixelFraction = 0;
                            }
                            if (message.color != null && message.hasOwnProperty("color"))
                                object.color = $root.google.type.Color.toObject(message.color, options);
                            if (message.score != null && message.hasOwnProperty("score"))
                                object.score = options.json && !isFinite(message.score) ? String(message.score) : message.score;
                            if (message.pixelFraction != null && message.hasOwnProperty("pixelFraction"))
                                object.pixelFraction = options.json && !isFinite(message.pixelFraction) ? String(message.pixelFraction) : message.pixelFraction;
                            return object;
                        };
    
                        /**
                         * Converts this ColorInfo to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ColorInfo.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ColorInfo
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.ColorInfo
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ColorInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.ColorInfo";
                        };
    
                        return ColorInfo;
                    })();
    
                    v1.DominantColorsAnnotation = (function() {
    
                        /**
                         * Properties of a DominantColorsAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @interface IDominantColorsAnnotation
                         * @property {Array.<google.cloud.vision.v1.IColorInfo>|null} [colors] DominantColorsAnnotation colors
                         */
    
                        /**
                         * Constructs a new DominantColorsAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a DominantColorsAnnotation.
                         * @implements IDominantColorsAnnotation
                         * @constructor
                         * @param {google.cloud.vision.v1.IDominantColorsAnnotation=} [properties] Properties to set
                         */
                        function DominantColorsAnnotation(properties) {
                            this.colors = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DominantColorsAnnotation colors.
                         * @member {Array.<google.cloud.vision.v1.IColorInfo>} colors
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @instance
                         */
                        DominantColorsAnnotation.prototype.colors = $util.emptyArray;
    
                        /**
                         * Creates a new DominantColorsAnnotation instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.IDominantColorsAnnotation=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.DominantColorsAnnotation} DominantColorsAnnotation instance
                         */
                        DominantColorsAnnotation.create = function create(properties) {
                            return new DominantColorsAnnotation(properties);
                        };
    
                        /**
                         * Encodes the specified DominantColorsAnnotation message. Does not implicitly {@link google.cloud.vision.v1.DominantColorsAnnotation.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.IDominantColorsAnnotation} message DominantColorsAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DominantColorsAnnotation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.colors != null && message.colors.length)
                                for (var i = 0; i < message.colors.length; ++i)
                                    $root.google.cloud.vision.v1.ColorInfo.encode(message.colors[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DominantColorsAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.DominantColorsAnnotation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.IDominantColorsAnnotation} message DominantColorsAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DominantColorsAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DominantColorsAnnotation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.DominantColorsAnnotation} DominantColorsAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DominantColorsAnnotation.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.DominantColorsAnnotation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.colors && message.colors.length))
                                            message.colors = [];
                                        message.colors.push($root.google.cloud.vision.v1.ColorInfo.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DominantColorsAnnotation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.DominantColorsAnnotation} DominantColorsAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DominantColorsAnnotation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DominantColorsAnnotation message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DominantColorsAnnotation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.colors != null && message.hasOwnProperty("colors")) {
                                if (!Array.isArray(message.colors))
                                    return "colors: array expected";
                                for (var i = 0; i < message.colors.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.ColorInfo.verify(message.colors[i]);
                                    if (error)
                                        return "colors." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a DominantColorsAnnotation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.DominantColorsAnnotation} DominantColorsAnnotation
                         */
                        DominantColorsAnnotation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.DominantColorsAnnotation)
                                return object;
                            var message = new $root.google.cloud.vision.v1.DominantColorsAnnotation();
                            if (object.colors) {
                                if (!Array.isArray(object.colors))
                                    throw TypeError(".google.cloud.vision.v1.DominantColorsAnnotation.colors: array expected");
                                message.colors = [];
                                for (var i = 0; i < object.colors.length; ++i) {
                                    if (typeof object.colors[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.DominantColorsAnnotation.colors: object expected");
                                    message.colors[i] = $root.google.cloud.vision.v1.ColorInfo.fromObject(object.colors[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DominantColorsAnnotation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.DominantColorsAnnotation} message DominantColorsAnnotation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DominantColorsAnnotation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.colors = [];
                            if (message.colors && message.colors.length) {
                                object.colors = [];
                                for (var j = 0; j < message.colors.length; ++j)
                                    object.colors[j] = $root.google.cloud.vision.v1.ColorInfo.toObject(message.colors[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this DominantColorsAnnotation to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DominantColorsAnnotation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DominantColorsAnnotation
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.DominantColorsAnnotation
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DominantColorsAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.DominantColorsAnnotation";
                        };
    
                        return DominantColorsAnnotation;
                    })();
    
                    v1.ImageProperties = (function() {
    
                        /**
                         * Properties of an ImageProperties.
                         * @memberof google.cloud.vision.v1
                         * @interface IImageProperties
                         * @property {google.cloud.vision.v1.IDominantColorsAnnotation|null} [dominantColors] ImageProperties dominantColors
                         */
    
                        /**
                         * Constructs a new ImageProperties.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an ImageProperties.
                         * @implements IImageProperties
                         * @constructor
                         * @param {google.cloud.vision.v1.IImageProperties=} [properties] Properties to set
                         */
                        function ImageProperties(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ImageProperties dominantColors.
                         * @member {google.cloud.vision.v1.IDominantColorsAnnotation|null|undefined} dominantColors
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @instance
                         */
                        ImageProperties.prototype.dominantColors = null;
    
                        /**
                         * Creates a new ImageProperties instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @static
                         * @param {google.cloud.vision.v1.IImageProperties=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.ImageProperties} ImageProperties instance
                         */
                        ImageProperties.create = function create(properties) {
                            return new ImageProperties(properties);
                        };
    
                        /**
                         * Encodes the specified ImageProperties message. Does not implicitly {@link google.cloud.vision.v1.ImageProperties.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @static
                         * @param {google.cloud.vision.v1.IImageProperties} message ImageProperties message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImageProperties.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.dominantColors != null && Object.hasOwnProperty.call(message, "dominantColors"))
                                $root.google.cloud.vision.v1.DominantColorsAnnotation.encode(message.dominantColors, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ImageProperties message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImageProperties.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @static
                         * @param {google.cloud.vision.v1.IImageProperties} message ImageProperties message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImageProperties.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ImageProperties message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.ImageProperties} ImageProperties
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImageProperties.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.ImageProperties();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.dominantColors = $root.google.cloud.vision.v1.DominantColorsAnnotation.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ImageProperties message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.ImageProperties} ImageProperties
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImageProperties.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ImageProperties message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ImageProperties.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.dominantColors != null && message.hasOwnProperty("dominantColors")) {
                                var error = $root.google.cloud.vision.v1.DominantColorsAnnotation.verify(message.dominantColors);
                                if (error)
                                    return "dominantColors." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an ImageProperties message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.ImageProperties} ImageProperties
                         */
                        ImageProperties.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.ImageProperties)
                                return object;
                            var message = new $root.google.cloud.vision.v1.ImageProperties();
                            if (object.dominantColors != null) {
                                if (typeof object.dominantColors !== "object")
                                    throw TypeError(".google.cloud.vision.v1.ImageProperties.dominantColors: object expected");
                                message.dominantColors = $root.google.cloud.vision.v1.DominantColorsAnnotation.fromObject(object.dominantColors);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ImageProperties message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @static
                         * @param {google.cloud.vision.v1.ImageProperties} message ImageProperties
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ImageProperties.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.dominantColors = null;
                            if (message.dominantColors != null && message.hasOwnProperty("dominantColors"))
                                object.dominantColors = $root.google.cloud.vision.v1.DominantColorsAnnotation.toObject(message.dominantColors, options);
                            return object;
                        };
    
                        /**
                         * Converts this ImageProperties to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ImageProperties.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ImageProperties
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.ImageProperties
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ImageProperties.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.ImageProperties";
                        };
    
                        return ImageProperties;
                    })();
    
                    v1.CropHint = (function() {
    
                        /**
                         * Properties of a CropHint.
                         * @memberof google.cloud.vision.v1
                         * @interface ICropHint
                         * @property {google.cloud.vision.v1.IBoundingPoly|null} [boundingPoly] CropHint boundingPoly
                         * @property {number|null} [confidence] CropHint confidence
                         * @property {number|null} [importanceFraction] CropHint importanceFraction
                         */
    
                        /**
                         * Constructs a new CropHint.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a CropHint.
                         * @implements ICropHint
                         * @constructor
                         * @param {google.cloud.vision.v1.ICropHint=} [properties] Properties to set
                         */
                        function CropHint(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CropHint boundingPoly.
                         * @member {google.cloud.vision.v1.IBoundingPoly|null|undefined} boundingPoly
                         * @memberof google.cloud.vision.v1.CropHint
                         * @instance
                         */
                        CropHint.prototype.boundingPoly = null;
    
                        /**
                         * CropHint confidence.
                         * @member {number} confidence
                         * @memberof google.cloud.vision.v1.CropHint
                         * @instance
                         */
                        CropHint.prototype.confidence = 0;
    
                        /**
                         * CropHint importanceFraction.
                         * @member {number} importanceFraction
                         * @memberof google.cloud.vision.v1.CropHint
                         * @instance
                         */
                        CropHint.prototype.importanceFraction = 0;
    
                        /**
                         * Creates a new CropHint instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.CropHint
                         * @static
                         * @param {google.cloud.vision.v1.ICropHint=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.CropHint} CropHint instance
                         */
                        CropHint.create = function create(properties) {
                            return new CropHint(properties);
                        };
    
                        /**
                         * Encodes the specified CropHint message. Does not implicitly {@link google.cloud.vision.v1.CropHint.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.CropHint
                         * @static
                         * @param {google.cloud.vision.v1.ICropHint} message CropHint message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CropHint.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.boundingPoly != null && Object.hasOwnProperty.call(message, "boundingPoly"))
                                $root.google.cloud.vision.v1.BoundingPoly.encode(message.boundingPoly, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.confidence != null && Object.hasOwnProperty.call(message, "confidence"))
                                writer.uint32(/* id 2, wireType 5 =*/21).float(message.confidence);
                            if (message.importanceFraction != null && Object.hasOwnProperty.call(message, "importanceFraction"))
                                writer.uint32(/* id 3, wireType 5 =*/29).float(message.importanceFraction);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CropHint message, length delimited. Does not implicitly {@link google.cloud.vision.v1.CropHint.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.CropHint
                         * @static
                         * @param {google.cloud.vision.v1.ICropHint} message CropHint message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CropHint.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CropHint message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.CropHint
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.CropHint} CropHint
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CropHint.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.CropHint();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.confidence = reader.float();
                                        break;
                                    }
                                case 3: {
                                        message.importanceFraction = reader.float();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CropHint message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.CropHint
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.CropHint} CropHint
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CropHint.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CropHint message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.CropHint
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CropHint.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly")) {
                                var error = $root.google.cloud.vision.v1.BoundingPoly.verify(message.boundingPoly);
                                if (error)
                                    return "boundingPoly." + error;
                            }
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                if (typeof message.confidence !== "number")
                                    return "confidence: number expected";
                            if (message.importanceFraction != null && message.hasOwnProperty("importanceFraction"))
                                if (typeof message.importanceFraction !== "number")
                                    return "importanceFraction: number expected";
                            return null;
                        };
    
                        /**
                         * Creates a CropHint message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.CropHint
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.CropHint} CropHint
                         */
                        CropHint.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.CropHint)
                                return object;
                            var message = new $root.google.cloud.vision.v1.CropHint();
                            if (object.boundingPoly != null) {
                                if (typeof object.boundingPoly !== "object")
                                    throw TypeError(".google.cloud.vision.v1.CropHint.boundingPoly: object expected");
                                message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.fromObject(object.boundingPoly);
                            }
                            if (object.confidence != null)
                                message.confidence = Number(object.confidence);
                            if (object.importanceFraction != null)
                                message.importanceFraction = Number(object.importanceFraction);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CropHint message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.CropHint
                         * @static
                         * @param {google.cloud.vision.v1.CropHint} message CropHint
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CropHint.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.boundingPoly = null;
                                object.confidence = 0;
                                object.importanceFraction = 0;
                            }
                            if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly"))
                                object.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.toObject(message.boundingPoly, options);
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                object.confidence = options.json && !isFinite(message.confidence) ? String(message.confidence) : message.confidence;
                            if (message.importanceFraction != null && message.hasOwnProperty("importanceFraction"))
                                object.importanceFraction = options.json && !isFinite(message.importanceFraction) ? String(message.importanceFraction) : message.importanceFraction;
                            return object;
                        };
    
                        /**
                         * Converts this CropHint to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.CropHint
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CropHint.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CropHint
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.CropHint
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CropHint.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.CropHint";
                        };
    
                        return CropHint;
                    })();
    
                    v1.CropHintsAnnotation = (function() {
    
                        /**
                         * Properties of a CropHintsAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @interface ICropHintsAnnotation
                         * @property {Array.<google.cloud.vision.v1.ICropHint>|null} [cropHints] CropHintsAnnotation cropHints
                         */
    
                        /**
                         * Constructs a new CropHintsAnnotation.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a CropHintsAnnotation.
                         * @implements ICropHintsAnnotation
                         * @constructor
                         * @param {google.cloud.vision.v1.ICropHintsAnnotation=} [properties] Properties to set
                         */
                        function CropHintsAnnotation(properties) {
                            this.cropHints = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CropHintsAnnotation cropHints.
                         * @member {Array.<google.cloud.vision.v1.ICropHint>} cropHints
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @instance
                         */
                        CropHintsAnnotation.prototype.cropHints = $util.emptyArray;
    
                        /**
                         * Creates a new CropHintsAnnotation instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.ICropHintsAnnotation=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.CropHintsAnnotation} CropHintsAnnotation instance
                         */
                        CropHintsAnnotation.create = function create(properties) {
                            return new CropHintsAnnotation(properties);
                        };
    
                        /**
                         * Encodes the specified CropHintsAnnotation message. Does not implicitly {@link google.cloud.vision.v1.CropHintsAnnotation.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.ICropHintsAnnotation} message CropHintsAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CropHintsAnnotation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.cropHints != null && message.cropHints.length)
                                for (var i = 0; i < message.cropHints.length; ++i)
                                    $root.google.cloud.vision.v1.CropHint.encode(message.cropHints[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CropHintsAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.CropHintsAnnotation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.ICropHintsAnnotation} message CropHintsAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CropHintsAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CropHintsAnnotation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.CropHintsAnnotation} CropHintsAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CropHintsAnnotation.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.CropHintsAnnotation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.cropHints && message.cropHints.length))
                                            message.cropHints = [];
                                        message.cropHints.push($root.google.cloud.vision.v1.CropHint.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CropHintsAnnotation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.CropHintsAnnotation} CropHintsAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CropHintsAnnotation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CropHintsAnnotation message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CropHintsAnnotation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.cropHints != null && message.hasOwnProperty("cropHints")) {
                                if (!Array.isArray(message.cropHints))
                                    return "cropHints: array expected";
                                for (var i = 0; i < message.cropHints.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.CropHint.verify(message.cropHints[i]);
                                    if (error)
                                        return "cropHints." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CropHintsAnnotation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.CropHintsAnnotation} CropHintsAnnotation
                         */
                        CropHintsAnnotation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.CropHintsAnnotation)
                                return object;
                            var message = new $root.google.cloud.vision.v1.CropHintsAnnotation();
                            if (object.cropHints) {
                                if (!Array.isArray(object.cropHints))
                                    throw TypeError(".google.cloud.vision.v1.CropHintsAnnotation.cropHints: array expected");
                                message.cropHints = [];
                                for (var i = 0; i < object.cropHints.length; ++i) {
                                    if (typeof object.cropHints[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.CropHintsAnnotation.cropHints: object expected");
                                    message.cropHints[i] = $root.google.cloud.vision.v1.CropHint.fromObject(object.cropHints[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CropHintsAnnotation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @static
                         * @param {google.cloud.vision.v1.CropHintsAnnotation} message CropHintsAnnotation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CropHintsAnnotation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.cropHints = [];
                            if (message.cropHints && message.cropHints.length) {
                                object.cropHints = [];
                                for (var j = 0; j < message.cropHints.length; ++j)
                                    object.cropHints[j] = $root.google.cloud.vision.v1.CropHint.toObject(message.cropHints[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this CropHintsAnnotation to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CropHintsAnnotation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CropHintsAnnotation
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.CropHintsAnnotation
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CropHintsAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.CropHintsAnnotation";
                        };
    
                        return CropHintsAnnotation;
                    })();
    
                    v1.CropHintsParams = (function() {
    
                        /**
                         * Properties of a CropHintsParams.
                         * @memberof google.cloud.vision.v1
                         * @interface ICropHintsParams
                         * @property {Array.<number>|null} [aspectRatios] CropHintsParams aspectRatios
                         */
    
                        /**
                         * Constructs a new CropHintsParams.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a CropHintsParams.
                         * @implements ICropHintsParams
                         * @constructor
                         * @param {google.cloud.vision.v1.ICropHintsParams=} [properties] Properties to set
                         */
                        function CropHintsParams(properties) {
                            this.aspectRatios = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CropHintsParams aspectRatios.
                         * @member {Array.<number>} aspectRatios
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @instance
                         */
                        CropHintsParams.prototype.aspectRatios = $util.emptyArray;
    
                        /**
                         * Creates a new CropHintsParams instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @static
                         * @param {google.cloud.vision.v1.ICropHintsParams=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.CropHintsParams} CropHintsParams instance
                         */
                        CropHintsParams.create = function create(properties) {
                            return new CropHintsParams(properties);
                        };
    
                        /**
                         * Encodes the specified CropHintsParams message. Does not implicitly {@link google.cloud.vision.v1.CropHintsParams.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @static
                         * @param {google.cloud.vision.v1.ICropHintsParams} message CropHintsParams message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CropHintsParams.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.aspectRatios != null && message.aspectRatios.length) {
                                writer.uint32(/* id 1, wireType 2 =*/10).fork();
                                for (var i = 0; i < message.aspectRatios.length; ++i)
                                    writer.float(message.aspectRatios[i]);
                                writer.ldelim();
                            }
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CropHintsParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1.CropHintsParams.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @static
                         * @param {google.cloud.vision.v1.ICropHintsParams} message CropHintsParams message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CropHintsParams.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CropHintsParams message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.CropHintsParams} CropHintsParams
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CropHintsParams.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.CropHintsParams();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.aspectRatios && message.aspectRatios.length))
                                            message.aspectRatios = [];
                                        if ((tag & 7) === 2) {
                                            var end2 = reader.uint32() + reader.pos;
                                            while (reader.pos < end2)
                                                message.aspectRatios.push(reader.float());
                                        } else
                                            message.aspectRatios.push(reader.float());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CropHintsParams message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.CropHintsParams} CropHintsParams
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CropHintsParams.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CropHintsParams message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CropHintsParams.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.aspectRatios != null && message.hasOwnProperty("aspectRatios")) {
                                if (!Array.isArray(message.aspectRatios))
                                    return "aspectRatios: array expected";
                                for (var i = 0; i < message.aspectRatios.length; ++i)
                                    if (typeof message.aspectRatios[i] !== "number")
                                        return "aspectRatios: number[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CropHintsParams message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.CropHintsParams} CropHintsParams
                         */
                        CropHintsParams.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.CropHintsParams)
                                return object;
                            var message = new $root.google.cloud.vision.v1.CropHintsParams();
                            if (object.aspectRatios) {
                                if (!Array.isArray(object.aspectRatios))
                                    throw TypeError(".google.cloud.vision.v1.CropHintsParams.aspectRatios: array expected");
                                message.aspectRatios = [];
                                for (var i = 0; i < object.aspectRatios.length; ++i)
                                    message.aspectRatios[i] = Number(object.aspectRatios[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CropHintsParams message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @static
                         * @param {google.cloud.vision.v1.CropHintsParams} message CropHintsParams
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CropHintsParams.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.aspectRatios = [];
                            if (message.aspectRatios && message.aspectRatios.length) {
                                object.aspectRatios = [];
                                for (var j = 0; j < message.aspectRatios.length; ++j)
                                    object.aspectRatios[j] = options.json && !isFinite(message.aspectRatios[j]) ? String(message.aspectRatios[j]) : message.aspectRatios[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this CropHintsParams to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CropHintsParams.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CropHintsParams
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.CropHintsParams
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CropHintsParams.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.CropHintsParams";
                        };
    
                        return CropHintsParams;
                    })();
    
                    v1.WebDetectionParams = (function() {
    
                        /**
                         * Properties of a WebDetectionParams.
                         * @memberof google.cloud.vision.v1
                         * @interface IWebDetectionParams
                         * @property {boolean|null} [includeGeoResults] WebDetectionParams includeGeoResults
                         */
    
                        /**
                         * Constructs a new WebDetectionParams.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a WebDetectionParams.
                         * @implements IWebDetectionParams
                         * @constructor
                         * @param {google.cloud.vision.v1.IWebDetectionParams=} [properties] Properties to set
                         */
                        function WebDetectionParams(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * WebDetectionParams includeGeoResults.
                         * @member {boolean} includeGeoResults
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @instance
                         */
                        WebDetectionParams.prototype.includeGeoResults = false;
    
                        /**
                         * Creates a new WebDetectionParams instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @static
                         * @param {google.cloud.vision.v1.IWebDetectionParams=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.WebDetectionParams} WebDetectionParams instance
                         */
                        WebDetectionParams.create = function create(properties) {
                            return new WebDetectionParams(properties);
                        };
    
                        /**
                         * Encodes the specified WebDetectionParams message. Does not implicitly {@link google.cloud.vision.v1.WebDetectionParams.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @static
                         * @param {google.cloud.vision.v1.IWebDetectionParams} message WebDetectionParams message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        WebDetectionParams.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.includeGeoResults != null && Object.hasOwnProperty.call(message, "includeGeoResults"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.includeGeoResults);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified WebDetectionParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1.WebDetectionParams.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @static
                         * @param {google.cloud.vision.v1.IWebDetectionParams} message WebDetectionParams message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        WebDetectionParams.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a WebDetectionParams message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.WebDetectionParams} WebDetectionParams
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        WebDetectionParams.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.WebDetectionParams();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 2: {
                                        message.includeGeoResults = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a WebDetectionParams message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.WebDetectionParams} WebDetectionParams
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        WebDetectionParams.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a WebDetectionParams message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        WebDetectionParams.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.includeGeoResults != null && message.hasOwnProperty("includeGeoResults"))
                                if (typeof message.includeGeoResults !== "boolean")
                                    return "includeGeoResults: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a WebDetectionParams message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.WebDetectionParams} WebDetectionParams
                         */
                        WebDetectionParams.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.WebDetectionParams)
                                return object;
                            var message = new $root.google.cloud.vision.v1.WebDetectionParams();
                            if (object.includeGeoResults != null)
                                message.includeGeoResults = Boolean(object.includeGeoResults);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a WebDetectionParams message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @static
                         * @param {google.cloud.vision.v1.WebDetectionParams} message WebDetectionParams
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        WebDetectionParams.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.includeGeoResults = false;
                            if (message.includeGeoResults != null && message.hasOwnProperty("includeGeoResults"))
                                object.includeGeoResults = message.includeGeoResults;
                            return object;
                        };
    
                        /**
                         * Converts this WebDetectionParams to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        WebDetectionParams.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for WebDetectionParams
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.WebDetectionParams
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        WebDetectionParams.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.WebDetectionParams";
                        };
    
                        return WebDetectionParams;
                    })();
    
                    v1.TextDetectionParams = (function() {
    
                        /**
                         * Properties of a TextDetectionParams.
                         * @memberof google.cloud.vision.v1
                         * @interface ITextDetectionParams
                         * @property {boolean|null} [enableTextDetectionConfidenceScore] TextDetectionParams enableTextDetectionConfidenceScore
                         * @property {Array.<string>|null} [advancedOcrOptions] TextDetectionParams advancedOcrOptions
                         */
    
                        /**
                         * Constructs a new TextDetectionParams.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a TextDetectionParams.
                         * @implements ITextDetectionParams
                         * @constructor
                         * @param {google.cloud.vision.v1.ITextDetectionParams=} [properties] Properties to set
                         */
                        function TextDetectionParams(properties) {
                            this.advancedOcrOptions = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * TextDetectionParams enableTextDetectionConfidenceScore.
                         * @member {boolean} enableTextDetectionConfidenceScore
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @instance
                         */
                        TextDetectionParams.prototype.enableTextDetectionConfidenceScore = false;
    
                        /**
                         * TextDetectionParams advancedOcrOptions.
                         * @member {Array.<string>} advancedOcrOptions
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @instance
                         */
                        TextDetectionParams.prototype.advancedOcrOptions = $util.emptyArray;
    
                        /**
                         * Creates a new TextDetectionParams instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @static
                         * @param {google.cloud.vision.v1.ITextDetectionParams=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.TextDetectionParams} TextDetectionParams instance
                         */
                        TextDetectionParams.create = function create(properties) {
                            return new TextDetectionParams(properties);
                        };
    
                        /**
                         * Encodes the specified TextDetectionParams message. Does not implicitly {@link google.cloud.vision.v1.TextDetectionParams.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @static
                         * @param {google.cloud.vision.v1.ITextDetectionParams} message TextDetectionParams message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TextDetectionParams.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.enableTextDetectionConfidenceScore != null && Object.hasOwnProperty.call(message, "enableTextDetectionConfidenceScore"))
                                writer.uint32(/* id 9, wireType 0 =*/72).bool(message.enableTextDetectionConfidenceScore);
                            if (message.advancedOcrOptions != null && message.advancedOcrOptions.length)
                                for (var i = 0; i < message.advancedOcrOptions.length; ++i)
                                    writer.uint32(/* id 11, wireType 2 =*/90).string(message.advancedOcrOptions[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified TextDetectionParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1.TextDetectionParams.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @static
                         * @param {google.cloud.vision.v1.ITextDetectionParams} message TextDetectionParams message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TextDetectionParams.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a TextDetectionParams message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.TextDetectionParams} TextDetectionParams
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TextDetectionParams.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.TextDetectionParams();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 9: {
                                        message.enableTextDetectionConfidenceScore = reader.bool();
                                        break;
                                    }
                                case 11: {
                                        if (!(message.advancedOcrOptions && message.advancedOcrOptions.length))
                                            message.advancedOcrOptions = [];
                                        message.advancedOcrOptions.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a TextDetectionParams message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.TextDetectionParams} TextDetectionParams
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TextDetectionParams.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a TextDetectionParams message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TextDetectionParams.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.enableTextDetectionConfidenceScore != null && message.hasOwnProperty("enableTextDetectionConfidenceScore"))
                                if (typeof message.enableTextDetectionConfidenceScore !== "boolean")
                                    return "enableTextDetectionConfidenceScore: boolean expected";
                            if (message.advancedOcrOptions != null && message.hasOwnProperty("advancedOcrOptions")) {
                                if (!Array.isArray(message.advancedOcrOptions))
                                    return "advancedOcrOptions: array expected";
                                for (var i = 0; i < message.advancedOcrOptions.length; ++i)
                                    if (!$util.isString(message.advancedOcrOptions[i]))
                                        return "advancedOcrOptions: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a TextDetectionParams message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.TextDetectionParams} TextDetectionParams
                         */
                        TextDetectionParams.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.TextDetectionParams)
                                return object;
                            var message = new $root.google.cloud.vision.v1.TextDetectionParams();
                            if (object.enableTextDetectionConfidenceScore != null)
                                message.enableTextDetectionConfidenceScore = Boolean(object.enableTextDetectionConfidenceScore);
                            if (object.advancedOcrOptions) {
                                if (!Array.isArray(object.advancedOcrOptions))
                                    throw TypeError(".google.cloud.vision.v1.TextDetectionParams.advancedOcrOptions: array expected");
                                message.advancedOcrOptions = [];
                                for (var i = 0; i < object.advancedOcrOptions.length; ++i)
                                    message.advancedOcrOptions[i] = String(object.advancedOcrOptions[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a TextDetectionParams message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @static
                         * @param {google.cloud.vision.v1.TextDetectionParams} message TextDetectionParams
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TextDetectionParams.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.advancedOcrOptions = [];
                            if (options.defaults)
                                object.enableTextDetectionConfidenceScore = false;
                            if (message.enableTextDetectionConfidenceScore != null && message.hasOwnProperty("enableTextDetectionConfidenceScore"))
                                object.enableTextDetectionConfidenceScore = message.enableTextDetectionConfidenceScore;
                            if (message.advancedOcrOptions && message.advancedOcrOptions.length) {
                                object.advancedOcrOptions = [];
                                for (var j = 0; j < message.advancedOcrOptions.length; ++j)
                                    object.advancedOcrOptions[j] = message.advancedOcrOptions[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this TextDetectionParams to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TextDetectionParams.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for TextDetectionParams
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.TextDetectionParams
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        TextDetectionParams.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.TextDetectionParams";
                        };
    
                        return TextDetectionParams;
                    })();
    
                    v1.ImageContext = (function() {
    
                        /**
                         * Properties of an ImageContext.
                         * @memberof google.cloud.vision.v1
                         * @interface IImageContext
                         * @property {google.cloud.vision.v1.ILatLongRect|null} [latLongRect] ImageContext latLongRect
                         * @property {Array.<string>|null} [languageHints] ImageContext languageHints
                         * @property {google.cloud.vision.v1.ICropHintsParams|null} [cropHintsParams] ImageContext cropHintsParams
                         * @property {google.cloud.vision.v1.IProductSearchParams|null} [productSearchParams] ImageContext productSearchParams
                         * @property {google.cloud.vision.v1.IWebDetectionParams|null} [webDetectionParams] ImageContext webDetectionParams
                         * @property {google.cloud.vision.v1.ITextDetectionParams|null} [textDetectionParams] ImageContext textDetectionParams
                         */
    
                        /**
                         * Constructs a new ImageContext.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an ImageContext.
                         * @implements IImageContext
                         * @constructor
                         * @param {google.cloud.vision.v1.IImageContext=} [properties] Properties to set
                         */
                        function ImageContext(properties) {
                            this.languageHints = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ImageContext latLongRect.
                         * @member {google.cloud.vision.v1.ILatLongRect|null|undefined} latLongRect
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @instance
                         */
                        ImageContext.prototype.latLongRect = null;
    
                        /**
                         * ImageContext languageHints.
                         * @member {Array.<string>} languageHints
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @instance
                         */
                        ImageContext.prototype.languageHints = $util.emptyArray;
    
                        /**
                         * ImageContext cropHintsParams.
                         * @member {google.cloud.vision.v1.ICropHintsParams|null|undefined} cropHintsParams
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @instance
                         */
                        ImageContext.prototype.cropHintsParams = null;
    
                        /**
                         * ImageContext productSearchParams.
                         * @member {google.cloud.vision.v1.IProductSearchParams|null|undefined} productSearchParams
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @instance
                         */
                        ImageContext.prototype.productSearchParams = null;
    
                        /**
                         * ImageContext webDetectionParams.
                         * @member {google.cloud.vision.v1.IWebDetectionParams|null|undefined} webDetectionParams
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @instance
                         */
                        ImageContext.prototype.webDetectionParams = null;
    
                        /**
                         * ImageContext textDetectionParams.
                         * @member {google.cloud.vision.v1.ITextDetectionParams|null|undefined} textDetectionParams
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @instance
                         */
                        ImageContext.prototype.textDetectionParams = null;
    
                        /**
                         * Creates a new ImageContext instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @static
                         * @param {google.cloud.vision.v1.IImageContext=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.ImageContext} ImageContext instance
                         */
                        ImageContext.create = function create(properties) {
                            return new ImageContext(properties);
                        };
    
                        /**
                         * Encodes the specified ImageContext message. Does not implicitly {@link google.cloud.vision.v1.ImageContext.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @static
                         * @param {google.cloud.vision.v1.IImageContext} message ImageContext message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImageContext.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.latLongRect != null && Object.hasOwnProperty.call(message, "latLongRect"))
                                $root.google.cloud.vision.v1.LatLongRect.encode(message.latLongRect, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.languageHints != null && message.languageHints.length)
                                for (var i = 0; i < message.languageHints.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.languageHints[i]);
                            if (message.cropHintsParams != null && Object.hasOwnProperty.call(message, "cropHintsParams"))
                                $root.google.cloud.vision.v1.CropHintsParams.encode(message.cropHintsParams, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.productSearchParams != null && Object.hasOwnProperty.call(message, "productSearchParams"))
                                $root.google.cloud.vision.v1.ProductSearchParams.encode(message.productSearchParams, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.webDetectionParams != null && Object.hasOwnProperty.call(message, "webDetectionParams"))
                                $root.google.cloud.vision.v1.WebDetectionParams.encode(message.webDetectionParams, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.textDetectionParams != null && Object.hasOwnProperty.call(message, "textDetectionParams"))
                                $root.google.cloud.vision.v1.TextDetectionParams.encode(message.textDetectionParams, writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ImageContext message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImageContext.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @static
                         * @param {google.cloud.vision.v1.IImageContext} message ImageContext message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImageContext.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ImageContext message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.ImageContext} ImageContext
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImageContext.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.ImageContext();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.latLongRect = $root.google.cloud.vision.v1.LatLongRect.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        if (!(message.languageHints && message.languageHints.length))
                                            message.languageHints = [];
                                        message.languageHints.push(reader.string());
                                        break;
                                    }
                                case 4: {
                                        message.cropHintsParams = $root.google.cloud.vision.v1.CropHintsParams.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 5: {
                                        message.productSearchParams = $root.google.cloud.vision.v1.ProductSearchParams.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.webDetectionParams = $root.google.cloud.vision.v1.WebDetectionParams.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 12: {
                                        message.textDetectionParams = $root.google.cloud.vision.v1.TextDetectionParams.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ImageContext message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.ImageContext} ImageContext
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImageContext.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ImageContext message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ImageContext.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.latLongRect != null && message.hasOwnProperty("latLongRect")) {
                                var error = $root.google.cloud.vision.v1.LatLongRect.verify(message.latLongRect);
                                if (error)
                                    return "latLongRect." + error;
                            }
                            if (message.languageHints != null && message.hasOwnProperty("languageHints")) {
                                if (!Array.isArray(message.languageHints))
                                    return "languageHints: array expected";
                                for (var i = 0; i < message.languageHints.length; ++i)
                                    if (!$util.isString(message.languageHints[i]))
                                        return "languageHints: string[] expected";
                            }
                            if (message.cropHintsParams != null && message.hasOwnProperty("cropHintsParams")) {
                                var error = $root.google.cloud.vision.v1.CropHintsParams.verify(message.cropHintsParams);
                                if (error)
                                    return "cropHintsParams." + error;
                            }
                            if (message.productSearchParams != null && message.hasOwnProperty("productSearchParams")) {
                                var error = $root.google.cloud.vision.v1.ProductSearchParams.verify(message.productSearchParams);
                                if (error)
                                    return "productSearchParams." + error;
                            }
                            if (message.webDetectionParams != null && message.hasOwnProperty("webDetectionParams")) {
                                var error = $root.google.cloud.vision.v1.WebDetectionParams.verify(message.webDetectionParams);
                                if (error)
                                    return "webDetectionParams." + error;
                            }
                            if (message.textDetectionParams != null && message.hasOwnProperty("textDetectionParams")) {
                                var error = $root.google.cloud.vision.v1.TextDetectionParams.verify(message.textDetectionParams);
                                if (error)
                                    return "textDetectionParams." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an ImageContext message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.ImageContext} ImageContext
                         */
                        ImageContext.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.ImageContext)
                                return object;
                            var message = new $root.google.cloud.vision.v1.ImageContext();
                            if (object.latLongRect != null) {
                                if (typeof object.latLongRect !== "object")
                                    throw TypeError(".google.cloud.vision.v1.ImageContext.latLongRect: object expected");
                                message.latLongRect = $root.google.cloud.vision.v1.LatLongRect.fromObject(object.latLongRect);
                            }
                            if (object.languageHints) {
                                if (!Array.isArray(object.languageHints))
                                    throw TypeError(".google.cloud.vision.v1.ImageContext.languageHints: array expected");
                                message.languageHints = [];
                                for (var i = 0; i < object.languageHints.length; ++i)
                                    message.languageHints[i] = String(object.languageHints[i]);
                            }
                            if (object.cropHintsParams != null) {
                                if (typeof object.cropHintsParams !== "object")
                                    throw TypeError(".google.cloud.vision.v1.ImageContext.cropHintsParams: object expected");
                                message.cropHintsParams = $root.google.cloud.vision.v1.CropHintsParams.fromObject(object.cropHintsParams);
                            }
                            if (object.productSearchParams != null) {
                                if (typeof object.productSearchParams !== "object")
                                    throw TypeError(".google.cloud.vision.v1.ImageContext.productSearchParams: object expected");
                                message.productSearchParams = $root.google.cloud.vision.v1.ProductSearchParams.fromObject(object.productSearchParams);
                            }
                            if (object.webDetectionParams != null) {
                                if (typeof object.webDetectionParams !== "object")
                                    throw TypeError(".google.cloud.vision.v1.ImageContext.webDetectionParams: object expected");
                                message.webDetectionParams = $root.google.cloud.vision.v1.WebDetectionParams.fromObject(object.webDetectionParams);
                            }
                            if (object.textDetectionParams != null) {
                                if (typeof object.textDetectionParams !== "object")
                                    throw TypeError(".google.cloud.vision.v1.ImageContext.textDetectionParams: object expected");
                                message.textDetectionParams = $root.google.cloud.vision.v1.TextDetectionParams.fromObject(object.textDetectionParams);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ImageContext message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @static
                         * @param {google.cloud.vision.v1.ImageContext} message ImageContext
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ImageContext.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.languageHints = [];
                            if (options.defaults) {
                                object.latLongRect = null;
                                object.cropHintsParams = null;
                                object.productSearchParams = null;
                                object.webDetectionParams = null;
                                object.textDetectionParams = null;
                            }
                            if (message.latLongRect != null && message.hasOwnProperty("latLongRect"))
                                object.latLongRect = $root.google.cloud.vision.v1.LatLongRect.toObject(message.latLongRect, options);
                            if (message.languageHints && message.languageHints.length) {
                                object.languageHints = [];
                                for (var j = 0; j < message.languageHints.length; ++j)
                                    object.languageHints[j] = message.languageHints[j];
                            }
                            if (message.cropHintsParams != null && message.hasOwnProperty("cropHintsParams"))
                                object.cropHintsParams = $root.google.cloud.vision.v1.CropHintsParams.toObject(message.cropHintsParams, options);
                            if (message.productSearchParams != null && message.hasOwnProperty("productSearchParams"))
                                object.productSearchParams = $root.google.cloud.vision.v1.ProductSearchParams.toObject(message.productSearchParams, options);
                            if (message.webDetectionParams != null && message.hasOwnProperty("webDetectionParams"))
                                object.webDetectionParams = $root.google.cloud.vision.v1.WebDetectionParams.toObject(message.webDetectionParams, options);
                            if (message.textDetectionParams != null && message.hasOwnProperty("textDetectionParams"))
                                object.textDetectionParams = $root.google.cloud.vision.v1.TextDetectionParams.toObject(message.textDetectionParams, options);
                            return object;
                        };
    
                        /**
                         * Converts this ImageContext to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ImageContext.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ImageContext
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.ImageContext
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ImageContext.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.ImageContext";
                        };
    
                        return ImageContext;
                    })();
    
                    v1.AnnotateImageRequest = (function() {
    
                        /**
                         * Properties of an AnnotateImageRequest.
                         * @memberof google.cloud.vision.v1
                         * @interface IAnnotateImageRequest
                         * @property {google.cloud.vision.v1.IImage|null} [image] AnnotateImageRequest image
                         * @property {Array.<google.cloud.vision.v1.IFeature>|null} [features] AnnotateImageRequest features
                         * @property {google.cloud.vision.v1.IImageContext|null} [imageContext] AnnotateImageRequest imageContext
                         */
    
                        /**
                         * Constructs a new AnnotateImageRequest.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an AnnotateImageRequest.
                         * @implements IAnnotateImageRequest
                         * @constructor
                         * @param {google.cloud.vision.v1.IAnnotateImageRequest=} [properties] Properties to set
                         */
                        function AnnotateImageRequest(properties) {
                            this.features = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AnnotateImageRequest image.
                         * @member {google.cloud.vision.v1.IImage|null|undefined} image
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @instance
                         */
                        AnnotateImageRequest.prototype.image = null;
    
                        /**
                         * AnnotateImageRequest features.
                         * @member {Array.<google.cloud.vision.v1.IFeature>} features
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @instance
                         */
                        AnnotateImageRequest.prototype.features = $util.emptyArray;
    
                        /**
                         * AnnotateImageRequest imageContext.
                         * @member {google.cloud.vision.v1.IImageContext|null|undefined} imageContext
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @instance
                         */
                        AnnotateImageRequest.prototype.imageContext = null;
    
                        /**
                         * Creates a new AnnotateImageRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateImageRequest=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.AnnotateImageRequest} AnnotateImageRequest instance
                         */
                        AnnotateImageRequest.create = function create(properties) {
                            return new AnnotateImageRequest(properties);
                        };
    
                        /**
                         * Encodes the specified AnnotateImageRequest message. Does not implicitly {@link google.cloud.vision.v1.AnnotateImageRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateImageRequest} message AnnotateImageRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnnotateImageRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.image != null && Object.hasOwnProperty.call(message, "image"))
                                $root.google.cloud.vision.v1.Image.encode(message.image, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.features != null && message.features.length)
                                for (var i = 0; i < message.features.length; ++i)
                                    $root.google.cloud.vision.v1.Feature.encode(message.features[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.imageContext != null && Object.hasOwnProperty.call(message, "imageContext"))
                                $root.google.cloud.vision.v1.ImageContext.encode(message.imageContext, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AnnotateImageRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AnnotateImageRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateImageRequest} message AnnotateImageRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnnotateImageRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AnnotateImageRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.AnnotateImageRequest} AnnotateImageRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnnotateImageRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.AnnotateImageRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.image = $root.google.cloud.vision.v1.Image.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        if (!(message.features && message.features.length))
                                            message.features = [];
                                        message.features.push($root.google.cloud.vision.v1.Feature.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        message.imageContext = $root.google.cloud.vision.v1.ImageContext.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AnnotateImageRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.AnnotateImageRequest} AnnotateImageRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnnotateImageRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AnnotateImageRequest message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AnnotateImageRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.image != null && message.hasOwnProperty("image")) {
                                var error = $root.google.cloud.vision.v1.Image.verify(message.image);
                                if (error)
                                    return "image." + error;
                            }
                            if (message.features != null && message.hasOwnProperty("features")) {
                                if (!Array.isArray(message.features))
                                    return "features: array expected";
                                for (var i = 0; i < message.features.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.Feature.verify(message.features[i]);
                                    if (error)
                                        return "features." + error;
                                }
                            }
                            if (message.imageContext != null && message.hasOwnProperty("imageContext")) {
                                var error = $root.google.cloud.vision.v1.ImageContext.verify(message.imageContext);
                                if (error)
                                    return "imageContext." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AnnotateImageRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.AnnotateImageRequest} AnnotateImageRequest
                         */
                        AnnotateImageRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.AnnotateImageRequest)
                                return object;
                            var message = new $root.google.cloud.vision.v1.AnnotateImageRequest();
                            if (object.image != null) {
                                if (typeof object.image !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageRequest.image: object expected");
                                message.image = $root.google.cloud.vision.v1.Image.fromObject(object.image);
                            }
                            if (object.features) {
                                if (!Array.isArray(object.features))
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageRequest.features: array expected");
                                message.features = [];
                                for (var i = 0; i < object.features.length; ++i) {
                                    if (typeof object.features[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AnnotateImageRequest.features: object expected");
                                    message.features[i] = $root.google.cloud.vision.v1.Feature.fromObject(object.features[i]);
                                }
                            }
                            if (object.imageContext != null) {
                                if (typeof object.imageContext !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageRequest.imageContext: object expected");
                                message.imageContext = $root.google.cloud.vision.v1.ImageContext.fromObject(object.imageContext);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AnnotateImageRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @static
                         * @param {google.cloud.vision.v1.AnnotateImageRequest} message AnnotateImageRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AnnotateImageRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.features = [];
                            if (options.defaults) {
                                object.image = null;
                                object.imageContext = null;
                            }
                            if (message.image != null && message.hasOwnProperty("image"))
                                object.image = $root.google.cloud.vision.v1.Image.toObject(message.image, options);
                            if (message.features && message.features.length) {
                                object.features = [];
                                for (var j = 0; j < message.features.length; ++j)
                                    object.features[j] = $root.google.cloud.vision.v1.Feature.toObject(message.features[j], options);
                            }
                            if (message.imageContext != null && message.hasOwnProperty("imageContext"))
                                object.imageContext = $root.google.cloud.vision.v1.ImageContext.toObject(message.imageContext, options);
                            return object;
                        };
    
                        /**
                         * Converts this AnnotateImageRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AnnotateImageRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AnnotateImageRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.AnnotateImageRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AnnotateImageRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.AnnotateImageRequest";
                        };
    
                        return AnnotateImageRequest;
                    })();
    
                    v1.ImageAnnotationContext = (function() {
    
                        /**
                         * Properties of an ImageAnnotationContext.
                         * @memberof google.cloud.vision.v1
                         * @interface IImageAnnotationContext
                         * @property {string|null} [uri] ImageAnnotationContext uri
                         * @property {number|null} [pageNumber] ImageAnnotationContext pageNumber
                         */
    
                        /**
                         * Constructs a new ImageAnnotationContext.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an ImageAnnotationContext.
                         * @implements IImageAnnotationContext
                         * @constructor
                         * @param {google.cloud.vision.v1.IImageAnnotationContext=} [properties] Properties to set
                         */
                        function ImageAnnotationContext(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ImageAnnotationContext uri.
                         * @member {string} uri
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @instance
                         */
                        ImageAnnotationContext.prototype.uri = "";
    
                        /**
                         * ImageAnnotationContext pageNumber.
                         * @member {number} pageNumber
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @instance
                         */
                        ImageAnnotationContext.prototype.pageNumber = 0;
    
                        /**
                         * Creates a new ImageAnnotationContext instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @static
                         * @param {google.cloud.vision.v1.IImageAnnotationContext=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.ImageAnnotationContext} ImageAnnotationContext instance
                         */
                        ImageAnnotationContext.create = function create(properties) {
                            return new ImageAnnotationContext(properties);
                        };
    
                        /**
                         * Encodes the specified ImageAnnotationContext message. Does not implicitly {@link google.cloud.vision.v1.ImageAnnotationContext.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @static
                         * @param {google.cloud.vision.v1.IImageAnnotationContext} message ImageAnnotationContext message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImageAnnotationContext.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.uri != null && Object.hasOwnProperty.call(message, "uri"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.uri);
                            if (message.pageNumber != null && Object.hasOwnProperty.call(message, "pageNumber"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageNumber);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ImageAnnotationContext message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ImageAnnotationContext.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @static
                         * @param {google.cloud.vision.v1.IImageAnnotationContext} message ImageAnnotationContext message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImageAnnotationContext.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ImageAnnotationContext message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.ImageAnnotationContext} ImageAnnotationContext
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImageAnnotationContext.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.ImageAnnotationContext();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.uri = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageNumber = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ImageAnnotationContext message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.ImageAnnotationContext} ImageAnnotationContext
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImageAnnotationContext.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ImageAnnotationContext message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ImageAnnotationContext.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.uri != null && message.hasOwnProperty("uri"))
                                if (!$util.isString(message.uri))
                                    return "uri: string expected";
                            if (message.pageNumber != null && message.hasOwnProperty("pageNumber"))
                                if (!$util.isInteger(message.pageNumber))
                                    return "pageNumber: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates an ImageAnnotationContext message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.ImageAnnotationContext} ImageAnnotationContext
                         */
                        ImageAnnotationContext.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.ImageAnnotationContext)
                                return object;
                            var message = new $root.google.cloud.vision.v1.ImageAnnotationContext();
                            if (object.uri != null)
                                message.uri = String(object.uri);
                            if (object.pageNumber != null)
                                message.pageNumber = object.pageNumber | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ImageAnnotationContext message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @static
                         * @param {google.cloud.vision.v1.ImageAnnotationContext} message ImageAnnotationContext
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ImageAnnotationContext.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.uri = "";
                                object.pageNumber = 0;
                            }
                            if (message.uri != null && message.hasOwnProperty("uri"))
                                object.uri = message.uri;
                            if (message.pageNumber != null && message.hasOwnProperty("pageNumber"))
                                object.pageNumber = message.pageNumber;
                            return object;
                        };
    
                        /**
                         * Converts this ImageAnnotationContext to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ImageAnnotationContext.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ImageAnnotationContext
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.ImageAnnotationContext
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ImageAnnotationContext.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.ImageAnnotationContext";
                        };
    
                        return ImageAnnotationContext;
                    })();
    
                    v1.AnnotateImageResponse = (function() {
    
                        /**
                         * Properties of an AnnotateImageResponse.
                         * @memberof google.cloud.vision.v1
                         * @interface IAnnotateImageResponse
                         * @property {Array.<google.cloud.vision.v1.IFaceAnnotation>|null} [faceAnnotations] AnnotateImageResponse faceAnnotations
                         * @property {Array.<google.cloud.vision.v1.IEntityAnnotation>|null} [landmarkAnnotations] AnnotateImageResponse landmarkAnnotations
                         * @property {Array.<google.cloud.vision.v1.IEntityAnnotation>|null} [logoAnnotations] AnnotateImageResponse logoAnnotations
                         * @property {Array.<google.cloud.vision.v1.IEntityAnnotation>|null} [labelAnnotations] AnnotateImageResponse labelAnnotations
                         * @property {Array.<google.cloud.vision.v1.ILocalizedObjectAnnotation>|null} [localizedObjectAnnotations] AnnotateImageResponse localizedObjectAnnotations
                         * @property {Array.<google.cloud.vision.v1.IEntityAnnotation>|null} [textAnnotations] AnnotateImageResponse textAnnotations
                         * @property {google.cloud.vision.v1.ITextAnnotation|null} [fullTextAnnotation] AnnotateImageResponse fullTextAnnotation
                         * @property {google.cloud.vision.v1.ISafeSearchAnnotation|null} [safeSearchAnnotation] AnnotateImageResponse safeSearchAnnotation
                         * @property {google.cloud.vision.v1.IImageProperties|null} [imagePropertiesAnnotation] AnnotateImageResponse imagePropertiesAnnotation
                         * @property {google.cloud.vision.v1.ICropHintsAnnotation|null} [cropHintsAnnotation] AnnotateImageResponse cropHintsAnnotation
                         * @property {google.cloud.vision.v1.IWebDetection|null} [webDetection] AnnotateImageResponse webDetection
                         * @property {google.cloud.vision.v1.IProductSearchResults|null} [productSearchResults] AnnotateImageResponse productSearchResults
                         * @property {google.rpc.IStatus|null} [error] AnnotateImageResponse error
                         * @property {google.cloud.vision.v1.IImageAnnotationContext|null} [context] AnnotateImageResponse context
                         */
    
                        /**
                         * Constructs a new AnnotateImageResponse.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an AnnotateImageResponse.
                         * @implements IAnnotateImageResponse
                         * @constructor
                         * @param {google.cloud.vision.v1.IAnnotateImageResponse=} [properties] Properties to set
                         */
                        function AnnotateImageResponse(properties) {
                            this.faceAnnotations = [];
                            this.landmarkAnnotations = [];
                            this.logoAnnotations = [];
                            this.labelAnnotations = [];
                            this.localizedObjectAnnotations = [];
                            this.textAnnotations = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AnnotateImageResponse faceAnnotations.
                         * @member {Array.<google.cloud.vision.v1.IFaceAnnotation>} faceAnnotations
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.faceAnnotations = $util.emptyArray;
    
                        /**
                         * AnnotateImageResponse landmarkAnnotations.
                         * @member {Array.<google.cloud.vision.v1.IEntityAnnotation>} landmarkAnnotations
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.landmarkAnnotations = $util.emptyArray;
    
                        /**
                         * AnnotateImageResponse logoAnnotations.
                         * @member {Array.<google.cloud.vision.v1.IEntityAnnotation>} logoAnnotations
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.logoAnnotations = $util.emptyArray;
    
                        /**
                         * AnnotateImageResponse labelAnnotations.
                         * @member {Array.<google.cloud.vision.v1.IEntityAnnotation>} labelAnnotations
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.labelAnnotations = $util.emptyArray;
    
                        /**
                         * AnnotateImageResponse localizedObjectAnnotations.
                         * @member {Array.<google.cloud.vision.v1.ILocalizedObjectAnnotation>} localizedObjectAnnotations
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.localizedObjectAnnotations = $util.emptyArray;
    
                        /**
                         * AnnotateImageResponse textAnnotations.
                         * @member {Array.<google.cloud.vision.v1.IEntityAnnotation>} textAnnotations
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.textAnnotations = $util.emptyArray;
    
                        /**
                         * AnnotateImageResponse fullTextAnnotation.
                         * @member {google.cloud.vision.v1.ITextAnnotation|null|undefined} fullTextAnnotation
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.fullTextAnnotation = null;
    
                        /**
                         * AnnotateImageResponse safeSearchAnnotation.
                         * @member {google.cloud.vision.v1.ISafeSearchAnnotation|null|undefined} safeSearchAnnotation
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.safeSearchAnnotation = null;
    
                        /**
                         * AnnotateImageResponse imagePropertiesAnnotation.
                         * @member {google.cloud.vision.v1.IImageProperties|null|undefined} imagePropertiesAnnotation
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.imagePropertiesAnnotation = null;
    
                        /**
                         * AnnotateImageResponse cropHintsAnnotation.
                         * @member {google.cloud.vision.v1.ICropHintsAnnotation|null|undefined} cropHintsAnnotation
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.cropHintsAnnotation = null;
    
                        /**
                         * AnnotateImageResponse webDetection.
                         * @member {google.cloud.vision.v1.IWebDetection|null|undefined} webDetection
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.webDetection = null;
    
                        /**
                         * AnnotateImageResponse productSearchResults.
                         * @member {google.cloud.vision.v1.IProductSearchResults|null|undefined} productSearchResults
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.productSearchResults = null;
    
                        /**
                         * AnnotateImageResponse error.
                         * @member {google.rpc.IStatus|null|undefined} error
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.error = null;
    
                        /**
                         * AnnotateImageResponse context.
                         * @member {google.cloud.vision.v1.IImageAnnotationContext|null|undefined} context
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         */
                        AnnotateImageResponse.prototype.context = null;
    
                        /**
                         * Creates a new AnnotateImageResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateImageResponse=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.AnnotateImageResponse} AnnotateImageResponse instance
                         */
                        AnnotateImageResponse.create = function create(properties) {
                            return new AnnotateImageResponse(properties);
                        };
    
                        /**
                         * Encodes the specified AnnotateImageResponse message. Does not implicitly {@link google.cloud.vision.v1.AnnotateImageResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateImageResponse} message AnnotateImageResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnnotateImageResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.faceAnnotations != null && message.faceAnnotations.length)
                                for (var i = 0; i < message.faceAnnotations.length; ++i)
                                    $root.google.cloud.vision.v1.FaceAnnotation.encode(message.faceAnnotations[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.landmarkAnnotations != null && message.landmarkAnnotations.length)
                                for (var i = 0; i < message.landmarkAnnotations.length; ++i)
                                    $root.google.cloud.vision.v1.EntityAnnotation.encode(message.landmarkAnnotations[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.logoAnnotations != null && message.logoAnnotations.length)
                                for (var i = 0; i < message.logoAnnotations.length; ++i)
                                    $root.google.cloud.vision.v1.EntityAnnotation.encode(message.logoAnnotations[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.labelAnnotations != null && message.labelAnnotations.length)
                                for (var i = 0; i < message.labelAnnotations.length; ++i)
                                    $root.google.cloud.vision.v1.EntityAnnotation.encode(message.labelAnnotations[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.textAnnotations != null && message.textAnnotations.length)
                                for (var i = 0; i < message.textAnnotations.length; ++i)
                                    $root.google.cloud.vision.v1.EntityAnnotation.encode(message.textAnnotations[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.safeSearchAnnotation != null && Object.hasOwnProperty.call(message, "safeSearchAnnotation"))
                                $root.google.cloud.vision.v1.SafeSearchAnnotation.encode(message.safeSearchAnnotation, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.imagePropertiesAnnotation != null && Object.hasOwnProperty.call(message, "imagePropertiesAnnotation"))
                                $root.google.cloud.vision.v1.ImageProperties.encode(message.imagePropertiesAnnotation, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                                $root.google.rpc.Status.encode(message.error, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            if (message.cropHintsAnnotation != null && Object.hasOwnProperty.call(message, "cropHintsAnnotation"))
                                $root.google.cloud.vision.v1.CropHintsAnnotation.encode(message.cropHintsAnnotation, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                            if (message.fullTextAnnotation != null && Object.hasOwnProperty.call(message, "fullTextAnnotation"))
                                $root.google.cloud.vision.v1.TextAnnotation.encode(message.fullTextAnnotation, writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
                            if (message.webDetection != null && Object.hasOwnProperty.call(message, "webDetection"))
                                $root.google.cloud.vision.v1.WebDetection.encode(message.webDetection, writer.uint32(/* id 13, wireType 2 =*/106).fork()).ldelim();
                            if (message.productSearchResults != null && Object.hasOwnProperty.call(message, "productSearchResults"))
                                $root.google.cloud.vision.v1.ProductSearchResults.encode(message.productSearchResults, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
                            if (message.context != null && Object.hasOwnProperty.call(message, "context"))
                                $root.google.cloud.vision.v1.ImageAnnotationContext.encode(message.context, writer.uint32(/* id 21, wireType 2 =*/170).fork()).ldelim();
                            if (message.localizedObjectAnnotations != null && message.localizedObjectAnnotations.length)
                                for (var i = 0; i < message.localizedObjectAnnotations.length; ++i)
                                    $root.google.cloud.vision.v1.LocalizedObjectAnnotation.encode(message.localizedObjectAnnotations[i], writer.uint32(/* id 22, wireType 2 =*/178).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AnnotateImageResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AnnotateImageResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateImageResponse} message AnnotateImageResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnnotateImageResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AnnotateImageResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.AnnotateImageResponse} AnnotateImageResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnnotateImageResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.AnnotateImageResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.faceAnnotations && message.faceAnnotations.length))
                                            message.faceAnnotations = [];
                                        message.faceAnnotations.push($root.google.cloud.vision.v1.FaceAnnotation.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        if (!(message.landmarkAnnotations && message.landmarkAnnotations.length))
                                            message.landmarkAnnotations = [];
                                        message.landmarkAnnotations.push($root.google.cloud.vision.v1.EntityAnnotation.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        if (!(message.logoAnnotations && message.logoAnnotations.length))
                                            message.logoAnnotations = [];
                                        message.logoAnnotations.push($root.google.cloud.vision.v1.EntityAnnotation.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 4: {
                                        if (!(message.labelAnnotations && message.labelAnnotations.length))
                                            message.labelAnnotations = [];
                                        message.labelAnnotations.push($root.google.cloud.vision.v1.EntityAnnotation.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 22: {
                                        if (!(message.localizedObjectAnnotations && message.localizedObjectAnnotations.length))
                                            message.localizedObjectAnnotations = [];
                                        message.localizedObjectAnnotations.push($root.google.cloud.vision.v1.LocalizedObjectAnnotation.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 5: {
                                        if (!(message.textAnnotations && message.textAnnotations.length))
                                            message.textAnnotations = [];
                                        message.textAnnotations.push($root.google.cloud.vision.v1.EntityAnnotation.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 12: {
                                        message.fullTextAnnotation = $root.google.cloud.vision.v1.TextAnnotation.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.safeSearchAnnotation = $root.google.cloud.vision.v1.SafeSearchAnnotation.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        message.imagePropertiesAnnotation = $root.google.cloud.vision.v1.ImageProperties.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 11: {
                                        message.cropHintsAnnotation = $root.google.cloud.vision.v1.CropHintsAnnotation.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 13: {
                                        message.webDetection = $root.google.cloud.vision.v1.WebDetection.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 14: {
                                        message.productSearchResults = $root.google.cloud.vision.v1.ProductSearchResults.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 9: {
                                        message.error = $root.google.rpc.Status.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 21: {
                                        message.context = $root.google.cloud.vision.v1.ImageAnnotationContext.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AnnotateImageResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.AnnotateImageResponse} AnnotateImageResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnnotateImageResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AnnotateImageResponse message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AnnotateImageResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.faceAnnotations != null && message.hasOwnProperty("faceAnnotations")) {
                                if (!Array.isArray(message.faceAnnotations))
                                    return "faceAnnotations: array expected";
                                for (var i = 0; i < message.faceAnnotations.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.FaceAnnotation.verify(message.faceAnnotations[i]);
                                    if (error)
                                        return "faceAnnotations." + error;
                                }
                            }
                            if (message.landmarkAnnotations != null && message.hasOwnProperty("landmarkAnnotations")) {
                                if (!Array.isArray(message.landmarkAnnotations))
                                    return "landmarkAnnotations: array expected";
                                for (var i = 0; i < message.landmarkAnnotations.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.EntityAnnotation.verify(message.landmarkAnnotations[i]);
                                    if (error)
                                        return "landmarkAnnotations." + error;
                                }
                            }
                            if (message.logoAnnotations != null && message.hasOwnProperty("logoAnnotations")) {
                                if (!Array.isArray(message.logoAnnotations))
                                    return "logoAnnotations: array expected";
                                for (var i = 0; i < message.logoAnnotations.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.EntityAnnotation.verify(message.logoAnnotations[i]);
                                    if (error)
                                        return "logoAnnotations." + error;
                                }
                            }
                            if (message.labelAnnotations != null && message.hasOwnProperty("labelAnnotations")) {
                                if (!Array.isArray(message.labelAnnotations))
                                    return "labelAnnotations: array expected";
                                for (var i = 0; i < message.labelAnnotations.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.EntityAnnotation.verify(message.labelAnnotations[i]);
                                    if (error)
                                        return "labelAnnotations." + error;
                                }
                            }
                            if (message.localizedObjectAnnotations != null && message.hasOwnProperty("localizedObjectAnnotations")) {
                                if (!Array.isArray(message.localizedObjectAnnotations))
                                    return "localizedObjectAnnotations: array expected";
                                for (var i = 0; i < message.localizedObjectAnnotations.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.LocalizedObjectAnnotation.verify(message.localizedObjectAnnotations[i]);
                                    if (error)
                                        return "localizedObjectAnnotations." + error;
                                }
                            }
                            if (message.textAnnotations != null && message.hasOwnProperty("textAnnotations")) {
                                if (!Array.isArray(message.textAnnotations))
                                    return "textAnnotations: array expected";
                                for (var i = 0; i < message.textAnnotations.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.EntityAnnotation.verify(message.textAnnotations[i]);
                                    if (error)
                                        return "textAnnotations." + error;
                                }
                            }
                            if (message.fullTextAnnotation != null && message.hasOwnProperty("fullTextAnnotation")) {
                                var error = $root.google.cloud.vision.v1.TextAnnotation.verify(message.fullTextAnnotation);
                                if (error)
                                    return "fullTextAnnotation." + error;
                            }
                            if (message.safeSearchAnnotation != null && message.hasOwnProperty("safeSearchAnnotation")) {
                                var error = $root.google.cloud.vision.v1.SafeSearchAnnotation.verify(message.safeSearchAnnotation);
                                if (error)
                                    return "safeSearchAnnotation." + error;
                            }
                            if (message.imagePropertiesAnnotation != null && message.hasOwnProperty("imagePropertiesAnnotation")) {
                                var error = $root.google.cloud.vision.v1.ImageProperties.verify(message.imagePropertiesAnnotation);
                                if (error)
                                    return "imagePropertiesAnnotation." + error;
                            }
                            if (message.cropHintsAnnotation != null && message.hasOwnProperty("cropHintsAnnotation")) {
                                var error = $root.google.cloud.vision.v1.CropHintsAnnotation.verify(message.cropHintsAnnotation);
                                if (error)
                                    return "cropHintsAnnotation." + error;
                            }
                            if (message.webDetection != null && message.hasOwnProperty("webDetection")) {
                                var error = $root.google.cloud.vision.v1.WebDetection.verify(message.webDetection);
                                if (error)
                                    return "webDetection." + error;
                            }
                            if (message.productSearchResults != null && message.hasOwnProperty("productSearchResults")) {
                                var error = $root.google.cloud.vision.v1.ProductSearchResults.verify(message.productSearchResults);
                                if (error)
                                    return "productSearchResults." + error;
                            }
                            if (message.error != null && message.hasOwnProperty("error")) {
                                var error = $root.google.rpc.Status.verify(message.error);
                                if (error)
                                    return "error." + error;
                            }
                            if (message.context != null && message.hasOwnProperty("context")) {
                                var error = $root.google.cloud.vision.v1.ImageAnnotationContext.verify(message.context);
                                if (error)
                                    return "context." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AnnotateImageResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.AnnotateImageResponse} AnnotateImageResponse
                         */
                        AnnotateImageResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.AnnotateImageResponse)
                                return object;
                            var message = new $root.google.cloud.vision.v1.AnnotateImageResponse();
                            if (object.faceAnnotations) {
                                if (!Array.isArray(object.faceAnnotations))
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.faceAnnotations: array expected");
                                message.faceAnnotations = [];
                                for (var i = 0; i < object.faceAnnotations.length; ++i) {
                                    if (typeof object.faceAnnotations[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.faceAnnotations: object expected");
                                    message.faceAnnotations[i] = $root.google.cloud.vision.v1.FaceAnnotation.fromObject(object.faceAnnotations[i]);
                                }
                            }
                            if (object.landmarkAnnotations) {
                                if (!Array.isArray(object.landmarkAnnotations))
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.landmarkAnnotations: array expected");
                                message.landmarkAnnotations = [];
                                for (var i = 0; i < object.landmarkAnnotations.length; ++i) {
                                    if (typeof object.landmarkAnnotations[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.landmarkAnnotations: object expected");
                                    message.landmarkAnnotations[i] = $root.google.cloud.vision.v1.EntityAnnotation.fromObject(object.landmarkAnnotations[i]);
                                }
                            }
                            if (object.logoAnnotations) {
                                if (!Array.isArray(object.logoAnnotations))
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.logoAnnotations: array expected");
                                message.logoAnnotations = [];
                                for (var i = 0; i < object.logoAnnotations.length; ++i) {
                                    if (typeof object.logoAnnotations[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.logoAnnotations: object expected");
                                    message.logoAnnotations[i] = $root.google.cloud.vision.v1.EntityAnnotation.fromObject(object.logoAnnotations[i]);
                                }
                            }
                            if (object.labelAnnotations) {
                                if (!Array.isArray(object.labelAnnotations))
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.labelAnnotations: array expected");
                                message.labelAnnotations = [];
                                for (var i = 0; i < object.labelAnnotations.length; ++i) {
                                    if (typeof object.labelAnnotations[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.labelAnnotations: object expected");
                                    message.labelAnnotations[i] = $root.google.cloud.vision.v1.EntityAnnotation.fromObject(object.labelAnnotations[i]);
                                }
                            }
                            if (object.localizedObjectAnnotations) {
                                if (!Array.isArray(object.localizedObjectAnnotations))
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.localizedObjectAnnotations: array expected");
                                message.localizedObjectAnnotations = [];
                                for (var i = 0; i < object.localizedObjectAnnotations.length; ++i) {
                                    if (typeof object.localizedObjectAnnotations[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.localizedObjectAnnotations: object expected");
                                    message.localizedObjectAnnotations[i] = $root.google.cloud.vision.v1.LocalizedObjectAnnotation.fromObject(object.localizedObjectAnnotations[i]);
                                }
                            }
                            if (object.textAnnotations) {
                                if (!Array.isArray(object.textAnnotations))
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.textAnnotations: array expected");
                                message.textAnnotations = [];
                                for (var i = 0; i < object.textAnnotations.length; ++i) {
                                    if (typeof object.textAnnotations[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.textAnnotations: object expected");
                                    message.textAnnotations[i] = $root.google.cloud.vision.v1.EntityAnnotation.fromObject(object.textAnnotations[i]);
                                }
                            }
                            if (object.fullTextAnnotation != null) {
                                if (typeof object.fullTextAnnotation !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.fullTextAnnotation: object expected");
                                message.fullTextAnnotation = $root.google.cloud.vision.v1.TextAnnotation.fromObject(object.fullTextAnnotation);
                            }
                            if (object.safeSearchAnnotation != null) {
                                if (typeof object.safeSearchAnnotation !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.safeSearchAnnotation: object expected");
                                message.safeSearchAnnotation = $root.google.cloud.vision.v1.SafeSearchAnnotation.fromObject(object.safeSearchAnnotation);
                            }
                            if (object.imagePropertiesAnnotation != null) {
                                if (typeof object.imagePropertiesAnnotation !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.imagePropertiesAnnotation: object expected");
                                message.imagePropertiesAnnotation = $root.google.cloud.vision.v1.ImageProperties.fromObject(object.imagePropertiesAnnotation);
                            }
                            if (object.cropHintsAnnotation != null) {
                                if (typeof object.cropHintsAnnotation !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.cropHintsAnnotation: object expected");
                                message.cropHintsAnnotation = $root.google.cloud.vision.v1.CropHintsAnnotation.fromObject(object.cropHintsAnnotation);
                            }
                            if (object.webDetection != null) {
                                if (typeof object.webDetection !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.webDetection: object expected");
                                message.webDetection = $root.google.cloud.vision.v1.WebDetection.fromObject(object.webDetection);
                            }
                            if (object.productSearchResults != null) {
                                if (typeof object.productSearchResults !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.productSearchResults: object expected");
                                message.productSearchResults = $root.google.cloud.vision.v1.ProductSearchResults.fromObject(object.productSearchResults);
                            }
                            if (object.error != null) {
                                if (typeof object.error !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.error: object expected");
                                message.error = $root.google.rpc.Status.fromObject(object.error);
                            }
                            if (object.context != null) {
                                if (typeof object.context !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateImageResponse.context: object expected");
                                message.context = $root.google.cloud.vision.v1.ImageAnnotationContext.fromObject(object.context);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AnnotateImageResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @static
                         * @param {google.cloud.vision.v1.AnnotateImageResponse} message AnnotateImageResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AnnotateImageResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.faceAnnotations = [];
                                object.landmarkAnnotations = [];
                                object.logoAnnotations = [];
                                object.labelAnnotations = [];
                                object.textAnnotations = [];
                                object.localizedObjectAnnotations = [];
                            }
                            if (options.defaults) {
                                object.safeSearchAnnotation = null;
                                object.imagePropertiesAnnotation = null;
                                object.error = null;
                                object.cropHintsAnnotation = null;
                                object.fullTextAnnotation = null;
                                object.webDetection = null;
                                object.productSearchResults = null;
                                object.context = null;
                            }
                            if (message.faceAnnotations && message.faceAnnotations.length) {
                                object.faceAnnotations = [];
                                for (var j = 0; j < message.faceAnnotations.length; ++j)
                                    object.faceAnnotations[j] = $root.google.cloud.vision.v1.FaceAnnotation.toObject(message.faceAnnotations[j], options);
                            }
                            if (message.landmarkAnnotations && message.landmarkAnnotations.length) {
                                object.landmarkAnnotations = [];
                                for (var j = 0; j < message.landmarkAnnotations.length; ++j)
                                    object.landmarkAnnotations[j] = $root.google.cloud.vision.v1.EntityAnnotation.toObject(message.landmarkAnnotations[j], options);
                            }
                            if (message.logoAnnotations && message.logoAnnotations.length) {
                                object.logoAnnotations = [];
                                for (var j = 0; j < message.logoAnnotations.length; ++j)
                                    object.logoAnnotations[j] = $root.google.cloud.vision.v1.EntityAnnotation.toObject(message.logoAnnotations[j], options);
                            }
                            if (message.labelAnnotations && message.labelAnnotations.length) {
                                object.labelAnnotations = [];
                                for (var j = 0; j < message.labelAnnotations.length; ++j)
                                    object.labelAnnotations[j] = $root.google.cloud.vision.v1.EntityAnnotation.toObject(message.labelAnnotations[j], options);
                            }
                            if (message.textAnnotations && message.textAnnotations.length) {
                                object.textAnnotations = [];
                                for (var j = 0; j < message.textAnnotations.length; ++j)
                                    object.textAnnotations[j] = $root.google.cloud.vision.v1.EntityAnnotation.toObject(message.textAnnotations[j], options);
                            }
                            if (message.safeSearchAnnotation != null && message.hasOwnProperty("safeSearchAnnotation"))
                                object.safeSearchAnnotation = $root.google.cloud.vision.v1.SafeSearchAnnotation.toObject(message.safeSearchAnnotation, options);
                            if (message.imagePropertiesAnnotation != null && message.hasOwnProperty("imagePropertiesAnnotation"))
                                object.imagePropertiesAnnotation = $root.google.cloud.vision.v1.ImageProperties.toObject(message.imagePropertiesAnnotation, options);
                            if (message.error != null && message.hasOwnProperty("error"))
                                object.error = $root.google.rpc.Status.toObject(message.error, options);
                            if (message.cropHintsAnnotation != null && message.hasOwnProperty("cropHintsAnnotation"))
                                object.cropHintsAnnotation = $root.google.cloud.vision.v1.CropHintsAnnotation.toObject(message.cropHintsAnnotation, options);
                            if (message.fullTextAnnotation != null && message.hasOwnProperty("fullTextAnnotation"))
                                object.fullTextAnnotation = $root.google.cloud.vision.v1.TextAnnotation.toObject(message.fullTextAnnotation, options);
                            if (message.webDetection != null && message.hasOwnProperty("webDetection"))
                                object.webDetection = $root.google.cloud.vision.v1.WebDetection.toObject(message.webDetection, options);
                            if (message.productSearchResults != null && message.hasOwnProperty("productSearchResults"))
                                object.productSearchResults = $root.google.cloud.vision.v1.ProductSearchResults.toObject(message.productSearchResults, options);
                            if (message.context != null && message.hasOwnProperty("context"))
                                object.context = $root.google.cloud.vision.v1.ImageAnnotationContext.toObject(message.context, options);
                            if (message.localizedObjectAnnotations && message.localizedObjectAnnotations.length) {
                                object.localizedObjectAnnotations = [];
                                for (var j = 0; j < message.localizedObjectAnnotations.length; ++j)
                                    object.localizedObjectAnnotations[j] = $root.google.cloud.vision.v1.LocalizedObjectAnnotation.toObject(message.localizedObjectAnnotations[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AnnotateImageResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AnnotateImageResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AnnotateImageResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.AnnotateImageResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AnnotateImageResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.AnnotateImageResponse";
                        };
    
                        return AnnotateImageResponse;
                    })();
    
                    v1.BatchAnnotateImagesRequest = (function() {
    
                        /**
                         * Properties of a BatchAnnotateImagesRequest.
                         * @memberof google.cloud.vision.v1
                         * @interface IBatchAnnotateImagesRequest
                         * @property {Array.<google.cloud.vision.v1.IAnnotateImageRequest>|null} [requests] BatchAnnotateImagesRequest requests
                         * @property {string|null} [parent] BatchAnnotateImagesRequest parent
                         * @property {Object.<string,string>|null} [labels] BatchAnnotateImagesRequest labels
                         */
    
                        /**
                         * Constructs a new BatchAnnotateImagesRequest.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a BatchAnnotateImagesRequest.
                         * @implements IBatchAnnotateImagesRequest
                         * @constructor
                         * @param {google.cloud.vision.v1.IBatchAnnotateImagesRequest=} [properties] Properties to set
                         */
                        function BatchAnnotateImagesRequest(properties) {
                            this.requests = [];
                            this.labels = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * BatchAnnotateImagesRequest requests.
                         * @member {Array.<google.cloud.vision.v1.IAnnotateImageRequest>} requests
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @instance
                         */
                        BatchAnnotateImagesRequest.prototype.requests = $util.emptyArray;
    
                        /**
                         * BatchAnnotateImagesRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @instance
                         */
                        BatchAnnotateImagesRequest.prototype.parent = "";
    
                        /**
                         * BatchAnnotateImagesRequest labels.
                         * @member {Object.<string,string>} labels
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @instance
                         */
                        BatchAnnotateImagesRequest.prototype.labels = $util.emptyObject;
    
                        /**
                         * Creates a new BatchAnnotateImagesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateImagesRequest=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.BatchAnnotateImagesRequest} BatchAnnotateImagesRequest instance
                         */
                        BatchAnnotateImagesRequest.create = function create(properties) {
                            return new BatchAnnotateImagesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified BatchAnnotateImagesRequest message. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateImagesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateImagesRequest} message BatchAnnotateImagesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchAnnotateImagesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.requests != null && message.requests.length)
                                for (var i = 0; i < message.requests.length; ++i)
                                    $root.google.cloud.vision.v1.AnnotateImageRequest.encode(message.requests[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.parent);
                            if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                                for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 5, wireType 2 =*/42).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified BatchAnnotateImagesRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateImagesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateImagesRequest} message BatchAnnotateImagesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchAnnotateImagesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a BatchAnnotateImagesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.BatchAnnotateImagesRequest} BatchAnnotateImagesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchAnnotateImagesRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.BatchAnnotateImagesRequest(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.requests && message.requests.length))
                                            message.requests = [];
                                        message.requests.push($root.google.cloud.vision.v1.AnnotateImageRequest.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 4: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 5: {
                                        if (message.labels === $util.emptyObject)
                                            message.labels = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = "";
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.string();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.labels[key] = value;
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a BatchAnnotateImagesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.BatchAnnotateImagesRequest} BatchAnnotateImagesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchAnnotateImagesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a BatchAnnotateImagesRequest message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        BatchAnnotateImagesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.requests != null && message.hasOwnProperty("requests")) {
                                if (!Array.isArray(message.requests))
                                    return "requests: array expected";
                                for (var i = 0; i < message.requests.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.AnnotateImageRequest.verify(message.requests[i]);
                                    if (error)
                                        return "requests." + error;
                                }
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.labels != null && message.hasOwnProperty("labels")) {
                                if (!$util.isObject(message.labels))
                                    return "labels: object expected";
                                var key = Object.keys(message.labels);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.labels[key[i]]))
                                        return "labels: string{k:string} expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a BatchAnnotateImagesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.BatchAnnotateImagesRequest} BatchAnnotateImagesRequest
                         */
                        BatchAnnotateImagesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.BatchAnnotateImagesRequest)
                                return object;
                            var message = new $root.google.cloud.vision.v1.BatchAnnotateImagesRequest();
                            if (object.requests) {
                                if (!Array.isArray(object.requests))
                                    throw TypeError(".google.cloud.vision.v1.BatchAnnotateImagesRequest.requests: array expected");
                                message.requests = [];
                                for (var i = 0; i < object.requests.length; ++i) {
                                    if (typeof object.requests[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.BatchAnnotateImagesRequest.requests: object expected");
                                    message.requests[i] = $root.google.cloud.vision.v1.AnnotateImageRequest.fromObject(object.requests[i]);
                                }
                            }
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.labels) {
                                if (typeof object.labels !== "object")
                                    throw TypeError(".google.cloud.vision.v1.BatchAnnotateImagesRequest.labels: object expected");
                                message.labels = {};
                                for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                    message.labels[keys[i]] = String(object.labels[keys[i]]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a BatchAnnotateImagesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @static
                         * @param {google.cloud.vision.v1.BatchAnnotateImagesRequest} message BatchAnnotateImagesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        BatchAnnotateImagesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.requests = [];
                            if (options.objects || options.defaults)
                                object.labels = {};
                            if (options.defaults)
                                object.parent = "";
                            if (message.requests && message.requests.length) {
                                object.requests = [];
                                for (var j = 0; j < message.requests.length; ++j)
                                    object.requests[j] = $root.google.cloud.vision.v1.AnnotateImageRequest.toObject(message.requests[j], options);
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            var keys2;
                            if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                                object.labels = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.labels[keys2[j]] = message.labels[keys2[j]];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this BatchAnnotateImagesRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        BatchAnnotateImagesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for BatchAnnotateImagesRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        BatchAnnotateImagesRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.BatchAnnotateImagesRequest";
                        };
    
                        return BatchAnnotateImagesRequest;
                    })();
    
                    v1.BatchAnnotateImagesResponse = (function() {
    
                        /**
                         * Properties of a BatchAnnotateImagesResponse.
                         * @memberof google.cloud.vision.v1
                         * @interface IBatchAnnotateImagesResponse
                         * @property {Array.<google.cloud.vision.v1.IAnnotateImageResponse>|null} [responses] BatchAnnotateImagesResponse responses
                         */
    
                        /**
                         * Constructs a new BatchAnnotateImagesResponse.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a BatchAnnotateImagesResponse.
                         * @implements IBatchAnnotateImagesResponse
                         * @constructor
                         * @param {google.cloud.vision.v1.IBatchAnnotateImagesResponse=} [properties] Properties to set
                         */
                        function BatchAnnotateImagesResponse(properties) {
                            this.responses = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * BatchAnnotateImagesResponse responses.
                         * @member {Array.<google.cloud.vision.v1.IAnnotateImageResponse>} responses
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @instance
                         */
                        BatchAnnotateImagesResponse.prototype.responses = $util.emptyArray;
    
                        /**
                         * Creates a new BatchAnnotateImagesResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateImagesResponse=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.BatchAnnotateImagesResponse} BatchAnnotateImagesResponse instance
                         */
                        BatchAnnotateImagesResponse.create = function create(properties) {
                            return new BatchAnnotateImagesResponse(properties);
                        };
    
                        /**
                         * Encodes the specified BatchAnnotateImagesResponse message. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateImagesResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateImagesResponse} message BatchAnnotateImagesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchAnnotateImagesResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.responses != null && message.responses.length)
                                for (var i = 0; i < message.responses.length; ++i)
                                    $root.google.cloud.vision.v1.AnnotateImageResponse.encode(message.responses[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified BatchAnnotateImagesResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateImagesResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateImagesResponse} message BatchAnnotateImagesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchAnnotateImagesResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a BatchAnnotateImagesResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.BatchAnnotateImagesResponse} BatchAnnotateImagesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchAnnotateImagesResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.BatchAnnotateImagesResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.responses && message.responses.length))
                                            message.responses = [];
                                        message.responses.push($root.google.cloud.vision.v1.AnnotateImageResponse.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a BatchAnnotateImagesResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.BatchAnnotateImagesResponse} BatchAnnotateImagesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchAnnotateImagesResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a BatchAnnotateImagesResponse message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        BatchAnnotateImagesResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.responses != null && message.hasOwnProperty("responses")) {
                                if (!Array.isArray(message.responses))
                                    return "responses: array expected";
                                for (var i = 0; i < message.responses.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.AnnotateImageResponse.verify(message.responses[i]);
                                    if (error)
                                        return "responses." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a BatchAnnotateImagesResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.BatchAnnotateImagesResponse} BatchAnnotateImagesResponse
                         */
                        BatchAnnotateImagesResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.BatchAnnotateImagesResponse)
                                return object;
                            var message = new $root.google.cloud.vision.v1.BatchAnnotateImagesResponse();
                            if (object.responses) {
                                if (!Array.isArray(object.responses))
                                    throw TypeError(".google.cloud.vision.v1.BatchAnnotateImagesResponse.responses: array expected");
                                message.responses = [];
                                for (var i = 0; i < object.responses.length; ++i) {
                                    if (typeof object.responses[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.BatchAnnotateImagesResponse.responses: object expected");
                                    message.responses[i] = $root.google.cloud.vision.v1.AnnotateImageResponse.fromObject(object.responses[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a BatchAnnotateImagesResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @static
                         * @param {google.cloud.vision.v1.BatchAnnotateImagesResponse} message BatchAnnotateImagesResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        BatchAnnotateImagesResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.responses = [];
                            if (message.responses && message.responses.length) {
                                object.responses = [];
                                for (var j = 0; j < message.responses.length; ++j)
                                    object.responses[j] = $root.google.cloud.vision.v1.AnnotateImageResponse.toObject(message.responses[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this BatchAnnotateImagesResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        BatchAnnotateImagesResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for BatchAnnotateImagesResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.BatchAnnotateImagesResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        BatchAnnotateImagesResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.BatchAnnotateImagesResponse";
                        };
    
                        return BatchAnnotateImagesResponse;
                    })();
    
                    v1.AnnotateFileRequest = (function() {
    
                        /**
                         * Properties of an AnnotateFileRequest.
                         * @memberof google.cloud.vision.v1
                         * @interface IAnnotateFileRequest
                         * @property {google.cloud.vision.v1.IInputConfig|null} [inputConfig] AnnotateFileRequest inputConfig
                         * @property {Array.<google.cloud.vision.v1.IFeature>|null} [features] AnnotateFileRequest features
                         * @property {google.cloud.vision.v1.IImageContext|null} [imageContext] AnnotateFileRequest imageContext
                         * @property {Array.<number>|null} [pages] AnnotateFileRequest pages
                         */
    
                        /**
                         * Constructs a new AnnotateFileRequest.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an AnnotateFileRequest.
                         * @implements IAnnotateFileRequest
                         * @constructor
                         * @param {google.cloud.vision.v1.IAnnotateFileRequest=} [properties] Properties to set
                         */
                        function AnnotateFileRequest(properties) {
                            this.features = [];
                            this.pages = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AnnotateFileRequest inputConfig.
                         * @member {google.cloud.vision.v1.IInputConfig|null|undefined} inputConfig
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @instance
                         */
                        AnnotateFileRequest.prototype.inputConfig = null;
    
                        /**
                         * AnnotateFileRequest features.
                         * @member {Array.<google.cloud.vision.v1.IFeature>} features
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @instance
                         */
                        AnnotateFileRequest.prototype.features = $util.emptyArray;
    
                        /**
                         * AnnotateFileRequest imageContext.
                         * @member {google.cloud.vision.v1.IImageContext|null|undefined} imageContext
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @instance
                         */
                        AnnotateFileRequest.prototype.imageContext = null;
    
                        /**
                         * AnnotateFileRequest pages.
                         * @member {Array.<number>} pages
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @instance
                         */
                        AnnotateFileRequest.prototype.pages = $util.emptyArray;
    
                        /**
                         * Creates a new AnnotateFileRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateFileRequest=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.AnnotateFileRequest} AnnotateFileRequest instance
                         */
                        AnnotateFileRequest.create = function create(properties) {
                            return new AnnotateFileRequest(properties);
                        };
    
                        /**
                         * Encodes the specified AnnotateFileRequest message. Does not implicitly {@link google.cloud.vision.v1.AnnotateFileRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateFileRequest} message AnnotateFileRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnnotateFileRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.inputConfig != null && Object.hasOwnProperty.call(message, "inputConfig"))
                                $root.google.cloud.vision.v1.InputConfig.encode(message.inputConfig, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.features != null && message.features.length)
                                for (var i = 0; i < message.features.length; ++i)
                                    $root.google.cloud.vision.v1.Feature.encode(message.features[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.imageContext != null && Object.hasOwnProperty.call(message, "imageContext"))
                                $root.google.cloud.vision.v1.ImageContext.encode(message.imageContext, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.pages != null && message.pages.length) {
                                writer.uint32(/* id 4, wireType 2 =*/34).fork();
                                for (var i = 0; i < message.pages.length; ++i)
                                    writer.int32(message.pages[i]);
                                writer.ldelim();
                            }
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AnnotateFileRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AnnotateFileRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateFileRequest} message AnnotateFileRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnnotateFileRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AnnotateFileRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.AnnotateFileRequest} AnnotateFileRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnnotateFileRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.AnnotateFileRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.inputConfig = $root.google.cloud.vision.v1.InputConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        if (!(message.features && message.features.length))
                                            message.features = [];
                                        message.features.push($root.google.cloud.vision.v1.Feature.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        message.imageContext = $root.google.cloud.vision.v1.ImageContext.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        if (!(message.pages && message.pages.length))
                                            message.pages = [];
                                        if ((tag & 7) === 2) {
                                            var end2 = reader.uint32() + reader.pos;
                                            while (reader.pos < end2)
                                                message.pages.push(reader.int32());
                                        } else
                                            message.pages.push(reader.int32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AnnotateFileRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.AnnotateFileRequest} AnnotateFileRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnnotateFileRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AnnotateFileRequest message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AnnotateFileRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.inputConfig != null && message.hasOwnProperty("inputConfig")) {
                                var error = $root.google.cloud.vision.v1.InputConfig.verify(message.inputConfig);
                                if (error)
                                    return "inputConfig." + error;
                            }
                            if (message.features != null && message.hasOwnProperty("features")) {
                                if (!Array.isArray(message.features))
                                    return "features: array expected";
                                for (var i = 0; i < message.features.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.Feature.verify(message.features[i]);
                                    if (error)
                                        return "features." + error;
                                }
                            }
                            if (message.imageContext != null && message.hasOwnProperty("imageContext")) {
                                var error = $root.google.cloud.vision.v1.ImageContext.verify(message.imageContext);
                                if (error)
                                    return "imageContext." + error;
                            }
                            if (message.pages != null && message.hasOwnProperty("pages")) {
                                if (!Array.isArray(message.pages))
                                    return "pages: array expected";
                                for (var i = 0; i < message.pages.length; ++i)
                                    if (!$util.isInteger(message.pages[i]))
                                        return "pages: integer[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AnnotateFileRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.AnnotateFileRequest} AnnotateFileRequest
                         */
                        AnnotateFileRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.AnnotateFileRequest)
                                return object;
                            var message = new $root.google.cloud.vision.v1.AnnotateFileRequest();
                            if (object.inputConfig != null) {
                                if (typeof object.inputConfig !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateFileRequest.inputConfig: object expected");
                                message.inputConfig = $root.google.cloud.vision.v1.InputConfig.fromObject(object.inputConfig);
                            }
                            if (object.features) {
                                if (!Array.isArray(object.features))
                                    throw TypeError(".google.cloud.vision.v1.AnnotateFileRequest.features: array expected");
                                message.features = [];
                                for (var i = 0; i < object.features.length; ++i) {
                                    if (typeof object.features[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AnnotateFileRequest.features: object expected");
                                    message.features[i] = $root.google.cloud.vision.v1.Feature.fromObject(object.features[i]);
                                }
                            }
                            if (object.imageContext != null) {
                                if (typeof object.imageContext !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateFileRequest.imageContext: object expected");
                                message.imageContext = $root.google.cloud.vision.v1.ImageContext.fromObject(object.imageContext);
                            }
                            if (object.pages) {
                                if (!Array.isArray(object.pages))
                                    throw TypeError(".google.cloud.vision.v1.AnnotateFileRequest.pages: array expected");
                                message.pages = [];
                                for (var i = 0; i < object.pages.length; ++i)
                                    message.pages[i] = object.pages[i] | 0;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AnnotateFileRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @static
                         * @param {google.cloud.vision.v1.AnnotateFileRequest} message AnnotateFileRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AnnotateFileRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.features = [];
                                object.pages = [];
                            }
                            if (options.defaults) {
                                object.inputConfig = null;
                                object.imageContext = null;
                            }
                            if (message.inputConfig != null && message.hasOwnProperty("inputConfig"))
                                object.inputConfig = $root.google.cloud.vision.v1.InputConfig.toObject(message.inputConfig, options);
                            if (message.features && message.features.length) {
                                object.features = [];
                                for (var j = 0; j < message.features.length; ++j)
                                    object.features[j] = $root.google.cloud.vision.v1.Feature.toObject(message.features[j], options);
                            }
                            if (message.imageContext != null && message.hasOwnProperty("imageContext"))
                                object.imageContext = $root.google.cloud.vision.v1.ImageContext.toObject(message.imageContext, options);
                            if (message.pages && message.pages.length) {
                                object.pages = [];
                                for (var j = 0; j < message.pages.length; ++j)
                                    object.pages[j] = message.pages[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AnnotateFileRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AnnotateFileRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AnnotateFileRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.AnnotateFileRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AnnotateFileRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.AnnotateFileRequest";
                        };
    
                        return AnnotateFileRequest;
                    })();
    
                    v1.AnnotateFileResponse = (function() {
    
                        /**
                         * Properties of an AnnotateFileResponse.
                         * @memberof google.cloud.vision.v1
                         * @interface IAnnotateFileResponse
                         * @property {google.cloud.vision.v1.IInputConfig|null} [inputConfig] AnnotateFileResponse inputConfig
                         * @property {Array.<google.cloud.vision.v1.IAnnotateImageResponse>|null} [responses] AnnotateFileResponse responses
                         * @property {number|null} [totalPages] AnnotateFileResponse totalPages
                         * @property {google.rpc.IStatus|null} [error] AnnotateFileResponse error
                         */
    
                        /**
                         * Constructs a new AnnotateFileResponse.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an AnnotateFileResponse.
                         * @implements IAnnotateFileResponse
                         * @constructor
                         * @param {google.cloud.vision.v1.IAnnotateFileResponse=} [properties] Properties to set
                         */
                        function AnnotateFileResponse(properties) {
                            this.responses = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AnnotateFileResponse inputConfig.
                         * @member {google.cloud.vision.v1.IInputConfig|null|undefined} inputConfig
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @instance
                         */
                        AnnotateFileResponse.prototype.inputConfig = null;
    
                        /**
                         * AnnotateFileResponse responses.
                         * @member {Array.<google.cloud.vision.v1.IAnnotateImageResponse>} responses
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @instance
                         */
                        AnnotateFileResponse.prototype.responses = $util.emptyArray;
    
                        /**
                         * AnnotateFileResponse totalPages.
                         * @member {number} totalPages
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @instance
                         */
                        AnnotateFileResponse.prototype.totalPages = 0;
    
                        /**
                         * AnnotateFileResponse error.
                         * @member {google.rpc.IStatus|null|undefined} error
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @instance
                         */
                        AnnotateFileResponse.prototype.error = null;
    
                        /**
                         * Creates a new AnnotateFileResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateFileResponse=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.AnnotateFileResponse} AnnotateFileResponse instance
                         */
                        AnnotateFileResponse.create = function create(properties) {
                            return new AnnotateFileResponse(properties);
                        };
    
                        /**
                         * Encodes the specified AnnotateFileResponse message. Does not implicitly {@link google.cloud.vision.v1.AnnotateFileResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateFileResponse} message AnnotateFileResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnnotateFileResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.inputConfig != null && Object.hasOwnProperty.call(message, "inputConfig"))
                                $root.google.cloud.vision.v1.InputConfig.encode(message.inputConfig, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.responses != null && message.responses.length)
                                for (var i = 0; i < message.responses.length; ++i)
                                    $root.google.cloud.vision.v1.AnnotateImageResponse.encode(message.responses[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.totalPages != null && Object.hasOwnProperty.call(message, "totalPages"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.totalPages);
                            if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                                $root.google.rpc.Status.encode(message.error, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AnnotateFileResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AnnotateFileResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAnnotateFileResponse} message AnnotateFileResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnnotateFileResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AnnotateFileResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.AnnotateFileResponse} AnnotateFileResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnnotateFileResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.AnnotateFileResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.inputConfig = $root.google.cloud.vision.v1.InputConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        if (!(message.responses && message.responses.length))
                                            message.responses = [];
                                        message.responses.push($root.google.cloud.vision.v1.AnnotateImageResponse.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        message.totalPages = reader.int32();
                                        break;
                                    }
                                case 4: {
                                        message.error = $root.google.rpc.Status.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AnnotateFileResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.AnnotateFileResponse} AnnotateFileResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnnotateFileResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AnnotateFileResponse message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AnnotateFileResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.inputConfig != null && message.hasOwnProperty("inputConfig")) {
                                var error = $root.google.cloud.vision.v1.InputConfig.verify(message.inputConfig);
                                if (error)
                                    return "inputConfig." + error;
                            }
                            if (message.responses != null && message.hasOwnProperty("responses")) {
                                if (!Array.isArray(message.responses))
                                    return "responses: array expected";
                                for (var i = 0; i < message.responses.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.AnnotateImageResponse.verify(message.responses[i]);
                                    if (error)
                                        return "responses." + error;
                                }
                            }
                            if (message.totalPages != null && message.hasOwnProperty("totalPages"))
                                if (!$util.isInteger(message.totalPages))
                                    return "totalPages: integer expected";
                            if (message.error != null && message.hasOwnProperty("error")) {
                                var error = $root.google.rpc.Status.verify(message.error);
                                if (error)
                                    return "error." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AnnotateFileResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.AnnotateFileResponse} AnnotateFileResponse
                         */
                        AnnotateFileResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.AnnotateFileResponse)
                                return object;
                            var message = new $root.google.cloud.vision.v1.AnnotateFileResponse();
                            if (object.inputConfig != null) {
                                if (typeof object.inputConfig !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateFileResponse.inputConfig: object expected");
                                message.inputConfig = $root.google.cloud.vision.v1.InputConfig.fromObject(object.inputConfig);
                            }
                            if (object.responses) {
                                if (!Array.isArray(object.responses))
                                    throw TypeError(".google.cloud.vision.v1.AnnotateFileResponse.responses: array expected");
                                message.responses = [];
                                for (var i = 0; i < object.responses.length; ++i) {
                                    if (typeof object.responses[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AnnotateFileResponse.responses: object expected");
                                    message.responses[i] = $root.google.cloud.vision.v1.AnnotateImageResponse.fromObject(object.responses[i]);
                                }
                            }
                            if (object.totalPages != null)
                                message.totalPages = object.totalPages | 0;
                            if (object.error != null) {
                                if (typeof object.error !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AnnotateFileResponse.error: object expected");
                                message.error = $root.google.rpc.Status.fromObject(object.error);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AnnotateFileResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @static
                         * @param {google.cloud.vision.v1.AnnotateFileResponse} message AnnotateFileResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AnnotateFileResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.responses = [];
                            if (options.defaults) {
                                object.inputConfig = null;
                                object.totalPages = 0;
                                object.error = null;
                            }
                            if (message.inputConfig != null && message.hasOwnProperty("inputConfig"))
                                object.inputConfig = $root.google.cloud.vision.v1.InputConfig.toObject(message.inputConfig, options);
                            if (message.responses && message.responses.length) {
                                object.responses = [];
                                for (var j = 0; j < message.responses.length; ++j)
                                    object.responses[j] = $root.google.cloud.vision.v1.AnnotateImageResponse.toObject(message.responses[j], options);
                            }
                            if (message.totalPages != null && message.hasOwnProperty("totalPages"))
                                object.totalPages = message.totalPages;
                            if (message.error != null && message.hasOwnProperty("error"))
                                object.error = $root.google.rpc.Status.toObject(message.error, options);
                            return object;
                        };
    
                        /**
                         * Converts this AnnotateFileResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AnnotateFileResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AnnotateFileResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.AnnotateFileResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AnnotateFileResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.AnnotateFileResponse";
                        };
    
                        return AnnotateFileResponse;
                    })();
    
                    v1.BatchAnnotateFilesRequest = (function() {
    
                        /**
                         * Properties of a BatchAnnotateFilesRequest.
                         * @memberof google.cloud.vision.v1
                         * @interface IBatchAnnotateFilesRequest
                         * @property {Array.<google.cloud.vision.v1.IAnnotateFileRequest>|null} [requests] BatchAnnotateFilesRequest requests
                         * @property {string|null} [parent] BatchAnnotateFilesRequest parent
                         * @property {Object.<string,string>|null} [labels] BatchAnnotateFilesRequest labels
                         */
    
                        /**
                         * Constructs a new BatchAnnotateFilesRequest.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a BatchAnnotateFilesRequest.
                         * @implements IBatchAnnotateFilesRequest
                         * @constructor
                         * @param {google.cloud.vision.v1.IBatchAnnotateFilesRequest=} [properties] Properties to set
                         */
                        function BatchAnnotateFilesRequest(properties) {
                            this.requests = [];
                            this.labels = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * BatchAnnotateFilesRequest requests.
                         * @member {Array.<google.cloud.vision.v1.IAnnotateFileRequest>} requests
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @instance
                         */
                        BatchAnnotateFilesRequest.prototype.requests = $util.emptyArray;
    
                        /**
                         * BatchAnnotateFilesRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @instance
                         */
                        BatchAnnotateFilesRequest.prototype.parent = "";
    
                        /**
                         * BatchAnnotateFilesRequest labels.
                         * @member {Object.<string,string>} labels
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @instance
                         */
                        BatchAnnotateFilesRequest.prototype.labels = $util.emptyObject;
    
                        /**
                         * Creates a new BatchAnnotateFilesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateFilesRequest=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.BatchAnnotateFilesRequest} BatchAnnotateFilesRequest instance
                         */
                        BatchAnnotateFilesRequest.create = function create(properties) {
                            return new BatchAnnotateFilesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified BatchAnnotateFilesRequest message. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateFilesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateFilesRequest} message BatchAnnotateFilesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchAnnotateFilesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.requests != null && message.requests.length)
                                for (var i = 0; i < message.requests.length; ++i)
                                    $root.google.cloud.vision.v1.AnnotateFileRequest.encode(message.requests[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.parent);
                            if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                                for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 5, wireType 2 =*/42).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified BatchAnnotateFilesRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateFilesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateFilesRequest} message BatchAnnotateFilesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchAnnotateFilesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a BatchAnnotateFilesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.BatchAnnotateFilesRequest} BatchAnnotateFilesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchAnnotateFilesRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.BatchAnnotateFilesRequest(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.requests && message.requests.length))
                                            message.requests = [];
                                        message.requests.push($root.google.cloud.vision.v1.AnnotateFileRequest.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 5: {
                                        if (message.labels === $util.emptyObject)
                                            message.labels = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = "";
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.string();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.labels[key] = value;
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a BatchAnnotateFilesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.BatchAnnotateFilesRequest} BatchAnnotateFilesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchAnnotateFilesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a BatchAnnotateFilesRequest message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        BatchAnnotateFilesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.requests != null && message.hasOwnProperty("requests")) {
                                if (!Array.isArray(message.requests))
                                    return "requests: array expected";
                                for (var i = 0; i < message.requests.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.AnnotateFileRequest.verify(message.requests[i]);
                                    if (error)
                                        return "requests." + error;
                                }
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.labels != null && message.hasOwnProperty("labels")) {
                                if (!$util.isObject(message.labels))
                                    return "labels: object expected";
                                var key = Object.keys(message.labels);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.labels[key[i]]))
                                        return "labels: string{k:string} expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a BatchAnnotateFilesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.BatchAnnotateFilesRequest} BatchAnnotateFilesRequest
                         */
                        BatchAnnotateFilesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.BatchAnnotateFilesRequest)
                                return object;
                            var message = new $root.google.cloud.vision.v1.BatchAnnotateFilesRequest();
                            if (object.requests) {
                                if (!Array.isArray(object.requests))
                                    throw TypeError(".google.cloud.vision.v1.BatchAnnotateFilesRequest.requests: array expected");
                                message.requests = [];
                                for (var i = 0; i < object.requests.length; ++i) {
                                    if (typeof object.requests[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.BatchAnnotateFilesRequest.requests: object expected");
                                    message.requests[i] = $root.google.cloud.vision.v1.AnnotateFileRequest.fromObject(object.requests[i]);
                                }
                            }
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.labels) {
                                if (typeof object.labels !== "object")
                                    throw TypeError(".google.cloud.vision.v1.BatchAnnotateFilesRequest.labels: object expected");
                                message.labels = {};
                                for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                    message.labels[keys[i]] = String(object.labels[keys[i]]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a BatchAnnotateFilesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @static
                         * @param {google.cloud.vision.v1.BatchAnnotateFilesRequest} message BatchAnnotateFilesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        BatchAnnotateFilesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.requests = [];
                            if (options.objects || options.defaults)
                                object.labels = {};
                            if (options.defaults)
                                object.parent = "";
                            if (message.requests && message.requests.length) {
                                object.requests = [];
                                for (var j = 0; j < message.requests.length; ++j)
                                    object.requests[j] = $root.google.cloud.vision.v1.AnnotateFileRequest.toObject(message.requests[j], options);
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            var keys2;
                            if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                                object.labels = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.labels[keys2[j]] = message.labels[keys2[j]];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this BatchAnnotateFilesRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        BatchAnnotateFilesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for BatchAnnotateFilesRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        BatchAnnotateFilesRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.BatchAnnotateFilesRequest";
                        };
    
                        return BatchAnnotateFilesRequest;
                    })();
    
                    v1.BatchAnnotateFilesResponse = (function() {
    
                        /**
                         * Properties of a BatchAnnotateFilesResponse.
                         * @memberof google.cloud.vision.v1
                         * @interface IBatchAnnotateFilesResponse
                         * @property {Array.<google.cloud.vision.v1.IAnnotateFileResponse>|null} [responses] BatchAnnotateFilesResponse responses
                         */
    
                        /**
                         * Constructs a new BatchAnnotateFilesResponse.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a BatchAnnotateFilesResponse.
                         * @implements IBatchAnnotateFilesResponse
                         * @constructor
                         * @param {google.cloud.vision.v1.IBatchAnnotateFilesResponse=} [properties] Properties to set
                         */
                        function BatchAnnotateFilesResponse(properties) {
                            this.responses = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * BatchAnnotateFilesResponse responses.
                         * @member {Array.<google.cloud.vision.v1.IAnnotateFileResponse>} responses
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @instance
                         */
                        BatchAnnotateFilesResponse.prototype.responses = $util.emptyArray;
    
                        /**
                         * Creates a new BatchAnnotateFilesResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateFilesResponse=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.BatchAnnotateFilesResponse} BatchAnnotateFilesResponse instance
                         */
                        BatchAnnotateFilesResponse.create = function create(properties) {
                            return new BatchAnnotateFilesResponse(properties);
                        };
    
                        /**
                         * Encodes the specified BatchAnnotateFilesResponse message. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateFilesResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateFilesResponse} message BatchAnnotateFilesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchAnnotateFilesResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.responses != null && message.responses.length)
                                for (var i = 0; i < message.responses.length; ++i)
                                    $root.google.cloud.vision.v1.AnnotateFileResponse.encode(message.responses[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified BatchAnnotateFilesResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.BatchAnnotateFilesResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IBatchAnnotateFilesResponse} message BatchAnnotateFilesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BatchAnnotateFilesResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a BatchAnnotateFilesResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.BatchAnnotateFilesResponse} BatchAnnotateFilesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchAnnotateFilesResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.BatchAnnotateFilesResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.responses && message.responses.length))
                                            message.responses = [];
                                        message.responses.push($root.google.cloud.vision.v1.AnnotateFileResponse.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a BatchAnnotateFilesResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.BatchAnnotateFilesResponse} BatchAnnotateFilesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BatchAnnotateFilesResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a BatchAnnotateFilesResponse message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        BatchAnnotateFilesResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.responses != null && message.hasOwnProperty("responses")) {
                                if (!Array.isArray(message.responses))
                                    return "responses: array expected";
                                for (var i = 0; i < message.responses.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.AnnotateFileResponse.verify(message.responses[i]);
                                    if (error)
                                        return "responses." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a BatchAnnotateFilesResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.BatchAnnotateFilesResponse} BatchAnnotateFilesResponse
                         */
                        BatchAnnotateFilesResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.BatchAnnotateFilesResponse)
                                return object;
                            var message = new $root.google.cloud.vision.v1.BatchAnnotateFilesResponse();
                            if (object.responses) {
                                if (!Array.isArray(object.responses))
                                    throw TypeError(".google.cloud.vision.v1.BatchAnnotateFilesResponse.responses: array expected");
                                message.responses = [];
                                for (var i = 0; i < object.responses.length; ++i) {
                                    if (typeof object.responses[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.BatchAnnotateFilesResponse.responses: object expected");
                                    message.responses[i] = $root.google.cloud.vision.v1.AnnotateFileResponse.fromObject(object.responses[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a BatchAnnotateFilesResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @static
                         * @param {google.cloud.vision.v1.BatchAnnotateFilesResponse} message BatchAnnotateFilesResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        BatchAnnotateFilesResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.responses = [];
                            if (message.responses && message.responses.length) {
                                object.responses = [];
                                for (var j = 0; j < message.responses.length; ++j)
                                    object.responses[j] = $root.google.cloud.vision.v1.AnnotateFileResponse.toObject(message.responses[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this BatchAnnotateFilesResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        BatchAnnotateFilesResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for BatchAnnotateFilesResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.BatchAnnotateFilesResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        BatchAnnotateFilesResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.BatchAnnotateFilesResponse";
                        };
    
                        return BatchAnnotateFilesResponse;
                    })();
    
                    v1.AsyncAnnotateFileRequest = (function() {
    
                        /**
                         * Properties of an AsyncAnnotateFileRequest.
                         * @memberof google.cloud.vision.v1
                         * @interface IAsyncAnnotateFileRequest
                         * @property {google.cloud.vision.v1.IInputConfig|null} [inputConfig] AsyncAnnotateFileRequest inputConfig
                         * @property {Array.<google.cloud.vision.v1.IFeature>|null} [features] AsyncAnnotateFileRequest features
                         * @property {google.cloud.vision.v1.IImageContext|null} [imageContext] AsyncAnnotateFileRequest imageContext
                         * @property {google.cloud.vision.v1.IOutputConfig|null} [outputConfig] AsyncAnnotateFileRequest outputConfig
                         */
    
                        /**
                         * Constructs a new AsyncAnnotateFileRequest.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an AsyncAnnotateFileRequest.
                         * @implements IAsyncAnnotateFileRequest
                         * @constructor
                         * @param {google.cloud.vision.v1.IAsyncAnnotateFileRequest=} [properties] Properties to set
                         */
                        function AsyncAnnotateFileRequest(properties) {
                            this.features = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AsyncAnnotateFileRequest inputConfig.
                         * @member {google.cloud.vision.v1.IInputConfig|null|undefined} inputConfig
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @instance
                         */
                        AsyncAnnotateFileRequest.prototype.inputConfig = null;
    
                        /**
                         * AsyncAnnotateFileRequest features.
                         * @member {Array.<google.cloud.vision.v1.IFeature>} features
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @instance
                         */
                        AsyncAnnotateFileRequest.prototype.features = $util.emptyArray;
    
                        /**
                         * AsyncAnnotateFileRequest imageContext.
                         * @member {google.cloud.vision.v1.IImageContext|null|undefined} imageContext
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @instance
                         */
                        AsyncAnnotateFileRequest.prototype.imageContext = null;
    
                        /**
                         * AsyncAnnotateFileRequest outputConfig.
                         * @member {google.cloud.vision.v1.IOutputConfig|null|undefined} outputConfig
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @instance
                         */
                        AsyncAnnotateFileRequest.prototype.outputConfig = null;
    
                        /**
                         * Creates a new AsyncAnnotateFileRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncAnnotateFileRequest=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.AsyncAnnotateFileRequest} AsyncAnnotateFileRequest instance
                         */
                        AsyncAnnotateFileRequest.create = function create(properties) {
                            return new AsyncAnnotateFileRequest(properties);
                        };
    
                        /**
                         * Encodes the specified AsyncAnnotateFileRequest message. Does not implicitly {@link google.cloud.vision.v1.AsyncAnnotateFileRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncAnnotateFileRequest} message AsyncAnnotateFileRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncAnnotateFileRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.inputConfig != null && Object.hasOwnProperty.call(message, "inputConfig"))
                                $root.google.cloud.vision.v1.InputConfig.encode(message.inputConfig, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.features != null && message.features.length)
                                for (var i = 0; i < message.features.length; ++i)
                                    $root.google.cloud.vision.v1.Feature.encode(message.features[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.imageContext != null && Object.hasOwnProperty.call(message, "imageContext"))
                                $root.google.cloud.vision.v1.ImageContext.encode(message.imageContext, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.outputConfig != null && Object.hasOwnProperty.call(message, "outputConfig"))
                                $root.google.cloud.vision.v1.OutputConfig.encode(message.outputConfig, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AsyncAnnotateFileRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncAnnotateFileRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncAnnotateFileRequest} message AsyncAnnotateFileRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncAnnotateFileRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AsyncAnnotateFileRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.AsyncAnnotateFileRequest} AsyncAnnotateFileRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncAnnotateFileRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.AsyncAnnotateFileRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.inputConfig = $root.google.cloud.vision.v1.InputConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        if (!(message.features && message.features.length))
                                            message.features = [];
                                        message.features.push($root.google.cloud.vision.v1.Feature.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        message.imageContext = $root.google.cloud.vision.v1.ImageContext.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        message.outputConfig = $root.google.cloud.vision.v1.OutputConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AsyncAnnotateFileRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.AsyncAnnotateFileRequest} AsyncAnnotateFileRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncAnnotateFileRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AsyncAnnotateFileRequest message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AsyncAnnotateFileRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.inputConfig != null && message.hasOwnProperty("inputConfig")) {
                                var error = $root.google.cloud.vision.v1.InputConfig.verify(message.inputConfig);
                                if (error)
                                    return "inputConfig." + error;
                            }
                            if (message.features != null && message.hasOwnProperty("features")) {
                                if (!Array.isArray(message.features))
                                    return "features: array expected";
                                for (var i = 0; i < message.features.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.Feature.verify(message.features[i]);
                                    if (error)
                                        return "features." + error;
                                }
                            }
                            if (message.imageContext != null && message.hasOwnProperty("imageContext")) {
                                var error = $root.google.cloud.vision.v1.ImageContext.verify(message.imageContext);
                                if (error)
                                    return "imageContext." + error;
                            }
                            if (message.outputConfig != null && message.hasOwnProperty("outputConfig")) {
                                var error = $root.google.cloud.vision.v1.OutputConfig.verify(message.outputConfig);
                                if (error)
                                    return "outputConfig." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AsyncAnnotateFileRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.AsyncAnnotateFileRequest} AsyncAnnotateFileRequest
                         */
                        AsyncAnnotateFileRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.AsyncAnnotateFileRequest)
                                return object;
                            var message = new $root.google.cloud.vision.v1.AsyncAnnotateFileRequest();
                            if (object.inputConfig != null) {
                                if (typeof object.inputConfig !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AsyncAnnotateFileRequest.inputConfig: object expected");
                                message.inputConfig = $root.google.cloud.vision.v1.InputConfig.fromObject(object.inputConfig);
                            }
                            if (object.features) {
                                if (!Array.isArray(object.features))
                                    throw TypeError(".google.cloud.vision.v1.AsyncAnnotateFileRequest.features: array expected");
                                message.features = [];
                                for (var i = 0; i < object.features.length; ++i) {
                                    if (typeof object.features[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AsyncAnnotateFileRequest.features: object expected");
                                    message.features[i] = $root.google.cloud.vision.v1.Feature.fromObject(object.features[i]);
                                }
                            }
                            if (object.imageContext != null) {
                                if (typeof object.imageContext !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AsyncAnnotateFileRequest.imageContext: object expected");
                                message.imageContext = $root.google.cloud.vision.v1.ImageContext.fromObject(object.imageContext);
                            }
                            if (object.outputConfig != null) {
                                if (typeof object.outputConfig !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AsyncAnnotateFileRequest.outputConfig: object expected");
                                message.outputConfig = $root.google.cloud.vision.v1.OutputConfig.fromObject(object.outputConfig);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AsyncAnnotateFileRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @static
                         * @param {google.cloud.vision.v1.AsyncAnnotateFileRequest} message AsyncAnnotateFileRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AsyncAnnotateFileRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.features = [];
                            if (options.defaults) {
                                object.inputConfig = null;
                                object.imageContext = null;
                                object.outputConfig = null;
                            }
                            if (message.inputConfig != null && message.hasOwnProperty("inputConfig"))
                                object.inputConfig = $root.google.cloud.vision.v1.InputConfig.toObject(message.inputConfig, options);
                            if (message.features && message.features.length) {
                                object.features = [];
                                for (var j = 0; j < message.features.length; ++j)
                                    object.features[j] = $root.google.cloud.vision.v1.Feature.toObject(message.features[j], options);
                            }
                            if (message.imageContext != null && message.hasOwnProperty("imageContext"))
                                object.imageContext = $root.google.cloud.vision.v1.ImageContext.toObject(message.imageContext, options);
                            if (message.outputConfig != null && message.hasOwnProperty("outputConfig"))
                                object.outputConfig = $root.google.cloud.vision.v1.OutputConfig.toObject(message.outputConfig, options);
                            return object;
                        };
    
                        /**
                         * Converts this AsyncAnnotateFileRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AsyncAnnotateFileRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AsyncAnnotateFileRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AsyncAnnotateFileRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.AsyncAnnotateFileRequest";
                        };
    
                        return AsyncAnnotateFileRequest;
                    })();
    
                    v1.AsyncAnnotateFileResponse = (function() {
    
                        /**
                         * Properties of an AsyncAnnotateFileResponse.
                         * @memberof google.cloud.vision.v1
                         * @interface IAsyncAnnotateFileResponse
                         * @property {google.cloud.vision.v1.IOutputConfig|null} [outputConfig] AsyncAnnotateFileResponse outputConfig
                         */
    
                        /**
                         * Constructs a new AsyncAnnotateFileResponse.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an AsyncAnnotateFileResponse.
                         * @implements IAsyncAnnotateFileResponse
                         * @constructor
                         * @param {google.cloud.vision.v1.IAsyncAnnotateFileResponse=} [properties] Properties to set
                         */
                        function AsyncAnnotateFileResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AsyncAnnotateFileResponse outputConfig.
                         * @member {google.cloud.vision.v1.IOutputConfig|null|undefined} outputConfig
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @instance
                         */
                        AsyncAnnotateFileResponse.prototype.outputConfig = null;
    
                        /**
                         * Creates a new AsyncAnnotateFileResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncAnnotateFileResponse=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.AsyncAnnotateFileResponse} AsyncAnnotateFileResponse instance
                         */
                        AsyncAnnotateFileResponse.create = function create(properties) {
                            return new AsyncAnnotateFileResponse(properties);
                        };
    
                        /**
                         * Encodes the specified AsyncAnnotateFileResponse message. Does not implicitly {@link google.cloud.vision.v1.AsyncAnnotateFileResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncAnnotateFileResponse} message AsyncAnnotateFileResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncAnnotateFileResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.outputConfig != null && Object.hasOwnProperty.call(message, "outputConfig"))
                                $root.google.cloud.vision.v1.OutputConfig.encode(message.outputConfig, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AsyncAnnotateFileResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncAnnotateFileResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncAnnotateFileResponse} message AsyncAnnotateFileResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncAnnotateFileResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AsyncAnnotateFileResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.AsyncAnnotateFileResponse} AsyncAnnotateFileResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncAnnotateFileResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.AsyncAnnotateFileResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.outputConfig = $root.google.cloud.vision.v1.OutputConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AsyncAnnotateFileResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.AsyncAnnotateFileResponse} AsyncAnnotateFileResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncAnnotateFileResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AsyncAnnotateFileResponse message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AsyncAnnotateFileResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.outputConfig != null && message.hasOwnProperty("outputConfig")) {
                                var error = $root.google.cloud.vision.v1.OutputConfig.verify(message.outputConfig);
                                if (error)
                                    return "outputConfig." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AsyncAnnotateFileResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.AsyncAnnotateFileResponse} AsyncAnnotateFileResponse
                         */
                        AsyncAnnotateFileResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.AsyncAnnotateFileResponse)
                                return object;
                            var message = new $root.google.cloud.vision.v1.AsyncAnnotateFileResponse();
                            if (object.outputConfig != null) {
                                if (typeof object.outputConfig !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AsyncAnnotateFileResponse.outputConfig: object expected");
                                message.outputConfig = $root.google.cloud.vision.v1.OutputConfig.fromObject(object.outputConfig);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AsyncAnnotateFileResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @static
                         * @param {google.cloud.vision.v1.AsyncAnnotateFileResponse} message AsyncAnnotateFileResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AsyncAnnotateFileResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.outputConfig = null;
                            if (message.outputConfig != null && message.hasOwnProperty("outputConfig"))
                                object.outputConfig = $root.google.cloud.vision.v1.OutputConfig.toObject(message.outputConfig, options);
                            return object;
                        };
    
                        /**
                         * Converts this AsyncAnnotateFileResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AsyncAnnotateFileResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AsyncAnnotateFileResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.AsyncAnnotateFileResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AsyncAnnotateFileResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.AsyncAnnotateFileResponse";
                        };
    
                        return AsyncAnnotateFileResponse;
                    })();
    
                    v1.AsyncBatchAnnotateImagesRequest = (function() {
    
                        /**
                         * Properties of an AsyncBatchAnnotateImagesRequest.
                         * @memberof google.cloud.vision.v1
                         * @interface IAsyncBatchAnnotateImagesRequest
                         * @property {Array.<google.cloud.vision.v1.IAnnotateImageRequest>|null} [requests] AsyncBatchAnnotateImagesRequest requests
                         * @property {google.cloud.vision.v1.IOutputConfig|null} [outputConfig] AsyncBatchAnnotateImagesRequest outputConfig
                         * @property {string|null} [parent] AsyncBatchAnnotateImagesRequest parent
                         * @property {Object.<string,string>|null} [labels] AsyncBatchAnnotateImagesRequest labels
                         */
    
                        /**
                         * Constructs a new AsyncBatchAnnotateImagesRequest.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an AsyncBatchAnnotateImagesRequest.
                         * @implements IAsyncBatchAnnotateImagesRequest
                         * @constructor
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest=} [properties] Properties to set
                         */
                        function AsyncBatchAnnotateImagesRequest(properties) {
                            this.requests = [];
                            this.labels = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AsyncBatchAnnotateImagesRequest requests.
                         * @member {Array.<google.cloud.vision.v1.IAnnotateImageRequest>} requests
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @instance
                         */
                        AsyncBatchAnnotateImagesRequest.prototype.requests = $util.emptyArray;
    
                        /**
                         * AsyncBatchAnnotateImagesRequest outputConfig.
                         * @member {google.cloud.vision.v1.IOutputConfig|null|undefined} outputConfig
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @instance
                         */
                        AsyncBatchAnnotateImagesRequest.prototype.outputConfig = null;
    
                        /**
                         * AsyncBatchAnnotateImagesRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @instance
                         */
                        AsyncBatchAnnotateImagesRequest.prototype.parent = "";
    
                        /**
                         * AsyncBatchAnnotateImagesRequest labels.
                         * @member {Object.<string,string>} labels
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @instance
                         */
                        AsyncBatchAnnotateImagesRequest.prototype.labels = $util.emptyObject;
    
                        /**
                         * Creates a new AsyncBatchAnnotateImagesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest} AsyncBatchAnnotateImagesRequest instance
                         */
                        AsyncBatchAnnotateImagesRequest.create = function create(properties) {
                            return new AsyncBatchAnnotateImagesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified AsyncBatchAnnotateImagesRequest message. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest} message AsyncBatchAnnotateImagesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncBatchAnnotateImagesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.requests != null && message.requests.length)
                                for (var i = 0; i < message.requests.length; ++i)
                                    $root.google.cloud.vision.v1.AnnotateImageRequest.encode(message.requests[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.outputConfig != null && Object.hasOwnProperty.call(message, "outputConfig"))
                                $root.google.cloud.vision.v1.OutputConfig.encode(message.outputConfig, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.parent);
                            if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                                for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 5, wireType 2 =*/42).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AsyncBatchAnnotateImagesRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateImagesRequest} message AsyncBatchAnnotateImagesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncBatchAnnotateImagesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AsyncBatchAnnotateImagesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest} AsyncBatchAnnotateImagesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncBatchAnnotateImagesRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.requests && message.requests.length))
                                            message.requests = [];
                                        message.requests.push($root.google.cloud.vision.v1.AnnotateImageRequest.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.outputConfig = $root.google.cloud.vision.v1.OutputConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 5: {
                                        if (message.labels === $util.emptyObject)
                                            message.labels = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = "";
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.string();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.labels[key] = value;
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AsyncBatchAnnotateImagesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest} AsyncBatchAnnotateImagesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncBatchAnnotateImagesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AsyncBatchAnnotateImagesRequest message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AsyncBatchAnnotateImagesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.requests != null && message.hasOwnProperty("requests")) {
                                if (!Array.isArray(message.requests))
                                    return "requests: array expected";
                                for (var i = 0; i < message.requests.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.AnnotateImageRequest.verify(message.requests[i]);
                                    if (error)
                                        return "requests." + error;
                                }
                            }
                            if (message.outputConfig != null && message.hasOwnProperty("outputConfig")) {
                                var error = $root.google.cloud.vision.v1.OutputConfig.verify(message.outputConfig);
                                if (error)
                                    return "outputConfig." + error;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.labels != null && message.hasOwnProperty("labels")) {
                                if (!$util.isObject(message.labels))
                                    return "labels: object expected";
                                var key = Object.keys(message.labels);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.labels[key[i]]))
                                        return "labels: string{k:string} expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AsyncBatchAnnotateImagesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest} AsyncBatchAnnotateImagesRequest
                         */
                        AsyncBatchAnnotateImagesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest)
                                return object;
                            var message = new $root.google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest();
                            if (object.requests) {
                                if (!Array.isArray(object.requests))
                                    throw TypeError(".google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.requests: array expected");
                                message.requests = [];
                                for (var i = 0; i < object.requests.length; ++i) {
                                    if (typeof object.requests[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.requests: object expected");
                                    message.requests[i] = $root.google.cloud.vision.v1.AnnotateImageRequest.fromObject(object.requests[i]);
                                }
                            }
                            if (object.outputConfig != null) {
                                if (typeof object.outputConfig !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.outputConfig: object expected");
                                message.outputConfig = $root.google.cloud.vision.v1.OutputConfig.fromObject(object.outputConfig);
                            }
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.labels) {
                                if (typeof object.labels !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.labels: object expected");
                                message.labels = {};
                                for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                    message.labels[keys[i]] = String(object.labels[keys[i]]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AsyncBatchAnnotateImagesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @static
                         * @param {google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest} message AsyncBatchAnnotateImagesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AsyncBatchAnnotateImagesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.requests = [];
                            if (options.objects || options.defaults)
                                object.labels = {};
                            if (options.defaults) {
                                object.outputConfig = null;
                                object.parent = "";
                            }
                            if (message.requests && message.requests.length) {
                                object.requests = [];
                                for (var j = 0; j < message.requests.length; ++j)
                                    object.requests[j] = $root.google.cloud.vision.v1.AnnotateImageRequest.toObject(message.requests[j], options);
                            }
                            if (message.outputConfig != null && message.hasOwnProperty("outputConfig"))
                                object.outputConfig = $root.google.cloud.vision.v1.OutputConfig.toObject(message.outputConfig, options);
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            var keys2;
                            if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                                object.labels = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.labels[keys2[j]] = message.labels[keys2[j]];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AsyncBatchAnnotateImagesRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AsyncBatchAnnotateImagesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AsyncBatchAnnotateImagesRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AsyncBatchAnnotateImagesRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest";
                        };
    
                        return AsyncBatchAnnotateImagesRequest;
                    })();
    
                    v1.AsyncBatchAnnotateImagesResponse = (function() {
    
                        /**
                         * Properties of an AsyncBatchAnnotateImagesResponse.
                         * @memberof google.cloud.vision.v1
                         * @interface IAsyncBatchAnnotateImagesResponse
                         * @property {google.cloud.vision.v1.IOutputConfig|null} [outputConfig] AsyncBatchAnnotateImagesResponse outputConfig
                         */
    
                        /**
                         * Constructs a new AsyncBatchAnnotateImagesResponse.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an AsyncBatchAnnotateImagesResponse.
                         * @implements IAsyncBatchAnnotateImagesResponse
                         * @constructor
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateImagesResponse=} [properties] Properties to set
                         */
                        function AsyncBatchAnnotateImagesResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AsyncBatchAnnotateImagesResponse outputConfig.
                         * @member {google.cloud.vision.v1.IOutputConfig|null|undefined} outputConfig
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @instance
                         */
                        AsyncBatchAnnotateImagesResponse.prototype.outputConfig = null;
    
                        /**
                         * Creates a new AsyncBatchAnnotateImagesResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateImagesResponse=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse} AsyncBatchAnnotateImagesResponse instance
                         */
                        AsyncBatchAnnotateImagesResponse.create = function create(properties) {
                            return new AsyncBatchAnnotateImagesResponse(properties);
                        };
    
                        /**
                         * Encodes the specified AsyncBatchAnnotateImagesResponse message. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateImagesResponse} message AsyncBatchAnnotateImagesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncBatchAnnotateImagesResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.outputConfig != null && Object.hasOwnProperty.call(message, "outputConfig"))
                                $root.google.cloud.vision.v1.OutputConfig.encode(message.outputConfig, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AsyncBatchAnnotateImagesResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateImagesResponse} message AsyncBatchAnnotateImagesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncBatchAnnotateImagesResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AsyncBatchAnnotateImagesResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse} AsyncBatchAnnotateImagesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncBatchAnnotateImagesResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.outputConfig = $root.google.cloud.vision.v1.OutputConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AsyncBatchAnnotateImagesResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse} AsyncBatchAnnotateImagesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncBatchAnnotateImagesResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AsyncBatchAnnotateImagesResponse message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AsyncBatchAnnotateImagesResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.outputConfig != null && message.hasOwnProperty("outputConfig")) {
                                var error = $root.google.cloud.vision.v1.OutputConfig.verify(message.outputConfig);
                                if (error)
                                    return "outputConfig." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AsyncBatchAnnotateImagesResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse} AsyncBatchAnnotateImagesResponse
                         */
                        AsyncBatchAnnotateImagesResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse)
                                return object;
                            var message = new $root.google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse();
                            if (object.outputConfig != null) {
                                if (typeof object.outputConfig !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse.outputConfig: object expected");
                                message.outputConfig = $root.google.cloud.vision.v1.OutputConfig.fromObject(object.outputConfig);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AsyncBatchAnnotateImagesResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @static
                         * @param {google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse} message AsyncBatchAnnotateImagesResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AsyncBatchAnnotateImagesResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.outputConfig = null;
                            if (message.outputConfig != null && message.hasOwnProperty("outputConfig"))
                                object.outputConfig = $root.google.cloud.vision.v1.OutputConfig.toObject(message.outputConfig, options);
                            return object;
                        };
    
                        /**
                         * Converts this AsyncBatchAnnotateImagesResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AsyncBatchAnnotateImagesResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AsyncBatchAnnotateImagesResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AsyncBatchAnnotateImagesResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse";
                        };
    
                        return AsyncBatchAnnotateImagesResponse;
                    })();
    
                    v1.AsyncBatchAnnotateFilesRequest = (function() {
    
                        /**
                         * Properties of an AsyncBatchAnnotateFilesRequest.
                         * @memberof google.cloud.vision.v1
                         * @interface IAsyncBatchAnnotateFilesRequest
                         * @property {Array.<google.cloud.vision.v1.IAsyncAnnotateFileRequest>|null} [requests] AsyncBatchAnnotateFilesRequest requests
                         * @property {string|null} [parent] AsyncBatchAnnotateFilesRequest parent
                         * @property {Object.<string,string>|null} [labels] AsyncBatchAnnotateFilesRequest labels
                         */
    
                        /**
                         * Constructs a new AsyncBatchAnnotateFilesRequest.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an AsyncBatchAnnotateFilesRequest.
                         * @implements IAsyncBatchAnnotateFilesRequest
                         * @constructor
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest=} [properties] Properties to set
                         */
                        function AsyncBatchAnnotateFilesRequest(properties) {
                            this.requests = [];
                            this.labels = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AsyncBatchAnnotateFilesRequest requests.
                         * @member {Array.<google.cloud.vision.v1.IAsyncAnnotateFileRequest>} requests
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @instance
                         */
                        AsyncBatchAnnotateFilesRequest.prototype.requests = $util.emptyArray;
    
                        /**
                         * AsyncBatchAnnotateFilesRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @instance
                         */
                        AsyncBatchAnnotateFilesRequest.prototype.parent = "";
    
                        /**
                         * AsyncBatchAnnotateFilesRequest labels.
                         * @member {Object.<string,string>} labels
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @instance
                         */
                        AsyncBatchAnnotateFilesRequest.prototype.labels = $util.emptyObject;
    
                        /**
                         * Creates a new AsyncBatchAnnotateFilesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest} AsyncBatchAnnotateFilesRequest instance
                         */
                        AsyncBatchAnnotateFilesRequest.create = function create(properties) {
                            return new AsyncBatchAnnotateFilesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified AsyncBatchAnnotateFilesRequest message. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest} message AsyncBatchAnnotateFilesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncBatchAnnotateFilesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.requests != null && message.requests.length)
                                for (var i = 0; i < message.requests.length; ++i)
                                    $root.google.cloud.vision.v1.AsyncAnnotateFileRequest.encode(message.requests[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.parent);
                            if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                                for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 5, wireType 2 =*/42).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AsyncBatchAnnotateFilesRequest message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateFilesRequest} message AsyncBatchAnnotateFilesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncBatchAnnotateFilesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AsyncBatchAnnotateFilesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest} AsyncBatchAnnotateFilesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncBatchAnnotateFilesRequest.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.requests && message.requests.length))
                                            message.requests = [];
                                        message.requests.push($root.google.cloud.vision.v1.AsyncAnnotateFileRequest.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 4: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 5: {
                                        if (message.labels === $util.emptyObject)
                                            message.labels = {};
                                        var end2 = reader.uint32() + reader.pos;
                                        key = "";
                                        value = "";
                                        while (reader.pos < end2) {
                                            var tag2 = reader.uint32();
                                            switch (tag2 >>> 3) {
                                            case 1:
                                                key = reader.string();
                                                break;
                                            case 2:
                                                value = reader.string();
                                                break;
                                            default:
                                                reader.skipType(tag2 & 7);
                                                break;
                                            }
                                        }
                                        message.labels[key] = value;
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AsyncBatchAnnotateFilesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest} AsyncBatchAnnotateFilesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncBatchAnnotateFilesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AsyncBatchAnnotateFilesRequest message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AsyncBatchAnnotateFilesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.requests != null && message.hasOwnProperty("requests")) {
                                if (!Array.isArray(message.requests))
                                    return "requests: array expected";
                                for (var i = 0; i < message.requests.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.AsyncAnnotateFileRequest.verify(message.requests[i]);
                                    if (error)
                                        return "requests." + error;
                                }
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.labels != null && message.hasOwnProperty("labels")) {
                                if (!$util.isObject(message.labels))
                                    return "labels: object expected";
                                var key = Object.keys(message.labels);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.labels[key[i]]))
                                        return "labels: string{k:string} expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AsyncBatchAnnotateFilesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest} AsyncBatchAnnotateFilesRequest
                         */
                        AsyncBatchAnnotateFilesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest)
                                return object;
                            var message = new $root.google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest();
                            if (object.requests) {
                                if (!Array.isArray(object.requests))
                                    throw TypeError(".google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.requests: array expected");
                                message.requests = [];
                                for (var i = 0; i < object.requests.length; ++i) {
                                    if (typeof object.requests[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.requests: object expected");
                                    message.requests[i] = $root.google.cloud.vision.v1.AsyncAnnotateFileRequest.fromObject(object.requests[i]);
                                }
                            }
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.labels) {
                                if (typeof object.labels !== "object")
                                    throw TypeError(".google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.labels: object expected");
                                message.labels = {};
                                for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                    message.labels[keys[i]] = String(object.labels[keys[i]]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AsyncBatchAnnotateFilesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @static
                         * @param {google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest} message AsyncBatchAnnotateFilesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AsyncBatchAnnotateFilesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.requests = [];
                            if (options.objects || options.defaults)
                                object.labels = {};
                            if (options.defaults)
                                object.parent = "";
                            if (message.requests && message.requests.length) {
                                object.requests = [];
                                for (var j = 0; j < message.requests.length; ++j)
                                    object.requests[j] = $root.google.cloud.vision.v1.AsyncAnnotateFileRequest.toObject(message.requests[j], options);
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            var keys2;
                            if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                                object.labels = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.labels[keys2[j]] = message.labels[keys2[j]];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AsyncBatchAnnotateFilesRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AsyncBatchAnnotateFilesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AsyncBatchAnnotateFilesRequest
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AsyncBatchAnnotateFilesRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest";
                        };
    
                        return AsyncBatchAnnotateFilesRequest;
                    })();
    
                    v1.AsyncBatchAnnotateFilesResponse = (function() {
    
                        /**
                         * Properties of an AsyncBatchAnnotateFilesResponse.
                         * @memberof google.cloud.vision.v1
                         * @interface IAsyncBatchAnnotateFilesResponse
                         * @property {Array.<google.cloud.vision.v1.IAsyncAnnotateFileResponse>|null} [responses] AsyncBatchAnnotateFilesResponse responses
                         */
    
                        /**
                         * Constructs a new AsyncBatchAnnotateFilesResponse.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an AsyncBatchAnnotateFilesResponse.
                         * @implements IAsyncBatchAnnotateFilesResponse
                         * @constructor
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateFilesResponse=} [properties] Properties to set
                         */
                        function AsyncBatchAnnotateFilesResponse(properties) {
                            this.responses = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AsyncBatchAnnotateFilesResponse responses.
                         * @member {Array.<google.cloud.vision.v1.IAsyncAnnotateFileResponse>} responses
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @instance
                         */
                        AsyncBatchAnnotateFilesResponse.prototype.responses = $util.emptyArray;
    
                        /**
                         * Creates a new AsyncBatchAnnotateFilesResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateFilesResponse=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse} AsyncBatchAnnotateFilesResponse instance
                         */
                        AsyncBatchAnnotateFilesResponse.create = function create(properties) {
                            return new AsyncBatchAnnotateFilesResponse(properties);
                        };
    
                        /**
                         * Encodes the specified AsyncBatchAnnotateFilesResponse message. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateFilesResponse} message AsyncBatchAnnotateFilesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncBatchAnnotateFilesResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.responses != null && message.responses.length)
                                for (var i = 0; i < message.responses.length; ++i)
                                    $root.google.cloud.vision.v1.AsyncAnnotateFileResponse.encode(message.responses[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AsyncBatchAnnotateFilesResponse message, length delimited. Does not implicitly {@link google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @static
                         * @param {google.cloud.vision.v1.IAsyncBatchAnnotateFilesResponse} message AsyncBatchAnnotateFilesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AsyncBatchAnnotateFilesResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AsyncBatchAnnotateFilesResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse} AsyncBatchAnnotateFilesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncBatchAnnotateFilesResponse.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.responses && message.responses.length))
                                            message.responses = [];
                                        message.responses.push($root.google.cloud.vision.v1.AsyncAnnotateFileResponse.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AsyncBatchAnnotateFilesResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse} AsyncBatchAnnotateFilesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AsyncBatchAnnotateFilesResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AsyncBatchAnnotateFilesResponse message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AsyncBatchAnnotateFilesResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.responses != null && message.hasOwnProperty("responses")) {
                                if (!Array.isArray(message.responses))
                                    return "responses: array expected";
                                for (var i = 0; i < message.responses.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.AsyncAnnotateFileResponse.verify(message.responses[i]);
                                    if (error)
                                        return "responses." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AsyncBatchAnnotateFilesResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse} AsyncBatchAnnotateFilesResponse
                         */
                        AsyncBatchAnnotateFilesResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse)
                                return object;
                            var message = new $root.google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse();
                            if (object.responses) {
                                if (!Array.isArray(object.responses))
                                    throw TypeError(".google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse.responses: array expected");
                                message.responses = [];
                                for (var i = 0; i < object.responses.length; ++i) {
                                    if (typeof object.responses[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse.responses: object expected");
                                    message.responses[i] = $root.google.cloud.vision.v1.AsyncAnnotateFileResponse.fromObject(object.responses[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AsyncBatchAnnotateFilesResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @static
                         * @param {google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse} message AsyncBatchAnnotateFilesResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AsyncBatchAnnotateFilesResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.responses = [];
                            if (message.responses && message.responses.length) {
                                object.responses = [];
                                for (var j = 0; j < message.responses.length; ++j)
                                    object.responses[j] = $root.google.cloud.vision.v1.AsyncAnnotateFileResponse.toObject(message.responses[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AsyncBatchAnnotateFilesResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AsyncBatchAnnotateFilesResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AsyncBatchAnnotateFilesResponse
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AsyncBatchAnnotateFilesResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse";
                        };
    
                        return AsyncBatchAnnotateFilesResponse;
                    })();
    
                    v1.InputConfig = (function() {
    
                        /**
                         * Properties of an InputConfig.
                         * @memberof google.cloud.vision.v1
                         * @interface IInputConfig
                         * @property {google.cloud.vision.v1.IGcsSource|null} [gcsSource] InputConfig gcsSource
                         * @property {Uint8Array|null} [content] InputConfig content
                         * @property {string|null} [mimeType] InputConfig mimeType
                         */
    
                        /**
                         * Constructs a new InputConfig.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an InputConfig.
                         * @implements IInputConfig
                         * @constructor
                         * @param {google.cloud.vision.v1.IInputConfig=} [properties] Properties to set
                         */
                        function InputConfig(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * InputConfig gcsSource.
                         * @member {google.cloud.vision.v1.IGcsSource|null|undefined} gcsSource
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @instance
                         */
                        InputConfig.prototype.gcsSource = null;
    
                        /**
                         * InputConfig content.
                         * @member {Uint8Array} content
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @instance
                         */
                        InputConfig.prototype.content = $util.newBuffer([]);
    
                        /**
                         * InputConfig mimeType.
                         * @member {string} mimeType
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @instance
                         */
                        InputConfig.prototype.mimeType = "";
    
                        /**
                         * Creates a new InputConfig instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @static
                         * @param {google.cloud.vision.v1.IInputConfig=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.InputConfig} InputConfig instance
                         */
                        InputConfig.create = function create(properties) {
                            return new InputConfig(properties);
                        };
    
                        /**
                         * Encodes the specified InputConfig message. Does not implicitly {@link google.cloud.vision.v1.InputConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @static
                         * @param {google.cloud.vision.v1.IInputConfig} message InputConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        InputConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.gcsSource != null && Object.hasOwnProperty.call(message, "gcsSource"))
                                $root.google.cloud.vision.v1.GcsSource.encode(message.gcsSource, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.mimeType != null && Object.hasOwnProperty.call(message, "mimeType"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.mimeType);
                            if (message.content != null && Object.hasOwnProperty.call(message, "content"))
                                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.content);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified InputConfig message, length delimited. Does not implicitly {@link google.cloud.vision.v1.InputConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @static
                         * @param {google.cloud.vision.v1.IInputConfig} message InputConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        InputConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an InputConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.InputConfig} InputConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        InputConfig.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.InputConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.gcsSource = $root.google.cloud.vision.v1.GcsSource.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        message.content = reader.bytes();
                                        break;
                                    }
                                case 2: {
                                        message.mimeType = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an InputConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.InputConfig} InputConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        InputConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an InputConfig message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        InputConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.gcsSource != null && message.hasOwnProperty("gcsSource")) {
                                var error = $root.google.cloud.vision.v1.GcsSource.verify(message.gcsSource);
                                if (error)
                                    return "gcsSource." + error;
                            }
                            if (message.content != null && message.hasOwnProperty("content"))
                                if (!(message.content && typeof message.content.length === "number" || $util.isString(message.content)))
                                    return "content: buffer expected";
                            if (message.mimeType != null && message.hasOwnProperty("mimeType"))
                                if (!$util.isString(message.mimeType))
                                    return "mimeType: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an InputConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.InputConfig} InputConfig
                         */
                        InputConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.InputConfig)
                                return object;
                            var message = new $root.google.cloud.vision.v1.InputConfig();
                            if (object.gcsSource != null) {
                                if (typeof object.gcsSource !== "object")
                                    throw TypeError(".google.cloud.vision.v1.InputConfig.gcsSource: object expected");
                                message.gcsSource = $root.google.cloud.vision.v1.GcsSource.fromObject(object.gcsSource);
                            }
                            if (object.content != null)
                                if (typeof object.content === "string")
                                    $util.base64.decode(object.content, message.content = $util.newBuffer($util.base64.length(object.content)), 0);
                                else if (object.content.length >= 0)
                                    message.content = object.content;
                            if (object.mimeType != null)
                                message.mimeType = String(object.mimeType);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an InputConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @static
                         * @param {google.cloud.vision.v1.InputConfig} message InputConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        InputConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.gcsSource = null;
                                object.mimeType = "";
                                if (options.bytes === String)
                                    object.content = "";
                                else {
                                    object.content = [];
                                    if (options.bytes !== Array)
                                        object.content = $util.newBuffer(object.content);
                                }
                            }
                            if (message.gcsSource != null && message.hasOwnProperty("gcsSource"))
                                object.gcsSource = $root.google.cloud.vision.v1.GcsSource.toObject(message.gcsSource, options);
                            if (message.mimeType != null && message.hasOwnProperty("mimeType"))
                                object.mimeType = message.mimeType;
                            if (message.content != null && message.hasOwnProperty("content"))
                                object.content = options.bytes === String ? $util.base64.encode(message.content, 0, message.content.length) : options.bytes === Array ? Array.prototype.slice.call(message.content) : message.content;
                            return object;
                        };
    
                        /**
                         * Converts this InputConfig to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        InputConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for InputConfig
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.InputConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        InputConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.InputConfig";
                        };
    
                        return InputConfig;
                    })();
    
                    v1.OutputConfig = (function() {
    
                        /**
                         * Properties of an OutputConfig.
                         * @memberof google.cloud.vision.v1
                         * @interface IOutputConfig
                         * @property {google.cloud.vision.v1.IGcsDestination|null} [gcsDestination] OutputConfig gcsDestination
                         * @property {number|null} [batchSize] OutputConfig batchSize
                         */
    
                        /**
                         * Constructs a new OutputConfig.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an OutputConfig.
                         * @implements IOutputConfig
                         * @constructor
                         * @param {google.cloud.vision.v1.IOutputConfig=} [properties] Properties to set
                         */
                        function OutputConfig(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * OutputConfig gcsDestination.
                         * @member {google.cloud.vision.v1.IGcsDestination|null|undefined} gcsDestination
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @instance
                         */
                        OutputConfig.prototype.gcsDestination = null;
    
                        /**
                         * OutputConfig batchSize.
                         * @member {number} batchSize
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @instance
                         */
                        OutputConfig.prototype.batchSize = 0;
    
                        /**
                         * Creates a new OutputConfig instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @static
                         * @param {google.cloud.vision.v1.IOutputConfig=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.OutputConfig} OutputConfig instance
                         */
                        OutputConfig.create = function create(properties) {
                            return new OutputConfig(properties);
                        };
    
                        /**
                         * Encodes the specified OutputConfig message. Does not implicitly {@link google.cloud.vision.v1.OutputConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @static
                         * @param {google.cloud.vision.v1.IOutputConfig} message OutputConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OutputConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.gcsDestination != null && Object.hasOwnProperty.call(message, "gcsDestination"))
                                $root.google.cloud.vision.v1.GcsDestination.encode(message.gcsDestination, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.batchSize != null && Object.hasOwnProperty.call(message, "batchSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.batchSize);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified OutputConfig message, length delimited. Does not implicitly {@link google.cloud.vision.v1.OutputConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @static
                         * @param {google.cloud.vision.v1.IOutputConfig} message OutputConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OutputConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an OutputConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.OutputConfig} OutputConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OutputConfig.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.OutputConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.gcsDestination = $root.google.cloud.vision.v1.GcsDestination.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.batchSize = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an OutputConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.OutputConfig} OutputConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OutputConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an OutputConfig message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OutputConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.gcsDestination != null && message.hasOwnProperty("gcsDestination")) {
                                var error = $root.google.cloud.vision.v1.GcsDestination.verify(message.gcsDestination);
                                if (error)
                                    return "gcsDestination." + error;
                            }
                            if (message.batchSize != null && message.hasOwnProperty("batchSize"))
                                if (!$util.isInteger(message.batchSize))
                                    return "batchSize: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates an OutputConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.OutputConfig} OutputConfig
                         */
                        OutputConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.OutputConfig)
                                return object;
                            var message = new $root.google.cloud.vision.v1.OutputConfig();
                            if (object.gcsDestination != null) {
                                if (typeof object.gcsDestination !== "object")
                                    throw TypeError(".google.cloud.vision.v1.OutputConfig.gcsDestination: object expected");
                                message.gcsDestination = $root.google.cloud.vision.v1.GcsDestination.fromObject(object.gcsDestination);
                            }
                            if (object.batchSize != null)
                                message.batchSize = object.batchSize | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an OutputConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @static
                         * @param {google.cloud.vision.v1.OutputConfig} message OutputConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OutputConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.gcsDestination = null;
                                object.batchSize = 0;
                            }
                            if (message.gcsDestination != null && message.hasOwnProperty("gcsDestination"))
                                object.gcsDestination = $root.google.cloud.vision.v1.GcsDestination.toObject(message.gcsDestination, options);
                            if (message.batchSize != null && message.hasOwnProperty("batchSize"))
                                object.batchSize = message.batchSize;
                            return object;
                        };
    
                        /**
                         * Converts this OutputConfig to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OutputConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for OutputConfig
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.OutputConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        OutputConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.OutputConfig";
                        };
    
                        return OutputConfig;
                    })();
    
                    v1.GcsSource = (function() {
    
                        /**
                         * Properties of a GcsSource.
                         * @memberof google.cloud.vision.v1
                         * @interface IGcsSource
                         * @property {string|null} [uri] GcsSource uri
                         */
    
                        /**
                         * Constructs a new GcsSource.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a GcsSource.
                         * @implements IGcsSource
                         * @constructor
                         * @param {google.cloud.vision.v1.IGcsSource=} [properties] Properties to set
                         */
                        function GcsSource(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GcsSource uri.
                         * @member {string} uri
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @instance
                         */
                        GcsSource.prototype.uri = "";
    
                        /**
                         * Creates a new GcsSource instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @static
                         * @param {google.cloud.vision.v1.IGcsSource=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.GcsSource} GcsSource instance
                         */
                        GcsSource.create = function create(properties) {
                            return new GcsSource(properties);
                        };
    
                        /**
                         * Encodes the specified GcsSource message. Does not implicitly {@link google.cloud.vision.v1.GcsSource.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @static
                         * @param {google.cloud.vision.v1.IGcsSource} message GcsSource message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GcsSource.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.uri != null && Object.hasOwnProperty.call(message, "uri"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.uri);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GcsSource message, length delimited. Does not implicitly {@link google.cloud.vision.v1.GcsSource.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @static
                         * @param {google.cloud.vision.v1.IGcsSource} message GcsSource message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GcsSource.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GcsSource message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.GcsSource} GcsSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GcsSource.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.GcsSource();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.uri = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GcsSource message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.GcsSource} GcsSource
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GcsSource.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GcsSource message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GcsSource.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.uri != null && message.hasOwnProperty("uri"))
                                if (!$util.isString(message.uri))
                                    return "uri: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GcsSource message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.GcsSource} GcsSource
                         */
                        GcsSource.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.GcsSource)
                                return object;
                            var message = new $root.google.cloud.vision.v1.GcsSource();
                            if (object.uri != null)
                                message.uri = String(object.uri);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GcsSource message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @static
                         * @param {google.cloud.vision.v1.GcsSource} message GcsSource
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GcsSource.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.uri = "";
                            if (message.uri != null && message.hasOwnProperty("uri"))
                                object.uri = message.uri;
                            return object;
                        };
    
                        /**
                         * Converts this GcsSource to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GcsSource.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GcsSource
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.GcsSource
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GcsSource.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.GcsSource";
                        };
    
                        return GcsSource;
                    })();
    
                    v1.GcsDestination = (function() {
    
                        /**
                         * Properties of a GcsDestination.
                         * @memberof google.cloud.vision.v1
                         * @interface IGcsDestination
                         * @property {string|null} [uri] GcsDestination uri
                         */
    
                        /**
                         * Constructs a new GcsDestination.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a GcsDestination.
                         * @implements IGcsDestination
                         * @constructor
                         * @param {google.cloud.vision.v1.IGcsDestination=} [properties] Properties to set
                         */
                        function GcsDestination(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GcsDestination uri.
                         * @member {string} uri
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @instance
                         */
                        GcsDestination.prototype.uri = "";
    
                        /**
                         * Creates a new GcsDestination instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @static
                         * @param {google.cloud.vision.v1.IGcsDestination=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.GcsDestination} GcsDestination instance
                         */
                        GcsDestination.create = function create(properties) {
                            return new GcsDestination(properties);
                        };
    
                        /**
                         * Encodes the specified GcsDestination message. Does not implicitly {@link google.cloud.vision.v1.GcsDestination.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @static
                         * @param {google.cloud.vision.v1.IGcsDestination} message GcsDestination message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GcsDestination.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.uri != null && Object.hasOwnProperty.call(message, "uri"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.uri);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GcsDestination message, length delimited. Does not implicitly {@link google.cloud.vision.v1.GcsDestination.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @static
                         * @param {google.cloud.vision.v1.IGcsDestination} message GcsDestination message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GcsDestination.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GcsDestination message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.GcsDestination} GcsDestination
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GcsDestination.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.GcsDestination();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.uri = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GcsDestination message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.GcsDestination} GcsDestination
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GcsDestination.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GcsDestination message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GcsDestination.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.uri != null && message.hasOwnProperty("uri"))
                                if (!$util.isString(message.uri))
                                    return "uri: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GcsDestination message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.GcsDestination} GcsDestination
                         */
                        GcsDestination.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.GcsDestination)
                                return object;
                            var message = new $root.google.cloud.vision.v1.GcsDestination();
                            if (object.uri != null)
                                message.uri = String(object.uri);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GcsDestination message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @static
                         * @param {google.cloud.vision.v1.GcsDestination} message GcsDestination
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GcsDestination.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.uri = "";
                            if (message.uri != null && message.hasOwnProperty("uri"))
                                object.uri = message.uri;
                            return object;
                        };
    
                        /**
                         * Converts this GcsDestination to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GcsDestination.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GcsDestination
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.GcsDestination
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GcsDestination.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.GcsDestination";
                        };
    
                        return GcsDestination;
                    })();
    
                    v1.OperationMetadata = (function() {
    
                        /**
                         * Properties of an OperationMetadata.
                         * @memberof google.cloud.vision.v1
                         * @interface IOperationMetadata
                         * @property {google.cloud.vision.v1.OperationMetadata.State|null} [state] OperationMetadata state
                         * @property {google.protobuf.ITimestamp|null} [createTime] OperationMetadata createTime
                         * @property {google.protobuf.ITimestamp|null} [updateTime] OperationMetadata updateTime
                         */
    
                        /**
                         * Constructs a new OperationMetadata.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents an OperationMetadata.
                         * @implements IOperationMetadata
                         * @constructor
                         * @param {google.cloud.vision.v1.IOperationMetadata=} [properties] Properties to set
                         */
                        function OperationMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * OperationMetadata state.
                         * @member {google.cloud.vision.v1.OperationMetadata.State} state
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @instance
                         */
                        OperationMetadata.prototype.state = 0;
    
                        /**
                         * OperationMetadata createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @instance
                         */
                        OperationMetadata.prototype.createTime = null;
    
                        /**
                         * OperationMetadata updateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @instance
                         */
                        OperationMetadata.prototype.updateTime = null;
    
                        /**
                         * Creates a new OperationMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @static
                         * @param {google.cloud.vision.v1.IOperationMetadata=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.OperationMetadata} OperationMetadata instance
                         */
                        OperationMetadata.create = function create(properties) {
                            return new OperationMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified OperationMetadata message. Does not implicitly {@link google.cloud.vision.v1.OperationMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @static
                         * @param {google.cloud.vision.v1.IOperationMetadata} message OperationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OperationMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.state);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.updateTime != null && Object.hasOwnProperty.call(message, "updateTime"))
                                $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified OperationMetadata message, length delimited. Does not implicitly {@link google.cloud.vision.v1.OperationMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @static
                         * @param {google.cloud.vision.v1.IOperationMetadata} message OperationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OperationMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an OperationMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.OperationMetadata} OperationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OperationMetadata.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.OperationMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 5: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an OperationMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.OperationMetadata} OperationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OperationMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an OperationMetadata message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OperationMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                    break;
                                }
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
                                if (error)
                                    return "updateTime." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an OperationMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.OperationMetadata} OperationMetadata
                         */
                        OperationMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.OperationMetadata)
                                return object;
                            var message = new $root.google.cloud.vision.v1.OperationMetadata();
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "CREATED":
                            case 1:
                                message.state = 1;
                                break;
                            case "RUNNING":
                            case 2:
                                message.state = 2;
                                break;
                            case "DONE":
                            case 3:
                                message.state = 3;
                                break;
                            case "CANCELLED":
                            case 4:
                                message.state = 4;
                                break;
                            }
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.vision.v1.OperationMetadata.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.updateTime != null) {
                                if (typeof object.updateTime !== "object")
                                    throw TypeError(".google.cloud.vision.v1.OperationMetadata.updateTime: object expected");
                                message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an OperationMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @static
                         * @param {google.cloud.vision.v1.OperationMetadata} message OperationMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OperationMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.createTime = null;
                                object.updateTime = null;
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.cloud.vision.v1.OperationMetadata.State[message.state] === undefined ? message.state : $root.google.cloud.vision.v1.OperationMetadata.State[message.state] : message.state;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.updateTime != null && message.hasOwnProperty("updateTime"))
                                object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
                            return object;
                        };
    
                        /**
                         * Converts this OperationMetadata to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OperationMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for OperationMetadata
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.OperationMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        OperationMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.OperationMetadata";
                        };
    
                        /**
                         * State enum.
                         * @name google.cloud.vision.v1.OperationMetadata.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} CREATED=1 CREATED value
                         * @property {number} RUNNING=2 RUNNING value
                         * @property {number} DONE=3 DONE value
                         * @property {number} CANCELLED=4 CANCELLED value
                         */
                        OperationMetadata.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "CREATED"] = 1;
                            values[valuesById[2] = "RUNNING"] = 2;
                            values[valuesById[3] = "DONE"] = 3;
                            values[valuesById[4] = "CANCELLED"] = 4;
                            return values;
                        })();
    
                        return OperationMetadata;
                    })();
    
                    v1.ProductSearchParams = (function() {
    
                        /**
                         * Properties of a ProductSearchParams.
                         * @memberof google.cloud.vision.v1
                         * @interface IProductSearchParams
                         * @property {google.cloud.vision.v1.IBoundingPoly|null} [boundingPoly] ProductSearchParams boundingPoly
                         * @property {string|null} [productSet] ProductSearchParams productSet
                         * @property {Array.<string>|null} [productCategories] ProductSearchParams productCategories
                         * @property {string|null} [filter] ProductSearchParams filter
                         */
    
                        /**
                         * Constructs a new ProductSearchParams.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a ProductSearchParams.
                         * @implements IProductSearchParams
                         * @constructor
                         * @param {google.cloud.vision.v1.IProductSearchParams=} [properties] Properties to set
                         */
                        function ProductSearchParams(properties) {
                            this.productCategories = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ProductSearchParams boundingPoly.
                         * @member {google.cloud.vision.v1.IBoundingPoly|null|undefined} boundingPoly
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @instance
                         */
                        ProductSearchParams.prototype.boundingPoly = null;
    
                        /**
                         * ProductSearchParams productSet.
                         * @member {string} productSet
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @instance
                         */
                        ProductSearchParams.prototype.productSet = "";
    
                        /**
                         * ProductSearchParams productCategories.
                         * @member {Array.<string>} productCategories
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @instance
                         */
                        ProductSearchParams.prototype.productCategories = $util.emptyArray;
    
                        /**
                         * ProductSearchParams filter.
                         * @member {string} filter
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @instance
                         */
                        ProductSearchParams.prototype.filter = "";
    
                        /**
                         * Creates a new ProductSearchParams instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @static
                         * @param {google.cloud.vision.v1.IProductSearchParams=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.ProductSearchParams} ProductSearchParams instance
                         */
                        ProductSearchParams.create = function create(properties) {
                            return new ProductSearchParams(properties);
                        };
    
                        /**
                         * Encodes the specified ProductSearchParams message. Does not implicitly {@link google.cloud.vision.v1.ProductSearchParams.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @static
                         * @param {google.cloud.vision.v1.IProductSearchParams} message ProductSearchParams message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ProductSearchParams.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.productSet != null && Object.hasOwnProperty.call(message, "productSet"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.productSet);
                            if (message.productCategories != null && message.productCategories.length)
                                for (var i = 0; i < message.productCategories.length; ++i)
                                    writer.uint32(/* id 7, wireType 2 =*/58).string(message.productCategories[i]);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 8, wireType 2 =*/66).string(message.filter);
                            if (message.boundingPoly != null && Object.hasOwnProperty.call(message, "boundingPoly"))
                                $root.google.cloud.vision.v1.BoundingPoly.encode(message.boundingPoly, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ProductSearchParams message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSearchParams.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @static
                         * @param {google.cloud.vision.v1.IProductSearchParams} message ProductSearchParams message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ProductSearchParams.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ProductSearchParams message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.ProductSearchParams} ProductSearchParams
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ProductSearchParams.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.ProductSearchParams();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 9: {
                                        message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.productSet = reader.string();
                                        break;
                                    }
                                case 7: {
                                        if (!(message.productCategories && message.productCategories.length))
                                            message.productCategories = [];
                                        message.productCategories.push(reader.string());
                                        break;
                                    }
                                case 8: {
                                        message.filter = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ProductSearchParams message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.ProductSearchParams} ProductSearchParams
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ProductSearchParams.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ProductSearchParams message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ProductSearchParams.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly")) {
                                var error = $root.google.cloud.vision.v1.BoundingPoly.verify(message.boundingPoly);
                                if (error)
                                    return "boundingPoly." + error;
                            }
                            if (message.productSet != null && message.hasOwnProperty("productSet"))
                                if (!$util.isString(message.productSet))
                                    return "productSet: string expected";
                            if (message.productCategories != null && message.hasOwnProperty("productCategories")) {
                                if (!Array.isArray(message.productCategories))
                                    return "productCategories: array expected";
                                for (var i = 0; i < message.productCategories.length; ++i)
                                    if (!$util.isString(message.productCategories[i]))
                                        return "productCategories: string[] expected";
                            }
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ProductSearchParams message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.ProductSearchParams} ProductSearchParams
                         */
                        ProductSearchParams.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.ProductSearchParams)
                                return object;
                            var message = new $root.google.cloud.vision.v1.ProductSearchParams();
                            if (object.boundingPoly != null) {
                                if (typeof object.boundingPoly !== "object")
                                    throw TypeError(".google.cloud.vision.v1.ProductSearchParams.boundingPoly: object expected");
                                message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.fromObject(object.boundingPoly);
                            }
                            if (object.productSet != null)
                                message.productSet = String(object.productSet);
                            if (object.productCategories) {
                                if (!Array.isArray(object.productCategories))
                                    throw TypeError(".google.cloud.vision.v1.ProductSearchParams.productCategories: array expected");
                                message.productCategories = [];
                                for (var i = 0; i < object.productCategories.length; ++i)
                                    message.productCategories[i] = String(object.productCategories[i]);
                            }
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ProductSearchParams message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @static
                         * @param {google.cloud.vision.v1.ProductSearchParams} message ProductSearchParams
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ProductSearchParams.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.productCategories = [];
                            if (options.defaults) {
                                object.productSet = "";
                                object.filter = "";
                                object.boundingPoly = null;
                            }
                            if (message.productSet != null && message.hasOwnProperty("productSet"))
                                object.productSet = message.productSet;
                            if (message.productCategories && message.productCategories.length) {
                                object.productCategories = [];
                                for (var j = 0; j < message.productCategories.length; ++j)
                                    object.productCategories[j] = message.productCategories[j];
                            }
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly"))
                                object.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.toObject(message.boundingPoly, options);
                            return object;
                        };
    
                        /**
                         * Converts this ProductSearchParams to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ProductSearchParams.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ProductSearchParams
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.ProductSearchParams
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ProductSearchParams.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.ProductSearchParams";
                        };
    
                        return ProductSearchParams;
                    })();
    
                    v1.ProductSearchResults = (function() {
    
                        /**
                         * Properties of a ProductSearchResults.
                         * @memberof google.cloud.vision.v1
                         * @interface IProductSearchResults
                         * @property {google.protobuf.ITimestamp|null} [indexTime] ProductSearchResults indexTime
                         * @property {Array.<google.cloud.vision.v1.ProductSearchResults.IResult>|null} [results] ProductSearchResults results
                         * @property {Array.<google.cloud.vision.v1.ProductSearchResults.IGroupedResult>|null} [productGroupedResults] ProductSearchResults productGroupedResults
                         */
    
                        /**
                         * Constructs a new ProductSearchResults.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a ProductSearchResults.
                         * @implements IProductSearchResults
                         * @constructor
                         * @param {google.cloud.vision.v1.IProductSearchResults=} [properties] Properties to set
                         */
                        function ProductSearchResults(properties) {
                            this.results = [];
                            this.productGroupedResults = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ProductSearchResults indexTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} indexTime
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @instance
                         */
                        ProductSearchResults.prototype.indexTime = null;
    
                        /**
                         * ProductSearchResults results.
                         * @member {Array.<google.cloud.vision.v1.ProductSearchResults.IResult>} results
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @instance
                         */
                        ProductSearchResults.prototype.results = $util.emptyArray;
    
                        /**
                         * ProductSearchResults productGroupedResults.
                         * @member {Array.<google.cloud.vision.v1.ProductSearchResults.IGroupedResult>} productGroupedResults
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @instance
                         */
                        ProductSearchResults.prototype.productGroupedResults = $util.emptyArray;
    
                        /**
                         * Creates a new ProductSearchResults instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @static
                         * @param {google.cloud.vision.v1.IProductSearchResults=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.ProductSearchResults} ProductSearchResults instance
                         */
                        ProductSearchResults.create = function create(properties) {
                            return new ProductSearchResults(properties);
                        };
    
                        /**
                         * Encodes the specified ProductSearchResults message. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @static
                         * @param {google.cloud.vision.v1.IProductSearchResults} message ProductSearchResults message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ProductSearchResults.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.indexTime != null && Object.hasOwnProperty.call(message, "indexTime"))
                                $root.google.protobuf.Timestamp.encode(message.indexTime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.results != null && message.results.length)
                                for (var i = 0; i < message.results.length; ++i)
                                    $root.google.cloud.vision.v1.ProductSearchResults.Result.encode(message.results[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.productGroupedResults != null && message.productGroupedResults.length)
                                for (var i = 0; i < message.productGroupedResults.length; ++i)
                                    $root.google.cloud.vision.v1.ProductSearchResults.GroupedResult.encode(message.productGroupedResults[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ProductSearchResults message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @static
                         * @param {google.cloud.vision.v1.IProductSearchResults} message ProductSearchResults message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ProductSearchResults.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ProductSearchResults message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.ProductSearchResults} ProductSearchResults
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ProductSearchResults.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.ProductSearchResults();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 2: {
                                        message.indexTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 5: {
                                        if (!(message.results && message.results.length))
                                            message.results = [];
                                        message.results.push($root.google.cloud.vision.v1.ProductSearchResults.Result.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 6: {
                                        if (!(message.productGroupedResults && message.productGroupedResults.length))
                                            message.productGroupedResults = [];
                                        message.productGroupedResults.push($root.google.cloud.vision.v1.ProductSearchResults.GroupedResult.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ProductSearchResults message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.ProductSearchResults} ProductSearchResults
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ProductSearchResults.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ProductSearchResults message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ProductSearchResults.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.indexTime != null && message.hasOwnProperty("indexTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.indexTime);
                                if (error)
                                    return "indexTime." + error;
                            }
                            if (message.results != null && message.hasOwnProperty("results")) {
                                if (!Array.isArray(message.results))
                                    return "results: array expected";
                                for (var i = 0; i < message.results.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.ProductSearchResults.Result.verify(message.results[i]);
                                    if (error)
                                        return "results." + error;
                                }
                            }
                            if (message.productGroupedResults != null && message.hasOwnProperty("productGroupedResults")) {
                                if (!Array.isArray(message.productGroupedResults))
                                    return "productGroupedResults: array expected";
                                for (var i = 0; i < message.productGroupedResults.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.ProductSearchResults.GroupedResult.verify(message.productGroupedResults[i]);
                                    if (error)
                                        return "productGroupedResults." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ProductSearchResults message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.ProductSearchResults} ProductSearchResults
                         */
                        ProductSearchResults.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.ProductSearchResults)
                                return object;
                            var message = new $root.google.cloud.vision.v1.ProductSearchResults();
                            if (object.indexTime != null) {
                                if (typeof object.indexTime !== "object")
                                    throw TypeError(".google.cloud.vision.v1.ProductSearchResults.indexTime: object expected");
                                message.indexTime = $root.google.protobuf.Timestamp.fromObject(object.indexTime);
                            }
                            if (object.results) {
                                if (!Array.isArray(object.results))
                                    throw TypeError(".google.cloud.vision.v1.ProductSearchResults.results: array expected");
                                message.results = [];
                                for (var i = 0; i < object.results.length; ++i) {
                                    if (typeof object.results[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.ProductSearchResults.results: object expected");
                                    message.results[i] = $root.google.cloud.vision.v1.ProductSearchResults.Result.fromObject(object.results[i]);
                                }
                            }
                            if (object.productGroupedResults) {
                                if (!Array.isArray(object.productGroupedResults))
                                    throw TypeError(".google.cloud.vision.v1.ProductSearchResults.productGroupedResults: array expected");
                                message.productGroupedResults = [];
                                for (var i = 0; i < object.productGroupedResults.length; ++i) {
                                    if (typeof object.productGroupedResults[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.ProductSearchResults.productGroupedResults: object expected");
                                    message.productGroupedResults[i] = $root.google.cloud.vision.v1.ProductSearchResults.GroupedResult.fromObject(object.productGroupedResults[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ProductSearchResults message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @static
                         * @param {google.cloud.vision.v1.ProductSearchResults} message ProductSearchResults
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ProductSearchResults.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.results = [];
                                object.productGroupedResults = [];
                            }
                            if (options.defaults)
                                object.indexTime = null;
                            if (message.indexTime != null && message.hasOwnProperty("indexTime"))
                                object.indexTime = $root.google.protobuf.Timestamp.toObject(message.indexTime, options);
                            if (message.results && message.results.length) {
                                object.results = [];
                                for (var j = 0; j < message.results.length; ++j)
                                    object.results[j] = $root.google.cloud.vision.v1.ProductSearchResults.Result.toObject(message.results[j], options);
                            }
                            if (message.productGroupedResults && message.productGroupedResults.length) {
                                object.productGroupedResults = [];
                                for (var j = 0; j < message.productGroupedResults.length; ++j)
                                    object.productGroupedResults[j] = $root.google.cloud.vision.v1.ProductSearchResults.GroupedResult.toObject(message.productGroupedResults[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ProductSearchResults to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ProductSearchResults.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ProductSearchResults
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.ProductSearchResults
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ProductSearchResults.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.ProductSearchResults";
                        };
    
                        ProductSearchResults.Result = (function() {
    
                            /**
                             * Properties of a Result.
                             * @memberof google.cloud.vision.v1.ProductSearchResults
                             * @interface IResult
                             * @property {google.cloud.vision.v1.IProduct|null} [product] Result product
                             * @property {number|null} [score] Result score
                             * @property {string|null} [image] Result image
                             */
    
                            /**
                             * Constructs a new Result.
                             * @memberof google.cloud.vision.v1.ProductSearchResults
                             * @classdesc Represents a Result.
                             * @implements IResult
                             * @constructor
                             * @param {google.cloud.vision.v1.ProductSearchResults.IResult=} [properties] Properties to set
                             */
                            function Result(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * Result product.
                             * @member {google.cloud.vision.v1.IProduct|null|undefined} product
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @instance
                             */
                            Result.prototype.product = null;
    
                            /**
                             * Result score.
                             * @member {number} score
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @instance
                             */
                            Result.prototype.score = 0;
    
                            /**
                             * Result image.
                             * @member {string} image
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @instance
                             */
                            Result.prototype.image = "";
    
                            /**
                             * Creates a new Result instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.IResult=} [properties] Properties to set
                             * @returns {google.cloud.vision.v1.ProductSearchResults.Result} Result instance
                             */
                            Result.create = function create(properties) {
                                return new Result(properties);
                            };
    
                            /**
                             * Encodes the specified Result message. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.Result.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.IResult} message Result message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            Result.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.product != null && Object.hasOwnProperty.call(message, "product"))
                                    $root.google.cloud.vision.v1.Product.encode(message.product, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                if (message.score != null && Object.hasOwnProperty.call(message, "score"))
                                    writer.uint32(/* id 2, wireType 5 =*/21).float(message.score);
                                if (message.image != null && Object.hasOwnProperty.call(message, "image"))
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.image);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified Result message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.Result.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.IResult} message Result message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            Result.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a Result message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.vision.v1.ProductSearchResults.Result} Result
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            Result.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.ProductSearchResults.Result();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.product = $root.google.cloud.vision.v1.Product.decode(reader, reader.uint32());
                                            break;
                                        }
                                    case 2: {
                                            message.score = reader.float();
                                            break;
                                        }
                                    case 3: {
                                            message.image = reader.string();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a Result message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.vision.v1.ProductSearchResults.Result} Result
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            Result.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a Result message.
                             * @function verify
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            Result.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.product != null && message.hasOwnProperty("product")) {
                                    var error = $root.google.cloud.vision.v1.Product.verify(message.product);
                                    if (error)
                                        return "product." + error;
                                }
                                if (message.score != null && message.hasOwnProperty("score"))
                                    if (typeof message.score !== "number")
                                        return "score: number expected";
                                if (message.image != null && message.hasOwnProperty("image"))
                                    if (!$util.isString(message.image))
                                        return "image: string expected";
                                return null;
                            };
    
                            /**
                             * Creates a Result message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.vision.v1.ProductSearchResults.Result} Result
                             */
                            Result.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.vision.v1.ProductSearchResults.Result)
                                    return object;
                                var message = new $root.google.cloud.vision.v1.ProductSearchResults.Result();
                                if (object.product != null) {
                                    if (typeof object.product !== "object")
                                        throw TypeError(".google.cloud.vision.v1.ProductSearchResults.Result.product: object expected");
                                    message.product = $root.google.cloud.vision.v1.Product.fromObject(object.product);
                                }
                                if (object.score != null)
                                    message.score = Number(object.score);
                                if (object.image != null)
                                    message.image = String(object.image);
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a Result message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.Result} message Result
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            Result.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.product = null;
                                    object.score = 0;
                                    object.image = "";
                                }
                                if (message.product != null && message.hasOwnProperty("product"))
                                    object.product = $root.google.cloud.vision.v1.Product.toObject(message.product, options);
                                if (message.score != null && message.hasOwnProperty("score"))
                                    object.score = options.json && !isFinite(message.score) ? String(message.score) : message.score;
                                if (message.image != null && message.hasOwnProperty("image"))
                                    object.image = message.image;
                                return object;
                            };
    
                            /**
                             * Converts this Result to JSON.
                             * @function toJSON
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            Result.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for Result
                             * @function getTypeUrl
                             * @memberof google.cloud.vision.v1.ProductSearchResults.Result
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            Result.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.vision.v1.ProductSearchResults.Result";
                            };
    
                            return Result;
                        })();
    
                        ProductSearchResults.ObjectAnnotation = (function() {
    
                            /**
                             * Properties of an ObjectAnnotation.
                             * @memberof google.cloud.vision.v1.ProductSearchResults
                             * @interface IObjectAnnotation
                             * @property {string|null} [mid] ObjectAnnotation mid
                             * @property {string|null} [languageCode] ObjectAnnotation languageCode
                             * @property {string|null} [name] ObjectAnnotation name
                             * @property {number|null} [score] ObjectAnnotation score
                             */
    
                            /**
                             * Constructs a new ObjectAnnotation.
                             * @memberof google.cloud.vision.v1.ProductSearchResults
                             * @classdesc Represents an ObjectAnnotation.
                             * @implements IObjectAnnotation
                             * @constructor
                             * @param {google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation=} [properties] Properties to set
                             */
                            function ObjectAnnotation(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * ObjectAnnotation mid.
                             * @member {string} mid
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @instance
                             */
                            ObjectAnnotation.prototype.mid = "";
    
                            /**
                             * ObjectAnnotation languageCode.
                             * @member {string} languageCode
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @instance
                             */
                            ObjectAnnotation.prototype.languageCode = "";
    
                            /**
                             * ObjectAnnotation name.
                             * @member {string} name
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @instance
                             */
                            ObjectAnnotation.prototype.name = "";
    
                            /**
                             * ObjectAnnotation score.
                             * @member {number} score
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @instance
                             */
                            ObjectAnnotation.prototype.score = 0;
    
                            /**
                             * Creates a new ObjectAnnotation instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation=} [properties] Properties to set
                             * @returns {google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation} ObjectAnnotation instance
                             */
                            ObjectAnnotation.create = function create(properties) {
                                return new ObjectAnnotation(properties);
                            };
    
                            /**
                             * Encodes the specified ObjectAnnotation message. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation} message ObjectAnnotation message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            ObjectAnnotation.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.mid != null && Object.hasOwnProperty.call(message, "mid"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.mid);
                                if (message.languageCode != null && Object.hasOwnProperty.call(message, "languageCode"))
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.languageCode);
                                if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.name);
                                if (message.score != null && Object.hasOwnProperty.call(message, "score"))
                                    writer.uint32(/* id 4, wireType 5 =*/37).float(message.score);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified ObjectAnnotation message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation} message ObjectAnnotation message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            ObjectAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an ObjectAnnotation message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation} ObjectAnnotation
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            ObjectAnnotation.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.mid = reader.string();
                                            break;
                                        }
                                    case 2: {
                                            message.languageCode = reader.string();
                                            break;
                                        }
                                    case 3: {
                                            message.name = reader.string();
                                            break;
                                        }
                                    case 4: {
                                            message.score = reader.float();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an ObjectAnnotation message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation} ObjectAnnotation
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            ObjectAnnotation.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an ObjectAnnotation message.
                             * @function verify
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            ObjectAnnotation.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.mid != null && message.hasOwnProperty("mid"))
                                    if (!$util.isString(message.mid))
                                        return "mid: string expected";
                                if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                                    if (!$util.isString(message.languageCode))
                                        return "languageCode: string expected";
                                if (message.name != null && message.hasOwnProperty("name"))
                                    if (!$util.isString(message.name))
                                        return "name: string expected";
                                if (message.score != null && message.hasOwnProperty("score"))
                                    if (typeof message.score !== "number")
                                        return "score: number expected";
                                return null;
                            };
    
                            /**
                             * Creates an ObjectAnnotation message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation} ObjectAnnotation
                             */
                            ObjectAnnotation.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation)
                                    return object;
                                var message = new $root.google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation();
                                if (object.mid != null)
                                    message.mid = String(object.mid);
                                if (object.languageCode != null)
                                    message.languageCode = String(object.languageCode);
                                if (object.name != null)
                                    message.name = String(object.name);
                                if (object.score != null)
                                    message.score = Number(object.score);
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an ObjectAnnotation message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation} message ObjectAnnotation
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            ObjectAnnotation.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.mid = "";
                                    object.languageCode = "";
                                    object.name = "";
                                    object.score = 0;
                                }
                                if (message.mid != null && message.hasOwnProperty("mid"))
                                    object.mid = message.mid;
                                if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                                    object.languageCode = message.languageCode;
                                if (message.name != null && message.hasOwnProperty("name"))
                                    object.name = message.name;
                                if (message.score != null && message.hasOwnProperty("score"))
                                    object.score = options.json && !isFinite(message.score) ? String(message.score) : message.score;
                                return object;
                            };
    
                            /**
                             * Converts this ObjectAnnotation to JSON.
                             * @function toJSON
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            ObjectAnnotation.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for ObjectAnnotation
                             * @function getTypeUrl
                             * @memberof google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            ObjectAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation";
                            };
    
                            return ObjectAnnotation;
                        })();
    
                        ProductSearchResults.GroupedResult = (function() {
    
                            /**
                             * Properties of a GroupedResult.
                             * @memberof google.cloud.vision.v1.ProductSearchResults
                             * @interface IGroupedResult
                             * @property {google.cloud.vision.v1.IBoundingPoly|null} [boundingPoly] GroupedResult boundingPoly
                             * @property {Array.<google.cloud.vision.v1.ProductSearchResults.IResult>|null} [results] GroupedResult results
                             * @property {Array.<google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation>|null} [objectAnnotations] GroupedResult objectAnnotations
                             */
    
                            /**
                             * Constructs a new GroupedResult.
                             * @memberof google.cloud.vision.v1.ProductSearchResults
                             * @classdesc Represents a GroupedResult.
                             * @implements IGroupedResult
                             * @constructor
                             * @param {google.cloud.vision.v1.ProductSearchResults.IGroupedResult=} [properties] Properties to set
                             */
                            function GroupedResult(properties) {
                                this.results = [];
                                this.objectAnnotations = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * GroupedResult boundingPoly.
                             * @member {google.cloud.vision.v1.IBoundingPoly|null|undefined} boundingPoly
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @instance
                             */
                            GroupedResult.prototype.boundingPoly = null;
    
                            /**
                             * GroupedResult results.
                             * @member {Array.<google.cloud.vision.v1.ProductSearchResults.IResult>} results
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @instance
                             */
                            GroupedResult.prototype.results = $util.emptyArray;
    
                            /**
                             * GroupedResult objectAnnotations.
                             * @member {Array.<google.cloud.vision.v1.ProductSearchResults.IObjectAnnotation>} objectAnnotations
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @instance
                             */
                            GroupedResult.prototype.objectAnnotations = $util.emptyArray;
    
                            /**
                             * Creates a new GroupedResult instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.IGroupedResult=} [properties] Properties to set
                             * @returns {google.cloud.vision.v1.ProductSearchResults.GroupedResult} GroupedResult instance
                             */
                            GroupedResult.create = function create(properties) {
                                return new GroupedResult(properties);
                            };
    
                            /**
                             * Encodes the specified GroupedResult message. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.GroupedResult.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.IGroupedResult} message GroupedResult message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            GroupedResult.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.boundingPoly != null && Object.hasOwnProperty.call(message, "boundingPoly"))
                                    $root.google.cloud.vision.v1.BoundingPoly.encode(message.boundingPoly, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                if (message.results != null && message.results.length)
                                    for (var i = 0; i < message.results.length; ++i)
                                        $root.google.cloud.vision.v1.ProductSearchResults.Result.encode(message.results[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                                if (message.objectAnnotations != null && message.objectAnnotations.length)
                                    for (var i = 0; i < message.objectAnnotations.length; ++i)
                                        $root.google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation.encode(message.objectAnnotations[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified GroupedResult message, length delimited. Does not implicitly {@link google.cloud.vision.v1.ProductSearchResults.GroupedResult.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.IGroupedResult} message GroupedResult message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            GroupedResult.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a GroupedResult message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.vision.v1.ProductSearchResults.GroupedResult} GroupedResult
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            GroupedResult.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.ProductSearchResults.GroupedResult();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.decode(reader, reader.uint32());
                                            break;
                                        }
                                    case 2: {
                                            if (!(message.results && message.results.length))
                                                message.results = [];
                                            message.results.push($root.google.cloud.vision.v1.ProductSearchResults.Result.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    case 3: {
                                            if (!(message.objectAnnotations && message.objectAnnotations.length))
                                                message.objectAnnotations = [];
                                            message.objectAnnotations.push($root.google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a GroupedResult message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.vision.v1.ProductSearchResults.GroupedResult} GroupedResult
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            GroupedResult.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a GroupedResult message.
                             * @function verify
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            GroupedResult.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly")) {
                                    var error = $root.google.cloud.vision.v1.BoundingPoly.verify(message.boundingPoly);
                                    if (error)
                                        return "boundingPoly." + error;
                                }
                                if (message.results != null && message.hasOwnProperty("results")) {
                                    if (!Array.isArray(message.results))
                                        return "results: array expected";
                                    for (var i = 0; i < message.results.length; ++i) {
                                        var error = $root.google.cloud.vision.v1.ProductSearchResults.Result.verify(message.results[i]);
                                        if (error)
                                            return "results." + error;
                                    }
                                }
                                if (message.objectAnnotations != null && message.hasOwnProperty("objectAnnotations")) {
                                    if (!Array.isArray(message.objectAnnotations))
                                        return "objectAnnotations: array expected";
                                    for (var i = 0; i < message.objectAnnotations.length; ++i) {
                                        var error = $root.google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation.verify(message.objectAnnotations[i]);
                                        if (error)
                                            return "objectAnnotations." + error;
                                    }
                                }
                                return null;
                            };
    
                            /**
                             * Creates a GroupedResult message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.vision.v1.ProductSearchResults.GroupedResult} GroupedResult
                             */
                            GroupedResult.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.vision.v1.ProductSearchResults.GroupedResult)
                                    return object;
                                var message = new $root.google.cloud.vision.v1.ProductSearchResults.GroupedResult();
                                if (object.boundingPoly != null) {
                                    if (typeof object.boundingPoly !== "object")
                                        throw TypeError(".google.cloud.vision.v1.ProductSearchResults.GroupedResult.boundingPoly: object expected");
                                    message.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.fromObject(object.boundingPoly);
                                }
                                if (object.results) {
                                    if (!Array.isArray(object.results))
                                        throw TypeError(".google.cloud.vision.v1.ProductSearchResults.GroupedResult.results: array expected");
                                    message.results = [];
                                    for (var i = 0; i < object.results.length; ++i) {
                                        if (typeof object.results[i] !== "object")
                                            throw TypeError(".google.cloud.vision.v1.ProductSearchResults.GroupedResult.results: object expected");
                                        message.results[i] = $root.google.cloud.vision.v1.ProductSearchResults.Result.fromObject(object.results[i]);
                                    }
                                }
                                if (object.objectAnnotations) {
                                    if (!Array.isArray(object.objectAnnotations))
                                        throw TypeError(".google.cloud.vision.v1.ProductSearchResults.GroupedResult.objectAnnotations: array expected");
                                    message.objectAnnotations = [];
                                    for (var i = 0; i < object.objectAnnotations.length; ++i) {
                                        if (typeof object.objectAnnotations[i] !== "object")
                                            throw TypeError(".google.cloud.vision.v1.ProductSearchResults.GroupedResult.objectAnnotations: object expected");
                                        message.objectAnnotations[i] = $root.google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation.fromObject(object.objectAnnotations[i]);
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a GroupedResult message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @static
                             * @param {google.cloud.vision.v1.ProductSearchResults.GroupedResult} message GroupedResult
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            GroupedResult.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults) {
                                    object.results = [];
                                    object.objectAnnotations = [];
                                }
                                if (options.defaults)
                                    object.boundingPoly = null;
                                if (message.boundingPoly != null && message.hasOwnProperty("boundingPoly"))
                                    object.boundingPoly = $root.google.cloud.vision.v1.BoundingPoly.toObject(message.boundingPoly, options);
                                if (message.results && message.results.length) {
                                    object.results = [];
                                    for (var j = 0; j < message.results.length; ++j)
                                        object.results[j] = $root.google.cloud.vision.v1.ProductSearchResults.Result.toObject(message.results[j], options);
                                }
                                if (message.objectAnnotations && message.objectAnnotations.length) {
                                    object.objectAnnotations = [];
                                    for (var j = 0; j < message.objectAnnotations.length; ++j)
                                        object.objectAnnotations[j] = $root.google.cloud.vision.v1.ProductSearchResults.ObjectAnnotation.toObject(message.objectAnnotations[j], options);
                                }
                                return object;
                            };
    
                            /**
                             * Converts this GroupedResult to JSON.
                             * @function toJSON
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            GroupedResult.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for GroupedResult
                             * @function getTypeUrl
                             * @memberof google.cloud.vision.v1.ProductSearchResults.GroupedResult
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            GroupedResult.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.vision.v1.ProductSearchResults.GroupedResult";
                            };
    
                            return GroupedResult;
                        })();
    
                        return ProductSearchResults;
                    })();
    
                    v1.ProductSearch = (function() {
    
                        /**
                         * Constructs a new ProductSearch service.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a ProductSearch
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function ProductSearch(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (ProductSearch.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = ProductSearch;
    
                        /**
                         * Creates new ProductSearch service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {ProductSearch} RPC service. Useful where requests and/or responses are streamed.
                         */
                        ProductSearch.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|createProductSet}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef CreateProductSetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.ProductSet} [response] ProductSet
                         */
    
                        /**
                         * Calls CreateProductSet.
                         * @function createProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.ICreateProductSetRequest} request CreateProductSetRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.CreateProductSetCallback} callback Node-style callback called with the error, if any, and ProductSet
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.createProductSet = function createProductSet(request, callback) {
                            return this.rpcCall(createProductSet, $root.google.cloud.vision.v1.CreateProductSetRequest, $root.google.cloud.vision.v1.ProductSet, request, callback);
                        }, "name", { value: "CreateProductSet" });
    
                        /**
                         * Calls CreateProductSet.
                         * @function createProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.ICreateProductSetRequest} request CreateProductSetRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.ProductSet>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|listProductSets}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef ListProductSetsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.ListProductSetsResponse} [response] ListProductSetsResponse
                         */
    
                        /**
                         * Calls ListProductSets.
                         * @function listProductSets
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IListProductSetsRequest} request ListProductSetsRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.ListProductSetsCallback} callback Node-style callback called with the error, if any, and ListProductSetsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.listProductSets = function listProductSets(request, callback) {
                            return this.rpcCall(listProductSets, $root.google.cloud.vision.v1.ListProductSetsRequest, $root.google.cloud.vision.v1.ListProductSetsResponse, request, callback);
                        }, "name", { value: "ListProductSets" });
    
                        /**
                         * Calls ListProductSets.
                         * @function listProductSets
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IListProductSetsRequest} request ListProductSetsRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.ListProductSetsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|getProductSet}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef GetProductSetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.ProductSet} [response] ProductSet
                         */
    
                        /**
                         * Calls GetProductSet.
                         * @function getProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IGetProductSetRequest} request GetProductSetRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.GetProductSetCallback} callback Node-style callback called with the error, if any, and ProductSet
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.getProductSet = function getProductSet(request, callback) {
                            return this.rpcCall(getProductSet, $root.google.cloud.vision.v1.GetProductSetRequest, $root.google.cloud.vision.v1.ProductSet, request, callback);
                        }, "name", { value: "GetProductSet" });
    
                        /**
                         * Calls GetProductSet.
                         * @function getProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IGetProductSetRequest} request GetProductSetRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.ProductSet>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|updateProductSet}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef UpdateProductSetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.ProductSet} [response] ProductSet
                         */
    
                        /**
                         * Calls UpdateProductSet.
                         * @function updateProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IUpdateProductSetRequest} request UpdateProductSetRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.UpdateProductSetCallback} callback Node-style callback called with the error, if any, and ProductSet
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.updateProductSet = function updateProductSet(request, callback) {
                            return this.rpcCall(updateProductSet, $root.google.cloud.vision.v1.UpdateProductSetRequest, $root.google.cloud.vision.v1.ProductSet, request, callback);
                        }, "name", { value: "UpdateProductSet" });
    
                        /**
                         * Calls UpdateProductSet.
                         * @function updateProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IUpdateProductSetRequest} request UpdateProductSetRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.ProductSet>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|deleteProductSet}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef DeleteProductSetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteProductSet.
                         * @function deleteProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IDeleteProductSetRequest} request DeleteProductSetRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.DeleteProductSetCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.deleteProductSet = function deleteProductSet(request, callback) {
                            return this.rpcCall(deleteProductSet, $root.google.cloud.vision.v1.DeleteProductSetRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteProductSet" });
    
                        /**
                         * Calls DeleteProductSet.
                         * @function deleteProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IDeleteProductSetRequest} request DeleteProductSetRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|createProduct}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef CreateProductCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.Product} [response] Product
                         */
    
                        /**
                         * Calls CreateProduct.
                         * @function createProduct
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.ICreateProductRequest} request CreateProductRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.CreateProductCallback} callback Node-style callback called with the error, if any, and Product
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.createProduct = function createProduct(request, callback) {
                            return this.rpcCall(createProduct, $root.google.cloud.vision.v1.CreateProductRequest, $root.google.cloud.vision.v1.Product, request, callback);
                        }, "name", { value: "CreateProduct" });
    
                        /**
                         * Calls CreateProduct.
                         * @function createProduct
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.ICreateProductRequest} request CreateProductRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.Product>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|listProducts}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef ListProductsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.ListProductsResponse} [response] ListProductsResponse
                         */
    
                        /**
                         * Calls ListProducts.
                         * @function listProducts
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IListProductsRequest} request ListProductsRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.ListProductsCallback} callback Node-style callback called with the error, if any, and ListProductsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.listProducts = function listProducts(request, callback) {
                            return this.rpcCall(listProducts, $root.google.cloud.vision.v1.ListProductsRequest, $root.google.cloud.vision.v1.ListProductsResponse, request, callback);
                        }, "name", { value: "ListProducts" });
    
                        /**
                         * Calls ListProducts.
                         * @function listProducts
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IListProductsRequest} request ListProductsRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.ListProductsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|getProduct}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef GetProductCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.Product} [response] Product
                         */
    
                        /**
                         * Calls GetProduct.
                         * @function getProduct
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IGetProductRequest} request GetProductRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.GetProductCallback} callback Node-style callback called with the error, if any, and Product
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.getProduct = function getProduct(request, callback) {
                            return this.rpcCall(getProduct, $root.google.cloud.vision.v1.GetProductRequest, $root.google.cloud.vision.v1.Product, request, callback);
                        }, "name", { value: "GetProduct" });
    
                        /**
                         * Calls GetProduct.
                         * @function getProduct
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IGetProductRequest} request GetProductRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.Product>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|updateProduct}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef UpdateProductCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.Product} [response] Product
                         */
    
                        /**
                         * Calls UpdateProduct.
                         * @function updateProduct
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IUpdateProductRequest} request UpdateProductRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.UpdateProductCallback} callback Node-style callback called with the error, if any, and Product
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.updateProduct = function updateProduct(request, callback) {
                            return this.rpcCall(updateProduct, $root.google.cloud.vision.v1.UpdateProductRequest, $root.google.cloud.vision.v1.Product, request, callback);
                        }, "name", { value: "UpdateProduct" });
    
                        /**
                         * Calls UpdateProduct.
                         * @function updateProduct
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IUpdateProductRequest} request UpdateProductRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.Product>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|deleteProduct}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef DeleteProductCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteProduct.
                         * @function deleteProduct
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IDeleteProductRequest} request DeleteProductRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.DeleteProductCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.deleteProduct = function deleteProduct(request, callback) {
                            return this.rpcCall(deleteProduct, $root.google.cloud.vision.v1.DeleteProductRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteProduct" });
    
                        /**
                         * Calls DeleteProduct.
                         * @function deleteProduct
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IDeleteProductRequest} request DeleteProductRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|createReferenceImage}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef CreateReferenceImageCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.ReferenceImage} [response] ReferenceImage
                         */
    
                        /**
                         * Calls CreateReferenceImage.
                         * @function createReferenceImage
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.ICreateReferenceImageRequest} request CreateReferenceImageRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.CreateReferenceImageCallback} callback Node-style callback called with the error, if any, and ReferenceImage
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.createReferenceImage = function createReferenceImage(request, callback) {
                            return this.rpcCall(createReferenceImage, $root.google.cloud.vision.v1.CreateReferenceImageRequest, $root.google.cloud.vision.v1.ReferenceImage, request, callback);
                        }, "name", { value: "CreateReferenceImage" });
    
                        /**
                         * Calls CreateReferenceImage.
                         * @function createReferenceImage
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.ICreateReferenceImageRequest} request CreateReferenceImageRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.ReferenceImage>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|deleteReferenceImage}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef DeleteReferenceImageCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteReferenceImage.
                         * @function deleteReferenceImage
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IDeleteReferenceImageRequest} request DeleteReferenceImageRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.DeleteReferenceImageCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.deleteReferenceImage = function deleteReferenceImage(request, callback) {
                            return this.rpcCall(deleteReferenceImage, $root.google.cloud.vision.v1.DeleteReferenceImageRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteReferenceImage" });
    
                        /**
                         * Calls DeleteReferenceImage.
                         * @function deleteReferenceImage
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IDeleteReferenceImageRequest} request DeleteReferenceImageRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|listReferenceImages}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef ListReferenceImagesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.ListReferenceImagesResponse} [response] ListReferenceImagesResponse
                         */
    
                        /**
                         * Calls ListReferenceImages.
                         * @function listReferenceImages
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IListReferenceImagesRequest} request ListReferenceImagesRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.ListReferenceImagesCallback} callback Node-style callback called with the error, if any, and ListReferenceImagesResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.listReferenceImages = function listReferenceImages(request, callback) {
                            return this.rpcCall(listReferenceImages, $root.google.cloud.vision.v1.ListReferenceImagesRequest, $root.google.cloud.vision.v1.ListReferenceImagesResponse, request, callback);
                        }, "name", { value: "ListReferenceImages" });
    
                        /**
                         * Calls ListReferenceImages.
                         * @function listReferenceImages
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IListReferenceImagesRequest} request ListReferenceImagesRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.ListReferenceImagesResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|getReferenceImage}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef GetReferenceImageCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.ReferenceImage} [response] ReferenceImage
                         */
    
                        /**
                         * Calls GetReferenceImage.
                         * @function getReferenceImage
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IGetReferenceImageRequest} request GetReferenceImageRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.GetReferenceImageCallback} callback Node-style callback called with the error, if any, and ReferenceImage
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.getReferenceImage = function getReferenceImage(request, callback) {
                            return this.rpcCall(getReferenceImage, $root.google.cloud.vision.v1.GetReferenceImageRequest, $root.google.cloud.vision.v1.ReferenceImage, request, callback);
                        }, "name", { value: "GetReferenceImage" });
    
                        /**
                         * Calls GetReferenceImage.
                         * @function getReferenceImage
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IGetReferenceImageRequest} request GetReferenceImageRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.ReferenceImage>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|addProductToProductSet}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef AddProductToProductSetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls AddProductToProductSet.
                         * @function addProductToProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IAddProductToProductSetRequest} request AddProductToProductSetRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.AddProductToProductSetCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.addProductToProductSet = function addProductToProductSet(request, callback) {
                            return this.rpcCall(addProductToProductSet, $root.google.cloud.vision.v1.AddProductToProductSetRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "AddProductToProductSet" });
    
                        /**
                         * Calls AddProductToProductSet.
                         * @function addProductToProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IAddProductToProductSetRequest} request AddProductToProductSetRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|removeProductFromProductSet}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef RemoveProductFromProductSetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls RemoveProductFromProductSet.
                         * @function removeProductFromProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IRemoveProductFromProductSetRequest} request RemoveProductFromProductSetRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.RemoveProductFromProductSetCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.removeProductFromProductSet = function removeProductFromProductSet(request, callback) {
                            return this.rpcCall(removeProductFromProductSet, $root.google.cloud.vision.v1.RemoveProductFromProductSetRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "RemoveProductFromProductSet" });
    
                        /**
                         * Calls RemoveProductFromProductSet.
                         * @function removeProductFromProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IRemoveProductFromProductSetRequest} request RemoveProductFromProductSetRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|listProductsInProductSet}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef ListProductsInProductSetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.vision.v1.ListProductsInProductSetResponse} [response] ListProductsInProductSetResponse
                         */
    
                        /**
                         * Calls ListProductsInProductSet.
                         * @function listProductsInProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IListProductsInProductSetRequest} request ListProductsInProductSetRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.ListProductsInProductSetCallback} callback Node-style callback called with the error, if any, and ListProductsInProductSetResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.listProductsInProductSet = function listProductsInProductSet(request, callback) {
                            return this.rpcCall(listProductsInProductSet, $root.google.cloud.vision.v1.ListProductsInProductSetRequest, $root.google.cloud.vision.v1.ListProductsInProductSetResponse, request, callback);
                        }, "name", { value: "ListProductsInProductSet" });
    
                        /**
                         * Calls ListProductsInProductSet.
                         * @function listProductsInProductSet
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IListProductsInProductSetRequest} request ListProductsInProductSetRequest message or plain object
                         * @returns {Promise<google.cloud.vision.v1.ListProductsInProductSetResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|importProductSets}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef ImportProductSetsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls ImportProductSets.
                         * @function importProductSets
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IImportProductSetsRequest} request ImportProductSetsRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.ImportProductSetsCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.importProductSets = function importProductSets(request, callback) {
                            return this.rpcCall(importProductSets, $root.google.cloud.vision.v1.ImportProductSetsRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "ImportProductSets" });
    
                        /**
                         * Calls ImportProductSets.
                         * @function importProductSets
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IImportProductSetsRequest} request ImportProductSetsRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.vision.v1.ProductSearch|purgeProducts}.
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @typedef PurgeProductsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls PurgeProducts.
                         * @function purgeProducts
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IPurgeProductsRequest} request PurgeProductsRequest message or plain object
                         * @param {google.cloud.vision.v1.ProductSearch.PurgeProductsCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ProductSearch.prototype.purgeProducts = function purgeProducts(request, callback) {
                            return this.rpcCall(purgeProducts, $root.google.cloud.vision.v1.PurgeProductsRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "PurgeProducts" });
    
                        /**
                         * Calls PurgeProducts.
                         * @function purgeProducts
                         * @memberof google.cloud.vision.v1.ProductSearch
                         * @instance
                         * @param {google.cloud.vision.v1.IPurgeProductsRequest} request PurgeProductsRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        return ProductSearch;
                    })();
    
                    v1.Product = (function() {
    
                        /**
                         * Properties of a Product.
                         * @memberof google.cloud.vision.v1
                         * @interface IProduct
                         * @property {string|null} [name] Product name
                         * @property {string|null} [displayName] Product displayName
                         * @property {string|null} [description] Product description
                         * @property {string|null} [productCategory] Product productCategory
                         * @property {Array.<google.cloud.vision.v1.Product.IKeyValue>|null} [productLabels] Product productLabels
                         */
    
                        /**
                         * Constructs a new Product.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a Product.
                         * @implements IProduct
                         * @constructor
                         * @param {google.cloud.vision.v1.IProduct=} [properties] Properties to set
                         */
                        function Product(properties) {
                            this.productLabels = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Product name.
                         * @member {string} name
                         * @memberof google.cloud.vision.v1.Product
                         * @instance
                         */
                        Product.prototype.name = "";
    
                        /**
                         * Product displayName.
                         * @member {string} displayName
                         * @memberof google.cloud.vision.v1.Product
                         * @instance
                         */
                        Product.prototype.displayName = "";
    
                        /**
                         * Product description.
                         * @member {string} description
                         * @memberof google.cloud.vision.v1.Product
                         * @instance
                         */
                        Product.prototype.description = "";
    
                        /**
                         * Product productCategory.
                         * @member {string} productCategory
                         * @memberof google.cloud.vision.v1.Product
                         * @instance
                         */
                        Product.prototype.productCategory = "";
    
                        /**
                         * Product productLabels.
                         * @member {Array.<google.cloud.vision.v1.Product.IKeyValue>} productLabels
                         * @memberof google.cloud.vision.v1.Product
                         * @instance
                         */
                        Product.prototype.productLabels = $util.emptyArray;
    
                        /**
                         * Creates a new Product instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.Product
                         * @static
                         * @param {google.cloud.vision.v1.IProduct=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.Product} Product instance
                         */
                        Product.create = function create(properties) {
                            return new Product(properties);
                        };
    
                        /**
                         * Encodes the specified Product message. Does not implicitly {@link google.cloud.vision.v1.Product.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.vision.v1.Product
                         * @static
                         * @param {google.cloud.vision.v1.IProduct} message Product message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Product.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.displayName);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.description);
                            if (message.productCategory != null && Object.hasOwnProperty.call(message, "productCategory"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.productCategory);
                            if (message.productLabels != null && message.productLabels.length)
                                for (var i = 0; i < message.productLabels.length; ++i)
                                    $root.google.cloud.vision.v1.Product.KeyValue.encode(message.productLabels[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Product message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Product.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.vision.v1.Product
                         * @static
                         * @param {google.cloud.vision.v1.IProduct} message Product message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Product.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Product message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.vision.v1.Product
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.vision.v1.Product} Product
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Product.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.Product();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.displayName = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.description = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.productCategory = reader.string();
                                        break;
                                    }
                                case 5: {
                                        if (!(message.productLabels && message.productLabels.length))
                                            message.productLabels = [];
                                        message.productLabels.push($root.google.cloud.vision.v1.Product.KeyValue.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Product message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.vision.v1.Product
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.vision.v1.Product} Product
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Product.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Product message.
                         * @function verify
                         * @memberof google.cloud.vision.v1.Product
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Product.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.productCategory != null && message.hasOwnProperty("productCategory"))
                                if (!$util.isString(message.productCategory))
                                    return "productCategory: string expected";
                            if (message.productLabels != null && message.hasOwnProperty("productLabels")) {
                                if (!Array.isArray(message.productLabels))
                                    return "productLabels: array expected";
                                for (var i = 0; i < message.productLabels.length; ++i) {
                                    var error = $root.google.cloud.vision.v1.Product.KeyValue.verify(message.productLabels[i]);
                                    if (error)
                                        return "productLabels." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Product message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.vision.v1.Product
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.vision.v1.Product} Product
                         */
                        Product.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.vision.v1.Product)
                                return object;
                            var message = new $root.google.cloud.vision.v1.Product();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.productCategory != null)
                                message.productCategory = String(object.productCategory);
                            if (object.productLabels) {
                                if (!Array.isArray(object.productLabels))
                                    throw TypeError(".google.cloud.vision.v1.Product.productLabels: array expected");
                                message.productLabels = [];
                                for (var i = 0; i < object.productLabels.length; ++i) {
                                    if (typeof object.productLabels[i] !== "object")
                                        throw TypeError(".google.cloud.vision.v1.Product.productLabels: object expected");
                                    message.productLabels[i] = $root.google.cloud.vision.v1.Product.KeyValue.fromObject(object.productLabels[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Product message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.vision.v1.Product
                         * @static
                         * @param {google.cloud.vision.v1.Product} message Product
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Product.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.productLabels = [];
                            if (options.defaults) {
                                object.name = "";
                                object.displayName = "";
                                object.description = "";
                                object.productCategory = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.productCategory != null && message.hasOwnProperty("productCategory"))
                                object.productCategory = message.productCategory;
                            if (message.productLabels && message.productLabels.length) {
                                object.productLabels = [];
                                for (var j = 0; j < message.productLabels.length; ++j)
                                    object.productLabels[j] = $root.google.cloud.vision.v1.Product.KeyValue.toObject(message.productLabels[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Product to JSON.
                         * @function toJSON
                         * @memberof google.cloud.vision.v1.Product
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Product.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Product
                         * @function getTypeUrl
                         * @memberof google.cloud.vision.v1.Product
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Product.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.cloud.vision.v1.Product";
                        };
    
                        Product.KeyValue = (function() {
    
                            /**
                             * Properties of a KeyValue.
                             * @memberof google.cloud.vision.v1.Product
                             * @interface IKeyValue
                             * @property {string|null} [key] KeyValue key
                             * @property {string|null} [value] KeyValue value
                             */
    
                            /**
                             * Constructs a new KeyValue.
                             * @memberof google.cloud.vision.v1.Product
                             * @classdesc Represents a KeyValue.
                             * @implements IKeyValue
                             * @constructor
                             * @param {google.cloud.vision.v1.Product.IKeyValue=} [properties] Properties to set
                             */
                            function KeyValue(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * KeyValue key.
                             * @member {string} key
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @instance
                             */
                            KeyValue.prototype.key = "";
    
                            /**
                             * KeyValue value.
                             * @member {string} value
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @instance
                             */
                            KeyValue.prototype.value = "";
    
                            /**
                             * Creates a new KeyValue instance using the specified properties.
                             * @function create
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @static
                             * @param {google.cloud.vision.v1.Product.IKeyValue=} [properties] Properties to set
                             * @returns {google.cloud.vision.v1.Product.KeyValue} KeyValue instance
                             */
                            KeyValue.create = function create(properties) {
                                return new KeyValue(properties);
                            };
    
                            /**
                             * Encodes the specified KeyValue message. Does not implicitly {@link google.cloud.vision.v1.Product.KeyValue.verify|verify} messages.
                             * @function encode
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @static
                             * @param {google.cloud.vision.v1.Product.IKeyValue} message KeyValue message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            KeyValue.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.key);
                                if (message.value != null && Object.hasOwnProperty.call(message, "value"))
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.value);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified KeyValue message, length delimited. Does not implicitly {@link google.cloud.vision.v1.Product.KeyValue.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @static
                             * @param {google.cloud.vision.v1.Product.IKeyValue} message KeyValue message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            KeyValue.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a KeyValue message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.cloud.vision.v1.Product.KeyValue} KeyValue
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            KeyValue.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.vision.v1.Product.KeyValue();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.key = reader.string();
                                            break;
                                        }
                                    case 2: {
                                            message.value = reader.string();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a KeyValue message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.cloud.vision.v1.Product.KeyValue} KeyValue
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            KeyValue.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a KeyValue message.
                             * @function verify
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            KeyValue.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.key != null && message.hasOwnProperty("key"))
                                    if (!$util.isString(message.key))
                                        return "key: string expected";
                                if (message.value != null && message.hasOwnProperty("value"))
                                    if (!$util.isString(message.value))
                                        return "value: string expected";
                                return null;
                            };
    
                            /**
                             * Creates a KeyValue message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.cloud.vision.v1.Product.KeyValue} KeyValue
                             */
                            KeyValue.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.cloud.vision.v1.Product.KeyValue)
                                    return object;
                                var message = new $root.google.cloud.vision.v1.Product.KeyValue();
                                if (object.key != null)
                                    message.key = String(object.key);
                                if (object.value != null)
                                    message.value = String(object.value);
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a KeyValue message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @static
                             * @param {google.cloud.vision.v1.Product.KeyValue} message KeyValue
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            KeyValue.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.key = "";
                                    object.value = "";
                                }
                                if (message.key != null && message.hasOwnProperty("key"))
                                    object.key = message.key;
                                if (message.value != null && message.hasOwnProperty("value"))
                                    object.value = message.value;
                                return object;
                            };
    
                            /**
                             * Converts this KeyValue to JSON.
                             * @function toJSON
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            KeyValue.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for KeyValue
                             * @function getTypeUrl
                             * @memberof google.cloud.vision.v1.Product.KeyValue
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            KeyValue.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.cloud.vision.v1.Product.KeyValue";
                            };
    
                            return KeyValue;
                        })();
    
                        return Product;
                    })();
    
                    v1.ProductSet = (function() {
    
                        /**
                         * Properties of a ProductSet.
                         * @memberof google.cloud.vision.v1
                         * @interface IProductSet
                         * @property {string|null} [name] ProductSet name
                         * @property {string|null} [displayName] ProductSet displayName
                         * @property {google.protobuf.ITimestamp|null} [indexTime] ProductSet indexTime
                         * @property {google.rpc.IStatus|null} [indexError] ProductSet indexError
                         */
    
                        /**
                         * Constructs a new ProductSet.
                         * @memberof google.cloud.vision.v1
                         * @classdesc Represents a ProductSet.
                         * @implements IProductSet
                         * @constructor
                         * @param {google.cloud.vision.v1.IProductSet=} [properties] Properties to set
                         */
                        function ProductSet(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ProductSet name.
                         * @member {string} name
                         * @memberof google.cloud.vision.v1.ProductSet
                         * @instance
                         */
                        ProductSet.prototype.name = "";
    
                        /**
                         * ProductSet displayName.
                         * @member {string} displayName
                         * @memberof google.cloud.vision.v1.ProductSet
                         * @instance
                         */
                        ProductSet.prototype.displayName = "";
    
                        /**
                         * ProductSet indexTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} indexTime
                         * @memberof google.cloud.vision.v1.ProductSet
                         * @instance
                         */
                        ProductSet.prototype.indexTime = null;
    
                        /**
                         * ProductSet indexError.
                         * @member {google.rpc.IStatus|null|undefined} indexError
                         * @memberof google.cloud.vision.v1.ProductSet
                         * @instance
                         */
                        ProductSet.prototype.indexError = null;
    
                        /**
                         * Creates a new ProductSet instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.vision.v1.ProductSet
                         * @static
                         * @param {google.cloud.vision.v1.IProductSet=} [properties] Properties to set
                         * @returns {google.cloud.vision.v1.ProductSet} ProductSet instance
       