import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from './modules/auth/auth.module';
import { KycModule } from './modules/kyc/kyc.module';
import { MarketplaceModule } from './modules/marketplace/marketplace.module';
import { LogisticaModule } from './modules/logistica/logistica.module';
import { PagamentosModule } from './modules/pagamentos/pagamentos.module';
import { ServicosModule } from './modules/servicos/servicos.module';

@Module({
  imports: [
    // Configuração de ambiente (.env)
    ConfigModule.forRoot({
      isGlobal: true,
    }),

    // PostgreSQL Connection
    TypeOrmModule.forRoot({
      type: 'postgres',
      host: process.env.DB_HOST || 'localhost',
      port: Number.parseInt(process.env.DB_PORT ?? '5432', 10),
      username: process.env.DB_USER || 'postgres',
      password: process.env.DB_PASSWORD || 'postgres',
      database: process.env.DB_NAME || 'tudoaqui',
      autoLoadEntities: true, // Auto-carregar entidades dos módulos TypeOrmModule.forFeature()
      synchronize: process.env.NODE_ENV !== 'production', // Apenas em dev
      logging: process.env.NODE_ENV === 'development',
    }),

    // 🚀 5 MÓDULOS PRINCIPAIS - TudoAqui Super App
    AuthModule,        // Módulo 1: Google Identity / Auth0 + JWT
    KycModule,         // Módulo 1: Amazon Rekognition / Google Vision AI
    MarketplaceModule, // Módulo 2: Imóveis, Automóveis (Marca d'água)
    LogisticaModule,   // Módulo 3: Tupuca Integration (GPS Tracking)
    PagamentosModule,  // Módulo 4: Multicaixa Express + GPO
    ServicosModule,    // Módulo 5: Turismo, Seguros, Reservas
  ],
})
export class AppModule {}
