import { NestFactory } from '@nestjs/core';
import { AppModule } from './app.module';
import { ValidationPipe } from '@nestjs/common';
import { AllExceptionsFilter } from './filters/all-exceptions.filter';

async function bootstrap() {
  const app = await NestFactory.create(AppModule);
  
  // Filtro global de exceções para debugging
  app.useGlobalFilters(new AllExceptionsFilter());
  
  // Habilitar CORS para o app Flutter e testes locais
  app.enableCors({
    origin: [
      'http://localhost',
      'http://localhost:3000',
      'http://127.0.0.1',
      'http://127.0.0.1:3000',
      'https://tudoaqui.ao'
    ],
    credentials: true,
  });

  // Validação automática de DTOs
  app.useGlobalPipes(new ValidationPipe({
    whitelist: true,
    forbidNonWhitelisted: true,
    transform: true,
  }));

  // Prefixo global para todas as rotas da API
  app.setGlobalPrefix('api/v1');

  const port = process.env.PORT || 3000;
  // Bind em 0.0.0.0 para aceitar conexões IPv4 e IPv6
  await app.listen(port, '0.0.0.0');
  
  console.log(`🚀 TudoAqui Backend rodando em http://localhost:${port}/api/v1`);
  console.log(`📱 Arquitetura: Microserviços NestJS + TypeScript`);
  console.log(`🔧 Exception Filter ativo para debugging detalhado`);
}

bootstrap();
