import { Entity, Column, PrimaryGeneratedColumn, CreateDateColumn, UpdateDateColumn } from 'typeorm';

@Entity('users')
export class User {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ unique: true })
  email: string;

  @Column()
  senha: string;

  @Column()
  nome: string;

  @Column({ unique: true })
  telefone: string;

  @Column({ type: 'enum', enum: ['vendedor', 'comprador'], default: 'comprador' })
  tipo: string;

  @Column({ default: false })
  seloVerificado: boolean;

  @Column({ type: 'enum', enum: ['pendente', 'aprovado', 'rejeitado'], default: 'pendente' })
  kycStatus: string;

  @Column({ nullable: true })
  biNumero: string;

  @Column({ nullable: true })
  fotoBI: string;

  @Column({ nullable: true })
  fotoSelfie: string;

  @Column({ nullable: true })
  alvaraUrl: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;
}
