import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { MulterModule } from '@nestjs/platform-express';
import { memoryStorage } from 'multer';
import { KycController } from './kyc.controller';
import { KycService } from './kyc.service';
import { User } from '../auth/entities/user.entity';

/**
 * Módulo KYC (Know Your Customer)
 * 
 * Responsável por:
 * - Upload e validação de Bilhete de Identidade (BI)
 * - Liveness Detection (selfie com detecção de pessoa viva)
 * - OCR de documentos angolanos com Amazon Rekognition / Google Vision AI
 * - Validação de Alvarás para contas Business
 * - Marca d'água automática em fotos de documentos
 */
@Module({
  imports: [
    TypeOrmModule.forFeature([User]),
    MulterModule.register({
      storage: memoryStorage(),
      limits: { fileSize: 5 * 1024 * 1024 }, // 5MB por segurança
    }),
  ],
  controllers: [KycController],
  providers: [KycService],
  exports: [KycService],
})
export class KycModule {}
