import { Controller, Post, Get, Body, Param, UseGuards, Request } from '@nestjs/common';
import { TupucaService } from './tupuca.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';

@Controller('logistica')
export class LogisticaController {
  constructor(private readonly tupucaService: TupucaService) {}

  /**
   * Calcular estimativa de entrega
   */
  @Post('estimativa')
  async calcularEstimativa(@Body() dados: any): Promise<any> {
    return this.tupucaService.calcularEstimativaEntrega(dados);
  }

  /**
   * Criar pedido de entrega (requer autenticação)
   */
  @Post('pedido')
  @UseGuards(JwtAuthGuard)
  async criarPedido(@Request() req: any, @Body() dados: any) {
    return this.tupucaService.criarPedidoEntrega(dados.pedidoId, dados.origem, dados.destino);
  }

  /**
   * Rastrear entrega em tempo real
   */
  @Get('rastrear/:trackingId')
  async rastrearEntrega(@Param('trackingId') trackingId: string) {
    return this.tupucaService.rastrearEntrega(trackingId);
  }
}
