import { IsString, IsNotEmpty, IsEnum, IsNumber, IsOptional, IsArray, IsBoolean, Min } from 'class-validator';
import { CategoriaAnuncio } from '../entities/anuncio.entity';
import { TipoImovel, TipoNegocio } from '../entities/detalhes-imovel.entity';
import { TipoVeiculo, TipoCombustivel, Transmissao } from '../entities/detalhes-veiculo.entity';

export class CriarAnuncioDto {
  @IsEnum(CategoriaAnuncio)
  categoria: CategoriaAnuncio;

  @IsString()
  @IsNotEmpty()
  titulo: string;

  @IsString()
  @IsNotEmpty()
  descricao: string;

  @IsNumber()
  @Min(0)
  preco: number;

  @IsString()
  @IsNotEmpty()
  provincia: string;

  @IsString()
  @IsNotEmpty()
  municipio: string;

  @IsString()
  @IsOptional()
  bairro?: string;

  @IsString()
  @IsOptional()
  endereco?: string;

  @IsNumber()
  @IsOptional()
  latitude?: number;

  @IsNumber()
  @IsOptional()
  longitude?: number;

  // Detalhes de Imóvel (opcional se categoria = IMOVEIS)
  @IsEnum(TipoImovel)
  @IsOptional()
  tipoImovel?: TipoImovel;

  @IsEnum(TipoNegocio)
  @IsOptional()
  tipoNegocio?: TipoNegocio;

  @IsNumber()
  @IsOptional()
  quartos?: number;

  @IsNumber()
  @IsOptional()
  banheiros?: number;

  @IsNumber()
  @IsOptional()
  garagem?: number;

  @IsNumber()
  @IsOptional()
  area?: number;

  @IsBoolean()
  @IsOptional()
  mobilado?: boolean;

  @IsBoolean()
  @IsOptional()
  piscina?: boolean;

  // Detalhes de Veículo (opcional se categoria = VEICULOS)
  @IsEnum(TipoVeiculo)
  @IsOptional()
  tipoVeiculo?: TipoVeiculo;

  @IsString()
  @IsOptional()
  marca?: string;

  @IsString()
  @IsOptional()
  modelo?: string;

  @IsNumber()
  @IsOptional()
  ano?: number;

  @IsEnum(TipoCombustivel)
  @IsOptional()
  combustivel?: TipoCombustivel;

  @IsEnum(Transmissao)
  @IsOptional()
  transmissao?: Transmissao;

  @IsNumber()
  @IsOptional()
  quilometragem?: number;

  @IsString()
  @IsOptional()
  cor?: string;
}

export class FiltrosAnuncioDto {
  @IsEnum(CategoriaAnuncio)
  @IsOptional()
  categoria?: CategoriaAnuncio;

  @IsString()
  @IsOptional()
  provincia?: string;

  @IsString()
  @IsOptional()
  municipio?: string;

  @IsNumber()
  @IsOptional()
  precoMin?: number;

  @IsNumber()
  @IsOptional()
  precoMax?: number;

  @IsNumber()
  @IsOptional()
  latitude?: number; // Para filtro "perto de mim"

  @IsNumber()
  @IsOptional()
  longitude?: number;

  @IsNumber()
  @IsOptional()
  raioKm?: number; // Raio de busca em km

  @IsString()
  @IsOptional()
  busca?: string; // Texto livre para busca
}
