import { Entity, Column, PrimaryGeneratedColumn, CreateDateColumn, UpdateDateColumn, ManyToOne, JoinColumn, Point } from 'typeorm';
import { User } from '../../auth/entities/user.entity';

export enum CategoriaAnuncio {
  IMOVEIS = 'imoveis',
  VEICULOS = 'veiculos',
  TURISMO = 'turismo',
  SERVICOS = 'servicos',
}

export enum StatusAnuncio {
  PENDENTE = 'pendente',
  ATIVO = 'ativo',
  VENDIDO = 'vendido',
  REMOVIDO = 'removido',
}

@Entity('anuncios')
export class Anuncio {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @ManyToOne(() => User)
  @JoinColumn({ name: 'vendedor_id' })
  vendedor: User;

  @Column()
  vendedorId: string;

  @Column({ type: 'enum', enum: CategoriaAnuncio })
  categoria: CategoriaAnuncio;

  @Column()
  titulo: string;

  @Column('text')
  descricao: string;

  @Column('decimal', { precision: 12, scale: 2 })
  preco: number;

  @Column({ nullable: true })
  provincia: string;

  @Column({ nullable: true })
  municipio: string;

  @Column({ nullable: true })
  bairro: string;

  @Column({ nullable: true })
  endereco: string;

  // Localização GPS para filtros "perto de mim"
  @Column({
    type: 'geography',
    spatialFeatureType: 'Point',
    srid: 4326,
    nullable: true,
  })
  localizacao: Point;

  @Column('simple-array', { nullable: true })
  fotos: string[]; // URLs com marca d'água

  @Column('simple-array', { nullable: true })
  fotosOriginais: string[]; // Backup sem marca d'água (uso interno)

  @Column({ type: 'enum', enum: StatusAnuncio, default: StatusAnuncio.PENDENTE })
  status: StatusAnuncio;

  @Column({ default: 0 })
  visualizacoes: number;

  @Column({ default: false })
  destaque: boolean; // Anúncios pagos aparecem no topo

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;
}
