import { Entity, Column, PrimaryGeneratedColumn, OneToOne, JoinColumn } from 'typeorm';
import { Anuncio } from './anuncio.entity';

export enum TipoImovel {
  APARTAMENTO = 'apartamento',
  CASA = 'casa',
  TERRENO = 'terreno',
  VIVENDA = 'vivenda',
  ESCRITORIO = 'escritorio',
  ARMAZEM = 'armazem',
}

export enum TipoNegocio {
  VENDA = 'venda',
  ARRENDAMENTO = 'arrendamento',
}

@Entity('detalhes_imoveis')
export class DetalhesImovel {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @OneToOne(() => Anuncio, { onDelete: 'CASCADE' })
  @JoinColumn({ name: 'anuncio_id' })
  anuncio: Anuncio;

  @Column()
  anuncioId: string;

  @Column({ type: 'enum', enum: TipoImovel })
  tipo: TipoImovel;

  @Column({ type: 'enum', enum: TipoNegocio })
  tipoNegocio: TipoNegocio;

  @Column({ nullable: true })
  quartos: number;

  @Column({ nullable: true })
  banheiros: number;

  @Column({ nullable: true })
  garagem: number;

  @Column('decimal', { precision: 10, scale: 2, nullable: true })
  area: number; // Área em m²

  @Column({ default: false })
  mobilado: boolean;

  @Column({ default: false })
  piscina: boolean;

  @Column({ default: false })
  quintal: boolean;

  @Column({ default: false })
  seguranca24h: boolean;

  @Column('text', { nullable: true })
  amenidades: string; // JSON com outras amenidades
}
