import { Entity, Column, PrimaryGeneratedColumn, OneToOne, JoinColumn } from 'typeorm';
import { Anuncio } from './anuncio.entity';

export enum TipoVeiculo {
  CARRO = 'carro',
  MOTO = 'moto',
  CAMINHAO = 'caminhao',
  ONIBUS = 'onibus',
}

export enum TipoCombustivel {
  GASOLINA = 'gasolina',
  DIESEL = 'diesel',
  ELETRICO = 'eletrico',
  HIBRIDO = 'hibrido',
}

export enum Transmissao {
  MANUAL = 'manual',
  AUTOMATICA = 'automatica',
}

@Entity('detalhes_veiculos')
export class DetalhesVeiculo {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @OneToOne(() => Anuncio, { onDelete: 'CASCADE' })
  @JoinColumn({ name: 'anuncio_id' })
  anuncio: Anuncio;

  @Column()
  anuncioId: string;

  @Column({ type: 'enum', enum: TipoVeiculo })
  tipo: TipoVeiculo;

  @Column()
  marca: string; // Toyota, Mercedes, etc.

  @Column()
  modelo: string; // Corolla, C-Class, etc.

  @Column()
  ano: number;

  @Column({ type: 'enum', enum: TipoCombustivel })
  combustivel: TipoCombustivel;

  @Column({ type: 'enum', enum: Transmissao })
  transmissao: Transmissao;

  @Column({ nullable: true })
  quilometragem: number;

  @Column({ nullable: true })
  cor: string;

  @Column({ nullable: true })
  portas: number;

  @Column({ default: false })
  arcondicionado: boolean;

  @Column({ default: false })
  direcaoHidraulica: boolean;

  @Column({ default: false })
  vidrosEletricos: boolean;

  @Column({ default: false })
  alarme: boolean;

  @Column({ nullable: true })
  numeroChaveta: string; // Chapa angolana

  @Column('text', { nullable: true })
  caracteristicas: string; // JSON com outras features
}
