import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { MarketplaceController } from './marketplace.controller';
import { MarketplaceService } from './marketplace.service';
import { Anuncio } from './entities/anuncio.entity';
import { DetalhesImovel } from './entities/detalhes-imovel.entity';
import { DetalhesVeiculo } from './entities/detalhes-veiculo.entity';
import { AuthModule } from '../auth/auth.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([Anuncio, DetalhesImovel, DetalhesVeiculo]),
    AuthModule,
  ],
  controllers: [MarketplaceController],
  providers: [MarketplaceService],
  exports: [MarketplaceService],
})
export class MarketplaceModule {}
