import { Controller, Post, Get, Body, Param, UseGuards, Request } from '@nestjs/common';
import { PagamentosService } from './pagamentos.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';

@Controller('pagamentos')
export class PagamentosController {
  constructor(private readonly pagamentosService: PagamentosService) {}

  /**
   * Iniciar pagamento (requer autenticação)
   */
  @Post('iniciar')
  @UseGuards(JwtAuthGuard)
  async iniciarPagamento(@Request() req: any, @Body() dados: any) {
    return this.pagamentosService.iniciarPagamento(dados);
  }

  /**
   * Verificar status de pagamento
   */
  @Get('status/:transacaoId')
  @UseGuards(JwtAuthGuard)
  async verificarStatus(@Param('transacaoId') transacaoId: string): Promise<any> {
    return this.pagamentosService.verificarStatusPagamento(transacaoId);
  }

  /**
   * Webhook Multicaixa/GPO (sem autenticação - valida assinatura internamente)
   */
  @Post('webhook')
  async webhook(@Body() payload: any) {
    return this.pagamentosService.processarWebhookPagamento(payload);
  }

  /**
   * Calcular taxa da plataforma
   */
  @Get('taxa/:valor')
  async calcularTaxa(@Param('valor') valor: number) {
    const taxa = this.pagamentosService.calcularTaxaPlataforma(valor);
    return {
      valorOriginal: valor,
      taxa,
      valorComTaxa: valor + taxa,
    };
  }
}
