import { IsEnum, IsString, IsNotEmpty, IsNumber, IsOptional, IsDate, Min } from 'class-validator';
import { Type } from 'class-transformer';
import { TipoServico } from '../entities/reserva.entity';
import { TipoSeguro } from '../entities/cotacao-seguro.entity';

export class CriarReservaDto {
  @IsEnum(TipoServico)
  tipoServico: TipoServico;

  @IsString()
  @IsNotEmpty()
  servicoNome: string;

  @IsDate()
  @Type(() => Date)
  dataReserva: Date;

  @IsString()
  @IsOptional()
  horario?: string;

  @IsNumber()
  @Min(1)
  numeroPessoas: number;

  @IsString()
  @IsOptional()
  observacoes?: string;

  @IsOptional()
  detalhesAdicionais?: any;
}

export class CotacaoSeguroDto {
  @IsEnum(TipoSeguro)
  tipo: TipoSeguro;

  @IsString()
  @IsNotEmpty()
  nomeCompleto: string;

  @IsString()
  @IsNotEmpty()
  telefone: string;

  @IsString()
  @IsNotEmpty()
  email: string;

  // Campos opcionais para seguro automóvel
  @IsString()
  @IsOptional()
  veiculoMarca?: string;

  @IsString()
  @IsOptional()
  veiculoModelo?: string;

  @IsNumber()
  @IsOptional()
  veiculoAno?: number;

  @IsString()
  @IsOptional()
  veiculoChaveta?: string;
}
