import {
  Entity,
  Column,
  PrimaryGeneratedColumn,
  CreateDateColumn,
} from "typeorm";

export enum TipoSeguro {
  AUTOMOVEL = "automovel",
  RESIDENCIAL = "residencial",
  VIDA = "vida",
}

export enum StatusCotacao {
  PENDENTE = "pendente",
  APROVADA = "aprovada",
  REJEITADA = "rejeitada",
  CONTRATADA = "contratada",
}

@Entity("cotacoes_seguro")
export class CotacaoSeguro {
  @PrimaryGeneratedColumn("uuid")
  id: string;

  @Column()
  userId: string;

  @Column({ type: "enum", enum: TipoSeguro })
  tipo: TipoSeguro;

  // Dados do veículo (se automovel)
  @Column({ nullable: true })
  veiculoMarca: string;

  @Column({ nullable: true })
  veiculoModelo: string;

  @Column({ nullable: true })
  veiculoAno: number;

  @Column({ nullable: true })
  veiculoChaveta: string;

  // Dados do segurado
  @Column()
  nomeCompleto: string;

  @Column()
  telefone: string;

  @Column()
  email: string;

  // Resultado da cotação
  @Column("decimal", { precision: 10, scale: 2, nullable: true })
  valorMensal: number;

  @Column("decimal", { precision: 10, scale: 2, nullable: true })
  valorAnual: number;

  @Column({ nullable: true })
  seguradoraParceira: string;

  @Column({
    type: "enum",
    enum: StatusCotacao,
    default: StatusCotacao.PENDENTE,
  })
  status: StatusCotacao;

  @CreateDateColumn()
  createdAt: Date;
}
