import {
  Entity,
  Column,
  PrimaryGeneratedColumn,
  CreateDateColumn,
  ManyToOne,
  JoinColumn,
} from "typeorm";
import { User } from "../../auth/entities/user.entity";

export enum TipoServico {
  RESTAURANTE = "restaurante",
  GUIA_TURISTICO = "guia_turistico",
  HOTEL = "hotel",
  TRANSPORTE = "transporte",
  SEGUROS = "seguros",
  OUTROS = "outros",
}

export enum StatusReserva {
  PENDENTE = "pendente",
  CONFIRMADA = "confirmada",
  CANCELADA = "cancelada",
  CONCLUIDA = "concluida",
}

@Entity("reservas")
export class Reserva {
  @PrimaryGeneratedColumn("uuid")
  id: string;

  @ManyToOne(() => User)
  @JoinColumn({ name: "cliente_id" })
  cliente: User;

  @Column()
  clienteId: string;

  @Column({ type: "enum", enum: TipoServico })
  tipoServico: TipoServico;

  @Column()
  servicoNome: string; // Nome do restaurante/hotel/guia

  @Column("timestamp")
  dataReserva: Date;

  @Column({ nullable: true })
  horario: string;

  @Column({ type: "int", default: 1 })
  numeroPessoas: number;

  @Column("text", { nullable: true })
  observacoes: string;

  @Column("decimal", { precision: 10, scale: 2, nullable: true })
  valorTotal: number;

  @Column({
    type: "enum",
    enum: StatusReserva,
    default: StatusReserva.PENDENTE,
  })
  status: StatusReserva;

  @Column("simple-json", { nullable: true })
  detalhesAdicionais: any; // JSON com dados específicos por tipo

  @CreateDateColumn()
  createdAt: Date;
}
