import {
  Controller,
  Post,
  Get,
  Body,
  Param,
  Query,
  UseGuards,
  Request,
} from "@nestjs/common";
import { ServicosService } from "./servicos.service";
import { JwtAuthGuard } from "../auth/guards/jwt-auth.guard";
import { CriarReservaDto, CotacaoSeguroDto } from "./dto/servicos.dto";

@Controller("servicos")
export class ServicosController {
  constructor(private readonly servicosService: ServicosService) {}

  /**
   * Criar reserva (restaurante, hotel, guia turístico)
   */
  @Post("reservas")
  @UseGuards(JwtAuthGuard)
  async criarReserva(@Request() req: any, @Body() dto: CriarReservaDto) {
    return this.servicosService.criarReserva(req.user.userId, dto);
  }

  /**
   * Listar reservas do utilizador
   */
  @Get("reservas")
  @UseGuards(JwtAuthGuard)
  async listarReservas(@Request() req: any) {
    return this.servicosService.listarReservasUtilizador(req.user.userId);
  }

  /**
   * Solicitar cotação de seguro
   */
  @Post("seguros/cotacao")
  @UseGuards(JwtAuthGuard)
  async solicitarCotacao(@Request() req: any, @Body() dto: CotacaoSeguroDto) {
    return this.servicosService.solicitarCotacaoSeguro(req.user.userId, dto);
  }

  /**
   * Obter detalhes de cotação
   */
  @Get("seguros/cotacao/:id")
  @UseGuards(JwtAuthGuard)
  async obterCotacao(@Request() req: any, @Param("id") id: string) {
    return this.servicosService.obterCotacao(id, req.user.userId);
  }
}
