import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ServicosController } from './servicos.controller';
import { ServicosService } from './servicos.service';
import { Reserva } from './entities/reserva.entity';
import { CotacaoSeguro } from './entities/cotacao-seguro.entity';
import { AuthModule } from '../auth/auth.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([Reserva, CotacaoSeguro]),
    AuthModule,
  ],
  controllers: [ServicosController],
  providers: [ServicosService],
  exports: [ServicosService],
})
export class ServicosModule {}
