# Outputs da infraestrutura AWS

output "ec2_instance_id" {
  description = "ID da instância EC2"
  value       = aws_instance.app.id
}

output "ec2_public_ip" {
  description = "IP público da instância EC2"
  value       = aws_eip.app.public_ip
}

output "ec2_private_ip" {
  description = "IP privado da instância EC2"
  value       = aws_instance.app.private_ip
}

output "ec2_instance_profile_name" {
  description = "Nome do instance profile"
  value       = aws_iam_instance_profile.app.name
}

output "rds_endpoint" {
  description = "Endpoint do banco de dados RDS"
  value       = aws_db_instance.main.endpoint
  sensitive   = true
}

output "rds_address" {
  description = "Endereço do RDS (sem porta)"
  value       = aws_db_instance.main.address
  sensitive   = true
}

output "rds_port" {
  description = "Porta do RDS"
  value       = aws_db_instance.main.port
}

output "rds_database_name" {
  description = "Nome do banco de dados"
  value       = aws_db_instance.main.db_name
}

output "redis_endpoint" {
  description = "Endpoint do Redis ElastiCache"
  value       = aws_elasticache_cluster.redis.cache_nodes[0].address
  sensitive   = true
}

output "redis_port" {
  description = "Porta do Redis"
  value       = aws_elasticache_cluster.redis.port
}

output "s3_bucket_name" {
  description = "Nome do bucket S3"
  value       = aws_s3_bucket.uploads.id
}

output "s3_bucket_region" {
  description = "Região do bucket S3"
  value       = aws_s3_bucket.uploads.region
}

output "cloudfront_domain_name" {
  description = "Domain name do CloudFront"
  value       = aws_cloudfront_distribution.cdn.domain_name
}

output "cloudfront_distribution_id" {
  description = "ID da distribuição CloudFront"
  value       = aws_cloudfront_distribution.cdn.id
}

output "vpc_id" {
  description = "ID da VPC"
  value       = aws_vpc.main.id
}

output "security_group_app_id" {
  description = "ID do security group da aplicação"
  value       = aws_security_group.app.id
}

output "connection_string" {
  description = "String de conexão do banco de dados"
  value       = "postgresql://${var.db_username}@${aws_db_instance.main.address}:5432/${aws_db_instance.main.db_name}"
  sensitive   = true
}

output "deployment_summary" {
  description = "Resumo do deployment"
  value = <<-EOT
    🎉 Deploy AWS Completo!
    
    🖥️  EC2 Instance:
        - IP Público: ${aws_eip.app.public_ip}
        - Tipo: ${var.instance_type}
        - SSH: ssh -i ~/.ssh/id_rsa ubuntu@${aws_eip.app.public_ip}
    
    🗄️  RDS PostgreSQL:
        - Endpoint: ${aws_db_instance.main.address}
        - Database: ${aws_db_instance.main.db_name}
        - User: ${var.db_username}
    
    📦 Redis ElastiCache:
        - Endpoint: ${aws_elasticache_cluster.redis.cache_nodes[0].address}:${aws_elasticache_cluster.redis.port}
    
    🗂️  S3 Bucket:
        - Bucket: ${aws_s3_bucket.uploads.id}
        - CDN: https://${aws_cloudfront_distribution.cdn.domain_name}
    
    📝 Próximos passos:
        1. Conectar via SSH e esperar cloud-init finalizar (~5 min)
        2. Configurar domínio DNS em Route 53
        3. Gerar certificado SSL com certbot
        4. Acessar API em https://seu-dominio.ao
  EOT
}
