# Variáveis de configuração AWS

variable "aws_region" {
  description = "Região AWS"
  type        = string
  default     = "us-east-1"
}

variable "environment" {
  description = "Ambiente (dev, staging, prod)"
  type        = string
  default     = "prod"
}

variable "app_name" {
  description = "Nome da aplicação"
  type        = string
  default     = "tudoaqui"
}

variable "instance_type" {
  description = "Tipo de instância EC2"
  type        = string
  default     = "t3.medium"  # 2 vCPU, 4GB RAM - $0.0416/hora
}

variable "db_instance_class" {
  description = "Classe de instância RDS"
  type        = string
  default     = "db.t3.micro"  # Free tier
}

variable "db_username" {
  description = "Username do banco de dados"
  type        = string
  default     = "postgres"
  sensitive   = true
}

variable "db_password" {
  description = "Password do banco de dados"
  type        = string
  sensitive   = true
}

variable "jwt_secret" {
  description = "JWT Secret para autenticação"
  type        = string
  sensitive   = true
}

variable "aws_s3_bucket_prefix" {
  description = "Prefixo do bucket S3"
  type        = string
  default     = "tudoaqui-uploads"
}

variable "enable_backups" {
  description = "Ativar backups automáticos"
  type        = bool
  default     = true
}

variable "backup_retention_days" {
  description = "Dias de retenção de backups"
  type        = number
  default     = 30
}

variable "tags" {
  description = "Tags comuns para todos os recursos"
  type        = map(string)
  default = {
    Environment = "production"
    Project     = "TudoAqui"
    ManagedBy   = "Terraform"
    CreatedAt   = "2026-01-22"
  }
}
