import 'package:flutter/material.dart';
import 'screens/home_marketplace.dart';
import 'screens/auth/login_screen.dart';
import 'screens/auth/registro_screen.dart';
import 'verificacao_documentos.dart';
import 'utils/constants.dart';

void main() {
  runApp(TudoAquiApp());
}

class TudoAquiApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'TudoAqui - Encontre tudo num só lugar',
      debugShowCheckedModeBanner: false,
      initialRoute: '/login',
      theme: ThemeData(
        primaryColor: AppColors.primary,
        colorScheme: ColorScheme.fromSeed(
          seedColor: AppColors.primary,
          primary: AppColors.primary,
        ),
        fontFamily: 'Roboto',
        scaffoldBackgroundColor: AppColors.background,
        appBarTheme: AppBarTheme(
          backgroundColor: AppColors.primary,
          foregroundColor: Colors.white,
          elevation: 0,
        ),
      ),
      // Iniciar na Login (fluxo de autenticação)
      home: LoginScreen(),
      
      routes: {
        '/login': (context) => LoginScreen(),
        '/registar': (context) => RegistroScreen(),
        '/verificacao': (context) => VerificacaoDocumentos(),
        '/home': (context) => HomeMarketplace(),
      },
    );
  }
}
