import 'package:flutter/material.dart';
import '../utils/constants.dart';

class HomeMarketplace extends StatefulWidget {
  @override
  _HomeMarketplaceState createState() => _HomeMarketplaceState();
}

class _HomeMarketplaceState extends State<HomeMarketplace> {
  int _selectedIndex = 0;
  String _nomeUtilizador = "João Silva"; // Virá da sessão/auth
  bool _seloVerificado = true;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.background,
      body: SafeArea(
        child: Column(
          children: [
            _buildHeader(),
            Expanded(
              child: SingleChildScrollView(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    _buildBarraPesquisa(),
                    SizedBox(height: 20),
                    _buildCategoriasGrid(),
                    SizedBox(height: 20),
                    _buildCardIntegracao(),
                    SizedBox(height: 20),
                    _buildFeedPertoTi(),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
      bottomNavigationBar: _buildBarraNavegacao(),
    );
  }

  // A. Cabeçalho (Header)
  Widget _buildHeader() {
    return Container(
      padding: EdgeInsets.all(AppDimensions.paddingScreen),
      color: Colors.white,
      child: Row(
        children: [
          Expanded(
            child: Text(
              "Olá, $_nomeUtilizador! 👋",
              style: AppTextStyles.heading2,
            ),
          ),
          // Ícone de Notificações
          Stack(
            children: [
              IconButton(
                icon: Icon(Icons.notifications_outlined, size: 28),
                onPressed: () {
                  // Navegar para notificações
                },
              ),
              Positioned(
                right: 8,
                top: 8,
                child: Container(
                  width: 10,
                  height: 10,
                  decoration: BoxDecoration(
                    color: Colors.red,
                    shape: BoxShape.circle,
                  ),
                ),
              ),
            ],
          ),
          SizedBox(width: 8),
          // Foto de Perfil com Selo Verificado
          Stack(
            children: [
              CircleAvatar(
                radius: 22,
                backgroundColor: AppColors.primary,
                child: Text(
                  _nomeUtilizador[0].toUpperCase(),
                  style: TextStyle(color: Colors.white, fontSize: 20),
                ),
              ),
              if (_seloVerificado)
                Positioned(
                  right: 0,
                  bottom: 0,
                  child: Container(
                    width: 16,
                    height: 16,
                    decoration: BoxDecoration(
                      color: AppColors.success,
                      shape: BoxShape.circle,
                      border: Border.all(color: Colors.white, width: 2),
                    ),
                    child: Icon(
                      Icons.check,
                      size: 10,
                      color: Colors.white,
                    ),
                  ),
                ),
            ],
          ),
        ],
      ),
    );
  }

  // Barra de Pesquisa
  Widget _buildBarraPesquisa() {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: AppDimensions.paddingScreen),
      child: Container(
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(AppDimensions.borderRadiusMedium),
          boxShadow: [
            BoxShadow(
              color: Colors.black12,
              blurRadius: 8,
              offset: Offset(0, 2),
            ),
          ],
        ),
        child: TextField(
          decoration: InputDecoration(
            hintText: "O que procuras hoje em Angola?",
            hintStyle: AppTextStyles.caption,
            prefixIcon: Icon(Icons.search, color: AppColors.primary),
            border: InputBorder.none,
            contentPadding: EdgeInsets.symmetric(horizontal: 20, vertical: 15),
          ),
        ),
      ),
    );
  }

  // B. Seção de Categorias (Grelha de Ícones)
  Widget _buildCategoriasGrid() {
    final categorias = [
      {'icon': Icons.home, 'label': 'Imóveis', 'color': Colors.blue},
      {'icon': Icons.directions_car, 'label': 'Automóveis', 'color': Colors.red},
      {'icon': Icons.terrain, 'label': 'Terrenos', 'color': Colors.green},
      {'icon': Icons.restaurant, 'label': 'Restaurantes', 'color': Colors.orange},
      {'icon': Icons.beach_access, 'label': 'Turismo', 'color': Colors.teal},
      {'icon': Icons.local_taxi, 'label': 'Táxi', 'color': Colors.yellow[700]!},
      {'icon': Icons.security, 'label': 'Seguros', 'color': Colors.purple},
      {'icon': Icons.more_horiz, 'label': 'Mais', 'color': Colors.grey},
    ];

    return Padding(
      padding: EdgeInsets.symmetric(horizontal: AppDimensions.paddingScreen),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text("Categorias", style: AppTextStyles.heading2),
          SizedBox(height: 15),
          GridView.builder(
            shrinkWrap: true,
            physics: NeverScrollableScrollPhysics(),
            gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
              crossAxisCount: 4,
              crossAxisSpacing: 15,
              mainAxisSpacing: 15,
              childAspectRatio: 0.85,
            ),
            itemCount: categorias.length,
            itemBuilder: (context, index) {
              final categoria = categorias[index];
              return GestureDetector(
                onTap: () {
                  // Navegar para a categoria específica
                  print("Categoria selecionada: ${categoria['label']}");
                },
                child: Column(
                  children: [
                    Container(
                      width: 60,
                      height: 60,
                      decoration: BoxDecoration(
                        color: (categoria['color'] as Color).withOpacity(0.1),
                        borderRadius: BorderRadius.circular(15),
                      ),
                      child: Icon(
                        categoria['icon'] as IconData,
                        size: 32,
                        color: categoria['color'] as Color,
                      ),
                    ),
                    SizedBox(height: 8),
                    Text(
                      categoria['label'] as String,
                      style: AppTextStyles.caption.copyWith(fontSize: 12),
                      textAlign: TextAlign.center,
                    ),
                  ],
                ),
              );
            },
          ),
        ],
      ),
    );
  }

  // C. Card de Integração Logística (Destaque)
  Widget _buildCardIntegracao() {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: AppDimensions.paddingScreen),
      child: Container(
        padding: EdgeInsets.all(20),
        decoration: BoxDecoration(
          gradient: LinearGradient(
            colors: [AppColors.primary, Color(0xFF0066FF)],
            begin: Alignment.topLeft,
            end: Alignment.bottomRight,
          ),
          borderRadius: BorderRadius.circular(AppDimensions.borderRadiusLarge),
          boxShadow: [
            BoxShadow(
              color: AppColors.primary.withOpacity(0.3),
              blurRadius: 12,
              offset: Offset(0, 4),
            ),
          ],
        ),
        child: Row(
          children: [
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    "Precisa entregar algo?",
                    style: TextStyle(
                      color: Colors.white,
                      fontSize: 16,
                      fontWeight: FontWeight.bold,
                    ),
                  ),
                  SizedBox(height: 5),
                  Text(
                    "Peça agora via Tupuca no TudoAqui",
                    style: TextStyle(
                      color: Colors.white70,
                      fontSize: 13,
                    ),
                  ),
                ],
              ),
            ),
            ElevatedButton(
              style: ElevatedButton.styleFrom(
                backgroundColor: Colors.white,
                foregroundColor: AppColors.primary,
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(8),
                ),
              ),
              onPressed: () {
                // Integração Tupuca
              },
              child: Text("Chamar Entrega"),
            ),
          ],
        ),
      ),
    );
  }

  // D. Feed "Perto de Ti" (Cards Verticais)
  Widget _buildFeedPertoTi() {
    // Dados simulados - virão da API
    final anuncios = [
      {
        'foto': 'https://via.placeholder.com/300x200',
        'titulo': 'Toyota Hilux 2022',
        'preco': '35.000.000',
        'verificado': true,
        'localizacao': 'Talatona, Luanda',
      },
      {
        'foto': 'https://via.placeholder.com/300x200',
        'titulo': 'Apartamento T3 Kilamba',
        'preco': '18.500.000',
        'verificado': true,
        'localizacao': 'Kilamba, Luanda',
      },
      {
        'foto': 'https://via.placeholder.com/300x200',
        'titulo': 'Terreno 500m² Viana',
        'preco': '8.200.000',
        'verificado': false,
        'localizacao': 'Viana, Luanda',
      },
    ];

    return Padding(
      padding: EdgeInsets.symmetric(horizontal: AppDimensions.paddingScreen),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Text("Perto de Ti 📍", style: AppTextStyles.heading2),
              TextButton(
                onPressed: () {},
                child: Text("Ver Tudo", style: TextStyle(color: AppColors.primary)),
              ),
            ],
          ),
          SizedBox(height: 10),
          ListView.builder(
            shrinkWrap: true,
            physics: NeverScrollableScrollPhysics(),
            itemCount: anuncios.length,
            itemBuilder: (context, index) {
              final anuncio = anuncios[index];
              return _buildCardAnuncio(anuncio);
            },
          ),
        ],
      ),
    );
  }

  Widget _buildCardAnuncio(Map<String, dynamic> anuncio) {
    return Container(
      margin: EdgeInsets.only(bottom: 15),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(AppDimensions.borderRadiusLarge),
        boxShadow: [
          BoxShadow(
            color: Colors.black12,
            blurRadius: 8,
            offset: Offset(0, 2),
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          // Foto do Item
          Stack(
            children: [
              ClipRRect(
                borderRadius: BorderRadius.vertical(
                  top: Radius.circular(AppDimensions.borderRadiusLarge),
                ),
                child: Image.network(
                  anuncio['foto'],
                  height: 180,
                  width: double.infinity,
                  fit: BoxFit.cover,
                  errorBuilder: (context, error, stackTrace) {
                    return Container(
                      height: 180,
                      color: Colors.grey[300],
                      child: Icon(Icons.image, size: 50, color: Colors.grey),
                    );
                  },
                ),
              ),
              // Selo de Verificado
              if (anuncio['verificado'])
                Positioned(
                  top: 10,
                  right: 10,
                  child: Container(
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                    decoration: BoxDecoration(
                      color: AppColors.success,
                      borderRadius: BorderRadius.circular(20),
                    ),
                    child: Row(
                      mainAxisSize: MainAxisSize.min,
                      children: [
                        Icon(Icons.verified, color: Colors.white, size: 14),
                        SizedBox(width: 4),
                        Text(
                          "Verificado",
                          style: TextStyle(
                            color: Colors.white,
                            fontSize: 11,
                            fontWeight: FontWeight.bold,
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
            ],
          ),
          // Informações
          Padding(
            padding: EdgeInsets.all(15),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  anuncio['titulo'],
                  style: TextStyle(
                    fontSize: 16,
                    fontWeight: FontWeight.bold,
                  ),
                ),
                SizedBox(height: 5),
                Text(
                  "${anuncio['preco']} Kz",
                  style: TextStyle(
                    fontSize: 18,
                    fontWeight: FontWeight.bold,
                    color: AppColors.primary,
                  ),
                ),
                SizedBox(height: 5),
                Row(
                  children: [
                    Icon(Icons.location_on, size: 14, color: Colors.grey),
                    SizedBox(width: 4),
                    Text(
                      anuncio['localizacao'],
                      style: AppTextStyles.caption,
                    ),
                  ],
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }

  // E. Barra de Navegação Inferior (Sticky Menu)
  Widget _buildBarraNavegacao() {
    return BottomNavigationBar(
      currentIndex: _selectedIndex,
      onTap: (index) {
        setState(() {
          _selectedIndex = index;
        });
      },
      type: BottomNavigationBarType.fixed,
      selectedItemColor: AppColors.primary,
      unselectedItemColor: Colors.grey,
      items: [
        BottomNavigationBarItem(
          icon: Icon(Icons.home),
          label: 'Home',
        ),
        BottomNavigationBarItem(
          icon: Icon(Icons.favorite_border),
          label: 'Favoritos',
        ),
        BottomNavigationBarItem(
          icon: Container(
            padding: EdgeInsets.all(12),
            decoration: BoxDecoration(
              color: AppColors.primary,
              shape: BoxShape.circle,
            ),
            child: Icon(Icons.add, color: Colors.white),
          ),
          label: 'Anunciar',
        ),
        BottomNavigationBarItem(
          icon: Icon(Icons.chat_bubble_outline),
          label: 'Mensagens',
        ),
        BottomNavigationBarItem(
          icon: Icon(Icons.menu),
          label: 'Menu',
        ),
      ],
    );
  }
}
