import 'dart:convert';
import 'package:http/http.dart' as http;
import 'package:image_picker/image_picker.dart';
import '../utils/constants.dart';

class KycService {
  final http.Client _client;

  KycService({http.Client? client}) : _client = client ?? http.Client();

  Future<void> uploadDocumento({required XFile ficheiro, required String endpoint, String userId = 'demo-user'}) async {
    final uri = Uri.parse('${ApiEndpoints.baseUrl}$endpoint');
    final bytes = await ficheiro.readAsBytes();
    final request = http.MultipartRequest('POST', uri)
      ..fields['userId'] = userId
      ..files.add(http.MultipartFile.fromBytes('file', bytes, filename: ficheiro.name));

    final response = await http.Response.fromStream(await request.send());
    if (response.statusCode >= 300) {
      throw Exception('Upload falhou (${response.statusCode}): ${response.body}');
    }
  }

  Future<String> obterStatus({String userId = 'demo-user'}) async {
    final uri = Uri.parse('${ApiEndpoints.baseUrl}${ApiEndpoints.kycStatus}?userId=$userId');
    final response = await _client.get(uri);
    if (response.statusCode >= 300) {
      throw Exception('Erro ao obter status (${response.statusCode})');
    }
    final data = jsonDecode(response.body) as Map<String, dynamic>;
    return (data['status'] ?? 'pendente').toString();
  }

  void dispose() {
    _client.close();
  }
}
