import 'package:flutter/material.dart';

// Cores da Marca TudoAqui
class AppColors {
  static const Color primary = Color(0xFF0052CC); // Azul Cobalto para confiança
  static const Color success = Colors.green;
  static const Color warning = Colors.orange;
  static const Color danger = Colors.red;
  static const Color background = Color(0xFFF5F5F5);
  static const Color textDark = Color(0xFF333333);
  static const Color textLight = Color(0xFF666666);
}

// Dimensões Padrão
class AppDimensions {
  static const double paddingScreen = 20.0;
  static const double borderRadiusLarge = 15.0;
  static const double borderRadiusMedium = 10.0;
  static const double buttonHeight = 55.0;
  static const double iconSizeLarge = 50.0;
  static const double iconSizeMedium = 32.0;
}

// Estilos de Texto
class AppTextStyles {
  static const TextStyle heading1 = TextStyle(
    fontSize: 24,
    fontWeight: FontWeight.bold,
    color: AppColors.textDark,
  );
  
  static const TextStyle heading2 = TextStyle(
    fontSize: 20,
    fontWeight: FontWeight.bold,
    color: AppColors.textDark,
  );
  
  static const TextStyle body = TextStyle(
    fontSize: 16,
    color: AppColors.textLight,
  );
  
  static const TextStyle caption = TextStyle(
    fontSize: 14,
    color: AppColors.textLight,
  );
}

// API Endpoints
class ApiEndpoints {
  static const String baseUrl = 'http://localhost:3000'; // Dev
  static const String prodUrl = 'https://api.tudoaqui.ao'; // Produção
  
  // KYC & Auth
  static const String register = '/auth/register';
  static const String login = '/auth/login';
  static const String uploadBI = '/kyc/upload-bi';
  static const String uploadSelfie = '/kyc/upload-selfie';
  static const String uploadAlvara = '/kyc/upload-alvara';
  static const String kycStatus = '/kyc/status';
  
  // Marketplace
  static const String anuncios = '/anuncios';
  static const String anunciosPertoMim = '/anuncios/perto-de-mim';
  
  // Integrações
  static const String tupucaEntrega = '/logistica/tupuca/solicitar';
  static const String chamarTaxi = '/mobilidade/chamar-taxi';
  static const String multicaixaPagamento = '/pagamentos/multicaixa';
}

// Categorias do Marketplace
class Categorias {
  static const String imoveis = 'imoveis';
  static const String automoveis = 'automoveis';
  static const String terrenos = 'terrenos';
  static const String restaurantes = 'restaurantes';
  static const String turismo = 'turismo';
  static const String taxis = 'taxis';
  static const String seguros = 'seguros';
}
