@echo off
REM Script para verificar ambiente Flutter e instalar dependências
REM TudoAqui - KYC Verification Setup

echo.
echo ========================================
echo  TudoAqui - Flutter Dependencies Setup
echo ========================================
echo.

REM Verificar se Flutter está instalado
where flutter >nul 2>&1
if %errorlevel% neq 0 (
    echo ❌ Flutter não foi encontrado no PATH
    echo.
    echo Instruções:
    echo 1. Descarregar Flutter: https://flutter.dev/docs/get-started/install
    echo 2. Adicionar ao PATH: C:\flutter\bin
    echo 3. Executar: flutter doctor
    echo 4. Depois executar este script novamente
    pause
    exit /b 1
)

echo ✓ Flutter encontrado
flutter --version
echo.

REM Verificar se está na pasta certa
if not exist pubspec.yaml (
    echo ❌ Erro: pubspec.yaml não encontrado
    echo Por favor executar este script na raiz do projeto TudoAqui
    pause
    exit /b 1
)

echo.
echo ⏳ A instalar dependências (image_picker, google_ml_kit, http)...
echo.

flutter pub get

if %errorlevel% neq 0 (
    echo ❌ Erro ao instalar dependências
    pause
    exit /b 1
)

echo.
echo ✅ Dependências instaladas com sucesso!
echo.
echo Próximos passos:
echo.
echo 1. Android:
echo    - Abrir: android/app/src/main/AndroidManifest.xml
echo    - Verificar permissões (CAMERA, READ_EXTERNAL_STORAGE, etc.)
echo.
echo 2. iOS:
echo    - Abrir: ios/Runner/Info.plist
echo    - Verificar NSCameraUsageDescription, etc.
echo.
echo 3. Testar:
echo    - flutter run -d chrome    (Web)
echo    - flutter run              (Android/iOS emulator)
echo.
pause
