const http = require('http');

console.log('🔍 A testar conexão ao backend...\n');

const options = {
  hostname: 'localhost',
  port: 3000,
  path: '/api/v1/auth/register',
  method: 'POST',
  headers: {
    'Content-Type': 'application/json'
  }
};

console.log('Host:', options.hostname);
console.log('Porta:', options.port);
console.log('Path:', options.path);
console.log('URL completa:', `http://${options.hostname}:${options.port}${options.path}\n`);

const req = http.request(options, (res) => {
  console.log('✅ CONEXÃO ESTABELECIDA!');
  console.log('Status HTTP:', res.statusCode);
  console.log('Headers:', res.headers);
  
  let data = '';
  res.on('data', (chunk) => data += chunk);
  res.on('end', () => {
    console.log('\nResposta do servidor:');
    console.log(data);
  });
});

req.on('error', (err) => {
  console.error('❌ ERRO DE CONEXÃO!');
  console.error('Código:', err.code);
  console.error('Mensagem:', err.message);
  console.error('Endereço:', err.address);
  console.error('Porta:', err.port);
  
  if (err.code === 'ECONNREFUSED') {
    console.error('\n⚠️  O backend não está a responder no porto 3000');
    console.error('Possíveis causas:');
    console.error('1. Backend não foi iniciado');
    console.error('2. Backend iniciou mas fechou imediatamente');
    console.error('3. Backend está a rodar noutro porto');
    console.error('4. Firewall está a bloquear a conexão');
  }
});

const body = JSON.stringify({
  email: 'teste@tudoaqui.ao',
  senha: 'senha123',
  nome: 'Teste User',
  telefone: '+244923456789',
  tipo: 'vendedor'
});

req.write(body);
req.end();
