@echo off
chcp 65001 >nul
setlocal enabledelayedexpansion

echo ============================================================
echo 🧪 TESTES KYC COMPLETOS - TudoAqui Backend
echo ============================================================
echo.

REM 1. REGISTAR UTILIZADOR
echo [1/4] 📝 REGISTANDO UTILIZADOR...
echo.

powershell -NoProfile -Command ^
"$body = @{email='teste.kyc@tudoaqui.ao';senha='Senha123!';nome='Teste KYC';telefone='+244923456789';tipo='vendedor'} | ConvertTo-Json; ^
$response = Invoke-RestMethod -Uri 'http://localhost:3000/api/v1/auth/register' -Method POST -ContentType 'application/json' -Body $body; ^
Write-Host '✅ Utilizador criado!' -ForegroundColor Green; ^
Write-Host 'User ID:' $response.id; ^
Write-Host 'Token:' $response.access_token.Substring(0,50)'...'; ^
$response | ConvertTo-Json; ^
$global:userId = $response.id; ^
$global:token = $response.access_token; ^
Set-Content -Path '%TEMP%\kyc_userid.txt' -Value $response.id; ^
Set-Content -Path '%TEMP%\kyc_token.txt' -Value $response.access_token"

if errorlevel 1 (
    echo ❌ Erro ao registar utilizador
    exit /b 1
)

echo.
echo ============================================================
echo.

REM 2. STATUS INICIAL
echo [2/4] 📊 VERIFICANDO STATUS INICIAL...
echo.

set /p USER_ID=<%TEMP%\kyc_userid.txt
set /p TOKEN=<%TEMP%\kyc_token.txt

powershell -NoProfile -Command ^
"$headers = @{Authorization='Bearer %TOKEN%'}; ^
$response = Invoke-RestMethod -Uri 'http://localhost:3000/api/v1/kyc/status/%USER_ID%' -Method GET -Headers $headers; ^
Write-Host '📊 STATUS KYC:' -ForegroundColor Cyan; ^
Write-Host '  kycStatus:' $response.kycStatus; ^
Write-Host '  seloVerificado:' $response.seloVerificado; ^
Write-Host '  biNumero:' $response.biNumero"

echo.
echo ============================================================
echo.

REM 3. CRIAR IMAGEM TESTE E UPLOAD BI
echo [3/4] 📸 UPLOAD BI COM WATERMARK...
echo.

powershell -NoProfile -Command ^
"Add-Type -AssemblyName System.Drawing; ^
$bmp = New-Object System.Drawing.Bitmap(400, 250); ^
$graphics = [System.Drawing.Graphics]::FromImage($bmp); ^
$graphics.Clear([System.Drawing.Color]::LightBlue); ^
$font = New-Object System.Drawing.Font('Arial', 20); ^
$brush = [System.Drawing.Brushes]::Black; ^
$graphics.DrawString('BI TESTE - 123456789', $font, $brush, 50, 100); ^
$graphics.Dispose(); ^
$tempFile = [System.IO.Path]::GetTempFileName() + '.png'; ^
$bmp.Save($tempFile, [System.Drawing.Imaging.ImageFormat]::Png); ^
$bmp.Dispose(); ^
Write-Host 'Imagem criada:' $tempFile; ^
$boundary = [System.Guid]::NewGuid().ToString(); ^
$headers = @{Authorization='Bearer %TOKEN%'; 'Content-Type'='multipart/form-data; boundary=' + $boundary}; ^
$fileBytes = [System.IO.File]::ReadAllBytes($tempFile); ^
$fileContent = [System.Text.Encoding]::GetEncoding('iso-8859-1').GetString($fileBytes); ^
$body = '--' + $boundary + \"`r`n\" + 'Content-Disposition: form-data; name=\"file\"; filename=\"test_bi.png\"' + \"`r`n\" + 'Content-Type: image/png' + \"`r`n`r`n\" + $fileContent + \"`r`n\" + '--' + $boundary + '--' + \"`r`n\"; ^
$bodyBytes = [System.Text.Encoding]::GetEncoding('iso-8859-1').GetBytes($body); ^
$response = Invoke-RestMethod -Uri 'http://localhost:3000/api/v1/kyc/upload-bi' -Method POST -Headers $headers -Body $bodyBytes; ^
Write-Host '✅ BI enviado!' -ForegroundColor Green; ^
$response | ConvertTo-Json"

echo.
echo ============================================================
echo.

REM 4. UPLOAD SELFIE
echo [4/4] 🤳 UPLOAD SELFIE PARA LIVENESS...
echo.

powershell -NoProfile -Command ^
"Add-Type -AssemblyName System.Drawing; ^
$bmp = New-Object System.Drawing.Bitmap(300, 300); ^
$graphics = [System.Drawing.Graphics]::FromImage($bmp); ^
$graphics.Clear([System.Drawing.Color]::Beige); ^
$pen = New-Object System.Drawing.Pen([System.Drawing.Color]::Black, 3); ^
$graphics.DrawEllipse($pen, 50, 50, 200, 200); ^
$graphics.DrawEllipse($pen, 100, 100, 30, 30); ^
$graphics.DrawEllipse($pen, 170, 100, 30, 30); ^
$graphics.DrawArc($pen, 80, 120, 140, 100, 0, 180); ^
$graphics.Dispose(); ^
$pen.Dispose(); ^
$tempFile = [System.IO.Path]::GetTempFileName() + '.png'; ^
$bmp.Save($tempFile, [System.Drawing.Imaging.ImageFormat]::Png); ^
$bmp.Dispose(); ^
Write-Host 'Selfie criada:' $tempFile; ^
$boundary = [System.Guid]::NewGuid().ToString(); ^
$headers = @{Authorization='Bearer %TOKEN%'; 'Content-Type'='multipart/form-data; boundary=' + $boundary}; ^
$fileBytes = [System.IO.File]::ReadAllBytes($tempFile); ^
$fileContent = [System.Text.Encoding]::GetEncoding('iso-8859-1').GetString($fileBytes); ^
$body = '--' + $boundary + \"`r`n\" + 'Content-Disposition: form-data; name=\"file\"; filename=\"test_selfie.png\"' + \"`r`n\" + 'Content-Type: image/png' + \"`r`n`r`n\" + $fileContent + \"`r`n\" + '--' + $boundary + '--' + \"`r`n\"; ^
$bodyBytes = [System.Text.Encoding]::GetEncoding('iso-8859-1').GetBytes($body); ^
$response = Invoke-RestMethod -Uri 'http://localhost:3000/api/v1/kyc/upload-selfie' -Method POST -Headers $headers -Body $bodyBytes; ^
Write-Host '✅ Selfie enviada!' -ForegroundColor Green; ^
$response | ConvertTo-Json"

echo.
echo ============================================================
echo.
echo ✅ TESTES CONCLUÍDOS COM SUCESSO!
echo.
echo Próximo: Execute 'POST /api/v1/kyc/analyze' com userId para validar Rekognition
echo.

del %TEMP%\kyc_userid.txt 2>nul
del %TEMP%\kyc_token.txt 2>nul

endlocal
