# Testes KYC Completos - TudoAqui Backend
Write-Host "============================================================" -ForegroundColor Cyan
Write-Host "🧪 TESTES KYC COMPLETOS - TudoAqui Backend" -ForegroundColor Yellow
Write-Host "============================================================" -ForegroundColor Cyan
Write-Host ""

# 1. REGISTAR UTILIZADOR
Write-Host "[1/4] 📝 REGISTANDO UTILIZADOR..." -ForegroundColor Yellow
Write-Host ""

try {
    $registerBody = @{
        email = 'teste.kyc@tudoaqui.ao'
        senha = 'Senha123!'
        nome = 'Teste KYC'
        telefone = '+244923456789'
        tipo = 'vendedor'
    } | ConvertTo-Json

    $registerResponse = Invoke-RestMethod `
        -Uri 'http://localhost:3000/api/v1/auth/register' `
        -Method POST `
        -ContentType 'application/json' `
        -Body $registerBody

    Write-Host "✅ Utilizador criado!" -ForegroundColor Green
    Write-Host "User ID: $($registerResponse.id)"
    Write-Host "Email: $($registerResponse.email)"
    Write-Host "Tipo: $($registerResponse.tipo)"
    Write-Host "Token: $($registerResponse.access_token.Substring(0,50))..."
    Write-Host ""

    $userId = $registerResponse.id
    $token = $registerResponse.access_token

} catch {
    Write-Host "❌ Erro ao registar: $($_.Exception.Message)" -ForegroundColor Red
    exit 1
}

Write-Host "============================================================" -ForegroundColor Cyan
Write-Host ""

# 2. STATUS INICIAL
Write-Host "[2/4] 📊 VERIFICANDO STATUS INICIAL..." -ForegroundColor Yellow
Write-Host ""

try {
    $headers = @{
        Authorization = "Bearer $token"
    }

    $statusResponse = Invoke-RestMethod `
        -Uri "http://localhost:3000/api/v1/kyc/status/$userId" `
        -Method GET `
        -Headers $headers

    Write-Host "📊 STATUS KYC:" -ForegroundColor Cyan
    Write-Host "  kycStatus: $($statusResponse.kycStatus)"
    Write-Host "  seloVerificado: $($statusResponse.seloVerificado)"
    Write-Host "  biNumero: $($statusResponse.biNumero)"
    Write-Host ""

} catch {
    Write-Host "❌ Erro ao verificar status: $($_.Exception.Message)" -ForegroundColor Red
}

Write-Host "============================================================" -ForegroundColor Cyan
Write-Host ""

# 3. UPLOAD BI
Write-Host "[3/4] 📸 UPLOAD BI COM WATERMARK..." -ForegroundColor Yellow
Write-Host ""

try {
    # Criar imagem de teste
    Add-Type -AssemblyName System.Drawing
    $bmp = New-Object System.Drawing.Bitmap(400, 250)
    $graphics = [System.Drawing.Graphics]::FromImage($bmp)
    $graphics.Clear([System.Drawing.Color]::LightBlue)
    $font = New-Object System.Drawing.Font('Arial', 18)
    $brush = [System.Drawing.Brushes]::Black
    $graphics.DrawString('BI TESTE - 123456789', $font, $brush, 50, 100)
    $graphics.Dispose()
    
    $tempFile = [System.IO.Path]::Combine([System.IO.Path]::GetTempPath(), "test_bi_$(Get-Date -Format 'yyyyMMddHHmmss').png")
    $bmp.Save($tempFile, [System.Drawing.Imaging.ImageFormat]::Png)
    $bmp.Dispose()
    
    Write-Host "Imagem criada: $tempFile" -ForegroundColor Gray

    # Upload multipart
    $boundary = [System.Guid]::NewGuid().ToString()
    $LF = "`r`n"
    
    $fileBytes = [System.IO.File]::ReadAllBytes($tempFile)
    $fileContent = [System.Text.Encoding]::GetEncoding('iso-8859-1').GetString($fileBytes)
    
    $bodyLines = (
        "--$boundary",
        "Content-Disposition: form-data; name=`"file`"; filename=`"test_bi.png`"",
        "Content-Type: image/png$LF",
        $fileContent,
        "--$boundary--$LF"
    ) -join $LF
    
    $bodyBytes = [System.Text.Encoding]::GetEncoding('iso-8859-1').GetBytes($bodyLines)
    
    $uploadHeaders = @{
        Authorization = "Bearer $token"
        'Content-Type' = "multipart/form-data; boundary=$boundary"
    }
    
    $biResponse = Invoke-RestMethod `
        -Uri 'http://localhost:3000/api/v1/kyc/upload-bi' `
        -Method POST `
        -Headers $uploadHeaders `
        -Body $bodyBytes
    
    Write-Host "✅ BI enviado com sucesso!" -ForegroundColor Green
    Write-Host "Resposta: $($biResponse.message)"
    Write-Host ""

    # Limpar arquivo temporário
    Remove-Item $tempFile -ErrorAction SilentlyContinue

} catch {
    Write-Host "❌ Erro no upload BI: $($_.Exception.Message)" -ForegroundColor Red
    Write-Host "Detalhes: $($_.ErrorDetails.Message)" -ForegroundColor Red
}

Write-Host "============================================================" -ForegroundColor Cyan
Write-Host ""

# 4. UPLOAD SELFIE
Write-Host "[4/4] 🤳 UPLOAD SELFIE PARA LIVENESS..." -ForegroundColor Yellow
Write-Host ""

try {
    # Criar selfie de teste (emoji simples)
    Add-Type -AssemblyName System.Drawing
    $bmp = New-Object System.Drawing.Bitmap(300, 300)
    $graphics = [System.Drawing.Graphics]::FromImage($bmp)
    $graphics.Clear([System.Drawing.Color]::Beige)
    
    $pen = New-Object System.Drawing.Pen([System.Drawing.Color]::Black, 3)
    # Rosto
    $graphics.DrawEllipse($pen, 50, 50, 200, 200)
    # Olhos
    $graphics.DrawEllipse($pen, 100, 100, 30, 30)
    $graphics.DrawEllipse($pen, 170, 100, 30, 30)
    # Boca sorridente
    $graphics.DrawArc($pen, 80, 120, 140, 100, 0, 180)
    
    $graphics.Dispose()
    $pen.Dispose()
    
    $tempFile = [System.IO.Path]::Combine([System.IO.Path]::GetTempPath(), "test_selfie_$(Get-Date -Format 'yyyyMMddHHmmss').png")
    $bmp.Save($tempFile, [System.Drawing.Imaging.ImageFormat]::Png)
    $bmp.Dispose()
    
    Write-Host "Selfie criada: $tempFile" -ForegroundColor Gray

    # Upload multipart
    $boundary = [System.Guid]::NewGuid().ToString()
    $LF = "`r`n"
    
    $fileBytes = [System.IO.File]::ReadAllBytes($tempFile)
    $fileContent = [System.Text.Encoding]::GetEncoding('iso-8859-1').GetString($fileBytes)
    
    $bodyLines = (
        "--$boundary",
        "Content-Disposition: form-data; name=`"file`"; filename=`"test_selfie.png`"",
        "Content-Type: image/png$LF",
        $fileContent,
        "--$boundary--$LF"
    ) -join $LF
    
    $bodyBytes = [System.Text.Encoding]::GetEncoding('iso-8859-1').GetBytes($bodyLines)
    
    $uploadHeaders = @{
        Authorization = "Bearer $token"
        'Content-Type' = "multipart/form-data; boundary=$boundary"
    }
    
    $selfieResponse = Invoke-RestMethod `
        -Uri 'http://localhost:3000/api/v1/kyc/upload-selfie' `
        -Method POST `
        -Headers $uploadHeaders `
        -Body $bodyBytes
    
    Write-Host "✅ Selfie enviada com sucesso!" -ForegroundColor Green
    Write-Host "Resposta: $($selfieResponse.message)"
    Write-Host ""

    # Limpar arquivo temporário
    Remove-Item $tempFile -ErrorAction SilentlyContinue

} catch {
    Write-Host "❌ Erro no upload Selfie: $($_.Exception.Message)" -ForegroundColor Red
    Write-Host "Detalhes: $($_.ErrorDetails.Message)" -ForegroundColor Red
}

Write-Host "============================================================" -ForegroundColor Cyan
Write-Host ""
Write-Host "✅ TESTES 1-4 CONCLUÍDOS!" -ForegroundColor Green
Write-Host ""
Write-Host "📝 Resumo:" -ForegroundColor Cyan
Write-Host "  1. ✅ Utilizador registado (ID: $userId)"
Write-Host "  2. ✅ Status KYC verificado"
Write-Host "  3. ✅ BI com watermark enviado"
Write-Host "  4. ✅ Selfie para liveness enviada"
Write-Host ""
Write-Host "🔬 Próximo passo: Analisar com Rekognition" -ForegroundColor Yellow
Write-Host "   POST /api/v1/kyc/analyze {userId: '$userId'}"
Write-Host ""
