Write-Host "============================================================" -ForegroundColor Cyan
Write-Host "TESTES KYC - TudoAqui Backend" -ForegroundColor Yellow
Write-Host "============================================================" -ForegroundColor Cyan
Write-Host ""

# 1. REGISTAR UTILIZADOR
Write-Host "[1/4] Registando utilizador..." -ForegroundColor Yellow

$registerBody = @{
    email = 'teste.kyc@tudoaqui.ao'
    senha = 'Senha123!'
    nome = 'Teste KYC'
    telefone = '+244923456789'
    tipo = 'vendedor'
} | ConvertTo-Json

try {
    $registerResponse = Invoke-RestMethod -Uri 'http://localhost:3000/api/v1/auth/register' -Method POST -ContentType 'application/json' -Body $registerBody
    
    Write-Host "Utilizador criado!" -ForegroundColor Green
    Write-Host "User ID: $($registerResponse.id)"
    Write-Host "Email: $($registerResponse.email)"
    Write-Host "Token: $($registerResponse.access_token.Substring(0,50))..."
    Write-Host ""

    $global:userId = $registerResponse.id
    $global:token = $registerResponse.access_token

} catch {
    Write-Host "Erro: $($_.Exception.Message)" -ForegroundColor Red
    if ($_.ErrorDetails.Message) {
        Write-Host "Detalhes: $($_.ErrorDetails.Message)" -ForegroundColor Red
    }
    exit 1
}

Write-Host "============================================================" -ForegroundColor Cyan
Write-Host ""

# 2. STATUS INICIAL
Write-Host "[2/4] Verificando status inicial..." -ForegroundColor Yellow

$headers = @{
    Authorization = "Bearer $global:token"
}

try {
    $statusResponse = Invoke-RestMethod -Uri "http://localhost:3000/api/v1/kyc/status/$global:userId" -Method GET -Headers $headers
    
    Write-Host "STATUS KYC:" -ForegroundColor Cyan
    Write-Host "  kycStatus: $($statusResponse.kycStatus)"
    Write-Host "  seloVerificado: $($statusResponse.seloVerificado)"
    Write-Host "  biNumero: $($statusResponse.biNumero)"
    Write-Host ""

} catch {
    Write-Host "Erro: $($_.Exception.Message)" -ForegroundColor Red
}

Write-Host "============================================================" -ForegroundColor Cyan
Write-Host ""
Write-Host "Testes 1-2 concluidos!" -ForegroundColor Green
Write-Host "User ID salvo: $global:userId" -ForegroundColor Gray
Write-Host ""
Write-Host "Para continuar (uploads 3-4), use o token acima" -ForegroundColor Yellow
