#!/usr/bin/env python3
import requests
import json
import base64
from PIL import Image
import io

BASE_URL = "http://localhost:3000/api/v1"

# 1. REGISTAR UTILIZADOR
print("=" * 60)
print("1️⃣ REGISTAR UTILIZADOR")
print("=" * 60)

register_data = {
    "email": "teste@tudoaqui.ao",
    "senha": "Senha123!",
    "nome": "Teste Utilizador",
    "telefone": "+244912345678",
    "tipo": "vendedor"
}

response = requests.post(f"{BASE_URL}/auth/register", json=register_data)
print(f"Status: {response.status_code}")
print(f"Response: {response.text}")

register_response = response.json() if response.status_code == 201 else None
if register_response:
    user_id = register_response.get("id") or register_response.get("userId")
    token = register_response.get("access_token")
    print(f"\n✅ Utilizador criado!")
    print(f"User ID: {user_id}")
    print(f"Token: {token[:50]}..." if token else "No token")
else:
    print(f"❌ Erro ao registar")
    exit(1)

print("\n" + "=" * 60)
print("2️⃣ CRIAR IMAGEM DE TESTE")
print("=" * 60)

# Criar imagem simples para teste
img = Image.new('RGB', (200, 100), color='blue')
img_bytes = io.BytesIO()
img.save(img_bytes, format='PNG')
img_bytes.seek(0)

print("✅ Imagem de teste criada (200x100 px)")

print("\n" + "=" * 60)
print("3️⃣ UPLOAD BI")
print("=" * 60)

files = {'file': ('test_bi.png', img_bytes, 'image/png')}
headers = {'Authorization': f'Bearer {token}'} if token else {}
response = requests.post(f"{BASE_URL}/kyc/upload-bi", files=files, headers=headers)
print(f"Status: {response.status_code}")
print(f"Response: {response.text}")

print("\n" + "=" * 60)
print("4️⃣ UPLOAD SELFIE")
print("=" * 60)

img_bytes.seek(0)
files = {'file': ('test_selfie.png', img_bytes, 'image/png')}
response = requests.post(f"{BASE_URL}/kyc/upload-selfie", files=files, headers=headers)
print(f"Status: {response.status_code}")
print(f"Response: {response.text}")

print("\n" + "=" * 60)
print("5️⃣ ANALISAR (REKOGNITION MOCK)")
print("=" * 60)

analyze_data = {"userId": user_id}
response = requests.post(f"{BASE_URL}/kyc/analyze", json=analyze_data, headers=headers)
print(f"Status: {response.status_code}")
print(f"Response: {response.text}")

print("\n" + "=" * 60)
print("6️⃣ VERIFICAR STATUS KYC")
print("=" * 60)

response = requests.get(f"{BASE_URL}/kyc/status/{user_id}", headers=headers)
print(f"Status: {response.status_code}")
print(f"Response: {response.text}")
if response.status_code == 200:
    status = response.json()
    print(f"\n📊 STATUS KYC:")
    print(f"  kycStatus: {status.get('kycStatus', 'N/A')}")
    print(f"  seloVerificado: {status.get('seloVerificado', False)}")
    print(f"  biNumero: {status.get('biNumero', 'N/A')}")
