// Teste ultra-simples para forçar erro e ver logs detalhados
const http = require('http');

const postData = JSON.stringify({
  email: `teste${Date.now()}@tudoaqui.ao`,
  senha: 'Senha123!',
  nome: 'Teste',
  telefone: `+244${Date.now().toString().substr(-9)}`,
  tipo: 'vendedor'
});

console.log('Enviando requisição...\n');

const req = http.request({
  hostname: 'localhost',
  port: 3000,
  path: '/api/v1/auth/register',
  method: 'POST',
  headers: {
    'Content-Type': 'application/json',
    'Content-Length': Buffer.byteLength(postData)
  }
}, (res) => {
  console.log(`Status: ${res.statusCode}`);
  console.log(`Headers: ${JSON.stringify(res.headers, null, 2)}\n`);
  
  let data = '';
  res.on('data', (chunk) => { data += chunk; });
  res.on('end', () => {
    console.log('Response Body:');
    try {
      console.log(JSON.stringify(JSON.parse(data), null, 2));
    } catch (e) {
      console.log(data);
    }
  });
});

req.on('error', (e) => {
  console.error(`Erro: ${e.message}`);
});

req.write(postData);
req.end();
