# Script de Teste - KYC Flutter + Backend Integration
# TudoAqui - Verificação Completa

Write-Host "`n========================================" -ForegroundColor Cyan
Write-Host "  TudoAqui - KYC Integration Test" -ForegroundColor Cyan
Write-Host "========================================`n" -ForegroundColor Cyan

# Configurações
$BASE_URL = "http://localhost:3000"
$TEST_USER = @{
    nome = "João Silva"
    email = "joao@test.tudoaqui.ao"
    telefone = "+244923123456"
    senha = "TestPass123!"
    isEmpresa = $false
}

# 1. Teste de Conectividade
Write-Host "[1/4] Testando conectividade com backend..." -ForegroundColor Yellow
try {
    $response = Invoke-WebRequest -Uri "$BASE_URL/health" -Method GET -ErrorAction Stop
    Write-Host "✓ Backend disponível" -ForegroundColor Green
} catch {
    Write-Host "✗ Erro: Backend não está a responder em $BASE_URL" -ForegroundColor Red
    Write-Host "  Certifique-se que executou: npm run start:dev na pasta backend/" -ForegroundColor Gray
    exit 1
}

# 2. Teste de Registro
Write-Host "`n[2/4] Testando registro de utilizador..." -ForegroundColor Yellow
try {
    $registerBody = $TEST_USER | ConvertTo-Json
    $response = Invoke-WebRequest -Uri "$BASE_URL/auth/register" `
        -Method POST `
        -ContentType "application/json" `
        -Body $registerBody `
        -ErrorAction Stop
    
    $data = $response.Content | ConvertFrom-Json
    $userId = $data.userId
    $token = $data.token
    
    Write-Host "✓ Utilizador registado com sucesso" -ForegroundColor Green
    Write-Host "  UserId: $userId" -ForegroundColor Gray
    Write-Host "  Token: $($token.Substring(0, 20))..." -ForegroundColor Gray
} catch {
    Write-Host "✗ Erro ao registar utilizador:" -ForegroundColor Red
    Write-Host "  $($_.Exception.Message)" -ForegroundColor Gray
    exit 1
}

# 3. Teste de Consulta de Status KYC
Write-Host "`n[3/4] Testando consulta de status KYC..." -ForegroundColor Yellow
try {
    $response = Invoke-WebRequest -Uri "$BASE_URL/kyc/status?userId=$userId" `
        -Method GET `
        -Headers @{"Authorization" = "Bearer $token"} `
        -ErrorAction Stop
    
    $kycData = $response.Content | ConvertFrom-Json
    Write-Host "✓ Status KYC obtido com sucesso" -ForegroundColor Green
    Write-Host "  Status: $($kycData.status)" -ForegroundColor Gray
    Write-Host "  Verificado: $($kycData.seloVerificado)" -ForegroundColor Gray
} catch {
    Write-Host "✗ Erro ao obter status KYC:" -ForegroundColor Red
    Write-Host "  $($_.Exception.Message)" -ForegroundColor Gray
}

# 4. Teste de Endpoints Marketplace
Write-Host "`n[4/4] Testando endpoints de marketplace..." -ForegroundColor Yellow
try {
    $response = Invoke-WebRequest -Uri "$BASE_URL/anuncios?limit=5" `
        -Method GET `
        -ErrorAction Stop
    
    $listings = $response.Content | ConvertFrom-Json
    Write-Host "✓ Anúncios carregados com sucesso" -ForegroundColor Green
    Write-Host "  Total: $($listings.count)" -ForegroundColor Gray
} catch {
    Write-Host "✗ Erro ao carregar anúncios:" -ForegroundColor Red
    Write-Host "  $($_.Exception.Message)" -ForegroundColor Gray
}

Write-Host "`n========================================" -ForegroundColor Cyan
Write-Host "  ✅ Testes Concluídos!" -ForegroundColor Green
Write-Host "========================================`n" -ForegroundColor Cyan

Write-Host "Próximos passos:" -ForegroundColor Yellow
Write-Host "1. Executar: flutter pub get" -ForegroundColor Gray
Write-Host "2. Testar em dispositivo/emulador: flutter run" -ForegroundColor Gray
Write-Host "3. Navegar até a tela de KYC" -ForegroundColor Gray
Write-Host "4. Capturar fotos e validar uploads`n" -ForegroundColor Gray
