// Teste simples de conexão ao backend TudoAqui
// Executar com: node test_simples.js

const http = require('http');

console.log('===================================');
console.log('Testando Backend TudoAqui');
console.log('===================================\n');

// Passo 1: Testar conexão OPTIONS (CORS)
console.log('[1/3] Testando CORS...');
const optionsReq = http.request({
  hostname: 'localhost',
  port: 3000,
  path: '/api/v1/auth/register',
  method: 'OPTIONS',
  headers: {
    'Origin': 'http://localhost',
    'Access-Control-Request-Method': 'POST'
  }
}, (res) => {
  console.log(`✅ CORS Status: ${res.statusCode}`);
  console.log(`✅ Allow-Origin: ${res.headers['access-control-allow-origin']}`);
  console.log('');
  
  // Passo 2: Registar utilizador
  console.log('[2/3] Registando utilizador...');
  const email = `teste${Date.now()}@tudoaqui.ao`;
  const postData = JSON.stringify({
    email: email,
    senha: 'Senha123!',
    nome: 'Teste Utilizador',
    telefone: '+244923456789',
    tipo: 'vendedor'
  });
  
  const registerReq = http.request({
    hostname: 'localhost',
    port: 3000,
    path: '/api/v1/auth/register',
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'Content-Length': Buffer.byteLength(postData)
    }
  }, (res) => {
    let data = '';
    res.on('data', (chunk) => { data += chunk; });
    res.on('end', () => {
      console.log(`✅ Register Status: ${res.statusCode}`);
      
      if (res.statusCode === 201) {
        const response = JSON.parse(data);
        console.log(`✅ User ID: ${response.id}`);
        console.log(`✅ Email: ${response.email}`);
        console.log(`✅ Token: ${response.access_token.substring(0, 20)}...`);
        console.log('');
        
        // Passo 3: Verificar status KYC
        console.log('[3/3] Verificando status KYC...');
        const statusReq = http.request({
          hostname: 'localhost',
          port: 3000,
          path: `/api/v1/kyc/status/${response.id}`,
          method: 'GET',
          headers: {
            'Authorization': `Bearer ${response.access_token}`
          }
        }, (res) => {
          let kycData = '';
          res.on('data', (chunk) => { kycData += chunk; });
          res.on('end', () => {
            if (res.statusCode === 200) {
              const kyc = JSON.parse(kycData);
              console.log(`✅ KYC Status: ${res.statusCode}`);
              console.log(`✅ kycStatus: ${kyc.kycStatus}`);
              console.log(`✅ seloVerificado: ${kyc.seloVerificado}`);
              console.log('');
              console.log('===================================');
              console.log('✅ TODOS OS TESTES PASSARAM!');
              console.log('===================================');
            } else {
              console.error(`❌ KYC Status Error: ${res.statusCode} - ${kycData}`);
            }
          });
        });
        statusReq.on('error', (e) => {
          console.error(`❌ KYC Request Error: ${e.message}`);
        });
        statusReq.end();
        
      } else {
        console.error(`❌ Register Error: ${data}`);
      }
    });
  });
  
  registerReq.on('error', (e) => {
    console.error(`❌ Register Request Error: ${e.message}`);
  });
  registerReq.write(postData);
  registerReq.end();
});

optionsReq.on('error', (e) => {
  console.error(`❌ CORS Request Error: ${e.message}`);
  console.error('⚠️ Certifique-se que o backend está a funcionar em http://localhost:3000');
  process.exit(1);
});
optionsReq.end();
